# Artifacts Summary - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [MIF Associated concept property](StructureDefinition-ext-mif-assocConceptProp.md) | Concept Properties that are associated with this Code System or Value Set Version |
| [MIF concept relationship inverse name](StructureDefinition-ext-mif-relationship-inverseName.md) | Identifies the name of the relationship that references the inverse of the current relationship. Allows linking a relationship and its derived inverse. |
| [MIF concept relationship is navigable](StructureDefinition-ext-mif-relationship-isNavigable.md) | Indicates whether the relationship is intended to be navigated when selecting a code |
| [MIF concept relationship is reflexivity](StructureDefinition-ext-mif-relationship-reflexivity.md) | Indicates if the association always holds for a concept with itself (refexive), never holds for a concept with itself (irreflexive) |
| [MIF concept relationship kind](StructureDefinition-ext-mif-relationship-relationshipKind.md) | Identifies a type of relationship between codes that is supported by this code system version |
| [MIF concept relationship symmetry](StructureDefinition-ext-mif-relationship-symmetry.md) | Indicates if the relationship always holds in the reverse direction as well (symetric), never holds in the reverse direction as well (antisymetric) |
| [MIF concept relationship transitivity](StructureDefinition-ext-mif-relationship-transitivity.md) | Indicates whether the relationship always (transitive) or never (antitransitive) propagates such that if the association exists from A to B and from B to C that the relationship can be inferred to exist from A to C |
| [NamingSystem title](StructureDefinition-ext-namingsystem-title.md) | The human-readable descriptive name for the code or identifier system |
| [NamingSystem version](StructureDefinition-ext-namingsystem-version.md) | The business version associated with the Naming System |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AMA CPT All Codes](ValueSet-cpt-all.md) | All codes in CPT (including metadata, modifiers, etc). |
| [AMA CPT Base Codes](ValueSet-cpt-base.md) | All codes in CPT that represent procedure codes (no modifiers allowed - e.g. for Claim.item.productOrService). |
| [AMA CPT Modifier Codes](ValueSet-cpt-modifiers.md) | CPT modifiers (e.g. for Claim.item.modifier) |
| [AMA CPT Usable Codes](ValueSet-cpt-usable.md) | All CPT codes (no modifiers) that represent procedure codes (e.g. for Procedure.code). |
| [Abenakian](ValueSet-v3-Abenakian.md) | ****No description**** |
| [Accepting Patients](ValueSet-accepting-patients.md) | This value set defines a set of codes that can be used to indicate a practice is accepting new patients. |
| [AccessMedicalDevice](ValueSet-v3-AccessMedicalDevice.md) | A device used to allow access to a part of a body |
| [AcknowledgementCondition](ValueSet-v3-AcknowledgementCondition.md) | Acknowledgement Condition codes describe the conditions under which accept or application level acknowledgements are required to be returned in response to the message send operation. |
| [AcknowledgementDetailCode](ValueSet-v3-AcknowledgementDetailCode.md) | A site specific problem code |
| [AcknowledgementDetailNotSupportedCode](ValueSet-v3-AcknowledgementDetailNotSupportedCode.md) | Refelects rejections because elements of the communication are not supported in the current context. |
| [AcknowledgementDetailSyntaxErrorCode](ValueSet-v3-AcknowledgementDetailSyntaxErrorCode.md) | Reflects errors in the syntax or structure of the communication. |
| [AcknowledgementDetailType](ValueSet-v3-AcknowledgementDetailType.md) | A code identifying the specific message to be provided. A textual value may be specified as the print name, or for non-coded messages, as the original text.**Discussion:**'Required attribute xxx is missing', 'System will be unavailable March 19 from 0100 to 0300'**Examples:** |
| [AcknowledgementType](ValueSet-v3-AcknowledgementType.md) | Acknowledgement code as described in HL7 message processing rules. |
| [Act Procedure Code CCI](ValueSet-v3-ActProcedureCodeCCI.md) | **** MISSING DESCRIPTION **** |
| [ActAccommodationReason](ValueSet-v3-ActAccommodationReason.md) | Identifies the reason the patient is assigned to this accommodation type |
| [ActAccountCode](ValueSet-v3-ActAccountCode.md) | An account represents a grouping of financial transactions that are tracked and reported together with a single balance. Examples of account codes (types) are Patient billing accounts (collection of charges), Cost centers; Cash. |
| [ActAdjudicationCode](ValueSet-v3-ActAdjudicationCode.md) | Includes coded responses that will occur as a result of the adjudication of an electronic invoice at a summary level and provides guidance on interpretation of the referenced adjudication results. |
| [ActAdjudicationGroupCode](ValueSet-v3-ActAdjudicationGroupCode.md) | Catagorization of grouping criteria for the associated transactions and/or summary (totals, subtotals). |
| [ActAdjudicationResultActionCode](ValueSet-v3-ActAdjudicationResultActionCode.md) | Actions to be carried out by the recipient of the Adjudication Result information. |
| [ActAdministrativeAuthorizationDetectedIssueCode](ValueSet-v3-ActAdministrativeAuthorizationDetectedIssueCode.md) | ****No description**** |
| [ActAdministrativeDetectedIssueCode](ValueSet-v3-ActAdministrativeDetectedIssueCode.md) | Identifies types of detectyed issues for Act class "ALRT" for the administrative and patient administrative acts domains. |
| [ActAdministrativeDetectedIssueManagementCode](ValueSet-v3-ActAdministrativeDetectedIssueManagementCode.md) | Codes dealing with the management of Detected Issue observations for the administrative and patient administrative acts domains. |
| [ActAdministrativeRuleDetectedIssueCode](ValueSet-v3-ActAdministrativeRuleDetectedIssueCode.md) | ****No description**** |
| [ActAmbulatoryEncounterCode](ValueSet-v3-ActAmbulatoryEncounterCode.md) | **Definition:**A comprehensive term for health care provided in a healthcare facility (e.g. a practitioneraTMs office, clinic setting, or hospital) on a nonresident basis. The term ambulatory usually implies that the patient has come to the location and is not assigned to a bed. Sometimes referred to as an outpatient encounter. |
| [ActAntigenInvalidReason](ValueSet-v3-ActAntigenInvalidReason.md) | **Description:**Coded reasons why an antigen is considered invalid. |
| [ActBillableModifierCode](ValueSet-v3-ActBillableModifierCode.md) | **Definition:**An identifying modifier code for healthcare interventions or procedures. |
| [ActBillingArrangementCode](ValueSet-v3-ActBillingArrangementCode.md) | The type of provision(s) made for reimbursing for the deliver of healthcare services and/or goods provided by a Provider, over a specified period. |
| [ActBoundedROICode](ValueSet-v3-ActBoundedROICode.md) | Type of bounded ROI. |
| [ActCareProvisionCode](ValueSet-v3-ActCareProvisionCode.md) | **Description:**The type and scope of responsibility taken-on by the performer of the Act for a specific subject of care. |
| [ActClaimAttachmentCategoryCode](ValueSet-v3-ActClaimAttachmentCategoryCode.md) | ****No description**** |
| [ActClass](ValueSet-v3-ActClass.md) | A code specifying the major type of Act that this Act-instance represents.**Constraints:**The classCode domain is a tightly controlled vocabulary, not an external or user-defined vocabulary. Every Act-instance must have a classCode. If the act class is not further specified, the most general Act.classCode (ACT) is used. The Act.classCode must be a generalization of the specific Act concept (e.g., as expressed in Act.code), in other words, the Act concepts conveyed in an Act must be specializations of the Act.classCode. Especially, Act.code is not a "modifier" that can alter the meaning of a class code. (See Act.code for contrast.) |
| [ActClassAccession](ValueSet-v3-ActClassAccession.md) | A unit of work, a grouper of work items as defined by the system performing that work. Typically some laboratory order fulfillers communicate references to accessions in their communications regarding laboratory orders. Often one or more specimens are related to an accession such that in some environments the accession number is taken as an identifier for a specimen (group). |
| [ActClassAccommodation](ValueSet-v3-ActClassAccommodation.md) | An accommodation is a service provided for a Person or other LivingSubject in which a place is provided for the subject to reside for a period of time. Commonly used to track the provision of ward, private and semi-private accommodations for a patient. |
| [ActClassAccount](ValueSet-v3-ActClassAccount.md) | A financial account established to track the net result of financial acts. |
| [ActClassAcquisitionExposure](ValueSet-v3-ActClassAcquisitionExposure.md) | **Description:**An acquisition exposure act describes the proximity (location and time) through which the participating entity was potentially exposed to a physical (including energy), chemical or biological agent from another entity. The acquisition exposure act is used in conjunction with transmission exposure acts as part of an analysis technique for contact tracing. Although an exposure can be decomposed into transmission and acquisition exposures, there is no requirement that all exposures be treated in this fashion.**Constraints:**The Acquisition Exposure inherits the participation constraints that apply to Exposure with the following exception. The EXPSRC (exposure source) participation must never be associated with the Transmission Exposure either directly or via context conduction. |
| [ActClassAction](ValueSet-v3-ActClassAction.md) | Sender asks addressee to do something depending on the focal Act of the payload. An example is "fulfill this order". Addressee has responsibilities to either reject the message or to act on it in an appropriate way (specified by the specific receiver responsibilities for the interaction). |
| [ActClassBattery](ValueSet-v3-ActClassBattery.md) | **Description:**A battery specifies a set of observations. These observations typically have a logical or practical grouping for generally accepted clinical or functional purposes, such as observations that are run together because of automation. A battery can define required and optional components and, in some cases, will define complex rules that determine whether or not a particular observation is made.**Examples:**"Blood pressure", "Full blood count", "Chemistry panel". |
| [ActClassBioSequence](ValueSet-v3-ActClassBioSequence.md) | **Description:**A sequence of biomolecule like the DNA, RNA, protein and the like. |
| [ActClassBioSequenceVariation](ValueSet-v3-ActClassBioSequenceVariation.md) | **Description:**A variation in a sequence as described by BioSequence. |
| [ActClassBoundedRoi](ValueSet-v3-ActClassBoundedRoi.md) | A Region of Interest (ROI) specified for a multidimensional observation, such as an Observation Series (OBSSER). The ROI is specified using a set of observation criteria, each delineating the boundary of the region in one of the dimensions in the multidimensional observation. The relationship between a ROI and its referenced Act is specified through an ActRelationship of type subject (SUBJ), which must always be present. Each of the boundary criteria observations is connected with the ROI using ActRelationships of type "has component" (COMP). In each boundary criterion, the Act.code names the dimension and the Observation.value specifies the range of values inside the region. Typically the bounded dimension is continuous, and so the Observation.value will be an interval (IVL) data type. The Observation.value need not be specified if the respective dimension is only named but not constrained. For example, an ROI for the QT interval of a certain beat in ECG Lead II would contain 2 boundary criteria, one naming the interval in time (constrained), and the other naming the interval in ECG Lead II (only named, but not constrained). |
| [ActClassCareProvision](ValueSet-v3-ActClassCareProvision.md) | An**Act**that of taking on whole or partial responsibility for, or attention to, safety and well-being of a subject of care.**Discussion:**A**care provision**event may exist without any other care actions taking place. For example, when a patient is assigned to the care of a particular health professional. In**request**(RQO) mood**care provision**communicates a referral, which is a request:* from one party (linked as a **participant** of type **author** (AUT)), 
* to another party (linked as a **participant** of type **performer** (PRF), 
* to take responsibility for a scope specified by the code attribute, 
* for an entity (linked as a **participant** of type **subject** (SBJ)). The scope of the care for which responsibility is taken is identified by **code** attribute. In **event** (EVN) mood **care provision** indicates the effective time interval of a specified scope of responsibility by a **performer** (PRF) or set of **performers** (PRF) for a **subject** (SBJ). **Examples:** 
1. Referral from GP to a specialist.
1. Assignment of a patient or group of patients to the case list of a health professional.
1. Assignment of inpatients to the care of particular nurses for a working shift.
 
 |
| [ActClassCategory](ValueSet-v3-ActClassCategory.md) | A group of entries within a composition or topic that have a common characteristic - for example, Examination, Diagnosis, Management OR Subjective, Objective, Analysis, Plan. The distinction from Topic relates to value sets. For Category there is a bounded list of things like "Examination", "Diagnosis" or SOAP categories. For Topic the list is wide open to any clinical condition or reason for a part of an encounter. A CATEGORY MAY CONTAIN ENTRIES. |
| [ActClassCdaLevelOneClinicalDocument](ValueSet-v3-ActClassCdaLevelOneClinicalDocument.md) | A clinical document that conforms to Level One of the HL7 Clinical Document Architecture (CDA) |
| [ActClassClinicalDocument](ValueSet-v3-ActClassClinicalDocument.md) | A clinical document is a documentation of clinical observations and services, with the following characteristics: (1) Persistence - A clinical document continues to exist in an unaltered state, for a time period defined by local and regulatory requirements; (2) Stewardship - A clinical document is maintained by a person or organization entrusted with its care; (3) Potential for authentication - A clinical document is an assemblage of information that is intended to be legally authenticated; (4) Wholeness - Authentication of a clinical document applies to the whole and does not apply to portions of the document without the full context of the document; (5) Human readability - A clinical document is human readable." |
| [ActClassClinicalTrial](ValueSet-v3-ActClassClinicalTrial.md) | The set of actions that define an experiment to assess the effectiveness and/or safety of a biopharmaceutical product (food, drug, device, etc.). In definition mood, this set of actions is often embodied in a clinical trial protocol; in event mood, this designates the aggregate act of applying the actions to one or more subjects. |
| [ActClassClinicalTrialTimepointEvent](ValueSet-v3-ActClassClinicalTrialTimepointEvent.md) | An identified point during a clinical trial at which one or more actions are scheduled to be performed (definition mood), or are actually performed (event mood). The actions may or may not involve an encounter between the subject and a healthcare professional. |
| [ActClassCluster](ValueSet-v3-ActClassCluster.md) | A group of entries within a composition, topic or category that have a logical association with one another. The representation of a single observation or action might itself be multi-part. The data might need to be represented as a nested set of values, as a table, list, or as a time series. The Cluster class permits such aggregation within an entry for such compound data. Examples include "Haematology investigations" which might include two or more distinct batteries. A cluster may contain batteries and/or individual entries |
| [ActClassCompositeOrder](ValueSet-v3-ActClassCompositeOrder.md) | ****No description**** |
| [ActClassComposition](ValueSet-v3-ActClassComposition.md) | A context representing a grouped commitment of information to the EHR. It is considered the unit of modification of the record, the unit of transmission in record extracts, and the unit of attestation by authorizing clinicians. A composition represents part of a patient record originating from a single interaction between an authenticator and the record. Unless otherwise stated all statements within a composition have the same authenticator, apply to the same patient and were recorded in a single session of use of a single application. A composition contains organizers and entries. |
| [ActClassConcern](ValueSet-v3-ActClassConcern.md) | ****No description**** |
| [ActClassCondition](ValueSet-v3-ActClassCondition.md) | An observable finding or state that persists over time and tends to require intervention or management, and, therefore, distinguished from an Observation made at a point in time; may exist before an Observation of the Condition is made or after interventions to manage the Condition are undertaken. Examples: equipment repair status, device recall status, a health risk, a financial risk, public health risk, pregnancy, health maintenance, chronic illness |
| [ActClassConditionNode](ValueSet-v3-ActClassConditionNode.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassConsent](ValueSet-v3-ActClassConsent.md) | The Consent class represents informed consents and all similar medico-legal transactions between the patient (or his legal guardian) and the provider. Examples are informed consent for surgical procedures, informed consent for clinical trials, advanced beneficiary notice, against medical advice decline from service, release of information agreement, etc. The details of consents vary. Often an institution has a number of different consent forms for various purposes, including reminding the physician about the topics to mention. Such forms also include patient education material. In electronic medical record communication, consents thus are information-generating acts on their own and need to be managed similar to medical activities. Thus, Consent is modeled as a special class of Act. The "signatures" to the consent document are represented electronically through Participation instances to the consent object. Typically an informed consent has Participation.typeCode of "performer", the healthcare provider informing the patient, and "consenter", the patient or legal guardian. Some consent may associate a witness or a notary public (e.g., living wills, advanced directives). In consents where a healthcare provider is not required (e.g. living will), the performer may be the patient himself or a notary public. Some consent has a minimum required delay between the consent and the service, so as to allow the patient to rethink his decisions. This minimum delay can be expressed in the act definition by the ActRelationship.pauseQuantity attribute that delays the service until the pause time has elapsed after the consent has been completed. |
| [ActClassContainer](ValueSet-v3-ActClassContainer.md) | Used to group a set of acts sharing a common context. Container structures can nest within other context structures - such as where a document is contained within a folder, or a folder is contained within an EHR extract.**Open issue:**There is a clear conflict between this act and the use of the more general "component" ActRelationship. The question that must be resolved is what should be the class code of the parent (or containing) Act. |
| [ActClassContainerRegistration](ValueSet-v3-ActClassContainerRegistration.md) | An Act where a container is registered either via an automated sensor, such as a barcode reader, or by manual receipt |
| [ActClassContract](ValueSet-v3-ActClassContract.md) | An agreement of obligation between two or more parties that is subject to contractual law and enforcement. |
| [ActClassControlAct](ValueSet-v3-ActClassControlAct.md) | An act representing a system action such as the change of state of another act or the initiation of a query. All control acts represent trigger events in the HL7 context. ControlActs may occur in different moods. |
| [ActClassCorrelatedObservationSequences](ValueSet-v3-ActClassCorrelatedObservationSequences.md) | Container for Observation Sequences (Observations whose values are contained in LIST<>'s) having values correlated with each other. Each contained Observation Sequence LIST<> must be the same length. Values in the LIST<>'s are correlated based on index. E.g. the values in position 2 in all the LIST<>'s are correlated. This is analogous to a table where each column is an Observation Sequence with a LIST<> of values, and each row in the table is a correlation between the columns. For example, a 12-lead ECG would contain 13 sequences: one sequence for time, and a sequence for each of the 12 leads. |
| [ActClassCoverage](ValueSet-v3-ActClassCoverage.md) | When used in the EVN mood, this concept means with respect to a covered party:1. A health care insurance policy or plan that is contractually binding between two or more parties; or
1. A health care program, usually administered by government entities, that provides coverage to persons determined eligible under the terms of the program.
* When used in the definition (DEF) mood, COV means potential coverage for a patient who may or may not be a covered party. 
* The concept's meaning is fully specified by the choice of ActCoverageTypeCode (abstract) ActProgramCode or ActInsurancePolicyCode.

 |
| [ActClassDetectedIssue](ValueSet-v3-ActClassDetectedIssue.md) | An observation identifying a potential adverse outcome as a result of an Act or combination of Acts.**Examples:**Detection of a drug-drug interaction; Identification of a late-submission for an invoice; Requesting discharge for a patient who does not meet hospital-defined discharge criteria.**Discussion:**This class is commonly used for identifying 'business rule' or 'process' problems that may result in a refusal to carry out a particular request. In some circumstances it may be possible to 'bypass' a problem by modifying the request to acknowledge the issue and/or by providing some form of mitigation.**Constraints:**the Act or Acts that may cause the the adverse outcome are the target of a subject ActRelationship. The subbtypes of this concept indicate the type of problem being detected (e.g. drug-drug interaction) while the Observation.value is used to repesent a specific problem code (e.g. specific drug-drug interaction id). |
| [ActClassDeterminantPeptide](ValueSet-v3-ActClassDeterminantPeptide.md) | **Description:**A determinant peptide in a polypeptide as described by polypeptide. |
| [ActClassDiagnosticImage](ValueSet-v3-ActClassDiagnosticImage.md) | Class for holding attributes unique to diagnostic images. |
| [ActClassDiet](ValueSet-v3-ActClassDiet.md) | ****No description**** |
| [ActClassDisciplinaryAction](ValueSet-v3-ActClassDisciplinaryAction.md) | An action taken with respect to a subject Entity by a regulatory or authoritative body with supervisory capacity over that entity. The action is taken in response to behavior by the subject Entity that body finds to be undesirable. Suspension, license restrictions, monetary fine, letter of reprimand, mandated training, mandated supervision, etc.**Examples:** |
| [ActClassDocument](ValueSet-v3-ActClassDocument.md) | Specialization of Act to add the characteristics unique to document management services. |
| [ActClassDocumentBody](ValueSet-v3-ActClassDocumentBody.md) | A context that distinguishes the body of a document from the document header. This is seen, for instance, in HTML documents, which have discrete <head> and <body> elements. |
| [ActClassDocumentSection](ValueSet-v3-ActClassDocumentSection.md) | A context that subdivides the body of a document. Document sections are typically used for human navigation, to give a reader a clue as to the expected content. Document sections are used to organize and provide consistency to the contents of a document body. Document sections can contain document sections and can contain entries. |
| [ActClassElectronicHealthRecord](ValueSet-v3-ActClassElectronicHealthRecord.md) | A context that comprises all compositions. The EHR is an extract that includes the entire chart.**NOTE:**In an exchange scenario, an EHR is a specialization of an extract. |
| [ActClassEncounter](ValueSet-v3-ActClassEncounter.md) | An interaction between a patient and healthcare participant(s) for the purpose of providing patient service(s) or assessing the health status of a patient. For example, outpatient visit to multiple departments, home health support (including physical therapy), inpatient hospital stay, emergency room visit, field visit (e.g., traffic accident), office visit, occupational therapy, telephone call. |
| [ActClassExposure](ValueSet-v3-ActClassExposure.md) | The action of coming into sufficient physical proximity to allow physical or chemical interaction. Examples include: exposure to radiation, inhalation of peanut aerosol or viral particles. This includes intended exposure (e.g. administering a drug product) as well as accidental or environmental exposure. Actual vs. potential exposure can be differentiated using Act.uncertaintyCode. The agent to which the subject was exposed is conveyed as a**Direct**participation or specialization there-of.**Constraints:**The following Participations should be used with the following Roles and Entities to distinguish the specific entities:* The ****exposed entity**** is the entity of interest that is the recipient of the exposure and potentially affected. This is conveyed through the subject (SBJ) Participation. 
* An entity that has carried the agent transmitted in the exposure is the "****exposure source****" (EXSRC). For example: 
* a person or animal who carried an infectious disease and interacts (EXSRC) with another person or animal (SBJ) transmitting the disease agent; or 
* a place or other environment (EXSRC) and a person or animal (SBJ) who is exposed in the presence of this environment. 
 
* When it is unknown whether a participating entity is the source of the agent (EXSRC) or the target of the transmission (SBJ), also known as "****exposure contact****", the "participant" (PART) is used. 
* The substance to which the subject is exposed that carries the exposure agent or the chemical substance of interest itself, participates as a "consumable" (CSM). There are at least two configurations: (a) the player of the Role that participates as CSM is the chemical or biological substance mixed or carried by the scoper-entity of the Role (e.g., ingredient role); or (b) the player of the Role that participates as CSM is a mixture known to contain the chemical, radiological or biological substance of interest. 
* The device specifically used to administer the substance is associated using the device (DEV) Participation. This may be a device intentionally used (such as applicator device) or it may be a thing that accidentally carried this substance; for instance, an infected needle or knife. The same entity may be related in the act as both EXSRC and DEV.
 |
| [ActClassExpressionLevel](ValueSet-v3-ActClassExpressionLevel.md) | **Description:**An expression level of genes/proteins or other expressed genomic entities. |
| [ActClassExtract](ValueSet-v3-ActClassExtract.md) | This context represents the part of a patient record conveyed in a single communication. It is drawn from a providing system for the purposes of communication to a requesting process (which might be another repository, a client application or a middleware service such as an electronic guideline engine), and supporting the faithful inclusion of the communicated data in the receiving system. An extract may be the entirety of the patient record as held by the sender or it may be a part of that record (e.g. changes since a specified date). An extract contains folders or compositions. An extract cannot contain another extract. |
| [ActClassFinancialAdjudication](ValueSet-v3-ActClassFinancialAdjudication.md) | A transformation process where a requested invoice is transformed into an agreed invoice. Represents the adjudication processing of an invoice (claim). Adjudication results can be adjudicated as submitted, with adjustments or refused. Adjudication results comprise 2 components: the adjudication processing results and a restated (or adjudicated) invoice or claim |
| [ActClassFinancialContract](ValueSet-v3-ActClassFinancialContract.md) | A contract whose value is measured in monetary terms. |
| [ActClassFinancialTransaction](ValueSet-v3-ActClassFinancialTransaction.md) | A sub-class of Act representing any transaction between two accounts whose value is measured in monetary terms. In the "intent" mood, communicates a request for a transaction to be initiated, or communicates a transfer of value between two accounts. In the "event" mood, communicates the posting of a transaction to an account. |
| [ActClassFolder](ValueSet-v3-ActClassFolder.md) | ****No description**** |
| [ActClassGenomicObservation](ValueSet-v3-ActClassGenomicObservation.md) | **Description:**An observation of genomic phenomena. |
| [ActClassGrouper](ValueSet-v3-ActClassGrouper.md) | ****No description**** |
| [ActClassIncident](ValueSet-v3-ActClassIncident.md) | An event that occurred outside of the control of one or more of the parties involved. Includes the concept of an accident. |
| [ActClassInform](ValueSet-v3-ActClassInform.md) | The act of transmitting information and understanding about a topic to a subject where the participation association must be SBJ.**Discussion:**This act may be used to request that a patient or provider be informed about an Act, or to indicate that a person was informed about a particular act. |
| [ActClassInformation](ValueSet-v3-ActClassInformation.md) | Sender sends payload to addressee as information. Addressee does not have responsibilities beyond serving addressee's own interest (i.e., read and memorize if you see fit). This is equivalent to an FYI on a memo. |
| [ActClassInvestigation](ValueSet-v3-ActClassInvestigation.md) | An formalized inquiry into the circumstances surrounding a particular unplanned event or potential event for the purposes of identifying possible causes and contributing factors for the event. This investigation could be conducted at a local institutional level or at the level of a local or national government. |
| [ActClassInvoiceElement](ValueSet-v3-ActClassInvoiceElement.md) | Represents concepts related to invoice processing in health care |
| [ActClassJurisdictionalPolicy](ValueSet-v3-ActClassJurisdictionalPolicy.md) | **Description:**A mandate, regulation, obligation, requirement, rule, or expectation unilaterally imposed by a jurisdiction on:* The activity of another party 
* The behavior of another party 
* The manner in which an act is executed **Examples:**A jurisdictional mandate regarding the prescribing and dispensing of a particular medication. A jurisdictional privacy or security regulation dictating the manner in which personal health information is disclosed. A jurisdictional requirement that certain services or health conditions are reported to a monitoring program, e.g., immunizations, methadone treatment, or cancer registries.
 |
| [ActClassLeftLateralDecubitus](ValueSet-v3-ActClassLeftLateralDecubitus.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassLocus](ValueSet-v3-ActClassLocus.md) | **Description:**The position of a gene (or other significant sequence) on the genome. |
| [ActClassMonitoringProgram](ValueSet-v3-ActClassMonitoringProgram.md) | An officially or unofficially instituted program to track acts of a particular type or categorization. |
| [ActClassObservation](ValueSet-v3-ActClassObservation.md) | **Description:**An act that is intended to result in new information about a subject. The main difference between Observations and other Acts is that Observations have a value attribute. The**code**attribute of Observation and the**value**attribute of Observation must be considered in combination to determine the semantics of the observation.**Discussion:**Structurally, many observations are name-value-pairs, where the Observation.code (inherited from Act) is the name and the Observation.value is the value of the property. Such a construct is also known as a variable (a named feature that can assume a value) hence, the Observation class is always used to hold generic name-value-pairs or variables, even though the variable valuation may not be the result of an elaborate observation method. It may be a simple answer to a question or it may be an assertion or setting of a parameter. As with all Act statements, Observation statements describe what was done, and in the case of Observations, this includes a description of what was actually observed (results or answers); and those results or answers are part of the observation and not split off into other objects. The method of action is asserted by the Observation classCode or its subclasses at the least granular level, by the Observation.code attribute value at the medium level of granularity, and by the attribute value of observation.methodCode when a finer level of granularity is required. The method in whole or in part may also appear in the attribute value of Observation.value when using coded data types to express the value of the attribute. Relevant aspects of methodology may also be restated in value when the results themselves imply or state a methodology. An observation may consist of component observations each having their own Observation.code and Observation.value. In this case, the composite observation may not have an Observation.value for itself. For instance, a white blood cell count consists of the sub-observations for the counts of the various granulocytes, lymphocytes and other normal or abnormal blood cells (e.g., blasts). The overall white blood cell count Observation itself may therefore not have a value by itself (even though it could have one, e.g., the sum total of white blood cells). Thus, as long as an Act is essentially an Act of recognizing and noting information about a subject, it is an Observation, regardless of whether it has a simple value by itself or whether it has sub-observations. Even though observations are professional acts (see Act) and as such are intentional actions, this does not require that every possible outcome of an observation be pondered in advance of it being actually made. For instance, differential white blood cell counts (WBC) rarely show blasts, but if they do, this is part of the WBC observation even though blasts might not be predefined in the structure of a normal WBC. Clinical documents commonly have Subjective and Objective findings, both of which are kinds of Observations. In addition, clinical documents commonly contain Assessments, which are also kinds of Observations. Thus, the establishment of a diagnosis is an Observation.**Examples:*** Recording the results of a Family History Assessment 
* Laboratory test and associated result 
* Physical exam test and associated result 
* Device temperature 
* Soil lead level
 |
| [ActClassObservationSeries](ValueSet-v3-ActClassObservationSeries.md) | Container for Correlated Observation Sequences sharing a common frame of reference. All Observations of the same cd must be comparable and relative to the common frame of reference. For example, a 3-channel ECG device records a 12-lead ECG in 4 steps (3 leads at a time). Each of the separate 3-channel recordings would be in their own "OBSCOR". And, all 4 OBSCOR would be contained in one OBSSER because all the times are relative to the same origin (beginning of the recording) and all the ECG signals were from a fixed set of electrodes. |
| [ActClassOrganizationalPolicy](ValueSet-v3-ActClassOrganizationalPolicy.md) | **Description:**A mandate, obligation, requirement, rule, or expectation unilaterally imposed by an organization on:* The activity of another party 
* The behavior of another party 
* The manner in which an act is executed **Examples:**A clinical or research protocols imposed by a payer, a malpractice insurer, or an institution to which a provider must adhere. A mandate imposed by a denominational institution for a provider to provide or withhold certain information from the patient about treatment options.
 |
| [ActClassOutbreak](ValueSet-v3-ActClassOutbreak.md) | An outbreak represents a series of public health cases. The date on which an outbreak starts is the earliest date of onset among the cases assigned to the outbreak, and its ending date is the last date of onset among the cases assigned to the outbreak. |
| [ActClassOutbreak2](ValueSet-v3-ActClassOutbreak2.md) | An Outbreak is a concern resulting from a series of public health cases. |
| [ActClassOverlayRoi](ValueSet-v3-ActClassOverlayRoi.md) | A Region of Interest (ROI) specified for an image using an overlay shape. Typically used to make reference to specific regions in images, e.g., to specify the location of a radiologic finding in an image or to specify the site of a physical finding by "circling" a region in a schematic picture of a human body. The units of the coordinate values are in pixels. The origin is in the upper left hand corner, with positive X values going to the right and positive Y values going down. The relationship between a ROI and its referenced Act is specified through an ActRelationship of type "subject" (SUBJ), which must always be present. |
| [ActClassPhenotype](ValueSet-v3-ActClassPhenotype.md) | **Description:**A genomic phenomenon that is expressed externally in the organism. |
| [ActClassPolicy](ValueSet-v3-ActClassPolicy.md) | **Description:**A mandate, regulation, obligation, requirement, rule, or expectation unilaterally imposed by one party on:* The activity of another party 
* The behavior of another party 
* The manner in which an act is executed
 |
| [ActClassPolypeptide](ValueSet-v3-ActClassPolypeptide.md) | **Description:**A polypeptide resulting from the translation of a gene. |
| [ActClassPosition](ValueSet-v3-ActClassPosition.md) | An observation denoting the physical location of a person or thing based on a reference coordinate system. |
| [ActClassPositionAccuracy](ValueSet-v3-ActClassPositionAccuracy.md) | **Description:**An observation representing the degree to which the assignment of the spatial coordinates, based on a matching algorithm by a geocoding engine against a reference spatial database, matches true or accepted values. |
| [ActClassPositionCoordinate](ValueSet-v3-ActClassPositionCoordinate.md) | **Description:**An observation representing one of a set of numerical values used to determine the position of a place. The name of the coordinate value is determined by the reference coordinate system. |
| [ActClassProcedure](ValueSet-v3-ActClassProcedure.md) | An Act whose immediate and primary outcome (post-condition) is the alteration of the physical condition of the subject.**Examples:**: Procedures may involve the disruption of some body surface (e.g. an incision in a surgical procedure), but they also include conservative procedures such as reduction of a luxated join, chiropractic treatment, massage, balneotherapy, acupuncture, shiatsu, etc. Outside of clinical medicine, procedures may be such things as alteration of environments (e.g. straightening rivers, draining swamps, building dams) or the repair or change of machinery etc. |
| [ActClassProcessStep](ValueSet-v3-ActClassProcessStep.md) | **ActCodeProcessStep**- Property applies to value sets that contain classCode values in structural vocabularies. It identifies by name the Concept Domain(s) that represent(s) the concepts that are sub-types of the concept collection established by the value sets of class codes. |
| [ActClassProne](ValueSet-v3-ActClassProne.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassPublicHealthCase](ValueSet-v3-ActClassPublicHealthCase.md) | A public health case is an Observation representing a condition or event that has a specific significance for public health. Typically it involves an instance or instances of a reportable infectious disease or other condition. The public health case can include a health-related event concerning a single individual or it may refer to multiple health-related events that are occurrences of the same disease or condition of interest to public health. An outbreak involving multiple individuals may be considered as a type of public health case. A public health case definition (Act.moodCode = "definition") includes the description of the clinical, laboratory, and epidemiologic indicators associated with a disease or condition of interest to public health. There are case definitions for conditions that are reportable, as well as for those that are not. There are also case definitions for outbreaks. A public health case definition is a construct used by public health for the purpose of counting cases, and should not be used as clinical indications for treatment. Examples include AIDS, toxic-shock syndrome, and salmonellosis and their associated indicators that are used to define a case. |
| [ActClassPublicHealthCase2](ValueSet-v3-ActClassPublicHealthCase2.md) | A public health case is a Concern about an observation or event that has a specific significance for public health. The creation of a PublicHealthCase initiates the tracking of the object of concern. The decision to track is related to but somewhat independent of the underlying event or observation. |
| [ActClassROI](ValueSet-v3-ActClassROI.md) | Regions of Interest (ROI) within a subject Act. Primarily used for making secondary observations on a subset of a subject observation. The relationship between a ROI and its referenced Act is specified through an ActRelationship of type "subject" (SUBJ), which must always be present. |
| [ActClassRecordOrganizer](ValueSet-v3-ActClassRecordOrganizer.md) | ****No description**** |
| [ActClassRegistration](ValueSet-v3-ActClassRegistration.md) | Represents the act of maintaining information about the registration of its associated registered subject. The subject can be either an Act or a Role, and includes subjects such as lab exam definitions, drug protocol definitions, prescriptions, persons, patients, practitioners, and equipment. The registration may have a unique identifier - separate from the unique identification of the subject - as well as a core set of related participations and act relationships that characterize the registration event and aid in the disposition of the subject information by a receiving system.**Usage notes:** |
| [ActClassReverseTrendelenburg](ValueSet-v3-ActClassReverseTrendelenburg.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassReview](ValueSet-v3-ActClassReview.md) | The act of examining and evaluating the subject, usually another act. For example, "This prescription needs to be reviewed in 2 months." |
| [ActClassRightLateralDecubitus](ValueSet-v3-ActClassRightLateralDecubitus.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassRoot](ValueSet-v3-ActClassRoot.md) | A record of something that is being done, has been done, can be done, or is intended or requested to be done.**Examples:**The kinds of acts that are common in health care are (1) a clinical observation, (2) an assessment of health condition (such as problems and diagnoses), (3) healthcare goals, (4) treatment services (such as medication, surgery, physical and psychological therapy), (5) assisting, monitoring or attending, (6) training and education services to patients and their next of kin, (7) and notary services (such as advanced directives or living will), (8) editing and maintaining documents, and many others.**Discussion and Rationale:**Acts are the pivot of the RIM; all domain information and processes are represented primarily in Acts. Any profession or business, including healthcare, is primarily constituted of intentional and occasionally non-intentional actions, performed and recorded by responsible actors. An Act-instance is a record of such an action. Acts connect to Entities in their Roles through Participations and connect to other Acts through ActRelationships. Participations are the authors, performers and other responsible parties as well as subjects and beneficiaries (which includes tools and material used in the performance of the act, which are also subjects). The moodCode distinguishes between Acts that are meant as factual records, vs. records of intended or ordered services, and the other modalities in which act can appear. One of the Participations that all acts have (at least implicitly) is a primary author, who is responsible of the Act and who "owns" the act. Responsibility for the act means responsibility for what is being stated in the Act and as what it is stated. Ownership of the act is assumed in the sense of who may operationally modify the same act. Ownership and responsibility of the Act is not the same as ownership or responsibility of what the Act-object refers to in the real world. The same real world activity can be described by two people, each being the author of their Act, describing the same real world activity. Yet one can be a witness while the other can be a principal performer. The performer has responsibilities for the physical actions; the witness only has responsibility for making a true statement to the best of his or her ability. The two Act-instances may even disagree, but because each is properly attributed to its author, such disagreements can exist side by side and left to arbitration by a recipient of these Act-instances. In this sense, an Act-instance represents a "statement" according to Rector and Nowlan (1991) [Foundations for an electronic medical record. Methods Inf Med. 30.] Rector and Nowlan have emphasized the importance of understanding the medical record not as a collection of facts, but "a faithful record of what clinicians have heard, seen, thought, and done." Rector and Nowlan go on saying that "the other requirements for a medical record, e.g., that it be attributable and permanent, follow naturally from this view." Indeed the Act class is this attributable statement, and the rules of updating acts (discussed in the state-transition model, see Act.statusCode) versus generating new Act-instances are designed according to this principle of permanent attributable statements. Rector and Nolan focus on the electronic medical record as a collection of statements, while attributed statements, these are still mostly factual statements. However, the Act class goes beyond this limitation to attributed factual statements, representing what is known as "speech-acts" in linguistics and philosophy. The notion of speech-act includes that there is pragmatic meaning in language utterances, aside from just factual statements; and that these utterances interact with the real world to change the state of affairs, even directly cause physical activities to happen. For example, an order is a speech act that (provided it is issued adequately) will cause the ordered action to be physically performed. The speech act theory has culminated in the seminal work by Austin (1962) [How to do things with words. Oxford University Press]. An activity in the real world may progress from defined, through planned and ordered to executed, which is represented as the mood of the Act. Even though one might think of a single activity as progressing from planned to executed, this progression is reflected by multiple Act-instances, each having one and only one mood that will not change along the Act-instance life cycle. This is because the attribution and content of speech acts along this progression of an activity may be different, and it is often critical that a permanent and faithful record be maintained of this progression. The specification of orders or promises or plans must not be overwritten by the specification of what was actually done, so as to allow comparing actions with their earlier specifications. Act-instances that describe this progression of the same real world activity are linked through the ActRelationships (of the relationship category "sequel"). Act as statements or speech-acts are the only representation of real world facts or processes in the HL7 RIM. The truth about the real world is constructed through a combination (and arbitration) of such attributed statements only, and there is no class in the RIM whose objects represent "objective state of affairs" or "real processes" independent from attributed statements. As such, there is no distinction between an activity and its documentation. Every Act includes both to varying degrees. For example, a factual statement made about recent (but past) activities, authored (and signed) by the performer of such activities, is commonly known as a procedure report or original documentation (e.g., surgical procedure report, clinic note etc.). Conversely, a status update on an activity that is presently in progress, authored by the performer (or a close observer) is considered to capture that activity (and is later superceded by a full procedure report). However, both status update and procedure report are acts of the same kind, only distinguished by mood and state (see statusCode) and completeness of the information. |
| [ActClassScopeOfPracticePolicy](ValueSet-v3-ActClassScopeOfPracticePolicy.md) | **Description:**An ethical or clinical obligation, requirement, rule, or expectation imposed or strongly encouraged by organizations that oversee particular clinical domains or provider certification which define the boundaries within which a provider may practice and which may have legal basis or ramifications on:* The activity of another party 
* The behavior of another party 
* The manner in which an act is executed **Examples:**An ethical obligation for a provider to fully inform a patient about all treatment options. An ethical obligation for a provider not to disclose personal health information that meets certain criteria, e.g., where disclosure might result in harm to the patient or another person. The set of health care services which a provider is credentialed or privileged to provide.
 |
| [ActClassSemiFowlers](ValueSet-v3-ActClassSemiFowlers.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassSitting](ValueSet-v3-ActClassSitting.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassSpecimenCollection](ValueSet-v3-ActClassSpecimenCollection.md) | A procedure for obtaining a specimen from a source entity. |
| [ActClassSpecimenObservation](ValueSet-v3-ActClassSpecimenObservation.md) | An observation on a specimen in a laboratory environment that may affect processing, analysis or result interpretation |
| [ActClassSpecimenTreatment](ValueSet-v3-ActClassSpecimenTreatment.md) | A procedure or treatment performed on a specimen to prepare it for analysis |
| [ActClassStandardOfPracticePolicy](ValueSet-v3-ActClassStandardOfPracticePolicy.md) | **Description:**A requirement, rule, or expectation typically documented as guidelines, protocols, or formularies imposed or strongly encouraged by an organization that oversees or has authority over the practices within a domain, and which may have legal basis or ramifications on:* The activity of another party 
* The behavior of another party 
* The manner in which an act is executed **Examples:**A payer may require a prescribing provider to adhere to formulary guidelines. An institution may adopt clinical guidelines and protocols and implement these within its electronic health record and decision support systems.
 |
| [ActClassStanding](ValueSet-v3-ActClassStanding.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassStateTransitionControl](ValueSet-v3-ActClassStateTransitionControl.md) | Sender transmits a status change pertaining to the focal act of the payload. This status of the focal act is the final state of the state transition. This can be either a request or a command, according to the mood of the control act. |
| [ActClassStorage](ValueSet-v3-ActClassStorage.md) | The act of putting something away for safe keeping. The "something" may be physical object such as a specimen, or information, such as observations regarding a specimen. |
| [ActClassSubjectBodyPosition](ValueSet-v3-ActClassSubjectBodyPosition.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassSubjectPhysicalPosition](ValueSet-v3-ActClassSubjectPhysicalPosition.md) | The spatial relationship of a subject whether human, other animal, or plant, to a frame of reference such as gravity or a collection device. |
| [ActClassSubstanceAdministration](ValueSet-v3-ActClassSubstanceAdministration.md) | The act of introducing or otherwise applying a substance to the subject.**Discussion:**The effect of the substance is typically established on a biochemical basis, however, that is not a requirement. For example, radiotherapy can largely be described in the same way, especially if it is a systemic therapy such as radio-iodine. This class also includes the application of chemical treatments to an area.**Examples:**Chemotherapy protocol; Drug prescription; Vaccination record |
| [ActClassSubstanceExtraction](ValueSet-v3-ActClassSubstanceExtraction.md) | ****No description**** |
| [ActClassSubstitution](ValueSet-v3-ActClassSubstitution.md) | Definition: Indicates that the subject Act has undergone or should undergo substitution of a type indicated by Act.code. Rationale: Used to specify "allowed" substitution when creating orders, "actual" susbstitution when sending events, as well as the reason for the substitution and who was responsible for it. |
| [ActClassSupine](ValueSet-v3-ActClassSupine.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassSupply](ValueSet-v3-ActClassSupply.md) | Supply orders and deliveries are simple Acts that focus on the delivered product. The product is associated with the Supply Act via Participation.typeCode="product". With general Supply Acts, the precise identification of the Material (manufacturer, serial numbers, etc.) is important. Most of the detailed information about the Supply should be represented using the Material class. If delivery needs to be scheduled, tracked, and billed separately, one can associate a Transportation Act with the Supply Act. Pharmacy dispense services are represented as Supply Acts, associated with a SubstanceAdministration Act. The SubstanceAdministration class represents the administration of medication, while dispensing is supply. |
| [ActClassTopic](ValueSet-v3-ActClassTopic.md) | A group of entries within a composition that are related to a common clinical theme - such as a specific disorder or problem, prevention, screening and provision of contraceptive services. A topic may contain categories and entries. |
| [ActClassTransfer](ValueSet-v3-ActClassTransfer.md) | **Definition:**The act of transferring information without the intent of imparting understanding about a topic to the subject that is the recipient or holder of the transferred information where the participation association must be RCV or HLD. |
| [ActClassTransmissionExposure](ValueSet-v3-ActClassTransmissionExposure.md) | **Description:**A transmission exposure act describes the proximity (time and location) over which the participating source entity was capable of transmitting a physical (including energy), chemical or biological substance agent to another entity. The transmission exposure act is used in conjunction with acquisition exposure acts as part of an analysis technique for contact tracing. Although an exposure can be decomposed into transmission and acquisition exposures, there is no requirement that all exposures be treated in this fashion.**Constraints:**The Transmission Exposure inherits the participation constraints that apply to Exposure with the following exception. The EXPTRGT (exposure target) participation must never be associated with the Transmission Exposure either directly or via context conduction. |
| [ActClassTransportation](ValueSet-v3-ActClassTransportation.md) | Transportation is the moving of a payload (people or material) from a location of origin to a destination location. Thus, any transport service has the three target instances of type payload, origin, and destination, besides the targets that are generally used for any service (i.e., performer, device, etc.) |
| [ActClassTrendelenburg](ValueSet-v3-ActClassTrendelenburg.md) | **Deprecation Comment:**This value set has been deprecated because its root code was deprecated in an earlier vocabulary release. |
| [ActClassVerification](ValueSet-v3-ActClassVerification.md) | An act which describes the process whereby a 'verifying party' validates either the existence of the Role attested to by some Credential or the actual Vetting act and its details. |
| [ActClassWorkingList](ValueSet-v3-ActClassWorkingList.md) | Working list collects a dynamic list of individual instances of Act via ActRelationship which reflects the need of an individual worker, team of workers, or an organization to manage lists of acts for many different clinical and administrative reasons. Examples of working lists include problem lists, goal lists, allergy lists, and to-do lists. |
| [ActCodeProcessStep](ValueSet-v3-ActCodeProcessStep.md) | ****No description**** |
| [ActConditionList](ValueSet-v3-ActConditionList.md) | List of condition observations. |
| [ActConsentDirective](ValueSet-v3-ActConsentDirective.md) | ActConsentDirective codes are used to specify the type of Consent Directive to which a Consent Directive Act conforms. |
| [ActConsentDirectiveType](ValueSet-v3-ActConsentDirectiveType.md) | ActConsentDirective and ActConsentType codes are used to specify the type of Consent Directive or Consent Type to which, for example, a Consent Act conforms, to which a Security Observation (Security Label) refers to, or to which a Privacy or Security Act refers. >**Steward:**Security WG |
| [ActConsentInformationAccessOverrideReason](ValueSet-v3-ActConsentInformationAccessOverrideReason.md) | **Definition:**Use to convey the reason that a provider may or has accessed personal healthcare information. Typically, this involves overriding the subject's consent directives. |
| [ActConsentType](ValueSet-v3-ActConsentType.md) | **Definition:**The type of consent directive, e.g., to consent or dissent to collect, access, or use in specific ways within an EHRS or for health information exchange; or to disclose health information for purposes such as research. |
| [ActContainerRegistrationCode](ValueSet-v3-ActContainerRegistrationCode.md) | Constrains the ActCode to the domain of Container Registration |
| [ActControlVariable](ValueSet-v3-ActControlVariable.md) | An observation form that determines parameters or attributes of an Act. Examples are the settings of a ventilator machine as parameters of a ventilator treatment act; the controls on dillution factors of a chemical analyzer as a parameter of a laboratory observation act; the settings of a physiologic measurement assembly (e.g., time skew) or the position of the body while measuring blood pressure. Control variables are forms of observations because just as with clinical observations, the Observation.code determines the parameter and the Observation.value assigns the value. While control variables sometimes can be observed (by noting the control settings or an actually measured feedback loop) they are not primary observations, in the sense that a control variable without a primary act is of no use (e.g., it makes no sense to record a blood pressure position without recording a blood pressure, whereas it does make sense to record a systolic blood pressure without a diastolic blood pressure). |
| [ActCoverageAssessmentObservationValue](ValueSet-v3-ActCoverageAssessmentObservationValue.md) | Codes specify the category of observation, evidence, or document used to assess for services, e.g., discharge planning, or to establish eligibility for coverage under a policy or program. The type of evidence is coded as observation values. |
| [ActCoverageAuthorizationConfirmationCode](ValueSet-v3-ActCoverageAuthorizationConfirmationCode.md) | Indication of authorization for healthcare service(s) and/or product(s). If authorization is approved, funds are set aside. |
| [ActCoverageConfirmationCode](ValueSet-v3-ActCoverageConfirmationCode.md) | Response to an insurance coverage eligibility query or authorization request. |
| [ActCoverageLimitCode](ValueSet-v3-ActCoverageLimitCode.md) | Criteria that are applicable to the authorized coverage. |
| [ActCoverageMaximaCodes](ValueSet-v3-ActCoverageMaximaCodes.md) | **Definition:**Codes representing the maximum coverate or financial participation requirements. |
| [ActCoverageQuantityLimitCode](ValueSet-v3-ActCoverageQuantityLimitCode.md) | Maximum amount paid or maximum number of services/products covered; or maximum amount or number covered during a specified time period under the policy or program. |
| [ActCoverageReason](ValueSet-v3-ActCoverageReason.md) | **Description:**Codes used to specify reasons or criteria relating to coverage provided under a policy or program. May be used to convey reasons pertaining to coverage contractual provisions, including criteria for eligibility, coverage limitations, coverage maximums, or financial participation required of covered parties. |
| [ActCoverageTypeCode](ValueSet-v3-ActCoverageTypeCode.md) | **Definition:**Set of codes indicating the type of insurance policy or program that pays for the cost of benefits provided to covered parties. |
| [ActCredentialedCareCode](ValueSet-v3-ActCredentialedCareCode.md) | **Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by a credentialing agency, i.e. government or non-government agency. Failure in executing this Act may result in loss of credential to the person or organization who participates as performer of the Act. Excludes employment agreements.**Example:**Hospital license; physician license; clinic accreditation. |
| [ActCredentialedCareProvisionPersonCode](ValueSet-v3-ActCredentialedCareProvisionPersonCode.md) | **Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by an agency for credentialing individuals. |
| [ActCredentialedCareProvisionProgramCode](ValueSet-v3-ActCredentialedCareProvisionProgramCode.md) | **Description:**The type and scope of legal and/or professional responsibility taken-on by the performer of the Act for a specific subject of care as described by an agency for credentialing individuals. |
| [ActDetectedIssueCode](ValueSet-v3-ActDetectedIssueCode.md) | Identifies types of detected issues for Act class "ALRT" |
| [ActDetectedIssueManagementCode](ValueSet-v3-ActDetectedIssueManagementCode.md) | Codes dealing with the management of Detected Issue observations |
| [ActDietCode](ValueSet-v3-ActDietCode.md) | Code set to define specialized/allowed diets |
| [ActEmergencyEncounterCode](ValueSet-v3-ActEmergencyEncounterCode.md) | **Definition:**A patient encounter that takes place at a dedicated healthcare service delivery location where the patient receives immediate evaluation and treatment, provided until the patient can be discharged or responsibility for the patient's care is transferred elsewhere (for example, the patient could be admitted as an inpatient or transferred to another facility.) |
| [ActEncounterAccommodationCode](ValueSet-v3-ActEncounterAccommodationCode.md) | Accommodation type. In Intent mood, represents the accommodation type requested. In Event mood, represents accommodation assigned/used. In Definition mood, represents the available accommodation type. |
| [ActEncounterCode](ValueSet-v3-ActEncounterCode.md) | Domain provides codes that qualify the ActEncounterClass (ENC) |
| [ActExposureCode](ValueSet-v3-ActExposureCode.md) | Concepts that identify the type or nature of exposure interaction. Examples include "household", "care giver", "intimate partner", "common space", "common substance", etc. to further describe the nature of interaction. |
| [ActExposureLevelCode](ValueSet-v3-ActExposureLevelCode.md) | A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as "low", "medium" and "high". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance. |
| [ActFieldEncounterCode](ValueSet-v3-ActFieldEncounterCode.md) | **Definition:**A patient encounter that takes place both outside a dedicated service delivery location and outside a patient's residence. Example locations might include an accident site and at a supermarket. |
| [ActFinancialStatusObservationValue](ValueSet-v3-ActFinancialStatusObservationValue.md) | Code specifying financial indicators used to assess or establish eligibility for coverage under a policy or program; e.g., pay stub; tax or income document; asset document; living expenses. |
| [ActFinancialTransactionCode](ValueSet-v3-ActFinancialTransactionCode.md) | ****No description**** |
| [ActHealthInformationManagementReason](ValueSet-v3-ActHealthInformationManagementReason.md) | The rationale or purpose for an act relating to health information management, such as archiving information for the purpose of complying with an organization policy or jurisdictional law relating to data retention. |
| [ActHealthInsuranceTypeCode](ValueSet-v3-ActHealthInsuranceTypeCode.md) | **Definition:**Set of codes indicating the type of health insurance policy that covers health services provided to covered parties. A health insurance policy is a written contract for insurance between the insurance company and the policyholder, and contains pertinent facts about the policy owner (the policy holder), the health insurance coverage, the insured subscribers and dependents, and the insurer. Health insurance is typically administered in accordance with a plan, which specifies (1) the type of health services and health conditions that will be covered under what circumstances (e.g., exclusion of a pre-existing condition, service must be deemed medically necessary; service must not be experimental; service must provided in accordance with a protocol; drug must be on a formulary; service must be prior authorized; or be a referral from a primary care provider); (2) the type and affiliation of providers (e.g., only allopathic physicians, only in network, only providers employed by an HMO); (3) financial participations required of covered parties (e.g., co-pays, coinsurance, deductibles, out-of-pocket); and (4) the manner in which services will be paid (e.g., under indemnity or fee-for-service health plans, the covered party typically pays out-of-pocket and then file a claim for reimbursement, while health plans that have contractual relationships with providers, i.e., network providers, typically do not allow the providers to bill the covered party for the cost of the service until after filing a claim with the payer and receiving reimbursement). |
| [ActHomeHealthEncounterCode](ValueSet-v3-ActHomeHealthEncounterCode.md) | **Definition:**Healthcare encounter that takes place in the residence of the patient or a designee |
| [ActIncidentCode](ValueSet-v3-ActIncidentCode.md) | Set of codes indicating the type of incident or accident. |
| [ActIneligibilityReason](ValueSet-v3-ActIneligibilityReason.md) | Identifies the reason or rational for why a person is not eligibile for benefits under an insurance policy. Examples are client deceased & adopted client has been given a new policy identifier. |
| [ActInformationAccess](ValueSet-v3-ActInformationAccess.md) | **Definition:**Consent to access healthcare information. |
| [ActInformationAccessCode](ValueSet-v3-ActInformationAccessCode.md) | The type of personal health information to which the subject of the information, or the delegate of the subject, consents or dissents to authorize access. |
| [ActInformationAccessContextCode](ValueSet-v3-ActInformationAccessContextCode.md) | Conveyance of the type of context in which authorization given under jurisdictional law, by organizational policy, or by a patient consent directive permits the collection, access, use or disclosure of specified patient health information.**Steward:**Security WG |
| [ActInformationCategoryCode](ValueSet-v3-ActInformationCategoryCode.md) | **Definition:**Indicates the set of information types which may be manipulated or referenced, such as for recommending access restrictions. |
| [ActInformationSensitivityPolicy](ValueSet-v3-ActInformationSensitivityPolicy.md) | ActSensitivity codes are used to bind information to an Act.confidentialityCode according to local sensitivity policy so that those confidentiality codes can then govern its handling across enterprises. Internally to a policy domain, however, local policies guide the access control system on how end users in that policy domain are able to use information tagged with these sensitivity values. |
| [ActInformationTransferCode](ValueSet-v3-ActInformationTransferCode.md) | **Description:**Conveyance of the type of information transfer protocol. |
| [ActInjuryCodeCSA](ValueSet-v3-ActInjuryCodeCSA.md) | ****No description**** |
| [ActInpatientEncounterCode](ValueSet-v3-ActInpatientEncounterCode.md) | An inpatient encounter is an encounter in which the patient is admitted to a hospital or equivalent facility. |
| [ActInsurancePolicyCode](ValueSet-v3-ActInsurancePolicyCode.md) | Set of codes indicating the type of insurance policy or other source of funds to cover healthcare costs. |
| [ActInsuranceTypeCode](ValueSet-v3-ActInsuranceTypeCode.md) | **Definition:**Set of codes indicating the type of insurance policy. Insurance, in law and economics, is a form of risk management primarily used to hedge against the risk of potential financial loss. Insurance is defined as the equitable transfer of the risk of a potential loss, from one entity to another, in exchange for a premium and duty of care. A policy holder is an individual or an organization enters into a contract with an underwriter which stipulates that, in exchange for payment of a sum of money (a premium), one or more covered parties (insureds) is guaranteed compensation for losses resulting from certain perils under specified conditions. The underwriter analyzes the risk of loss, makes a decision as to whether the risk is insurable, and prices the premium accordingly. A policy provides benefits that indemnify or cover the cost of a loss incurred by a covered party, and may include coverage for services required to remediate a loss. An insurance policy contains pertinent facts about the policy holder, the insurance coverage, the covered parties, and the insurer. A policy may include exemptions and provisions specifying the extent to which the indemnification clause cannot be enforced for intentional tortious conduct of a covered party, e.g., whether the covered parties are jointly or severably insured.**Discussion:**In contrast to programs, an insurance policy has one or more policy holders, who own the policy. The policy holder may be the covered party, a relative of the covered party, a partnership, or a corporation, e.g., an employer. A subscriber of a self-insured health insurance policy is a policy holder. A subscriber of an employer sponsored health insurance policy is holds a certificate of coverage, but is not a policy holder; the policy holder is the employer. See CoveredRoleType. |
| [ActInvoiceAdjudicationPaymentCode](ValueSet-v3-ActInvoiceAdjudicationPaymentCode.md) | Codes representing a grouping of invoice elements (totals, sub-totals), reported through a Payment Advice or a Statement of Financial Activity (SOFA). The code can represent summaries by day, location, payee and other cost elements such as bonus, retroactive adjustment and transaction fees. |
| [ActInvoiceAdjudicationPaymentGroupCode](ValueSet-v3-ActInvoiceAdjudicationPaymentGroupCode.md) | Codes representing adjustments to a Payment Advice such as retroactive, clawback, garnishee, etc. |
| [ActInvoiceAdjudicationPaymentSummaryCode](ValueSet-v3-ActInvoiceAdjudicationPaymentSummaryCode.md) | Codes representing a grouping of invoice elements (totals, sub-totals), reported through a Payment Advice or a Statement of Financial Activity (SOFA). The code can represent summaries by day, location, payee, etc. |
| [ActInvoiceDetailClinicalProductCode](ValueSet-v3-ActInvoiceDetailClinicalProductCode.md) | An identifying data string for healthcare products. |
| [ActInvoiceDetailCode](ValueSet-v3-ActInvoiceDetailCode.md) | Codes representing a service or product that is being invoiced (billed). The code can represent such concepts as "office visit", "drug X", "wheelchair" and other billable items such as taxes, service charges and discounts. |
| [ActInvoiceDetailDrugProductCode](ValueSet-v3-ActInvoiceDetailDrugProductCode.md) | An identifying data string for A substance used as a medication or in the preparation of medication. |
| [ActInvoiceDetailGenericAdjudicatorCode](ValueSet-v3-ActInvoiceDetailGenericAdjudicatorCode.md) | The billable item codes to identify adjudicator specified components to the total billing of a claim. |
| [ActInvoiceDetailGenericCode](ValueSet-v3-ActInvoiceDetailGenericCode.md) | The detail item codes to identify charges or changes to the total billing of a claim due to insurance rules and payments. |
| [ActInvoiceDetailGenericModifierCode](ValueSet-v3-ActInvoiceDetailGenericModifierCode.md) | The billable item codes to identify modifications to a billable item charge. As for example after hours increase in the office visit fee. |
| [ActInvoiceDetailGenericProviderCode](ValueSet-v3-ActInvoiceDetailGenericProviderCode.md) | The billable item codes to identify provider supplied charges or changes to the total billing of a claim. |
| [ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-ActInvoiceDetailPreferredAccommodationCode.md) | An identifying data string for medical facility accommodations. |
| [ActInvoiceDetailTaxCode](ValueSet-v3-ActInvoiceDetailTaxCode.md) | The billable item codes to identify modifications to a billable item charge by a tax factor applied to the amount. As for example 7% provincial sales tax. |
| [ActInvoiceElementCode](ValueSet-v3-ActInvoiceElementCode.md) | Type of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results. |
| [ActInvoiceElementModifier](ValueSet-v3-ActInvoiceElementModifier.md) | Processing consideration and clarification codes. |
| [ActInvoiceElementSummaryCode](ValueSet-v3-ActInvoiceElementSummaryCode.md) | Identifies the different types of summary information that can be reported by queries dealing with Statement of Financial Activity (SOFA). The summary information is generally used to help resolve balance discrepancies between providers and payors. |
| [ActInvoiceGroupCode](ValueSet-v3-ActInvoiceGroupCode.md) | Type of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results. Invoice elements of this type signify a grouping of one or more children (detail) invoice elements. They do not have intrinsic costing associated with them, but merely reflect the sum of all costing for it's immediate children invoice elements. |
| [ActInvoiceInterGroupCode](ValueSet-v3-ActInvoiceInterGroupCode.md) | Type of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results. Invoice elements of this type signify a grouping of one or more children (detail) invoice elements. They do not have intrinsic costing associated with them, but merely reflect the sum of all costing for it's immediate children invoice elements. The domain is only specified for an intermediate invoice element group (non-root or non-top level) for an Invoice. |
| [ActInvoiceOverrideCode](ValueSet-v3-ActInvoiceOverrideCode.md) | Includes coded responses that will occur as a result of the adjudication of an electronic invoice at a summary level and provides guidance on interpretation of the referenced adjudication results. |
| [ActInvoicePaymentCode](ValueSet-v3-ActInvoicePaymentCode.md) | ****No description**** |
| [ActInvoiceRootGroupCode](ValueSet-v3-ActInvoiceRootGroupCode.md) | Type of invoice element that is used to assist in describing an Invoice that is either submitted for adjudication or for which is returned on adjudication results. Invoice elements of this type signify a grouping of one or more children (detail) invoice elements. They do not have intrinsic costing associated with them, but merely reflect the sum of all costing for it's immediate children invoice elements. Codes from this domain reflect the type of Invoice such as Pharmacy Dispense, Clinical Service and Clinical Product. The domain is only specified for the root (top level) invoice element group for an Invoice. |
| [ActListCode](ValueSet-v3-ActListCode.md) | Provides codes associated with ActClass value of LIST (working list) |
| [ActMedicalServiceCode](ValueSet-v3-ActMedicalServiceCode.md) | General category of medical service provided to the patient during their encounter. |
| [ActMedicationList](ValueSet-v3-ActMedicationList.md) | List of medications. |
| [ActMedicationTherapyDurationWorkingListCode](ValueSet-v3-ActMedicationTherapyDurationWorkingListCode.md) | ****No description**** |
| [ActMonitoringProtocolCode](ValueSet-v3-ActMonitoringProtocolCode.md) | Identifies types of monitoring programs |
| [ActMood](ValueSet-v3-ActMood.md) | A code distinguishing whether an Act is conceived of as a factual statement or in some other manner as a command, possibility, goal, etc.**Constraints:**An Act-instance must have one and only one moodCode value. The moodCode of a single Act-instance never changes. Mood is not state. To describe the progression of a business activity from defined to planned to executed, etc. one must instantiate different Act-instances in the different moods and link them using ActRelationship of general type "sequel". (See ActRelationship.type.) |
| [ActMoodActRequest](ValueSet-v3-ActMoodActRequest.md) | ****No description**** |
| [ActMoodAppointment](ValueSet-v3-ActMoodAppointment.md) | A planned Act for a specific time and place. |
| [ActMoodAppointmentRequest](ValueSet-v3-ActMoodAppointmentRequest.md) | A request for the booking of an appointment. |
| [ActMoodCompletionTrack](ValueSet-v3-ActMoodCompletionTrack.md) | These are moods describing activities as they progress in the business cycle, from defined, through planned and ordered to completed. |
| [ActMoodCriterion](ValueSet-v3-ActMoodCriterion.md) | A criterion or condition over actual and potential services that must apply for an associated service to be considered. Matches records any ActMoodCompletionTrack moods. |
| [ActMoodDefinition](ValueSet-v3-ActMoodDefinition.md) | A definition of a service (master). Historical note: in previous RIM versions, the definition mood was captured as a separate class hierarchy, called Master_service. |
| [ActMoodDesire](ValueSet-v3-ActMoodDesire.md) | ****No description**** |
| [ActMoodEventCriterion](ValueSet-v3-ActMoodEventCriterion.md) | A criterion or condition over service events that must apply for an associated service to be considered. |
| [ActMoodEventOccurrence](ValueSet-v3-ActMoodEventOccurrence.md) | A service that actually happens, may be an ongoing service or a documentation of a past service. Historical note: in previous RIM versions, the event mood was captured as a separate class hierarchy, called Patient_service_event, and later Service_event. |
| [ActMoodExpectation](ValueSet-v3-ActMoodExpectation.md) | **Definition:**An act that is considered likely to occur in the future. The essential feature of an act expressed in expectation mood is that it is likely to occur. An expectation may be desirable, undesirable or neutral in effect.**Examples:**Prognosis of a condition, Expected date of discharge from hospital, patient will likely need an emergency decompression of the intracranial pressure by morning.**Discussion:**INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with expectation, which is a prediction that something will happen in the future. GOL (goal) reflects a hope rather than a prediction. RSK (risk) reflects a potential negative event that may or may not be expected to happen. |
| [ActMoodGoal](ValueSet-v3-ActMoodGoal.md) | **Definition:**An observation that is considered to be desirable to occur in the future. The essential feature of a goal is that if it occurs it would be considered as a marker of a positive outcome or of progress towards a positive outcome.**Examples:**Target weight below 80Kg, Stop smoking, Regain ability to walk, goal is to administer thrombolytics to candidate patients presenting with acute myocardial infarction.**Discussion:**INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with goal which doesn't represent an intention to act, merely a hope for an eventual result. A goal is distinct from the intended actions to reach that goal. "I will reduce the dose of drug x to 20mg" is an intent. "I hope to be able to get the patient to the point where I can reduce the dose of drug x to 20mg" is a goal. EXPEC (expectation) reflects a prediction rather than a hope. RSK (risk) reflects a potential negative event rather than a hope. |
| [ActMoodIntent](ValueSet-v3-ActMoodIntent.md) | An intention or plan to perform a service. Historical note: in previous RIM versions, the intent mood was captured as a separate class hierarchy, called Service_intent_or_order. |
| [ActMoodOption](ValueSet-v3-ActMoodOption.md) | An option is an alternative set of property-value bindings. Options specify alternative sets of values, typically used in definitions or orders to describe alternatives. An option can only be used as a group, that is, all assigned values must be used together. Historical note: in HL7 v2.x option existed in the special case for alternative medication routes (RXR segment). |
| [ActMoodPermission](ValueSet-v3-ActMoodPermission.md) | A kind of service which is authorized to be performed. |
| [ActMoodPermissionRequest](ValueSet-v3-ActMoodPermissionRequest.md) | A request for authorization to perform a kind of service. This is distinct from RQO which is a request for an actual act. PERMRQ is merely a request for permission to perform an act.**Discussion:** |
| [ActMoodPotential](ValueSet-v3-ActMoodPotential.md) | ****No description**** |
| [ActMoodPredicate](ValueSet-v3-ActMoodPredicate.md) | Any of the above service moods (e.g., event, intent, or goal) can be turned into a predicate used as a criterion to express conditionals (or queries.) However, currently we allow only criteria on service events. |
| [ActMoodPromise](ValueSet-v3-ActMoodPromise.md) | An intent to perform a service that has the strength of a commitment, i.e., other parties may rely on the originator of such promise that said originator will see to it that the promised act will be fulfilled. A promise can be either solicited or unsolicited. |
| [ActMoodProposal](ValueSet-v3-ActMoodProposal.md) | A non-mandated intent to perform an act. Used to record intents that are explicitly not Orders. Professional responsibility for the 'proposal' may or may not be present. |
| [ActMoodRecommendation](ValueSet-v3-ActMoodRecommendation.md) | A non-mandated intent to perform an act where a level of professional responsibility is being accepted by making the proposal. |
| [ActMoodRequest](ValueSet-v3-ActMoodRequest.md) | A request or order for a service is an intent directed from a placer (request author) to a fulfiller (service performer).**Rationale:**The concepts of a "request" and an "order" are viewed as different, because there is an implication of a mandate associated with order. In practice, however, this distinction has no general functional value in the inter-operation of health care computing. "Orders" are commonly refused for a variety of clinical and business reasons, and the notion of a "request" obligates the recipient (the fulfiller) to respond to the sender (the author). Indeed, in many regions, including Australia and Europe, the common term used is "request." Thus, the concept embodies both notions, as there is no useful distinction to be made. If a mandate is to be associated with a request, this will be embodied in the "local" business rules applied to the transactions. Should HL7 desire to provide a distinction between these in the future, the individual concepts could be added as specializations of this concept. The critical distinction here, is the difference between this concept and an "intent", of which it is a specialization. An intent involves decisions by a single party, the author. A request, however, involves decisions by two parties, the author and the fulfiller, with an obligation on the part of the fulfiller to respond to the request indicating that the fulfiller will indeed fulfill the request. |
| [ActMoodResourceSlot](ValueSet-v3-ActMoodResourceSlot.md) | Periods of time on a schedule for a resource. Appointments occupy sets of one or more booked slots. A slot that is open for appointments is considered available and a slot that is held back for administrative purposes is considered blocked. A Resource slot that is "tentatively" booked is referred to as reserved. |
| [ActMoodRisk](ValueSet-v3-ActMoodRisk.md) | **Definition:**An act that may occur in the future and which is regarded as undesirable. The essential feature of a risk is that if it occurs this would be regarded as a marker of a negative outcome or of deterioration towards a negative outcome. Recording a risk indicates that it is seen as more likely to occur in the subject than in a general member of the population but does not mean it is expected to occur.**Examples:**Increased risk of DVT, at risk for sub-acute bacterial endocarditis.**Discussion:**Note: An observation in RSK mood expresses the undesirable act, and not the underlying risk factor. A risk factor that is present (e.g. obesity, smoking, etc) should be expressed in event mood. INT (intent) reflects a plan for the future, which is a declaration to do something. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen. GOL (goal) reflects a hope to achieve something. EXPEC (expectation) is the prediction of a positive or negative event. This contrasts with RSK (risk), which is the potential that something negative will occur that may or may not ever happen, and may not be expected to happen. |
| [ActNoImmunizationReason](ValueSet-v3-ActNoImmunizationReason.md) | A coded description of the reason for why a patient did not receive a scheduled immunization. (important for public health strategy |
| [ActNonObservationIndicationCode](ValueSet-v3-ActNonObservationIndicationCode.md) | **Description:**Concepts representing indications (reasons for clinical action) other than diagnosis and symptoms. |
| [ActObservationList](ValueSet-v3-ActObservationList.md) | ****No description**** |
| [ActObservationVerificationType](ValueSet-v3-ActObservationVerificationType.md) | Identifies the type of verification investigation being undertaken with respect to the subject of the verification activity.**Examples:**1. Verification of eligibility for coverage under a policy or program - aka enrolled/covered by a policy or program
1. Verification of record - e.g., person has record in an immunization registry
1. Verification of enumeration - e.g. NPI
1. Verification of Board Certification - provider specific
1. Verification of Certification - e.g. JAHCO, NCQA, URAC
1. Verification of Conformance - e.g. entity use with HIPAA, conformant to the CCHIT EHR system criteria
1. Verification of Provider Credentials
1. Verification of no adverse findings - e.g. on National Provider Data Bank, Health Integrity Protection Data Base (HIPDB)
 |
| [ActPatientAnnotationType](ValueSet-v3-ActPatientAnnotationType.md) | Provides a categorization for annotations recorded directly against the patient |
| [ActPatientTransportationModeCode](ValueSet-v3-ActPatientTransportationModeCode.md) | Definition: Characterizes how a patient was or will be transported to the site of a patient encounter.**Examples:**Via ambulance, via public transit, on foot. |
| [ActPaymentCode](ValueSet-v3-ActPaymentCode.md) | Code identifying the method or the movement of payment instructions. Codes are drawn from X12 data element 591 (PaymentMethodCode) |
| [ActPharmacySupplyType](ValueSet-v3-ActPharmacySupplyType.md) | Identifies types of dispensing events |
| [ActPolicyType](ValueSet-v3-ActPolicyType.md) | **Description:**Types of policies that further specify the ActClassPolicy value set. |
| [ActPriority](ValueSet-v3-ActPriority.md) | A code or set of codes (e.g., for routine, emergency,) specifying the urgency under which the Act happened, can happen, is happening, is intended to happen, or is requested/demanded to happen.**Discussion:**This attribute is used in orders to indicate the ordered priority, and in event documentation it indicates the actual priority used to perform the act. In definition mood it indicates the available priorities. |
| [ActPriorityCallback](ValueSet-v3-ActPriorityCallback.md) | Filler should contact the placer (or target) to schedule the service. (Was "C" in HL7 version 2.3's TQ-priority component.) |
| [ActPrivacyLaw](ValueSet-v3-ActPrivacyLaw.md) | ActPrivacyLaw codes may be associated with an Act or a Role to indicate the legal provision to which the assignment of an Act.confidentialityCode or Role.confidentialtyCode complies. May be used to further specify rationale for assignment of other ActPrivacyPolicy codes in the US realm, e.g., ETH and 42CFRPart2 can be differentiated from ETH and Title38Part1. |
| [ActPrivacyPolicy](ValueSet-v3-ActPrivacyPolicy.md) | ActPrivacyPolicyType codes support the designation of the 1..* policies that are applicable to an Act such as a Consent Directive, a Role such as a VIP Patient, or an Entity such as a patient who is a minor. 1..* ActPrivacyPolicyType values may be associated with an Act or Role to indicate the policies that govern the assignment of an Act or Role confidentialityCode. Use of multiple ActPrivacyPolicyType values enables fine grain specification of applicable policies, but must be carefully assigned to ensure cogency and avoid creation of conflicting policy mandates. Statutory title may be named in the ActClassPolicy Act Act.title to specify which privacy policy is being referenced. |
| [ActProductAcquisitionCode](ValueSet-v3-ActProductAcquisitionCode.md) | The method that a product is obtained for use by the subject of the supply act (e.g. patient). Product examples are consumable or durable goods. |
| [ActProgramTypeCode](ValueSet-v3-ActProgramTypeCode.md) | **Definition:**A set of codes used to indicate coverage under a program. A program is an organized structure for administering and funding coverage of a benefit package for covered parties meeting eligibility criteria, typically related to employment, health, financial, and demographic status. Programs are typically established or permitted by legislation with provisions for ongoing government oversight. Regulations may mandate the structure of the program, the manner in which it is funded and administered, covered benefits, provider types, eligibility criteria and financial participation. A government agency may be charged with implementing the program in accordance to the regulation. Risk of loss under a program in most cases would not meet what an underwriter would consider an insurable risk, i.e., the risk is not random in nature, not financially measurable, and likely requires subsidization with government funds.**Discussion:**Programs do not have policy holders or subscribers. Program eligibles are enrolled based on health status, statutory eligibility, financial status, or age. Program eligibles who are covered parties under the program may be referred to as members, beneficiaries, eligibles, or recipients. Programs risk are underwritten by not for profit organizations such as governmental entities, and the beneficiaries typically do not pay for any or some portion of the cost of coverage. See CoveredPartyRoleType. |
| [ActRelationshipAccounting](ValueSet-v3-ActRelationshipAccounting.md) | Codes that describe the relationship between an Act and a financial instrument such as a financial transaction, account or invoice element. |
| [ActRelationshipActProvenance](ValueSet-v3-ActRelationshipActProvenance.md) | Used to convey the relationship between two or more Acts for purpose of tracking provenance relationships such as the following:* A predecessor Act and a successor Act (e.g., a predecessor Lab Result from which a successor Lab Result in derived) 
* A ProvenanceEvent Act and a target Act for which it records the Provenance (e.g., a target Act is an update of a predecessor Act) 
* A predecessor ProvenanceEvent Act and a successor ProvenanceEvent Act **UsageConstraint:** The v:ActRelationshipActProvenance is intended to limit the types of relationships that could be conveyed by the ActRelationshipType codes to a subset that pertains to these provenance relations.
 |
| [ActRelationshipActiveImmunizationAgainst](ValueSet-v3-ActRelationshipActiveImmunizationAgainst.md) | ****No description**** |
| [ActRelationshipAdjunctCurativeIndication](ValueSet-v3-ActRelationshipAdjunctCurativeIndication.md) | ****No description**** |
| [ActRelationshipAdjunctMitigation](ValueSet-v3-ActRelationshipAdjunctMitigation.md) | ****No description**** |
| [ActRelationshipAdjunctiveTreatment](ValueSet-v3-ActRelationshipAdjunctiveTreatment.md) | ****No description**** |
| [ActRelationshipArrival](ValueSet-v3-ActRelationshipArrival.md) | The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act entered into the source Act by means of the target Transportation act. |
| [ActRelationshipAssignsName](ValueSet-v3-ActRelationshipAssignsName.md) | Used to assign a "name" to a condition thread. Source is a condition node, target can be any service. |
| [ActRelationshipAuthorizedBy](ValueSet-v3-ActRelationshipAuthorizedBy.md) | A relationship in which the target act authorizes or certifies the source act. |
| [ActRelationshipBlocks](ValueSet-v3-ActRelationshipBlocks.md) | **Definition:**The source act is performed to block the effects of the target act. This act relationship should be used when describing near miss type incidents where potential harm could have occurred, but the action described in the source act blocked the potential harmful effects of the incident actually occurring. |
| [ActRelationshipCheckpoint](ValueSet-v3-ActRelationshipCheckpoint.md) | A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., before the Act starts for the first time, before every repetition, after each repetition but not before the first, or throughout the entire time of the Act.)**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Before each step is executed and has preconditions these conditions are tested and if the test is positive, the Act has clearance for execution. The repeatNumber may indicate that an Act may be repeatedly executed. The checkpointCode is specifies when the precondition is checked and is analogous to the various conditional statements and loop constructs in programming languages "while-do" vs. "do-while" or "repeat-until" vs. "loop-exit". For all checkpointCodes, except "end", preconditions are being checked at the time when the preceding step of the plan has terminated and this step would be next in the sequence established by the sequenceNumber attribute. When the checkpointCode for a criterion of a repeatable Act is "end", the criterion is tested only at the end of each repetition of that Act. When the condition holds true, the next repetition is ready for execution. When the checkpointCode is "entry" the criterion is checked at the beginning of each repetition (if any) whereas "beginning" means the criterion is checked only once before the repetition "loop" starts. The checkpointCode "through" is special in that it requires the condition to hold throughout the execution of the Act, even throughout a single execution. As soon as the condition turns false, the Act should receive an interrupt event (see interruptibleInd) and will eventually terminate. The checkpointCode "exit" is only used on a special plan step that represents a loop exit step. This allows an action plan to exit due to a condition tested inside the execution of this plan. Such exit criteria are sequenced with the other plan components using the ActRelationship.sequenceNumber. |
| [ActRelationshipCheckpointBeginning](ValueSet-v3-ActRelationshipCheckpointBeginning.md) | Condition is tested every time before execution of the service (WHILE condition DO service). |
| [ActRelationshipCheckpointEnd](ValueSet-v3-ActRelationshipCheckpointEnd.md) | Condition is tested at the end of a repeated service execution. The service is repeated only if the condition is true (DO service WHILE condition). |
| [ActRelationshipCheckpointEntry](ValueSet-v3-ActRelationshipCheckpointEntry.md) | Condition is tested once before the service is executed (IF condition THEN service). |
| [ActRelationshipCheckpointExit](ValueSet-v3-ActRelationshipCheckpointExit.md) | Condition is a loop checkpoint, i.e. it is a step of an activity plan and, if negative causes the containing loop to exit. |
| [ActRelationshipCheckpointThrough](ValueSet-v3-ActRelationshipCheckpointThrough.md) | Condition must be true throughout the execution and the service is interrupted (asynchronously) as soon as the condition turns false (asynchronous WHILE loop). The service must be interruptible. |
| [ActRelationshipCompliesWith](ValueSet-v3-ActRelationshipCompliesWith.md) | ****No description**** |
| [ActRelationshipConcurrentWith](ValueSet-v3-ActRelationshipConcurrentWith.md) | ****No description**** |
| [ActRelationshipConditional](ValueSet-v3-ActRelationshipConditional.md) | Specifies under what circumstances (target Act) the source-Act may, must, must not or has occurred |
| [ActRelationshipContainsEndOf](ValueSet-v3-ActRelationshipContainsEndOf.md) | ****No description**** |
| [ActRelationshipContainsStartOf](ValueSet-v3-ActRelationshipContainsStartOf.md) | ****No description**** |
| [ActRelationshipContainsStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipContainsStartOfEndsBeforeEndOf.md) | ****No description**** |
| [ActRelationshipContainsTimeOf](ValueSet-v3-ActRelationshipContainsTimeOf.md) | ****No description**** |
| [ActRelationshipCostTracking](ValueSet-v3-ActRelationshipCostTracking.md) | Expresses values for describing the relationship relationship between an InvoiceElement or InvoiceElementGroup and a billable act. |
| [ActRelationshipCoveredBy](ValueSet-v3-ActRelationshipCoveredBy.md) | A relationship in which the source act is covered by or is under the authority of a target act. A financial instrument such as an Invoice Element is covered by one or more specific instances of an Insurance Policy. |
| [ActRelationshipCurativeIndication](ValueSet-v3-ActRelationshipCurativeIndication.md) | ****No description**** |
| [ActRelationshipDeparture](ValueSet-v3-ActRelationshipDeparture.md) | The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act departed from the source Act by means of the target Transportation act. |
| [ActRelationshipDiagnosis](ValueSet-v3-ActRelationshipDiagnosis.md) | ****No description**** |
| [ActRelationshipDocumentHQMF](ValueSet-v3-ActRelationshipDocumentHQMF.md) | The reasons that may be used when relating a Quality Measure Document to other document types. |
| [ActRelationshipDocumentProvenance](ValueSet-v3-ActRelationshipDocumentProvenance.md) | Used to convey the relationship between two or more Documents for purpose of tracking provenance relationships such as a predecessor Document and a successor Document. For example, a predecessor Clinical Summary Document from which a successor Clinical Summary Document is derived. |
| [ActRelationshipDocuments](ValueSet-v3-ActRelationshipDocuments.md) | The source act documents the target act. |
| [ActRelationshipDuring](ValueSet-v3-ActRelationshipDuring.md) | ****No description**** |
| [ActRelationshipEndsAfterEndOf](ValueSet-v3-ActRelationshipEndsAfterEndOf.md) | ****No description**** |
| [ActRelationshipEndsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithEndOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEndsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithStartOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEndsAfterStartOf](ValueSet-v3-ActRelationshipEndsAfterStartOf.md) | ****No description**** |
| [ActRelationshipEndsBeforeEnd](ValueSet-v3-ActRelationshipEndsBeforeEnd.md) | The source Act ends after the end of the target Act (i.e. if we say "ActOne EBE ActTwo", it means that ActOne ends before the end of ActTwo, therefore ActOne is the source and ActTwo is the target). |
| [ActRelationshipEndsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithEndOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEndsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithStartOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEndsBeforeStartOf](ValueSet-v3-ActRelationshipEndsBeforeStartOf.md) | ****No description**** |
| [ActRelationshipEndsConcurrentWith](ValueSet-v3-ActRelationshipEndsConcurrentWith.md) | ****No description**** |
| [ActRelationshipEndsConcurrentWithStart](ValueSet-v3-ActRelationshipEndsConcurrentWithStart.md) | The source Act ends when the target act starts (i.e. if we say "ActOne ECWS ActTwo", it means that ActOne ends when ActTwo starts, therefore ActOne is the source and ActTwo is the target). |
| [ActRelationshipEndsDuring](ValueSet-v3-ActRelationshipEndsDuring.md) | ****No description**** |
| [ActRelationshipEndsNearEnd](ValueSet-v3-ActRelationshipEndsNearEnd.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEndsNearStarts](ValueSet-v3-ActRelationshipEndsNearStarts.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipEpisodelink](ValueSet-v3-ActRelationshipEpisodelink.md) | Expresses an association that links two instances of the same act over time, indicating that the instance are part of the same episode, e.g. linking two condition nodes for episode of illness; linking two encounters for episode of encounter. |
| [ActRelationshipEvaluatesGoal](ValueSet-v3-ActRelationshipEvaluatesGoal.md) | A goal-evaluation links an observation (intent or actual) to a goal to indicate that the observation evaluates the goal. Given the goal and the observation, a "goal distance" (e.g., goal to observation) can be "calculated" and need not be sent explicitly. |
| [ActRelationshipExacerbatredBy](ValueSet-v3-ActRelationshipExacerbatredBy.md) | ****No description**** |
| [ActRelationshipExcerpt](ValueSet-v3-ActRelationshipExcerpt.md) | The source is an excerpt from the target. |
| [ActRelationshipExcerptVerbatim](ValueSet-v3-ActRelationshipExcerptVerbatim.md) | The source is a direct quote from the target. |
| [ActRelationshipFulfills](ValueSet-v3-ActRelationshipFulfills.md) | The source act fulfills (in whole or in part) the target act. Source act must be in a mood equal or more actual than the target act. |
| [ActRelationshipHasBaseline](ValueSet-v3-ActRelationshipHasBaseline.md) | ****No description**** |
| [ActRelationshipHasBoundedSupport](ValueSet-v3-ActRelationshipHasBoundedSupport.md) | A specialization of "has support" (SPRT), used to relate a secondary observation to a Region of Interest on a multidimensional observation, if the ROI specifies the true boundaries of the secondary observation as opposed to only marking the approximate area. For example, if the start and end of an ST elevation episode is visible in an EKG, this relation would indicate the ROI bounds the "ST elevation" observation – the ROI defines the true beginning and ending of the episode. Conversely, if a ROI simply contains ST elevation, but it does not define the bounds (start and end) of the episode, the more general "has support" relation is used. Likewise, if a ROI on an image defines the true bounds of a "1st degree burn", the relation "has bounded support" is used; but if the ROI only points to the approximate area of the burn, the general "has support" relation is used. |
| [ActRelationshipHasCharge](ValueSet-v3-ActRelationshipHasCharge.md) | A relationship that provides an ability to associate a financial transaction (target) as a charge to a clinical act (source). A clinical act may have a charge associated with the execution or delivery of the service. The financial transaction will define the charge (bill) for delivery or performance of the service. Charges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product. |
| [ActRelationshipHasComponent](ValueSet-v3-ActRelationshipHasComponent.md) | A collection of sub-services as steps or subtasks performed for the source service. Services may be performed sequentially or concurrently. |
| [ActRelationshipHasContinuingObjective](ValueSet-v3-ActRelationshipHasContinuingObjective.md) | A desired state that a service action aims to maintain. E.g., keep systolic blood pressure between 90 and 110 mm Hg. Source is an intervention service. Target must be an observation in criterion mood. |
| [ActRelationshipHasContra-indication](ValueSet-v3-ActRelationshipHasContra-indication.md) | A contraindication is just a negation of a reason, i.e. it gives a condition under which the action is not to be done. Both, source and target can be any kind of service; target service is in criterion mood. How the strength of a contraindication is expressed (e.g., relative, absolute) is left as an open issue. The priorityNumber attribute could be used. |
| [ActRelationshipHasControlVariable](ValueSet-v3-ActRelationshipHasControlVariable.md) | A relationship from an Act to a Control Variable. For example, if a Device makes an Observation, this relates the Observation to its Control Variables documenting the device's settings that influenced the observation. |
| [ActRelationshipHasCost](ValueSet-v3-ActRelationshipHasCost.md) | A relationship that provides an ability to associate a financial transaction (target) as a cost to a clinical act (source). A clinical act may have an inherit cost associated with the execution or delivery of the service. The financial transaction will define the cost of delivery or performance of the service. Charges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product. |
| [ActRelationshipHasCredit](ValueSet-v3-ActRelationshipHasCredit.md) | A credit relationship ties a financial transaction (target) to an account (source). A credit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account credit will decrease the account balance. A non-asset account credit will decrease the account balance. |
| [ActRelationshipHasDebit](ValueSet-v3-ActRelationshipHasDebit.md) | A debit relationship ties a financial transaction (target) to an account (source). A debit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account debit will increase the account balance. A non-asset account debit will decrease the account balance. |
| [ActRelationshipHasExplanation](ValueSet-v3-ActRelationshipHasExplanation.md) | This is the inversion of support. Used to indicate that a given observation is explained by another observation or condition. |
| [ActRelationshipHasFinalObjective](ValueSet-v3-ActRelationshipHasFinalObjective.md) | A desired outcome that a service action aims to meet finally. Source is any service (typically an intervention). Target must be an observation in criterion mood. |
| [ActRelationshipHasGeneralization](ValueSet-v3-ActRelationshipHasGeneralization.md) | The generalization relationship can be used to express categorical knowledge about services (e.g., amilorid, triamterene, and spironolactone have the common generalization potassium sparing diuretic). |
| [ActRelationshipHasGoal](ValueSet-v3-ActRelationshipHasGoal.md) | A goal that one defines given a patient's health condition. Subsequently planned actions aim to meet that goal. Source is an observation or condition node, target must be an observation in goal mood. |
| [ActRelationshipHasMember](ValueSet-v3-ActRelationshipHasMember.md) | ****No description**** |
| [ActRelationshipHasMetadata](ValueSet-v3-ActRelationshipHasMetadata.md) | ****No description**** |
| [ActRelationshipHasOption](ValueSet-v3-ActRelationshipHasOption.md) | A relationship between a source Act that provides more detailed properties to the target Act. The source act thus is a specialization of the target act, but instead of mentioning all the inherited properties it only mentions new property bindings or refinements. The typical use case is to specify certain alternative variants of one kind of Act. The priorityNumber attribute is used to weigh refinements as preferred over other alternative refinements. Example: several routing options for a drug are specified as one SubstanceAdministration for the general treatment with attached refinements for the various routing options. |
| [ActRelationshipHasPart](ValueSet-v3-ActRelationshipHasPart.md) | ****No description**** |
| [ActRelationshipHasPre-condition](ValueSet-v3-ActRelationshipHasPre-condition.md) | A requirement to be true before a service is performed. The target can be any service in criterion mood. For multiple pre-conditions a conjunction attribute (AND, OR, XOR) is applicable. |
| [ActRelationshipHasPreviousInstance](ValueSet-v3-ActRelationshipHasPreviousInstance.md) | A relationship in which the target act is a predecessor instance to the source act. Generally each of these instances is similar, but no identical. In healthcare coverage it is used to link a claim item to a previous claim item that might have claimed for the same set of services. |
| [ActRelationshipHasQualifier](ValueSet-v3-ActRelationshipHasQualifier.md) | ****No description**** |
| [ActRelationshipHasReferenceValues](ValueSet-v3-ActRelationshipHasReferenceValues.md) | Reference ranges are essentially descriptors of a class of result values assumed to be "normal", "abnormal", or "critical." Those can vary by sex, age, or any other criterion. Source and target are observations, the target is in criterion mood. This link type can act as a trigger in case of alarms being triggered by critical results. |
| [ActRelationshipHasRisk](ValueSet-v3-ActRelationshipHasRisk.md) | A noteworthy undesired outcome of a patient's condition that is either likely enough to become an issue or is less likely but dangerous enough to be addressed. |
| [ActRelationshipHasStep](ValueSet-v3-ActRelationshipHasStep.md) | ****No description**** |
| [ActRelationshipHasSubject](ValueSet-v3-ActRelationshipHasSubject.md) | Relates an Act to its subject Act that the first Act is primarily concerned with. Examples1. The first Act may be a ControlAct manipulating the subject Act
1. The first act is a region of interest (ROI) that defines a region within the subject Act.
1. The first act is a reporting or notification Act, that echos the subject Act for a specific new purpose. Constraints An Act may have multiple subject acts. Rationale The ActRelationshipType "has subject" is similar to the ParticipationType "subject", Acts that primarily operate on physical subjects use the Participation, those Acts that primarily operate on other Acts (other information) use the ActRelationship.
 |
| [ActRelationshipHasSupport](ValueSet-v3-ActRelationshipHasSupport.md) | Used to indicate that an existing service is suggesting evidence for a new observation. The assumption of support is attributed to the same actor who asserts the observation. Source must be an observation, target may be any service (e.g., to indicate a status post.) |
| [ActRelationshipHasTrigger](ValueSet-v3-ActRelationshipHasTrigger.md) | A pre-condition that if true should result in the source Act being executed. The target is in typically in criterion mood. When reported after the fact (i.e. the criterion has been met) it may be in Event mood. A delay between the trigger and the triggered action can be specified.**Discussion:**This includes the concept of a required act for a service or financial instrument such as an insurance plan or policy. In such cases, the trigger is the occurrence of a specific condition such as coverage limits being exceeded. |
| [ActRelationshipHasValue](ValueSet-v3-ActRelationshipHasValue.md) | ****No description**** |
| [ActRelationshipICSRInvestigation](ValueSet-v3-ActRelationshipICSRInvestigation.md) | **Description:**The ways that product safety Investigations, about which information is captured in an Individual Case Safety Report, are related to each other. One investigation may be performed at a patient care institution, and the second by a manufacturer, a third by a regulatory agency. They may all investigate the same case and are thus related. Other kinds of relationships are replacement (if the mode of the Investigation is changed). |
| [ActRelationshipImmunizationAgainst](ValueSet-v3-ActRelationshipImmunizationAgainst.md) | ****No description**** |
| [ActRelationshipIndependentOfTimeOf](ValueSet-v3-ActRelationshipIndependentOfTimeOf.md) | ****No description**** |
| [ActRelationshipInstantiatesMaster](ValueSet-v3-ActRelationshipInstantiatesMaster.md) | Used to capture the link between a potential service ("master" or plan) and an actual service, where the actual service instantiates the potential service. The instantiation may override the master's defaults. |
| [ActRelationshipInterferedBy](ValueSet-v3-ActRelationshipInterferedBy.md) | ****No description**** |
| [ActRelationshipIsAppendage](ValueSet-v3-ActRelationshipIsAppendage.md) | An addendum (source) to an existing service object (target), containing supplemental information. The addendum is itself an original service object linked to the supplemented service object. The supplemented service object remains in place and its content and status are unaltered. |
| [ActRelationshipIsDerivedFrom](ValueSet-v3-ActRelationshipIsDerivedFrom.md) | Associates a derived Act with its input parameters. E.G., an anion-gap observation can be associated as being derived from given sodium-, (potassium-,), chloride-, and bicarbonate-observations. The narrative content (Act.text) of a source act is wholly machine-derived from the collection of target acts. |
| [ActRelationshipIsEtiologyFor](ValueSet-v3-ActRelationshipIsEtiologyFor.md) | An assertion that a new observation was assumed to be the cause for another existing observation. The assumption is attributed to the same actor who asserts the observation. This is stronger and more specific than the support link. For example, a growth of Staphylococcus aureus may be considered the cause of an abscess. The source (cause) is typically an observation, but may be any service, while the target must be an observation. |
| [ActRelationshipIsManifestationOf](ValueSet-v3-ActRelationshipIsManifestationOf.md) | An assertion that a new observation may be the manifestation of another existing observation or action. This assumption is attributed to the same actor who asserts the manifestation. This is stronger and more specific than an inverted support link. For example, an agitated appearance can be asserted to be the manifestation (effect) of a known hyperthyroxia. This expresses that one might not have realized a symptom if it would not be a common manifestation of a known condition. The target (cause) may be any service, while the source (manifestation) must be an observation. |
| [ActRelationshipItemsLocated](ValueSet-v3-ActRelationshipItemsLocated.md) | Items located |
| [ActRelationshipJoin](ValueSet-v3-ActRelationshipJoin.md) | A code specifying how concurrent Acts are resynchronized in a parallel branch construct.**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. Branches are parallel if the splitCode specifies that more than one branch can be executed at the same time. The joinCode then specifies if and how the braches are resynchronized. The principal re-synchronization actions are (1) the control flow waits for a branch to terminate (wait-branch), (2) the branch that is not yet terminated is aborted (kill-branch), (3) the branch is not re-synchronized at all and continues in parallel (detached branch). A kill branch is only executed if there is at least one active wait (or exclusive wait) branch. If there is no other wait branch active, a kill branch is not started at all (rather than being aborted shortly after it is started.) Since a detached branch is unrelated to all other branches, active detached branches do not protect a kill-branch from being aborted. |
| [ActRelationshipJoinDetached](ValueSet-v3-ActRelationshipJoinDetached.md) | Detach this branch from the other branches so it will not be resynchronized with the other branches. |
| [ActRelationshipJoinExclusiveWait](ValueSet-v3-ActRelationshipJoinExclusiveWait.md) | Wait for any one of the branches in the set of exclusive wait branches to terminate, then discontinue all the other exclusive wait branches. |
| [ActRelationshipJoinKill](ValueSet-v3-ActRelationshipJoinKill.md) | When all other concurrent branches are terminated, interrupt and discontinue this branch. |
| [ActRelationshipJoinWait](ValueSet-v3-ActRelationshipJoinWait.md) | Wait for this branch to terminate. |
| [ActRelationshipLimitedBy](ValueSet-v3-ActRelationshipLimitedBy.md) | A relationship that limits or restricts the source act by the elements of the target act. For example, an authorization may be limited by a financial amount (up to $500). Target Act must be in EVN.CRIT mood. |
| [ActRelationshipMaintenanceTreatment](ValueSet-v3-ActRelationshipMaintenanceTreatment.md) | ****No description**** |
| [ActRelationshipMatchesTrigger](ValueSet-v3-ActRelationshipMatchesTrigger.md) | A trigger-match links an actual service (e.g., an observation or procedure that took place) with a service in criterion mood. For example if the trigger is "observation of pain" and pain is actually observed, and if that pain-observation caused the trigger to fire, that pain-observation can be linked with the trigger. |
| [ActRelationshipMitigates](ValueSet-v3-ActRelationshipMitigates.md) | The source act removes or lessens the occurrence or effect of the target act. |
| [ActRelationshipModifies](ValueSet-v3-ActRelationshipModifies.md) | Definition: Used to link a newer version or 'snapshot' of a business object (source) to an older version or 'snapshot' of the same business object (target).**Usage:**The identifier of the Act should be the same for both source and target. If the identifiers are distinct, RPLC should be used instead. Name from source to target = "modifiesPrior" Name from target to source = "modifiesByNew" |
| [ActRelationshipObjective](ValueSet-v3-ActRelationshipObjective.md) | The target act is a desired outcome of the source act. Source is any act (typically an intervention). Target must be an observation in criterion mood. |
| [ActRelationshipOccurrence](ValueSet-v3-ActRelationshipOccurrence.md) | The source act is a single occurrence of a repeatable target act. The source and target act can be in any mood on the "completion track" but the source act must be as far as or further along the track than the target act (i.e., the occurrence of an intent can be an event but not vice versa). |
| [ActRelationshipOutcome](ValueSet-v3-ActRelationshipOutcome.md) | An observation that should follow or does actually follow as a result or consequence of a condition or action (sometimes called "post-condition".) Target must be an observation as a goal, risk or any criterion. For complex outcomes a conjunction attribute |
| [ActRelationshipOverlapsWith](ValueSet-v3-ActRelationshipOverlapsWith.md) | ****No description**** |
| [ActRelationshipPalliates](ValueSet-v3-ActRelationshipPalliates.md) | ****No description**** |
| [ActRelationshipPassiveImmunizationAgainst](ValueSet-v3-ActRelationshipPassiveImmunizationAgainst.md) | ****No description**** |
| [ActRelationshipPertains](ValueSet-v3-ActRelationshipPertains.md) | This is a very unspecific relationship from one item of clinical information to another. It does not judge about the role the pertinent information plays. |
| [ActRelationshipPosting](ValueSet-v3-ActRelationshipPosting.md) | Expresses values for describing the relationship between a FinancialTransaction and an Account. |
| [ActRelationshipProphylaxisOf](ValueSet-v3-ActRelationshipProphylaxisOf.md) | ****No description**** |
| [ActRelationshipProvidesEvidenceFor](ValueSet-v3-ActRelationshipProvidesEvidenceFor.md) | Indicates that the target Act provides evidence in support of the action represented by the source Act. The target is not a 'reason' for the source act, but rather gives supporting information on why the source act is an appropriate course of action. Possible targets might be clinical trial results, journal articles, similar successful therapies, etc.**Rationale:**Provides a mechanism for conveying clinical justification for non-approved or otherwise non-traditional therapies. |
| [ActRelationshipRe-challenge](ValueSet-v3-ActRelationshipRe-challenge.md) | **Description:**A relationship in which the target act is carried out to determine whether an effect attributed to the source act can be recreated. |
| [ActRelationshipReason](ValueSet-v3-ActRelationshipReason.md) | The reason or rationale for a service. A reason link is weaker than a trigger, it only suggests that some service may be or might have been a reason for some action, but not that this reason requires/required the action to be taken. Also, as opposed to the trigger, there is no strong timely relation between the reason and the action.**Discussion:**In prior releases, the code "SUGG" (suggests) was expressed as "an inversion of the reason link." That code has been retired in favor of the inversion indicator that is an attribute of ActRelationship. |
| [ActRelationshipRecovery](ValueSet-v3-ActRelationshipRecovery.md) | **Definition:**The source act is performed to recover from the effects of the target act. |
| [ActRelationshipReferencesOrder](ValueSet-v3-ActRelationshipReferencesOrder.md) | Relates either an appointment request or an appointment to the order for the service being scheduled. |
| [ActRelationshipRefersTo](ValueSet-v3-ActRelationshipRefersTo.md) | A relationship in which the target act is referred to by the source act. This permits a simple reference relationship that distinguishes between the referent and the referee. |
| [ActRelationshipRelievedBy](ValueSet-v3-ActRelationshipRelievedBy.md) | ****No description**** |
| [ActRelationshipReplaces](ValueSet-v3-ActRelationshipReplaces.md) | A replacement source act replaces an existing target act. The state of the target act being replaced becomes obselete, but the act is typically still retained in the system for historical reference. The source and target must be of the same type. |
| [ActRelationshipReverses](ValueSet-v3-ActRelationshipReverses.md) | A relationship between a source Act that seeks to reverse or undo the action of the prior target Act. Example: A posted financial transaction (e.g., a debit transaction) was applied in error and must be reversed (e.g., by a credit transaction) the credit transaction is identified as an undo (or reversal) of the prior target transaction. Constraints: the "completion track" mood of the target Act must be equally or more "actual" than the source act. I.e., when the target act is EVN the source act can be EVN, or any INT. If the target act is INT, the source act can be INT. |
| [ActRelationshipSchedulesRequest](ValueSet-v3-ActRelationshipSchedulesRequest.md) | Associates a specific time (and associated resources) with a scheduling request or other intent. |
| [ActRelationshipSequel](ValueSet-v3-ActRelationshipSequel.md) | An act relationship indicating that the source act follows the target act. The source act should in principle represent the same kind of act as the target. Source and target need not have the same mood code (mood will often differ). The target of a sequel is called antecedent. Examples for sequel relationships are: revision, transformation, derivation from a prototype (as a specialization is a derivation of a generalization), followup, realization, instantiation. |
| [ActRelationshipSplit](ValueSet-v3-ActRelationshipSplit.md) | A code specifying how branches in an action plan are selected among other branches.**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. The splitCode specifies whether a branch is executed exclusively (case-switch) or inclusively, i.e., in parallel with other branches. In addition to exlusive and inclusive split the splitCode specifies how the pre-condition (also known as "guard conditions" on the branch) are evaluated. A guard condition may be evaluated once when the branching step is entered and if the conditions do not hold at that time, the branch is abandoned. Conversely execution of a branch may wait until the guard condition turns true. In exclusive wait branches, the first branch whose guard conditions turn true will be executed and all other branches abandoned. In inclusive wait branches some branches may already be executed while other branches still wait for their guard conditions to turn true. |
| [ActRelationshipSplitExclusiveTryOnce](ValueSet-v3-ActRelationshipSplitExclusiveTryOnce.md) | The pre-condition associated with the branch is evaluated once and if true the branch may be entered. All other exclusive branches compete with each other and only one will be selected. This implements a COND, IF and CASE conditionals, or "XOR-split." The order in which the branches are considered may be specified in the priorityNumber attribute. |
| [ActRelationshipSplitExclusiveWait](ValueSet-v3-ActRelationshipSplitExclusiveWait.md) | A branch is selected as soon as the pre-condition associated with the branch evaluates to true. If the condition is false, the branch may be entered later, when the condition turns true. All other exclusive branches compete with each other and only one will be selected. Each waiting branch executes in parallel with the default join code wait (see below). The order in which the branches are considered may be specified in the Service_relationship.priority_nmb. |
| [ActRelationshipSplitInclusiveTryOnce](ValueSet-v3-ActRelationshipSplitInclusiveTryOnce.md) | A branch is executed if its associated preconditions permit. If associated preconditions do not permit, the branch is dropped. Inclusive branches are not suppressed and do not suppress other branches. |
| [ActRelationshipSplitInclusiveWait](ValueSet-v3-ActRelationshipSplitInclusiveWait.md) | A branch is executed as soon as its associated conditions permit. If the condition is false, the branch may be entered later, when the condition turns true. Inclusive branches are not suppressed and do not suppress other branches. Each waiting branch executes in parallel with the default join code wait (see below). |
| [ActRelationshipStartAfterStartOfContainsEndOf](ValueSet-v3-ActRelationshipStartAfterStartOfContainsEndOf.md) | ****No description**** |
| [ActRelationshipStartsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterEndOf.md) | **Description:**A relationship in which the target act takes place with a defined temporal relationship with respect to the time at which the source act terminates. |
| [ActRelationshipStartsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithEndOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithStartOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsAfterStartOf](ValueSet-v3-ActRelationshipStartsAfterStartOf.md) | The source Act starts after the start of the target Act (i.e. if we say "ActOne SAS ActTwo", it means that ActOne starts after the start of ActTwo, therefore ActOne is the source and ActTwo is the target). |
| [ActRelationshipStartsAfterStartOfEndsWith](ValueSet-v3-ActRelationshipStartsAfterStartOfEndsWith.md) | ****No description**** |
| [ActRelationshipStartsAfterStartofEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterStartofEndsAfterEndOf.md) | ****No description**** |
| [ActRelationshipStartsBeforeEnd](ValueSet-v3-ActRelationshipStartsBeforeEnd.md) | The source Act starts after the end of the target Act (i.e. if we say "ActOne SBE ActTwo", it means that ActOne starts before the end of ActTwo, therefore ActOne is the source and ActTwo is the target). |
| [ActRelationshipStartsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithEndOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithStartOf.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsBeforeStartOf](ValueSet-v3-ActRelationshipStartsBeforeStartOf.md) | ****No description**** |
| [ActRelationshipStartsBeforeStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsBeforeEndOf.md) | ****No description**** |
| [ActRelationshipStartsBeforeStartOfEndsWith](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsWith.md) | ****No description**** |
| [ActRelationshipStartsConcurrentWith](ValueSet-v3-ActRelationshipStartsConcurrentWith.md) | ****No description**** |
| [ActRelationshipStartsConcurrentWithEnd](ValueSet-v3-ActRelationshipStartsConcurrentWithEnd.md) | The source Act starts when the target act ends (i.e. if we say "ActOne SCWE ActTwo", it means that ActOne starts when ActTwo ends, therefore ActOne is the source and ActTwo is the target). |
| [ActRelationshipStartsDuring](ValueSet-v3-ActRelationshipStartsDuring.md) | ****No description**** |
| [ActRelationshipStartsNearEnd](ValueSet-v3-ActRelationshipStartsNearEnd.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsNearStart](ValueSet-v3-ActRelationshipStartsNearStart.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipStartsWithEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsWithEndsAfterEndOf.md) | ****No description**** |
| [ActRelationshipStartsWithEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsWithEndsBeforeEndOf.md) | ****No description**** |
| [ActRelationshipSubset](ValueSet-v3-ActRelationshipSubset.md) | Used to indicate that the target of the relationship will be a filtered subset of the total related set of targets. Used when there is a need to limit the number of components to the first, the last, the next, the total, the average or some other filtered or calculated subset. |
| [ActRelationshipSucceeds](ValueSet-v3-ActRelationshipSucceeds.md) | **Definition:**A new act that carries forward the intention of the original act, but does not completely replace it. The status of the predecessor act must be 'completed'. The original act is the target act and the successor is the source act. |
| [ActRelationshipSummarizedBy](ValueSet-v3-ActRelationshipSummarizedBy.md) | An act that contains summary values for a list or set of subordinate acts. For example, a summary of transactions for a particular accounting period. |
| [ActRelationshipSymptomaticRelief](ValueSet-v3-ActRelationshipSymptomaticRelief.md) | Used in the diagnosis of the indicated disease. |
| [ActRelationshipTemporallyPertains](ValueSet-v3-ActRelationshipTemporallyPertains.md) | ****No description**** |
| [ActRelationshipTemporallyPertainsApproximates](ValueSet-v3-ActRelationshipTemporallyPertainsApproximates.md) | Pro-forma value set for each head code in the ActRelationshipType code system; all codes present and future below the head code. |
| [ActRelationshipTemporallyPertainsEnd](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md) | ****No description**** |
| [ActRelationshipTemporallyPertainsStart](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md) | ****No description**** |
| [ActRelationshipTransformation](ValueSet-v3-ActRelationshipTransformation.md) | Used when the target Act is a transformation of the source Act. (For instance, used to show that a CDA document is a transformation of a DICOM SR document.) |
| [ActRelationshipTreats](ValueSet-v3-ActRelationshipTreats.md) | ****No description**** |
| [ActRelationshipType](ValueSet-v3-ActRelationshipType.md) | A code specifying the meaning and purpose of every ActRelationship instance. Each of its values implies specific constraints to what kinds of Act objects can be related and in which way.**Discussion:**The types of act relationships fall under one of 5 categories: 1.) (De)-composition, with composite (source) and component (target) 2.) Sequel which includes follow-up, fulfillment, instantiation, replacement, transformation, etc. that all have in common that source and target are Acts of essentially the same kind but with variances in mood and other attributes, and where the target exists before the source and the source refers to the target that it links back to. 3.) Pre-condition, trigger, reason, contraindication, with the conditioned Act at the source and the condition or reason at the target. 4.) Post-condition, outcome, goal and risk, with the Act at the source having the outcome or goal at the target. 5.) A host of functional relationships including support, cause, derivation, etc. generalized under the notion of "pertinence". |
| [ActRelationshipUpdate](ValueSet-v3-ActRelationshipUpdate.md) | **Description:****Deprecation Comment:**Was mis-named, and a proper representation has been provided. Replaced by value set ActRelationshipCompliesWith. |
| [ActRelationshipUpdatesCondition](ValueSet-v3-ActRelationshipUpdatesCondition.md) | A condition thread relationship specifically links condition nodes together to form a condition thread. The source is the new condition node and the target links to the most recent node of the existing condition thread. |
| [ActRelationshipUses](ValueSet-v3-ActRelationshipUses.md) | ****No description**** |
| [ActResearchInformationAccess](ValueSet-v3-ActResearchInformationAccess.md) | **Definition:**Consent to have healthcare information in an electronic health record accessed for research purposes. |
| [ActShortStayEncounterCode](ValueSet-v3-ActShortStayEncounterCode.md) | **Definition:**An encounter where the patient is admitted to a health care facility for a predetermined length of time, usually less than 24 hours. |
| [ActSpecObsCode](ValueSet-v3-ActSpecObsCode.md) | Identifies the type of observation that is made about a specimen that may affect its processing, analysis or further result interpretation |
| [ActSpecObsDilutionCode](ValueSet-v3-ActSpecObsDilutionCode.md) | An observation that reports the dilution of a sample. |
| [ActSpecObsInterferenceCode](ValueSet-v3-ActSpecObsInterferenceCode.md) | An observation that relates to factors that may potentially cause interference with the observation |
| [ActSpecObsVolumeCode](ValueSet-v3-ActSpecObsVolumeCode.md) | An observation that reports the volume of a sample. |
| [ActSpecimenTreatmentCode](ValueSet-v3-ActSpecimenTreatmentCode.md) | Set of codes related to specimen treatments |
| [ActStatus](ValueSet-v3-ActStatus.md) | Contains the names (codes) for each of the states in the state-machine of the RIM Act class. |
| [ActStatusAborted](ValueSet-v3-ActStatusAborted.md) | The Act has been terminated prior to the originally intended completion. |
| [ActStatusAbortedCancelledCompleted](ValueSet-v3-ActStatusAbortedCancelledCompleted.md) | **Description:**The status of an assessment for indications of an abnormal condition. |
| [ActStatusActive](ValueSet-v3-ActStatusActive.md) | The Act can be performed or is being performed |
| [ActStatusActiveAborted](ValueSet-v3-ActStatusActiveAborted.md) | ** none supplied ** |
| [ActStatusActiveSuspendedObsolete](ValueSet-v3-ActStatusActiveSuspendedObsolete.md) | ** none supplied ** |
| [ActStatusCancelled](ValueSet-v3-ActStatusCancelled.md) | The Act has been abandoned before activation. |
| [ActStatusCompleted](ValueSet-v3-ActStatusCompleted.md) | An Act that has terminated normally after all of its constituents have been performed. |
| [ActStatusHeld](ValueSet-v3-ActStatusHeld.md) | An Act that is still in the preparatory stages has been put aside. No action can occur until the Act is released. |
| [ActStatusNew](ValueSet-v3-ActStatusNew.md) | An Act that is in the preparatory stages and may not yet be acted upon |
| [ActStatusNormal](ValueSet-v3-ActStatusNormal.md) | Encompasses the expected states of an Act, but excludes "nullified" and "obsolete" which represent unusual terminal states for the life-cycle. |
| [ActStatusNullified](ValueSet-v3-ActStatusNullified.md) | This Act instance was created in error and has been 'removed' and is treated as though it never existed. A record is retained for audit purposes only. |
| [ActStatusObsolete](ValueSet-v3-ActStatusObsolete.md) | This Act instance has been replaced by a new instance. |
| [ActStatusSuspended](ValueSet-v3-ActStatusSuspended.md) | An Act that has been activated (actions could or have been performed against it), but has been temporarily disabled. No further action should be taken against it until it is released |
| [ActSubstanceAdminSubstitutionCode](ValueSet-v3-ActSubstanceAdminSubstitutionCode.md) | ****No description**** |
| [ActSubstanceAdministrationCode](ValueSet-v3-ActSubstanceAdministrationCode.md) | Describes the type of substance administration being performed. |
| [ActSubstanceAdministrationImmunizationCode](ValueSet-v3-ActSubstanceAdministrationImmunizationCode.md) | The introduction of an immunogen with the intent of stimulating an immune response, aimed at preventing subsequent infections by more viable agents. |
| [ActSuppliedItemDetectedIssueCode](ValueSet-v3-ActSuppliedItemDetectedIssueCode.md) | Identifies types of detected issues regarding the administration or supply of an item to a patient. |
| [ActSupplyFulfillmentRefusalReason](ValueSet-v3-ActSupplyFulfillmentRefusalReason.md) | Indicates why a fulfiller refused to fulfill a supply order, and considered it important to notify other providers of their decision. E.g. "Suspect fraud", "Possible abuse", "Contraindicated". (used when capturing 'refusal to fill' annotations) |
| [ActTaskClinicalNoteEntryCode](ValueSet-v3-ActTaskClinicalNoteEntryCode.md) | A clinician enters a clinical note about a given patient |
| [ActTaskClinicalNoteReviewCode](ValueSet-v3-ActTaskClinicalNoteReviewCode.md) | A person reviews a clinical note of a given patient. |
| [ActTaskCode](ValueSet-v3-ActTaskCode.md) | **Description:**A task or action that a user may perform in a clinical information system. |
| [ActTaskMedicationListReviewCode](ValueSet-v3-ActTaskMedicationListReviewCode.md) | A person reviews a list of medication orders submitted to a given patient |
| [ActTaskMicrobiologyResultsReviewCode](ValueSet-v3-ActTaskMicrobiologyResultsReviewCode.md) | A person reviews a list of microbiology results of a given patient. |
| [ActTaskOrderEntryCode](ValueSet-v3-ActTaskOrderEntryCode.md) | ****No description**** |
| [ActTaskPatientDocumentationCode](ValueSet-v3-ActTaskPatientDocumentationCode.md) | A person enters documentation about a given patient. |
| [ActTaskPatientInformationReviewCode](ValueSet-v3-ActTaskPatientInformationReviewCode.md) | A person (e.g., clinician, the patient herself) reviews patient information in the electronic medical record. |
| [ActTaskRiskAssessmentInstrumentCode](ValueSet-v3-ActTaskRiskAssessmentInstrumentCode.md) | A person reviews a Risk Assessment Instrument report of a given patient. |
| [ActTherapyDurationWorkingListCode](ValueSet-v3-ActTherapyDurationWorkingListCode.md) | Codes used to identify different types of 'duration-based' working lists. Examples include "Continuous/Chronic", "Short-Term" and "As-Needed". |
| [ActTransportationModeCode](ValueSet-v3-ActTransportationModeCode.md) | Characterizes how a transportation act was or will be carried out.**Examples:**Via private transport, via public transit, via courier. |
| [ActUSPrivacyLaw](ValueSet-v3-ActUSPrivacyLaw.md) | ****Deprecation Comment:****Content moved to ActCode, and is now represented in value set ActPrivacyLaw. |
| [ActUncertainty](ValueSet-v3-ActUncertainty.md) | A code indicating whether the Act statement as a whole, with its subordinate components has been asserted to be uncertain in any way.**Examples:**Patient might have had a cholecystectomy procedure in the past (but isn't sure).**Constraints:**Uncertainty asserted using this attribute applies to the combined meaning of the Act statement established by all descriptive attributes (e.g., Act.code, Act.effectiveTime, Observation.value, SubstanceAdministration.doseQuantity, etc.), and the meanings of any components.**Discussion:**This is not intended for use to replace or compete with uncertainty associated with a Observation.values alone or other individual attributes of the class. Such pointed indications of uncertainty should be specified by applying the PPD, UVP or UVN data type extensions to the specific attribute. Particularly if the uncertainty is uncertainty of a quantitative measurement value, this must still be represented by a PPD<PQ> in the value and NOT using the uncertaintyCode. Also, when differential diagnoses are enumerated or weighed for probability, the UVP<CD> or UVN<CD> must be used, not the uncertaintyCode. The use of the uncertaintyCode is appropriate only if the entirety of the Act and its dependent Acts is questioned. Note that very vague uncertainty may be thought related to negationInd, however, the two concepts are really independent. One may be very uncertain about an event, but that does not mean that one is certain about the negation of the event. |
| [ActVirtualEncounterCode](ValueSet-v3-ActVirtualEncounterCode.md) | **Definition:**A patient encounter where the patient and the practitioner(s) are not in the same physical location. Examples include telephone conference, email exchange, robotic surgery, and televideo conference. |
| [Action Participant Role](ValueSet-action-participant-role.md) | Either a practitioner role or a relationship type. Note from UTG import - may have been a temporary entry that subsequently disappeared from the FHIR source; unable to locate. Version set to 0.1.0 |
| [ActionType](ValueSet-action-type.md) | The type of action to be performed. |
| [ActivityDefinitionCategory](ValueSet-activity-definition-category.md) | High-level categorization of the type of activity. |
| [AdditionalLocator](ValueSet-v3-AdditionalLocator.md) | This can be a unit designator, such as apartment number, suite number, or floor. There may be several unit designators in an address (e.g., "3rd floor, Appt. 342".) This can also be a designator pointing away from the location (e.g. Across the street from). |
| [AddressLine](ValueSet-v3-AddressLine.md) | **Description:**An address line is for either an additional locator, a delivery address or a street address. |
| [AddressPartType](ValueSet-v3-AddressPartType.md) | Discussion: The hierarchical nature of these concepts shows composition. E.g. "Street Name" is part of "Street Address Line" |
| [AddressRepresentationUse](ValueSet-v3-AddressRepresentationUse.md) | **Description:**Identifies the different representations of a Address. The representation may affect how the address is used. (E.g. use of Ideographic for formal communications.) |
| [AddressUse](ValueSet-v3-AddressUse.md) | ****No description**** |
| [AdjudicatedWithAdjustments](ValueSet-v3-AdjudicatedWithAdjustments.md) | The invoice element has been accepted for payment but one or more adjustment(s) have been made to one or more invoice element line items (component charges). Also includes the concept 'Adjudicate as zero' and items not covered under a particular Policy. Invoice element can be reversed (nullified). Recommend that the invoice element is saved for DUR (Drug Utilization Reporting). |
| [Adjudication Reason Codes](ValueSet-adjudication-reason.md) | This value set includes smattering of Adjudication Reason codes. |
| [Adjudication Value Codes](ValueSet-adjudication.md) | This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc. |
| [AdjudicationError](ValueSet-adjudication-error.md) | This value set includes a smattering of adjudication codes. |
| [AdministrableDrugForm](ValueSet-v3-AdministrableDrugForm.md) | Indicates the form in which the drug product should be administered. This element only needs to be specified when (a) the form in which the drug is measured for dispensing differs from the form in which the drug is administered; and (b) the form in which the quantity of the administered drug being administered is not expressed as a discrete measured mass or volume.**Usage:** |
| [AdministrationDetectedIssueCode](ValueSet-v3-AdministrationDetectedIssueCode.md) | Administration of the proposed therapy may be inappropriate or contraindicated as proposed |
| [AdministrationMedicalDevice](ValueSet-v3-AdministrationMedicalDevice.md) | A device intended to administer a substance to a subject |
| [AdministrativeContactRoleType](ValueSet-v3-AdministrativeContactRoleType.md) | A role type that is used to further qualify an entity playing a role where the role class attribute is set to RoleClassCommissioningParty. |
| [AdministrativeGender](ValueSet-v3-AdministrativeGender.md) | The gender of a person used for adminstrative purposes (as opposed to clinical gender) |
| [Admit source](ValueSet-encounter-admit-source.md) | This value set defines a set of codes that can be used to indicate from where the patient came in. |
| [AdoptedChild](ValueSet-v3-AdoptedChild.md) | The player of the role is a child taken into a family through legal means and raised by the scoping person (parent) as his or her own child. |
| [Adverse Event Clinical Research Causality Relatedness](ValueSet-adverse-event-clinical-research-causality-relatedness.md) | Value set for stating if a suspected entity is Not Related, Unlikely Related, Possibly Related, or Related to the cause of the adverse event. Using NCI codes. The values originate with ICH. For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document |
| [Adverse Event Clinical Research Grades](ValueSet-adverse-event-clinical-research-grades.md) | Value set of grades used in Adverse Event Clinical Research, especially in Oncology clinical trials |
| [Adverse Event Clinical Research Outcomes](ValueSet-adverse-event-clinical-research-outcomes.md) | This value set includes codes that describe the type of outcome from the adverse event as typically used in reporting for Clinical Research, post-market surveillance (e.g. Medwatch forms). NCI codes used here This list originates from the ICH E2B R3 (https://database.ich.org/sites/default/files/E2D_Guideline.pdf), specifically CDISC CL.C66768.OUT. For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document. |
| [Adverse Event Clinical Research Seriousness Criteria](ValueSet-adverse-event-clinical-research-seriousness-criteria.md) | Action criteria usually associated with serious events that pose a threat to a patient's life or functioning. Adverse Events criteria to expand on the seriousness of the adverse event. Typically used in reporting for Clinical Research, post-market surveillance (e.g. Form FDA 3500A MedWatch). The adverse event seriousness criteria value set is based on the ICH E2D Post-Approval Safety Data Management: Definitions and Standards for Expedited Reporting guidance (https://database.ich.org/sites/default/files/E2D_Guideline.pdf). For information on ICH see https://admin.ich.org/sites/default/files/inline-files/OID_Information_Paper_1.pdf from the INTERNATIONAL CONFERENCE ON HARMONISATION OF TECHNICAL REQUIREMENTS FOR REGISTRATION OF PHARMACEUTICALS FOR HUMAN USE (ICH) document ICH E2B(R3), the Electronic Transmission of Individual Case Safety Reports (ICSRs) Implementation Guide Data Elements and Message Specification, and ICH M8, the Electronic Common Technical Document |
| [AdverseEventCategory](ValueSet-adverse-event-category.md) | Overall categorization of the event, e.g. product-related or situational. |
| [AdverseEventCausalityAssessment](ValueSet-adverse-event-causality-assess.md) | Codes for the assessment of whether the entity caused the event. |
| [AdverseEventCausalityMethod](ValueSet-adverse-event-causality-method.md) | TODO. |
| [AdverseEventSeriousness](ValueSet-adverse-event-seriousness.md) | Overall seriousness of this event for the patient. |
| [AdverseEventSeverity](ValueSet-adverse-event-severity.md) | The severity of the adverse event itself, in direct relation to the subject. |
| [AerosolDrugForm](ValueSet-v3-AerosolDrugForm.md) | ****No description**** |
| [AgeDetectedIssueCode](ValueSet-v3-AgeDetectedIssueCode.md) | Proposed therapy may be inappropriate or contraindicated due to patient age |
| [AgeGroupObservationValue](ValueSet-v3-AgeGroupObservationValue.md) | Observation values used to indicate the age group of a person in terms of age group concept codes. |
| [Aleut](ValueSet-v3-Aleut.md) | ****No description**** |
| [Algic](ValueSet-v3-Algic.md) | ****No description**** |
| [Algonquian](ValueSet-v3-Algonquian.md) | ****No description**** |
| [AlgorithmicDecisionObservationMethod](ValueSet-v3-AlgorithmicDecisionObservationMethod.md) | Reaching a decision through the application of an algorithm designed to weigh the different factors involved. |
| [Allergy Status](ValueSet-v3-AllergyStatus.md) | The clinical status of an allergy disposition (Clinical Focus) Used in Program: C-CDA, C-CDA R2.1 2017-06-09 using this value set |
| [AllergyIntolerance Clinical Status Codes](ValueSet-allergyintolerance-clinical.md) | Preferred value set for AllergyIntolerance Clinical Status. |
| [AllergyIntolerance Verification Status](ValueSet-allergyintolerance-verification.md) | The verification status to support or decline the clinical status of the allergy or intolerance. |
| [AllergyIntoleranceCertainty](ValueSet-reaction-event-certainty.md) | Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event. |
| [AllergyIntoleranceSubstanceExposureRisk](ValueSet-allerg-intol-substance-exp-risk.md) | The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products). |
| [AllergyTestValue](ValueSet-v3-AllergyTestValue.md) | Indicates the result of a particular allergy test. E.g. Negative, Mild, Moderate, Severe |
| [AlternativeCodeKind](ValueSet-codesystem-altcode-kind.md) | Indicates the type of use for which the code is defined. |
| [AlternativeCodeKind](ValueSet-composition-altcode-kind.md) | Indicates the type of use for which the code is defined. |
| [Ambulance](ValueSet-v3-Ambulance.md) | ****No description**** |
| [AmbulanceHIPAA](ValueSet-v3-AmbulanceHIPAA.md) | An emergency vehicle used for transporting patients to a health care facility after injury or illness. Types of ambulances used in the United States include ground (surface) ambulance, rotor-wing (helicopter), and fixed-wing aircraft (airplane). |
| [AmericanIndianAlaskaNativeLanguages](ValueSet-v3-AmericanIndianAlaskaNativeLanguages.md) | ****No description**** |
| [AmnioticFluidSacRoute](ValueSet-v3-AmnioticFluidSacRoute.md) | Amniotic fluid sac |
| [AnnotationType](ValueSet-v3-AnnotationType.md) | ****No description**** |
| [Apachean](ValueSet-v3-Apachean.md) | ****No description**** |
| [ApplicationMediaType](ValueSet-v3-ApplicationMediaType.md) | Application specific media type. |
| [Appointment cancellation reason](ValueSet-appointment-cancellation-reason.md) | This example value set defines a set of reasons for the cancellation of an appointment. |
| [Appropriateness Score](ValueSet-appropriateness-score.md) | The scoring for appropriateness of an action based upon RAND. |
| [AppropriatenessDetectedIssueCode](ValueSet-v3-AppropriatenessDetectedIssueCode.md) | ****No description**** |
| [ArapahoGrosVentre](ValueSet-v3-ArapahoGrosVentre.md) | ****No description**** |
| [Arapahoan](ValueSet-v3-Arapahoan.md) | ****No description**** |
| [Artifact Contribution Instance Type](ValueSet-artifact-contribution-instance-type.md) | Artifact Contribution Instance Type |
| [Artifact Identifier Type](ValueSet-artifact-identifier-type.md) | Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher) |
| [Artifact Relationship Type](ValueSet-artifact-relationship-type.md) | Type of relationship to the related artifact. |
| [Artifact Url Classifier](ValueSet-artifact-url-classifier.md) | Code the reason for different URLs, eg abstract and full-text. |
| [Artifact Version Policy](ValueSet-artifact-version-policy.md) | The versioning policy of an artifact or set of artifacts (metadata or strict) |
| [ArtificialDentition](ValueSet-v3-ArtificialDentition.md) | Artificial dentition, artificial subsitutes for the natural dentition |
| [AskedButUnknown](ValueSet-v3-AskedButUnknown.md) | Information was sought but not found (e.g., patient was asked but didn't know) |
| [AssignedNonPersonLivingSubjectRoleType](ValueSet-v3-AssignedNonPersonLivingSubjectRoleType.md) | **Description:**A role type that is used to further qualify a non-person subject playing a role where the role class attribute is set to RoleClass AssignedEntity |
| [Athapaskan](ValueSet-v3-Athapaskan.md) | ****No description**** |
| [AthapaskanEyak](ValueSet-v3-AthapaskanEyak.md) | ****No description**** |
| [AudioMediaType](ValueSet-v3-AudioMediaType.md) | Audio media type. |
| [Audit Event Outcome](ValueSet-audit-event-outcome.md) | The type of process where the audit event originated from. |
| [Audit Event Source Type](ValueSet-audit-source-type.md) | The type of process where the audit event originated from. |
| [AuditEventEntityRole](ValueSet-object-role.md) | Code representing the role the entity played in the audit event. |
| [AuthorizationIssueManagementCode](ValueSet-v3-AuthorizationIssueManagementCode.md) | ****No description**** |
| [AuthorizedParticipationFunction](ValueSet-v3-AuthorizedParticipationFunction.md) | This code is used to specify the exact function an actor is authorized to have in a service in all necessary detail. |
| [AuthorizedReceiverParticipationFunction](ValueSet-v3-AuthorizedReceiverParticipationFunction.md) | This code is used to specify the exact function an actor is authorized to have as a receiver of information that is the subject of a consent directive or consent override. |
| [AutomobileInsurancePolicy](ValueSet-v3-AutomobileInsurancePolicy.md) | **Definition:**An insurance policy for losses sustained in an automobile accident that typically covers losses incurred by the named insured and parties who may be claimants for losses, such as pedestrians and passengers. |
| [BarDrugForm](ValueSet-v3-BarDrugForm.md) | ****No description**** |
| [BarSoapDrugForm](ValueSet-v3-BarSoapDrugForm.md) | ****No description**** |
| [Basic Resource Types](ValueSet-basic-resource-type.md) | This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR. Many of the codes listed here will eventually be turned into official resources. However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here. Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts. |
| [Benefit Category Codes](ValueSet-ex-benefitcategory.md) | This value set includes examples of Benefit Category codes. |
| [Benefit Term Codes](ValueSet-benefit-term.md) | This value set includes a smattering of Benefit Term codes. |
| [Benefit Type Codes](ValueSet-benefit-type.md) | This value set includes a smattering of Benefit type codes. |
| [Benefit cost applicability](ValueSet-insuranceplan-applicability.md) | Whether the cost applies to in-network or out-of-network providers. |
| [BiliaryRoute](ValueSet-v3-BiliaryRoute.md) | Biliary tract |
| [BindingRealm](ValueSet-v3-BindingRealm.md) | **Description:**All coded binding realms for terminology constraint context binding. |
| [BiotherapeuticNon-personLivingSubjectRoleType](ValueSet-v3-BiotherapeuticNon-personLivingSubjectRoleType.md) | **Description:**Animals, including fish and insects, and microorganisms which may participate as assigned entities in biotherapies. |
| [BlisterPackEntityType](ValueSet-v3-BlisterPackEntityType.md) | A bubblepack. Medications sealed individually, separated into doses. |
| [BodySurfaceRoute](ValueSet-v3-BodySurfaceRoute.md) | Body surface |
| [BottleEntityType](ValueSet-v3-BottleEntityType.md) | A container, typically rounded, either glass or plastic with a narrow neck and capable of storing liquid. |
| [BuccalMucosaRoute](ValueSet-v3-BuccalMucosaRoute.md) | Buccal mucosa |
| [BuccalTablet](ValueSet-v3-BuccalTablet.md) | ****No description**** |
| [BuildingNumber](ValueSet-v3-BuildingNumber.md) | The number of a building, house or lot alongside the street. Also known as "primary street number". This does not number the street but rather the building. |
| [CMS Place of Service Codes (POS)](ValueSet-CMSPlaceOfServiceCodes.md) | This is the all codes value set for the CMS POS code system. |
| [CQL Access Modifier](ValueSet-cql-access-modifier.md) | Access modifiers defined by the Clinical Quality Language (CQL) specification in the[Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers)topic. |
| [CUI](ValueSet-v3-CUI.md) | Information the US Government creates or possesses, or that an entity creates or possesses for or on behalf of the Government, that a law, regulation, or Government-wide policy requires or permits an agency to handle using safeguarding or dissemination controls. Purpose: Supports the selection of the entire ControlledUnclassifiedInformation value set for e.g., rules engine policy set purposes. |
| [CUILabel](ValueSet-v3-CUILabel.md) | Information the US Government creates or possesses, or that an entity creates or possesses for or on behalf of the Government, that a law, regulation, or Government-wide policy requires or permits an agency to handle using safeguarding or dissemination controls Purpose: Supports the selection of ControlledUnclassifiedInformation leaf concepts for use, e.g., in security labels. |
| [CVDiagTherPracticeSetting](ValueSet-v3-CVDiagTherPracticeSetting.md) | A practice setting where cardiovascular diagnostic procedures or therapeutic interventions are performed (e.g., cardiac catheterization lab, echocardiography suite) |
| [Caddoan](ValueSet-v3-Caddoan.md) | ****No description**** |
| [Cahitan](ValueSet-v3-Cahitan.md) | ****No description**** |
| [Calendar](ValueSet-v3-Calendar.md) | ****No description**** |
| [CalendarCycle](ValueSet-v3-CalendarCycle.md) | ****No description**** |
| [CalendarCycleOneLetter](ValueSet-v3-CalendarCycleOneLetter.md) | One letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed) |
| [CalendarCycleTwoLetter](ValueSet-v3-CalendarCycleTwoLetter.md) | Two letter calendar cycle abbreviations (Temporary - remove when RoseTree is fixed) |
| [CalendarType](ValueSet-v3-CalendarType.md) | ****No description**** |
| [CaliforniaAthapaskan](ValueSet-v3-CaliforniaAthapaskan.md) | ****No description**** |
| [Can-push-updates](ValueSet-verificationresult-can-push-updates.md) | Ability of the primary source to push updates/alerts |
| [CapsuleDrugForm](ValueSet-v3-CapsuleDrugForm.md) | A solid dosage form in which the drug is enclosed within either a hard or soft soluble container or "shell" made from a suitable form of gelatin. |
| [CardClinPracticeSetting](ValueSet-v3-CardClinPracticeSetting.md) | ****No description**** |
| [Care Service Accessibility](ValueSet-care-service-accessibility.md) | This value set defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location. |
| [CaseTransmissionMode](ValueSet-v3-CaseTransmissionMode.md) | Code for the mechanism by which disease was acquired by the living subject involved in the public health case. Includes sexually transmitted, airborne, bloodborne, vectorborne, foodborne, zoonotic, nosocomial, mechanical, dermal, congenital, environmental exposure, indeterminate. |
| [CatalogType](ValueSet-catalogType.md) | The type of catalog. |
| [Catawba](ValueSet-v3-Catawba.md) | ****No description**** |
| [CecostomyRoute](ValueSet-v3-CecostomyRoute.md) | Cecostomy |
| [CentralAlaskaYukon](ValueSet-v3-CentralAlaskaYukon.md) | ****No description**** |
| [CentralMuskogean](ValueSet-v3-CentralMuskogean.md) | ****No description**** |
| [CentralNumic](ValueSet-v3-CentralNumic.md) | ****No description**** |
| [CentralSalish](ValueSet-v3-CentralSalish.md) | ****No description**** |
| [CervicalRoute](ValueSet-v3-CervicalRoute.md) | Cervix of the uterus |
| [CharacteristicMethod](ValueSet-characteristic-method.md) | The method used to determine the characteristic(s) of the variable. |
| [ChargeItemCode](ValueSet-chargeitem-billingcodes.md) | Example set of codes that can be used for billing purposes. |
| [Charset](ValueSet-v3-Charset.md) | Internet Assigned Numbers Authority (IANA) Charset Types |
| [Chew](ValueSet-v3-Chew.md) | Chew |
| [Child](ValueSet-v3-Child.md) | The player of the role is a child of the scoping entity. |
| [ChildInLaw](ValueSet-v3-ChildInLaw.md) | The player of the role is the spouse of scoping person's child. |
| [Chimakuan](ValueSet-v3-Chimakuan.md) | ****No description**** |
| [Chinookan](ValueSet-v3-Chinookan.md) | ****No description**** |
| [ChiwereWinnebago](ValueSet-v3-ChiwereWinnebago.md) | ****No description**** |
| [ChoiceListOrientation](ValueSet-choice-list-orientation.md) | Direction in which lists of possible answers should be displayed. |
| [ChronicCareFacility](ValueSet-v3-ChronicCareFacility.md) | (1) A hospital including a physical plant and personnel that provides multidisciplinary diagnosis and treatment for diseases that have one or more of the following characteristics: is permanent; leaves residual disability; is caused by nonreversible pathological alteration; requires special training of the patient for rehabilitation; and/or may be expected to require a long period of supervision or care. In addition, patients require the safety, security, and shelter of these specialized inpatient or partial hospitalization settings. (2) A hospital that provides medical and skilled nursing services to patients with long-term illnesses who are not in an acute phase but who require an intensity of services not available in nursing homes |
| [Citation Artifact Classifier](ValueSet-citation-artifact-classifier.md) | Citation artifact classifier |
| [Citation Classification Type](ValueSet-citation-classification-type.md) | Citation classification type |
| [Citation Summary Style](ValueSet-citation-summary-style.md) | The format for display of the citation. |
| [Cited Artifact Abstract Type](ValueSet-cited-artifact-abstract-type.md) | Used to express the reason and specific aspect for the variant abstract, such as language and specific language. |
| [Cited Artifact Classification Type](ValueSet-cited-artifact-classification-type.md) | Cited Artifact Classification Type |
| [Cited Artifact Contribution Type](ValueSet-cited-artifact-contribution-type.md) | Citation contribution. |
| [Cited Artifact Part Type](ValueSet-cited-artifact-part-type.md) | To describe the reason for the variant citation, such as version number or subpart specification. |
| [Cited Artifact Status Type](ValueSet-cited-artifact-status-type.md) | Cited Artifact Status Type |
| [Cited Medium](ValueSet-cited-medium.md) | NLM codes Internet or Print. |
| [CitizenRoleType](ValueSet-v3-CitizenRoleType.md) | A role type used to qualify a person's legal status within a country or nation.**Examples:*** Full citizen 
* Asylum seeker 
* Permit card holder
 |
| [Claim Care Team Role Codes](ValueSet-claim-careteamrole.md) | Claim roles of the care team members providing products and services. |
| [Claim Information Category Codes](ValueSet-claim-informationcategory.md) | This value set includes sample Information Category codes. |
| [Claim Type Codes](ValueSet-claim-type.md) | This value set includes Claim Type codes. |
| [ClaimPayeeResourceType](ValueSet-ex-payee-resource-type.md) | The type of Claim payee Resource. |
| [ClaimantCoveredPartyRoleType](ValueSet-v3-ClaimantCoveredPartyRoleType.md) | **Description**A role recognized through the eligibility of a party play a claimant for benefits covered or provided under an insurance policy. |
| [ClassNullFlavor](ValueSet-v3-ClassNullFlavor.md) | **Description:**Subset of null flavors, used for associations as needed for the ITS, and used in InfrastructureRoot. |
| [Clinical Discharge Disposition](ValueSet-clinical-discharge-disposition.md) | This value set defines a set of codes that can be used to where the patient left the hospital. Note that this value set explicitly removes 'oth' (Other) to allow the binding strength to be extensible and therefore allow the exchange of additional concepts without requiring mapping to 'oth.' |
| [ClinicalResearchEventReason](ValueSet-v3-ClinicalResearchEventReason.md) | **Definition:**Specifies the reason that an event occurred in a clinical research study. |
| [ClinicalResearchObservationReason](ValueSet-v3-ClinicalResearchObservationReason.md) | **Definition:**SSpecifies the reason that a test was performed or observation collected in a clinical research study.**Note:**This set of codes are not strictly reasons, but are used in the currently Normative standard. Future revisions of the specification will model these as ActRelationships and thes codes may subsequently be retired. Thus, these codes should not be used for new specifications. |
| [ClinicalResearchReason](ValueSet-v3-ClinicalResearchReason.md) | **Definition:**Contains domains for act reasons used in clinical research. |
| [CochimiYuman](ValueSet-v3-CochimiYuman.md) | ****No description**** |
| [CodeIsNotValid](ValueSet-v3-CodeIsNotValid.md) | ****No description**** |
| [CodeSystem](ValueSet-v3-CodeSystem.md) | Code systems used in HL7 standards. |
| [CodeSystemType](ValueSet-v3-CodeSystemType.md) | How a code system is maintained by HL7 |
| [CodingRationale](ValueSet-v3-CodingRationale.md) | Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Since HL7 (or a government body) may mandate that codes from certain code systems be sent in conformant messages, other synonyms that are sent in the translation set need to be distinguished among the originally captured source, the HL7 specified code, or some future role. When this code is NULL, it indicates that the translation is an undefined type. When valued, this property must contain one of the following values: SRC - Source (or original) code HL7 - HL7 Specified or Mandated SH - both HL7 mandated and the original code (precoordination) There may be additional values added to this value set as we work through the use of codes in messages and determine other Use Cases requiring special interpretation of the translations. |
| [CombinedPharmacyOrderSuspendReasonCode](ValueSet-v3-CombinedPharmacyOrderSuspendReasonCode.md) | **Description:**Indicates why the prescription should be suspended. |
| [Common Tags](ValueSet-common-tags.md) | Common Tag Codes defined by FHIR project |
| [Common UCUM units](ValueSet-ucum-common.md) | Commonly encountered UCUM units (for purposes of helping populate look ups). |
| [CommunicationCategory](ValueSet-communication-category.md) | Codes for general categories of communications such as alerts, instructions, etc. |
| [CommunicationFunctionType](ValueSet-v3-CommunicationFunctionType.md) | Describes the type of communication function that the associated entity plays in the associated transmission. |
| [CommunicationNotDoneReason](ValueSet-communication-not-done-reason.md) | Codes for the reason why a communication did not happen. |
| [CommunicationTopic](ValueSet-communication-topic.md) | Codes describing the purpose or content of the communication. |
| [Compartment](ValueSet-v3-Compartment.md) | A named tag set for metadata used to populate a security category label field that "segments" an IT resource per policy by indicating that access and use is restricted to members of a defined community or project. (HL7 Healthcare Privacy and Security Classification System)**Usage Note:**This is the healthcare analog to the US Intelligence Community's concept of a Special Access Program. Compartment codes may be used in as a field value in an initiator's clearance to indicate permission to access and use an IT Resource with a security label having the same compartment value in security category label field. Map: Aligns with ISO 2382-8 definition of Compartment - "A division of data into isolated blocks with separate security controls for the purpose of reducing risk." |
| [ComplianceAlert](ValueSet-v3-ComplianceAlert.md) | ****No description**** |
| [ComplianceDetectedIssueCode](ValueSet-v3-ComplianceDetectedIssueCode.md) | There may be an issue with the patient complying with the intentions of the proposed therapy |
| [CompliancePackageEntityType](ValueSet-v3-CompliancePackageEntityType.md) | A container intended to contain sufficient material for more than one use, but grouped or organized to provide individual access to sufficient material for a single use. Often used to ensure that the proper type and amount of material is consumed/expended for each use. |
| [CompositeMeasureScoring](ValueSet-composite-measure-scoring.md) | The composite scoring method of the measure. |
| [CompositeMeasureScoring](ValueSet-v3-CompositeMeasureScoring.md) | Observation values that communicate the method used in a quality measure to combine the component measure results that are included in a composite measure.**Steward:**CQI WG |
| [CompressionAlgorithm](ValueSet-v3-CompressionAlgorithm.md) | ****No description**** |
| [ConceptPropertyId](ValueSet-v3-ConceptPropertyId.md) | Property identifiers for a concept code |
| [Condition Category Codes](ValueSet-condition-category.md) | Preferred value set for Condition Categories. |
| [Condition Clinical Status Codes](ValueSet-condition-clinical.md) | Preferred value set for Condition Clinical Status. |
| [ConditionDetectedIssueCode](ValueSet-v3-ConditionDetectedIssueCode.md) | Proposed therapy may be inappropriate or contraindicated due to an existing/recent patient condition or diagnosis |
| [ConditionState](ValueSet-condition-state.md) | Enumeration indicating whether the condition is currently active, inactive, or has been resolved. |
| [ConditionVerificationStatus](ValueSet-condition-ver-status.md) | The verification status to support or decline the clinical status of the condition or diagnosis. |
| [Conditional](ValueSet-v3-Conditional.md) | Some conditions may be attached to an allowable substitution. An allowable substitution is based on a match to any other attributes that may be specified. |
| [Confidentiality](ValueSet-v2-0952.md) | Concepts drawn from the HL7 V3 Confidentiality code system . Used in Version 2 messaging in the Security Classification elements in the Message Header segment (MSH) and the Access Restrictions segment (ARV). |
| [Confidentiality](ValueSet-v3-Confidentiality.md) | Set of codes used to value Act.Confidentiality and Role.Confidentiality attribute in accordance with the definition for concept domain "Confidentiality". |
| [ConfidentialityModifiers](ValueSet-v3-ConfidentialityModifiers.md) | Modifiers of role based access rights (multiple allowed)**Usage Note:**All codes that are referenced by this value set were retired as of the November 2013 Harmonization cycle. Guidance for what to use instead of the v:ConfidentialityModifers leaf concepts: celebrity, sensitive, and taboo: These codes have been revised and are now included under v:ActCode at:* V:ActInformationSensitivityPolicy:2.16.840.1.113883.1.11.20429 - taboo 
* V:InformationSensitivityPolicy:2.16.840.1.113883.1.11.20428 - celebrity/VIP and patient requested sensitivity
 |
| [ConformanceExpectation](ValueSet-conformance-expectation.md) | Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification. |
| [Consent Action Codes](ValueSet-consent-action.md) | This value set includes sample Consent Action codes. |
| [Consent PolicyRule Codes](ValueSet-consent-policy.md) | This value set includes sample Regulatory consent policy types from the US and other regions. |
| [Consent Scope Codes](ValueSet-consent-scope.md) | This value set includes the four Consent scope codes. |
| [Consent Verification Codes](ValueSet-consent-verification.md) | This value set includes base Consent Verification codes. |
| [ConsenterParticipationFunction](ValueSet-v3-ConsenterParticipationFunction.md) | This code is used to specify the exact function an actor is authorized to have in authoring a consent directive. |
| [ConsultedPrescriberManagementCode](ValueSet-v3-ConsultedPrescriberManagementCode.md) | Consulted prescriber, therapy confirmed |
| [Contact entity type](ValueSet-contactentity-type.md) | This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party. |
| [ContactRoleType](ValueSet-v3-ContactRoleType.md) | Types of contact for Role code "CON" |
| [ContainerCap](ValueSet-container-cap.md) | Color of the container cap. |
| [ContainerCap](ValueSet-v3-ContainerCap.md) | The type of cap associated with a container |
| [ContainerEntityType](ValueSet-v3-ContainerEntityType.md) | Material intended to hold another material for purpose of storage or transport. |
| [ContainerSeparator](ValueSet-v3-ContainerSeparator.md) | A material in a blood collection container that facilites the separation of of blood cells from serum or plasma |
| [ContentProcessingMode](ValueSet-v3-ContentProcessingMode.md) | **Description:**Identifies the order in which content should be processed. |
| [ContextConductionStyle](ValueSet-v3-ContextConductionStyle.md) | ****No description**** |
| [ContextControl](ValueSet-v3-ContextControl.md) | A code that specifies how an ActRelationship or Participation contributes to the context of an Act, and whether it may be propagated to descendent Acts whose association allows such propagation (see also attributes Participation.contextControlCode, ActRelationship.contextControlCode, ActRelationship.contextConductionInd). |
| [ContextControlAdditive](ValueSet-v3-ContextControlAdditive.md) | The association adds to the existing context associated with the Act. Both this association and any associations propagated from ancestor Acts are interpreted as being related to this Act. |
| [ContextControlAdditiveNon-propagating](ValueSet-v3-ContextControlAdditiveNon-propagating.md) | The association adds to the existing context associated with the Act, but will not propagate to any descendant Acts reached by conducting ActRelationships (see contextControlCode). Examples: If an 'Author' Participation were marked as "Additive, Non-Propagating" it means that the author will be added to the set of author participations that have propagated from ancestor Acts for the purpose of this Act. However only the previously propagated authors will propagate to any child Acts that allow context to be propagated. |
| [ContextControlAdditivePropagating](ValueSet-v3-ContextControlAdditivePropagating.md) | The association adds to the existing context associated with the Act, and will propagate to any descendant Acts reached by conducting ActRelationships (see contextControlCode). Examples: If an 'Author' Participation were marked as "Additive, Propagating" it means that the author will be added to the set of author participations that have propagated from ancestor Acts, and will itself propagate with the other authors to any child Acts that allow context to be propagated. |
| [ContextControlNonPropagating](ValueSet-v3-ContextControlNonPropagating.md) | The association applies only to the current Act and will not propagate to any child Acts that are related via a conducting ActRelationship (refer to contextConductionInd). |
| [ContextControlOverriding](ValueSet-v3-ContextControlOverriding.md) | The association adds to the existing context associated with the Act, but replaces associations propagated from ancestor Acts whose typeCodes are the same. |
| [ContextControlOverridingNon-propagating](ValueSet-v3-ContextControlOverridingNon-propagating.md) | The association is added to the existing context associated with the Act, but overrides an association with the same typeCode. However, this overriding association will not propagate to any descendant Acts reached by conducting ActRelationships (see contextControlCode). Examples: If an 'Author' Participation were marked as "Overriding, Non-Propagating" it means that the author will replace the set of author participations that have propagated from ancestor Acts. Furthermore, no author participations whatsoever will propagate to any child Acts that allow context to be propagated. |
| [ContextControlOverridingPropagating](ValueSet-v3-ContextControlOverridingPropagating.md) | The association is added to the existing context associated with the Act, but overrides an association with the same typeCode. This overriding association will propagate to any descendant Acts reached by conducting ActRelationships (see contextControlCode). Examples: If an 'Author' Participation were marked as "Overriding, Propagating" it means that the author will replace the set of author participations that have propagated from ancestor Acts, and will itself be the only author to propagate to any child Acts that allow context to be propagated. |
| [ContextControlPropagating](ValueSet-v3-ContextControlPropagating.md) | The association propagates to any child Acts that are related via a conducting ActRelationship (refer to contextConductionInd). |
| [Contract Action Codes](ValueSet-contract-action.md) | This value set includes sample Contract Action codes. |
| [Contract Actor Role Codes](ValueSet-contract-actorrole.md) | This value set includes sample Contract Actor Role codes. |
| [Contract Content Derivation Codes](ValueSet-contract-content-derivative.md) | This is an example set of Content Derivative type codes, which represent the minimal content derived from the basal information source at a specific stage in its lifecycle, which is sufficient to manage that source information, for example, in a repository, registry, processes and workflows, for making access control decisions, and providing query responses. |
| [Contract Signer Type Codes](ValueSet-contract-signer-type.md) | This value set includes sample Contract Signer Type codes. |
| [Contract Subtype Codes](ValueSet-contract-subtype.md) | This value set includes sample Contract Subtype codes. |
| [Contract Term Subtype Codes](ValueSet-contract-term-subtype.md) | This value set includes sample Contract Term SubType codes. |
| [Contract Term Type Codes](ValueSet-contract-term-type.md) | This value set includes sample Contract Term Type codes. |
| [Contract Type Codes](ValueSet-contract-type.md) | This value set includes sample Contract Type codes. |
| [ContractDataMeaning](ValueSet-contract-data-meaning.md) | How a resource reference is interpreted when evaluating contract offers. |
| [Contributor Role](ValueSet-contributor-role.md) | Used to code the format of the display string. |
| [Contributor Summary Source](ValueSet-contributor-summary-source.md) | Used to code the producer or rule for creating the display string. |
| [Contributor Summary Style](ValueSet-contributor-summary-style.md) | Used to code the format of the display string. |
| [Contributor Summary Type](ValueSet-contributor-summary-type.md) | Used to code author list statement, contributorship statement, and such. |
| [ControlActNullificationReasonCode](ValueSet-v3-ControlActNullificationReasonCode.md) | **Description:**Identifies reasons for nullifying (retracting) a particular control act.**Examples:**"Entered in error", "altered decision", etc. |
| [ControlActNullificationRefusalReasonType](ValueSet-v3-ControlActNullificationRefusalReasonType.md) | ****No description**** |
| [ControlActReason](ValueSet-v3-ControlActReason.md) | Identifies why a specific query, request, or other trigger event occurred. |
| [ControlledSubstanceMonitoringProtocol](ValueSet-v3-ControlledSubstanceMonitoringProtocol.md) | A monitoring program that focuses on narcotics and/or commonly abused substances that are subject to legal restriction. |
| [Coosan](ValueSet-v3-Coosan.md) | ****No description**** |
| [CopyNumberEvent](ValueSet-copy-number-event.md) | Copy Number Event. |
| [Country](ValueSet-v3-Country.md) | Countries of the world. ISO 3166, part 1, alpha-3 set. |
| [Country2](ValueSet-v3-Country2.md) | Countries of the world. ISO 3166, part 1, alpha-2 set. |
| [CountryEntityType](ValueSet-v3-CountryEntityType.md) | A set of codes identifying specific countries. |
| [Coverage Class Codes](ValueSet-coverage-class.md) | This value set includes Coverage Class codes. |
| [Coverage Copay Type Codes](ValueSet-coverage-copay-type.md) | This value set includes sample Coverage Copayment Type codes. |
| [Coverage SelfPay Codes](ValueSet-coverage-selfpay.md) | This value set includes Coverage SelfPay codes. |
| [CoverageEligibilityReason](ValueSet-v3-CoverageEligibilityReason.md) | **Description:**Identifies the reason or rational for why a person is eligible for benefits under an insurance policy or program.**Examples:**A new employee is eligible for health insurance as an employment benefit. A person meets eligibility criteria for government program coverage based on financial, age or health status. |
| [CoverageEligibilityResponse Auth Support Codes](ValueSet-coverageeligibilityresponse-ex-auth-support.md) | This value set includes CoverageEligibilityResponse Auth Support codes. |
| [CoverageLevelObservationValue](ValueSet-v3-CoverageLevelObservationValue.md) | **Description:**Coded observation values for types of covered parties under a policy or program based on their personal relationships or employment status. |
| [CoverageLimitObservationValue](ValueSet-v3-CoverageLimitObservationValue.md) | **Description:**Coded observation values for coverage limitations, for e.g., types of claims or types of parties covered under a policy or program. |
| [CoverageParticipationFunction](ValueSet-v3-CoverageParticipationFunction.md) | **Definition:**Set of codes indicating the manner in which sponsors, underwriters, and payers participate in a policy or program. |
| [CoverageRoleType](ValueSet-v3-CoverageRoleType.md) | Role recognized through the issuance of insurance coverage to an identified covered party who has this relationship with the policy holder such as the policy holder themselves (self), spouse, child, etc |
| [CoverageSponsorRoleType](ValueSet-v3-CoverageSponsorRoleType.md) | **Description:**Codes that indicate a specific type of sponsor. Used when the sponsor's role is only either as a fully insured sponsor or only as a self-insured sponsor. NOTE: Where a sponsor may be either, use the SponsorParticipationFunction.code (fully insured or self insured) to indicate the type of responsibility. (CO6-0057) |
| [CoveredPartyRoleType](ValueSet-v3-CoveredPartyRoleType.md) | A role recognized through the eligibility of an identified living subject for benefits covered under an insurance policy or a program. Eligibility as a covered party may be conditioned on a relationship with (1) the policy holder such as the policy holder who is covered as an individual under a poliy or as a party sponsored for coverage by the policy holder.**Example:**An employee as a subscriber; or (2) on being scoped another covered party such as the subscriber, as in the case of a dependent.**Discussion:**The Abstract Value Set "CoverageRoleType", which was developed for use in the Canadian realm "pre-coordinate" coverage roles with other roles that a covered party must play in order to be eligible for coverage, e.g., "handicapped dependent". Other codes in the Abstract Value Set CoveredPartyRoleType domain can be "post-coordinated" with the EligiblePartyRoleType codes to denote comparable concepts. Decoupling the concepts is intended to support a wider range of concepts and semantic comparability of coded concepts. |
| [CreamDrugForm](ValueSet-v3-CreamDrugForm.md) | A semisolid dosage form containing one or more drug substances dissolved or dispersed in a suitable base; more recently, the term has been restricted to products consisting of oil-in-water emulsions or aqueous microcrystalline dispersions of long chain fatty acids or alcohols that are water washable and more cosmetically and aesthetically acceptable. |
| [CreditCard](ValueSet-v3-CreditCard.md) | ****No description**** |
| [Cree](ValueSet-v3-Cree.md) | ****No description**** |
| [CreeMontagnais](ValueSet-v3-CreeMontagnais.md) | ****No description**** |
| [CriticalityObservationValue](ValueSet-v3-CriticalityObservationValue.md) | Recommended values for criticality observations >**Steward:**Security WG |
| [Cupan](ValueSet-v3-Cupan.md) | ****No description**** |
| [Currency](ValueSet-v3-Currency.md) | The currency unit as defined in ISO 4217 |
| [Dakotan](ValueSet-v3-Dakotan.md) | ****No description**** |
| [Decision Observation Method](ValueSet-v3-DecisionObservationMethod.md) | Provides codes for decision methods, initially for assessing the causality of events. |
| [DedicatedClinicalLocationRoleType](ValueSet-v3-DedicatedClinicalLocationRoleType.md) | A role of a place that further classifies the clinical setting (e.g., cardiology clinic, primary care clinic, rehabilitation hospital, skilled nursing facility) in which care is delivered during an encounter. |
| [DedicatedNonClinicalLocationRoleType](ValueSet-v3-DedicatedNonClinicalLocationRoleType.md) | A role of a place that further classifies a setting that is intended to house the provision of non-clinical services. |
| [DedicatedServiceDeliveryLocationRoleType](ValueSet-v3-DedicatedServiceDeliveryLocationRoleType.md) | A role of a place that further classifies a setting that is intended to house the provision of services. |
| [DefinitionStatus](ValueSet-definition-status.md) | Codes identifying the lifecycle stage of a definition. |
| [DefinitionTopic](ValueSet-definition-topic.md) | High-level categorization of the definition, used for searching, sorting, and filtering. |
| [Delawaran](ValueSet-v3-Delawaran.md) | ****No description**** |
| [DeliveryAddressLine](ValueSet-v3-DeliveryAddressLine.md) | A delivery address line is frequently used instead of breaking out delivery mode, delivery installation, etc. An address generally has only a delivery address line or a street address line, but not both. |
| [DeltaCalifornia](ValueSet-v3-DeltaCalifornia.md) | ****No description**** |
| [DentistHIPAA](ValueSet-v3-DentistHIPAA.md) | A dentist is a person qualified by a doctorate in dental surgery (D.D. S.) or dental medicine (D.M.D.). licensed by the state to practice dentistry, and practicing within the scope of that license. Many dentists are general practitioners who handle a wide variety of dental needs. Other dentists practice in one of eight specialty areas recognized by the American Dental Association: oral and maxillofacial surgery, orthodontics, periodontics, prosthodontics, endodontics, public health, oral pathology and pediatric dentistry. |
| [Dentition](ValueSet-v3-Dentition.md) | ****No description**** |
| [DependentCoveredPartyRoleType](ValueSet-v3-DependentCoveredPartyRoleType.md) | **Description:**A role recognized through the eligibility of a party to play a dependent for benefits covered or provided under a health insurance policy because of an association with the subscriber that is recognized by the policy underwriter. |
| [DeviceAlert Activation State Codes](ValueSet-devicealert-activationState.md) | DeviceAlert Activation State Codes |
| [DeviceAlert Condition Codes](ValueSet-devicealert-condition.md) | DeviceAlert Condition Codes |
| [DeviceAlert Priority Codes](ValueSet-devicealert-priority.md) | DeviceAlert Priority Codes |
| [DeviceAlertLevel](ValueSet-v3-DeviceAlertLevel.md) | Domain values for the Device.Alert_levelCode |
| [DeviceDefinitionParameterGroup](ValueSet-parameter-group.md) | Codes identifying groupings of parameters; e.g. Cardiovascular. |
| [DeviceType](ValueSet-v2-0961.md) | Codes used to identify medical devices. |
| [Dhegiha](ValueSet-v3-Dhegiha.md) | ****No description**** |
| [DiagTherPracticeSetting](ValueSet-v3-DiagTherPracticeSetting.md) | A practice setting where diagnostic procedures or therapeutic interventions are performed |
| [Diagnosis Type Codes](ValueSet-diagnosistype.md) | This value set includes Diagnosis Type codes. |
| [DiagnosisICD9CM](ValueSet-v3-DiagnosisICD9CM.md) | ****No description**** |
| [DiagnosisRole](ValueSet-diagnosis-role.md) | This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record. |
| [Diegueno](ValueSet-v3-Diegueno.md) | ****No description**** |
| [Diet](ValueSet-encounter-diet.md) | This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have. |
| [Diffusion](ValueSet-v3-Diffusion.md) | Diffusion |
| [Discharge Disposition](ValueSet-v3-DischargeDisposition.md) | These codes are used to convey the patient discharge status |
| [Discharge disposition](ValueSet-encounter-discharge-disposition.md) | This value set defines a set of codes that can be used to where the patient left the hospital. |
| [DiseaseProgram](ValueSet-v3-DiseaseProgram.md) | **Definition:**A public or government health program that administers and funds coverage for health and social services to assist program eligible who meet financial and health status criteria related to a particular disease.**Example:**Reproductive health, sexually transmitted disease, and end renal disease programs. |
| [DispensableDrugForm](ValueSet-v3-DispensableDrugForm.md) | ****No description**** |
| [Dissolve](ValueSet-v3-Dissolve.md) | Dissolve |
| [DocumentCompletion](ValueSet-v3-DocumentCompletion.md) | Identifies the current completion state of a clinical document. |
| [DocumentSectionType](ValueSet-v3-DocumentSectionType.md) | The type of document section. Possible values: review of systems, medical history, family history, microscopic findings, etc. |
| [DocumentStorage](ValueSet-v3-DocumentStorage.md) | Identifies the storage status of a document. |
| [DocumentStorageActive](ValueSet-v3-DocumentStorageActive.md) | A storage status in which a document is available on-line. |
| [DosageProblem](ValueSet-v3-DosageProblem.md) | ****No description**** |
| [DosageProblemDetectedIssueCode](ValueSet-v3-DosageProblemDetectedIssueCode.md) | Proposed dosage instructions for therapy differ from standard practice. |
| [DoseAndRateType](ValueSet-dose-rate-type.md) | The kind of dose or rate specified. |
| [DoseDurationDetectedIssueCode](ValueSet-v3-DoseDurationDetectedIssueCode.md) | Proposed length of therpay differs from standard practice |
| [DoseDurationHighDetectedIssueCode](ValueSet-v3-DoseDurationHighDetectedIssueCode.md) | Proposed length of therapy is longer than standard practice |
| [DoseDurationLowDetectedIssueCode](ValueSet-v3-DoseDurationLowDetectedIssueCode.md) | Proposed length of therapy is shorter than that necessary for therapeutic effect |
| [DoseHighDetectedIssueCode](ValueSet-v3-DoseHighDetectedIssueCode.md) | Proposed dosage exceeds standard practice |
| [DoseIntervalDetectedIssueCode](ValueSet-v3-DoseIntervalDetectedIssueCode.md) | Proposed dosage interval/timing differs from standard practice |
| [DoseLowDetectedIssueCode](ValueSet-v3-DoseLowDetectedIssueCode.md) | Proposed dosage is below suggested therapeutic levels |
| [Douche](ValueSet-v3-Douche.md) | Douche |
| [DropsDrugForm](ValueSet-v3-DropsDrugForm.md) | ****No description**** |
| [Drug Entity](ValueSet-v3-DrugEntity.md) | A value representing the specific kind of Drug Entity the instance represents. |
| [DuplicateTherapyAlert](ValueSet-v3-DuplicateTherapyAlert.md) | ****No description**** |
| [ECGObservationSeriesType](ValueSet-v3-ECGObservationSeriesType.md) | ****No description**** |
| [EPSG-GeodeticParameterDataset](ValueSet-v3-EPSG-GeodeticParameterDataset.md) | **Description:**The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide. |
| [ERPracticeSetting](ValueSet-v3-ERPracticeSetting.md) | The section of a health care facility for providing rapid treatment to victims of sudden illness or trauma. |
| [EasternAlgonquin](ValueSet-v3-EasternAlgonquin.md) | ****No description**** |
| [EasternApachean](ValueSet-v3-EasternApachean.md) | ****No description**** |
| [EasternMiwok](ValueSet-v3-EasternMiwok.md) | ****No description**** |
| [EducationLevel](ValueSet-v3-EducationLevel.md) | ****No description**** |
| [ElectroOsmosisRoute](ValueSet-v3-ElectroOsmosisRoute.md) | Electro-osmosis |
| [EligibilityActReasonCode](ValueSet-v3-EligibilityActReasonCode.md) | **Description:**Identifies the reason or rational for why a person is eligible for benefits under an insurance policy or program.**Examples:**A new employee is eligible for health insurance as an employment benefit. A person meets eligibility criteria for government program coverage based on financial, age or health status. |
| [EmergencyMedicalServiceProviderHIPAA](ValueSet-v3-EmergencyMedicalServiceProviderHIPAA.md) | Broad category for individuals who complete additional training and education in the area of pre-hospital emergency services and are licensed and/or practice within the scope of that training. |
| [EmergencyPharmacySupplyType](ValueSet-v3-EmergencyPharmacySupplyType.md) | A supply action where there is no 'valid' order for the supplied medication. E.g. Emergency vacation supply, weekend supply (when prescriber is unavailable to provide a renewal prescription) |
| [EmployeeJobClass](ValueSet-v3-EmployeeJobClass.md) | A code qualifying the employment in various ways, such as, full-time vs. part time, etc. |
| [EmploymentStatusUB92](ValueSet-v3-EmploymentStatusUB92.md) | ****No description**** |
| [Encounter class](ValueSet-encounter-class.md) | This value set defines a set of codes that can be used to indicate the class of encounter: a specific code indicating class of service provided. |
| [Encounter subject status](ValueSet-encounter-subject-status.md) | This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter |
| [Encounter type](ValueSet-encounter-type.md) | This example value set defines a set of codes that can be used to indicate the type of encounter: a specific code indicating type of service provided. |
| [EncounterAdmissionSource](ValueSet-v3-EncounterAdmissionSource.md) | ****No description**** |
| [EncounterSpecialCourtesy](ValueSet-v3-EncounterSpecialCourtesy.md) | A code identifying special courtesies extended to the patient. For example, no courtesies, extended courtesies, professional courtesy, VIP courtesies. |
| [EndocervicalRoute](ValueSet-v3-EndocervicalRoute.md) | Endocervical |
| [EndocrinologyClinic](ValueSet-v3-EndocrinologyClinic.md) | ****No description**** |
| [Endpoint Connection Type](ValueSet-endpoint-connection-type.md) | This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values. |
| [Enema](ValueSet-v3-Enema.md) | Enema |
| [Enteral Formula Additive Type Code](ValueSet-entformula-additive.md) | EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example. |
| [EnteralRoute](ValueSet-v3-EnteralRoute.md) | Enteral |
| [EntericCoatedCapsule](ValueSet-v3-EntericCoatedCapsule.md) | ****No description**** |
| [EntericCoatedTablet](ValueSet-v3-EntericCoatedTablet.md) | ****No description**** |
| [EntityClass](ValueSet-v3-EntityClass.md) | Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top is this HL7-defined domain of high-level categories (such as represented by the Entity subclasses). Each of these terms must be harmonized and is specializable. The value sets beneath are encoded in Entity.code and are drawn from multiple, frequently external, domains that reflect much more fine-grained typing. |
| [EntityClassAnimal](ValueSet-v3-EntityClassAnimal.md) | A living subject from the animal kingdom. |
| [EntityClassCertificateRepresentation](ValueSet-v3-EntityClassCertificateRepresentation.md) | A physical artifact that stores information about the granting of authorization. |
| [EntityClassChemicalSubstance](ValueSet-v3-EntityClassChemicalSubstance.md) | A substance that is fully defined by an organic or inorganic chemical formula, includes mixtures of other chemical substances. Refine using, e.g., IUPAC codes. |
| [EntityClassCityOrTown](ValueSet-v3-EntityClassCityOrTown.md) | The territory of a city, town or other municipality. |
| [EntityClassContainer](ValueSet-v3-EntityClassContainer.md) | A container of other entities. |
| [EntityClassCountry](ValueSet-v3-EntityClassCountry.md) | The territory of a sovereign nation. |
| [EntityClassCountyOrParish](ValueSet-v3-EntityClassCountyOrParish.md) | The territory of a county, parish or other division of a state or province. |
| [EntityClassDevice](ValueSet-v3-EntityClassDevice.md) | A subtype of ManufacturedMaterial used in an activity, without being substantially changed through that activity. The kind of device is identified by the code attribute inherited from Entity.**Usage:**This includes durable (reusable) medical equipment as well as disposable equipment. |
| [EntityClassFood](ValueSet-v3-EntityClassFood.md) | Naturally occurring, processed or manufactured entities that are primarily used as food for humans and animals. |
| [EntityClassGroup](ValueSet-v3-EntityClassGroup.md) | A grouping of resources (personnel, material, or places) to be used for scheduling purposes. May be a pool of like-type resources, a team, or combination of personnel, material and places. |
| [EntityClassHealthChartEntity](ValueSet-v3-EntityClassHealthChartEntity.md) | A health chart included to serve as a document receiving entity in the management of medical records. |
| [EntityClassHolder](ValueSet-v3-EntityClassHolder.md) | A type of container that can hold other containers or other holders. |
| [EntityClassImagingModality](ValueSet-v3-EntityClassImagingModality.md) | Class to contain unique attributes of diagnostic imaging equipment. |
| [EntityClassLivingSubject](ValueSet-v3-EntityClassLivingSubject.md) | Anything that essentially has the property of life, independent of current state (a dead human corpse is still essentially a living subject.) |
| [EntityClassManufacturedMaterial](ValueSet-v3-EntityClassManufacturedMaterial.md) | Corresponds to the ManufacturedMaterial class |
| [EntityClassMaterial](ValueSet-v3-EntityClassMaterial.md) | Any thing that has extension in space and mass, may be of living or non-living origin. |
| [EntityClassMicroorganism](ValueSet-v3-EntityClassMicroorganism.md) | All single celled living organisms including protozoa, bacteria, yeast, viruses, etc. |
| [EntityClassNation](ValueSet-v3-EntityClassNation.md) | A politically organized body of people bonded by territory and known as a nation. |
| [EntityClassNonPersonLivingSubject](ValueSet-v3-EntityClassNonPersonLivingSubject.md) | ****No description**** |
| [EntityClassOrganization](ValueSet-v3-EntityClassOrganization.md) | A social or legal structure formed by human beings. |
| [EntityClassPerson](ValueSet-v3-EntityClassPerson.md) | A living subject of the species homo sapiens. |
| [EntityClassPlace](ValueSet-v3-EntityClassPlace.md) | A physicial place or site with its containing structure. May be natural or man-made. The geographic position of a place may or may not be constant. |
| [EntityClassPlant](ValueSet-v3-EntityClassPlant.md) | A living subject from the order of plants. |
| [EntityClassPublicInstitution](ValueSet-v3-EntityClassPublicInstitution.md) | An agency of the people of a state often assuming some authority over a certain matter. Includes government, governmental agencies, associations. |
| [EntityClassRoot](ValueSet-v3-EntityClassRoot.md) | Corresponds to the Entity class |
| [EntityClassState](ValueSet-v3-EntityClassState.md) | A politically organized body of people bonded by territory, culture, or ethnicity, having sovereignty (to a certain extent) granted by other states (enclosing or neighboring states). This includes countries (nations), provinces (e.g., one of the United States of America or a French departement), counties or municipalities. Refine using, e.g., ISO country codes, FIPS-PUB state codes, etc. |
| [EntityClassStateOrProvince](ValueSet-v3-EntityClassStateOrProvince.md) | The territory of a state, province, department or other division of a sovereign country. |
| [EntityCode](ValueSet-v3-EntityCode.md) | A value representing the specific kind of Entity the instance represents.**Examples:**A medical building, a Doberman Pinscher, a blood collection tube, a tissue biopsy.**Rationale:**For each Entity, the value for this attribute is drawn from one of several coding systems depending on the Entity classCode, such as living subjects (animal and plant taxonomies), chemical substance (e.g., IUPAC code), organizations, insurance company, government agency, hospital, park, lake, syringe, etc. It is possible that Entity.code may be so fine grained that it represents a single instance. An example is the CDC vaccine manufacturer code, modeled as a concept vocabulary, when in fact each concept refers to a single instance. |
| [EntityDeterminer](ValueSet-v3-EntityDeterminer.md) | EntityDeterminer in natural language grammar is the class of words that comprises articles, demonstrative pronouns, and quantifiers. In the RIM, determiner is a structural code in the Entity class to distinguish whether any given Entity object stands for some, any one, or a specific thing. |
| [EntityDeterminerDescribedGroup](ValueSet-v3-EntityDeterminerDescribedGroup.md) | A standard value set allowing reference to all EntityDeterminer codes that are equal to or specializations of GROUPKIND. This is the value set used when a model indicates that the binding is to "<= GROUPKIND". |
| [EntityDeterminerDescribedQuantified](ValueSet-v3-EntityDeterminerDescribedQuantified.md) | The described quantified determiner indicates that the given Entity is taken as a general description of a specific amount of a thing. For example, QUANTIFIED_KIND of syringe (quantity = 3,) stands for exactly three syringes. |
| [EntityDeterminerDetermined](ValueSet-v3-EntityDeterminerDetermined.md) | The described determiner is used to indicate that the given Entity is taken as a general description of a kind of thing that can be taken in whole, in part, or in multiples. |
| [EntityDeterminerSpecific](ValueSet-v3-EntityDeterminerSpecific.md) | The specific determiner indicates that the given Entity is taken as one specific thing instance. For example, a human INSTANCE (quantity = 1,) stands for exactly one human being. |
| [EntityDeterminerSpecificGroup](ValueSet-v3-EntityDeterminerSpecificGroup.md) | A standard value set allowing reference to all EntityDeterminer codes that are equal to or specializations of GROUP. This is the value set used when a model indicates that the binding is to "<= GROUP". |
| [EntityHandling](ValueSet-v3-EntityHandling.md) | Special handling requirements for an Entity.**Example:**Keep at room temperature; Keep frozen below 0 C; Keep in a dry environment; Keep upright, do not turn upside down. |
| [EntityInformationSensitivityPolicy](ValueSet-v3-EntityInformationSensitivityPolicy.md) | EntitySensitivity codes are used to convey a policy that is applicable to sensitive information conveyed by an entity attribute. May be used to bind a Role.confidentialityCode associated with an Entity per organizational policy. Role.confidentialityCode is defined in the RIM as "an indication of the appropriate disclosure of information about this Role with respect to the playing Entity." |
| [EntityNamePartQualifier](ValueSet-v3-EntityNamePartQualifier.md) | ****No description**** |
| [EntityNamePartQualifierR2](ValueSet-v3-EntityNamePartQualifierR2.md) | **Description:**The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records. |
| [EntityNamePartType](ValueSet-v3-EntityNamePartType.md) | ****No description**** |
| [EntityNamePartTypeR2](ValueSet-v3-EntityNamePartTypeR2.md) | **Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc. |
| [EntityNameUse](ValueSet-v3-EntityNameUse.md) | ****No description**** |
| [EntityNameUseR2](ValueSet-v3-EntityNameUseR2.md) | **Description:**A set of codes advising a system or user which name in a set of names to select for a given purpose. |
| [EntityRisk](ValueSet-v3-EntityRisk.md) | The vocabulary table for the Entity.riskCode attribute |
| [EntityStatus](ValueSet-v3-EntityStatus.md) | Codes representing the defined possible states of an Entity, as defined by the Entity class state machine. |
| [EntityStatusActive](ValueSet-v3-EntityStatusActive.md) | The state representing the fact that the Entity record is currently active. |
| [EntityStatusInactive](ValueSet-v3-EntityStatusInactive.md) | **Definition:**The state representing the fact that the entity is inactive. |
| [EntityStatusNormal](ValueSet-v3-EntityStatusNormal.md) | The 'typical' state. Excludes "nullified" which represents the termination state of an Entity record instance that was created in error. |
| [EntityStatusNullified](ValueSet-v3-EntityStatusNullified.md) | The state representing the termination of an Entity record instance that was created in error. |
| [EpiduralRoute](ValueSet-v3-EpiduralRoute.md) | Epidural |
| [Episode of care type](ValueSet-episodeofcare-type.md) | This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record. |
| [EquipmentAlertLevel](ValueSet-v3-EquipmentAlertLevel.md) | ****No description**** |
| [EskimoAleut](ValueSet-v3-EskimoAleut.md) | ****No description**** |
| [Eskimoan](ValueSet-v3-Eskimoan.md) | ****No description**** |
| [Ethnicity](ValueSet-v3-Ethnicity.md) | In the United States, federal standards for classifying data on ethnicity determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define ethnicity, and they recognize the absence of an anthropological or scientific basis for ethnicity classification. Instead, the federal standards acknowledge that ethnicity is a social-political construct in which an individual's own identification with a particular ethnicity is preferred to observer identification. The standards specify two minimum ethnicity categories: Hispanic or Latino, and Not Hispanic or Latino. The standards define a Hispanic or Latino as a person of "Mexican, Puerto Rican, Cuban, South or Central America, or other Spanish culture or origin, regardless of race." The standards stipulate that ethnicity data need not be limited to the two minimum categories, but any expansion must be collapsible to those categories. In addition, the standards stipulate that an individual can be Hispanic or Latino or can be Not Hispanic or Latino, but cannot be both. |
| [EthnicityHispanic](ValueSet-v3-EthnicityHispanic.md) | ****No description**** |
| [EthnicityHispanicCentralAmerican](ValueSet-v3-EthnicityHispanicCentralAmerican.md) | ****No description**** |
| [EthnicityHispanicMexican](ValueSet-v3-EthnicityHispanicMexican.md) | ****No description**** |
| [EthnicityHispanicSouthAmerican](ValueSet-v3-EthnicityHispanicSouthAmerican.md) | ****No description**** |
| [EthnicityHispanicSpaniard](ValueSet-v3-EthnicityHispanicSpaniard.md) | ****No description**** |
| [Evidence Certainty Type](ValueSet-certainty-type.md) | The aspect of quality, confidence, or certainty. |
| [EvidenceDirectness](ValueSet-directness.md) | The quality of how direct the match is. |
| [EvidenceVariableRole](ValueSet-variable-role.md) | **Deprecation Information:**This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role. |
| [EvidenceVariableRoleSubtype](ValueSet-variable-role-subtype.md) | The subclassification of the role that the assertion variable plays. |
| [Example Claim SubType Codes](ValueSet-claim-subtype.md) | This value set includes sample Claim SubType codes which are used to distinguish the claim types for example within type institutional there may be subtypes for emergency services, bed stay and transportation. |
| [Example Coverage Financial Exception Codes](ValueSet-coverage-financial-exception.md) | This value set includes Example Coverage Financial Exception Codes. |
| [Example Diagnosis Related Group Codes](ValueSet-ex-diagnosisrelatedgroup.md) | This value set includes example Diagnosis Related Group codes. |
| [Example Diagnosis Type Codes](ValueSet-ex-diagnosistype.md) | This value set includes example Diagnosis Type codes. |
| [Example Diagnosis on Admission Codes](ValueSet-ex-diagnosis-on-admission.md) | This value set includes example Diagnosis on Admission codes. |
| [Example Message Reason Codes](ValueSet-message-reason-encounter.md) | Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update. |
| [Example Payment Type Codes](ValueSet-ex-paymenttype.md) | This value set includes example Payment Type codes. |
| [Example Procedure Type Codes](ValueSet-ex-procedure-type.md) | This value set includes example Procedure Type codes. |
| [Example Program Reason Codes](ValueSet-ex-program-code.md) | This value set includes sample Program Reason Span codes. |
| [Example Provider Qualification Codes](ValueSet-provider-qualification.md) | This value set includes sample Provider Qualification codes. |
| [Example Related Claim Relationship Codes](ValueSet-related-claim-relationship.md) | This value set includes sample Related Claim Relationship codes. |
| [Example Revenue Center Codes](ValueSet-ex-revenue-center.md) | This value set includes sample Revenue Center codes. |
| [Example Service Place Codes](ValueSet-service-place.md) | This value set includes a smattering of Service Place codes. |
| [Example Use Codes for List](ValueSet-list-example-codes.md) | Example use codes for the List resource - typical kinds of use. |
| [Example Vision Prescription Product Codes](ValueSet-vision-product.md) | This value set includes a smattering of Prescription Product codes. |
| [Exception Codes](ValueSet-claim-exception.md) | This value set includes sample Exception codes. |
| [ExpansionParameterSource](ValueSet-expansion-parameter-source.md) | Declares what the source of a parameter is. |
| [ExpansionProcessingRule](ValueSet-expansion-processing-rule.md) | Defines how concepts are processed into the expansion when it's for UI presentation. |
| [ExpectedSubset](ValueSet-v3-ExpectedSubset.md) | An occurrence that is scheduled to occur in the future. An Act whose effective time is greater than 'now', where 'now' is the time the instance is authored. |
| [ExposureMode](ValueSet-v3-ExposureMode.md) | Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure. |
| [ExtendedReleaseCapsule](ValueSet-v3-ExtendedReleaseCapsule.md) | A solid dosage form in which the drug is enclosed within either a hard or soft soluble container made from a suitable form of gelatin, and which releases a drug (or drugs) in such a manner to allow a reduction in dosing frequency as compared to that drug (or drugs) presented as a conventional dosage form. |
| [ExtendedReleaseSuspension](ValueSet-v3-ExtendedReleaseSuspension.md) | ****No description**** |
| [ExtendedReleaseTablet](ValueSet-v3-ExtendedReleaseTablet.md) | A solid dosage form containing a drug which allows at least a reduction in dosing frequency as compared to that drug presented in conventional dosage form. |
| [ExtraAmnioticRoute](ValueSet-v3-ExtraAmnioticRoute.md) | Extra-amniotic |
| [ExtracorporealCirculationRoute](ValueSet-v3-ExtracorporealCirculationRoute.md) | Extracorporeal circulation |
| [FHIR Clinical Document Information Recipients Participant Types](ValueSet-fhir-clinical-doc-information-recipient.md) | Subset of codes from v3-ParticipationType for use as Clinical Document Participant Type codes, which are specifically CDA information recipients. |
| [FHIR Clinical Document Participant Types Value set](ValueSet-fhir-clinical-doc-participant.md) | FHIR Clinical Document Participant Types. Author, Authenticator, Custodian, Legal Authenticator, Record Target and Subject are found in distinct, named fields in FHIR. Thus, these types are excluded. |
| [FHIR Device Types](ValueSet-device-kind.md) | Codes used to identify medical devices. Includes concepts from SNOMED CT (http://www.snomed.org/) where concept is-a 49062001 (Device) and is provided as a suggestive example. |
| [FHIRDeviceStatusReason](ValueSet-device-status-reason.md) | The availability status reason of the device. |
| [FHIRdeviceStatus](ValueSet-v2-0962.md) | The availability status of the device. |
| [Failure-action](ValueSet-verificationresult-failure-action.md) | The result if validation fails |
| [FamilyHistoryAbsentReason](ValueSet-history-absent-reason.md) | Codes describing the reason why a family member's history is not available. |
| [FamilyMember](ValueSet-v3-FamilyMember.md) | A relationship between two people characterizing their "familial" relationship |
| [Financial Task Codes](ValueSet-financial-taskcode.md) | This value set includes Financial Task codes. |
| [Financial Task Input Type Codes](ValueSet-financial-taskinputtype.md) | This value set includes Financial Task Input Type codes. |
| [FirstFillPharmacySupplyType](ValueSet-v3-FirstFillPharmacySupplyType.md) | The initial fill against an order. (This includes initial fills against refill orders.) |
| [Flag Category](ValueSet-flag-category.md) | Example list of general categories for flagged issues. (Not complete or necessarily appropriate.) |
| [Flush](ValueSet-v3-Flush.md) | Flush |
| [FoamDrugForm](ValueSet-v3-FoamDrugForm.md) | ****No description**** |
| [FontStyle](ValueSet-v3-FontStyle.md) | (abstract) Defines font rendering characteristics |
| [Forms](ValueSet-forms.md) | This value set includes a sample set of Forms codes. |
| [FosterChild](ValueSet-v3-FosterChild.md) | The player of the role is a child receiving parental care and nurture from the scoping person (parent) but not related to him or her through legal or blood ties. |
| [Funds Reservation Codes](ValueSet-fundsreserve.md) | This value set includes sample funds reservation type codes. |
| [GIClinicPracticeSetting](ValueSet-v3-GIClinicPracticeSetting.md) | ****No description**** |
| [GIDiagTherPracticeSetting](ValueSet-v3-GIDiagTherPracticeSetting.md) | A practice setting where GI procedures (such as endoscopies) are performed |
| [GTIN](ValueSet-v3-GTIN.md) | **Description:**Global Trade Item Number is an identifier for trade items developed by GS1 (comprising the former EAN International and Uniform Code Council). |
| [GTSAbbreviation](ValueSet-v3-GTSAbbreviation.md) | ****No description**** |
| [GTSAbbreviationBase](ValueSet-v3-GTSAbbreviationBase.md) | **Description:**Basic abbreviations defined for the General timing Specification data type. |
| [GTSAbbreviationHolidays](ValueSet-v3-GTSAbbreviationHolidays.md) | Holidays |
| [GTSAbbreviationHolidaysChristianRoman](ValueSet-v3-GTSAbbreviationHolidaysChristianRoman.md) | Christian Holidays (Roman/Gregorian "Western" Tradition.) |
| [GTSAbbreviationHolidaysUSNational](ValueSet-v3-GTSAbbreviationHolidaysUSNational.md) | United States National Holidays (public holidays for federal employees established by U.S. Federal law 5 U.S.C. 6103.) |
| [GTSAbbreviationOther](ValueSet-v3-GTSAbbreviationOther.md) | **Description:**Other, more specific, abbreviations defined for the General timing Specification data type, that are specializations of one of the Base concepts. |
| [GasDrugForm](ValueSet-v3-GasDrugForm.md) | Any elastic aeriform fluid in which the molecules are separated from one another and have free paths. |
| [GasLiquidMixture](ValueSet-v3-GasLiquidMixture.md) | ****No description**** |
| [GasSolidSpray](ValueSet-v3-GasSolidSpray.md) | ****No description**** |
| [GastricRoute](ValueSet-v3-GastricRoute.md) | Gastric |
| [GelDrugForm](ValueSet-v3-GelDrugForm.md) | A semisolid system consisting of either suspensions made up of small inorganic particles or large organic molecules interpenetrated by a liquid. |
| [Gender Identity](ValueSet-gender-identity.md) | Codes that indicate a individual's gender identity. This value set is a minimum set of commonly used values. It is expected and encouraged that specific jurisdictions or communities will use additional gender identity concepts that are relevant within their community. |
| [GenderStatus](ValueSet-v3-GenderStatus.md) | A value representing whether the primary reproductive organs of NonPersonLivingSubject are present. |
| [GeneralAcuteCareHospital](ValueSet-v3-GeneralAcuteCareHospital.md) | (X12N 282N00000N) |
| [GeneralAddressUse](ValueSet-v3-GeneralAddressUse.md) | ****No description**** |
| [GeneralPurposeOfUse](ValueSet-v3-GeneralPurposeOfUse.md) | Supports communication of purpose of use at a general level. |
| [GenericUpdateReasonCode](ValueSet-v3-GenericUpdateReasonCode.md) | **Description:**Identifies why a change is being made to a record. |
| [GeneticObservationInterpretation](ValueSet-v3-GeneticObservationInterpretation.md) | Codes that specify interpretation of genetic analysis, such as "positive", "negative", "carrier", "responsive", etc. |
| [GeneticObservationMethod](ValueSet-v3-GeneticObservationMethod.md) | A code that provides additional detail about the means or technique used to ascertain the genetic analysis. Example, PCR, Micro Array |
| [GeneticObservationType](ValueSet-v3-GeneticObservationType.md) | **Description:**Identifies the kinds of genetic observations that can be performed. |
| [GeneticObservationValue](ValueSet-v3-GeneticObservationValue.md) | **Description:**The domain contains genetic analysis specific observation values, e.g. Homozygote, Heterozygote, etc. |
| [GenitourinaryRoute](ValueSet-v3-GenitourinaryRoute.md) | Genitourinary |
| [GingivalRoute](ValueSet-v3-GingivalRoute.md) | Gingival |
| [Goal achievement status](ValueSet-goal-achievement.md) | Describes the progression, or lack thereof, towards the goal against the target. |
| [Goal category](ValueSet-goal-category.md) | Example codes for grouping goals to use for filtering or presentation. |
| [Goal priority](ValueSet-goal-priority.md) | Indicates the level of importance associated with reaching or sustaining a goal. |
| [GoalAcceptanceStatus](ValueSet-goal-acceptance-status.md) | Codes indicating whether the goal has been accepted by a stakeholder. |
| [GoalRelationshipType](ValueSet-goal-relationship-type.md) | Types of relationships between two goals. |
| [GrandChild](ValueSet-v3-GrandChild.md) | The player of the role is a child of the scoping person's son or daughter. |
| [Grandparent](ValueSet-v3-Grandparent.md) | parent of a parent of the subject |
| [GreatGrandparent](ValueSet-v3-GreatGrandparent.md) | The player of the role is a parent of the scoping person's grandparent. |
| [GregorianCalendarCycle](ValueSet-v3-GregorianCalendarCycle.md) | ****No description**** |
| [Group Code](ValueSet-group-code.md) | A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group |
| [GuideParameterCode](ValueSet-guide-parameter-code.md) | Code of parameter that is input to the guide. |
| [HL7 Value Set for State/Province](ValueSet-v2-notAllCodes-0347.md) | Concepts used to specify a state or province. Used in Version 2 messaging in the Extended Composite ID with Check Digit (CX), Performing Person Time Stamp (PPN), and Extended Composite ID Number and Name for Persons (XCN) values as well as the Accident (ACC) segment. |
| [HL7 ValueSet of Format Codes for use with Document Sharing](ValueSet-v3-HL7FormatCodes.md) | The HL7-FormatCodes value set is defined to be the set of FormatCode(s) defined by implementation guides published by HL7 and other SDOs. The use of a formatCode from the FormatCodes value set specifies the technical format that a document conforms to. The formatCode is a further specialization more detailed than the mime-type. The formatCode provides sufficient information to allow any potential document content consumer to know if it can process and/or display the content of the document based on the document encoding, structure and template conformance indicated by the formatCode. The set of formatCodes is intended to be extensible. The Content Logical Description is defined intentionally to permit formatCodes defined by other Standards Development Organizations to be added by inclusion of additional formatCode Code Systems. |
| [HL7AccommodationCode](ValueSet-v3-HL7AccommodationCode.md) | **Description:**Accommodation type. In Intent mood, represents the accommodation type requested. In Event mood, represents accommodation assigned/used. In Definition mood, represents the available accommodation type. |
| [HL7CalendarCycle](ValueSet-v3-HL7CalendarCycle.md) | ****No description**** |
| [HL7ITSVersionCode](ValueSet-v3-HL7ITSVersionCode.md) | HL7 implementation technology specification versions. These codes will document the ITS type and version for message encoding. The code will appear in the instances based upon rules expressed in the ITS, and do not appear in the abstract message, either as it is presented to received from the ITS. |
| [HL7SearchUse](ValueSet-v3-HL7SearchUse.md) | ****No description**** |
| [HL7StandardVersionCode](ValueSet-v3-HL7StandardVersionCode.md) | This is the domain of HL7 version codes for the Version 3 standards. Values are to be determined by HL7 and added with each new version of the HL7 Standard. |
| [HL7UpdateMode](ValueSet-v3-HL7UpdateMode.md) | The possible modes of updating that occur when an attribute is received by a system that already contains values for that attribute. |
| [HL7Workgroup](ValueSet-hl7-work-group.md) | An HL7 administrative unit that owns artifacts in the FHIR specification. |
| [HairRoute](ValueSet-v3-HairRoute.md) | Hair |
| [HalfSibling](ValueSet-v3-HalfSibling.md) | The player of the role is related to the scoping entity by sharing only one biological parent. |
| [HandlingConditionSet](ValueSet-handling-condition.md) | Set of handling instructions prior testing of the specimen. |
| [HealthCareCommonProcedureCodingSystem](ValueSet-v3-HealthCareCommonProcedureCodingSystem.md) | This value set includes all HCPCS Level II codes. |
| [HealthQualityMeasureDocument](ValueSet-v3-HealthQualityMeasureDocument.md) | ****No description**** |
| [HealthcareServiceLocation](ValueSet-v3-HealthcareServiceLocation.md) | A comprehensive classification of locations and settings where healthcare services are provided. This value set is based on the CMS Place of Service code set NHSN location code system that has been developed over a number of years through CDCaTMs interaction with a variety of healthcare facilities and is intended to serve a variety of reporting needs where coding of healthcare service locations is required. Excluded codes are those that do not represent an actual location where health care services can be delivered, IE: Float, or a location aggregation. |
| [HeightSurfaceAreaAlert](ValueSet-v3-HeightSurfaceAreaAlert.md) | Proposed therapy may be inappropriate based on the patient's height or body surface area |
| [HemClinPracticeSetting](ValueSet-v3-HemClinPracticeSetting.md) | ****No description**** |
| [Hokan](ValueSet-v3-Hokan.md) | ****No description**** |
| [HomeAddress](ValueSet-v3-HomeAddress.md) | ****No description**** |
| [Homeless](ValueSet-v3-Homeless.md) | **Definition:**Living arrangements lacking a permanent residence. |
| [HospitalPracticeSetting](ValueSet-v3-HospitalPracticeSetting.md) | An acute care institution that provides medical, surgical, or psychiatric care and treatment for the sick or the injured. |
| [HospitalUnitPracticeSetting](ValueSet-v3-HospitalUnitPracticeSetting.md) | ****No description**** |
| [HtmlLinkType](ValueSet-v3-HtmlLinkType.md) | HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current document and the anchor that is the target of the link |
| [HumanActSite](ValueSet-v3-HumanActSite.md) | An anatomical location on a human which can be the focus of an act.**OpenIssue:**This value set was approved for**deletion**in November 2008, and was deleted at release #762. Subsequently, however, it was found that this deletion caused the legacy software embedded in the RMIM Designer in Visio to fail to show appropriate options for concepts in the subject area of this value set. For that reason, the value set was**re-added in releasse 813 and DEPRECATED from general use**at the same time. This value set should be deleted as soon as it is no longer required to support of the legacy software. |
| [HumanLanguage](ValueSet-v3-HumanLanguage.md) | Codes for the representation of the names of human languages. |
| [HumanSubstanceAdministrationSite](ValueSet-v3-HumanSubstanceAdministrationSite.md) | The set of body locations to or through which a drug product may be administered. |
| [ICUPracticeSetting](ValueSet-v3-ICUPracticeSetting.md) | ****No description**** |
| [IDClinPracticeSetting](ValueSet-v3-IDClinPracticeSetting.md) | ****No description**** |
| [IdentifierReliability](ValueSet-v3-IdentifierReliability.md) | **Description:**The identifier was issued by the system responsible for constructing the instance. |
| [IdentifierScope](ValueSet-v3-IdentifierScope.md) | **Description:**Codes to specify the scope in which the identifier applies to the object with which it is associated, and used in the datatype property II. |
| [Image Reference Type](ValueSet-image-reference-type.md) | The type of image reference specified by an imaging selection. |
| [ImageMediaType](ValueSet-v3-ImageMediaType.md) | Image media type. |
| [Immunization Evaluation Dose Status Reason codes](ValueSet-immunization-evaluation-dose-status-reason.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example. |
| [Immunization Evaluation Dose Status codes](ValueSet-immunization-evaluation-dose-status.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example. |
| [Immunization Function](ValueSet-immunization-function.md) | The value set defines the role that a performer has played in an immunization event. Core functions included in the value set including ordering and administering provider. If other concepts are necessary, the codes should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the function an individual or organization may play in the immunization event. |
| [Immunization Funding Source](ValueSet-immunization-funding-source.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the vaccine administered. This value set is provided as a suggestive example. |
| [Immunization Program Eligibility](ValueSet-immunization-program-eligibility.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the patient's eligibility for a vaccination program. This value set is provided as a suggestive example. |
| [Immunization Recommendation Status Codes](ValueSet-immunization-recommendation-status.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example. |
| [Immunization Subpotent Reason](ValueSet-immunization-subpotent-reason.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example. |
| [ImmunizationObservationType](ValueSet-v3-ImmunizationObservationType.md) | **Description:**Indicates the valid antigen count. |
| [Implant Status](ValueSet-implantStatus.md) | A set codes that define the functional status of an implanted device. |
| [Implantation](ValueSet-v3-Implantation.md) | Implantation |
| [IncidentalServiceDeliveryLocationRoleType](ValueSet-v3-IncidentalServiceDeliveryLocationRoleType.md) | ****No description**** |
| [IndividualCaseSafetyReportType](ValueSet-v3-IndividualCaseSafetyReportType.md) | All codes from code system ActCode._IndividualCaseSafetyReportType |
| [IndividualInsuredCoveredPartyRoleType](ValueSet-v3-IndividualInsuredCoveredPartyRoleType.md) | **Description**A role recognized through the eligibility of a party to play an individual insured for benefits covered or provided under an insurance policy where the party is also the policy holder. |
| [IndividualPackageEntityType](ValueSet-v3-IndividualPackageEntityType.md) | Container intended to contain sufficient material for only one use. |
| [IndustryClassificationSystem](ValueSet-v3-IndustryClassificationSystem.md) | ****No description**** |
| [InformationSensitivityPolicy](ValueSet-v2-0719.md) | Value Set of codes that specify the reason for the restricted access. Sensitivity codes are not useful for interoperability outside of a policy domain because sensitivity policies are typically localized and vary drastically across policy domains even for the same information category because of differing organizational business rules, security policies, and jurisdictional requirements. For example, an "employee" sensitivity code would make little sense for use outside of a policy domain. "Taboo" would rarely be useful outside of a policy domain unless there are jurisdictional requirements requiring that a provider disclose sensitive information to a patient directly. Sensitivity codes may be more appropriate in a legacy system's Master Files in order to notify those who access a patient's orders and observations about the sensitivity policies that apply. Newer systems may have a security engine that uses a sensitivity policy's criteria directly. The specializable Sensitivity Act.code may be useful in some scenarious if used in combination with a sensitivity identifier and/or Act.titleValue Set of codes that specify the reason for the restricted access. Note that this resource was created in THO in error due to an oversight in the import processing. |
| [InformationSensitivityPolicy](ValueSet-v3-InformationSensitivityPolicy.md) | Sensitivity codes are not useful for interoperability outside of a policy domain because sensitivity policies are typically localized and vary drastically across policy domains even for the same information category because of differing organizational business rules, security policies, and jurisdictional requirements. For example, an "employee" sensitivity code would make little sense for use outside of a policy domain. "Taboo" would rarely be useful outside of a policy domain unless there are jurisdictional requirements requiring that a provider disclose sensitive information to a patient directly. Sensitivity codes may be more appropriate in a legacy system's Master Files in order to notify those who access a patient's orders and observations about the sensitivity policies that apply. Newer systems may have a security engine that uses a sensitivity policy's criteria directly. The specializable Sensitivity Act.code may be useful in some scenarious if used in combination with a sensitivity identifier and/or Act.title. |
| [Infusion](ValueSet-v3-Infusion.md) | Infusion |
| [InhalantDrugForm](ValueSet-v3-InhalantDrugForm.md) | ****No description**** |
| [Inhalation](ValueSet-v3-Inhalation.md) | Inhalation |
| [InhalerMedicalDevice](ValueSet-v3-InhalerMedicalDevice.md) | A small device used for inhaling medicine in the form of a vapour or gas in order to ease a respiratory condition such as asthma or to relieve nasal congestion. |
| [Injection](ValueSet-v3-Injection.md) | Injection |
| [InjectionMedicalDevice](ValueSet-v3-InjectionMedicalDevice.md) | A device intended to administer liquid into a subject via a |
| [Insertion](ValueSet-v3-Insertion.md) | Insertion |
| [Instillation](ValueSet-v3-Instillation.md) | Instillation |
| [Institution](ValueSet-v3-Institution.md) | Institution |
| [Insurance Coverage Type](ValueSet-insurance-coverage-type.md) | This value set defines a set of codes for Insurance Coverage Type |
| [Insurance Product Type](ValueSet-insurance-product-type.md) | This value set defines a set of codes for Insurance Product Type |
| [Insurance plan type](ValueSet-insuranceplan-type.md) | This example value set defines a set of codes that can be used to indicate a type of insurance plan. |
| [Insuranceplan Plan Type](ValueSet-insuranceplan-plan-type.md) | This value set defines a set of codes for Insuranceplan Plan Type |
| [IntegrityCheckAlgorithm](ValueSet-v3-IntegrityCheckAlgorithm.md) | ****No description**** |
| [InteractionDetectedIssueCode](ValueSet-v3-InteractionDetectedIssueCode.md) | ****No description**** |
| [Interagency Language Roundtable Speaking Skill Scale](ValueSet-ILRSpeakingSkillScale.md) | This value set defines a set of codes for documenting spoken language proficiency based on the Interagency Language Roundtable scale of abilities to communicate in a language. |
| [InterameningealRoute](ValueSet-v3-InterameningealRoute.md) | Interameningeal |
| [InteriorSalish](ValueSet-v3-InteriorSalish.md) | ****No description**** |
| [InterstitialRoute](ValueSet-v3-InterstitialRoute.md) | Interstitial |
| [IntraabdominalRoute](ValueSet-v3-IntraabdominalRoute.md) | Intra-abdominal |
| [IntraarterialInjection](ValueSet-v3-IntraarterialInjection.md) | Injection, intraarterial |
| [IntraarterialRoute](ValueSet-v3-IntraarterialRoute.md) | Intra-arterial |
| [IntraarticularRoute](ValueSet-v3-IntraarticularRoute.md) | Intraarticular |
| [IntrabronchialRoute](ValueSet-v3-IntrabronchialRoute.md) | Intrabronchial |
| [IntrabursalRoute](ValueSet-v3-IntrabursalRoute.md) | Intrabursal |
| [IntracardiacInjection](ValueSet-v3-IntracardiacInjection.md) | Injection, intracardiac |
| [IntracardiacRoute](ValueSet-v3-IntracardiacRoute.md) | Intracardiac |
| [IntracartilaginousRoute](ValueSet-v3-IntracartilaginousRoute.md) | Intracartilaginous |
| [IntracaudalRoute](ValueSet-v3-IntracaudalRoute.md) | Intracaudal |
| [IntracavernosalRoute](ValueSet-v3-IntracavernosalRoute.md) | Intracavernosal |
| [IntracavitaryRoute](ValueSet-v3-IntracavitaryRoute.md) | Intracavitary |
| [IntracerebralRoute](ValueSet-v3-IntracerebralRoute.md) | Intracerebral |
| [IntracervicalRoute](ValueSet-v3-IntracervicalRoute.md) | Intracervical |
| [IntracisternalRoute](ValueSet-v3-IntracisternalRoute.md) | Intracisternal |
| [IntracornealRoute](ValueSet-v3-IntracornealRoute.md) | Intracorneal |
| [IntracoronalRoute](ValueSet-v3-IntracoronalRoute.md) | Intracoronal (dental) |
| [IntracoronaryInjection](ValueSet-v3-IntracoronaryInjection.md) | Injection, intracoronary |
| [IntracoronaryRoute](ValueSet-v3-IntracoronaryRoute.md) | Intracoronary |
| [IntracorpusCavernosumRoute](ValueSet-v3-IntracorpusCavernosumRoute.md) | Intracorpus cavernosum |
| [IntradermalRoute](ValueSet-v3-IntradermalRoute.md) | Intradermal |
| [IntradiscalRoute](ValueSet-v3-IntradiscalRoute.md) | Intradiscal |
| [IntraductalRoute](ValueSet-v3-IntraductalRoute.md) | Intraductal |
| [IntraduodenalRoute](ValueSet-v3-IntraduodenalRoute.md) | Intraduodenal |
| [IntraduralRoute](ValueSet-v3-IntraduralRoute.md) | Intradural |
| [IntraepidermalRoute](ValueSet-v3-IntraepidermalRoute.md) | Intraepidermal |
| [IntraepithelialRoute](ValueSet-v3-IntraepithelialRoute.md) | Intraepithelial |
| [IntraesophagealRoute](ValueSet-v3-IntraesophagealRoute.md) | Intraesophageal |
| [IntragastricRoute](ValueSet-v3-IntragastricRoute.md) | Intragastric |
| [IntrailealRoute](ValueSet-v3-IntrailealRoute.md) | Intraileal |
| [IntralesionalRoute](ValueSet-v3-IntralesionalRoute.md) | Intralesional |
| [IntraluminalRoute](ValueSet-v3-IntraluminalRoute.md) | Intraluminal |
| [IntralymphaticRoute](ValueSet-v3-IntralymphaticRoute.md) | Intralymphatic |
| [IntramedullaryRoute](ValueSet-v3-IntramedullaryRoute.md) | Intramedullary |
| [IntramuscularInjection](ValueSet-v3-IntramuscularInjection.md) | Injection, intramuscular |
| [IntramuscularRoute](ValueSet-v3-IntramuscularRoute.md) | Intramuscular |
| [IntraocularRoute](ValueSet-v3-IntraocularRoute.md) | Intraocular |
| [IntraosseousRoute](ValueSet-v3-IntraosseousRoute.md) | Intraosseous |
| [IntraovarianRoute](ValueSet-v3-IntraovarianRoute.md) | Intraovarian |
| [IntrapericardialRoute](ValueSet-v3-IntrapericardialRoute.md) | Intrapericardial |
| [IntraperitonealRoute](ValueSet-v3-IntraperitonealRoute.md) | Intraperitoneal |
| [IntrapleuralRoute](ValueSet-v3-IntrapleuralRoute.md) | Intrapleural |
| [IntraprostaticRoute](ValueSet-v3-IntraprostaticRoute.md) | Intraprostatic |
| [IntrapulmonaryRoute](ValueSet-v3-IntrapulmonaryRoute.md) | Intrapulmonary |
| [IntrasinalRoute](ValueSet-v3-IntrasinalRoute.md) | Intrasinal |
| [IntraspinalRoute](ValueSet-v3-IntraspinalRoute.md) | Intraspinal |
| [IntrasternalRoute](ValueSet-v3-IntrasternalRoute.md) | Intrasternal |
| [IntrasynovialRoute](ValueSet-v3-IntrasynovialRoute.md) | Intrasynovial |
| [IntratendinousRoute](ValueSet-v3-IntratendinousRoute.md) | Intratendinous |
| [IntratesticularRoute](ValueSet-v3-IntratesticularRoute.md) | Intratesticular |
| [IntrathecalRoute](ValueSet-v3-IntrathecalRoute.md) | Intrathecal |
| [IntrathoracicRoute](ValueSet-v3-IntrathoracicRoute.md) | Intrathoracic |
| [IntratrachealRoute](ValueSet-v3-IntratrachealRoute.md) | Intratracheal |
| [IntratubularRoute](ValueSet-v3-IntratubularRoute.md) | Intratubular |
| [IntratumorRoute](ValueSet-v3-IntratumorRoute.md) | Intratumor |
| [IntratympanicRoute](ValueSet-v3-IntratympanicRoute.md) | Intratympanic |
| [IntrauterineRoute](ValueSet-v3-IntrauterineRoute.md) | Intrauterine |
| [IntravascularRoute](ValueSet-v3-IntravascularRoute.md) | Intravascular |
| [IntravenousInfusion](ValueSet-v3-IntravenousInfusion.md) | Infusion, intravenous |
| [IntravenousInjection](ValueSet-v3-IntravenousInjection.md) | Injection, intravenous |
| [IntravenousRoute](ValueSet-v3-IntravenousRoute.md) | Intravenous |
| [IntraventricularRoute](ValueSet-v3-IntraventricularRoute.md) | Intraventricular |
| [IntravesicleRoute](ValueSet-v3-IntravesicleRoute.md) | Intravesicle |
| [IntravitrealRoute](ValueSet-v3-IntravitrealRoute.md) | Intravitreal |
| [InuitInupiaq](ValueSet-v3-InuitInupiaq.md) | ****No description**** |
| [InvoiceElementAdjudicated](ValueSet-v3-InvoiceElementAdjudicated.md) | Total counts and total net amounts adjudicated for all Invoice Groupings that were adjudicated within a time period based on the adjudication date of the Invoice Grouping. |
| [InvoiceElementPaid](ValueSet-v3-InvoiceElementPaid.md) | Total counts and total net amounts paid for all Invoice Groupings that were paid within a time period based on the payment date. |
| [InvoiceElementSubmitted](ValueSet-v3-InvoiceElementSubmitted.md) | Total counts and total net amounts billed for all Invoice Groupings that were submitted within a time period. Adjudicated invoice elements are included. |
| [IontophoresisRoute](ValueSet-v3-IontophoresisRoute.md) | Iontophoresis |
| [Iroquoian](ValueSet-v3-Iroquoian.md) | ****No description**** |
| [Irrigation](ValueSet-v3-Irrigation.md) | Irrigation |
| [IrrigationSolution](ValueSet-v3-IrrigationSolution.md) | A sterile solution intended to bathe or flush open wounds or body cavities; they're used topically, never parenterally. |
| [IssueFilterCode](ValueSet-v3-IssueFilterCode.md) | **Description:**Indicates how result sets should be filtered based on whether they have associated issues. |
| [JejunumRoute](ValueSet-v3-JejunumRoute.md) | Jejunum |
| [Jurisdiction ValueSet](ValueSet-jurisdiction.md) | This value set defines a base set of codes for country, country subdivision and region for indicating where a resource is intended to be used. Note: The codes for countries and country subdivisions are taken from[ISO 3166](https://www.iso.org/iso-3166-country-codes.html)while the codes for "supra-national" regions are from[UN Standard country or area codes for statistical use (M49)](http://unstats.un.org/unsd/methods/m49/m49.htm). |
| [Kalapuyan](ValueSet-v3-Kalapuyan.md) | ****No description**** |
| [Keresan](ValueSet-v3-Keresan.md) | ****No description**** |
| [KiowaTanoan](ValueSet-v3-KiowaTanoan.md) | ****No description**** |
| [KitEntityType](ValueSet-v3-KitEntityType.md) | A container for a diverse collection of products intended to be used together for some purpose (e.g. Medicinal kits often contain a syringe, a needle and the injectable medication). |
| [KnowledgeSubjectObservationCode](ValueSet-v3-KnowledgeSubjectObservationCode.md) | ****No description**** |
| [KnowledgeSubjectObservationValue](ValueSet-v3-KnowledgeSubjectObservationValue.md) | Observation values used to indicate a knowledge subject of interest for which knowledge content is requested (e.g., a medication, a laboratory test, a medical condition). |
| [KnowledgeSubtopicObservationCode](ValueSet-v3-KnowledgeSubtopicObservationCode.md) | ****No description**** |
| [KnowledgeSubtopicObservationValue](ValueSet-v3-KnowledgeSubtopicObservationValue.md) | Observation values used to indicate a knowledge subtopic of interest for which knowledge content is requested (e.g., treatment, etiology, prognosis). |
| [KoyukonIngalik](ValueSet-v3-KoyukonIngalik.md) | ****No description**** |
| [KutchinHan](ValueSet-v3-KutchinHan.md) | ****No description**** |
| [LOINCObservationActContextAgeDefinitionCode](ValueSet-v3-LOINCObservationActContextAgeDefinitionCode.md) | Identifies a type of observation that captures the age of an entity involved in an act with no implied method of determination. |
| [LOINCObservationActContextAgeType](ValueSet-v3-LOINCObservationActContextAgeType.md) | **Definition:**The set of LOINC codes for the act of determining the period of time that has elapsed since an entity was born or created. |
| [LabResultReportingProcessStepCode](ValueSet-v3-LabResultReportingProcessStepCode.md) | ****No description**** |
| [LabResultTriggerEvents](ValueSet-v3-LabResultTriggerEvents.md) | **Description:**Trigger Event ID as published in the standard. |
| [LabSpecimenCollectionProviders](ValueSet-v3-LabSpecimenCollectionProviders.md) | ****No description**** |
| [Laboratory Observation Sub-Type](ValueSet-v3-LaboratoryObservationSubtype.md) | Value Set of codes specifying an observation sub-type used with observation type code RSLT (Result). |
| [LacrimalPunctaRoute](ValueSet-v3-LacrimalPunctaRoute.md) | Lacrimal puncta |
| [LanguageAbilityMode](ValueSet-v3-LanguageAbilityMode.md) | A value representing the method of expression of the language.**Example:**Expressed spoken, expressed written, expressed signed, received spoken, received written, received signed. |
| [LanguageAbilityProficiency](ValueSet-v3-LanguageAbilityProficiency.md) | A value representing the level of proficiency in a language.**Example:**Excellent, good, fair, poor. |
| [Languages](ValueSet-Languages.md) | This value set defines a set of codes for the representation of the names of languages. It uses the list of ISO 639-2 concepts using the ISO 639-1 2-digit code for a concept where possible and the 3-digit terminological code where there is no 2-digit code. |
| [LaryngealRoute](ValueSet-v3-LaryngealRoute.md) | Laryngeal |
| [LavageRoute](ValueSet-v3-LavageRoute.md) | Lavage |
| [LengthOutOfRange](ValueSet-v3-LengthOutOfRange.md) | ****No description**** |
| [LibraryType](ValueSet-library-type.md) | The type of knowledge asset this library contains. |
| [LifeInsurancePolicy](ValueSet-v3-LifeInsurancePolicy.md) | **Definition:**A policy under which the insurer agrees to pay a sum of money upon the occurrence of the covered partys death. In return, the policyholder agrees to pay a stipulated amount called a premium at regular intervals. Life insurance indemnifies the beneficiary for the loss of the insurable interest that a beneficiary has in the life of a covered party. For persons related by blood, a substantial interest established through love and affection, and for all other persons, a lawful and substantial economic interest in having the life of the insured continue. An insurable interest is required when purchasing life insurance on another person. Specific exclusions are often written into the contract to limit the liability of the insurer; for example claims resulting from suicide or relating to war, riot and civil commotion.**Discussion:**A life insurance policy may be used by the covered party as a source of health care coverage in the case of a viatical settlement, which is the sale of a life insurance policy by the policy owner, before the policy matures. Such a sale, at a price discounted from the face amount of the policy but usually in excess of the premiums paid or current cash surrender value, provides the seller an immediate cash settlement. Generally, viatical settlements involve insured individuals with a life expectancy of less than two years. In countries without state-subsidized healthcare and high healthcare costs (e.g. United States), this is a practical way to pay extremely high health insurance premiums that severely ill people face. Some people are also familiar with life settlements, which are similar transactions but involve insureds with longer life expectancies (two to fifteen years). |
| [LineAccessMedicalDevice](ValueSet-v3-LineAccessMedicalDevice.md) | A hollow tube used to administer a substance into a vein, artery or body cavity |
| [LingualRoute](ValueSet-v3-LingualRoute.md) | Lingual |
| [Liquid](ValueSet-v3-Liquid.md) | A state of substance that is an intermediate one entered into as matter goes from solid to gas; liquids are also intermediate in that they have neither the orderliness of a crystal nor the randomness of a gas. (Note: This term should not be used to describe solutions, only pure chemicals in their liquid state.) |
| [LiquidCleanser](ValueSet-v3-LiquidCleanser.md) | ****No description**** |
| [LiquidLiquidEmulsion](ValueSet-v3-LiquidLiquidEmulsion.md) | A two-phase system in which one liquid is dispersed throughout another liquid in the form of small droplets. |
| [LiquidSolidSuspension](ValueSet-v3-LiquidSolidSuspension.md) | A liquid preparation which consists of solid particles dispersed throughout a liquid phase in which the particles are not soluble. |
| [List Empty Reasons](ValueSet-list-empty-reason.md) | General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list). |
| [List Order Codes](ValueSet-list-order.md) | Base values for the order of item lists in resources. |
| [ListStyle](ValueSet-v3-ListStyle.md) | Defines list rendering characteristics |
| [LivingArrangement](ValueSet-v3-LivingArrangement.md) | A code depicting the living arrangements of a person |
| [LivingSubjectProductionClass](ValueSet-v3-LivingSubjectProductionClass.md) | Code indicating the primary use for which a living subject is bred or grown |
| [Loan](ValueSet-v3-Loan.md) | Temporary supply of a product without transfer of ownership for the product. |
| [LocalMarkupIgnore](ValueSet-v3-LocalMarkupIgnore.md) | Tells a receiver to ignore just the local markup tags (local_markup, local_header, local_attr) when value="markup", or to ignore the local markup tags and all contained content when value="all" |
| [LocalRemoteControlState](ValueSet-v3-LocalRemoteControlState.md) | A value representing the current state of control associated with the device.**Examples:**A device can either work autonomously (localRemoteControlStateCode="Local") or it can be controlled by another system (localRemoteControlStateCode="Remote").**Rationale:**The control status of a device must be communicated between devices prior to remote commands being transmitted. If the device is not in "Remote" status then external commands will be ignored. |
| [Location type](ValueSet-location-physical-type.md) | This example value set defines a set of codes that can be used to indicate the physical form of the Location. |
| [LogicalObservationIdentifierNamesAndCodes](ValueSet-v3-LogicalObservationIdentifierNamesAndCodes.md) | The LOINC database provides a set of universal names and ID codes for identifying laboratory and clinical test results. The purpose is to facilitate the exchange and pooling of results, such as blood hemoglobin, serum potassium, or vital signs, for clinical care, outcomes management, and research. The LOINC codes are not intended to transmit all possible information about a test or observation. They are only intended to identify the test result or clinical observation. http://www.regenstrief.org/LOINC/LOINC.htm |
| [LoincDocumentOntologyInternational](ValueSet-v3-LoincDocumentOntologyInternational.md) | The LOINC Document Ontology constrained for usage in the Universal Realm by removal of "regional" Document Types such as the "VA Compensation and Pension" codes. |
| [LotionDrugForm](ValueSet-v3-LotionDrugForm.md) | The term "lotion" has been used to categorize many topical suspensions, solutions and emulsions intended for application to the skin. |
| [MIF Concept Relationship Kind](ValueSet-mif-conceptRelationshipKind.md) | Codes for use in the ext-mif-relationship-relationshipKind to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.relationshipKind values |
| [MIF Concept Relationship Reflexivity](ValueSet-mif-conceptRelationshipReflexivity.md) | Codes for use in the ext-mif-relationship-reflexivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.reflexivity values |
| [MIF Concept Relationship Symmetry](ValueSet-mif-conceptRelationshipSymmetry.md) | Codes for use in the ext-mif-relationship-symmetry to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.symmetry values |
| [MIF Concept Relationship Transitivity](ValueSet-mif-conceptRelationshipTransitivity.md) | Codes for use in the ext-mif-relationship-transitivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.transitivity values |
| [Maiduan](ValueSet-v3-Maiduan.md) | ****No description**** |
| [ManagedCarePolicy](ValueSet-v3-ManagedCarePolicy.md) | **Definition:**Government mandated program providing coverage, disability income, and vocational rehabilitation for injuries sustained in the work place or in the course of employment. Employers may either self-fund the program, purchase commercial coverage, or pay a premium to a government entity that administers the program. Employees may be required to pay premiums toward the cost of coverage as well. Managed care policies specifically exclude coverage for losses insured under a disability policy, workers' compensation program, liability insurance (including automobile insurance); or for medical expenses, coverage for on-site medical clinics or for limited dental or vision benefits when these are provided under a separate policy.**Discussion:**Managed care policies are offered by managed care plans that contract with selected providers or health care organizations to provide comprehensive health care at a discount to covered parties and coordinate the financing and delivery of health care. Managed care uses medical protocols and procedures agreed on by the medical profession to be cost effective, also known as medical practice guidelines. Providers are typically reimbursed for covered services by a capitated amount on a per member per month basis that may reflect difference in the health status and level of services anticipated to be needed by the member. |
| [ManagedParticipationStatus](ValueSet-v3-ManagedParticipationStatus.md) | Codes representing the defined possible states of a Managed Participation, as defined by the Managed Participation class state machine. |
| [ManagedParticipationStatusActive](ValueSet-v3-ManagedParticipationStatusActive.md) | The state representing the fact that the Participation is in progress. |
| [ManagedParticipationStatusCancelled](ValueSet-v3-ManagedParticipationStatusCancelled.md) | The terminal state resulting from cancellation of the Participation prior to activation. |
| [ManagedParticipationStatusCompleted](ValueSet-v3-ManagedParticipationStatusCompleted.md) | The terminal state representing the successful completion of the Participation. |
| [ManagedParticipationStatusNormal](ValueSet-v3-ManagedParticipationStatusNormal.md) | The 'typical' state. Excludes "nullified" which represents the termination state of a participation instance that was created in error. |
| [ManagedParticipationStatusNullified](ValueSet-v3-ManagedParticipationStatusNullified.md) | The state representing the termination of a Participation instance that was created in error. |
| [ManagedParticipationStatusPending](ValueSet-v3-ManagedParticipationStatusPending.md) | The state representing that fact that the Participation has not yet become active. |
| [Manufacturer Model Name Example](ValueSet-v3-ManufacturerModelNameExample.md) | An example value set representing the ManufacturerModelName concept domain used to convey a coded name for the software used to author content. |
| [MapRelationship](ValueSet-v3-MapRelationship.md) | The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept identifier) and the source coding system. The values are patterned after the similar relationships used in the UMLS Metathesaurus. Because the HL7 coding sy |
| [MaritalStatus](ValueSet-v3-MaritalStatus.md) | The domestic partnership status of a person.**Example:**Married, separated, divorced, widowed, common-law marriage. |
| [MatchGrade](ValueSet-match-grade.md) | A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not. |
| [MaterialDangerInfectious](ValueSet-v3-MaterialDangerInfectious.md) | Material known to be infectious with human pathogenic microorganisms. Those who handle this material must take precautions for their protection. |
| [MaterialDangerInflammable](ValueSet-v3-MaterialDangerInflammable.md) | Material is highly inflammable and in certain mixtures (with air) may lead to explosions. Keep away from fire, sparks and excessive heat. |
| [MaterialEntityClassType](ValueSet-v3-MaterialEntityClassType.md) | Types of Material for EntityClass "MAT" |
| [MaxOccurs](ValueSet-question-max-occurs.md) | Flags an element as having unlimited repetitions. |
| [Measure Aggregate Method](ValueSet-measure-aggregate-method.md) | Aggregation method for a measure (e.g. sum, average, median, minimum, maximum, count) |
| [Measure Scoring](ValueSet-measure-scoring.md) | The scoring type of the measure. |
| [Measure Supplemental Data](ValueSet-measure-supplemental-data.md) | Supplemental data in a population for measuring purposes. |
| [MeasureDataUsage](ValueSet-measure-data-usage.md) | The intended usage for supplemental data elements in the measure. |
| [MeasureImprovementNotation](ValueSet-measure-improvement-notation.md) | Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue. |
| [MeasurePopulationType](ValueSet-measure-population.md) | The type of population. |
| [MeasureType](ValueSet-measure-type.md) | The type of measure (includes codes from 2.16.840.1.113883.1.11.20368). |
| [MedOncClinPracticeSetting](ValueSet-v3-MedOncClinPracticeSetting.md) | ****No description**** |
| [MediaType](ValueSet-v3-MediaType.md) | Internet Assigned Numbers Authority (IANA) Mime Media Types |
| [Medical Management Type](ValueSet-medical-management-type.md) | This value set includes types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates. |
| [MedicalDevice](ValueSet-v3-MedicalDevice.md) | A device with direct or indirect therapeutic purpose. Values for EntityCode when EntityClass = "DEV" |
| [Medication administration performer function codes](ValueSet-med-admin-perform-function.md) | MedicationAdministration Performer Function Codes |
| [Medication dispense performer function codes](ValueSet-medicationdispense-performer-function.md) | MedicationDispense Performer Function Codes |
| [Medication knowledge characteristic codes](ValueSet-medicationknowledge-characteristic.md) | MedicationKnowledge Characteristic Codes |
| [Medication knowledge package type codes](ValueSet-medicationknowledge-package-type.md) | MedicationKnowledge Package Type Codes |
| [Medication knowledge status codes](ValueSet-medicationknowledge-status.md) | MedicationKnowledge Status Codes |
| [Medication request category codes](ValueSet-medicationrequest-category.md) | MedicationRequest Category Codes |
| [Medication request course of therapy codes](ValueSet-medicationrequest-course-of-therapy.md) | MedicationRequest Course of Therapy Codes |
| [Medication request status reason codes](ValueSet-medicationrequest-status-reason.md) | MedicationRequest Status Reason Codes |
| [MedicationAdministrationLocation](ValueSet-medication-admin-location.md) | Direction in which lists of possible answers should be displayed. |
| [MedicationCap](ValueSet-v3-MedicationCap.md) | Cap types for medication containers |
| [MedicationGeneralizationRoleType](ValueSet-v3-MedicationGeneralizationRoleType.md) | Identifies the specific hierarchical relationship between the playing and scoping medications.**Examples:**Generic, Generic Formulation, Therapeutic Class, etc. |
| [MedicationObservationType](ValueSet-v3-MedicationObservationType.md) | ****No description**** |
| [MedicationOrderAbortReasonCode](ValueSet-v3-MedicationOrderAbortReasonCode.md) | ****No description**** |
| [MedicationOrderReleaseReasonCode](ValueSet-v3-MedicationOrderReleaseReasonCode.md) | **Definition:**A collection of concepts that indicate why the prescription should be released from suspended state. |
| [MedicationRequestAdministrationLocation](ValueSet-medicationrequest-admin-location.md) | Direction in which lists of possible answers should be displayed. |
| [MedicationUsageAdministrationLocation](ValueSet-medication-usage-admin-location.md) | Direction in which lists of possible answers should be displayed. |
| [MemberRoleType](ValueSet-v3-MemberRoleType.md) | A role type that is used to further qualify an entity playing a role where the role class attribute is set to RoleClassMember. |
| [MessageWaitingPriority](ValueSet-v3-MessageWaitingPriority.md) | Indicates the highest importance level of the set of messages the acknowledging application has waiting on a queue for the receiving application.**Discussion:**These messages would need to be retrieved via a query. This facilitates receiving applications that cannot receive unsolicited messages (i.e. polling). The specific code specified identifies how important the most important waiting message is (and may govern how soon the receiving application is required to poll for the message). Priority may be used by local agreement to determine the timeframe in which the receiving application is expected to retrieve the messages from the queue. |
| [MilitaryHospital](ValueSet-v3-MilitaryHospital.md) | A health care facility operated by the Department of Defense or other military operation. |
| [MilitaryRoleType](ValueSet-v3-MilitaryRoleType.md) | **Definition:**A person playing the role of program eligible under a program based on military status.**Discussion:**This CoveredPartyRoleType.code is typically used when the CoveredPartyRole class code is either "program eligible" or "subscriber" and the person's status as a member of the military meets jurisdictional or program criteria |
| [Missing Tooth Reason Codes](ValueSet-missing-tooth-reason.md) | This value set includes sample Missing Tooth Reason codes. |
| [MississippiValley](ValueSet-v3-MississippiValley.md) | ****No description**** |
| [MissouriRiver](ValueSet-v3-MissouriRiver.md) | ****No description**** |
| [Miwokan](ValueSet-v3-Miwokan.md) | ****No description**** |
| [MobileUnit](ValueSet-v3-MobileUnit.md) | Location (mobile) where healthcare service was delivered. |
| [MobilityImpaired](ValueSet-v3-MobilityImpaired.md) | ****No description**** |
| [ModelMediaType](ValueSet-v3-ModelMediaType.md) | Model media type. |
| [Modifier type Codes](ValueSet-claim-modifiers.md) | This value set includes sample Modifier type codes. |
| [ModifyIndicator](ValueSet-v3-ModifyIndicator.md) | Indicates whether the subscription to a query is new or is being modified. |
| [ModifyPrescriptionReasonType](ValueSet-v3-ModifyPrescriptionReasonType.md) | Indicates why an existing prescription is changed. |
| [MucosalAbsorptionRoute](ValueSet-v3-MucosalAbsorptionRoute.md) | Mucosal absorption |
| [MucousMembraneRoute](ValueSet-v3-MucousMembraneRoute.md) | Mucous membrane |
| [MultiUseContainerEntityType](ValueSet-v3-MultiUseContainerEntityType.md) | A container intended to contain sufficient material for more than one use. (I.e. Material is intended to be removed from the container at more than one discrete time period.) |
| [MultipartMediaType](ValueSet-v3-MultipartMediaType.md) | Multipart Media Type |
| [Muskogean](ValueSet-v3-Muskogean.md) | ****No description**** |
| [NDH Healthcare Service Category](ValueSet-ndh-healthcare-service-category.md) | This value set defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH). |
| [NUCCProviderCodes](ValueSet-v3-NUCCProviderCodes.md) | In the absence of an all-encompassing Provider Classification System, both X12N and the National Provider System Workgroup from the Centers for Medicare and Medicaid Services (CMS) commenced work on identifying and coding an external provider table that would be able to codify provider type and provider area of specialization for all medical related providers. CMS' intent was to provide a single coding structure to support work on the National Provider System, while X12N needed a single common table for trading partner use. The two projects worked independently to some extent until April 1996 when the lists were coordinated and a single taxonomy was proposed. A sub-group of the X12N TG2 WG 15 was charged with resolving differences in the two proposed taxonomies. Their work resulted in a single taxonomy that both CMS and members of X12N found meaningful, easy to use, and functional for electronic transactions. The sub-group initially started with the CMS draft taxonomy. This list incorporated all types of providers associated with medical care in various ways. Many of the providers listed, such as technologists or technicians, support or repair equipment/machinery. A number of the providers offer medical services, in concert with others, and do not or cannot bill independently for their portion. The amount of research to validate and classify all providers using the proposed hierarchical structure was enormous. The X12N sub-group focused on medical providers who are licensed practitioners, those who bill for health-related services rendered, and those who appeared on the Medicare CMS Provider Specialty listing. This included providers who were licensed to practice medicine via state licensure agencies. In addition, a very broad definition of "areas of specialization" was used, which included nationally recognized specialties, provider self-designated specialties, areas of practice focus, and any request by any agency or trading partner submitted before the first taxonomy release. This level of detail captured specialty information in categories detailed enough to support those trading credentialing information, yet broad enough to support those wishing to trade directory level specialization information. In 2001, ANSI ASC X12N asked the NUCC to become the official maintainer of the Health Care Provider Taxonomy List. The NUCC has a formal operating protocol and its membership includes representation from key provider and payer organizations, as well as state and federal agencies, standard development organizations and the National Uniform Billing Committee (NUBC). Criteria for membership includes a national scope and representation of a unique constituency affected by health care electronic commerce, with an emphasis on maintaining a provider/payer balance. |
| [Nadene](ValueSet-v3-Nadene.md) | ****No description**** |
| [NailRoute](ValueSet-v3-NailRoute.md) | Nail |
| [NameLegalUse](ValueSet-v3-NameLegalUse.md) | ****No description**** |
| [NasalInhalation](ValueSet-v3-NasalInhalation.md) | Inhalation, nasal |
| [NasalRoute](ValueSet-v3-NasalRoute.md) | Nasal |
| [NationEntityType](ValueSet-v3-NationEntityType.md) | Codes identifying nation states. Allows for finer grained specification of Entity with classcode <= NAT**Example:**ISO3166 country codes. |
| [NativeEntityAlaska](ValueSet-v3-NativeEntityAlaska.md) | NATIVE ENTITIES WITHIN THE STATE OF ALASKA RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS |
| [NativeEntityContiguous](ValueSet-v3-NativeEntityContiguous.md) | NATIVE ENTITIES WITHIN THE CONTIGUOUS 48 STATES |
| [NaturalChild](ValueSet-v3-NaturalChild.md) | A child as determined by birth. |
| [NaturalParent](ValueSet-v3-NaturalParent.md) | ****No description**** |
| [NaturalSibling](ValueSet-v3-NaturalSibling.md) | The player of the role has both biological parents in common with the scoping entity. |
| [Nebulization](ValueSet-v3-Nebulization.md) | Nebulization |
| [NebulizationInhalation](ValueSet-v3-NebulizationInhalation.md) | Inhalation, nebulization |
| [Need](ValueSet-verificationresult-need.md) | The frequency with which the target must be validated |
| [NephClinPracticeSetting](ValueSet-v3-NephClinPracticeSetting.md) | ****No description**** |
| [Network Type Codes](ValueSet-benefit-network.md) | This value set includes the codes indicating the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product. |
| [NieceNephew](ValueSet-v3-NieceNephew.md) | The player of the role is a child of scoping person's brother or sister or of the brother or sister of the scoping person's spouse. |
| [NoInformation](ValueSet-v3-NoInformation.md) | **Description:**The value is exceptional (missing, omitted, incomplete, improper). No information as to the reason for being an exceptional value is provided. This is the most general exceptional value. It is also the default exceptional value. |
| [NonDrugAgentEntity](ValueSet-v3-NonDrugAgentEntity.md) | Indicates types of allergy and intolerance agents which are non-drugs. (E.g. foods, latex, etc.) |
| [NonRigidContainerEntityType](ValueSet-v3-NonRigidContainerEntityType.md) | A container having dimensions that adjust somewhat based on the amount and shape of the material placed within it. |
| [Nootkan](ValueSet-v3-Nootkan.md) | ****No description**** |
| [NorthernCaddoan](ValueSet-v3-NorthernCaddoan.md) | ****No description**** |
| [NorthernIroquoian](ValueSet-v3-NorthernIroquoian.md) | ****No description**** |
| [NullFlavor](ValueSet-v3-NullFlavor.md) | ****No description**** |
| [Numic](ValueSet-v3-Numic.md) | ****No description**** |
| [NursingOrCustodialCarePracticeSetting](ValueSet-v3-NursingOrCustodialCarePracticeSetting.md) | ****No description**** |
| [Nutrition intake category codes](ValueSet-nutrition-intake-category.md) | NutritionIntake Category Codes |
| [ObligationPolicy](ValueSet-v3-ObligationPolicy.md) | Conveys the mandated workflow action that an information custodian, receiver, or user must perform.**Examples:*** encrypt **Usage Note:** Per OASIS XACML, an obligation is an operation specified in a policy or policy that is performed in conjunction with the enforcement of an access control decision.
 |
| [Observation Category Codes](ValueSet-observation-category.md) | Observation Category codes. |
| [Observation Reference Range Meaning Codes](ValueSet-referencerange-meaning.md) | This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population. |
| [ObservationActContextAgeGroupType](ValueSet-v3-ObservationActContextAgeGroupType.md) | Identifies a type of observation that captures the age of a person in terms of age group concept codes. |
| [ObservationActContextAgeType](ValueSet-v3-ObservationActContextAgeType.md) | **Definition:**The ways the age of an entity involved in an act can be measured, calculated or otherwise expressed in order to provide context for another act. |
| [ObservationAlert](ValueSet-v3-ObservationAlert.md) | ****No description**** |
| [ObservationAllergyType](ValueSet-v3-ObservationAllergyType.md) | Hypersensitivity to an agent caused by an immunologic response to an initial exposure. |
| [ObservationAssetValue](ValueSet-v3-ObservationAssetValue.md) | Codes specifying asset indicators used to assess or establish eligibility for coverage under a policy or program. |
| [ObservationCategory](ValueSet-v3-ObservationCategory.md) | High level observation categories for the general type of observation being made.**Steward:**OO WG |
| [ObservationCoordinateAxisType](ValueSet-v3-ObservationCoordinateAxisType.md) | ****No description**** |
| [ObservationCoordinateSystemType](ValueSet-v3-ObservationCoordinateSystemType.md) | ****No description**** |
| [ObservationDetectedIssueCode](ValueSet-v3-ObservationDetectedIssueCode.md) | Proposed therapy may be inappropriate or contraindicated due to conditions or characteristics of the patient |
| [ObservationDiagnosisTypes](ValueSet-v3-ObservationDiagnosisTypes.md) | An observation about the presence (or absence) of a particular disease state in a subject. |
| [ObservationDrugIntoleranceType](ValueSet-v3-ObservationDrugIntoleranceType.md) | Hypersensitivity resulting in an adverse reaction upon exposure to a drug. |
| [ObservationEligibilityIndicatorValue](ValueSet-v3-ObservationEligibilityIndicatorValue.md) | Code specifying eligibility indicators used to assess or establish eligibility for coverage under a policy or program eligibility status, e.g., certificates of creditable coverage; student enrollment; adoption, marriage or birth certificate. |
| [ObservationEnvironmentalIntoleranceType](ValueSet-v3-ObservationEnvironmentalIntoleranceType.md) | Hypersensitivity resulting in an adverse reaction upon exposure to environmental conditions. |
| [ObservationFoodIntoleranceType](ValueSet-v3-ObservationFoodIntoleranceType.md) | Hypersensitivity resulting in an adverse reaction upon exposure to food. |
| [ObservationHealthStatusValue](ValueSet-v3-ObservationHealthStatusValue.md) | Code specifying non-clinical indicators related to health status used to assess or establish eligibility for coverage under a policy or program, e.g., pregnancy, disability, drug use, mental health issues. |
| [ObservationIncomeValue](ValueSet-v3-ObservationIncomeValue.md) | Code specifying financial indicators used to assess or establish eligibility for coverage under a policy or program; e.g., pay stub; tax or income document; asset document; living expenses. |
| [ObservationInterpretation](ValueSet-v3-ObservationInterpretation.md) | One or more codes providing a rough qualitative interpretation of the observation,such as "normal" / "abnormal", "low" / "high", "better" / "worse", "resistant" / "susceptible", "expected" / "not expected". The value set is intended to be for ANY use where coded representation of an interpretation is needed.**Usage Note:**This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. |
| [ObservationInterpretationChange](ValueSet-v3-ObservationInterpretationChange.md) | Interpretations of change of quantity and/or severity, such as "better", "worse", "increased", etc. At most one of B or W and one of U or D allowed. |
| [ObservationInterpretationDetected](ValueSet-v3-ObservationInterpretationDetected.md) | Interpretations of the presence or absence of a component / analyte or organism in a test or of a sign in a clinical observation. In keeping with laboratory data processing practice, these concepts provide a categorical interpretation of the "meaning" of the quantitative value for the same observation. |
| [ObservationInterpretationExceptions](ValueSet-v3-ObservationInterpretationExceptions.md) | Technical exceptions resulting in the inability to provide an interpretation. At most one allowed. Does not imply normality or severity. |
| [ObservationInterpretationExpectation](ValueSet-v3-ObservationInterpretationExpectation.md) | Observation interpretation codes for expected results based on additional information (contraindicators) about the patient's situation. |
| [ObservationInterpretationNormality](ValueSet-v3-ObservationInterpretationNormality.md) | Interpretation of normality or degree of abnormality (including critical or "alert" level). Concepts in this category are mutually exclusive, i.e., at most one is allowed. |
| [ObservationInterpretationNormalityAbnormal](ValueSet-v3-ObservationInterpretationNormalityAbnormal.md) | Interpretation of degree of abnormality (including critical or "alert" level). Concepts in this category are mutually exclusive, i.e., at most one is allowed. |
| [ObservationInterpretationNormalityCriticallyAbnormal](ValueSet-v3-ObservationInterpretationNormalityCriticallyAbnormal.md) | Interpretation of a critical (or "alert") degree of abnormality. Concepts in this category are mutually exclusive, i.e., at most one is allowed. |
| [ObservationInterpretationNormalityHigh](ValueSet-v3-ObservationInterpretationNormalityHigh.md) | Interpretation for a quantitative observation of degree of abnormality (including critical or "alert" level) above the upper limit of the reference range. |
| [ObservationInterpretationNormalityLow](ValueSet-v3-ObservationInterpretationNormalityLow.md) | Interpretation for a quantitative observation of degree of abnormality (including critical or "alert" level) below the lower limit of the reference range. |
| [ObservationInterpretationOustsideThreshold](ValueSet-v3-ObservationInterpretationOustsideThreshold.md) | The observation/test result is interpreted as being outside the inclusion range for a particular protocol within which the result is being reported.**Example:**A positive result on a Hepatitis screening test.**Open Issue:**We are not deprecating this value set at this time, but instead are leaving open the consideration of deprecation in the future. [Note: The concepts included in this value set have also been suggested for future deprecation, and there are no associated concept subdomains or bindings. Note also that the name of the value set appears to have a typo in it from the old cycle when it was originally added.] |
| [ObservationInterpretationProtocolInclusion](ValueSet-v3-ObservationInterpretationProtocolInclusion.md) | The observation/test result is interpreted as being outside the inclusion range for a particular protocol within which the result is being reported.**Example:**A positive result on a Hepatitis screening test.**Open Issue:**We are not deprecating this value set at this time, but instead are leaving open the consideration of deprecation in the future. [Note: The concepts included in this value set have also been suggested for future deprecation, and there are no associated concept subdomains or bindings.] |
| [ObservationInterpretationSusceptibility](ValueSet-v3-ObservationInterpretationSusceptibility.md) | Interpretations of anti-microbial susceptibility testing results (microbiology). At most one allowed. |
| [ObservationIntoleranceType](ValueSet-v3-ObservationIntoleranceType.md) | Hypersensitivity resulting in an adverse reaction upon exposure to an agent. |
| [ObservationIssueTriggerCodedObservationType](ValueSet-v3-ObservationIssueTriggerCodedObservationType.md) | Distinguishes the kinds of coded observations that could be the trigger for clinical issue detection. These are observations that are not measurable, but instead can be defined with codes. Coded observation types include: Allergy, Intolerance, Medical Condition, Pregnancy status, etc. |
| [ObservationLivingDependencyValue](ValueSet-v3-ObservationLivingDependencyValue.md) | Continued living in private residence requires functional and health care assistance from spouse or life partner. |
| [ObservationLivingExpenseValue](ValueSet-v3-ObservationLivingExpenseValue.md) | Codes specifying living expense indicators used to assess or establish eligibility for coverage under a policy or program. |
| [ObservationLivingSituationValue](ValueSet-v3-ObservationLivingSituationValue.md) | Code specifying observations related to living situation for a person in a private residence. |
| [ObservationMeasureCountableItems](ValueSet-v3-ObservationMeasureCountableItems.md) | A collection of items that can be counted by a quality measure (e.g., patients, encounters, procedures, etc.) for Observation.value used in the HQMF R2 MeasureAttribute class. |
| [ObservationMeasureScoring](ValueSet-v3-ObservationMeasureScoring.md) | ****No description**** |
| [ObservationMeasureType](ValueSet-v3-ObservationMeasureType.md) | Observation values used to indicate what kind of health quality measure is used. |
| [ObservationMethod](ValueSet-v3-ObservationMethod.md) | A code that provides additional detail about the means or technique used to ascertain the observation.**Examples:**Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc.**Constraints:**In all observations the method is already partially specified by the Act.code. In this case, the methodCode NEED NOT be used at all. The methodCode MAY still be used to identify this method more clearly in addition to what is implied from the Act.code. However, an information consumer system or process SHOULD NOT depend on this methodCode information for method detail that is implied by the Act.code. If the methodCode is used to express method detail that is also implied by the Act.code, the methodCode MUST NOT be in conflict with the implied method of the Act.code. |
| [ObservationMethodAggregate](ValueSet-v3-ObservationMethodAggregate.md) | A set of codes that defines how a set of values are summarized in an aggregated computation, for use with sets of values do describe which aggregated statistic functions are to be applied (e.g., average, mode, min, max, standard deviation, variance). |
| [ObservationNonAllergyIntoleranceType](ValueSet-v3-ObservationNonAllergyIntoleranceType.md) | Hypersensitivity to an agent caused by a mechanism other than an immunologic response to an initial exposure |
| [ObservationPopulationInclusion](ValueSet-v3-ObservationPopulationInclusion.md) | Observation values used to assert various populations that a subject falls into. |
| [ObservationQualityMeasureAttribute](ValueSet-v3-ObservationQualityMeasureAttribute.md) | Codes used to define various metadata aspects of a health quality measure. |
| [ObservationSequenceType](ValueSet-v3-ObservationSequenceType.md) | ****No description**** |
| [ObservationSeriesType](ValueSet-v3-ObservationSeriesType.md) | ****No description**** |
| [ObservationSocioEconomicStatusValue](ValueSet-v3-ObservationSocioEconomicStatusValue.md) | Code specifying observations or indicators related to socio-economic status used to assess to assess for services, e.g., discharge planning, or to establish eligibility for coverage under a policy or program. |
| [ObservationType](ValueSet-v3-ObservationType.md) | Identifies the kinds of observations that can be performed |
| [OilDrugForm](ValueSet-v3-OilDrugForm.md) | An unctuous, combustible substance which is liquid, or easily liquefiable, on warming, and is soluble in ether but insoluble in water. Such substances, depending on their origin, are classified as animal, mineral, or vegetable oils. |
| [OintmentDrugForm](ValueSet-v3-OintmentDrugForm.md) | A semisolid preparation intended for external application to the skin or mucous membranes. |
| [Ojibwayan](ValueSet-v3-Ojibwayan.md) | ****No description**** |
| [OphthalmicRoute](ValueSet-v3-OphthalmicRoute.md) | Ophthalmic |
| [Oral Site Codes](ValueSet-tooth.md) | This value set includes a smattering of FDI oral site codes. |
| [OralCapsule](ValueSet-v3-OralCapsule.md) | ****No description**** |
| [OralInhalation](ValueSet-v3-OralInhalation.md) | Inhalation, oral |
| [OralRoute](ValueSet-v3-OralRoute.md) | Oral |
| [OralSolution](ValueSet-v3-OralSolution.md) | ****No description**** |
| [OralSuspension](ValueSet-v3-OralSuspension.md) | ****No description**** |
| [OralTablet](ValueSet-v3-OralTablet.md) | ****No description**** |
| [OrderableDrugForm](ValueSet-v3-OrderableDrugForm.md) | ****No description**** |
| [OrderedListStyle](ValueSet-v3-OrderedListStyle.md) | Defines rendering characteristics for ordered lists |
| [OregonAthapaskan](ValueSet-v3-OregonAthapaskan.md) | ****No description**** |
| [Organization Affiliation Role](ValueSet-organization-affiliation-role.md) | This value set defines a set of codes that can be used to indicate an organization affiliation role. |
| [Organization Alias Type](ValueSet-organization-alias-type.md) | This value set defines a set of codes for indicating oranization alias type. |
| [Organization type](ValueSet-organization-type.md) | This example value set defines a set of codes that can be used to indicate a type of organization. |
| [OrganizationEntityType](ValueSet-v3-OrganizationEntityType.md) | Further classifies entities of classCode ORG. |
| [OrganizationIndustryClassNAICS](ValueSet-v3-OrganizationIndustryClassNAICS.md) | ****No description**** |
| [OrganizationNamePartQualifier](ValueSet-v3-OrganizationNamePartQualifier.md) | ****No description**** |
| [OrganizationNameUse](ValueSet-v3-OrganizationNameUse.md) | ****No description**** |
| [OromucosalRoute](ValueSet-v3-OromucosalRoute.md) | Oromucosal |
| [OropharyngealRoute](ValueSet-v3-OropharyngealRoute.md) | Oropharyngeal |
| [OrthoClinPracticeSetting](ValueSet-v3-OrthoClinPracticeSetting.md) | ****No description**** |
| [Other](ValueSet-v3-Other.md) | The actual value is not an element in the value domain of a variable. (e.g., concept not provided by required code system). |
| [OtherActionTakenManagementCode](ValueSet-v3-OtherActionTakenManagementCode.md) | Order is performed as issued, but other action taken to mitigate potential adverse effects |
| [OticRoute](ValueSet-v3-OticRoute.md) | Otic |
| [OutpatientFacilityPracticeSetting](ValueSet-v3-OutpatientFacilityPracticeSetting.md) | ****No description**** |
| [OverriderParticipationFunction](ValueSet-v3-OverriderParticipationFunction.md) | This code is used to specify the exact function an actor is authorized to have in authoring a consent override. |
| [PHVS_ManufacturersOfVaccinesMVX_CDC_NIP](ValueSet-v2-0227.md) | Value Set of codes that specify the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Note that the source of truth for these code values are maintained by the CDC, and the code system may be accessed via[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.12.227) |
| [PHVS_Race_HL7_2x](ValueSet-v2-0005.md) | This race value set is based upon CDC check-digit codes, but using the HL7 table 0005. HL7 adopted the CDC Race and Ethnicity codes in HL7 Table 0005 in 2005. This value set has been created for backward compatibility and some historic Implementation guides (E.g. Immunization). Recommend using Race Category value set based upon CDC Race & Ethnicity code system. |
| [PHVS_VaccinesAdministeredCVX_CDC_NIP](ValueSet-v2-0292.md) | Value Set of codes that specify the administered vaccines. The values are maintained by the US Centers of Disease Control.. The code system is maintained by the CDC, and may be found at URL; https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.1 |
| [PacificCoastAthapaskan](ValueSet-v3-PacificCoastAthapaskan.md) | ****No description**** |
| [PackageEntityType](ValueSet-v3-PackageEntityType.md) | A material intended to hold other materials for purposes of storage or transportation |
| [PadDrugForm](ValueSet-v3-PadDrugForm.md) | ****No description**** |
| [Pai](ValueSet-v3-Pai.md) | ****No description**** |
| [Palaihnihan](ValueSet-v3-Palaihnihan.md) | ****No description**** |
| [ParanasalSinusesRoute](ValueSet-v3-ParanasalSinusesRoute.md) | Paranasal sinuses |
| [Parent](ValueSet-v3-Parent.md) | one that begets or brings forth offspring or a person who brings up and cares for another (Webster's Collegiate Dictionary) |
| [ParentInLaw](ValueSet-v3-ParentInLaw.md) | The player of the role is the parent of scoping person's husband or wife. |
| [ParenteralRoute](ValueSet-v3-ParenteralRoute.md) | Parenteral |
| [PartialCompletionScale](ValueSet-v3-PartialCompletionScale.md) | ****No description**** |
| [ParticipationAdmitter](ValueSet-v3-ParticipationAdmitter.md) | The practitioner who is responsible for admitting a patient to a patient encounter. |
| [ParticipationAnalyte](ValueSet-v3-ParticipationAnalyte.md) | ****No description**** |
| [ParticipationAncillary](ValueSet-v3-ParticipationAncillary.md) | Participations related, but not primary to an act. The Referring, Admitting, and Discharging practitioners must be the same person as those authoring the ControlAct event for their respective trigger events. |
| [ParticipationAttender](ValueSet-v3-ParticipationAttender.md) | The practitioner that has responsibility for overseeing a patient's care during a patient encounter. |
| [ParticipationAuthenticator](ValueSet-v3-ParticipationAuthenticator.md) | A verifier who attests to the accuracy of an act, but who does not have privileges to legally authenticate the act. An example would be a resident physician who sees a patient and dictates a note, then later signs it. Their signature constitutes an authentication. |
| [ParticipationAuthorOriginator](ValueSet-v3-ParticipationAuthorOriginator.md) | **Definition:**A party that originates the Act and therefore has responsibility for the information given in the Act and ownership of this Act.**Example:**the report writer, the person writing the act definition, the guideline author, the placer of an order, the EKG cart (device) creating a report etc. Every Act should have an author. Authorship is regardless of mood always actual authorship. Examples of such policies might include:* The author and anyone they explicitly delegate may update the report; 
* All administrators within the same clinic may cancel and reschedule appointments created by other administrators within that clinic; A party that is neither an author nor a party who is extended authorship maintenance rights by policy, may only amend, reverse, override, replace, or follow up in other ways on this Act, whereby the Act remains intact and is linked to another Act authored by that other party.
 |
| [ParticipationBaby](ValueSet-v3-ParticipationBaby.md) | In an obstetric service, the baby. |
| [ParticipationBeneficiary](ValueSet-v3-ParticipationBeneficiary.md) | Target on behalf of whom the service happens, but that is not necessarily present in the service. Can occur together with direct target to indicate that a target is both, as in the case where the patient is the indirect beneficiary of a service rendered to a family member, e.g. counseling or given home care instructions. This concept includes a participant, such as a covered party, who derives benefits from a service act covered by a coverage act. Note that the semantic role of the intended recipient who benefits from the happening denoted by the verb in the clause. Thus, a patient who has no coverage under a policy or program may be a beneficiary of a health service while not being the beneficiary of coverage for that service. |
| [ParticipationCallbackContact](ValueSet-v3-ParticipationCallbackContact.md) | A person or organization who should be contacted for follow-up questions about the act in place of the author. |
| [ParticipationCatalyst](ValueSet-v3-ParticipationCatalyst.md) | ****No description**** |
| [ParticipationCausativeAgent](ValueSet-v3-ParticipationCausativeAgent.md) | Definition: A factor, such as a microorganism, chemical substance, or form of radiation, whose presence, excessive presence, or (in deficiency diseases) relative absence is essential, in whole or in part, for the occurrence of a condition. Constraint: The use of this participation is limited to observations. |
| [ParticipationConsultant](ValueSet-v3-ParticipationConsultant.md) | An advisor participating in the service by performing evaluations and making recommendations. |
| [ParticipationConsumable](ValueSet-v3-ParticipationConsumable.md) | Target that is taken up, is diminished, and disappears in the service. |
| [ParticipationCoverageTarget](ValueSet-v3-ParticipationCoverageTarget.md) | The target participation for an individual in a health care coverage act in which the target role is either the policy holder of the coverage, or a covered party under the coverage. |
| [ParticipationCustodian](ValueSet-v3-ParticipationCustodian.md) | An entity (person, organization or device) that is in charge of maintaining the information of this act (e.g., who maintains the report or the master service catalog item, etc.). |
| [ParticipationDataEntryPerson](ValueSet-v3-ParticipationDataEntryPerson.md) | A person entering the data into the originating system. The data entry person is collected optionally for internal quality control purposes. This includes the transcriptionist for dictated text. |
| [ParticipationDestination](ValueSet-v3-ParticipationDestination.md) | The destination for services. May be a static building (or room therein) or a movable facility (e.g., ship). |
| [ParticipationDischarger](ValueSet-v3-ParticipationDischarger.md) | The practitioner who is responsible for the discharge of a patient from a patient encounter. |
| [ParticipationDistributor](ValueSet-v3-ParticipationDistributor.md) | Distributes material used in or generated during the act. |
| [ParticipationDonor](ValueSet-v3-ParticipationDonor.md) | In some organ transplantation services and rarely in transfusion services a donor will be a target participant in the service. However, in most cases transplantation is decomposed in three services: explantation, transport, and implantation. The identity of the donor (recipient) is often irrelevant for the explantation (implantation) service. |
| [ParticipationEntryLocation](ValueSet-v3-ParticipationEntryLocation.md) | A location where data about an Act was entered. |
| [ParticipationEscort](ValueSet-v3-ParticipationEscort.md) | Only with Transportation services. A person who escorts the patient. |
| [ParticipationExposureagent](ValueSet-v3-ParticipationExposureagent.md) | **Description:**The entity playing the associated role is the physical (including energy), chemical or biological substance that is participating in the exposure. For example in communicable diseases, the associated playing entity is the disease causing pathogen. |
| [ParticipationExposureparticipation](ValueSet-v3-ParticipationExposureparticipation.md) | **Description:**Direct participation in an exposure act where it is unknown that the participant is the source or subject of the exposure. If the participant is known to be the contact of an exposure then the EXPTRGT participation type should be used. If the participant is known to be the source then the EXSRC participation type should be used. |
| [ParticipationExposuresource](ValueSet-v3-ParticipationExposuresource.md) | **Description:**The entity playing the associated role is the source of exposure. |
| [ParticipationExposuretarget](ValueSet-v3-ParticipationExposuretarget.md) | **Description:**The entity playing the associated role is the target (contact) of exposure. |
| [ParticipationFunction](ValueSet-v3-ParticipationFunction.md) | This code is used to specify the exact function an actor had in a service in all necessary detail. This domain may include local extensions (CWE). |
| [ParticipationGuarantorParty](ValueSet-v3-ParticipationGuarantorParty.md) | The target person or organization contractually recognized by the issuer as a participant who has assumed fiscal responsibility for another personaTMs financial obligations by guaranteeing to pay for amounts owed to a particular account**Example:**The subscriber of the patientaTMs health insurance policy signs a contract with the provider to be fiscally responsible for the patient billing account balance amount owed. |
| [ParticipationHolder](ValueSet-v3-ParticipationHolder.md) | Participant who posses an instrument such as a financial contract (insurance policy) usually based on some agreement with the author. |
| [ParticipationIndirectTarget](ValueSet-v3-ParticipationIndirectTarget.md) | Target that is not substantially present in the act and which is not directly affected by the act, but which will be a focus of the record or documentation of the act. |
| [ParticipationInformant](ValueSet-v3-ParticipationInformant.md) | A source of reported information (e.g., a next of kin who answers questions about the patient's history). For history questions, the patient is logically an informant, yet the informant of history questions is implicitly the subject. |
| [ParticipationInformationGenerator](ValueSet-v3-ParticipationInformationGenerator.md) | Parties that may or should contribute or have contributed information to the Act. Such information includes information leading to the decision to perform the Act and how to perform the Act (e.g., consultant), information that the Act itself seeks to reveal (e.g., informant of clinical history), or information about what Act was performed (e.g., informant witness). |
| [ParticipationInformationRecipient](ValueSet-v3-ParticipationInformationRecipient.md) | A party, who may or should receive or who has recieved the Act or subsequent or derivative information of that Act. Information recipient is inert, i.e., independent of mood." Rationale: this is a generalization of a too diverse family that the definition can't be any more specific, and the concept is abstract so one of the specializations should be used. |
| [ParticipationInformationTranscriber](ValueSet-v3-ParticipationInformationTranscriber.md) | An entity entering the data into the originating system. The data entry entity is collected optionally for internal quality control purposes. This includes the transcriptionist for dictated text transcribed into electronic form. |
| [ParticipationLegalAuthenticator](ValueSet-v3-ParticipationLegalAuthenticator.md) | A verifier who legally authenticates the accuracy of an act. An example would be a staff physician who sees a patient and dictates a note, then later signs it. Their signature constitutes a legal authentication. |
| [ParticipationMode](ValueSet-v3-ParticipationMode.md) | Identifies the primary means by which an Entity participates in an Act. |
| [ParticipationModeElectronicData](ValueSet-v3-ParticipationModeElectronicData.md) | Participation by non-human-languaged based electronic signal |
| [ParticipationModeVerbal](ValueSet-v3-ParticipationModeVerbal.md) | Participation by voice communication |
| [ParticipationModeWritten](ValueSet-v3-ParticipationModeWritten.md) | Participation by human language recorded on a physical material |
| [ParticipationNon-reuseableDevice](ValueSet-v3-ParticipationNon-reuseableDevice.md) | A device that changes ownership due to the service, e.g., a pacemaker, a prosthesis, an insulin injection equipment (pen), etc. Such material may need to be restocked after he service. |
| [ParticipationOrigin](ValueSet-v3-ParticipationOrigin.md) | The location of origin for services. May be a static building (or room therein) or a movable facility (e.g., ship). |
| [ParticipationParticipation](ValueSet-v3-ParticipationParticipation.md) | Indicates that the target of the participation is involved in some manner in the act, but does not qualify how. This should**not**be used except when no more specific participation type is known or when the participation type is further clarified elsewhere. It should not be used lightly, and should never be used as a "placeholder" when a more appropriate specific type does not yet exist. |
| [ParticipationPhysicalPerformer](ValueSet-v3-ParticipationPhysicalPerformer.md) | A person who actually and principally carries out the action. Need not be the principal responsible actor, e.g. a surgery resident operating under supervision of attending surgeon, and may be the patient in self-care, e.g. fingerstick blood sugar. The traditional order filler is a performer. This information should accompany every service event. |
| [ParticipationPrimaryInformationRecipient](ValueSet-v3-ParticipationPrimaryInformationRecipient.md) | Information recipient to whom an act statement is primarily directed. E.g., a primary care provider receiving a discharge letter from a hospitalist, a health department receiving information on a suspected case of infectious disease. Multiple of these participations may exist on the same act without requiring that recipients be ranked as primary vs. secondary. |
| [ParticipationPrimaryPerformer](ValueSet-v3-ParticipationPrimaryPerformer.md) | The principal or primary performer of the act. |
| [ParticipationProduct](ValueSet-v3-ParticipationProduct.md) | A material target that is brought forth (produced) in the service (e.g., specimen in a specimen collection, access or drainage in a placement service, medication package in a dispense service). It doesn't matter whether the material produced had existence prior to the service, or whether it is created in the service (e.g., in supply services the product is taken from a stock). |
| [ParticipationReceiver](ValueSet-v3-ParticipationReceiver.md) | The person (or organization) who receives the product of an Act. |
| [ParticipationRecordTarget](ValueSet-v3-ParticipationRecordTarget.md) | The record target indicates whose medical record holds the documentation of this act. This is especially important when the subject of a service is not the patient himself. |
| [ParticipationReferredBy](ValueSet-v3-ParticipationReferredBy.md) | A participant (e.g. provider) who has referred the subject of an act (e.g. patient). Typically, a referred by participant will provide a report (e.g. referral). |
| [ParticipationReferredTo](ValueSet-v3-ParticipationReferredTo.md) | The person who receives the patient |
| [ParticipationReferrer](ValueSet-v3-ParticipationReferrer.md) | A person having referred the subject of the service to the performer (referring physician). Typically, a referring physician will receive a report. |
| [ParticipationRemote](ValueSet-v3-ParticipationRemote.md) | Some services take place at multiple concurrent locations (e.g., telemedicine, telephone consultation). The location where the principal performing actor is located is taken as the primary location (LOC) while the other location(s) are considered "remote." |
| [ParticipationResponsibleParty](ValueSet-v3-ParticipationResponsibleParty.md) | The person or organization that has primary responsibility for the act. The responsible party is not necessarily present in an action, but is accountable for the action through the power to delegate, and the duty to review actions with the performing actor after the fact. This responsibility may be ethical, legal, contractual, fiscal, or fiduciary in nature.**Example:**A person who is the head of a biochemical laboratory; a sponsor for a policy or government program. |
| [ParticipationReusableDevice](ValueSet-v3-ParticipationReusableDevice.md) | A device that does not change ownership due to the service, i.e., a surgical instrument or tool or an endoscope. The distinction between reuseable and non-reuseable must be made in order to know whether material must be re-stocked. |
| [ParticipationSecondaryPerformer](ValueSet-v3-ParticipationSecondaryPerformer.md) | A person assisting in an act through his substantial presence and involvement This includes: assistants, technicians, associates, or whatever the job titles may be. |
| [ParticipationSignature](ValueSet-v3-ParticipationSignature.md) | A code specifying whether and how the participant has attested his participation through a signature and or whether such a signature is needed.**Examples:**A surgical Procedure act object (representing a procedure report) requires a signature of the performing and responsible surgeon, and possibly other participants. (See also: Participation.signatureText.) |
| [ParticipationSpecimen](ValueSet-v3-ParticipationSpecimen.md) | The subject of non-clinical (e.g. laboratory) observation services is a specimen. |
| [ParticipationSubset](ValueSet-v3-ParticipationSubset.md) | Used to indicate that the participation is a filtered subset of the total participations of the same type owned by the Act. Used when there is a need to limit the participations to the first, the last, the next or some other filtered subset. |
| [ParticipationTargetDevice](ValueSet-v3-ParticipationTargetDevice.md) | Something used in delivering the service without being substantially affected by the service (i.e. durable or inert with respect to that particular service.) Examples are: monitoring equipment, tools, but also access/drainage lines, prostheses, pace maker, etc. |
| [ParticipationTargetDirect](ValueSet-v3-ParticipationTargetDirect.md) | Target that is substantially present in the service and which is directly affected by the service action (includes consumed material, devices, etc.). |
| [ParticipationTargetLocation](ValueSet-v3-ParticipationTargetLocation.md) | The facility where the service is done. May be a static building (or room therein) or a moving location (e.g., ambulance, helicopter, aircraft, train, truck, ship, etc.) |
| [ParticipationTargetSubject](ValueSet-v3-ParticipationTargetSubject.md) | The principle target that the service acts on. E.g. the patient in physical examination, a specimen in a lab observation. May also be a patient's family member (teaching) or a device or room (cleaning, disinfecting, housekeeping). Note: not all direct targets are subjects, consumables, and devices used as tools for a service are not subjects. However, a device may be a subject of a maintenance service. |
| [ParticipationTracker](ValueSet-v3-ParticipationTracker.md) | A secondary information recipient, who receives copies (e.g., a primary care provider receiving copies of results as ordered by specialist). |
| [ParticipationType](ValueSet-v3-ParticipationType.md) | A code specifying the meaning and purpose of every Participation instance. Each of its values implies specific constraints on the Roles undertaking the participation. |
| [ParticipationTypeCDASectionOverride](ValueSet-v3-ParticipationTypeCDASectionOverride.md) | Identifies the set of participation types context that can be blocked (overridden) at the CDA section or sub-section level of a document. |
| [ParticipationUgentNotificationContact](ValueSet-v3-ParticipationUgentNotificationContact.md) | An information recipient to notify for urgent matters about this Act. (e.g., in a laboratory order, critical results are being called by phone right away, this is the contact to call; or for an inpatient encounter, a next of kin to notify when the patient becomes critically ill). |
| [ParticipationVerifier](ValueSet-v3-ParticipationVerifier.md) | A person who verifies the correctness and appropriateness of the service (plan, order, event, etc.) and hence takes on accountability. |
| [ParticipationVia](ValueSet-v3-ParticipationVia.md) | For services, an intermediate location that specifies a path between origin an destination. |
| [ParticipationWitness](ValueSet-v3-ParticipationWitness.md) | Only with service events. A person witnessing the action happening without doing anything. A witness is not necessarily aware, much less approves of anything stated in the service event. Example for a witness is students watching an operation or an advanced directive witness. |
| [PastSubset](ValueSet-v3-PastSubset.md) | An occurrence that occurred or was scheduled to occur in the past. An Act whose effective time is less than 'now'. ('now' is the time the instance is authored.) |
| [PasteDrugForm](ValueSet-v3-PasteDrugForm.md) | A semisolid dosage form that contains one or more drug substances intended for topical application. |
| [PatchDrugForm](ValueSet-v3-PatchDrugForm.md) | A drug delivery system that contains an adhesived backing and that permits its ingredients to diffuse from some portion of it (e.g., the backing itself, a reservoir, the adhesive, or some other component) into the body from the external site where it is applied. |
| [PatientImmunizationRelatedObservationType](ValueSet-v3-PatientImmunizationRelatedObservationType.md) | **Description:**Reporting codes that are related to an immunization event. |
| [PatientImportance](ValueSet-v3-PatientImportance.md) | Patient VIP code |
| [PatientProfileQueryReasonCode](ValueSet-v3-PatientProfileQueryReasonCode.md) | ****No description**** |
| [Payee Type Codes](ValueSet-payeetype.md) | Codes indicating the type of party to be reimbursed for cost of the products and service. |
| [PayeeResourceType](ValueSet-resource-type-link.md) | The type of payee Resource. |
| [Payment Adjustment Reason Codes](ValueSet-payment-adjustment-reason.md) | This value set includes smattering of Payment Adjustment Reason codes. |
| [Payment Status Codes](ValueSet-payment-status.md) | This value set includes a sample set of Payment Status codes. |
| [Payment Type Codes](ValueSet-payment-type.md) | This value set includes sample Payment Type codes. |
| [PaymentTerms](ValueSet-v3-PaymentTerms.md) | Describes payment terms for a financial transaction, used in an invoice. This is typically expressed as a responsibility of the acceptor or payor of an invoice. |
| [PayorParticipationFunction](ValueSet-v3-PayorParticipationFunction.md) | **Definition:**Set of codes indicating the manner in which payors participate in a policy or program.</ |
| [PayorRoleType](ValueSet-v3-PayorRoleType.md) | **Description:**PayorRoleType for a particular type of policy or program benefit package or plan where more detail about the coverage administration role of the Payor is required. The functions performed by a Payor qualified by a PayorRoleType may be specified by the PayorParticpationFunction value set.**Examples:**A Payor that is a TPA may administer a managed care plan without underwriting the risk. |
| [PedsClinPracticeSetting](ValueSet-v3-PedsClinPracticeSetting.md) | ****No description**** |
| [PedsICUPracticeSetting](ValueSet-v3-PedsICUPracticeSetting.md) | ****No description**** |
| [PedsPracticeSetting](ValueSet-v3-PedsPracticeSetting.md) | ****No description**** |
| [Penutian](ValueSet-v3-Penutian.md) | ****No description**** |
| [PerianalRoute](ValueSet-v3-PerianalRoute.md) | Perianal |
| [PeriarticularRoute](ValueSet-v3-PeriarticularRoute.md) | Periarticular |
| [PeriduralRoute](ValueSet-v3-PeriduralRoute.md) | Peridural |
| [PerinealRoute](ValueSet-v3-PerinealRoute.md) | Perineal |
| [PerineuralRoute](ValueSet-v3-PerineuralRoute.md) | Perineural |
| [PeriodontalRoute](ValueSet-v3-PeriodontalRoute.md) | Periodontal |
| [PermanentDentition](ValueSet-v3-PermanentDentition.md) | Permanent dentition, the natural teeth of adulthood that replace or are added to the deciduous teeth |
| [PersonDisabilityType](ValueSet-v3-PersonDisabilityType.md) | A code identifying a person's disability. |
| [PersonNameUse](ValueSet-v3-PersonNameUse.md) | A code indicating the type of name (e.g. nickname, alias, maiden name, legal, adopted) |
| [Personal Pronouns](ValueSet-pronouns.md) | Codes that indicate the pronouns to be used when communicating with or about an individual. |
| [PersonalAndLegalRelationshipRoleType](ValueSet-v3-PersonalAndLegalRelationshipRoleType.md) | A â€˜personal and legalâ€™ relationship records the role of a person in relation to another person, or a person to himself or herself. This value set is to be used when recording relationships based on personal or family ties or through legal assignment of responsibility. |
| [PersonalRelationshipRoleType](ValueSet-v3-PersonalRelationshipRoleType.md) | Types of personal relationships between two living subjects.**Example:**Parent, sibling, unrelated friend, neighbor |
| [PharmacistHIPAA](ValueSet-v3-PharmacistHIPAA.md) | An individual who is licensed to prepare and sell or dispense drugs and compounds and to make up prescriptions. |
| [PharmacySupplyEventAbortReason](ValueSet-v3-PharmacySupplyEventAbortReason.md) | **Definition:**Identifies why the dispense event was not completed |
| [PharmacySupplyEventStockReasonCode](ValueSet-v3-PharmacySupplyEventStockReasonCode.md) | ****No description**** |
| [PharmacySupplyRequestFulfillerRevisionRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestFulfillerRevisionRefusalReasonCode.md) | **Definition:**Indicates why the request to transfer a prescription from one dispensing facility to another has been refused. |
| [PharmacySupplyRequestRenewalRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestRenewalRefusalReasonCode.md) | **Definition:**A collection of concepts that identifies why a renewal prescription has been refused. |
| [Pidgin](ValueSet-v3-Pidgin.md) | ****No description**** |
| [PillDrugForm](ValueSet-v3-PillDrugForm.md) | A small, round solid dosage form containing a medicinal agent intended for oral administration. |
| [PlaceEntityType](ValueSet-v3-PlaceEntityType.md) | Types of places for EntityClass "PLC" |
| [PlanDefinitionType](ValueSet-plan-definition-type.md) | The type of PlanDefinition. |
| [PlasticBottleEntityType](ValueSet-v3-PlasticBottleEntityType.md) | A bottle made of plastic |
| [PlateauPenutian](ValueSet-v3-PlateauPenutian.md) | ****No description**** |
| [PolicyOrProgramCoverageRoleType](ValueSet-v3-PolicyOrProgramCoverageRoleType.md) | **Description:**A role recognized through the eligibility of an identified party for benefits covered under an insurance policy or a program based on meeting eligibility criteria. Eligibility as a covered party may be conditioned on the party meeting criteria to qualify for coverage under a policy or program, which may be mandated by law. These criteria may be:1. The sole basis for coverage, e.g., being differently abled may qualify a person for disability coverage
1. May more fully qualify a covered party role e.g, being differently abled may qualify an adult child as a dependent
1. May impact the level of coverage for a covered party under a policy or program, e.g., being differently abled may qualify a program eligible for additional benefits.**Discussion:**The Abstract Value Set "CoverageRoleType", which was developed for use in the Canadian realm "pre-coordinate" coverage roles with other roles that a covered party must play in order to be eligible for coverage, e.g., "handicapped dependent". These role.codes may only be used with COVPTY to avoid overlapping concepts that would result from using them to specify the specializations of COVPTY, e.g., the role.class DEPEN should not be used with the role.code family dependent because that relationship has overlapping concepts due to the role.code precoodination and is conveyed in FICO with the personal relationship role that has a PART role link to the covered party role. For the same reasons, the role.class DEPEN should not be used with the role.code HANDIC (handicapped dependent); the role.code DIFFABLE (differently abled) should be used instead. In summary, the coded concepts in the Abstract Value Set "CoveredPartyRoleType" can be "post-coordinated" with the "RoleClassCoveredParty" Abstract Value Set. Decoupling these concepts is intended to support an expansive range of covered party concepts and their semantic comparability.
 |
| [Pomoan](ValueSet-v3-Pomoan.md) | ****No description**** |
| [PopulationInclusionObservationType](ValueSet-v3-PopulationInclusionObservationType.md) | Observation types for specifying criteria used to assert that a subject is included in a particular population. |
| [PostalAddressUse](ValueSet-v3-PostalAddressUse.md) | ****No description**** |
| [PowderDrugForm](ValueSet-v3-PowderDrugForm.md) | An intimate mixture of dry, finely divided drugs and/or chemicals that may be intended for internal or external use. |
| [PowerOfAttorney](ValueSet-v3-PowerOfAttorney.md) | A relationship between two people in which one person authorizes another to act for him in a manner which is a legally binding upon the person giving such authority as if he or she personally were to do the acts. |
| [PrescriptionDispenseFilterCode](ValueSet-v3-PrescriptionDispenseFilterCode.md) | A "helper" vocabulary used to construct complex query filters based on how and whether a prescription has been dispensed. |
| [Present on Admission Indicators](ValueSet-POAIndicators.md) | Concepts that describe whether a condition is present when a patient is admitted to a healthcare facility. |
| [Primary-source-type](ValueSet-verificationresult-primary-source-type.md) | Type of the validation primary source |
| [PrimaryDentition](ValueSet-v3-PrimaryDentition.md) | Primary dentition, the first teeth to errupt and usually replaced with permanent dentition |
| [PrivacyMark](ValueSet-v3-PrivacyMark.md) | Codes used for human readable marks indicating, e.g., the level of confidentiality protection, an authorized compartment, the integrity, or the handling instruction required by applicable policy. Such markings must be displayed as directed by applicable policy on electronically rendered information content and any electronic transmittal envelope or container; or on hardcopy information and any physical transmittal envelope or container. Purpose: Supports the selection of the entire PrivacyMark value set with head code for e.g., rules engine policy set purposes. |
| [PrivateResidence](ValueSet-v3-PrivateResidence.md) | **Definition:**A living arrangement within a private residence for single family. |
| [ProbabilityDistributionType](ValueSet-v3-ProbabilityDistributionType.md) | ****No description**** |
| [Procedure Type Codes](ValueSet-procedure-type.md) | This value set includes Procedure Type codes. |
| [Process Priority Codes](ValueSet-process-priority.md) | This value set includes the financial processing priority codes. |
| [ProcessingID](ValueSet-v3-ProcessingID.md) | This attribute defines whether the message is part of a production, training, or debugging system. |
| [ProcessingMode](ValueSet-v3-ProcessingMode.md) | This attribute defines whether the message is being sent in current processing, archive mode, initial load mode, restore from archive mode, etc. |
| [Program](ValueSet-program.md) | This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties. |
| [ProgramEligibleCoveredPartyRoleType](ValueSet-v3-ProgramEligibleCoveredPartyRoleType.md) | **Description:**A role recognized through the eligibility of a party to play a program eligible for benefits covered or provided under a program. |
| [Provenance participant type](ValueSet-provenance-agent-type.md) | The type of participation a provenance participant. |
| [ProvenanceEventCurrentState](ValueSet-v3-ProvenanceEventCurrentState.md) | Specifies the state change of a target Act, such as a document or an entry, from its previous state as a predecessor Act. For example, if the target Act is the result of a predecessor Act being "obsoleted" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be "obsoleted". |
| [ProvenanceEventCurrentState-AS](ValueSet-v3-ProvenanceEventCurrentState-AS.md) | Specifies the state change of a target Act, using ActStatus codes, from its previous state as a predecessor Act. For example, if the target Act is the result of a predecessor Act being "obsoleted" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be "obsoleted". |
| [ProvenanceEventCurrentState-DC](ValueSet-v3-ProvenanceEventCurrentState-DC.md) | Specifies the state change of a target Act using DocuymentCompletion codes, from its previous state as a predecessor Act. For example, if the target Act is the result of a predecessor Act being "obsoleted" and replaced with the target Act, the source ProvenanceEventCurrentState Act code would be "obsoleted". |
| [PublicHealthcareProgram](ValueSet-v3-PublicHealthcareProgram.md) | **Definition:**A a public or governmental health program with an organized structure for administering and funding coverage of a benefit package for covered parties meeting eligibility criteria, typically related to employment, health and financial status. These programs are established by legislation with provisions for ongoing government oversight. Regulations mandate the structure of the program, the manner in which it is funded and administered, covered benefits, provider types, eligibility criteria and financial participation. A government agency may be charged with implementing the program in accordance to the regulation. For example, A Canadian provincial or national health plan such as the BC MSP (British Columbia Medical Services Plan) OHIP (Ontario Health Insurance Plan), NHS (National Health Service). Examples of U.S. government funded health programs include those for maternity case management, behavioral health, and HIV-AIDs, such as the Ryan White program. |
| [Published In Type](ValueSet-published-in-type.md) | The type of publication such as book, database, or journal. |
| [PulmonaryRoute](ValueSet-v3-PulmonaryRoute.md) | Pulmonary |
| [PurposeOfUse](ValueSet-v3-PurposeOfUse.md) | Supports communication of purpose of use at a general level. |
| [Push-type-available](ValueSet-verificationresult-push-type-available.md) | Type of alerts/updates the primary source can send |
| [QualityMeasureSectionType](ValueSet-v3-QualityMeasureSectionType.md) | A type of document section within a health quality measure (aka eMeasure), used to cluster the various parts of the eMeasure into a more human navigable format. |
| [QualityOfEvidenceRating](ValueSet-evidence-quality.md) | A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM systems. |
| [QualitySpecimenRoleType](ValueSet-v3-QualitySpecimenRoleType.md) | A specimen specifically used to verify the sensitivity, specificity, accuracy or other perfomance parameter of a diagnostic test. |
| [QueryPriority](ValueSet-v3-QueryPriority.md) | Identifies the time frame in which the response is expected. |
| [QueryRequestLimit](ValueSet-v3-QueryRequestLimit.md) | **Definition:**The number of matching instances (number of focal classes). The document header class is the focal class of a document, a record would therefore be equal to a document. |
| [QueryResponse](ValueSet-v3-QueryResponse.md) | A code classifying the general nature of the response to a given query. Includes whether or not data was found, or whether an error occurred. |
| [QueryStatusCode](ValueSet-v3-QueryStatusCode.md) | A code specifying the state of the Query. |
| [QuestionnaireItemUsageMode](ValueSet-questionnaire-usage-mode.md) | Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item. |
| [ROIOverlayShape](ValueSet-v3-ROIOverlayShape.md) | Shape of the region on the object being referenced |
| [Race](ValueSet-v3-Race.md) | In the United States, federal standards for classifying data on race determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define race, and they recognize the absence of an anthropological or scientific basis for racial classification. Instead, the federal standards acknowledge that race is a social-political construct in which an individual's own identification with one more race categories is preferred to observer identification. The standards use a variety of features to define five minimum race categories. Among these features are descent from "the original peoples" of a specified region or nation. The minimum race categories are American Indian or Alaska Native, Asian, Black or African American, Native Hawaiian or Other Pacific Islander, and White. The federal standards stipulate that race data need not be limited to the five minimum categories, but any expansion must be collapsible to those categories. |
| [RaceAfricanAmericanAfrican](ValueSet-v3-RaceAfricanAmericanAfrican.md) | ****No description**** |
| [RaceAlaskanIndian](ValueSet-v3-RaceAlaskanIndian.md) | ****No description**** |
| [RaceAlaskanIndianAthabascan](ValueSet-v3-RaceAlaskanIndianAthabascan.md) | ****No description**** |
| [RaceAlaskanNative](ValueSet-v3-RaceAlaskanNative.md) | ****No description**** |
| [RaceAlaskanNativeAleut](ValueSet-v3-RaceAlaskanNativeAleut.md) | ****No description**** |
| [RaceAlaskanNativeAleutAlutiiq](ValueSet-v3-RaceAlaskanNativeAleutAlutiiq.md) | ****No description**** |
| [RaceAlaskanNativeAleutBristolBay](ValueSet-v3-RaceAlaskanNativeAleutBristolBay.md) | ****No description**** |
| [RaceAlaskanNativeAleutChugach](ValueSet-v3-RaceAlaskanNativeAleutChugach.md) | ****No description**** |
| [RaceAlaskanNativeAleutKoniag](ValueSet-v3-RaceAlaskanNativeAleutKoniag.md) | ****No description**** |
| [RaceAlaskanNativeAleutUnangan](ValueSet-v3-RaceAlaskanNativeAleutUnangan.md) | ****No description**** |
| [RaceAlaskanNativeEskimo](ValueSet-v3-RaceAlaskanNativeEskimo.md) | ****No description**** |
| [RaceAlaskanNativeInupiatEskimo](ValueSet-v3-RaceAlaskanNativeInupiatEskimo.md) | ****No description**** |
| [RaceAlaskanNativeSiberianEskimo](ValueSet-v3-RaceAlaskanNativeSiberianEskimo.md) | ****No description**** |
| [RaceAlaskanNativeYupikEskimo](ValueSet-v3-RaceAlaskanNativeYupikEskimo.md) | ****No description**** |
| [RaceAmericanIndian](ValueSet-v3-RaceAmericanIndian.md) | ****No description**** |
| [RaceAmericanIndianApache](ValueSet-v3-RaceAmericanIndianApache.md) | ****No description**** |
| [RaceAmericanIndianArapaho](ValueSet-v3-RaceAmericanIndianArapaho.md) | ****No description**** |
| [RaceAmericanIndianAssiniboineSioux](ValueSet-v3-RaceAmericanIndianAssiniboineSioux.md) | ****No description**** |
| [RaceAmericanIndianCaddo](ValueSet-v3-RaceAmericanIndianCaddo.md) | ****No description**** |
| [RaceAmericanIndianCahuilla](ValueSet-v3-RaceAmericanIndianCahuilla.md) | ****No description**** |
| [RaceAmericanIndianCalifornia](ValueSet-v3-RaceAmericanIndianCalifornia.md) | ****No description**** |
| [RaceAmericanIndianChemakuan](ValueSet-v3-RaceAmericanIndianChemakuan.md) | ****No description**** |
| [RaceAmericanIndianCherokee](ValueSet-v3-RaceAmericanIndianCherokee.md) | ****No description**** |
| [RaceAmericanIndianCheyenne](ValueSet-v3-RaceAmericanIndianCheyenne.md) | ****No description**** |
| [RaceAmericanIndianChickahominy](ValueSet-v3-RaceAmericanIndianChickahominy.md) | ****No description**** |
| [RaceAmericanIndianChinook](ValueSet-v3-RaceAmericanIndianChinook.md) | ****No description**** |
| [RaceAmericanIndianChippewa](ValueSet-v3-RaceAmericanIndianChippewa.md) | ****No description**** |
| [RaceAmericanIndianChippewaCree](ValueSet-v3-RaceAmericanIndianChippewaCree.md) | ****No description**** |
| [RaceAmericanIndianChoctaw](ValueSet-v3-RaceAmericanIndianChoctaw.md) | ****No description**** |
| [RaceAmericanIndianChumash](ValueSet-v3-RaceAmericanIndianChumash.md) | ****No description**** |
| [RaceAmericanIndianComanche](ValueSet-v3-RaceAmericanIndianComanche.md) | ****No description**** |
| [RaceAmericanIndianCoushatta](ValueSet-v3-RaceAmericanIndianCoushatta.md) | ****No description**** |
| [RaceAmericanIndianCreek](ValueSet-v3-RaceAmericanIndianCreek.md) | ****No description**** |
| [RaceAmericanIndianCupeno](ValueSet-v3-RaceAmericanIndianCupeno.md) | ****No description**** |
| [RaceAmericanIndianDelaware](ValueSet-v3-RaceAmericanIndianDelaware.md) | ****No description**** |
| [RaceAmericanIndianDiegueno](ValueSet-v3-RaceAmericanIndianDiegueno.md) | ****No description**** |
| [RaceAmericanIndianEasternTribes](ValueSet-v3-RaceAmericanIndianEasternTribes.md) | ****No description**** |
| [RaceAmericanIndianGrosVentres](ValueSet-v3-RaceAmericanIndianGrosVentres.md) | ****No description**** |
| [RaceAmericanIndianHoopa](ValueSet-v3-RaceAmericanIndianHoopa.md) | ****No description**** |
| [RaceAmericanIndianIowa](ValueSet-v3-RaceAmericanIndianIowa.md) | ****No description**** |
| [RaceAmericanIndianIroquois](ValueSet-v3-RaceAmericanIndianIroquois.md) | ****No description**** |
| [RaceAmericanIndianKickapoo](ValueSet-v3-RaceAmericanIndianKickapoo.md) | ****No description**** |
| [RaceAmericanIndianKiowa](ValueSet-v3-RaceAmericanIndianKiowa.md) | ****No description**** |
| [RaceAmericanIndianKlallam](ValueSet-v3-RaceAmericanIndianKlallam.md) | ****No description**** |
| [RaceAmericanIndianLongIsland](ValueSet-v3-RaceAmericanIndianLongIsland.md) | ****No description**** |
| [RaceAmericanIndianLuiseno](ValueSet-v3-RaceAmericanIndianLuiseno.md) | ****No description**** |
| [RaceAmericanIndianMaidu](ValueSet-v3-RaceAmericanIndianMaidu.md) | ****No description**** |
| [RaceAmericanIndianMiami](ValueSet-v3-RaceAmericanIndianMiami.md) | ****No description**** |
| [RaceAmericanIndianMicmac](ValueSet-v3-RaceAmericanIndianMicmac.md) | ****No description**** |
| [RaceAmericanIndianNavajo](ValueSet-v3-RaceAmericanIndianNavajo.md) | ****No description**** |
| [RaceAmericanIndianNorthwestTribes](ValueSet-v3-RaceAmericanIndianNorthwestTribes.md) | ****No description**** |
| [RaceAmericanIndianOttawa](ValueSet-v3-RaceAmericanIndianOttawa.md) | ****No description**** |
| [RaceAmericanIndianPaiute](ValueSet-v3-RaceAmericanIndianPaiute.md) | ****No description**** |
| [RaceAmericanIndianPassamaquoddy](ValueSet-v3-RaceAmericanIndianPassamaquoddy.md) | ****No description**** |
| [RaceAmericanIndianPawnee](ValueSet-v3-RaceAmericanIndianPawnee.md) | ****No description**** |
| [RaceAmericanIndianPeoria](ValueSet-v3-RaceAmericanIndianPeoria.md) | ****No description**** |
| [RaceAmericanIndianPequot](ValueSet-v3-RaceAmericanIndianPequot.md) | ****No description**** |
| [RaceAmericanIndianPima](ValueSet-v3-RaceAmericanIndianPima.md) | ****No description**** |
| [RaceAmericanIndianPomo](ValueSet-v3-RaceAmericanIndianPomo.md) | ****No description**** |
| [RaceAmericanIndianPonca](ValueSet-v3-RaceAmericanIndianPonca.md) | ****No description**** |
| [RaceAmericanIndianPotawatomi](ValueSet-v3-RaceAmericanIndianPotawatomi.md) | ****No description**** |
| [RaceAmericanIndianPueblo](ValueSet-v3-RaceAmericanIndianPueblo.md) | ****No description**** |
| [RaceAmericanIndianPugetSoundSalish](ValueSet-v3-RaceAmericanIndianPugetSoundSalish.md) | ****No description**** |
| [RaceAmericanIndianSacFox](ValueSet-v3-RaceAmericanIndianSacFox.md) | ****No description**** |
| [RaceAmericanIndianSeminole](ValueSet-v3-RaceAmericanIndianSeminole.md) | ****No description**** |
| [RaceAmericanIndianSerrano](ValueSet-v3-RaceAmericanIndianSerrano.md) | ****No description**** |
| [RaceAmericanIndianShawnee](ValueSet-v3-RaceAmericanIndianShawnee.md) | ****No description**** |
| [RaceAmericanIndianShoshone](ValueSet-v3-RaceAmericanIndianShoshone.md) | ****No description**** |
| [RaceAmericanIndianShoshonePaiute](ValueSet-v3-RaceAmericanIndianShoshonePaiute.md) | ****No description**** |
| [RaceAmericanIndianSioux](ValueSet-v3-RaceAmericanIndianSioux.md) | ****No description**** |
| [RaceAmericanIndianTohonoOOdham](ValueSet-v3-RaceAmericanIndianTohonoOOdham.md) | ****No description**** |
| [RaceAmericanIndianUmpqua](ValueSet-v3-RaceAmericanIndianUmpqua.md) | ****No description**** |
| [RaceAmericanIndianUte](ValueSet-v3-RaceAmericanIndianUte.md) | ****No description**** |
| [RaceAmericanIndianWampanoag](ValueSet-v3-RaceAmericanIndianWampanoag.md) | ****No description**** |
| [RaceAmericanIndianWashoe](ValueSet-v3-RaceAmericanIndianWashoe.md) | ****No description**** |
| [RaceAmericanIndianWinnebago](ValueSet-v3-RaceAmericanIndianWinnebago.md) | ****No description**** |
| [RaceAmericanIndianYuman](ValueSet-v3-RaceAmericanIndianYuman.md) | ****No description**** |
| [RaceAmericanIndianYurok](ValueSet-v3-RaceAmericanIndianYurok.md) | ****No description**** |
| [RaceAsian](ValueSet-v3-RaceAsian.md) | ****No description**** |
| [RaceBlackOrAfricanAmerican](ValueSet-v3-RaceBlackOrAfricanAmerican.md) | ****No description**** |
| [RaceCanadianLatinIndian](ValueSet-v3-RaceCanadianLatinIndian.md) | ****No description**** |
| [RaceHawaiianOrPacificIsland](ValueSet-v3-RaceHawaiianOrPacificIsland.md) | ****No description**** |
| [RaceNativeAmerican](ValueSet-v3-RaceNativeAmerican.md) | ****No description**** |
| [RacePacificIslandMelanesian](ValueSet-v3-RacePacificIslandMelanesian.md) | ****No description**** |
| [RacePacificIslandMicronesian](ValueSet-v3-RacePacificIslandMicronesian.md) | ****No description**** |
| [RacePacificIslandPolynesian](ValueSet-v3-RacePacificIslandPolynesian.md) | ****No description**** |
| [RaceSoutheastAlaskanIndian](ValueSet-v3-RaceSoutheastAlaskanIndian.md) | ****No description**** |
| [RaceSoutheastAlaskanIndianTlingit](ValueSet-v3-RaceSoutheastAlaskanIndianTlingit.md) | ****No description**** |
| [RaceSoutheastAlaskanIndianTsimshian](ValueSet-v3-RaceSoutheastAlaskanIndianTsimshian.md) | ****No description**** |
| [RaceWhite](ValueSet-v3-RaceWhite.md) | ****No description**** |
| [RaceWhiteArab](ValueSet-v3-RaceWhiteArab.md) | ****No description**** |
| [RaceWhiteEuropean](ValueSet-v3-RaceWhiteEuropean.md) | ****No description**** |
| [RaceWhiteMiddleEast](ValueSet-v3-RaceWhiteMiddleEast.md) | ****No description**** |
| [RadDiagTherPracticeSetting](ValueSet-v3-RadDiagTherPracticeSetting.md) | A practice setting where radiology services (diagnostic or therapeutic) are provided (X12N 261QR0200N) |
| [ReactionDetectedIssueCode](ValueSet-v3-ReactionDetectedIssueCode.md) | Proposed therapy may be inappropriate or contraindicated based on the potential for a patient reaction to the proposed product |
| [ReactionParticipant](ValueSet-v3-ReactionParticipant.md) | ****No description**** |
| [ReactivityObservationInterpretation](ValueSet-v3-ReactivityObservationInterpretation.md) | Interpretations of the presence and level of reactivity of the specified component / analyte with the reagent in the performed laboratory test. |
| [Reason Medication Given Codes](ValueSet-reason-medication-given-codes.md) | This value set is provided as an example. The value set to instantiate this attribute should be drawn from a robust terminology code system that consists of or contains concepts to support the medication process. |
| [Recorded Sex Or Gender Type](ValueSet-recorded-sex-or-gender-type.md) | Codes that represent the type of the recorded sex and gender. |
| [RectalInstillation](ValueSet-v3-RectalInstillation.md) | Instillation, rectal |
| [RectalRoute](ValueSet-v3-RectalRoute.md) | Rectal |
| [ReferralMethod](ValueSet-service-referral-method.md) | The methods of referral can be used when referring to a specific HealthCareService resource. |
| [RefillPharmacySupplyType](ValueSet-v3-RefillPharmacySupplyType.md) | A fill against an order that has already been filled (or partially filled) at least once. |
| [RefrainPolicy](ValueSet-v3-RefrainPolicy.md) | Conveys prohibited actions which an information custodian, receiver, or user is not permitted to perform unless otherwise authorized or permitted under specified circumstances.**Examples:*** prohibit redisclosure without consent directive
 |
| [RefusalReasonCode](ValueSet-v3-RefusalReasonCode.md) | ****No description**** |
| [RegulationPolicyActCode](ValueSet-v3-RegulationPolicyActCode.md) | **Description:**A rule set by regulators of product that somehow constrain the use of products. Regulator may be any organization with a mandate to issue such rules, regardless of level, regional, country, state, and local (e.g., an institutional Pharmaceutical and Treatment Committee.)**Examples:*** Prescription Only 
* Controlled Substance Schedule II 
* Standard of Practice
 |
| [RehabilitationHospital](ValueSet-v3-RehabilitationHospital.md) | (X12N 283X00000N) |
| [RejectionCriterion](ValueSet-rejection-criteria.md) | Criterion for rejection of the specimen by laboratory. |
| [RelatedReactionDetectedIssueCode](ValueSet-v3-RelatedReactionDetectedIssueCode.md) | Proposed therapy may be inappropriate or contraindicated because of a potential patient reaction to a cross-sensitivity related product. |
| [RelationalOperator](ValueSet-v3-RelationalOperator.md) | Identifies common relational operators used in selection criteria. |
| [RelationshipConjunction](ValueSet-v3-RelationshipConjunction.md) | A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.g., and, or, exclusive-or.)**Constraints:**All AND criteria must be true. If OR and AND criteria occur together, one criterion out of the OR-group must be true and all AND criteria must be true also. If XOR criteria occur together with OR and AND criteria, exactly one of the XOR criteria must be true, and at least one of the OR criteria and all AND criteria must be true. In other words, the sets of AND, OR, and XOR criteria are in turn combined by a logical AND operator (all AND criteria and at least one OR criterion and exactly one XOR criterion.) To overcome this ordering, Act criteria can be nested in any way necessary. |
| [ReligiousAffiliation](ValueSet-v3-ReligiousAffiliation.md) | Assigment of spiritual faith affiliation |
| [RepetitionsOutOfRange](ValueSet-v3-RepetitionsOutOfRange.md) | ****No description**** |
| [Research Study Party Role](ValueSet-research-study-party-role.md) | This is a ResearchStudy's party role. |
| [Research Study Status](ValueSet-research-study-status.md) | Codes that convey the current status of the research study. |
| [Research Subject Milestones](ValueSet-research-subject-milestones.md) | A terminology codelist relevant to protocol-specified, point-in-time events during a study. |
| [ResearchStudyObjectiveType](ValueSet-research-study-objective-type.md) | Codes for the kind of study objective. |
| [ResearchStudyPhase](ValueSet-research-study-phase.md) | Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation. |
| [ResearchStudyPrimaryPurposeType](ValueSet-research-study-prim-purp-type.md) | Codes for the main intent of the study. |
| [ResearchStudyReasonStopped](ValueSet-research-study-reason-stopped.md) | Codes for why the study ended prematurely. |
| [ResearchSubjectMilestone](ValueSet-research-subject-milestone.md) | Indicates the progression of a study subject through the study milestones.**Deprecation Information:**This valueSet is being replaced in favor of using NCI Thesaurus codes.[Research Subject Milestones](http://terminology.hl7.org/ValueSet/research-subject-milestones)should be used instead |
| [ResearchSubjectRoleBasis](ValueSet-v3-ResearchSubjectRoleBasis.md) | Specifies the administrative functionality within a formal experimental design for which the ResearchSubject role was established. Examples: screening - role is used for pre-enrollment evaluation portion of the design; enrolled - role is used for subjects admitted to the active treatment portion of the design. |
| [ResearchSubjectState](ValueSet-research-subject-state.md) | Indicates the progression of a study subject through a study. |
| [ResearchSubjectStateType](ValueSet-research-subject-state-type.md) | Identifies the kind of state being refered to. |
| [ResidentialTreatmentPracticeSetting](ValueSet-v3-ResidentialTreatmentPracticeSetting.md) | ****No description**** |
| [ResourceGroupEntityType](ValueSet-v3-ResourceGroupEntityType.md) | Codes to characterize a Resource Group using categories that typify its membership and/or function .**Example:**PractitionerGroup |
| [ResourceSecurityCategory](ValueSet-resource-security-category.md) | Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Delete a resource. |
| [RespiratoryTractRoute](ValueSet-v3-RespiratoryTractRoute.md) | Respiratory tract |
| [ResponseLevel](ValueSet-v3-ResponseLevel.md) | Specifies whether a response is expected from the addressee of this interaction and what level of detail that response should include |
| [ResponseModality](ValueSet-v3-ResponseModality.md) | Defines the timing and grouping of the response instances. |
| [ResponseMode](ValueSet-v3-ResponseMode.md) | Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its receiver responsibilities. |
| [ResponsibleParty](ValueSet-v3-ResponsibleParty.md) | The role played by a party who has legal responsibility for another party. |
| [RetrobulbarRoute](ValueSet-v3-RetrobulbarRoute.md) | Retrobulbar |
| [RheumClinPracticeSetting](ValueSet-v3-RheumClinPracticeSetting.md) | ****No description**** |
| [RigidContainerEntityType](ValueSet-v3-RigidContainerEntityType.md) | A container having a fixed and inflexible dimensions and volume |
| [Rinse](ValueSet-v3-Rinse.md) | Rinse |
| [Risk Probability](ValueSet-risk-probability.md) | Codes representing the likelihood of a particular outcome in a risk assessment. |
| [Ritwan](ValueSet-v3-Ritwan.md) | ****No description**** |
| [River](ValueSet-v3-River.md) | ****No description**** |
| [RoleClass](ValueSet-v3-RoleClass.md) | This table includes codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role. The role hierarchy stems from three core concepts, or abstract domains:* **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity. 
* **RoleClassPartitive** collects roles in which the playing entity is in some sense a "part" of the scoping entity. 
* **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between: 
* **RoleClassPassive** which are roles in which the playing entity is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping entity. The playing entity is passive in these roles in that the role exists without an agreement from the playing entity. 
* **RoleClassMutualRelationship** which are relationships based on mutual behavior of the two entities. The basis of these relationship may be formal agreements or they may be **de facto** behavior. Thus, this sub-domain is further divided into: 
* **RoleClassRelationshipFormal** in which the relationship is formally defined, frequently by a contract or agreement. 
* **Personal relationship** which inks two people in a personal relationship. The hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the "Personal relationship" which is a leaf concept.
 
 
 |
| [RoleClassAccess](ValueSet-v3-RoleClassAccess.md) | A role in which the playing entity (material) provides access to another entity. The principal use case is intravenous (or other bodily) access lines that preexist and need to be referred to for medication routing instructions. |
| [RoleClassActiveIngredient](ValueSet-v3-RoleClassActiveIngredient.md) | A therapeutically active ingredient (player) in a mixture (scoper), where the mixture is typically a manufactured pharmaceutical. |
| [RoleClassActiveIngredientBasis](ValueSet-v3-RoleClassActiveIngredientBasis.md) | ****No description**** |
| [RoleClassActiveIngredientMoietyBasis](ValueSet-v3-RoleClassActiveIngredientMoietyBasis.md) | ****No description**** |
| [RoleClassActiveIngredientReferenceBasis](ValueSet-v3-RoleClassActiveIngredientReferenceBasis.md) | ****No description**** |
| [RoleClassActiveMoiety](ValueSet-v3-RoleClassActiveMoiety.md) | The molecule or ion that is responsible for the intended pharmacological action of the drug substance, excluding those appended or associated parts of the molecule that make the molecule an ester, salt (including a salt with hydrogen or coordination bonds), or other noncovalent derivative (such as a complex, chelate, or clathrate). Examples: heparin-sodium and heparin-potassium have the same active moiety, heparin; the active moiety of morphine-hydrochloride is morphine. |
| [RoleClassAdditive](ValueSet-v3-RoleClassAdditive.md) | An ingredient (player) that is added to a base (scoper), that amounts to a minor part of the overall mixture. |
| [RoleClassAdjacency](ValueSet-v3-RoleClassAdjacency.md) | ****No description**** |
| [RoleClassAdjuvant](ValueSet-v3-RoleClassAdjuvant.md) | ****No description**** |
| [RoleClassAdministerableMaterial](ValueSet-v3-RoleClassAdministerableMaterial.md) | A material (player) that can be administered to an Entity (scoper). |
| [RoleClassAffiliate](ValueSet-v3-RoleClassAffiliate.md) | Player of the Affiliate role has a business/professional relationship with scoper. Player and scoper may be persons or organization. The Affiliate relationship does not imply membership in a group, nor does it exist for resource scheduling purposes.**Example:**A healthcare provider is affiliated with another provider as a business associate. |
| [RoleClassAgent](ValueSet-v3-RoleClassAgent.md) | An entity (player) that acts or is authorized to act on behalf of another entity (scoper). |
| [RoleClassAliquot](ValueSet-v3-RoleClassAliquot.md) | A portion (player) of an original or source specimen (scoper) used for testing or transportation. |
| [RoleClassAssignedEntity](ValueSet-v3-RoleClassAssignedEntity.md) | An agent role in which the agent is an Entity acting in the employ of an organization. The focus is on functional role on behalf of the organization, unlike the Employee role where the focus is on the 'Human Resources' relationship between the employee and the organization. |
| [RoleClassAssociative](ValueSet-v3-RoleClassAssociative.md) | A general association between two entities that is neither partitive nor ontological. |
| [RoleClassBase](ValueSet-v3-RoleClassBase.md) | A base ingredient (player) is what comprises the major part of a mixture (scoper). E.g., Water in most i.v. solutions, or Vaseline in salves. Among all ingredients of a material, there should be only one base. A base substance can, in turn, be a mixture. |
| [RoleClassBirthplace](ValueSet-v3-RoleClassBirthplace.md) | Relates a place (playing Entity) as the location where a living subject (scoping Entity) was born. |
| [RoleClassCaregiver](ValueSet-v3-RoleClassCaregiver.md) | A person responsible for the primary care of a patient at home. |
| [RoleClassCaseSubject](ValueSet-v3-RoleClassCaseSubject.md) | A person, non-person living subject, or place that is the subject of an investigation related to a notifiable condition (health circumstance that is reportable within the applicable public health jurisdiction) |
| [RoleClassChild](ValueSet-v3-RoleClassChild.md) | The player of the role is a child of the scoping entity, in a generic sense. |
| [RoleClassCitizen](ValueSet-v3-RoleClassCitizen.md) | Citizen of apolitical entity |
| [RoleClassClaimant](ValueSet-v3-RoleClassClaimant.md) | **Description:**A role played by a party making a claim for coverage under a policy or program. A claimant must be either a person or organization, or a group of persons or organizations. A claimant is not a named insured or a program eligible.**Discussion:**With respect to liability insurance such as property and casualty insurance, a claimant must file a claim requesting indemnification for a loss that the claimant considers covered under the policy of a named insured. The claims adjuster for the policy underwriter will review the claim to determine whether the loss meets the benefit coverage criteria under a policy, and base any indemnification or coverage payment on that review. If a third party is liable in whole or part for the loss, the underwriter may pursue third party liability recovery. A claimant may be involved in civil or criminal legal proceedings involving claims against a defendant party that is indemnified by an insurance policy or to protest the finding of a claims adjustor. With respect to life insurance, a beneficiary designated by a named insured becomes a claimant of the proceeds of coverage, as in the case of a life insurance policy. However, a claimant for coverage under life insurance is not necessarily a designated beneficiary.**Note:**A claimant is not a named insured. However, a named insured may make a claim under a policy, e.g., an insured driver may make a claim for an injury under his or her comprehensive automobile insurance policy. Similarly, a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants. In the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that either a named insured or an individual insured has filed a claim for a loss. In the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a "claim" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.**Example:**A claimant under automobile policy that is not the named insured. |
| [RoleClassClinicalResearchInvestigator](ValueSet-v3-RoleClassClinicalResearchInvestigator.md) | A role played by a provider, always a person, who has agency authority from a Clinical Research Sponsor to direct the conduct of a clinical research trial or study on behalf of the sponsor. |
| [RoleClassClinicalResearchSponsor](ValueSet-v3-RoleClassClinicalResearchSponsor.md) | A role played by an entity, usually an organization, that is the sponsor of a clinical research trial or study. The sponsor commissions the study, bears the expenses, is responsible for satisfying all legal requirements concerning subject safety and privacy, and is generally responsible for collection, storage and analysis of the data generated during the trial. No scoper is necessary, as a clinical research sponsor undertakes the role on its own authority and declaration. Clinical research sponsors are usually educational or other research organizations, government agencies or biopharmaceutical companies. |
| [RoleClassColorAdditive](ValueSet-v3-RoleClassColorAdditive.md) | A substance (player) influencing the optical aspect of material (scoper). |
| [RoleClassCommissioningParty](ValueSet-v3-RoleClassCommissioningParty.md) | An Entity that is authorized to issue or instantiate permissions, privileges, credentials or other formal/legal authorizations. |
| [RoleClassConnection](ValueSet-v3-RoleClassConnection.md) | ****No description**** |
| [RoleClassContact](ValueSet-v3-RoleClassContact.md) | A person or an organization (player) which provides or receives information regarding another entity (scoper). Examples; patient NOK and emergency contacts; guarantor contact; employer contact. |
| [RoleClassContactCode](ValueSet-v3-RoleClassContactCode.md) | ****No description**** |
| [RoleClassContaminantIngredient](ValueSet-v3-RoleClassContaminantIngredient.md) | ****No description**** |
| [RoleClassContent](ValueSet-v3-RoleClassContent.md) | Relates a material as the content (player) to a container (scoper). Unlike ingredients, the content and a container remain separate (not mixed) and the content can be removed from the container. A content is not part of an empty container. |
| [RoleClassContinuity](ValueSet-v3-RoleClassContinuity.md) | ****No description**** |
| [RoleClassCoverageSponsor](ValueSet-v3-RoleClassCoverageSponsor.md) | A role played by an entity, usually an organization that is the sponsor of an insurance plan or a health program. A sponsor is the party that is ultimately accountable for the coverage by employment contract or by law. A sponsor can be an employer, union, government agency, or association. Fully insured sponsors establish the terms of the plan and contract with health insurance plans to assume the risk and to administer the plan. Self-insured sponsors delegate coverage administration, but not risk, to third-party administrators. Program sponsors designate services to be covered in accordance with statute. Program sponsors may administer the coverage themselves, delegate coverage administration, but not risk to third-party administrators, or contract with health insurance plans to assume the risk and administrator a program. Sponsors qualify individuals who may become1. a policy holder of the plan;
1. where the sponsor is the policy holder, who may become a subscriber or a dependent to a policy under the plan; or
1. where the sponsor is a government agency, who may become program eligibles under a program. The sponsor role may be further qualified by the SponsorRole.code. Entities playing the sponsor role may also play the role of a Coverage Administrator.**Example:**An employer, union, government agency, or association.
 |
| [RoleClassCoveredParty](ValueSet-v3-RoleClassCoveredParty.md) | **Description:**A relationship between a party that receives benefit coverage under the terms of an insurance policy or program and the underwriter of the policy or program. The role is played by the party that receives benefit coverage under the terms of a particular insurance policy or program. The organization playing the underwriter of that policy or program is the scoping entity. A covered party receives coverage under a policy because of some contractual or other relationship with the policy holder. In most cases, the policy holder has discretion over which parties may be covered under a policy, unless the policy holder assigns or is required by a court to assign this right. A covered party receives coverage under a program by being determined eligible based on program eligibility criteria specified by the program sponsor.**Discussion:**This reason for coverage is specified by use of a role type code from either of the abstract value sets beneath the PolicyOrProgramCoverageRoleType abstract value set. The CoverageRoleType abstract value set can only be used when the role class is the concept code "covered party" (COVPTY) because this value set contains precoordinated coded concepts relating to coverage criteria that was developed for the Canadian realm. This is to avoid overlapping concepts, e.g., the DEPEN role.class cannot be used with the FAMDEP Role.code The CoveredPartyRoleType abstract value set may be used with any of the covered party role class codes to support post coordination of coverage criteria. Where coverage under a policy depends on the concurrence of a policy holder, a relationship link with type code of indirect authority should be included using the policy holder role as the source, and the covered party role as the target.**Note:**A particular policy may cover several parties, one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.**Note:**The entity playing the role of covered party is an organization, a non-person living subject or a group of persons, the role class codes Subscriber and Dependent may not be used. |
| [RoleClassCredentialedEntity](ValueSet-v3-RoleClassCredentialedEntity.md) | A role played by an entity that receives credentials from the scoping entity. |
| [RoleClassDedicatedServiceDeliveryLocation](ValueSet-v3-RoleClassDedicatedServiceDeliveryLocation.md) | A role of a place (player) that is intended to house the provision of services. Scoper is the Entity (typically Organization) that provides these services. This is not synonymous with "ownership." |
| [RoleClassDependent](ValueSet-v3-RoleClassDependent.md) | **Description:**A role played by a person covered under a policy or program based on an association with a subscriber, which is recognized by the policy holder.**Note:**The party playing the role of a dependent is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a dependent may make a claim under a policy, e.g., a dependent under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a dependent making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the dependent has filed a claim for services covered under the health insurance policy.**Example:**The dependent has an association with the subscriber such as a financial dependency or personal relationship such as that of a spouse, or a natural or adopted child. The policy holder may be required by law to recognize certain associations or may have discretion about the associations. For example, a policy holder may dictate the criteria for the dependent status of adult children who are students, such as requiring full time enrollment, or may recognize domestic partners as dependents. Under certain circumstances, the dependent may be under the indirect authority of a responsible party acting as a surrogate for the subscriber, for example, if the subscriber is differently abled or deceased, a guardian ad Lidem or estate executor may be appointed to assume the subscriberaTMs legal standing in the relationship with the dependent. |
| [RoleClassDistributedMaterial](ValueSet-v3-RoleClassDistributedMaterial.md) | A material (player) distributed by a distributor (scoper) who functions between a manufacturer and a buyer or retailer. |
| [RoleClassEmergencyContact](ValueSet-v3-RoleClassEmergencyContact.md) | An entity to be contacted in the event of an emergency. |
| [RoleClassEmployee](ValueSet-v3-RoleClassEmployee.md) | A relationship between a person or organization and a person or organization formed for the purpose of exchanging work for compensation. The purpose of the role is to identify the type of relationship the employee has to the employer, rather than the nature of the work actually performed. (Contrast with AssignedEntity.) |
| [RoleClassEquivalentEntity](ValueSet-v3-RoleClassEquivalentEntity.md) | ****No description**** |
| [RoleClassEventLocation](ValueSet-v3-RoleClassEventLocation.md) | ****No description**** |
| [RoleClassExposedEntity](ValueSet-v3-RoleClassExposedEntity.md) | A role played by an entity that has been exposed to a person or animal suffering a contagious disease, or with a location from which a toxin has been distributed. The player of the role is normally a person or animal, but it is possible that other entity types could become exposed. The role is scoped by the source of the exposure, and it is quite possible for a person playing the role of exposed party to also become the scoper a role played by another person. That is to say, once a person has become infected, it is possible, perhaps likely, for that person to infect others. Management of exposures and tracking exposed parties is a key function within public health, and within most public health contexts - exposed parties are known as "contacts." |
| [RoleClassExposureAgentCarrier](ValueSet-v3-RoleClassExposureAgentCarrier.md) | An exposure agent carrier is an entity that is capable of conveying an exposure agent from one entity to another. The scoper of the role must be the exposure agent (e.g., pathogen). |
| [RoleClassExposureVector](ValueSet-v3-RoleClassExposureVector.md) | **Description:**A vector is a living subject that carries an exposure agent. The vector does not cause the disease itself, but exposes targets to the exposure agent. A mosquito carrying malaria is an example of a vector. The scoper of the role must be the exposure agent (e.g., pathogen). |
| [RoleClassFlavorAdditive](ValueSet-v3-RoleClassFlavorAdditive.md) | A substance (player) added to a mixture (scoper) to make it taste a certain way. In food the use is obvious, in pharmaceuticals flavors can hide disgusting taste of the active ingredient (important in pediatric treatments). |
| [RoleClassFomite](ValueSet-v3-RoleClassFomite.md) | **Description:**A fomite is a non-living entity that is capable of conveying exposure agent from one entity to another. A doorknob contaminated with a Norovirus is an example of a fomite. Anyone touching the doorknob would be exposed to the virus. The scoper of the role must be the exposure agent (e.g., pathogen). |
| [RoleClassGuarantor](ValueSet-v3-RoleClassGuarantor.md) | A person or organization (player) that serves as a financial guarantor for another person or organization (scoper). |
| [RoleClassGuardian](ValueSet-v3-RoleClassGuardian.md) | Guardian of a ward |
| [RoleClassHasGeneric](ValueSet-v3-RoleClassHasGeneric.md) | A special link between pharmaceuticals indicating that the target (scoper) is a generic for the source (player). |
| [RoleClassHealthChart](ValueSet-v3-RoleClassHealthChart.md) | The role of a material (player) that is the physical health chart belonging to an organization (scoper). |
| [RoleClassHealthcareProvider](ValueSet-v3-RoleClassHealthcareProvider.md) | An Entity (player) that is authorized to provide health care services by some authorizing agency (scoper). |
| [RoleClassHeldEntity](ValueSet-v3-RoleClassHeldEntity.md) | Entity that is currently in the possession of a holder (scoper), who holds, or uses it, usually based on some agreement with the owner. |
| [RoleClassICSRInvestigationSubject](ValueSet-v3-RoleClassICSRInvestigationSubject.md) | **Description:**The class of the primary role by which the party is identified as the subject of an adverse event assessment. |
| [RoleClassIdentifiedEntity](ValueSet-v3-RoleClassIdentifiedEntity.md) | Roles played by entities and scoped by entities that identify them for various purposes. |
| [RoleClassInactiveIngredient](ValueSet-v3-RoleClassInactiveIngredient.md) | ****No description**** |
| [RoleClassIncidentalServiceDeliveryLocation](ValueSet-v3-RoleClassIncidentalServiceDeliveryLocation.md) | A role played by a place at which health care services may be provided without prior designation or authorization. |
| [RoleClassIndividual](ValueSet-v3-RoleClassIndividual.md) | **Description:**A role played by a party covered under a policy as the policy holder. An individual may be either a person or an organization.**Note:**The party playing the role of an individual insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy if injured in an automobile accident and there is no liable third party. In the case of an individual insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that an individual insured has filed a claim for a loss.**Example:**The individual insured under a comprehensive automobile, disability, or property and casualty policy that is the policy holder. |
| [RoleClassIngredientEntity](ValueSet-v3-RoleClassIngredientEntity.md) | Relates a component (player) to a mixture (scoper). E.g., Glucose and Water are ingredients of D5W, latex may be an ingredient in a tracheal tube. |
| [RoleClassInstance](ValueSet-v3-RoleClassInstance.md) | An individual piece of material (player) instantiating a class of material (scoper). |
| [RoleClassInvestigationSubject](ValueSet-v3-RoleClassInvestigationSubject.md) | An entity that is the subject of an investigation. This role is scoped by the party responsible for the investigation. |
| [RoleClassInvoicePayor](ValueSet-v3-RoleClassInvoicePayor.md) | The role of an organization that undertakes to accept claims invoices, assess the coverage or payments due for those invoices and pay to the designated payees for those invoices. This role may be either the underwriter or a third-party organization authorized by the underwriter. The scoping entity is the organization that underwrites the claimed coverage. |
| [RoleClassIsSpeciesEntity](ValueSet-v3-RoleClassIsSpeciesEntity.md) | Relates a specialized material concept (player) to its generalization (scoper). |
| [RoleClassIsolate](ValueSet-v3-RoleClassIsolate.md) | A microorganism that has been isolated from other microorganisms or a source matrix. |
| [RoleClassLicensedEntity](ValueSet-v3-RoleClassLicensedEntity.md) | A relationship in which the scoper certifies the player ( e. g. a medical care giver, a medical device or a provider organization) to perform certain activities that fall under the jurisdiction of the scoper (e.g., a health authority licensing healthcare prlviders, a medical quality authority certifying healthcare professionals,) |
| [RoleClassLocatedEntity](ValueSet-v3-RoleClassLocatedEntity.md) | Relates an entity (player) to a location (scoper) at which it is present in some way. This presence may be limited in time. |
| [RoleClassMaintainedEntity](ValueSet-v3-RoleClassMaintainedEntity.md) | An entity (player) that is maintained by another entity (scoper). This is typical role held by durable equipment. The scoper assumes responsibility for proper operation, quality, and safety. |
| [RoleClassManagedEntity](ValueSet-v3-RoleClassManagedEntity.md) | **Description:**A value set of role classCodes related to entity management. |
| [RoleClassManufacturedProduct](ValueSet-v3-RoleClassManufacturedProduct.md) | Scoped by the manufacturer |
| [RoleClassMechanicalIngredient](ValueSet-v3-RoleClassMechanicalIngredient.md) | ****No description**** |
| [RoleClassMember](ValueSet-v3-RoleClassMember.md) | A role played by an entity that is a member of a group. The group provides the scope for this role. Among other uses, groups as used in insurance (groups of covered individuals) and in scheduling where resources may be grouped for scheduling and logistical purposes. |
| [RoleClassMilitaryPerson](ValueSet-v3-RoleClassMilitaryPerson.md) | A role played by a member of a military service. Scoper is the military service (e.g. Army, Navy, Air Force, etc.) or, more specifically, the unit (e.g. Company C, 3rd Battalion, 4th Division, etc.) |
| [RoleClassMolecularBond](ValueSet-v3-RoleClassMolecularBond.md) | ****No description**** |
| [RoleClassMolecularFeatures](ValueSet-v3-RoleClassMolecularFeatures.md) | ****No description**** |
| [RoleClassMolecularPart](ValueSet-v3-RoleClassMolecularPart.md) | ****No description**** |
| [RoleClassMutualRelationship](ValueSet-v3-RoleClassMutualRelationship.md) | A relationship that is based on mutual behavior of the two Entities as being related. The basis of such relationship may be agreements (e.g., spouses, contract parties) or they may be**de facto**behavior (e.g. friends) or may be an incidental involvement with each other (e.g. parties over a dispute, siblings, children). |
| [RoleClassNamedInsured](ValueSet-v3-RoleClassNamedInsured.md) | **Description:**A role played by a party to an insurance policy to which the insurer agrees to indemnify for losses, provides benefits for, or renders services. A named insured may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.**Discussion:**The coded concept NAMED should not be used where a more specific child concept in this Specializable value set applies. In some cases, the named insured may not be the policy holder, e.g., where a policy holder purchases life insurance policy in which another party is the named insured and the policy holder is the beneficiary of the policy.**Note:**The party playing the role of a named insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy e.g., if injured in an automobile accident and there is no liable third party. In the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that a named insured has filed a claim for a loss.**Example:**The named insured under a comprehensive automobile, disability, or property and casualty policy that is the named insured and may or may not be the policy holder. |
| [RoleClassNextOfKin](ValueSet-v3-RoleClassNextOfKin.md) | An individual designated for notification as the next of kin for a given entity. |
| [RoleClassNotaryPublic](ValueSet-v3-RoleClassNotaryPublic.md) | ****No description**** |
| [RoleClassNurse](ValueSet-v3-RoleClassNurse.md) | ****No description**** |
| [RoleClassNursePractitioner](ValueSet-v3-RoleClassNursePractitioner.md) | ****No description**** |
| [RoleClassOntological](ValueSet-v3-RoleClassOntological.md) | A relationship in which the scoping Entity defines or specifies what the playing Entity is. Thus, the player's "being" (Greek: ontos) is specified. |
| [RoleClassOwnedEntity](ValueSet-v3-RoleClassOwnedEntity.md) | An Entity (player) for which someone (scoper) is granted by law the right to call the material (player) his own. This entitles the scoper to make decisions about the disposition of that material. |
| [RoleClassPart](ValueSet-v3-RoleClassPart.md) | An association between two Entities where the playing Entity is considered in some way "part" of the scoping Entity, e.g., as a member, component, ingredient, or content. Being "part" in the broadest sense of the word can mean anything from being an integral structural component to a mere incidental temporary association of a playing Entity with a (generally larger) scoping Entity. |
| [RoleClassPartitive](ValueSet-v3-RoleClassPartitive.md) | An association between two Entities where the playing Entity is considered in some way "part" of the scoping Entity, e.g., as a member, component, ingredient, or content. Being "part" in the broadest sense of the word can mean anything from being an integral structural component to a mere incidental temporary association of a playing Entity with a (generally larger) scoping Entity. |
| [RoleClassPassive](ValueSet-v3-RoleClassPassive.md) | An association for a playing Entity that is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping Entity. The playing Entity is passive in these roles (even though it may be active in other roles), in the sense that the kinds of things done to it in this role happen without an agreement from the playing Entity. |
| [RoleClassPatient](ValueSet-v3-RoleClassPatient.md) | **Description:**A Role of a LivingSubject (player) as a recipient of health care services from a healthcare provider (scoper). |
| [RoleClassPayee](ValueSet-v3-RoleClassPayee.md) | The role of an organization or individual designated to receive payment for a claim against a particular coverage. The scoping entity is the organization that is the submitter of the invoice in question. |
| [RoleClassPersonalRelationship](ValueSet-v3-RoleClassPersonalRelationship.md) | Links two people in a personal relationship. The character of the relationship must be defined by a PersonalRelationshipRoleType code. The player and scoper are determined by PersonalRelationshipRoleType code as well. |
| [RoleClassPhysician](ValueSet-v3-RoleClassPhysician.md) | ****No description**** |
| [RoleClassPhysicianAssistant](ValueSet-v3-RoleClassPhysicianAssistant.md) | ****No description**** |
| [RoleClassPlaceOfDeath](ValueSet-v3-RoleClassPlaceOfDeath.md) | Definition: Relates a place (playing Entity) as the location where a living subject (scoping Entity) died. |
| [RoleClassPolicyHolder](ValueSet-v3-RoleClassPolicyHolder.md) | A role played by a person or organization that holds an insurance policy. The underwriter of that policy is the scoping entity.**Discussion:**The identifier of the policy is captured in 'Role.id' when the Role is a policy holder. A particular policy may cover several individuals one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder. |
| [RoleClassPreservative](ValueSet-v3-RoleClassPreservative.md) | A substance (player) added to a mixture (scoper) to prevent microorganisms (fungi, bacteria) to spoil the mixture. |
| [RoleClassProductRelated](ValueSet-v3-RoleClassProductRelated.md) | **Description:**A value set of product related role classCodes |
| [RoleClassProgramEligible](ValueSet-v3-RoleClassProgramEligible.md) | **Description:**A role played by a party that meets the eligibility criteria for coverage under a program. A program eligible may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.**Discussion:**A program as typically government administered coverage for parties determined eligible under the terms of the program.**Note:**The party playing a program eligible is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants. In the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a "claim" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.**Example:**A party meeting eligibility criteria related to health or financial status, e.g., in the U.S., persons meeting health, demographic, or financial criteria established by state and federal law are eligible for Medicaid. |
| [RoleClassQualifiedEntity](ValueSet-v3-RoleClassQualifiedEntity.md) | An entity (player) that has been recognized as having certain training/experience or other characteristics that would make said entity an appropriate performer for a certain activity. The scoper is an organization that educates or qualifies entities. |
| [RoleClassRegulatedProduct](ValueSet-v3-RoleClassRegulatedProduct.md) | A product regulated by some governmentatl orgnization. The role is played by Material and scoped by Organization. Rationale: To support an entity clone used to identify the NDC number for a drug product. |
| [RoleClassRelationshipFormal](ValueSet-v3-RoleClassRelationshipFormal.md) | A relationship between two entities that is formally recognized, frequently by a contract or similar agreement. |
| [RoleClassResearchSubject](ValueSet-v3-RoleClassResearchSubject.md) | **Definition:**Specifies the administrative functionality within a formal experimental design for which the ResearchSubject role was established.**Examples:**Screening - role is used for pre-enrollment evaluation portion of the design; enrolled - role is used for subjects admitted to the experimental portion of the design. |
| [RoleClassRetailedMaterial](ValueSet-v3-RoleClassRetailedMaterial.md) | Material (player) sold by a retailer (scoper), who also give advice to prospective buyers. |
| [RoleClassRoot](ValueSet-v3-RoleClassRoot.md) | Corresponds to the Role class |
| [RoleClassSame](ValueSet-v3-RoleClassSame.md) | The "same" roleclass asserts an identity between playing and scoping entities: that they are in fact instances of the same entity and, in the case of discrepancies (e.g different DOB, gender), that one or both are in error.**Usage:**playing and scoping entities must have same classcode, but need not have identical attributes or values.**Example:**a provider registry maintains sets of conflicting demographic data for what is reported to be the same individual. |
| [RoleClassServiceDeliveryLocation](ValueSet-v3-RoleClassServiceDeliveryLocation.md) | A role played by a place at which services may be provided. |
| [RoleClassSigningAuthorityOrOfficer](ValueSet-v3-RoleClassSigningAuthorityOrOfficer.md) | The role of a person (player) who is the officer or signature authority for of a scoping entity, usually an organization (scoper). |
| [RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md) | A role played by a material entity that is a specimen for an act. It is scoped by the source of the specimen. |
| [RoleClassStabilizer](ValueSet-v3-RoleClassStabilizer.md) | A stabilizer (player) added to a mixture (scoper) in order to prevent the molecular disintegration of the main substance. |
| [RoleClassStoredEntity](ValueSet-v3-RoleClassStoredEntity.md) | Relates an entity (player) (e.g. a device) to a location (scoper) at which it is normally found or stored when not used. |
| [RoleClassStudent](ValueSet-v3-RoleClassStudent.md) | A role played by an individual who is a student of a school, which is the scoping entity. |
| [RoleClassSubscriber](ValueSet-v3-RoleClassSubscriber.md) | **Description:**A role played by a person covered under a policy based on association with a sponsor who is the policy holder, and whose association may provide for the eligibility of dependents for coverage.**Discussion:**The policy holder holds the contract with the policy or program underwriter. The subscriber holds a certificate of coverage under the contract. In legal proceedings concerning the policy or program, the terms of the contract takes precedence over the terms of the certificate of coverage if there are any inconsistencies.**Note:**The party playing the role of a subscriber is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a subscriber may make a claim under a policy, e.g., a subscriber under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a subscriber making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the subscriber has filed a claim for services covered under the health insurance policy.**Example:**An employee or a member of an association. |
| [RoleClassSubstancePresence](ValueSet-v3-RoleClassSubstancePresence.md) | The presence of an bio-chemical entity (substance) at a location or environment, such as an ingredient in a mixture, molecular part of a complex, a located entity at a cellular structure, or content of a container, such as a vesicle. |
| [RoleClassSubsumedBy](ValueSet-v3-RoleClassSubsumedBy.md) | Relates a prevailing record of an Entity (scoper) with another record (player) that it subsumes.**Examples:**Show a correct new Person object (scoper) that subsumes one or more duplicate Person objects that had accidentally been created for the same physical person.**Constraints:**Both the player and scoper must have the same classCode. |
| [RoleClassSubsumer](ValueSet-v3-RoleClassSubsumer.md) | An entity that subsumes the identity of another. Used in the context of merging documented entity instances. Both the player and scoper must have the same classCode. The use of this code is**deprecated**in favor of the term SUBY which is its inverse and is more ontologically correct. |
| [RoleClassTerritoryOfAuthority](ValueSet-v3-RoleClassTerritoryOfAuthority.md) | Relates a place entity (player) as the region over which the scoper (typically an Organization) has certain authority (jurisdiction). For example, the Calgary Regional Health Authority (scoper) has authority over the territory "Region 4 of Alberta" (player) in matters of health. |
| [RoleClassTherapeuticAgent](ValueSet-v3-RoleClassTherapeuticAgent.md) | A manufactured material (player) that is used for its therapeutic properties. The manufacturer is the scoper. |
| [RoleClassUnderwriter](ValueSet-v3-RoleClassUnderwriter.md) | A role played by a person or an organization. It is the party that1. accepts fiscal responsibility for insurance plans and the policies created under those plans;
1. administers and accepts fiscal responsibility for a program that provides coverage for services to eligible individuals; and/or
1. has the responsibility to assess the merits of each risk and decide a suitable premium for accepting all or part of the risk. If played by an organization, this role may be further specified by an appropriate RoleCode.**Example:**
1. A health insurer;
1. Medicaid Program;
1. Lloyd's of London
 |
| [RoleClassUsedEntity](ValueSet-v3-RoleClassUsedEntity.md) | **Description:**An entity (player) that is used by another entity (scoper) |
| [RoleClassWarrantedProduct](ValueSet-v3-RoleClassWarrantedProduct.md) | A role a product plays when a guarantee is given to the purchaser by the seller (scoping entity) stating that the product is reliable and free from known defects and that the seller will repair or replace defective parts within a given time limit and under certain conditions. |
| [RoleInformationSensitivityPolicy](ValueSet-v3-RoleInformationSensitivityPolicy.md) | RoleSensitivity codes are used to bind information to a Role.confidentialityCode per organizational policy. Role.confidentialityCode is defined in the RIM as "an indication of the appropriate disclosure of information about this Role with respect to the playing Entity." |
| [RoleLinkHasContact](ValueSet-v3-RoleLinkHasContact.md) | ****No description**** |
| [RoleLinkHasDirectAuthorityOver](ValueSet-v3-RoleLinkHasDirectAuthorityOver.md) | The source Role has direct authority over the target role in a chain of authority. |
| [RoleLinkHasIndirectAuthorityOver](ValueSet-v3-RoleLinkHasIndirectAuthorityOver.md) | The source Role has indirect authority over the target role in a chain of authority. |
| [RoleLinkHasPart](ValueSet-v3-RoleLinkHasPart.md) | The target Role is part of the Source Role. |
| [RoleLinkIdentification](ValueSet-v3-RoleLinkIdentification.md) | **Definition:**The source role provides identification for the target role. The source role must be IDENT. The player entity of the source role is constrained to be the same as the player of the target role if present. If the player is absent from the source role, then it is assumed to be the same as the player of the target role. |
| [RoleLinkIsBackupFor](ValueSet-v3-RoleLinkIsBackupFor.md) | This relationship indicates the source Role is available to the target Role as a backup. An entity in a backup role will be available as a substitute or replacement in the event that the entity assigned the role is unavailable. In medical roles where it is critical that the function be performed and there is a possibility that the individual assigned may be ill or otherwise indisposed, another individual is assigned to cover for the individual originally assigned the role. A backup may be required to be identified, but unless the backup is actually used, he/she would not assume the assigned entity role. |
| [RoleLinkRelated](ValueSet-v3-RoleLinkRelated.md) | An action taken with respect to a subject Entity by a regulatory or authoritative body with supervisory capacity over that entity. The action is taken in response to behavior by the subject Entity that body finds to be undesirable. Suspension, license restrictions, monetary fine, letter of reprimand, mandated training, mandated supervision, etc.**Examples:** |
| [RoleLinkReplaces](ValueSet-v3-RoleLinkReplaces.md) | This relationship indicates that the source Role replaces (or subsumes) the target Role. Allows for new identifiers and/or new effective time for a registry entry or a certification, etc. |
| [RoleLinkStatus](ValueSet-v3-RoleLinkStatus.md) | ****No description**** |
| [RoleLinkStatusActive](ValueSet-v3-RoleLinkStatusActive.md) | ****No description**** |
| [RoleLinkStatusCancelled](ValueSet-v3-RoleLinkStatusCancelled.md) | ****No description**** |
| [RoleLinkStatusCompleted](ValueSet-v3-RoleLinkStatusCompleted.md) | ****No description**** |
| [RoleLinkStatusNormal](ValueSet-v3-RoleLinkStatusNormal.md) | ****No description**** |
| [RoleLinkStatusNullified](ValueSet-v3-RoleLinkStatusNullified.md) | ****No description**** |
| [RoleLinkStatusPending](ValueSet-v3-RoleLinkStatusPending.md) | ****No description**** |
| [RoleLinkType](ValueSet-v3-RoleLinkType.md) | A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies specific constraints to what kinds of Role objects can be related and in which way. |
| [RoleLocationIdentifiedEntity](ValueSet-v3-RoleLocationIdentifiedEntity.md) | **Description:**Describes types of identifiers other than the primary location registry identifier for a service delivery location. Identifiers may be assigned by a local service delivery organization, a formal body capable of accrediting the location for the capability to provide specific services or the identifier may be assigned at a jurisdictional level. |
| [RoleStatus](ValueSet-v3-RoleStatus.md) | Codes representing the defined possible states of an Role, as defined by the Role class state machine. |
| [RoleStatusActive](ValueSet-v3-RoleStatusActive.md) | The state representing the fact that the Entity is currently active in the Role. |
| [RoleStatusCancelled](ValueSet-v3-RoleStatusCancelled.md) | The terminal state resulting from cancellation of the role prior to activation. |
| [RoleStatusNormal](ValueSet-v3-RoleStatusNormal.md) | The 'typical' state. Excludes "nullified" which represents the termination state of a Role instance that was created in error. |
| [RoleStatusNullified](ValueSet-v3-RoleStatusNullified.md) | The state representing the termination of a Role instance that was created in error. |
| [RoleStatusPending](ValueSet-v3-RoleStatusPending.md) | The state representing that fact that the role has not yet become active. |
| [RoleStatusSuspended](ValueSet-v3-RoleStatusSuspended.md) | The state that represents a suspension of the Entity playing the Role. This state is arrived at from the "active" state. |
| [RoleStatusTerminated](ValueSet-v3-RoleStatusTerminated.md) | The state representing the successful termination of the Role. |
| [RouteByMethod](ValueSet-v3-RouteByMethod.md) | Route of substance administration classified by administration method. |
| [RouteBySite](ValueSet-v3-RouteBySite.md) | Route of substance administration classified by site. |
| [RouteOfAdministration](ValueSet-v3-RouteOfAdministration.md) | The path the administered medication takes to get into the body or into contact with the body. |
| [SCDHEC-GISSpatialAccuracyTiers](ValueSet-v3-SCDHEC-GISSpatialAccuracyTiers.md) | **Description:**The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices. |
| [SNOMED International Global Patient Set (GPS)](ValueSet-snomed-intl-gps.md) | SNOMED International Global Patient Set (GPS) value set. The value set includes all of the codes from the SNOMED International Global Patient Set (GPS) subset of SNOMED CT. The current version of the value set contains all concepts (26,158) from the September 2020 release of the GPS (based on the July 2020 SNOMED CT International Edition release).This value set is provided as a FHIR ValueSet resource instance for the convenience of implementers. |
| [Sahaptian](ValueSet-v3-Sahaptian.md) | ****No description**** |
| [Salishan](ValueSet-v3-Salishan.md) | ****No description**** |
| [SaukFoxKickapoo](ValueSet-v3-SaukFoxKickapoo.md) | ****No description**** |
| [ScalpRoute](ValueSet-v3-ScalpRoute.md) | Scalp |
| [SchedulingActReason](ValueSet-v3-SchedulingActReason.md) | Reasons for cancelling or rescheduling an Appointment |
| [SecurityAlterationIntegrityObservationType](ValueSet-v3-SecurityAlterationIntegrityObservationType.md) | <pType of security metadata observation made about the alteration integrity of an IT resource (data, information object, service, or system capability), which indicates the mechanism used for authorized transformations of the resource.</p> |
| [SecurityAlterationIntegrityObservationValue](ValueSet-v3-SecurityAlterationIntegrityObservationValue.md) | ****No description**** |
| [SecurityCategoryObservationType](ValueSet-v3-SecurityCategoryObservationType.md) | Type of security metadata observation made about the category of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security category metadata is defined by ISO/IEC 2382-8:1998(E/F)/ T-REC-X.812-1995 as: "A nonhierarchical grouping of sensitive information used to control access to data more finely than with hierarchical security classification alone." |
| [SecurityCategoryObservationValue](ValueSet-v3-SecurityCategoryObservationValue.md) | Security observation values used to indicate security category metadata. V:SecurityCategoryObservationValue is the union of V:PrivacyPolicyType, V:ActPrivacyLaw, V:ActConsentDirective, V:InformationSensitivityPolicy, V:ActInformationSensitivityPolicy, V:RoleInformationSensitivityPolicy, V:EntityInformationSensitivityPolicy, and the V:ActConsentType value used to populate the SecurityCategoryObservationValue attribute in order to convey one or more nonhierarchical categories of sensitivity metadata, which are used to control access to data more finely than with hierarchical security classification alone. Could be bound R1 to a V:ActUSPrivacyPolicy in a future US Realm. |
| [SecurityClassificationObservationType](ValueSet-v3-SecurityClassificationObservationType.md) | Type of security metadata observation made about the classification of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security classification is defined by ISO/IEC 2382-8:1998(E/F)/ T-REC-X.812-1995 as: "The determination of which specific degree of protection against access the data or information requires, together with a designation of that degree of protection." Security classification metadata is based on an analysis of applicable policies and the risk of financial, reputational, or other harm that could result from unauthorized disclosure. |
| [SecurityClassificationObservationValue](ValueSet-v3-SecurityClassificationObservationValue.md) | Security observation values used to indicate security classification metadata. |
| [SecurityControlObservationType](ValueSet-v3-SecurityControlObservationType.md) | Type of security metadata observation made about the control of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security control metadata conveys instructions for secure distribution, transmission, storage or use. |
| [SecurityControlObservationValue](ValueSet-v3-SecurityControlObservationValue.md) | Security observation values used to indicate security control metadata. V:SecurityControl is the union of V:SecurityPolicy, V:ObligationPolicy, V:RefrainPolicy, V:PurposeOfUse, and V:GeneralPurpose of Use, V:PrivacyMark, V:SecurityLabelMark, and V:ControlledUnclassifiedInformation used to populate the SecurityControlObservationValue attribute in order to convey one or more nonhierarchical security control metadata dictating handling caveats including, purpose of use, obligation policy, refrain policy, dissemination controls and privacy marks to which a custodian or receiver is required to comply. |
| [SecurityDataIntegrityObservationType](ValueSet-v3-SecurityDataIntegrityObservationType.md) | Type of security metadata observation made about the data integrity of an IT resource (data, information object, service, or system capability), which indicates the security mechanism used to preserve resource accuracy and consistency. Data integrity is defined by ISO 22600-23.3.21 as: "The property that data has not been altered or destroyed in an unauthorized manner", and by ISO/IEC 2382-8: The property of data whose accuracy and consistency are preserved regardless of changes made." |
| [SecurityDataIntegrityObservationValue](ValueSet-v3-SecurityDataIntegrityObservationValue.md) | Type of security metadata observation made about the data integrity of an IT resource (data, information object, service, or system capability), which indicates the security mechanism used to preserve resource accuracy and consistency. Data integrity is defined by ISO 22600-23.3.21 as: "The property that data has not been altered or destroyed in an unauthorized manner", and by ISO/IEC 2382-8: The property of data whose accuracy and consistency are preserved regardless of changes made." |
| [SecurityIntegrityConfidenceObservationType](ValueSet-v3-SecurityIntegrityConfidenceObservationType.md) | Type of security metadata observation made about the integrity confidence of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. |
| [SecurityIntegrityConfidenceObservationValue](ValueSet-v3-SecurityIntegrityConfidenceObservationValue.md) | ****No description**** |
| [SecurityIntegrityObservationType](ValueSet-v3-SecurityIntegrityObservationType.md) | Type of security metadata observation made about the integrity of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. |
| [SecurityIntegrityObservationValue](ValueSet-v3-SecurityIntegrityObservationValue.md) | Type of security metadata observation made about the integrity of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. |
| [SecurityIntegrityProvenanceAssertedByObservationType](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationType.md) | Type of security metadata observation made about the integrity provenance of an IT resource (data, information object, service, or system capability), which indicates the entity that made assertions about the resource. The asserting entity may not be the original informant about the resource. |
| [SecurityIntegrityProvenanceAssertedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceAssertedByObservationValue.md) | ****No description**** |
| [SecurityIntegrityProvenanceObservationType](ValueSet-v3-SecurityIntegrityProvenanceObservationType.md) | Type of security metadata observation made about the provenance integrity of an IT resource (data, information object, service, or system capability), which indicates the lifecycle completeness or workflow status of an IT resource, such as its creation, modification, suspension, and deletion; locations in which the resource has been collected or archived, from which it may be retrieved, and the history of its distribution and disclosure. Integrity provenance metadata about an IT resource may be used to assess its veracity, reliability, and trustworthiness. |
| [SecurityIntegrityProvenanceObservationValue](ValueSet-v3-SecurityIntegrityProvenanceObservationValue.md) | Type of security metadata observation made about the provenance integrity of an IT resource (data, information object, service, or system capability), which indicates the lifecycle completeness or workflow status of an IT resource, such as its creation, modification, suspension, and deletion; locations in which the resource has been collected or archived, from which it may be retrieved, and the history of its distribution and disclosure. Integrity provenance metadata about an IT resource may be used to assess its veracity, reliability, and trustworthiness. |
| [SecurityIntegrityProvenanceReportedByObservationType](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationType.md) | Type of security metadata observation made about the integrity provenance of an IT resource (data, information object, service, or system capability), which indicates the entity that reported the existence of the resource. The reporting entity may not be the original author of the resource. |
| [SecurityIntegrityProvenanceReportedByObservationValue](ValueSet-v3-SecurityIntegrityProvenanceReportedByObservationValue.md) | ****No description**** |
| [SecurityIntegrityStatusObservation](ValueSet-v3-SecurityIntegrityStatusObservation.md) | Security observation values used to indicate security integrity status metadata. |
| [SecurityIntegrityStatusObservationType](ValueSet-v3-SecurityIntegrityStatusObservationType.md) | Type of security metadata observation made about the integrity status of an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Indicates the completeness or workflow status of an IT resource, which may impact users that are authorized to access and use the resource. |
| [SecurityLabelMark](ValueSet-v3-SecurityLabelMark.md) | Codes used for displayed Security Label tags. Supports selection of SecurityLabelMark value set with head code for e.g., rules engine policy set purposes. |
| [SecurityLabelMarkLabel](ValueSet-v3-SecurityLabelMarkLabel.md) | Codes used for displayed Security Label tags. Supports the selection of SecurityLabelMark leaf concepts for use, e.g., in security labels. |
| [SecurityObservationType](ValueSet-v3-SecurityObservationType.md) | Type of security metadata observation made about an IT resource (data, information object, service, or system capability), which may be used to make access control decisions. Security metadata are used in security labels. According to ISO/TS 22600-3:2009(E) A.9.1.7 SECURITY LABEL MATCHING, Security label matching compares the initiator's clearance to the target's security label. All of the following must be true for authorization to be granted:* The security policy identifiers shall be identical, 
* The classification level of the initiator shall be greater than or equal to that of the target (that is, there shall be at least one value in the classification list of the clearance greater than or equal to the classification of the target), and 
* For each security category in the target label, there shall be a security category of the same type in the initiator'ijs clearance and the initiator's classification level shall dominate that of the target.
 |
| [SecurityObservationValue](ValueSet-v3-SecurityObservationValue.md) | Observation values used to indicate security observation metadata. |
| [SecurityPolicy](ValueSet-v3-SecurityPolicy.md) | Types of security policies that further specify the ActClassPolicy value set.**Examples:*** encrypt 
* prohibit redisclosure without consent directive
 |
| [SecurityTrustAccreditationObservationType](ValueSet-v3-SecurityTrustAccreditationObservationType.md) | Type of security metadata observation made about the formal declaration by an authority or neutral third party that validates the technical, security, trust, and business practice conformance of Trust Agents to facilitate security, interoperability, and trust among participants within a security domain or trust framework. |
| [SecurityTrustAccreditationObservationValue](ValueSet-v3-SecurityTrustAccreditationObservationValue.md) | Values for security metadata observation made about the formal declaration by an authority or neutral third party that validates the technical, security, trust, and business practice conformance of Trust Agents to facilitate security, interoperability, and trust among participants within a security domain or trust framework. |
| [SecurityTrustAgreementObservationType](ValueSet-v3-SecurityTrustAgreementObservationType.md) | Type of security metadata observation made about security requirements for a security domain. [ISO IEC 10181-1] |
| [SecurityTrustAgreementObservationValue](ValueSet-v3-SecurityTrustAgreementObservationValue.md) | Type of security metadata observation made about security requirements for a security domain. [ISO IEC 10181-1] Definition Is Immutable: true |
| [SecurityTrustAssuranceObservationType](ValueSet-v3-SecurityTrustAssuranceObservationType.md) | Values for security metadata observation made about the digital quality or reliability of a trust assertion, activity, capability, information exchange, mechanism, process, or protocol. |
| [SecurityTrustAssuranceObservationValue](ValueSet-v3-SecurityTrustAssuranceObservationValue.md) | Values for security metadata observation made about the digital quality or reliability of a trust assertion, activity, capability, information exchange, mechanism, process, or protocol. |
| [SecurityTrustCertificateObservationType](ValueSet-v3-SecurityTrustCertificateObservationType.md) | Type of security metadata observation made about a set of security-relevant data issued by a security authority or trusted third party, together with security information which is used to provide the integrity and data origin authentication services for an IT resource (data, information object, service, or system capability). [Based on ISO IEC 10181-1] |
| [SecurityTrustCertificateObservationValue](ValueSet-v3-SecurityTrustCertificateObservationValue.md) | Values for security metadata observation made about a set of security-relevant data issued by a security authority or trusted third party, together with security information which is used to provide the integrity and data origin authentication services for an IT resource (data, information object, service, or system capability). [Based on ISO IEC 10181-1] |
| [SecurityTrustFrameworkObservationType](ValueSet-v3-SecurityTrustFrameworkObservationType.md) | Type of security metadata observation made about a complete set of contracts, regulations, or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. [Kantara Initiative] |
| [SecurityTrustFrameworkObservationValue](ValueSet-v3-SecurityTrustFrameworkObservationValue.md) | Values for security metadata observation made about a complete set of contracts, regulations, or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. [Kantara Initiative] |
| [SecurityTrustMechanismObservationType](ValueSet-v3-SecurityTrustMechanismObservationType.md) | Type of security metadata observation made about a complete set of contracts, regulations, or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. [Kantara Initiative] |
| [SecurityTrustMechanismObservationValue](ValueSet-v3-SecurityTrustMechanismObservationValue.md) | Values for security metadata observation made about a complete set of contracts, regulations, or commitments that enable participating actors to rely on certain assertions by other actors to fulfill their information security requirements. [Kantara Initiative] |
| [SecurityTrustObservationType](ValueSet-v3-SecurityTrustObservationType.md) | Type of security metadata observation made about aspects of trust applicable to an IT resource (data, information object, service, or system capability). Trust applicable to IT resources is established and maintained in and among security domains, and may be comprised of observations about the domain's trust authority, trust framework, trust policy, trust interaction rules, means for assessing and monitoring adherence to trust policies, mechanisms that enforce trust, and quality and reliability measures of assurance in those mechanisms. [Based on ISO IEC 10181-1 and NIST SP 800-63-2]**Usage Note:**SecurityTrustObservationType may be used as a trust attribute in a computable trust policy, trust credential, trust assertion, or trust label field in a security label and populated with trust observation values. The valued trust attributes may be used for used for authentication, authorization, and access control decisions. These may also be used to negotiate trust relationships, adjudicate or bridge trust policies, and to specify requirements for participation in a Trust Domain or for asserting compliance with a Trust Framework. |
| [SecurityTrustObservationValue](ValueSet-v3-SecurityTrustObservationValue.md) | Values for security metadata observation made about aspects of trust applicable to an IT resource (data, information object, service, or system capability). Trust applicable to IT resources is established and maintained in and among security domains, and may be comprised of observations about the domain's trust authority, trust framework, trust policy, trust interaction rules, means for assessing and monitoring adherence to trust policies, mechanisms that enforce trust, and quality and reliability measures of assurance in those mechanisms. [Based on ISO IEC 10181-1 and NIST SP 800-63-2] |
| [Sequencing](ValueSet-v3-Sequencing.md) | Specifies sequence of sort order. |
| [SerranoGabrielino](ValueSet-v3-SerranoGabrielino.md) | ****No description**** |
| [Service Delivery Method](ValueSet-service-delivery-method.md) | This value set defines a set of codes that can be used to indicate service delivery method. |
| [Service category](ValueSet-service-category.md) | This value set defines an example set of codes that can be used to classify groupings of service-types/specialties. |
| [Service type](ValueSet-service-type.md) | This value set defines an example set of codes of service-types. |
| [ServiceDeliveryLocationRoleType](ValueSet-v3-ServiceDeliveryLocationRoleType.md) | A role of a place that further classifies the setting (e.g., accident site, road side, work site, community location) in which services are delivered. |
| [ServiceProvisionConditions](ValueSet-service-provision-conditions.md) | The code(s) that detail the conditions under which the healthcare service is available/offered. |
| [SetOperator](ValueSet-v3-SetOperator.md) | ****No description**** |
| [SeverityObservation](ValueSet-v3-SeverityObservation.md) | Potential values for observations of severity. |
| [SeverityObservationCode](ValueSet-v3-SeverityObservationCode.md) | ****No description**** |
| [Sex Parameter for Clinical Use](ValueSet-sex-parameter-for-clinical-use.md) | A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc.. |
| [Shasta](ValueSet-v3-Shasta.md) | ****No description**** |
| [Sibling](ValueSet-v3-Sibling.md) | One person who shares a parent or parents with another. |
| [SiblingInLaw](ValueSet-v3-SiblingInLaw.md) | The player of the role is: (1) a sibling of the scoping person's spouse, or (2) the spouse of the scoping person's sibling, or (3) the spouse of a sibling of the scoping person's spouse. |
| [SignificantOtherRoleType](ValueSet-v3-SignificantOtherRoleType.md) | A person who is important to one's well being; especially a spouse or one in a similar relationship. (The player is the one who is important) |
| [SinusUnspecifiedRoute](ValueSet-v3-SinusUnspecifiedRoute.md) | Sinus, unspecified |
| [Siouan](ValueSet-v3-Siouan.md) | ****No description**** |
| [SiouanCatawba](ValueSet-v3-SiouanCatawba.md) | ****No description**** |
| [SirenikskiYupik](ValueSet-v3-SirenikskiYupik.md) | ****No description**** |
| [SkinRoute](ValueSet-v3-SkinRoute.md) | Skin |
| [SmartCapabilities](ValueSet-smart-capabilities.md) | Codes that define what the server is capable of. |
| [SnodentAnteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentAnteriorInterarchDeviationTypeInternational.md) | The SNODENT identifiers for dental anterior inter-arch deviations utilized to calculate the Salzmann Malocclusion Severity Index. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentCraniofacialAnomalyInternational](ValueSet-v3-SnodentCraniofacialAnomalyInternational.md) | The SNODENT identifiers for the most common craniofacial anomalies that may influence the course of orthodontic treatment to be performed. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalAbnormalityInternational](ValueSet-v3-SnodentDentalAbnormalityInternational.md) | The SNODENT identifiers for tooth-specific abnormalities that impact orthodontic treatment. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalFrenumRegionInternational](ValueSet-v3-SnodentDentalFrenumRegionInternational.md) | The SNODENT identifiers for the regions of the human frenum within the mouth. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalPeriodontalProbingPositionInternational](ValueSet-v3-SnodentDentalPeriodontalProbingPositionInternational.md) | The SNODENT identifiers for the relative positions around the tooth that are probed and measured in assessing a patient's periodontal health. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalToothFurcationSiteInternational](ValueSet-v3-SnodentDentalToothFurcationSiteInternational.md) | The SNODENT identifiers for the relative location of a human tooth root that is being observed for furcation. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalToothMobilityMillerClassificationInternational](ValueSet-v3-SnodentDentalToothMobilityMillerClassificationInternational.md) | The SNODENT identifiers for the recognized grades of tooth mobility according to the Miller Classification system. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentalUniversalNumberingSystemInternational](ValueSet-v3-SnodentDentalUniversalNumberingSystemInternational.md) | The SNODENT identifiers for all of the possible human teeth, both adult and adolescent. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentDentitionStateInternational](ValueSet-v3-SnodentDentitionStateInternational.md) | The SNODENT identifiers for the stages of dentition an individual progresses through during a lifetime. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentJawTypeInternational](ValueSet-v3-SnodentJawTypeInternational.md) | The SNODENT identifiers for the two jaws (mandible and maxilla). This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentOralCavityAreaInternational](ValueSet-v3-SnodentOralCavityAreaInternational.md) | The SNODENT identifiers for regions in the mouth utilized to calculate the Salzmann Malocclusion Severity Index. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentOrthodonticDiagnosticFeatureInternational](ValueSet-v3-SnodentOrthodonticDiagnosticFeatureInternational.md) | The SNODENT identifiers for gross patient findings that inform the course of orthodontic treatment to be performed. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentOrthodonticTreatmentPreconditionInternational](ValueSet-v3-SnodentOrthodonticTreatmentPreconditionInternational.md) | The SNODENT identifiers for patient conditions that may preclude starting orthodontic treatment. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentPosteriorInterarchDeviationTypeInternational](ValueSet-v3-SnodentPosteriorInterarchDeviationTypeInternational.md) | The SNODENT identifiers for dental posterior inter-arch deviations utilized to calculate the Salzmann Malocclusion Severity Index. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SnodentSalzmannInterarchDeviationMaxillaryToothInternational](ValueSet-v3-SnodentSalzmannInterarchDeviationMaxillaryToothInternational.md) | The SNODENT identifiers for the teeth in the maxilla assessed for tooth-specific inter-arch deviations as part of calculating the Salzmann Malocclusion Severity Index. This value set contains content from SNODENT® Copyright American Dental Association (ADA). All rights reserved. SNODENT is a registered trademark of the ADA. http://www.ada.org/en/member-center/member-benefits/practice-resources/dental-informatics/snodent/licensing-snodent**Steward:**Attachments WG |
| [SoftTissueRoute](ValueSet-v3-SoftTissueRoute.md) | Soft tissue |
| [Software Name Example](ValueSet-v3-SoftwareNameExample.md) | An example value set representing the SoftwareName concept domain used to convey a coded name for a device.. |
| [Software System Type](ValueSet-software-system-type.md) | Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation) |
| [SolidDrugForm](ValueSet-v3-SolidDrugForm.md) | ****No description**** |
| [SolutionDrugForm](ValueSet-v3-SolutionDrugForm.md) | A liquid preparation that contains one or more chemical substances dissolved, i.e., molecularly dispersed, in a suitable solvent or mixture of mutually miscible solvents. |
| [SouthernAlaska](ValueSet-v3-SouthernAlaska.md) | ****No description**** |
| [SouthernCaddoan](ValueSet-v3-SouthernCaddoan.md) | ****No description**** |
| [SouthernNumic](ValueSet-v3-SouthernNumic.md) | ****No description**** |
| [Special arrangements](ValueSet-encounter-special-arrangements.md) | This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit. |
| [SpecialValues](ValueSet-special-values.md) | A set of generally useful codes defined so they can be included in value sets. |
| [SpecimenAdditiveEntity](ValueSet-v3-SpecimenAdditiveEntity.md) | Set of codes related to specimen additives |
| [SpecimenEntityType](ValueSet-v3-SpecimenEntityType.md) | ****No description**** |
| [SpecimenRoleType](ValueSet-v3-SpecimenRoleType.md) | ****No description**** |
| [SponsorParticipationFunction](ValueSet-v3-SponsorParticipationFunction.md) | **Definition:**Set of codes indicating the manner in which sponsors participate in a policy or program. NOTE: use only when the Sponsor is not further specified with a SponsorRoleType as being either a fully insured sponsor or a self insured sponsor. |
| [Spouse](ValueSet-v3-Spouse.md) | **Description:**A relationship between two people characterizing their "familial" relationship |
| [StandardsStatus](ValueSet-standards-status.md) | HL7 Ballot/Standards status of artifact. |
| [StateChangeReason](ValueSet-state-change-reason.md) | Indicates why the state of the subject changed. |
| [Statistic Model Code](ValueSet-statistic-model-code.md) | The handling of the variable in statistical analysis for exposures or outcomes. |
| [StatisticAttributeEstimateType](ValueSet-attribute-estimate-type.md) | Method of reporting variability of estimates, such as confidence intervals, interquartile range or standard deviation. |
| [StatisticCertaintyRating](ValueSet-certainty-rating.md) | The relative quality of the statistic. |
| [StatisticCertaintySubcomponentRating](ValueSet-certainty-subcomponent-rating.md) | The quality rating of the subcomponent of a quality of evidence rating. |
| [StatisticCertaintySubcomponentType](ValueSet-certainty-subcomponent-type.md) | The subcomponent classification of quality of evidence rating systems. |
| [StatisticStatisticType](ValueSet-statistic-type.md) | The type of a specific statistic. |
| [StatisticStudyType](ValueSet-study-type.md) | The type of study a statistic was derived from. |
| [StatisticSynthesisType](ValueSet-synthesis-type.md) | Types of combining results from a body of evidence (eg. summary data meta-analysis). |
| [StatisticsCode](ValueSet-observation-statistics.md) | The statistical operation parameter -"statistic" codes. |
| [StatusRevisionRefusalReasonCode](ValueSet-v3-StatusRevisionRefusalReasonCode.md) | Indicates why the act revision (status update) is being refused. |
| [StepChild](ValueSet-v3-StepChild.md) | The player of the role is a child of the scoping person's spouse by a previous union. |
| [StepParent](ValueSet-v3-StepParent.md) | The player of the role is the spouse of the scoping person's parent and not the scoping person's natural parent. |
| [StepSibling](ValueSet-v3-StepSibling.md) | The player of the role is a child of the scoping person's stepparent. |
| [StreetAddressLine](ValueSet-v3-StreetAddressLine.md) | ****No description**** |
| [StreetName](ValueSet-v3-StreetName.md) | ****No description**** |
| [StrengthOfRecommendationRating](ValueSet-recommendation-strength.md) | A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems. |
| [Structure Definition Use Codes / Keywords](ValueSet-definition-use.md) | Structure Definition Use Codes / Keywords |
| [StudentRoleType](ValueSet-v3-StudentRoleType.md) | Covered party to an insurance policy has coverage through full-time or part-time attendance at a recognized educational institution as defined by a particular insurance policy. |
| [Study Design](ValueSet-study-design.md) | This is a set of terms for study design characteristics. |
| [StyleType](ValueSet-v3-StyleType.md) | (abstract) Used within an instance to give the author some control over various aspects of rendering |
| [SubarachnoidRoute](ValueSet-v3-SubarachnoidRoute.md) | Subarachnoid |
| [SubconjunctivalRoute](ValueSet-v3-SubconjunctivalRoute.md) | Subconjunctival |
| [SubcutaneousRoute](ValueSet-v3-SubcutaneousRoute.md) | Subcutaneous |
| [SublesionalRoute](ValueSet-v3-SublesionalRoute.md) | Sublesional |
| [SublingualRoute](ValueSet-v3-SublingualRoute.md) | Sublingual |
| [SubmucosalRoute](ValueSet-v3-SubmucosalRoute.md) | Submucosal |
| [SubscriberCoveredPartyRoleType](ValueSet-v3-SubscriberCoveredPartyRoleType.md) | **Description:**A role recognized through the eligibility of a party to play a subscriber for benefits covered or provided under a health insurance policy. |
| [SubscriberPolicyholder Relationship Codes](ValueSet-subscriber-relationship.md) | This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient). |
| [Subscription Error Codes](ValueSet-subscription-error.md) | Codes to represent subscription error details |
| [SubscriptionChannel Type Codes](ValueSet-subscription-channel-type.md) | Codes to represent subscription error details |
| [SubscriptionStatusAtEvent](ValueSet-subscription-status-at-event.md) | A status code for the state of the Subscription. |
| [SubscriptionTag](ValueSet-subscription-tag.md) | Tags to put on a resource after subscriptions have been sent. |
| [SubsidizedHealthProgram](ValueSet-v3-SubsidizedHealthProgram.md) | **Definition:**A government health program that provides coverage for health services to persons meeting eligibility criteria such as income, location of residence, access to other coverages, health condition, and age, the cost of which is to some extent subsidized by public funds. |
| [Substance Category Codes](ValueSet-substance-category.md) | Substance category codes |
| [SubstanceAdminGenericSubstitution](ValueSet-v3-SubstanceAdminGenericSubstitution.md) | Substitution occurred or is permitted with another product in the same generic ingredient. |
| [SubstanceAdminSubstitutionNotAllowedReason](ValueSet-v3-SubstanceAdminSubstitutionNotAllowedReason.md) | Reasons why substitution of a substance administration request is not permitted. |
| [SubstanceAdminSubstitutionReason](ValueSet-v3-SubstanceAdminSubstitutionReason.md) | ****No description**** |
| [SubstanceAdministrationPermissionRefusalReasonCode](ValueSet-v3-SubstanceAdministrationPermissionRefusalReasonCode.md) | **Definition:**Indicates why the requested authorization to prescribe or dispense a medication has been refused. |
| [SubstitutionCondition](ValueSet-v3-SubstitutionCondition.md) | Identifies what sort of change is permitted or has occurred between the item that was ordered/requested and the one that was/will be provided. |
| [SupernumeraryTooth](ValueSet-v3-SupernumeraryTooth.md) | Supernumerary tooth, any tooth in addition to the normal permanent and primary dentition |
| [Supply Item Type](ValueSet-supplydelivery-type.md) | This value sets refers to a specific supply item. |
| [Supply Type](ValueSet-supplyrequest-kind.md) | This value sets refers to a Category of supply. |
| [SupplyAppropriateManagementCode](ValueSet-v3-SupplyAppropriateManagementCode.md) | Confirmed supply action appropriate |
| [SupplyDetectedIssueCode](ValueSet-v3-SupplyDetectedIssueCode.md) | Supplying the product at this time may be inappropriate or indicate compliance issues with the associated therapy |
| [SupplyOrderAbortReasonCode](ValueSet-v3-SupplyOrderAbortReasonCode.md) | **Definition:**A collection of concepts that indicates why the prescription should no longer be allowed to be dispensed (but can still administer what is already being dispensed). |
| [SupplyRequestReason](ValueSet-supplyrequest-reason.md) | The reason why the supply item was requested. |
| [SuppositoryDrugForm](ValueSet-v3-SuppositoryDrugForm.md) | A solid body of various weights and shapes, adapted for introduction into the rectal, vaginal, or urethral orifice of the human body; they usually melt, soften, or dissolve at body temperature. |
| [SuppositoryRoute](ValueSet-v3-SuppositoryRoute.md) | Suppository |
| [Surface Codes](ValueSet-surface.md) | This value set includes a smattering of FDI tooth surface codes. |
| [SurgClinPracticeSetting](ValueSet-v3-SurgClinPracticeSetting.md) | ****No description**** |
| [SusceptibilityObservationMethodType](ValueSet-v3-SusceptibilityObservationMethodType.md) | **Description:**Test methods designed to determine a microorganism's susceptibility to an antibiotic. |
| [SuspensionDrugForm](ValueSet-v3-SuspensionDrugForm.md) | ****No description**** |
| [SwabDrugForm](ValueSet-v3-SwabDrugForm.md) | A wad of absorbent material usually wound around one end of a small stick and used for applying medication or for removing material from an area. |
| [Swish](ValueSet-v3-Swish.md) | Swish |
| [TableCellHorizontalAlign](ValueSet-v3-TableCellHorizontalAlign.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableCellScope](ValueSet-v3-TableCellScope.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableCellVerticalAlign](ValueSet-v3-TableCellVerticalAlign.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableFrame](ValueSet-v3-TableFrame.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableRuleStyle](ValueSet-v3-TableRuleStyle.md) | (abstract) Defines table cell rendering characteristics |
| [TableRules](ValueSet-v3-TableRules.md) | These values are defined within the XHTML 4.0 Table Model |
| [TabletDrugForm](ValueSet-v3-TabletDrugForm.md) | A solid dosage form containing medicinal substances with or without suitable diluents. |
| [Takelman](ValueSet-v3-Takelman.md) | ****No description**** |
| [Takic](ValueSet-v3-Takic.md) | ****No description**** |
| [Tanana](ValueSet-v3-Tanana.md) | ****No description**** |
| [TananaTutchone](ValueSet-v3-TananaTutchone.md) | ****No description**** |
| [Taracahitan](ValueSet-v3-Taracahitan.md) | ****No description**** |
| [TargetAwareness](ValueSet-v3-TargetAwareness.md) | A code specifying the extent to which the Entity playing the participating Role (usually as a target Participation) is aware of the associated Act.**Examples:**For diagnostic observations, is the patient, family member or other participant aware of his terminal illness?**Discussion:**If the awareness, denial, unconsciousness, etc. is the subject of medical considerations (e.g., part of the problem list), one should use explicit observations in these matters as well, and should not solely rely on this simple attribute in the Participation. |
| [TelecommunicationAddressUse](ValueSet-v3-TelecommunicationAddressUse.md) | ****No description**** |
| [TelecommunicationCapabilities](ValueSet-v3-TelecommunicationCapabilities.md) | **Description:**Concepts that define the telecommunication capabilities of a particular device. Used to identify the expected capabilities to be found at a particular telecommunication address. |
| [Tepiman](ValueSet-v3-Tepiman.md) | ****No description**** |
| [Test script operation code](ValueSet-testscript-operation-codes.md) | This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool. |
| [Test script profile destination type](ValueSet-testscript-profile-destination-types.md) | This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript. |
| [Test script profile origin type](ValueSet-testscript-profile-origin-types.md) | This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the origin within a TestScript. |
| [TextMediaType](ValueSet-v3-TextMediaType.md) | For any text |
| [TherapeuticProductDetectedIssueCode](ValueSet-v3-TherapeuticProductDetectedIssueCode.md) | Proposed therapy may interact with an existing or recent therapeutic product |
| [TherapyAppropriateManagementCode](ValueSet-v3-TherapyAppropriateManagementCode.md) | Confirmed drug therapy appropriate |
| [Time Period Ranges](ValueSet-time-period-ranges.md) | All codes in the Time Period Ranges code system. Note that this value set is typically not expanded because the full set contains millions of codes, the set of all possible ranges of time periods expressible within the grammar. |
| [TimingDetectedIssueCode](ValueSet-v3-TimingDetectedIssueCode.md) | ****No description**** |
| [TimingEvent](ValueSet-v3-TimingEvent.md) | ****No description**** |
| [Title Type](ValueSet-title-type.md) | Used to express the reason and specific aspect for the variant title, such as language and specific language. |
| [Tiwa](ValueSet-v3-Tiwa.md) | ****No description**** |
| [TopicalAbsorptionRoute](ValueSet-v3-TopicalAbsorptionRoute.md) | Topical absorption |
| [TopicalApplication](ValueSet-v3-TopicalApplication.md) | Topical application |
| [TopicalPowder](ValueSet-v3-TopicalPowder.md) | ****No description**** |
| [TopicalSolution](ValueSet-v3-TopicalSolution.md) | ****No description**** |
| [TracheostomyRoute](ValueSet-v3-TracheostomyRoute.md) | Tracheostomy |
| [Transdermal](ValueSet-v3-Transdermal.md) | Transdermal |
| [TransdermalPatch](ValueSet-v3-TransdermalPatch.md) | ****No description**** |
| [Transfer](ValueSet-v3-Transfer.md) | Transfer of ownership for a product. |
| [TransferActReason](ValueSet-v3-TransferActReason.md) | The explanation for why a patient is moved from one location to another within the organization |
| [TransmissionRelationshipTypeCode](ValueSet-v3-TransmissionRelationshipTypeCode.md) | **Description:**A code specifying the meaning and purpose of every TransmissionRelationship instance. Each of its values implies specific constraints to what kinds of Transmission objects can be related and in which way. |
| [TransmucosalRoute](ValueSet-v3-TransmucosalRoute.md) | Transmucosal |
| [TransplacentalRoute](ValueSet-v3-TransplacentalRoute.md) | Transplacental |
| [TranstrachealRoute](ValueSet-v3-TranstrachealRoute.md) | Transtracheal |
| [TranstympanicRoute](ValueSet-v3-TranstympanicRoute.md) | Transtympanic |
| [TribalEntityUS](ValueSet-v3-TribalEntityUS.md) | INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS |
| [TriggerEventID](ValueSet-v3-TriggerEventID.md) | ****No description**** |
| [TrustPolicy](ValueSet-v3-TrustPolicy.md) | A mandate, obligation, requirement, rule, or expectation conveyed as security metadata between senders and receivers required to establish the reliability, authenticity, and trustworthiness of their transactions. Trust security metadata are observation made about aspects of trust applicable to an IT resource (data, information object, service, or system capability). Trust applicable to IT resources is established and maintained in and among security domains, and may be comprised of observations about the domain's trust authority, trust framework, trust policy, trust interaction rules, means for assessing and monitoring adherence to trust policies, mechanisms that enforce trust, and quality and reliability measures of assurance in those mechanisms. [Based on ISO IEC 10181-1 and NIST SP 800-63-2] |
| [Tsamosan](ValueSet-v3-Tsamosan.md) | ****No description**** |
| [Tsimshianic](ValueSet-v3-Tsimshianic.md) | ****No description**** |
| [Types of Edible Substances](ValueSet-edible-substance-type.md) | This value set represents codes for types of edible substances and is provided as a suggestive example. It include codes from[SNOMED CT](http://snomed.info/sct)where concept is-a 762766007 Edible Substance (substance). |
| [UCUM Codes](ValueSet-ucum-units.md) | Unified Code for Units of Measure (UCUM). This value set includes all UCUM codes |
| [UNSPSC](ValueSet-v3-UNSPSC.md) | **Description:**United Nations Standard Products and Services Classification, managed by Uniform Code Council (UCC): www.unspsc.org |
| [UPC](ValueSet-v3-UPC.md) | **Description:**Universal Product Code is one of a wide variety of bar code languages widely used in the United States and Canada for items in stores. |
| [URLScheme](ValueSet-v3-URLScheme.md) | A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet standard RFC 1738 [http://www.ietf.org/rfc/rfc1738.txt]. The URL specifies the protocol and the contact point defined by that protocol for the resource. |
| [USCLS Codes](ValueSet-service-uscls.md) | This value set includes a smattering of USCLS codes. |
| [USEncounterDischargeDisposition](ValueSet-v3-USEncounterDischargeDisposition.md) | These codes cannot be displayed because of AHA's NUBC Patient Discharge Status Codes Intellectual Property (IP) restrictions. To access these codes, see the[National Uniform Billing Committee](http://www.nubc.org/), manual UB-04, UB form locator 17. |
| [USEncounterReferralSource](ValueSet-v3-USEncounterReferralSource.md) | ****No description**** |
| [USPS Two Letter Alphabetic Codes](ValueSet-USPS-State.md) | This value set defines two letter USPS alphabetic codes. |
| [UnderwriterParticipationFunction](ValueSet-v3-UnderwriterParticipationFunction.md) | **Definition:**Set of codes indicating the manner in which underwriters participate in a policy or program. |
| [Unit Type Codes](ValueSet-benefit-unit.md) | This value set includes a smattering of Unit type codes. |
| [UnitsOfMeasureCaseSensitive](ValueSet-v3-UnitsOfMeasureCaseSensitive.md) | **Description:**All units of measure. |
| [Unknown](ValueSet-v3-Unknown.md) | A proper value is applicable, but not known. |
| [UnorderedListStyle](ValueSet-v3-UnorderedListStyle.md) | Defines rendering characteristics for unordered lists |
| [UpdateRefusalReasonCode](ValueSet-v3-UpdateRefusalReasonCode.md) | ****No description**** |
| [UpperChinook](ValueSet-v3-UpperChinook.md) | ****No description**** |
| [UreteralRoute](ValueSet-v3-UreteralRoute.md) | Ureteral |
| [UrethralRoute](ValueSet-v3-UrethralRoute.md) | Urethral |
| [UrinaryBladderIrrigation](ValueSet-v3-UrinaryBladderIrrigation.md) | Irrigation, urinary bladder |
| [UrinaryBladderRoute](ValueSet-v3-UrinaryBladderRoute.md) | Urinary bladder |
| [UrinaryTractRoute](ValueSet-v3-UrinaryTractRoute.md) | Urinary tract |
| [UsageContextType](ValueSet-usage-context-type.md) | A code that specifies a type of context being specified by a usage context. |
| [Utian](ValueSet-v3-Utian.md) | ****No description**** |
| [UtoAztecan](ValueSet-v3-UtoAztecan.md) | ****No description**** |
| [V2 Table 0942 Version Master](ValueSet-v2-0942.md) | Value Set of codes that specify the type of measurement of the state of an automated laboratory instrument. |
| [VaccineEntityType](ValueSet-v3-VaccineEntityType.md) | A Type of medicine that creates an immune protection without the recipient experiencing the disease. |
| [VaccineManufacturer](ValueSet-v3-VaccineManufacturer.md) | The manufacturer of a vaccine. |
| [VaccineType](ValueSet-v3-VaccineType.md) | The kind of vaccine. |
| [VaginalCream](ValueSet-v3-VaginalCream.md) | ****No description**** |
| [VaginalFoam](ValueSet-v3-VaginalFoam.md) | ****No description**** |
| [VaginalGel](ValueSet-v3-VaginalGel.md) | ****No description**** |
| [VaginalOintment](ValueSet-v3-VaginalOintment.md) | ****No description**** |
| [VaginalRoute](ValueSet-v3-VaginalRoute.md) | Vaginal |
| [Validation-process](ValueSet-verificationresult-validation-process.md) | The primary process by which the target is validated |
| [Validation-status](ValueSet-verificationresult-validation-status.md) | Status of the validation of the target against the primary source |
| [Validation-type](ValueSet-verificationresult-validation-type.md) | What the target is validated against |
| [ValidationIssue](ValueSet-v3-ValidationIssue.md) | ****No description**** |
| [VerificationMethod](ValueSet-v3-VerificationMethod.md) | ****No description**** |
| [VerificationOutcomeValue](ValueSet-v3-VerificationOutcomeValue.md) | Values for observations of verification act results**Examples:**Verified, not verified, verified with warning. |
| [VerificationResult Communication Method](ValueSet-verificationresult-communication-method.md) | Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated. |
| [VideoMediaType](ValueSet-v3-VideoMediaType.md) | Video media type. |
| [Virtual Healthcare Delivery Method](ValueSet-virtual-healthcare-delivery-method.md) | This value set defines a set of codes for virtual healthcare service delivery method. |
| [VitreousHumourRoute](ValueSet-v3-VitreousHumourRoute.md) | Vitreous humour |
| [Wakashan](ValueSet-v3-Wakashan.md) | ****No description**** |
| [WeightAlert](ValueSet-v3-WeightAlert.md) | Proposed therapy may be inappropriate based on the patient's weight |
| [WesternApachean](ValueSet-v3-WesternApachean.md) | ****No description**** |
| [WesternMiwok](ValueSet-v3-WesternMiwok.md) | ****No description**** |
| [WesternMuskogean](ValueSet-v3-WesternMuskogean.md) | ****No description**** |
| [WesternNumic](ValueSet-v3-WesternNumic.md) | ****No description**** |
| [Wintuan](ValueSet-v3-Wintuan.md) | ****No description**** |
| [Wiyot](ValueSet-v3-Wiyot.md) | ****No description**** |
| [WorkClassificationODH](ValueSet-v3-WorkClassificationODH.md) | Provide the concepts for the value element of the C-CDA Work Classification Observation entry template. |
| [WorkPlace](ValueSet-v3-WorkPlace.md) | ****No description**** |
| [WorkScheduleODH](ValueSet-v3-WorkScheduleODH.md) | Describes an individual's typical arrangement of working hours for an occupation. |
| [Yaqui](ValueSet-v3-Yaqui.md) | ****No description**** |
| [Yes No Unknown NotApplicable](ValueSet-yes-no-unknown-not-applicable.md) | This valueset contains the set of codes used to respond to any question that can be answered Yes, No, Unknown, or Not Applicable. |
| [Yes No Unknown NotAsked](ValueSet-yes-no-unknown-not-asked.md) | This value set contains 4 concepts commonly used as answers to items in a questionnaire. |
| [Yokuts](ValueSet-v3-Yokuts.md) | ****No description**** |
| [Yokutsan](ValueSet-v3-Yokutsan.md) | ****No description**** |
| [Yukian](ValueSet-v3-Yukian.md) | ****No description**** |
| [Yuman](ValueSet-v3-Yuman.md) | ****No description**** |
| [_0272](ValueSet-v3-tst0272.md) | Testing to measure the minimum concentration of the antibacterial agent in a given culture medium below which bacterial growth is not inhibited. |
| [_0275a](ValueSet-v3-tst0275a.md) | ****No description**** |
| [_0280](ValueSet-v3-tst0280.md) | Test methods designed to determine a microorganismaTMs susceptibility to being killed by an antibiotic. |
| [chromosome-human](ValueSet-chromosome-human.md) | Chromosome number for human. |
| [employmentStatusODH](ValueSet-v3-employmentStatusODH.md) | Concepts representing whether a person does or does not currently have a job or is not currently in the labor pool seeking employment. |
| [hl7VS-ReasonForStudy](ValueSet-v2-0951.md) | Value Set of codes that provide additional information to the universal service identifier on why a test, study or review was ordered. |
| [hl7VS-VS-collectionEvent](ValueSet-v2-0938.md) | Value Set of codes specifying the limit for a collection event or process step. |
| [hl7VS-VS-communicationLocation](ValueSet-v2-0939.md) | Value Set of codes specifying a communication location. |
| [hl7VS-VS-limitationTypeCode](ValueSet-v2-0940.md) | Value Set of codes specifying a type of limitation. |
| [hl7VS-VS-observationSubtype](ValueSet-v2-0937.md) | Value Set of codes specifying an observation sub-type. |
| [hl7VS-VS-observationType](ValueSet-v2-0936.md) | Value Set of codes that specify types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order. |
| [hl7VS-accept-applicationAcknowledgmentConditions](ValueSet-v2-0155.md) | Concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. |
| [hl7VS-accessRestrictionValue](ValueSet-v2-0717.md) | Value Set of codes that specify the information to which access is restricted. Note that the new codes as of November 2018 have been temporarily loaded into the underlying V2 code system pending availability of the currently unavailable new tooling, at which time this value set will be retired and a value set based on the HL7 V3 ActCode code system will be used instead for this table, and the rendered URL will be valid at terminology.hl7.org. |
| [hl7VS-acknowledgmentCode](ValueSet-v2-0008.md) | Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see message processing rules in the published Standard. |
| [hl7VS-actionCode](ValueSet-v2-0065.md) | Concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). |
| [hl7VS-actionCode](ValueSet-v2-0287.md) | Concepts used in Patient Care for the intent of a problem or goal. Used in Version 2 messaging in the GOL segment. |
| [hl7VS-actionCode](ValueSet-v2-0323.md) | Status codes of record operations. |
| [hl7VS-actionTakenInResponseToTheEvent](ValueSet-v2-0251.md) | Value Set of codes that define the action taken as a result of an event related to a product issue. |
| [hl7VS-active-inactive](ValueSet-v2-0183.md) | Value Set of codes that specify whether a person is currently a valid staff member. |
| [hl7VS-actpriority](ValueSet-v2-0906.md) | Value Set of codes specifying the priority for a shipment. |
| [hl7VS-additivePreservative](ValueSet-v2-0371.md) | Concepts specifying any additive introduced to the specimen before or at the time of collection. These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-addressExpirationReason](ValueSet-v2-0616.md) | Value Set of codes that specify the reason this address was marked as "ended". |
| [hl7VS-addressType](ValueSet-v2-0190.md) | Concepts specifying types or kinds of addresses. |
| [hl7VS-addressUsage](ValueSet-v2-0617.md) | Value Set of codes that specify how an address is intended to be used. |
| [hl7VS-adjustmentAction](ValueSet-v2-0569.md) | Value Set of codes used to specify the action requested of a party that receives an adjustment. |
| [hl7VS-adjustmentCategoryCode](ValueSet-v2-0564.md) | Value Set of codes used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason. |
| [hl7VS-administrationDevice](ValueSet-v2-0164.md) | Value Set of codes that specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. |
| [hl7VS-administrationMethod](ValueSet-v2-0165.md) | Value Set of codes that specify the specific method requested for the administration of the drug or treatment to the patient. |
| [hl7VS-administrativeSex](ValueSet-v2-0001.md) | Concepts specifying a patient's sex for administrative purposes. |
| [hl7VS-administriveSite](ValueSet-v2-0163.md) | Concepts that specify a body site from which a specimen is obtained. |
| [hl7VS-admissionLevelOfCareCode](ValueSet-v2-0432.md) | Value Set of codes specifying the acuity level assigned to the patient at the time of admission. |
| [hl7VS-admissionType](ValueSet-v2-0007.md) | Value Set of codes that specify the circumstances under which the patient was or will be admitted. |
| [hl7VS-advanceDirectiveCode](ValueSet-v2-0435.md) | Value Set of codes specifying the patient's instructions to the healthcare facility. |
| [hl7VS-advancedBeneficiaryNoticeCode](ValueSet-v2-0339.md) | Status codes specifying a patient's or a patient's representative's consent for responsibility to pay for potentially uninsured services. Note that this set of codes is generally used in the US only. |
| [hl7VS-alertDeviceCode](ValueSet-v2-0437.md) | Value Set of codes specifying any type of allergy alert device the patient may be carrying or wearing. |
| [hl7VS-alertLevel](ValueSet-v2-0367.md) | Value Set of codes that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event). |
| [hl7VS-allergyClinicalStatus](ValueSet-v2-0438.md) | Value Set of codes specifying the verification status for the allergy. |
| [hl7VS-allergySeverity](ValueSet-v2-0128.md) | Value Set of codes that specify the general severity of an allergy. |
| [hl7VS-allergyType](ValueSet-v2-0127.md) | Value Set of codes that specify classification of general allergy categories (drug, food, pollen, etc.). |
| [hl7VS-allowSubstitution](ValueSet-v2-0161.md) | Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitutions allowed. |
| [hl7VS-allowSubstitutionCodes](ValueSet-v2-0279.md) | Value Set of codes that indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. |
| [hl7VS-alternateCharacterSetHandlingScheme](ValueSet-v2-0356.md) | Concepts that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. |
| [hl7VS-alternateCharacterSets](ValueSet-v2-0211.md) | Value Set of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte. |
| [hl7VS-ambulatoryPaymentClassificationCode](ValueSet-v2-0466.md) | Value Set of codes that specify the derived Ambulatory Payment Classification (APC) code. |
| [hl7VS-ambulatoryStatus](ValueSet-v2-0009.md) | Value Set of codes that specify permanent or transient handicapped conditions of a person. |
| [hl7VS-amountClass](ValueSet-v2-0193.md) | Value Set of codes that specify the amount quantity class. |
| [hl7VS-amountType](ValueSet-v2-0146.md) | Value Set of codes that specify amount quantity type. |
| [hl7VS-analyteRepeatStatus](ValueSet-v2-0389.md) | Value Set of codes identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex). The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of r |
| [hl7VS-annotations](ValueSet-v2-0317.md) | Value Set of codes that specify the coded entry associated with a given point in time during the waveform recording. Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value. |
| [hl7VS-applicationChangeType](ValueSet-v2-0409.md) | Value Set of codes that specify a type of change being requested (if NMR query) or announced (if NMD unsolicited update). |
| [hl7VS-appointmentReasonCodes](ValueSet-v2-0276.md) | Value Set of codes that describe the kind of appointment or the reason why an appointment has been scheduled. |
| [hl7VS-appointmentTypeCodes](ValueSet-v2-0277.md) | Value Set of codes that an appointment request to describe the kind of appointment. |
| [hl7VS-approvingRegulatoryAgency](ValueSet-v2-0790.md) | Value Set of codes that specify the regulatory agency by which the item has been approved, such as the FDA or AMA. |
| [hl7VS-armStick](ValueSet-v2-0927.md) | Value Set of codes specifying the arm(s) receiving a stick. |
| [hl7VS-artificialBlood](ValueSet-v2-0375.md) | Value Set of codes that identify the artificial blood identifier associated with the specimen. |
| [hl7VS-assignmentOfBenefits](ValueSet-v2-0135.md) | Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider. If so, the insurance will pay the provider directly. |
| [hl7VS-authorizationMode](ValueSet-v2-0483.md) | Concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order. Used in Version 2 messaging for orders in the ORC segment. |
| [hl7VS-auto-DilutionType](ValueSet-v2-0945.md) | Value Set of codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration. |
| [hl7VS-bedStatus](ValueSet-v2-0116.md) | Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. |
| [hl7VS-benefitGroup](ValueSet-v2-0556.md) | Value Set of codes that specify the benefit group. |
| [hl7VS-bloodProductCode](ValueSet-v2-0426.md) | Value Set of codes specifying the blood product code. |
| [hl7VS-bloodProductDispenseStatus](ValueSet-v2-0510.md) | Value Set of codes that specify the current status of the specified blood product as indicated by the filler or placer. For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it fir |
| [hl7VS-bloodProductProcessingRequirements](ValueSet-v2-0508.md) | Value Set of codes that specify additional information about the blood component class associated with the Universal Service ID. The placer of the order can specify any required processing of the blood product that must be completed prior to t |
| [hl7VS-bloodProductTransfusion-dispositionStatus](ValueSet-v2-0513.md) | Value Set of codes that specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood co |
| [hl7VS-bloodUnitType](ValueSet-v2-0566.md) | Value Set of codes used to specify the type of blood unit |
| [hl7VS-bodyParts](ValueSet-v2-0550.md) | Value Set of codes that specify the part of the body. |
| [hl7VS-bodySiteModifier](ValueSet-v2-0495.md) | Value Set of codes that specify the modifier for the body site. |
| [hl7VS-bolusType](ValueSet-v2-0917.md) | Value Set of codes specifying a type of bolus. |
| [hl7VS-bpObservationStatusCodesInterpretation](ValueSet-v2-0511.md) | Value Set of codes that specify the interpretation for the blood product observation status codes. A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first c |
| [hl7VS-calendarAlignment](ValueSet-v2-0527.md) | Value Set of codes that specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from "the 5th of every month"). |
| [hl7VS-caseCategoryCode](ValueSet-v2-0423.md) | Value Set of codes specifying the reason a non-urgent patient presents to the emergency room for treatment instead of a clinic or physican office. |
| [hl7VS-causalityObservations](ValueSet-v2-0252.md) | Value Set of codes that record event observations regarding what may have caused a product related event. |
| [hl7VS-cclValue](ValueSet-v2-0728.md) | Value Set of codes that specify the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis. |
| [hl7VS-certificateStatus](ValueSet-v2-0536.md) | Value Set of codes that specify the status of the certificate held by a health professional. |
| [hl7VS-certificationCategoryCode](ValueSet-v2-0922.md) | Value Set of codes specifying the code for a certification category. |
| [hl7VS-certificationStatus](ValueSet-v2-0337.md) | Value Set of codes that specify the status of the practitioner's speciality certification. |
| [hl7VS-certificationTypeCode](ValueSet-v2-0921.md) | Value Set of codes specifying the code for a certification type. |
| [hl7VS-chargeOnIndicator](ValueSet-v2-0269.md) | Value Set of codes that define the event upon which a charge should be generated. |
| [hl7VS-chargeType](ValueSet-v2-0122.md) | Value Set of codes that specify someone or something other than the patient to be billed for a service. |
| [hl7VS-chargeTypeReason](ValueSet-v2-0475.md) | Value Set of codes that specify the choice of, and providing the clinical rationale for, a selected charge type. |
| [hl7VS-checkDigitScheme](ValueSet-v2-0061.md) | Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes. |
| [hl7VS-codingSystem](ValueSet-v2-0396.md) | Names of coding systems. Each coding system is assigned a unique identifier, which is generally a short mnemonic derived from the full name of the coding system. |
| [hl7VS-commandResponse](ValueSet-v2-0387.md) | Value Set of codes identifying the response of the previously issued command. |
| [hl7VS-commentType](ValueSet-v2-0364.md) | Value Set of codes that identify the type of comment text being sent in the specific comment record. |
| [hl7VS-completionStatus](ValueSet-v2-0322.md) | Status codes used in the workflow of treatment administration events. |
| [hl7VS-computationType](ValueSet-v2-0523.md) | Value Set of codes that specify if the change is computed as a percent change or as an absolute change. |
| [hl7VS-confidentiality](ValueSet-v2-0907.md) | Value Set of codes specifying the confidentiality for a shipment. |
| [hl7VS-confidentialityCode](ValueSet-v2-0177.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to the observation. |
| [hl7VS-consentBypassReason](ValueSet-v2-0499.md) | Value Set of codes that specify the reason the subject's consent was not sought. |
| [hl7VS-consentDisclosureLevel](ValueSet-v2-0500.md) | Value Set of codes that specify how much information was disclosed to the subject as part of the informed consent process. |
| [hl7VS-consentMode](ValueSet-v2-0497.md) | Value Set of codes that specify the method in which a subject provides consent. |
| [hl7VS-consentNon-disclosureReason](ValueSet-v2-0501.md) | Value Set of codes that specify a reason the subject did not receive full disclosure. |
| [hl7VS-consentStatus](ValueSet-v2-0498.md) | Value Set of codes that specify whether the consent has been sought and granted. |
| [hl7VS-consentType](ValueSet-v2-0496.md) | Value Set of codes that specify to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event. |
| [hl7VS-contactRole2](ValueSet-v2-0131.md) | Concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Built on the updated code system. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. |
| [hl7VS-containerCondition](ValueSet-v2-0544.md) | Value Set of codes that specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container |
| [hl7VS-containerStatus](ValueSet-v2-0370.md) | Value Set of codes that identify the status of the unique container in which the specimen resides at the time the transaction was initiated. |
| [hl7VS-continuationStyleCode](ValueSet-v2-0398.md) | Value Set of codes identifying whether it is a fragmented message or part of an interactive continuation message. |
| [hl7VS-controlledSubstanceSchedule](ValueSet-v2-0477.md) | Value Set of codes that specify the class of the drug or other substance if its usage is controlled by legislation. |
| [hl7VS-coordinationOfBenefits](ValueSet-v2-0173.md) | Value Set of codes that specify whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. |
| [hl7VS-countryCode-3alpha](ValueSet-v2-notAllCodes-0399.md) | Value Set of codes that identifies a country of origin for a message. It will be used primarily to specify default elements, such as currency denominations. The values to be used are those of ISO 3166. The ISO 3166 table has three separate forms for the codes for each country, this value set includes only the 3-character alpha form. |
| [hl7VS-coverageType](ValueSet-v2-0309.md) | Note that this set of codes is used generally in the US only. |
| [hl7VS-cumulativeDosageLimitUom](ValueSet-v2-0924.md) | Value Set of codes specifying the unit of measure (UoM) for the cumulative dosage limit. |
| [hl7VS-cweStatuses](ValueSet-v2-0353.md) | Concepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [hl7VS-cycleType](ValueSet-v2-0702.md) | Value Set of codes that specify the type of cycle that is being executed. A cycle type is a specific sterilization method used for a specific type of supply item. |
| [hl7VS-cyclicEntryExitIndicator](ValueSet-v2-0505.md) | Value Set of codes that specify if this service request is the first or last service request in a cyclic series of service requests. |
| [hl7VS-dataTypes](ValueSet-v2-0440.md) | Value Set of codes specifying the data type. |
| [hl7VS-date-timeSelectionQualifier](ValueSet-v2-0158.md) | Value Set of codes that allow the specification of certain types of values within the date/time range. |
| [hl7VS-dateFormat](ValueSet-v2-0653.md) | Value Set of codes that specify the date format for a decontamination/sterilization instance. |
| [hl7VS-dayType](ValueSet-v2-0149.md) | Value Set of codes that specify whether the days are denied, pending or approved. |
| [hl7VS-daysOfTheWeek](ValueSet-v2-0267.md) | Value Set of codes that identify the day(s) of the week when a location may be scheduled for appointments. |
| [hl7VS-deferredResponseType](ValueSet-v2-0107.md) | Value Set of codes which specify which type of deferred query resonse is desired, as specified with the query parameters. |
| [hl7VS-degreeLicenseCertificate](ValueSet-v2-0360.md) | Concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [hl7VS-delayedAcknowledgmentType](ValueSet-v2-0102.md) | Concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging. |
| [hl7VS-derivedSpecimen](ValueSet-v2-0170.md) | Value Set of codes that specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The pro |
| [hl7VS-deviceDataState](ValueSet-v2-0667.md) | Value Set of codes that specify the state of the data as provided from a device. |
| [hl7VS-deviceStatus](ValueSet-v2-0682.md) | Value Set of codes that specify the state of a device. |
| [hl7VS-deviceType](ValueSet-v2-0657.md) | Value Set of codes that specify the kind of device as defined by the manufacturer. |
| [hl7VS-diagnosisClassification](ValueSet-v2-0228.md) | Value Set of codes that classify whether a patient visit can be related to a diagnosis. |
| [hl7VS-diagnosisPriority](ValueSet-v2-0359.md) | Concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in Version 2 messaging. |
| [hl7VS-diagnosisType](ValueSet-v2-0052.md) | Concepts specifying a type of diagnosis being sent in HL7 Version 2.x messages. |
| [hl7VS-diagnosticServiceSectionId](ValueSet-v2-0074.md) | Concepts which specify a section of a diagnostic service where the observation may be performed. |
| [hl7VS-dietType](ValueSet-v2-0159.md) | Value Set of codes that specify the type of diet. |
| [hl7VS-disabledPerson](ValueSet-v2-0334.md) | Value Set of codes that specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. |
| [hl7VS-dispenseMethod](ValueSet-v2-0321.md) | Value Set of codes that specify the method by which treatment is dispensed. |
| [hl7VS-dispenseType](ValueSet-v2-0484.md) | Value Set of codes that specify the type of dispensing event that occurred. |
| [hl7VS-documentAvailabilityStatus](ValueSet-v2-0273.md) | Value Set of codes that define whether a patient document is appropriate or available for use in patient care. |
| [hl7VS-documentCompletionStatus](ValueSet-v2-0271.md) | Value Set of codes that record the state of a document in a workflow. |
| [hl7VS-documentConfidentialityStatus](ValueSet-v2-0272.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to information. The assignment of data elements to these categories is left to the discretion of the healthcare organization. |
| [hl7VS-documentStorageStatus](ValueSet-v2-0275.md) | Value Set of codes that describe the availability of a document in relation to the type of storage. |
| [hl7VS-donationDurationUnits](ValueSet-v2-0932.md) | Value Set of codes specifying the units of donation duration. |
| [hl7VS-drgDiagnosisDeterminationStatus](ValueSet-v2-0731.md) | Value Set of codes that specify the status of a diagnosis for a diagnosis related group (DRG) determination. |
| [hl7VS-drgGroupingStatus](ValueSet-v2-0749.md) | Value Set of codes that specify the status of the use of the gender information for diagnosis related group (DRG) determination. |
| [hl7VS-drgProcedureDeterminationStatus](ValueSet-v2-0761.md) | Value Set of codes that specify the status of the use of this particular procedure for the diagnosis related group (DRG) determination. |
| [hl7VS-drgProcedureRelevance](ValueSet-v2-0763.md) | Value Set of codes that specify the relevance of this particular procedure for the diagnosis related group (DRG) determination. |
| [hl7VS-drgStatusFinancialCalculation](ValueSet-v2-0742.md) | Value Set of codes that specify the status of the diagnosis related group (DRG) calculation regarding the financial aspects. |
| [hl7VS-drgTransferType](ValueSet-v2-0415.md) | Value Set of codes that specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG's), for example, exempt or non-exempt. |
| [hl7VS-durationCategories](ValueSet-v2-0255.md) | Value Set of codes that classify an observation definition as intended to measure a patient's state at a point in time. |
| [hl7VS-eligibilitySource](ValueSet-v2-0144.md) | Value Set of codes that specify the source of information about the insured's eligibility for benefits. |
| [hl7VS-employmentStatus](ValueSet-v2-0066.md) | Value Set of codes that specify the guarantor's employment status. |
| [hl7VS-encoding](ValueSet-v2-0299.md) | Concept identifying the type of IETF encoding used to represent successive octets of binary data as displayable ASCII characters. |
| [hl7VS-equipmentState](ValueSet-v2-0365.md) | Value Set of codes that identify the status the equipment was in at the time the transaction was initiated. |
| [hl7VS-errorSeverity](ValueSet-v2-0516.md) | Concepts documenting the severity of an application error as reported during acknowledgment of messages. |
| [hl7VS-escortRequired](ValueSet-v2-0225.md) | Value Set of codes indicating whether a patient must be accompanied while travelling to a diagnostic service department. |
| [hl7VS-ethnicGroup](ValueSet-v2-0189.md) | Concepts further defining a patient's ancestry. In the US, a current use is to use these codes to report ethnicity in line with US federal standards for Hispanic origin. Used for HL7 Version 2 messaging in the PID segment. |
| [hl7VS-eventCode](ValueSet-v2-0003.md) | Concepts specifying the trigger event for Version 2.x interface messages. |
| [hl7VS-eventConsequence](ValueSet-v2-0240.md) | Value Set of codes that describe the impact of an event on a patient. |
| [hl7VS-eventExpected](ValueSet-v2-0239.md) | Value Set of codes that communicate whether an event has been judged to be expected or unexpected. |
| [hl7VS-eventQualification](ValueSet-v2-0237.md) | Value Set of codes that qualify an event related to a product experience. |
| [hl7VS-eventReason](ValueSet-v2-0062.md) | Value Set of codes that specify the reason for an event. |
| [hl7VS-eventRelatedPeriod](ValueSet-v2-0528.md) | Value Set of codes that specify a common (periodical) activity of daily living. |
| [hl7VS-eventReportedTo](ValueSet-v2-0236.md) | Value Set of codes that identify the type of entity to which the event has been reported. |
| [hl7VS-eventSeriousness](ValueSet-v2-0238.md) | Value Set of codes that a sender to designate an event as serious or significant. |
| [hl7VS-eventType](ValueSet-v2-0450.md) | Value Set of codes specifying the type of event of the message. |
| [hl7VS-exclusiveTest](ValueSet-v2-0919.md) | Concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances. |
| [hl7VS-expandedYes-NoIndicator](ValueSet-v2-0532.md) | Value Set of codes that specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". |
| [hl7VS-extendedPriorityCodes](ValueSet-v2-0485.md) | Concepts describing the urgency of a request carried in an order. Used in Version 2 messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn). Many of the codes are widely recognized values used in healthcare settings in the english-speaking world. |
| [hl7VS-facilityType](ValueSet-v2-0331.md) | Value Set of codes that specify the type of facility. |
| [hl7VS-file-levelEventCode](ValueSet-v2-0178.md) | Concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [hl7VS-fillerStatusCodes](ValueSet-v2-0278.md) | Value Set of codes that describe an appointment status from the perspective of the entity assigned to fulfill the appointment. |
| [hl7VS-formularyStatus](ValueSet-v2-0473.md) | Value Set of codes that specify whether or not the service (pharmaceutical) is in the formulary. |
| [hl7VS-formularyStatus](ValueSet-v2-0478.md) | Value Set of codes that specify whether or not the pharmaceutical substance is part of the local formulary. |
| [hl7VS-gestationCategoryCode](ValueSet-v2-0424.md) | Value Set of codes specifying the status of the birth in relation to the gestation |
| [hl7VS-governmentReimbursementProgram](ValueSet-v2-0401.md) | Value Set of codes that specify codes that indicate an agency that the practitioner is authorized to bill for medical services. Existing codes only for use in the United States. |
| [hl7VS-grouperStatus](ValueSet-v2-0734.md) | Value Set of codes that specify the status of a grouper in general. |
| [hl7VS-hospitalService](ValueSet-v2-0069.md) | Value Set of codes that specify the treatment or type of surgery the patient is scheduled to receive. |
| [hl7VS-identifierType](ValueSet-v2-0203.md) | Concepts specifying types of identififiers, as used in person and organization identification datatypes in HL7 Version 2 standards. |
| [hl7VS-identityMayBeDivulged](ValueSet-v2-0243.md) | Value Set of codes that define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. |
| [hl7VS-identityReliabilityCode](ValueSet-v2-0445.md) | Value Set of codes that specify the reliability of patient/person identifying data transmitted via a transaction. |
| [hl7VS-immunizationRegistryStatus](ValueSet-v2-0441.md) | Immunization registry status codes of a patient. Used in Version 2 messaging in the PD1 segment. |
| [hl7VS-inactiveReasonCode](ValueSet-v2-0540.md) | Value Set of codes that specify the reason the staff member is inactive. |
| [hl7VS-incidentTypeCode](ValueSet-v2-0428.md) | Value Set of codes specifying a classification of the incident type. |
| [hl7VS-indirectExposureMechanism](ValueSet-v2-0253.md) | Value Set of codes that identify the mechanism of product transmission when the product has not been directly applied to the patient. |
| [hl7VS-informPersonCode](ValueSet-v2-0517.md) | Value Set of codes that specify who (if anyone) shouldor should not be informed of an error. |
| [hl7VS-institutionRelationshipType](ValueSet-v2-0538.md) | Value Set of codes that specify the relationship the staff person has with the institution for whom he/she provides services. |
| [hl7VS-insuranceCompanyContactReason](ValueSet-v2-0232.md) | Value Set of codes that describe why an insurance company has been contacted. |
| [hl7VS-intendedProcedureType](ValueSet-v2-0933.md) | Value Set of codes specifying the type of intended procedure. |
| [hl7VS-invoiceControlCode](ValueSet-v2-0553.md) | Value Set of codes that specify what invoice action is being performed by this message. |
| [hl7VS-invoiceProcessingResultsStatus](ValueSet-v2-0571.md) | Value Set of codes used to specify the processing status for an Invoice Processing Result. |
| [hl7VS-invoiceReasonCodes](ValueSet-v2-0554.md) | Value Set of codes that specify the reason for an invoice. |
| [hl7VS-invoiceType](ValueSet-v2-0555.md) | Value Set of codes that specify the type of invoice. |
| [hl7VS-itemImportanceCodes](ValueSet-v2-0634.md) | Value Set of codes that denote a level or importance of an inventory item within the context of an inventory location. |
| [hl7VS-itemStatus](ValueSet-v2-0776.md) | Value Set of codes that specify the status (useful for reporting and item usage purposes) that applies to an item. |
| [hl7VS-itemStatusCodes](ValueSet-v2-0625.md) | Value Set of codes that specify the state of an inventory item within the context of an inventory location. |
| [hl7VS-itemType](ValueSet-v2-0778.md) | Value Set of codes that specify a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures. |
| [hl7VS-jobStatus](ValueSet-v2-0311.md) | Value Set of codes that specify a next of kin/associated party's job status. |
| [hl7VS-jurisdictionalBreadth](ValueSet-v2-0547.md) | Value Set of codes that specify the breadth/extent of the jurisdiction where the qualification is valid. |
| [hl7VS-kindOfQuantity](ValueSet-v2-0254.md) | Value Set of codes that describe the underlying kind of property represented by an observation. The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so |
| [hl7VS-laborCalculationType](ValueSet-v2-0651.md) | Value Set of codes that specify the method used to calculate employee labor and measure employee productivity. |
| [hl7VS-languageAbility](ValueSet-v2-0403.md) | Value Set of codes that specify codes that indicate the ability that a Staff Member possesses with respect to the language. |
| [hl7VS-languageProficiency](ValueSet-v2-0404.md) | Value Set of codes which specify the level of knowledge a person possesses with respect to a language ability identified. |
| [hl7VS-levelOfCare](ValueSet-v2-0263.md) | Value Set of codes that identify the level of care a patient may be afforded when assigned to this location definition. |
| [hl7VS-livingArrangement](ValueSet-v2-0220.md) | Concepts characterizing the situation that patient-associated parties live in at their residential address. |
| [hl7VS-livingDependency](ValueSet-v2-0223.md) | Value Set of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs. |
| [hl7VS-livingWill](ValueSet-v2-0315.md) | Value Set of codes that specify whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the |
| [hl7VS-loadStatus](ValueSet-v2-0669.md) | Value Set of codes that specify the status of the information provided in a device sterilization or decontamination cycle. |
| [hl7VS-local-remoteControlState](ValueSet-v2-0366.md) | Value Set of codes that identify the current state of control associated with the equipment. Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state) |
| [hl7VS-locationCharacteristicId](ValueSet-v2-0324.md) | Value Set of codes that specify an identifier code to show which characteristic is being communicated with the segment. |
| [hl7VS-locationEquipment](ValueSet-v2-0261.md) | Value Set of codes that identify the equipment available in a location definition identified as a room or bed. |
| [hl7VS-locationRelationshipId](ValueSet-v2-0325.md) | Value Set of codes that specify an identifier code to show which relationship is being communicated with the segment. |
| [hl7VS-locationServiceCode](ValueSet-v2-0442.md) | Value Set of codes specifying the types of services provided by the location. |
| [hl7VS-lotControl](ValueSet-v2-0659.md) | Value Set of codes that specify whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department. |
| [hl7VS-mailClaimParty](ValueSet-v2-0137.md) | Value Set of codes that specify a party to which a claim should be mailed when claims are sent by mail. |
| [hl7VS-maritalStatus](ValueSet-v2-0002.md) | Value Set of codes that specify a person's marital (civil/legal) status. |
| [hl7VS-marketingBasis](ValueSet-v2-0330.md) | Value Set of codes that specify the basis for marketing approval. |
| [hl7VS-masterFileIdentifierCode](ValueSet-v2-0175.md) | Concepts which are represented by codes identifying HL7Versions 2.x Master Files. |
| [hl7VS-masterfileActionCode](ValueSet-v2-0180.md) | Concepts specifying an action for a master file record. Used in HL7 V2.x messaging in the MFE segment. |
| [hl7VS-matchAlgorithms](ValueSet-v2-0393.md) | Value Set of codes identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer. |
| [hl7VS-matchReason](ValueSet-v2-0392.md) | Value Set of codes identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels. It |
| [hl7VS-medicalRoleExecutingPhysician](ValueSet-v2-0882.md) | Value Set of codes specifying the role of the physician ("self-employed" or "employed"). |
| [hl7VS-messageErrorConditionCodes](ValueSet-v2-0357.md) | HL7 (communications) error codes, as transmitted in a message acknowledgement. |
| [hl7VS-messageStructure](ValueSet-v2-0354.md) | HL7 abstract message structure codes. |
| [hl7VS-messageType](ValueSet-v2-0076.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [hl7VS-messageWaitingPriority](ValueSet-v2-0520.md) | Value Set of codes that specify how important the most important waiting mesasge is. For example, if there are 3 low priority messages, 1 medium priority message and 1 high priority message, the message waiting priority would be "high", because |
| [hl7VS-mfnRecode-levelErrorReturn](ValueSet-v2-0181.md) | Concepts which code status values for requested master file record update operations. |
| [hl7VS-militaryService](ValueSet-v2-0140.md) | Value Set of codes that specify the military branch. This field is defined by CMS or other regulatory agencies. |
| [hl7VS-militaryStatus](ValueSet-v2-0142.md) | Value Set of codes that specify the military status of the patient. This field is defined by CMS or other regulatory agencies. |
| [hl7VS-mimeBase64EncodingCharacters](ValueSet-v2-0290.md) | Value Set of codes that are used for base64 MIME encoding. Base64 is defined as follows (adapted from MIME Internet standard RFC 1521). |
| [hl7VS-mimeTypes](ValueSet-v2-notAllCodes-0834.md) | Value Set of codes specifying the general type of data. |
| [hl7VS-modeOfArrivalCode](ValueSet-v2-0430.md) | Value Set of codes specifying how the patient was brought to the healthcare facility. |
| [hl7VS-modifyIndicator](ValueSet-v2-0395.md) | Value Set of codes identifying whether the subscription is new or is being modified. |
| [hl7VS-moodCodes](ValueSet-v2-0725.md) | Value Set of codes that specify the functional state of an order. |
| [hl7VS-name-addressRepresentation](ValueSet-v2-0465.md) | Value Set of codes that specify an indication of the representation provided by the data item. |
| [hl7VS-name-addressRepresentation](ValueSet-v2-4000.md) | Value Set of codes that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data. It is used to provides hints for a receiver, so it can make choic |
| [hl7VS-nameAssemblyOrder](ValueSet-v2-0444.md) | Value Set of codes specifying the preferred display order of the components of this person name. |
| [hl7VS-nameType](ValueSet-v2-0200.md) | Concepts for types of names for persons. |
| [hl7VS-natureOfAbnormalTesting](ValueSet-v2-0080.md) | Value Set of codes that specify the nature of an abnormal test. |
| [hl7VS-natureOfChallenge](ValueSet-v2-0257.md) | Value Set of codes that further describe an observation definition that is characterized as a challenge observation. |
| [hl7VS-natureOfServiceTestObservation](ValueSet-v2-0174.md) | Concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. |
| [hl7VS-networkSourceType](ValueSet-v2-0332.md) | Value Set of codes that indicate (in certain systems) whether a lower level source identifier is an initiate or accept type. |
| [hl7VS-newbornCode](ValueSet-v2-0425.md) | Value Set of codes specifying whether the baby was born in or out of the facility. |
| [hl7VS-non-subjectConsenterReason](ValueSet-v2-0502.md) | Value Set of codes that specify a reason consent was granted by a person other than the subject of the consent. |
| [hl7VS-notifyClergyCode](ValueSet-v2-0534.md) | Value Set of codes that specify whether the clergy should be notified. |
| [hl7VS-observationResultHandling](ValueSet-v2-0507.md) | Concepts regarding the handling of a result. |
| [hl7VS-observationResultStatus](ValueSet-v2-0085.md) | Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. |
| [hl7VS-occurrenceCode](ValueSet-v2-0350.md) | Concepts drawn from the National Uniform Billing Committee (NUBC) code for the event or occurrence relating to a bill that may affect payer processing. Used in Version 2 messaging in the Occurrence Code and Date (OCD) value. |
| [hl7VS-occurrenceSpan](ValueSet-v2-0351.md) | Concepts drawn from the National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim. Used in Version 2 messaging in the Occurrence Span Code and Date (OSP) value. |
| [hl7VS-onlineVerificationResult](ValueSet-v2-0970.md) | Code values used to indicate the result of an online verification of insurance data. |
| [hl7VS-onlineVerificationResultErrorCodes](ValueSet-v2-0971.md) | V2 Table 0971 Version Master (Online Verification Result Error Code) |
| [hl7VS-orderControl](ValueSet-v2-0119.md) | Concepts which are used to determine the function of the order segment. Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service. |
| [hl7VS-orderControlCodeReason](ValueSet-v2-0949.md) | Value Set of codes that describe reasons for the chosen order control codes. |
| [hl7VS-orderStatus](ValueSet-v2-0038.md) | Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is as |
| [hl7VS-orderStatusModifier](ValueSet-v2-0950.md) | Value Set of codes that further define an identified status. |
| [hl7VS-orderType](ValueSet-v2-0482.md) | Value Set of codes that specify whether the order is to be executed in an inpatient setting or an outpatient setting. |
| [hl7VS-organDonor](ValueSet-v2-0316.md) | Value Set of codes that specify whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. |
| [hl7VS-organization-Agency-Department](ValueSet-v2-0530.md) | Value Set of codes that specify the agency or department that assigned a specified identifier. |
| [hl7VS-organizationUnitType](ValueSet-v2-0406.md) | Value Set of codes that specify the environment in which the provider acts in the role associated with the provider type, and inludes codes for venues outside of formal organized healthcare settings, such as Home. The provider environment is no |
| [hl7VS-organizationUnitType-Org](ValueSet-v2-0474.md) | Value Set of codes that specify the classification of the organization unit. |
| [hl7VS-organizationalNameType](ValueSet-v2-0204.md) | Concepts used to specify the type of name for an organization i.e., legal name, display name. |
| [hl7VS-otherEnvironmentalFactors](ValueSet-v2-0377.md) | Value Set of codes that identify the other environmental factors associated with the specimen in a specific container, e.g., atmospheric exposure. |
| [hl7VS-outlierType](ValueSet-v2-0083.md) | Value Set of codes that specify the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid. |
| [hl7VS-overallClaimDispositionCode](ValueSet-v2-0457.md) | Value Set of codes specifying the final status of the claim. |
| [hl7VS-override](ValueSet-v2-0268.md) | Value Set of codes that define whether a Charge Description Master description may be overridden or if it must be overridden. |
| [hl7VS-overrideType](ValueSet-v2-0518.md) | Value Set of codes that specify what type of override can be used to override the specific error identified. |
| [hl7VS-package](ValueSet-v2-0818.md) | Value Set of codes specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment. |
| [hl7VS-packagingStatusCode](ValueSet-v2-0469.md) | Value Set of codes that specify the packaging status of the service. |
| [hl7VS-participation](ValueSet-v2-0912.md) | Concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.) |
| [hl7VS-patientClass](ValueSet-v2-0004.md) | Concepts used by systems to categorize patients by sites. |
| [hl7VS-patientConditionCode](ValueSet-v2-0434.md) | Value Set of codes specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc. |
| [hl7VS-patientLocationType](ValueSet-v2-0260.md) | Value Set of codes that identify the kind of location described in the location definition. |
| [hl7VS-patientOutcome](ValueSet-v2-0241.md) | Value Set of codes that describe the overall state of a patient as a result of patient care. |
| [hl7VS-patientResultsReleaseCategorizationScheme](ValueSet-v2-0909.md) | Value Set of codes specifying the scheme for the patient results release categorization. |
| [hl7VS-patientStatusCode](ValueSet-v2-0216.md) | Value Set of codes that define the state of a care episode for a patient. |
| [hl7VS-patient’sRelationshipToInsured](ValueSet-v2-0344.md) | Value Set of codes that specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. |
| [hl7VS-payeeRelationshipToInvoice](ValueSet-v2-0558.md) | Value Set of codes used to specify the relationship to the invoice for Person Payee Types. |
| [hl7VS-payeeType](ValueSet-v2-0557.md) | Value Set of codes that specify the type of payee (e.g., organization, person). |
| [hl7VS-paymentAdjustmentCode](ValueSet-v2-0468.md) | Value Set of codes that specify any payment adjustment due to drugs or medical devices. |
| [hl7VS-paymentMethodCode](ValueSet-v2-0570.md) | Value Set of codes used to specify the method for the movement of payment. |
| [hl7VS-pcaType](ValueSet-v2-0918.md) | Value Set of codes specifying a type of PCA. |
| [hl7VS-penaltyType](ValueSet-v2-0148.md) | Value Set of codes that specify whether the amount is currency or a percentage. |
| [hl7VS-personLocationType](ValueSet-v2-0305.md) | Value Set of codes that specify the categorization of the person's location. |
| [hl7VS-pharmacyOrderTypes](ValueSet-v2-0480.md) | Value Set of codes that specify the general category of pharmacy order which may be used to determine the processing path the order will take. |
| [hl7VS-phlebotomyIssue](ValueSet-v2-0925.md) | Value Set of codes specifying a phlebotomy issue. |
| [hl7VS-phlebotomyStatus](ValueSet-v2-0926.md) | Value Set of codes specifying the status of a phlebotomy. |
| [hl7VS-policyType](ValueSet-v2-0147.md) | Value Set of codes that specify the policy type. |
| [hl7VS-practitionerIdNumberType](ValueSet-v2-0338.md) | Value Set of codes that specify the type of number used for the practitioner identification. |
| [hl7VS-precautionCode](ValueSet-v2-0433.md) | Value Set of codes specifying non-clincal precautions that need to be taken with the patient. |
| [hl7VS-precertificationPatientType](ValueSet-v2-0150.md) | Value Set of codes that specify the category or type of patient for which this certification is requested. |
| [hl7VS-precision](ValueSet-v2-0529.md) | Value Set of codes used to specify the degree of precision of a time stamp. |
| [hl7VS-preferredMethodOfContrct](ValueSet-v2-0185.md) | Value Set of codes that specify which of a group of multiple phone numbers is the preferred method of contact for this person. |
| [hl7VS-preferredSpecimen-AttributeStatus](ValueSet-v2-0920.md) | Concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen. |
| [hl7VS-presentOnAdmission(poa)Indicator](ValueSet-v2-0895.md) | Value Set of codes specifying the present on admission indicator for this particular diagnosis. |
| [hl7VS-priceType](ValueSet-v2-0205.md) | Value Set of codes that identify the intent for the dollar amount on a pricing transaction. |
| [hl7VS-primaryKeyValueType](ValueSet-v2-0355.md) | Value Set of codes that specify the type for the master file record identifier. |
| [hl7VS-primaryObserver'sQualification](ValueSet-v2-0242.md) | Value Set of codes that provide a general description of the kind of health care professional who provided the primary observation. |
| [hl7VS-priority](ValueSet-v2-0027.md) | Value Set of codes that specify the allowed priorities for obtaining the specimen. |
| [hl7VS-privacyLevel](ValueSet-v2-0262.md) | Value Set of codes that identify the level of privacy a patient will be afforded when assigned to this location definition. |
| [hl7VS-procedureDrgType](ValueSet-v2-0416.md) | Value Set of codes that specify a procedure's priority ranking relative to its DRG. |
| [hl7VS-procedureFunctionalType](ValueSet-v2-0230.md) | Value Set of codes that classify a procedure. |
| [hl7VS-procedurePractitionerType](ValueSet-v2-0133.md) | Value Set of codes of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. |
| [hl7VS-procedurePriority](ValueSet-v2-0418.md) | Value Set of codes specifying a number that identifies the significance or priority of the procedure code. |
| [hl7VS-processInterruption](ValueSet-v2-0923.md) | Value Set of codes specifying whether a process was interrrupted and whether a needle had been inserted in the donor's arm prior to the interruption. |
| [hl7VS-processInterruptionReason](ValueSet-v2-0935.md) | Value Set of codes specifying the reason for a process interruption. |
| [hl7VS-processingConsiderationCodes](ValueSet-v2-0562.md) | Value Set of codes that specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). |
| [hl7VS-processingId](ValueSet-v2-0103.md) | Value Set of codes that specify whether the message is part of a production, training or debugging system. |
| [hl7VS-processingMode](ValueSet-v2-0207.md) | Concepts that indicate an archival process or an initial load process. |
| [hl7VS-processingPriority](ValueSet-v2-0168.md) | Value Set of codes that specify one or more available priorities for performing the observation or test. |
| [hl7VS-processingType](ValueSet-v2-0388.md) | Value Set of codes identifying the processing type that applies to the test code. If this attribute is omitted, then regular production is the default. |
| [hl7VS-product-serviceStatus](ValueSet-v2-0559.md) | Value Set of codes that specify the processing status for the Product/Service Code. |
| [hl7VS-product-servicesClarification](ValueSet-v2-0561.md) | Value Set of codes that specify the Product/Service Code. |
| [hl7VS-productSource](ValueSet-v2-0248.md) | Value Set of codes that describe the evaluation state of a product identified in an incident. |
| [hl7VS-productionClassCode](ValueSet-v2-0429.md) | Value Set of codes specifying the code and/or text indicating the primary use for which the living subject was bred or grown. |
| [hl7VS-protectionCode](ValueSet-v2-0618.md) | Value Set of codes that specify that an address needs to be treated with special care or sensitivity. |
| [hl7VS-providerAdjustmentReasonCode](ValueSet-v2-0565.md) | Value Set of codes used to specify the reason for this adjustment. |
| [hl7VS-providerBilling](ValueSet-v2-0187.md) | Value Set of codes that specify how provider services are billed. |
| [hl7VS-providerRole](ValueSet-v2-0286.md) | Value Set of codes that define the relationship between a referral recipient and a patient or between a referral initiator and a patient. |
| [hl7VS-providerRole](ValueSet-v2-0443.md) | Value Set of codes that specify the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). |
| [hl7VS-publicityCode](ValueSet-v2-0215.md) | Concepts specifying a level of publicity of information about a patient for a specific visit. |
| [hl7VS-purgeStatus](ValueSet-v2-0213.md) | Value Set of codes that define the state of a visit relative to its place in a purge workflow. |
| [hl7VS-quantityLimitedRequest](ValueSet-v2-0126.md) | Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. |
| [hl7VS-quantityMethod](ValueSet-v2-0329.md) | Value Set of codes that specify the method by which the quantity distributed is measured. |
| [hl7VS-quantityUnits](ValueSet-v2-0560.md) | Value Set of codes that specify the adjustment quantity. |
| [hl7VS-queryFormatCode](ValueSet-v2-0106.md) | Value Set of codes which specify which of several types of formats for data to be returned in response to a query. |
| [hl7VS-queryPriority](ValueSet-v2-0091.md) | Concepts which specify a time frame in which a querry response is expected. |
| [hl7VS-queryResponseStatus](ValueSet-v2-0208.md) | Concepts defining precise response status concepts in support of HL7 Version 2 query messaging. |
| [hl7VS-queryResultsLevel](ValueSet-v2-0108.md) | Value Set of codes which are used to control level of detail in query results. |
| [hl7VS-rangeType](ValueSet-v2-0298.md) | Value Set of codes that specify whether a composite price range is experssed as a flat rate or a percentage. |
| [hl7VS-re-admissionIndicator](ValueSet-v2-0092.md) | Value Set of codes which are used to specify that a patient is being re-admitted to a healthcare facility from which they were discharged, and indicates the circumstances around such re-admission. |
| [hl7VS-recreationalDrugUseCode](ValueSet-v2-0431.md) | Value Set of codes specifying what recreational drugs the patient uses. |
| [hl7VS-referralCategory](ValueSet-v2-0284.md) | Value Set of codes that describe the patient care setting where a referral should take place. |
| [hl7VS-referralDisposition](ValueSet-v2-0282.md) | Value Set of codes that identify the expected response from the healthcare professional receiving a referral. |
| [hl7VS-referralPriority](ValueSet-v2-0280.md) | Value Set of codes that designate the urgency of a referral. |
| [hl7VS-referralReason](ValueSet-v2-0336.md) | Value Set of codes that specify the reason for which the referral will take place. |
| [hl7VS-referralStatus](ValueSet-v2-0283.md) | Value Set of codes that define the state of a referral. |
| [hl7VS-referralType](ValueSet-v2-0281.md) | Value Set of codes that identify the general category of healthcare professional desired to satisfy a referral. |
| [hl7VS-reimbursementTypeCode](ValueSet-v2-0470.md) | Value Set of codes that specify the fee schedule reimbursement type applied to a line item. |
| [hl7VS-relatednessAssessment](ValueSet-v2-0250.md) | Value Set of codes that provide an estimate of whether an issue with a product was the cause of an event. |
| [hl7VS-relationalConjunction](ValueSet-v2-0210.md) | Value Set of codes used with relational operator values to group more than one segment field name. |
| [hl7VS-relationalOperator](ValueSet-v2-0209.md) | Value Set of codes that define the relationship between HL7 segment field names identified in a query construct. |
| [hl7VS-relationship](ValueSet-v2-0063.md) | Concepts specifying an actual personal relationship that the next of kin/associated party has to a patient. Used in HL7 Version 2.x messaging in the NK1 segment. |
| [hl7VS-relationshipModifier](ValueSet-v2-0258.md) | Value Set of codes that an observation definition to describe the subject of an observation in relation to a patient. |
| [hl7VS-relationshipType](ValueSet-v2-0948.md) | Value Set of codes that specify the type of relationship that is established between the instances of Source Information and Target Information. |
| [hl7VS-relevantClincialInformation](ValueSet-v2-0916.md) | Value Set of codes that specify additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. |
| [hl7VS-religion2](ValueSet-v2-0006.md) | Value Set of codes that specify a person's religion. |
| [hl7VS-remoteControlCommand](ValueSet-v2-0368.md) | Value Set of codes that identify the comment the component is to initiate. |
| [hl7VS-reorderTheoryCodes](ValueSet-v2-0642.md) | Value Set of codes that specify the calculation method used to determine the resupply schedule. |
| [hl7VS-repeatPattern](ValueSet-v2-0335.md) | Value Set of codes that specify the interval between repeated services. See the Comment/Usage Note in the table below, as the table contains both precoordinated codes that may be used in an HL7 field or component and also explanatory patterns i |
| [hl7VS-reportPriority](ValueSet-v2-0109.md) | Value Set of codes which specify the priority associated with a report or update run using a query. |
| [hl7VS-reportSource](ValueSet-v2-0235.md) | Value Set of codes that identify where a report sender learned about an event. |
| [hl7VS-reportTiming](ValueSet-v2-0234.md) | Value Set of codes that identify the time span of a report or the reason for a report sent to a regulatory agency. |
| [hl7VS-reportTypeCode](ValueSet-v2-0270.md) | Value Set of codes that identify the kind of patient document. |
| [hl7VS-reportingPriority](ValueSet-v2-0169.md) | Value Set of codes that specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. |
| [hl7VS-responseFlag](ValueSet-v2-0121.md) | Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler. |
| [hl7VS-responseLevel](ValueSet-v2-0179.md) | Concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. |
| [hl7VS-responseModality](ValueSet-v2-0394.md) | Value Set of codes identifying the timing and grouping of the response message(s). |
| [hl7VS-resultStatus-Obr](ValueSet-v2-0123.md) | Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [hl7VS-revenueCode](ValueSet-v2-0456.md) | Value Set of codes specifying a revenue code as specified in the National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code. These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. |
| [hl7VS-riskCodes](ValueSet-v2-0489.md) | Value Set of codes that specify any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. |
| [hl7VS-riskManagementIncidentCode](ValueSet-v2-0427.md) | Value Set of codes specifying the incident that occurred during a patient's stay. |
| [hl7VS-roleExecutingPhysician](ValueSet-v2-0881.md) | Value Set of codes specifying the account role of the physician, for example, only billing for the professional part, the technical part or both. |
| [hl7VS-roomType](ValueSet-v2-0145.md) | Value Set of codes that specify the room type. |
| [hl7VS-rootCause](ValueSet-v2-0914.md) | Value Set of codes specifying a root cause. |
| [hl7VS-route](ValueSet-v2-0033.md) | Value Set of codes that are used to indicate a means of administrating a medication dose. |
| [hl7VS-routeOfAdministration](ValueSet-v2-0162.md) | Value Set of codes that specify the route of administration. |
| [hl7VS-rulingAct](ValueSet-v2-0793.md) | Value Set of codes that specify an act containing a rule that the item is legally required to be included in notification reporting. |
| [hl7VS-rxComponentType](ValueSet-v2-0166.md) | Value Set of codes that specify the RX component type. |
| [hl7VS-schoolType](ValueSet-v2-0402.md) | Value Set of codes that specify a categorization of an academic institution that grants a degree to a Staff Member. |
| [hl7VS-securityCheckScheme](ValueSet-v2-0904.md) | Value Set of codes specifying the scheme for a security check. |
| [hl7VS-segmentActionCode](ValueSet-v2-0206.md) | Concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). |
| [hl7VS-segmentGroup](ValueSet-v2-0391.md) | Value Set of codes that specify the optional segment groups which are to be included in a response. |
| [hl7VS-sensitivityToCausativeAgentCode](ValueSet-v2-0436.md) | Value Set of codes specifying the reason the patient should not be exposed to a substance. |
| [hl7VS-sequenceCondition](ValueSet-v2-0524.md) | Value Set of codes that identify whether sequence conditions or a repeating cycle of orders is defined, as part of the Order Sequence Definition. |
| [hl7VS-sequenceConditionCode](ValueSet-v2-0504.md) | Value Set of codes that specify the relationship between the start/end of the related service request(s) and the current service request. |
| [hl7VS-sequenceResultsFlag](ValueSet-v2-0503.md) | Value Set of codes that specify the sequencing relationship between the current service request and a related service request(s) specified in the same information model structure. |
| [hl7VS-sequencing](ValueSet-v2-0397.md) | Value Set of codes identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not. |
| [hl7VS-serviceRequestRelationship](ValueSet-v2-0506.md) | Value Set of codes that specify an additional or alternate relationship between this service request and other service requests. |
| [hl7VS-severityOfIllnessCode](ValueSet-v2-0421.md) | Value Set of codes specifying the severity ranking of a patient's illness. |
| [hl7VS-shipmentStatus](ValueSet-v2-0905.md) | Value Set of codes specifying the status of a shipment. |
| [hl7VS-sideOfBody](ValueSet-v2-0894.md) | Value Set of codes specifying the side of the body ("left" or "right"). |
| [hl7VS-signatory'sRelationshipToSubject](ValueSet-v2-0548.md) | Value Set of codes that specify the relationship of the consenter to the subject. |
| [hl7VS-signatureCode](ValueSet-v2-0535.md) | Concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider. |
| [hl7VS-siteAdministered](ValueSet-v2-0034.md) | Value Set of codes that specify a location on the body where a dose is to be administered, e.g., IV, IM, Subcutaneous. |
| [hl7VS-sourceOfComment](ValueSet-v2-0105.md) | Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment. |
| [hl7VS-sourceOfSpecimen](ValueSet-v2-0070.md) | Value Set of codes which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table |
| [hl7VS-specialHandlingConsiderations](ValueSet-v2-0376.md) | Concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-specialProgramCode](ValueSet-v2-0214.md) | Value Set of codes that record a health insurance program required for healthcare visit reimbursement. |
| [hl7VS-specialtyType](ValueSet-v2-0265.md) | Value Set of codes that identify the specialty of the care professional who is supported when using this location definition. |
| [hl7VS-specimenAppropriateness](ValueSet-v2-0492.md) | Value Set of codes that specify the suitability of the specimen for the particular planned use as determined by the filler. |
| [hl7VS-specimenChildRole](ValueSet-v2-0494.md) | Value Set of codes that specify for child specimens the relationship between this specimen and the parent specimen. |
| [hl7VS-specimenCollectionMethod](ValueSet-v2-0488.md) | Concepts to document procedures or processes by which a specimen may be collected. This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-specimenComponent](ValueSet-v2-0372.md) | Value Set of codes that identify the specimen component, e.g., supernatant, sediment, etc. |
| [hl7VS-specimenCondition](ValueSet-v2-0493.md) | Concepts of modes or states of being that describe the nature of a specimen. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-specimenQuality](ValueSet-v2-0491.md) | Value Set of codes that specify the degree or grade of excellence of the specimen at receipt. |
| [hl7VS-specimenRejectReason](ValueSet-v2-0490.md) | Reasons a specimen may be rejected for a specified observation/result/analysis. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-specimenRole](ValueSet-v2-0369.md) | Value Set of codes that identify the role of a sample. |
| [hl7VS-specimenType](ValueSet-v2-0487.md) | Concepts that describe the precise nature of an entity that may be used as the source material for an observation. This is one of two code systems that are used instead of table 0070 (code system xxxx) which conflated specimen types and specimen collection methods. Used in Version 2 messaging in the SPM segment. |
| [hl7VS-startOfEvaluation](ValueSet-v2-0247.md) | Value Set of codes that describes the status of product evaluation. |
| [hl7VS-statusAdmission](ValueSet-v2-0759.md) | Value Set of codes that specify the admission status for the diagnosis related group (DRG) determination. |
| [hl7VS-statusPatient](ValueSet-v2-0739.md) | Value Set of codes that specify whether the length of stay is normal or respectively shorter or longer than normal. |
| [hl7VS-statusRespirationMinutes](ValueSet-v2-0757.md) | Value Set of codes that specify the status of the use of the respiration minutes information for diagnosis related group (DRG) determination. |
| [hl7VS-statusWeightAtBirth](ValueSet-v2-0755.md) | Value Set of codes that specify the status of the use of the weight at birth for diagnosis related group (DRG) determination. |
| [hl7VS-sterilizationType](ValueSet-v2-0806.md) | Value Set of codes specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment. |
| [hl7VS-stockLocation](ValueSet-v2-0012.md) | Value Set of codes that specify a stock location. |
| [hl7VS-studentStatus](ValueSet-v2-0231.md) | Value Set of codes that designate whether a guarantor is a full or part time student. |
| [hl7VS-substanceStatus](ValueSet-v2-0383.md) | Value Set of codes identifying the status of the inventoried item. The status indicates the current status of the substance. |
| [hl7VS-substanceType](ValueSet-v2-0384.md) | Value Set of codes identifying the type of substance. |
| [hl7VS-substitutionStatus](ValueSet-v2-0167.md) | Value Set of codes that specify the substitution status. |
| [hl7VS-subtypeOfReferencedData](ValueSet-v2-notAllCodes-0291.md) | A subset of the IANA media subtypes of binary data that are encoded in an ascii structure or stream. |
| [hl7VS-supplierType](ValueSet-v2-0946.md) | Value Set of codes specifying the type of supplier that will distribute the supply items associated to a contract number. |
| [hl7VS-supplyRiskCodes](ValueSet-v2-0871.md) | Value Set of codes specifying any known or suspected hazard associated with this material item. |
| [hl7VS-systemInducedContaminants](ValueSet-v2-0374.md) | Value Set of codes that identify the specimen contaminant identifier associated with the specimen in the container. |
| [hl7VS-taxStatus](ValueSet-v2-0572.md) | Value Set of codes used to specify the tax status of a provider. |
| [hl7VS-telecommunicationEquipmentType](ValueSet-v2-0202.md) | Concepts for specifying a type of telecommunication equipment. |
| [hl7VS-telecommunicationExpirationReason](ValueSet-v2-0868.md) | Value Set of codes specifying the reason this contact number/email was marked as "ended". |
| [hl7VS-telecommunicationUseCode](ValueSet-v2-0201.md) | Concepts for specifying a specific use of a telecommunication number. |
| [hl7VS-temperatureUnits](ValueSet-v2-0931.md) | Value Set of codes specifying the units of transport temperature. |
| [hl7VS-timeDelayPostChallenge](ValueSet-v2-0256.md) | Value Set of codes that classify an observation definition as being a component of a challenge test. |
| [hl7VS-timeSelectionCriteriaParameterClassCodes](ValueSet-v2-0294.md) | Value Set of codes that describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. |
| [hl7VS-tissueTypeCode](ValueSet-v2-0417.md) | Value Set of codes that specify the type of tissue removed from a patient during a procedure. |
| [hl7VS-tqConjunctionId](ValueSet-v2-0472.md) | Value Set of codes that specify that a second timing specification is to follow using the repeat delimiter. |
| [hl7VS-transactionType](ValueSet-v2-0017.md) | Value Set of codes that specify a type of financial transaction. |
| [hl7VS-transfusionAdverseReaction](ValueSet-v2-0514.md) | Value Set of codes that specify the type of adverse reaction that the recipient of the blood product experienced. |
| [hl7VS-transportArranged](ValueSet-v2-0224.md) | Value Set of codes defining whether patient transportation preparations are in place. |
| [hl7VS-transportationMode](ValueSet-v2-0124.md) | Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service. |
| [hl7VS-trayType](ValueSet-v2-0160.md) | Value Set of codes that specify the type of dietary tray. |
| [hl7VS-treatment](ValueSet-v2-0373.md) | Value Set of codes that identify the specimen treatment performed during lab processing. |
| [hl7VS-triageCode](ValueSet-v2-0422.md) | Value Set of codes specifying a patient's prioritization within the context of this abstract. |
| [hl7VS-typeOfAgreement](ValueSet-v2-0098.md) | Concepts which specify codes to further identify an insurance plan. |
| [hl7VS-typeOfData](ValueSet-v2-0191.md) | Concepts declaring the general type of media data that is encoded. |
| [hl7VS-universalIdType](ValueSet-v2-0301.md) | Types of UID (Universal Identifiers). |
| [hl7VS-userAuthenticationCredentialTypeCode](ValueSet-v2-0615.md) | Value Set of codes that specify a type of user authentication credential. |
| [hl7VS-valueType](ValueSet-v2-0125.md) | Concepts which specify the data type of OBX-5, Observation Value, and are a subset of the datatypes defined in HL7 Version 2.x. |
| [hl7VS-versionControlTable](ValueSet-v2-0104.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |
| [hl7VS-visitIndicator](ValueSet-v2-0326.md) | Value Set of codes that specify the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to i |
| [hl7VS-visitPriorityCode](ValueSet-v2-0217.md) | Value Set of codes that define a relative level of urgency applied to a patient visit. |
| [hl7VS-visitUserCode](ValueSet-v2-0130.md) | Value Set of codes that specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis. |
| [hl7VS-volumeUnits](ValueSet-v2-0568.md) | Value Set of codes of units of measure that are used to specify volume. |
| [hl7VS-volumeUnits](ValueSet-v2-0930.md) | Value Set of codes of units of measure that are used to specify volume. |
| [hl7VS-weightUnits](ValueSet-v2-0567.md) | Value Set of codes of units of measure that are used to specify weight. |
| [hl7VS-weightUnits](ValueSet-v2-0929.md) | Value Set of codes of units of measure that are used to specify weight. |
| [hl7VS-whatSubjectFilter](ValueSet-v2-0048.md) | Value Set of codes which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. |
| [hl7VS-whenToCharge](ValueSet-v2-0100.md) | Value Set of codes that specify codes for an event precipitating/triggering a charge activity. |
| [hl7VS-whichDate-timeQualifier](ValueSet-v2-0156.md) | Value Set of codes that specify the type of date referred to in the other date fields in the QRF segment. |
| [hl7VS-whichDate-timeStatusQualifier](ValueSet-v2-0157.md) | Value Set of codes that specify the status type of objects selected in date range defined by QRF-2 and QRF-3. |
| [hl7VS-yes-no-Indicator](ValueSet-v2-0136.md) | Codes specifying either Yes or No used in fields containing binary answers generally user-specified. |
| [immunizationForecastDate](ValueSet-v3-immunizationForecastDate.md) | Set of LOINC codes that identify the type of date that is specified within an immunization forecast step. |
| [immunizationForecastStatusObservationValue](ValueSet-v3-immunizationForecastStatusObservationValue.md) | Represents the patient's status with respect to their immunization guideline as of an evaluation date. |
| [materialForm](ValueSet-v3-materialForm.md) | A value representing the state (solid, liquid, gas) and nature of the material. |
| [rofessional Credential Status](ValueSet-professional-credential-status.md) | This code system establishes a series of codes designed to represent the status of professional credentials. |
| [sequenceStatus](ValueSet-variant-state.md) | Codes providing the status of the variant test result. |
| [v3 Code System ActCode](ValueSet-v3-ActCode.md) | A code specifying the particular kind of Act that the Act-instance represents within its class. Constraints: The kind of Act (e.g. physical examination, serum potassium, inpatient encounter, charge financial transaction, etc.) is specified with a code from one of several, typically external, coding systems. The coding system will depend on the class of Act, such as LOINC for observations, etc. Conceptually, the Act.code must be a specialization of the Act.classCode. This is why the structure of ActClass domain should be reflected in the superstructure of the ActCode domain and then individual codes or externally referenced vocabularies subordinated under these domains that reflect the ActClass structure. Act.classCode and Act.code are not modifiers of each other but the Act.code concept should really imply the Act.classCode concept. For a negative example, it is not appropriate to use an Act.code "potassium" together with and Act.classCode for "laboratory observation" to somehow mean "potassium laboratory observation" and then use the same Act.code for "potassium" together with Act.classCode for "medication" to mean "substitution of potassium". This mutually modifying use of Act.code and Act.classCode is not permitted. |
| [v3 Code System ActReason](ValueSet-v3-ActReason.md) | A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not reasonably represented as an ActRelationship of type "has reason" linking to another Act. Examples: Example reasons that might qualify for being coded in this field might be: "routine requirement", "infectious disease reporting requirement", "on patient request", "required by law". |
| [v3 Code System RoleCode](ValueSet-v3-RoleCode.md) | A set of codes further specifying the kind of Role; specific classification codes for further qualifying RoleClass codes. |
| [v3 Value Set ActSite](ValueSet-v3-ActSite.md) | An anatomical location on an organism which can be the focus of an act. |
| [workClassificationODH](ValueSet-v2-0959.md) | A person’s employment type as defined by compensation and sector (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.). |
| [x_AccommodationRequestorRole](ValueSet-v3-xAccommodationRequestorRole.md) | ****No description**** |
| [x_ActBillableCode](ValueSet-v3-xActBillableCode.md) | ****No description**** |
| [x_ActClassCareProvisionEncounter](ValueSet-v3-xActClassCareProvisionEncounter.md) | **Definition:**When identifying the "request" that resulted in an encounter, there is a need to distinguish whether the "request" was a general referral (CareProvisionRequest) or a more specific ordered or scheduled encounter (PatientEncounter). |
| [x_ActClassCareProvisionObservation](ValueSet-v3-xActClassCareProvisionObservation.md) | ****No description**** |
| [x_ActClassCareProvisionProcedure](ValueSet-v3-xActClassCareProvisionProcedure.md) | ****No description**** |
| [x_ActClassDocumentEntryAct](ValueSet-v3-xActClassDocumentEntryAct.md) | The set of Act class codes allowed for the ACT class clone in the CDA Clinical Statement model. The scope of this value set are those Act class codes not otherwise covered by specific classes in the CDA Clinical Statement model and required to enable representation of Clinical Statement in CDA. |
| [x_ActClassDocumentEntryOrganizer](ValueSet-v3-xActClassDocumentEntryOrganizer.md) | ****No description**** |
| [x_ActEncounterReason](ValueSet-v3-xActEncounterReason.md) | Administrative reasons for patient encounters.**Example:**Medical necessity, patient request and dependency. |
| [x_ActFinancialProductAcquisitionCode](ValueSet-v3-xActFinancialProductAcquisitionCode.md) | The method that a product is obtained for use by the subject of the supply act (e.g. patient), with financial compensation. Product examples are consumable or durable goods. |
| [x_ActInvoiceDetailPharmacyCode](ValueSet-v3-xActInvoiceDetailPharmacyCode.md) | The billable codes selected for use for Pharmacy Invoices. Steward is Financial Management. |
| [x_ActInvoiceDetailPreferredAccommodationCode](ValueSet-v3-xActInvoiceDetailPreferredAccommodationCode.md) | The billable codes selected for use for Preferred Accommodation Invoices. Steward is Financial Management. |
| [x_ActMoodCompletionCriterion](ValueSet-v3-xActMoodCompletionCriterion.md) | **Description:**These are moods describing activities as they progress in the business cycle, from defined, through planned and ordered to completed, and any applicable criterion or condition over actual and potential services that must apply for an associated service to be considered. |
| [x_ActMoodDefEvn](ValueSet-v3-xActMoodDefEvn.md) | A grouping of Definition, Event. These specific moods are used in control wrapper override acts. The domain is restricted to acts that are possible to occur or have already occurred. |
| [x_ActMoodDefEvnRqo](ValueSet-v3-xActMoodDefEvnRqo.md) | ****No description**** |
| [x_ActMoodDefEvnRqoPrmsPrp](ValueSet-v3-xActMoodDefEvnRqoPrmsPrp.md) | ****No description**** |
| [x_ActMoodDocumentObservation](ValueSet-v3-xActMoodDocumentObservation.md) | Used to enumerate the moods that an observation can take within the body of a clinical document. |
| [x_ActMoodEvnOrdPrmsPrp](ValueSet-v3-xActMoodEvnOrdPrmsPrp.md) | ****No description**** |
| [x_ActMoodIntentEvent](ValueSet-v3-xActMoodIntentEvent.md) | A constraint domain for RMIM design. |
| [x_ActMoodOrdPrms](ValueSet-v3-xActMoodOrdPrms.md) | A grouping of Order, Promise. These specific moods are used in orders. |
| [x_ActMoodOrdPrmsEvn](ValueSet-v3-xActMoodOrdPrmsEvn.md) | A grouping of Order, Promise and Event moods. |
| [x_ActMoodPermPermrq](ValueSet-v3-xActMoodPermPermrq.md) | Enumerates the moods that an Act can take when describing privileges. |
| [x_ActMoodRequestEvent](ValueSet-v3-xActMoodRequestEvent.md) | ****No description**** |
| [x_ActMoodRqoPrpAptArq](ValueSet-v3-xActMoodRqoPrpAptArq.md) | ****No description**** |
| [x_ActOrderableOrBillable](ValueSet-v3-xActOrderableOrBillable.md) | ****No description**** |
| [x_ActRelationshipDocument](ValueSet-v3-xActRelationshipDocument.md) | Used to enumerate the relationships between two clinical documents for document management. |
| [x_ActRelationshipDocumentSPL](ValueSet-v3-xActRelationshipDocumentSPL.md) | ****No description**** |
| [x_ActRelationshipEntry](ValueSet-v3-xActRelationshipEntry.md) | Used to enumerate the relationships between a CDA section and its contained entries. |
| [x_ActRelationshipEntryRelationship](ValueSet-v3-xActRelationshipEntryRelationship.md) | Used to enumerate the relationships between two CDA entries. |
| [x_ActRelationshipExternalReference](ValueSet-v3-xActRelationshipExternalReference.md) | Used to enumerate the relationships between a CDA entry and an externally referenced act. |
| [x_ActRelationshipPatientTransport](ValueSet-v3-xActRelationshipPatientTransport.md) | Relates a patient encounter act (source) to the transportation act (target) representing the patient"s arrival at or departure from the site of a patient encounter. |
| [x_ActRelationshipPertinentInfo](ValueSet-v3-xActRelationshipPertinentInfo.md) | ****No description**** |
| [x_ActRelationshipRelatedAuthorizations](ValueSet-v3-xActRelationshipRelatedAuthorizations.md) | ****No description**** |
| [x_ActReplaceOrRevise](ValueSet-v3-xActReplaceOrRevise.md) | ****No description**** |
| [x_ActStatusActiveComplete](ValueSet-v3-xActStatusActiveComplete.md) | ****No description**** |
| [x_ActStatusActiveSuspended](ValueSet-v3-xActStatusActiveSuspended.md) | ****No description**** |
| [x_ActStatusPrevious](ValueSet-v3-xActStatusPrevious.md) | **Description:**Cancelled, nullified and obsolete . |
| [x_AdministeredSubstance](ValueSet-v3-xAdministeredSubstance.md) | A type of Manufactured Material that is administered to a living subject, either by a healthcare professional or auto-administered, within a healthcare context. |
| [x_AdverseEventCausalityAssessmentMethods](ValueSet-v3-xAdverseEventCausalityAssessmentMethods.md) | Value set provides methods used to assess the causality of adverse events. New codes should not be added to the domain without first checking with its steward - the Regulated Clinical Research Information Management (RCRIM) technical committee. |
| [x_BasicConfidentialityKind](ValueSet-v3-xBasicConfidentialityKind.md) | **Description:**Used to enumerate the typical confidentiality constraints placed upon a clinical document.**Usage Note:**x_BasicConfidentialityKind is a subset of Confidentiality codes that are used as metadata indicating the receiver responsibility to comply with normally applicable jurisdictional privacy law or disclosure authorization; that the receiver may not disclose this information except as directed by the information custodian, who may be the information subject; or that the receiver may not disclose this information except as directed by the information custodian, who may be the information subject. |
| [x_BillableProduct](ValueSet-v3-xBillableProduct.md) | **Description:**The billable codes selected for Clinical Product Invoices. Steward is Financial Management. |
| [x_ClinicalStatementActMood](ValueSet-v3-xClinicalStatementActMood.md) | ****No description**** |
| [x_ClinicalStatementEncounterMood](ValueSet-v3-xClinicalStatementEncounterMood.md) | ****No description**** |
| [x_ClinicalStatementExposureMood](ValueSet-v3-xClinicalStatementExposureMood.md) | ****No description**** |
| [x_ClinicalStatementObservationMood](ValueSet-v3-xClinicalStatementObservationMood.md) | ****No description**** |
| [x_ClinicalStatementProcedureMood](ValueSet-v3-xClinicalStatementProcedureMood.md) | ****No description**** |
| [x_ClinicalStatementSubstanceMood](ValueSet-v3-xClinicalStatementSubstanceMood.md) | ****No description**** |
| [x_ClinicalStatementSupplyMood](ValueSet-v3-xClinicalStatementSupplyMood.md) | ****No description**** |
| [x_DeterminerInstanceKind](ValueSet-v3-xDeterminerInstanceKind.md) | ****No description**** |
| [x_DocumentActMood](ValueSet-v3-xDocumentActMood.md) | Used to enumerate the moods that an act can take within the body of a clinical document. |
| [x_DocumentEncounterMood](ValueSet-v3-xDocumentEncounterMood.md) | Used to enumerate the moods that an encounter can take within the body of a clinical document. |
| [x_DocumentEntrySubject](ValueSet-v3-xDocumentEntrySubject.md) | Used to represent the role(s) of those who can serve as subjects of the contents of a clinical document. |
| [x_DocumentProcedureMood](ValueSet-v3-xDocumentProcedureMood.md) | Used to enumerate the moods that a procedure can take within the body of a clinical document. |
| [x_DocumentStatus](ValueSet-v3-xDocumentStatus.md) | Status of a clinical document. |
| [x_DocumentSubject](ValueSet-v3-xDocumentSubject.md) | ****No description**** |
| [x_DocumentSubstanceMood](ValueSet-v3-xDocumentSubstanceMood.md) | Used to enumerate the moods that a substance administration can take within the body of a clinical document. |
| [x_EncounterAdmissionUrgency](ValueSet-v3-xEncounterAdmissionUrgency.md) | The urgency for starting a patient encounter.**Example:**Routine, urgent, emergency, and elective. |
| [x_EncounterParticipant](ValueSet-v3-xEncounterParticipant.md) | Clones using this x_domain should have a name "encounterParticipant". |
| [x_EncounterPerformerParticipation](ValueSet-v3-xEncounterPerformerParticipation.md) | Used to enumerate the ways in which a clinician can directly participate during an encounter which generates a clinical document. |
| [x_EntityClassDocumentReceiving](ValueSet-v3-xEntityClassDocumentReceiving.md) | ****No description**** |
| [x_EntityClassPersonOrOrgReceiving](ValueSet-v3-xEntityClassPersonOrOrgReceiving.md) | ****No description**** |
| [x_InformationRecipient](ValueSet-v3-xInformationRecipient.md) | Used to represent participant(s) who should receive a copy of a document. |
| [x_InformationRecipientRole](ValueSet-v3-xInformationRecipientRole.md) | Used to represent the role(s) of those who should receive a copy of a document. |
| [x_LabProcessClassCodes](ValueSet-v3-xLabProcessClassCodes.md) | ****No description**** |
| [x_MedicationOrImmunization](ValueSet-v3-xMedicationOrImmunization.md) | ****No description**** |
| [x_Medicine](ValueSet-v3-xMedicine.md) | A type of Administered Substance that is manufactured from raw organic or inorganic ingredients and used in the course of a patient's therapy. |
| [x_OrganizationNamePartType](ValueSet-v3-xOrganizationNamePartType.md) | A name for an organization, such as "Health Level Seven, Inc." An organization name consists only of untyped name parts, prefixes, suffixes, and delimiters. |
| [x_ParticipationAuthorPerformer](ValueSet-v3-xParticipationAuthorPerformer.md) | One who initiates the control act event, either as its author or its physical performer. |
| [x_ParticipationEntVrf](ValueSet-v3-xParticipationEntVrf.md) | A person that contributed to recording or validating the act. |
| [x_ParticipationPrfEntVrf](ValueSet-v3-xParticipationPrfEntVrf.md) | A person that performed, contributed in recording or validating the act. |
| [x_ParticipationVrfRespSprfWit](ValueSet-v3-xParticipationVrfRespSprfWit.md) | One who oversees a control act event. Includes either a type of accountability, as in responsible party, verifier (and its children) and witness; or being an assistant to the control act event, as in secondary performer. |
| [x_PayeeRelationshipRoleType](ValueSet-v3-xPayeeRelationshipRoleType.md) | The specification of the relationship to the covered party of the payee in the case when an insurer is not directly paying the healthcare provider (as payee) but reimbursing the party that did pay them. |
| [x_PersonNamePartType](ValueSet-v3-xPersonNamePartType.md) | ****No description**** |
| [x_PhoneOrEmailURLScheme](ValueSet-v3-xPhoneOrEmailURLScheme.md) | Restricts scheme to e-mail or phone numbers at which a human can be reached |
| [x_PhoneURLScheme](ValueSet-v3-xPhoneURLScheme.md) | Restricts scheme to phone numbers at which a human can be reached |
| [x_PhysicalVerbalParticipationMode](ValueSet-v3-xPhysicalVerbalParticipationMode.md) | Restricts participation to either physical or verbal |
| [x_RoleClassAccommodationRequestor](ValueSet-v3-xRoleClassAccommodationRequestor.md) | The requestor for the accommodation. Steward is Financial Management Technical Committee |
| [x_RoleClassCoverage](ValueSet-v3-xRoleClassCoverage.md) | An abstract domain that encompasses the roles that arise in the context of providing, purchasing, and managing health care coverage and insurance. |
| [x_RoleClassCoverageInvoice](ValueSet-v3-xRoleClassCoverageInvoice.md) | An abstract domain that encompasses the roles involved in submitting, responding to and managing invoices or claims for health care coverage. |
| [x_RoleClassCredentialedEntity](ValueSet-v3-xRoleClassCredentialedEntity.md) | A role played by an entity that receives credentials from the scoping entity. |
| [x_RoleClassPayeePolicyRelationship](ValueSet-v3-xRoleClassPayeePolicyRelationship.md) | The specification of the relationship of the Payee to the invoice. Can be used in cases when an insurer is not directly paying the healthcare provider (as payee) but reimbursing the party that paid the invoice/claim. |
| [x_SUCC_REPL_PREV](ValueSet-v3-xSUCCREPLPREV.md) | ****No description**** |
| [x_ServiceEventPerformer](ValueSet-v3-xServiceEventPerformer.md) | Clones using this x_domain should have a name "performer". |
| [x_SubstitutionConditionNoneOrUnconditional](ValueSet-v3-xSubstitutionConditionNoneOrUnconditional.md) | Restricts substitution to effectively a yes/no decision |
| [x_VeryBasicConfidentialityKind](ValueSet-v3-xVeryBasicConfidentialityKind.md) | **Description:**Limits confidentiality to effectively a yes/no decision.**Usage Note:**x_VeryBasicConfidentialityKind is a subset of Confidentiality codes that are used as metadata indicating the receiver responsibility to comply with normally applicable jurisdictional privacy law or disclosure authorization or that the receiver may not disclose this information except as directed by the information custodian, who may be the information subject. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ADA Tooth Surface Codes](CodeSystem-ADAToothSurfaceCodes.md) | Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form. Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces). Tooth Surface Codes can be accessed through the[ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7) |
| [ADA Universal Tooth Designation System](CodeSystem-ADAUniversalToothDesignationSystem.md) | The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994. The universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. Teeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32). Supernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32). The Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf |
| [Accepting Patients](CodeSystem-accepting-patients.md) | This code system defines a set of codes that can be used to indicate a practice is accepting new patients. |
| [AcknowledgementCondition](CodeSystem-v3-AcknowledgementCondition.md) | The codes identify the conditions under which accept acknowledgements are required to be returned in response to this message. Note that accept acknowledgement address two different issues at the same time: reliable transport as well as syntactical correctness |
| [AcknowledgementDetailCode](CodeSystem-v3-AcknowledgementDetailCode.md) | **OpenIssue:**Missing description. |
| [AcknowledgementDetailType](CodeSystem-v3-AcknowledgementDetailType.md) | A code identifying the specific message to be provided.**Discussion:**A textual value may be specified as the print name, or for non-coded messages, as the original text.**Examples:**'Required attribute xxx is missing', 'System will be unavailable March 19 from 0100 to 0300' |
| [AcknowledgementType](CodeSystem-v3-AcknowledgementType.md) | This attribute contains an acknowledgement code as described in the HL7 message processing rules.**OpenIssue:**Description was copied from attribute and needs to be improved to be appropriate for a code system. |
| [ActClass](CodeSystem-v3-ActClass.md) | A code specifying the major type of Act that this Act-instance represents.**Constraints:**The classCode domain is a tightly controlled vocabulary, not an external or user-defined vocabulary. Every Act-instance must have a classCode. If the act class is not further specified, the most general Act.classCode (ACT) is used. The Act.classCode must be a generalization of the specific Act concept (e.g., as expressed in Act.code), in other words, the Act concepts conveyed in an Act must be specializations of the Act.classCode. Especially, Act.code is not a "modifier" that can alter the meaning of a class code. (See Act.code for contrast.) |
| [ActCode](CodeSystem-v3-ActCode.md) | A code specifying the particular kind of Act that the Act-instance represents within its class.**Constraints:**The kind of Act (e.g. physical examination, serum potassium, inpatient encounter, charge financial transaction, etc.) is specified with a code from one of several, typically external, coding systems. The coding system will depend on the class of Act, such as LOINC for observations, etc. Conceptually, the Act.code must be a specialization of the Act.classCode. This is why the structure of ActClass domain should be reflected in the superstructure of the ActCode domain and then individual codes or externally referenced vocabularies subordinated under these domains that reflect the ActClass structure. Act.classCode and Act.code are not modifiers of each other but the Act.code concept should really imply the Act.classCode concept. For a negative example, it is not appropriate to use an Act.code "potassium" together with and Act.classCode for "laboratory observation" to somehow mean "potassium laboratory observation" and then use the same Act.code for "potassium" together with Act.classCode for "medication" to mean "substitution of potassium". This mutually modifying use of Act.code and Act.classCode is not permitted. |
| [ActExposureLevelCode](CodeSystem-v3-ActExposureLevelCode.md) | A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as "low", "medium" and "high". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance. |
| [ActInvoiceElementModifier](CodeSystem-v3-ActInvoiceElementModifier.md) | Processing consideration and clarification codes. |
| [ActMood](CodeSystem-v3-ActMood.md) | OpenIssue: In Ballot 2009May, a strong Negative vote was lodged against several of the concept definitions in the vocabulary used for Act.moodCode. The vote was found "Persuasive With Mod", with the understanding that M and M would undertake a detailed review of these concept definitions for a future release of the RIM. |
| [ActPriority](CodeSystem-v3-ActPriority.md) | A set of codes (e.g., for routine, emergency), specifying the urgency under which the Act happened, can happen, is happening, is intended to happen, or is requested/demanded to happen. |
| [ActReason](CodeSystem-v3-ActReason.md) | A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not reasonably represented as an ActRelationship of type "has reason" linking to another Act.**Examples:**Example reasons that might qualify for being coded in this field might be: "routine requirement", "infectious disease reporting requirement", "on patient request", "required by law". |
| [ActRelationshipCheckpoint](CodeSystem-v3-ActRelationshipCheckpoint.md) | A code specifying when in the course of an Act a precondition for the Act is evaluated (e.g., before the Act starts for the first time, before every repetition, after each repetition but not before the first, or throughout the entire time of the Act.)**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Before each step is executed and has preconditions these conditions are tested and if the test is positive, the Act has clearance for execution. The repeatNumber may indicate that an Act may be repeatedly executed. The checkpointCode is specifies when the precondition is checked and is analogous to the various conditional statements and loop constructs in programming languages "while-do" vs. "do-while" or "repeat-until" vs. "loop-exit". For all checkpointCodes, except "end", preconditions are being checked at the time when the preceding step of the plan has terminated and this step would be next in the sequence established by the sequenceNumber attribute. When the checkpointCode for a criterion of a repeatable Act is "end", the criterion is tested only at the end of each repetition of that Act. When the condition holds true, the next repetition is ready for execution. When the checkpointCode is "entry" the criterion is checked at the beginning of each repetition (if any) whereas "beginning" means the criterion is checked only once before the repetition "loop" starts. The checkpointCode "through" is special in that it requires the condition to hold throughout the execution of the Act, even throughout a single execution. As soon as the condition turns false, the Act should receive an interrupt event (see interruptibleInd) and will eventually terminate. The checkpointCode "exit" is only used on a special plan step that represents a loop exit step. This allows an action plan to exit due to a condition tested inside the execution of this plan. Such exit criteria are sequenced with the other plan components using the ActRelationship.sequenceNumber. |
| [ActRelationshipJoin](CodeSystem-v3-ActRelationshipJoin.md) | A code specifying how concurrent Acts are resynchronized in a parallel branch construct.**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. Branches are parallel if the splitCode specifies that more than one branch can be executed at the same time. The joinCode then specifies if and how the braches are resynchronized. The principal re-synchronization actions are (1) the control flow waits for a branch to terminate (wait-branch), (2) the branch that is not yet terminated is aborted (kill-branch), (3) the branch is not re-synchronized at all and continues in parallel (detached branch). A kill branch is only executed if there is at least one active wait (or exclusive wait) branch. If there is no other wait branch active, a kill branch is not started at all (rather than being aborted shortly after it is started.) Since a detached branch is unrelated to all other branches, active detached branches do not protect a kill-branch from being aborted. |
| [ActRelationshipSplit](CodeSystem-v3-ActRelationshipSplit.md) | A code specifying how branches in an action plan are selected among other branches.**Discussion:**This attribute is part of the workflow control suite of attributes. An action plan is a composite Act with component Acts. In a sequential plan, each component has a sequenceNumber that specifies the ordering of the plan steps. Branches exist when multiple components have the same sequenceNumber. The splitCode specifies whether a branch is executed exclusively (case-switch) or inclusively, i.e., in parallel with other branches. In addition to exlusive and inclusive split the splitCode specifies how the pre-condition (also known as "guard conditions" on the branch) are evaluated. A guard condition may be evaluated once when the branching step is entered and if the conditions do not hold at that time, the branch is abandoned. Conversely execution of a branch may wait until the guard condition turns true. In exclusive wait branches, the first branch whose guard conditions turn true will be executed and all other branches abandoned. In inclusive wait branches some branches may already be executed while other branches still wait for their guard conditions to turn true. |
| [ActRelationshipSubset](CodeSystem-v3-ActRelationshipSubset.md) | Used to indicate that the target of the relationship will be a filtered subset of the total related set of targets. Used when there is a need to limit the number of components to the first, the last, the next, the total, the average or some other filtered or calculated subset. |
| [ActRelationshipType](CodeSystem-v3-ActRelationshipType.md) | The source is an excerpt from the target. |
| [ActSite](CodeSystem-v3-ActSite.md) | An anatomical location on an organism which can be the focus of an act. |
| [ActStatus](CodeSystem-v3-ActStatus.md) | Codes representing the defined possible states of an Act, as defined by the Act class state machine. |
| [ActUSPrivacyLaw](CodeSystem-v3-ActUSPrivacyLaw.md) | A jurisdictional mandate in the US relating to privacy.****Deprecation Comment:****Content moved to ActCode under _ActPrivacyLaw; use that instead. |
| [ActUncertainty](CodeSystem-v3-ActUncertainty.md) | **OpenIssue:**Missing Description |
| [ActionType](CodeSystem-action-type.md) | The type of action to be performed. |
| [ActivityDefinitionCategory](CodeSystem-activity-definition-category.md) | High-level categorization of the type of activity. |
| [AddressPartType](CodeSystem-v3-AddressPartType.md) | **Description:**Code that specifies whether an address part names the street, city, country, postal code, post box, etc. Discussion: The hierarchical nature of these concepts shows composition. E.g. "Street Name" is part of "Street Address Line" |
| [AddressUse](CodeSystem-v3-AddressUse.md) | Codes that provide guidance around the circumstances in which a given address should be used. |
| [Adjudication Error Codes](CodeSystem-adjudication-error.md) | This value set includes a smattering of adjudication codes. |
| [Adjudication Reason Codes](CodeSystem-adjudication-reason.md) | This value set includes smattering of Adjudication Reason codes. |
| [Adjudication Value Codes](CodeSystem-adjudication.md) | This value set includes a smattering of Adjudication Value codes which includes codes to indicate the amounts eligible under the plan, the amount of benefit, copays etc. |
| [AdministrativeGender](CodeSystem-v3-AdministrativeGender.md) | The gender of a person used for adminstrative purposes (as opposed to clinical gender) |
| [Admit source](CodeSystem-admit-source.md) | This value set defines a set of codes that can be used to indicate from where the patient came in. |
| [AdverseEventCategory](CodeSystem-adverse-event-category.md) | Overall categorization of the event, e.g. product-related or situational. |
| [AdverseEventCausalityAssessment](CodeSystem-adverse-event-causality-assess.md) | Codes for the assessment of whether the entity caused the event. |
| [AdverseEventCausalityMethod](CodeSystem-adverse-event-causality-method.md) | This code system contains methods for assessing causality. |
| [AdverseEventSeriousness](CodeSystem-adverse-event-seriousness.md) | Overall seriousness of this event for the patient. |
| [AdverseEventSeverity](CodeSystem-adverse-event-severity.md) | The severity of the adverse event itself, in direct relation to the subject. |
| [AllergyIntolerance Clinical Status Codes](CodeSystem-allergyintolerance-clinical.md) | Preferred value set for AllergyIntolerance Clinical Status. |
| [AllergyIntolerance Verification Status](CodeSystem-allergyintolerance-verification.md) | The verification status to support or decline the clinical status of the allergy or intolerance. |
| [AllergyIntoleranceCertainty](CodeSystem-reaction-event-certainty.md) | Statement about the degree of clinical certainty that a specific substance was the cause of the manifestation in a reaction event. |
| [AllergyIntoleranceSubstanceExposureRisk](CodeSystem-allerg-intol-substance-exp-risk.md) | The risk of an adverse reaction (allergy or intolerance) for this patient upon exposure to the substance (including pharmaceutical products). |
| [AlternativeCodeKind](CodeSystem-codesystem-altcode-kind.md) | Indicates the type of use for which the code is defined. |
| [AlternativeCodeKind](CodeSystem-composition-altcode-kind.md) | Indicates the type of use for which the code is defined. |
| [AmericanIndianAlaskaNativeLanguages](CodeSystem-v3-AmericanIndianAlaskaNativeLanguages.md) | American Indian and Alaska Native languages currently being used in the United States. |
| [Appointment cancellation reason](CodeSystem-appointment-cancellation-reason.md) | This example value set defines a set of reasons for the cancellation of an appointment. |
| [Appropriateness Score](CodeSystem-appropriateness-score.md) | The scoring for appropriateness of an action based upon RAND. |
| [Artifact Contribution Instance Type](CodeSystem-artifact-contribution-instance-type.md) | Artifact Contribution Instance Type |
| [Artifact Identifier Type Codes](CodeSystem-artifact-identifier-type.md) | Identifier types for an artifact (e.g. version-independent, version-specific, short-name, endorser, publisher) |
| [Artifact Relationship Type](CodeSystem-artifact-relationship-type.md) | This artifact incorporates the target artifact. This artifact is constructed with the target artifact as a component. The target artifact is a part of this artifact. (A dataset is composed of data.). |
| [Artifact Url Classifier](CodeSystem-artifact-url-classifier.md) | Code the reason for different URLs, eg abstract and full-text. |
| [Artifact Version Policy Codes](CodeSystem-artifact-version-policy-codes.md) | The versioning policy of an artifact (metadata, strict, loose, package) |
| [Audit Event ID](CodeSystem-audit-event-type.md) | Event Types for Audit Events - defined by DICOM with some FHIR specific additions. |
| [Audit Event Source Type](CodeSystem-security-source-type.md) | The type of process where the audit event originated from. |
| [Audit event entity type](CodeSystem-audit-entity-type.md) | Code for the entity type involved in the audit event. |
| [AuditEventEntityRole](CodeSystem-object-role.md) | Code representing the role the entity played in the audit event. |
| [AuditEventOutcome](CodeSystem-audit-event-outcome.md) | Indicates whether the event succeeded or failed. |
| [Basic Resource Types](CodeSystem-basic-resource-type.md) | This value set defines codes for resources not yet supported by (or which will never be supported by) FHIR. Many of the codes listed here will eventually be turned into official resources. However, there is no guarantee that any particular resource will be created nor that the scope will be exactly as defined by the codes presented here. Codes in this set will be deprecated if/when formal resources are defined that encompass these concepts. |
| [Benefit Category Codes](CodeSystem-ex-benefitcategory.md) | This value set includes examples of Benefit Category codes. |
| [Benefit Term Codes](CodeSystem-benefit-term.md) | This value set includes a smattering of Benefit Term codes. |
| [Benefit Type Codes](CodeSystem-benefit-type.md) | This value set includes a smattering of Benefit type codes. |
| [Benefit cost applicability](CodeSystem-applicability.md) | Whether the cost applies to in-network or out-of-network providers. |
| [CDS Hooks Card Types](CodeSystem-cdshooks-card-type.md) | Codes defining types of cards that can potentially be returned by a decision support service. The initial set of codes is biased towards those related to insurance coverage, but all types of response types are acceptable in the code system. |
| [CDS Hooks Indicator](CodeSystem-cdshooks-indicator.md) | This codesystem captures the indicator codes defined by the CDS Hooks specification. The indicator is included as an element of the cards in a CDS Hooks response and conveys the urgency and/or importance of the information in each card. See[Card Attributes](https://cds-hooks.hl7.org/1.0/#card-attributes)in the CDS Hooks specification for more information. Note - the CodeSystem is transitioning from the Vocabulary Work Group to Clinical Decision Support (CDS) Work Group. |
| [CMS Place of Service Codes (POS)](CodeSystem-CMSPlaceofServiceCodes.md) | Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry. This code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider. |
| [CMS Present on Admission (POA) Indicator](CodeSystem-presentOnAdmission.md) | This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission. |
| [CQL Access Modifier](CodeSystem-cql-access-modifier.md) | Access modifiers defined by the Clinical Quality Language (CQL) specification in the[Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers)topic. |
| [CRD Coverage Detail Codes](CodeSystem-crd-coverage-detail.md) | Codes that describe additional details related to a coverage information assertion. These live in THO rather than the CRD specification to support adding additional concepts without putting out a new CRD release. |
| [Calendar](CodeSystem-v3-Calendar.md) | Code system for specifying a type of calendar |
| [Calendar Cycle Codes](CodeSystem-v3-CalendarCycle.md) | Calendar cycle identifiers |
| [CalendarType](CodeSystem-v3-CalendarType.md) | Code system for specifying a type of calendar |
| [Can-push-updates](CodeSystem-can-push-updates.md) | Ability of the primary source to push updates/alerts |
| [Care Service Accessibility](CodeSystem-care-service-accessibility.md) | This code system defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location. |
| [CatalogType](CodeSystem-catalogType.md) | The type of catalog. |
| [CharacteristicMethod](CodeSystem-characteristic-method.md) | The method used to determine the characteristic(s) of the variable. |
| [ChargeItemCode](CodeSystem-chargeitem-billingcodes.md) | Example set of codes that can be used for billing purposes. |
| [Charset](CodeSystem-v3-Charset.md) | Internet Assigned Numbers Authority (IANA) Charset Types |
| [ChoiceListOrientation](CodeSystem-choice-list-orientation.md) | Direction in which lists of possible answers should be displayed. |
| [Citation Artifact Classifier](CodeSystem-citation-artifact-classifier.md) | Citation artifact classifier |
| [Citation Classification Type](CodeSystem-citation-classification-type.md) | Citation classification type |
| [Citation Summary Style](CodeSystem-citation-summary-style.md) | The format for display of the citation. |
| [Cited Artifact Abstract Type](CodeSystem-cited-artifact-abstract-type.md) | Used to express the reason and specific aspect for the variant abstract, such as language and specific language |
| [Cited Artifact Classification Type](CodeSystem-cited-artifact-classification-type.md) | Cited Artifact Classification Type |
| [Cited Artifact Contribution Type](CodeSystem-cited-artifact-contribution-type.md) | Citation contribution. |
| [Cited Artifact Part Type](CodeSystem-cited-artifact-part-type.md) | To describe the reason for the variant citation, such as version number or subpart specification. |
| [Cited Artifact Status Type](CodeSystem-cited-artifact-status-type.md) | Cited Artifact Status Type |
| [Cited Medium](CodeSystem-cited-medium.md) | NLM codes Internet or Print. |
| [Claim Care Team Role Codes](CodeSystem-claimcareteamrole.md) | Claim roles of the care team members providing products and services. |
| [Claim Information Category Codes](CodeSystem-claiminformationcategory.md) | This value set includes sample Information Category codes. |
| [Claim Type Codes](CodeSystem-claim-type.md) | This value set includes Claim Type codes. |
| [ClaimPayeeResourceType](CodeSystem-ex-payee-resource-type.md) | The type of Claim payee Resource. |
| [CodeSystem](CodeSystem-v3-CodeSystem.md) | Code systems used in HL7 standards. |
| [CodingRationale](CodeSystem-v3-CodingRationale.md) | Identifies how to interpret the instance of the code, codeSystem value in a set of translations. Since HL7 (or a government body) may mandate that codes from certain code systems be sent in conformant messages, other synonyms that are sent in the translation set need to be distinguished among the originally captured source, the HL7 specified code, or some future role. When this code is NULL, it indicates that the translation is an undefined type. When valued, this property must contain one of the following values: SRC - Source (or original) code HL7 - HL7 Specified or Mandated SH - both HL7 mandated and the original code (precoordination) There may be additional values added to this value set as we work through the use of codes in messages and determine other Use Cases requiring special interpretation of the translations. |
| [Common Tags](CodeSystem-common-tags.md) | Common Tag Codes defined by FHIR project |
| [CommunicationCategory](CodeSystem-communication-category.md) | Codes for general categories of communications such as alerts, instructions, etc. |
| [CommunicationFunctionType](CodeSystem-v3-CommunicationFunctionType.md) | Describes the type of communication function that the associated entity plays in the associated transmission. |
| [CommunicationNotDoneReason](CodeSystem-communication-not-done-reason.md) | Codes for the reason why a communication did not happen. |
| [CommunicationTopic](CodeSystem-communication-topic.md) | Codes describing the purpose or content of the communication. |
| [CompositeMeasureScoring](CodeSystem-composite-measure-scoring.md) | The composite scoring method of the measure. |
| [CompressionAlgorithm](CodeSystem-v3-CompressionAlgorithm.md) | Type of compression algorithm used |
| [Concept Domains](CodeSystem-conceptdomains.md) | Concept Domains - includes both v2 abd v3 concept domains |
| [ConceptGenerality](CodeSystem-v3-ConceptGenerality.md) | Indicates whether the concept that is the target should be interpreted as itself, or whether it should be expanded to include its child concepts, or both when it is included in the source domain/valueset.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [Condition Category Codes](CodeSystem-condition-category.md) | Preferred value set for Condition Categories. |
| [Condition Clinical Status Codes](CodeSystem-condition-clinical.md) | Preferred value set for Condition Clinical Status. |
| [ConditionState](CodeSystem-condition-state.md) | Enumeration indicating whether the condition is currently active, inactive, or has been resolved. |
| [ConditionVerificationStatus](CodeSystem-condition-ver-status.md) | The verification status to support or decline the clinical status of the condition or diagnosis. |
| [Confidentiality](CodeSystem-v3-Confidentiality.md) | A set of codes specifying the security classification of acts and roles in accordance with the definition for concept domain "Confidentiality". |
| [ConformanceExpectation](CodeSystem-conformance-expectation.md) | Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification. |
| [Consent Action Codes](CodeSystem-consentaction.md) | This value set includes sample Consent Action codes. |
| [Consent Category Codes](CodeSystem-consentcategorycodes.md) | This value set includes sample Consent Directive Type codes, including several consent directive related LOINC codes; HL7 VALUE SET: ActConsentType(2.16.840.1.113883.1.11.19897); examples of US realm consent directive legal descriptions and references to online and/or downloadable forms such as the SSA-827 Authorization to Disclose Information to the Social Security Administration; and other anticipated consent directives related to participation in a clinical trial, medical procedures, reproductive procedures; health care directive (Living Will); advance directive, do not resuscitate (DNR); Physician Orders for Life-Sustaining Treatment (POLST) |
| [Consent PolicyRule Codes](CodeSystem-consentpolicycodes.md) | This value set includes sample Regulatory consent policy types from the US and other regions. |
| [Consent Scope Codes](CodeSystem-consentscope.md) | This value set includes the four Consent scope codes. |
| [Consent Verification Codes](CodeSystem-consentverification.md) | This value set includes base Consent Verification codes. |
| [Contact entity type](CodeSystem-contactentity-type.md) | This example value set defines a set of codes that can be used to indicate the purpose for which you would contact a contact party. |
| [ContainerCap](CodeSystem-container-cap.md) | Color of the container cap. |
| [ContainerCap](CodeSystem-v3-ContainerCap.md) | The type of cap associated with a container |
| [ContainerSeparator](CodeSystem-v3-ContainerSeparator.md) | A material in a blood collection container that facilites the separation of of blood cells from serum or plasma |
| [ContentProcessingMode](CodeSystem-v3-ContentProcessingMode.md) | **Description:**Identifies the order in which content should be processed. |
| [ContextControl](CodeSystem-v3-ContextControl.md) | A code that specifies how an ActRelationship or Participation contributes to the context of an Act, and whether it may be propagated to descendent Acts whose association allows such propagation (see also attributes Participation.contextControlCode, ActRelationship.contextControlCode, ActRelationship.contextConductionInd). |
| [Contract Action Codes](CodeSystem-contractaction.md) | This value set includes sample Contract Action codes. |
| [Contract Actor Role Codes](CodeSystem-contractactorrole.md) | This value set includes sample Contract Actor Role codes. |
| [Contract Content Derivation Codes](CodeSystem-contract-content-derivative.md) | This is an example set of Content Derivative type codes, which represent the minimal content derived from the basal information source at a specific stage in its lifecycle, which is sufficient to manage that source information, for example, in a repository, registry, processes and workflows, for making access control decisions, and providing query responses. |
| [Contract Signer Type Codes](CodeSystem-contractsignertypecodes.md) | This value set includes sample Contract Signer Type codes. |
| [Contract Subtype Codes](CodeSystem-contractsubtypecodes.md) | This value set includes sample Contract Subtype codes. |
| [Contract Term Subtype Codes](CodeSystem-contracttermsubtypecodes.md) | This value set includes sample Contract Term SubType codes. |
| [Contract Term Type Codes](CodeSystem-contracttermtypecodes.md) | This value set includes sample Contract Term Type codes. |
| [Contract Type Codes](CodeSystem-contract-type.md) | This value set includes sample Contract Type codes. |
| [ContractDataMeaning](CodeSystem-contract-data-meaning.md) | How a resource reference is interpreted when evaluating contract offers. |
| [Contributor Role](CodeSystem-contributor-role.md) | Used to code the format of the display string. |
| [Contributor Summary Source](CodeSystem-contributor-summary-source.md) | Used to code the producer or rule for creating the display string. |
| [Contributor Summary Style](CodeSystem-contributor-summary-style.md) | Used to code the format of the display string. |
| [Contributor Summary Type](CodeSystem-contributor-summary-type.md) | Used to code author list statement, contributorship statement, and such. |
| [CopyNumberEvent](CodeSystem-copy-number-event.md) | Copy Number Event. |
| [Country](CodeSystem-v3-Country.md) | The territory of a sovereign nation. Note that this has been deprecated in favor of using the ISO 3166 Country codes - 1.0.3166.1 iso3166-1 |
| [Coverage Class Codes](CodeSystem-coverage-class.md) | This value set includes Coverage Class codes. |
| [Coverage Copay Type Codes](CodeSystem-coverage-copay-type.md) | This value set includes sample Coverage Copayment Type codes. |
| [Coverage SelfPay Codes](CodeSystem-coverage-selfpay.md) | This value set includes Coverage SelfPay codes. |
| [CoverageEligibilityResponse Auth Support Codes](CodeSystem-coverageeligibilityresponse-ex-auth-support.md) | This value set includes CoverageEligibilityResponse Auth Support codes. |
| [Currency](CodeSystem-v3-Currency.md) | The currency unit as defined in ISO 4217. Created prior to ISO ruling on OIDs for ISO code tables defined in ISO standards. Retired. Replaced by 1.0.4217 iso4217. |
| [DICOM Audit Message Record Lifecycle Events](CodeSystem-dicom-audit-lifecycle.md) | Attached is vocabulary for the record lifecycle events, as per DICOM Audit Message, |
| [DataAbsentReason](CodeSystem-data-absent-reason.md) | Used to specify why the normally expected content of the data element is missing. |
| [DataOperation](CodeSystem-v3-DataOperation.md) | **** MISSING DESCRIPTION **** |
| [DataType](CodeSystem-v3-DataType.md) | Code system retired. |
| [DefinitionStatus](CodeSystem-definition-status.md) | Codes identifying the lifecycle stage of a definition. |
| [DefinitionTopic](CodeSystem-definition-topic.md) | High-level categorization of the definition, used for searching, sorting, and filtering. |
| [Dentition](CodeSystem-v3-Dentition.md) | **** MISSING DESCRIPTION **** |
| [Device Alert Activation State](CodeSystem-devicealert-activationState.md) | Describes the activation state of a DeviceAlert. |
| [Device Alert Priority](CodeSystem-devicealert-priority.md) | Describes the priority of a DeviceAlert. |
| [DeviceAlertLevel](CodeSystem-v3-DeviceAlertLevel.md) | Domain values for the Device.Alert_levelCode |
| [DeviceAssociation Relationship Codes](CodeSystem-deviceassociation-relationship.md) | DeviceAssociation Relationship Codes |
| [DeviceAssociation Status Reason Codes](CodeSystem-deviceassociation-status-reason.md) | DeviceAssociation Status Reason Codes |
| [DeviceDefinitionParameterGroup](CodeSystem-parameter-group.md) | Codes identifying groupings of parameters; e.g. Cardiovascular. |
| [Diagnosis Role](CodeSystem-diagnosis-role.md) | This value set defines a set of codes that can be used to express the role of a diagnosis on the Encounter or EpisodeOfCare record. |
| [Diagnosis Type Codes](CodeSystem-diagnosistype.md) | This value set includes Diagnosis Type codes. |
| [Diet](CodeSystem-diet.md) | This value set defines a set of codes that can be used to indicate dietary preferences or restrictions a patient may have. |
| [Digital Media Category](CodeSystem-media-category.md) | Codes for high level media types - whether the media is an image, video, or audio. |
| [Discharge disposition](CodeSystem-discharge-disposition.md) | This value set defines a set of codes that can be used to where the patient left the hospital. |
| [DocumentCompletion](CodeSystem-v3-DocumentCompletion.md) | Identifies the current completion state of a clinical document. |
| [DocumentStorage](CodeSystem-v3-DocumentStorage.md) | Identifies the storage status of a document. |
| [DoseAndRateType](CodeSystem-dose-rate-type.md) | The kind of dose or rate specified. |
| [EditStatus](CodeSystem-v3-EditStatus.md) | The status of an entry as it pertains to its review and incorporation into the HL7 domain specification database. |
| [Education Level](CodeSystem-v3-EducationLevel.md) | Years of education that a person has completed |
| [EmployeeJobClass](CodeSystem-v3-EmployeeJobClass.md) | A code qualifying the employment in various ways, such as, full-time vs. part time, etc. |
| [Encounter Acuity](CodeSystem-v3-EncounterAcuity.md) | The level of resource intensiveness of patient care.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. No content. |
| [Encounter subject status](CodeSystem-encounter-subject-status.md) | This example value set defines a set of codes that can be used to indicate the status of the subject within the encounter |
| [Encounter type](CodeSystem-encounter-type.md) | This example value set defines a set of codes that can be used to indicate the type of encounter: a specific code indicating type of service provided. |
| [EncounterAccident](CodeSystem-v3-EncounterAccident.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. No content. |
| [EncounterAdmissionSource](CodeSystem-v3-EncounterAdmissionSource.md) | **** MISSING DESCRIPTION **** |
| [EncounterReferralSource](CodeSystem-v3-EncounterReferralSource.md) | This domain is defined in UB92 and applies to US realm only**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. We've deprecated all of the codes. |
| [EncounterSpecialCourtesy](CodeSystem-v3-EncounterSpecialCourtesy.md) | **** MISSING DESCRIPTION **** |
| [Endpoint Connection Type](CodeSystem-endpoint-connection-type.md) | This is an example value set defined by the FHIR project, that could be used to represent possible connection type profile values. |
| [Endpoint Payload Type](CodeSystem-endpoint-payload-type.md) | This is an example value set defined by the FHIR project, that could be used to represent possible payload document types. |
| [Enteral Formula Additive Type Code](CodeSystem-entformula-additive.md) | EnteralFormulaAdditiveType: Codes for the type of modular component such as protein, carbohydrate or fiber to be provided in addition to or mixed with the base formula. This value set is provided as a suggestive example. |
| [EntityClass](CodeSystem-v3-EntityClass.md) | Classifies the Entity class and all of its subclasses. The terminology is hierarchical. At the top is this HL7-defined domain of high-level categories (such as represented by the Entity subclasses). Each of these terms must be harmonized and is specializable. The value sets beneath are drawn from multiple, frequently external, domains that reflect much more fine-grained typing. |
| [EntityCode](CodeSystem-v3-EntityCode.md) | **OpenIssue:**Missing description. |
| [EntityDeterminer](CodeSystem-v3-EntityDeterminer.md) | EntityDeterminer in natural language grammar is the class of words that comprises articles, demonstrative pronouns, and quantifiers. In the RIM, determiner is a structural code in the Entity class to distinguish whether any given Entity object stands for some, any one, or a specific thing. |
| [EntityHandling](CodeSystem-v3-EntityHandling.md) | Special handling requirements for an Entity.**Example:**Keep at room temperature; Keep frozen below 0 C; Keep in a dry environment; Keep upright, do not turn upside down. |
| [EntityNamePartQualifier](CodeSystem-v3-EntityNamePartQualifier.md) | **OpenIssue:**Needs description |
| [EntityNamePartQualifierR2](CodeSystem-v3-EntityNamePartQualifierR2.md) | **Description:**The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records. |
| [EntityNamePartType](CodeSystem-v3-EntityNamePartType.md) | **** MISSING DESCRIPTION **** |
| [EntityNamePartTypeR2](CodeSystem-v3-EntityNamePartTypeR2.md) | **Description:**Indicates whether the name part is a given name, family name, prefix, suffix, etc. |
| [EntityNameUse](CodeSystem-v3-EntityNameUse.md) | **** MISSING DESCRIPTION **** |
| [EntityNameUseR2](CodeSystem-v3-EntityNameUseR2.md) | **Description:**A set of codes advising a system or user which name in a set of names to select for a given purpose. |
| [EntityRisk](CodeSystem-v3-EntityRisk.md) | Kinds of risks associated with the handling of the material.. |
| [EntityStatus](CodeSystem-v3-EntityStatus.md) | Codes representing the defined possible states of an Entity, as defined by the Entity class state machine. |
| [Episode of care type](CodeSystem-episodeofcare-type.md) | This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record. |
| [EquipmentAlertLevel](CodeSystem-v3-EquipmentAlertLevel.md) | **** MISSING DESCRIPTION **** |
| [Ethnicity](CodeSystem-v3-Ethnicity.md) | **Deprecation Information:**Deprecated due to UP-265. This code system in NOT the acknowledged source of truth for Ethnicity concepts and codes. It should no longer be used. https://terminology.hl7.org/CodeSystem-CDCREC.html should be used in its place. In the United States, federal standards for classifying data on ethnicity determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define ethnicity, and they recognize the absence of an anthropological or scientific basis for ethnicity classification. Instead, the federal standards acknowledge that ethnicity is a social-political construct in which an individual's own identification with a particular ethnicity is preferred to observer identification. The standards specify two minimum ethnicity categories: Hispanic or Latino, and Not Hispanic or Latino. The standards define a Hispanic or Latino as a person of "Mexican, Puerto Rican, Cuban, South or Central America, or other Spanish culture or origin, regardless of race." The standards stipulate that ethnicity data need not be limited to the two minimum categories, but any expansion must be collapsible to those categories. In addition, the standards stipulate that an individual can be Hispanic or Latino or can be Not Hispanic or Latino, but cannot be both. |
| [Evidence Certainty Type](CodeSystem-certainty-type.md) | The aspect of quality, confidence, or certainty. |
| [EvidenceDirectness](CodeSystem-directness.md) | The quality of how direct the match is. |
| [EvidenceVariableRole](CodeSystem-variable-role.md) | **Deprecation Information:**This CodeSystem/ValueSet was used in FHIR R5 for a CodeableConcept binding that was changed to a code binding in FHIR R6. The replacement CodeSystem/ValueSet is http://hl7.org/fhir/variable-role and http://hl7.org/fhir/ValueSet/variable-role. |
| [EvidenceVariableRoleSubtype](CodeSystem-variable-role-subtype.md) | The subclassification of the role that the assertion variable plays. |
| [Example Claim SubType Codes](CodeSystem-ex-claimsubtype.md) | This value set includes sample Claim SubType codes which are used to distinguish the claim types for example within type institutional there may be subtypes for emergency services, bed stay and transportation. |
| [Example Coverage Financial Exception Codes](CodeSystem-ex-coverage-financial-exception.md) | This value set includes Example Coverage Financial Exception Codes. |
| [Example Diagnosis Related Group Codes](CodeSystem-ex-diagnosisrelatedgroup.md) | This value set includes example Diagnosis Related Group codes. |
| [Example Diagnosis Type Codes](CodeSystem-ex-diagnosistype.md) | This value set includes example Diagnosis Type codes. |
| [Example Diagnosis on Admission Codes](CodeSystem-ex-diagnosis-on-admission.md) | This value set includes example Diagnosis on Admission codes. |
| [Example Message Reason Codes](CodeSystem-message-reasons-encounter.md) | Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update. |
| [Example Payment Type Codes](CodeSystem-ex-paymenttype.md) | This value set includes example Payment Type codes. |
| [Example Procedure Type Codes](CodeSystem-ex-procedure-type.md) | This value set includes example Procedure Type codes. |
| [Example Program Reason Codes](CodeSystem-ex-programcode.md) | This value set includes sample Program Reason Span codes. |
| [Example Provider Qualification Codes](CodeSystem-ex-providerqualification.md) | This value set includes sample Provider Qualification codes. |
| [Example Related Claim Relationship Codes](CodeSystem-ex-relatedclaimrelationship.md) | This value set includes sample Related Claim Relationship codes. |
| [Example Revenue Center Codes](CodeSystem-ex-revenue-center.md) | This value set includes sample Revenue Center codes. |
| [Example Service Place Codes](CodeSystem-ex-serviceplace.md) | This value set includes a smattering of Service Place codes. |
| [Example Use Codes for List](CodeSystem-list-example-use-codes.md) | Example use codes for the List resource - typical kinds of use. |
| [Example Vision Prescription Product Codes](CodeSystem-ex-visionprescriptionproduct.md) | This value set includes a smattering of Prescription Product codes. |
| [Exception Codes](CodeSystem-claim-exception.md) | This value set includes sample Exception codes. |
| [ExpansionParameterSource](CodeSystem-expansion-parameter-source.md) | Declares what the source of a parameter is. |
| [ExpansionProcessingRule](CodeSystem-expansion-processing-rule.md) | Defines how concepts are processed into the expansion when it's for UI presentation. |
| [ExposureMode](CodeSystem-v3-ExposureMode.md) | Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure. |
| [FHIRDeviceStatusReason](CodeSystem-device-status-reason.md) | The availability status reason of the device. |
| [Failure-action](CodeSystem-failure-action.md) | The result if validation fails |
| [FamilyHistoryAbsentReason](CodeSystem-history-absent-reason.md) | Codes describing the reason why a family member's history is not available. |
| [Financial Task Codes](CodeSystem-financialtaskcode.md) | This value set includes Financial Task codes. |
| [Financial Task Input Type Codes](CodeSystem-financialtaskinputtype.md) | This value set includes Financial Task Input Type codes. |
| [Flag Category](CodeSystem-flag-category.md) | Example list of general categories for flagged issues. (Not complete or necessarily appropriate.) |
| [Form Codes](CodeSystem-forms-codes.md) | This value set includes a sample set of Forms codes. |
| [Funds Reservation Codes](CodeSystem-fundsreserve.md) | This value set includes sample funds reservation type codes. |
| [GTSAbbreviation](CodeSystem-v3-GTSAbbreviation.md) | **Open Issue:**It appears that the printnames are suboptimal and should be improved for many of the existing codes. |
| [GenderStatus](CodeSystem-v3-GenderStatus.md) | A value representing whether the primary reproductive organs of NonPersonLivingSubject are present. |
| [Goal achievement status](CodeSystem-goal-achievement.md) | Describes the progression, or lack thereof, towards the goal against the target. |
| [Goal category](CodeSystem-goal-category.md) | Codes for grouping goals to use for filtering or presentation. |
| [Goal priority](CodeSystem-goal-priority.md) | Indicates the level of importance associated with reaching or sustaining a goal. |
| [GoalAcceptanceStatus](CodeSystem-goal-acceptance-status.md) | Codes indicating whether the goal has been accepted by a stakeholder. |
| [GoalRelationshipType](CodeSystem-goal-relationship-type.md) | Types of relationships between two goals. |
| [Group Code](CodeSystem-group-code.md) | A code that describes the use of the group. The use of the group usually dictates what kind of entities can be members of the group. |
| [GuideParameterCode](CodeSystem-guide-parameter-code.md) | Code of parameter that is input to the guide. |
| [HL7 Code System Type](CodeSystem-v3-CodeSystemType.md) | Retired code system for HL7 Code System Types. This description added to conform to shareable codesystem profile |
| [HL7 Coded Concept Status](CodeSystem-v3-ConceptStatus.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [HL7 Document Format Codes](CodeSystem-v3-HL7DocumentFormatCodes.md) | This codeSystem contains codes which specify the technical format of a document. Each code provides sufficient information to allow any potential document consumer to know if it will be able to process the document. The codes are sufficiently specific to ensure processing/display by identifying a document encoding, structure and template. For example, formatCodes can be used in the FHIR DocumentReference resource to characterize the document being referenced. |
| [HL7 ITS Version Code](CodeSystem-v3-hl7ITSVersionCode.md) | HL7 implementation technology specification versions. These codes will document the ITS type and version for message encoding. The code will appear in the instances based upon rules expressed in the ITS, and do not appear in the abstract message, either as it is presented to received from the ITS. |
| [HL7 Terminology Maintenance Infrastructure Vocabulary](CodeSystem-hl7TermMaintInfra.md) | Codes that may have been strings or other types of data in pre-existing tooling for V3 and V2 terminology maintenance, and moved to codes in this code system for proper handling in the FHIR based UTG maintenance facilities. |
| [HL7 Value Set and Coded Concept Property Codes](CodeSystem-v3-ConceptProperty.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [HL7ApprovalStatus](CodeSystem-v3-hl7ApprovalStatus.md) | **Description:**Codes for concepts describing the approval level of HL7 artifacts. This code system reflects the concepts expressed in HL7's Governance & Operations Manual (GOM) past and present. |
| [HL7CMETAttribution](CodeSystem-v3-hl7CMETAttribution.md) | **** MISSING DEFINITIONS **** |
| [HL7CommitteeIDInRIM](CodeSystem-v3-HL7CommitteeIDInRIM.md) | Holds the codes used to identify the committees and SIGS of HL7 in RIM repository tables.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [HL7ConformanceInclusion](CodeSystem-v3-HL7ConformanceInclusion.md) | These concepts represent theconformance requirments defined for including or valuing an element of an HL7 message. The concepts apply equally to conformance profiles defined for Version 2.x messgaes as defined by the Conformance SIG, and to the conformance columns for Version 3 messages as specified in the HMD.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [HL7ContextConductionStyle](CodeSystem-v3-HL7ContextConductionStyle.md) | The styles of context conduction usable by relationships within a static model derived from tyhe HL7 Reference Information Model. |
| [HL7DefinedRoseProperty](CodeSystem-v3-HL7DefinedRoseProperty.md) | The property Ids that HL7 has defined for customizing Rational Rose.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [HL7ITSType](CodeSystem-v3-hl7ITSType.md) | **Description:**Codes identifying types of HL7 Implementation Technology Specifications |
| [HL7PublishingDomain](CodeSystem-v3-hl7PublishingDomain.md) | **Description:**Codes for HL7 publishing domains (specific content area) |
| [HL7PublishingSection](CodeSystem-v3-hl7PublishingSection.md) | **Description:**Codes for HL7 publishing sections (major business categories) |
| [HL7PublishingSubSection](CodeSystem-v3-hl7PublishingSubSection.md) | **Description:**Codes for HL7 publishing sub-sections (business sub-categories) |
| [HL7Realm](CodeSystem-v3-hl7Realm.md) | **Description:**Coded concepts representing Binding Realms (used for Context Binding of terminology in HL7 models) and/or Namespace Realms (used to help ensure unique identification of HL7 artifacts). This code system is partitioned into three sections: Affiliate realms, Binding realms and Namespace realms. All affiliate realm codes may automatically be used as both binding realms and namespace realms. Furthermore, affiliate realms are the only realms that have authority over the creation of binding realms. (Note that 'affiliate' includes the idea of both international affiliates and the HL7 International organization.) All other codes must be associated with an owning affiliate realm and must appear as a specialization of _BindingRealm or _NamespaceRealm. For affiliates whose concepts align with nations, the country codes from ISO 3166-1 2-character alpha are used for the code when possible so these codes should not be used for other realm types. It is recommended that binding realm and namespace codes submitted by affiliates use the realm code as a prefix to avoid possible collisions with ISO codes. However, tooling does not currently support namepace realm codes greater than 2 characters.**Open Issue:**The name of the concept property "owningAffiliate" should be changed to better reflect that the property value is the human readable name of the organizational entity that manages the Realm identified by the Realm Code.**Open Issue:**In spite of the inability of tooling to process codes longer than 2 characters, there is at least one realm codes ('SOA') that was added that is 3 characters in length. |
| [HL7StandardVersionCode](CodeSystem-v3-HL7StandardVersionCode.md) | This code system holds version codes for the Version 3 standards. Values are to be determined by HL7 and added with each new version of the HL7 Standard. |
| [HL7UpdateMode](CodeSystem-v3-HL7UpdateMode.md) | The possible modes of updating that occur when an attribute is received by a system that already contains values for that attribute. |
| [HL7V3Conformance](CodeSystem-v3-hl7V3Conformance.md) | **Description:**Identifies allowed codes for HL7aTMs v3 conformance property. |
| [HL7VoteResolution](CodeSystem-v3-hl7VoteResolution.md) | **Description:**Based on concepts for resolutions from HL7 ballot spreadsheet according to HL7's Governance & Operations Manual (GOM). |
| [HL7Workgroup](CodeSystem-hl7-work-group.md) | An HL7 administrative unit that owns artifacts in the FHIR specification. |
| [HandlingConditionSet](CodeSystem-handling-condition.md) | Set of handling instructions prior testing of the specimen. |
| [Healthcare Provider Taxonomy HIPAA](CodeSystem-v3-HealthcareProviderTaxonomyHIPAA.md) | NUCC Healthcare Provider Taxonomy codes, as cited in US HIPAA regulations. This HL7 copy of the content is made available by request of various HL7 Affiliates,so do have have direect access to the NUCC contnet as they are outside the US. In additions, some concept have been added to this set that are pending being added to the NUCC master. |
| [HtmlLinkType](CodeSystem-v3-HtmlLinkType.md) | HtmlLinkType values are drawn from HTML 4.0 and describe the relationship between the current document and the anchor that is the target of the link |
| [HumanNameAssemblyOrder](CodeSystem-name-assembly-order.md) | A code that represents the preferred display order of the components of a human name. |
| [ISO 21089 2017 Health Record Lifecycle Events](CodeSystem-iso-21089-lifecycle.md) | Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informatics - Trusted End-to-End Information Flows, Section 3, Terms and Definitions (2017, at ISO Central Secretariat, passed ballot and ready for publication). This will also be included in the FHIR EHR Record Lifecycle Event Implementation Guide, balloted and (to be) published with FHIR STU-3. |
| [ISO 3166 2 Character Country Codes](CodeSystem-v3-ISO3166-1retired.md) | Two character country codes Note that this OID was erroneously entered into HL7 some years ago, and has recently been replaced by 1.0.3166.1 at the request of ISO. |
| [ISO 3166 3 Character Country Codes](CodeSystem-v3-ISO3166-2retired.md) | Three character country codes Note that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.3 at the request of ISO. |
| [ISO 3166 Numeric country Codes](CodeSystem-v3-ISO3166-3retired.md) | Numeric country codes Note that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.1 at the request of ISO. |
| [ISO 4217 Currency code, HL7 use](CodeSystem-v3-iso4217-HL7.md) | ISO 4217 currency code Created prior to ISO ruling on OIDs for ISO code tables defined in ISO standards. Recommend using 1.0.4217 iso4217 code system instead. |
| [IdentifierReliability](CodeSystem-v3-IdentifierReliability.md) | Specifies the reliability with which the identifier is known. This attribute MAY be used to assist with identifier matching algorithms. |
| [IdentifierScope](CodeSystem-v3-IdentifierScope.md) | **Description:**Codes to specify the scope in which the identifier applies to the object with which it is associated, and used in the datatype property II. |
| [Immunization Evaluation Dose Status Reason codes](CodeSystem-immunization-evaluation-dose-status-reason.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example. |
| [Immunization Evaluation Dose Status codes](CodeSystem-immunization-evaluation-dose-status.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example. |
| [Immunization Funding Source](CodeSystem-immunization-funding-source.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the vaccine administered. This value set is provided as a suggestive example. |
| [Immunization Origin Codes](CodeSystem-immunization-origin.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the source of the data when the report of the immunization event is not based on information from the person, entity or organization who administered the vaccine. This value set is provided as a suggestive example. |
| [Immunization Program Eligibility](CodeSystem-immunization-program-eligibility.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the patient's eligibility for a vaccination program. This value set is provided as a suggestive example. |
| [Immunization Recommendation Status Codes](CodeSystem-immunization-recommendation-status.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the status of the patient towards perceived immunity against a vaccine preventable disease. This value set is provided as a suggestive example. |
| [Immunization Subpotent Reason](CodeSystem-immunization-subpotent-reason.md) | The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why a dose is considered to be subpotent. This value set is provided as a suggestive example. |
| [Implant Status](CodeSystem-implantStatus.md) | A set codes that define the functional status of an implanted device. |
| [Insurance Coverage Type](CodeSystem-insurance-coverage-type.md) | This code system defines a set of codes for Insurance CoverageType. |
| [Insurance Product Type](CodeSystem-insurance-product-type.md) | This code system defines a set of codes for Insurance Product Type. |
| [Insurance plan type](CodeSystem-insurance-plan-type.md) | This example value set defines a set of codes that can be used to indicate a type of insurance plan. |
| [Insuranceplan Plan Type](CodeSystem-insuranceplan-plan-type.md) | This code system defines a set of codes for Insuranceplan Plan Type. |
| [IntegrityCheckAlgorithm](CodeSystem-v3-IntegrityCheckAlgorithm.md) | **** MISSING DESCRIPTION **** |
| [Interagency Language Roundtable Speaking Skill Scale](CodeSystem-ILRSpeakingSkillScale.md) | The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale. Control of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary. There are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level. The SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience. The SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills. For more information, including the source content, please see[https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm). |
| [LanguageAbilityMode](CodeSystem-v3-LanguageAbilityMode.md) | A value representing the method of expression of the language.**Example:**Expressed spoken, expressed written, expressed signed, received spoken, received written, received signed.**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. |
| [LanguageAbilityProficiency](CodeSystem-v3-LanguageAbilityProficiency.md) | A value representing the level of proficiency in a language.**Example:**Excellent, good, fair, poor.**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. |
| [LibraryType](CodeSystem-library-type.md) | The type of knowledge asset this library contains. |
| [List Empty Reasons](CodeSystem-list-empty-reason.md) | General reasons for a list to be empty. Reasons are either related to a summary list (i.e. problem or medication list) or to a workflow related list (i.e. consultation list). |
| [List Order Codes](CodeSystem-list-order.md) | Base values for the order of item lists in resources. |
| [LivingArrangement](CodeSystem-v3-LivingArrangement.md) | A code depicting the living arrangements of a person |
| [LocalMarkupIgnore](CodeSystem-v3-LocalMarkupIgnore.md) | Tells a receiver to ignore just the local markup tags (local_markup, local_header, local_attr) when value="markup", or to ignore the local markup tags and all contained content when value="all" |
| [LocalRemoteControlState](CodeSystem-v3-LocalRemoteControlState.md) | A value representing the current state of control associated with the device.**Examples:**A device can either work autonomously (localRemoteControlStateCode="Local") or it can be controlled by another system (localRemoteControlStateCode="Remote").**Rationale:**The control status of a device must be communicated between devices prior to remote commands being transmitted. If the device is not in "Remote" status then external commands will be ignored. |
| [Location type](CodeSystem-location-physical-type.md) | This example value set defines a set of codes that can be used to indicate the physical form of the Location. This includes several 'non physical' codes which are still considered a location. |
| [MDFAttributeType](CodeSystem-v3-MDFAttributeType.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [MDFSubjectAreaPrefix](CodeSystem-v3-MDFSubjectAreaPrefix.md) | The standard prefixes used in Rose for RIM subject areas that determine the role or function of each subject area.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [ManagedParticipationStatus](CodeSystem-v3-ManagedParticipationStatus.md) | Codes representing the defined possible states of a Managed Participation, as defined by the Managed Participation class state machine. |
| [ManufacturerModelNameExample](CodeSystem-v3-ManufacturerModelNameExample.md) | This code system serves to capture the ManufacturerModelName concept domain used to convey a coded name for a device. |
| [MapRelationship](CodeSystem-v3-MapRelationship.md) | The closeness or quality of the mapping between the HL7 concept (as represented by the HL7 concept identifier) and the source coding system. The values are patterned after the similar relationships used in the UMLS Metathesaurus. Because the HL7 coding sy |
| [MaritalStatus](CodeSystem-v3-MaritalStatus.md) | * * * No description supplied * * ***Open Issue:**The specific meanings of these codes can vary somewhat by jurisdiction and implementation so caution should be used when determining equivalency.**Open Issue:**fixing and completion of the hierarchy and proper good definitions of all the concepts is badly needed. |
| [MatchGrade](CodeSystem-match-grade.md) | A Master Patient Index (MPI) assessment of whether a candidate patient record is a match or not. |
| [MaterialForm](CodeSystem-v3-MaterialForm.md) | A value representing the state (solid, liquid, gas) and nature of the material.**Open Issue:**There exist no codes in the repository for this coding system; should it be removed? |
| [MaterialType](CodeSystem-v3-MaterialType.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is outside the hierarchy and there's already an equivalent domain MaterialEntityClass in the right hierarchy. The corresponding code system is empty. |
| [MaxOccurs](CodeSystem-question-max-occurs.md) | Flags an element as having unlimited repetitions. |
| [MdfHmdMetSourceType](CodeSystem-v3-MdfHmdMetSourceType.md) | Code to identify the source of a Message Element Type represented in the 'of MET' column of an HMD.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [MdfHmdRowType](CodeSystem-v3-MdfHmdRowType.md) | The row type codes for the tabular representation of a Hierarchical Message Description.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [MdfRmimRowType](CodeSystem-v3-MdfRmimRowType.md) | The row types for the tabular representation of an R-MIM.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [Measure Aggregate Method](CodeSystem-measure-aggregate-method.md) | Aggregation method for a measure (e.g. sum, average, median, minimum, maximum, count) |
| [Measure Population Type](CodeSystem-measure-population.md) | The type of population. |
| [Measure Scoring](CodeSystem-measure-scoring.md) | The scoring type of the measure. |
| [Measure Supplemental Data](CodeSystem-measure-supplemental-data.md) | Identifier supplemental data in a population for measuring purposes. |
| [MeasureDataUsage](CodeSystem-measure-data-usage.md) | The intended usage for supplemental data elements in the measure. |
| [MeasureImprovementNotation](CodeSystem-measure-improvement-notation.md) | Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue. |
| [MeasureType](CodeSystem-measure-type.md) | The type of measure (includes codes from 2.16.840.1.113883.1.11.20368). |
| [Media Type](CodeSystem-v3-mediaType.md) | Internet Assigned Numbers Authority (IANA) Mime Media Types. Identifies the type of the encapsulated data and identifies a method to interpret or render the data. The IANA defined domain of media types is established by the Internet standard RFC 2045 [http://www.ietf.org/rfc/rfc2045.txt] and 2046 [http://www.ietf.org/rfc/rfc2046.txt]. RFC 2046 defines the media type to consist of two parts:1. top level media type, and
1. media subtype However, this HL7 datatypes specification treats the entire media type as one atomic code symbol in the form defined by IANA, i.e., top level type followed by a slash "/" followed by media subtype. Currently defined media types are registered in a database [http://www.iana.org/assignments/media-types/index.html] maintained by IANA. Currently several hundred different MIME media types are defined, with the list growing rapidly. In general, all those types defined by the IANA MAY be used.
 |
| [Medical Management Type](CodeSystem-medical-management-type.md) | Types of medical management requirements or processes used by health insurers (payers) that may impact whether a service or item is covered or reimbursement rates. |
| [Medication request administration location codes](CodeSystem-medicationrequest-admin-location.md) | MedicationRequest Administration Location Codes |
| [MedicationAdministration Location Codes](CodeSystem-medication-admin-location.md) | MedicationAdministration Location Codes |
| [MedicationAdministration Performer Function Codes](CodeSystem-med-admin-perform-function.md) | MedicationAdministration Performer Function Codes |
| [MedicationDispense Performer Function Codes](CodeSystem-medicationdispense-performer-function.md) | MedicationDispense Performer Function Codes |
| [MedicationKnowledge Characteristic Codes](CodeSystem-medicationknowledge-characteristic.md) | MedicationKnowledge Characteristic Codes |
| [MedicationKnowledge Package Type Codes](CodeSystem-medicationknowledge-package-type.md) | MedicationKnowledge Package Type Codes |
| [MedicationKnowledge Status Codes](CodeSystem-medicationknowledge-status.md) | MedicationKnowledge Status Codes |
| [MedicationRequest Category Codes](CodeSystem-medicationrequest-category.md) | MedicationRequest Category Codes |
| [MedicationRequest Course of Therapy Codes](CodeSystem-medicationrequest-course-of-therapy.md) | MedicationRequest Course of Therapy Codes |
| [MedicationRequest Status Reason Codes](CodeSystem-medicationrequest-status-reason.md) | MedicationRequest Status Reason Codes |
| [MedicationUsage Administration Location Codes](CodeSystem-medication-usage-admin-location.md) | MedicationUsage Administration Location Codes |
| [MessageCondition](CodeSystem-v3-MessageCondition.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.This isn't referenced in the RIM and is a copy of old v2 codes. It's superseded by AcknowledgementDetailCode |
| [MessageWaitingPriority](CodeSystem-v3-MessageWaitingPriority.md) | Indicates that the receiver has messages for the sender**OpenIssue:**Description does not make sense relative to name of coding system. Must be reviewed and improved. |
| [Missing Tooth Reason Codes](CodeSystem-missingtoothreason.md) | This value set includes sample Missing Tooth Reason codes. |
| [Modifier type Codes](CodeSystem-modifiers.md) | This value set includes sample Modifier type codes. |
| [ModifyIndicator](CodeSystem-v3-ModifyIndicator.md) | Indicates whether the subscription to a query is new or is being modified. |
| [NDH Healthcare Service Category](CodeSystem-ndh-healthcare-service-category.md) | This code system defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH). |
| [Need](CodeSystem-need.md) | The frequency with which the target must be validated |
| [Network Type Codes](CodeSystem-benefit-network.md) | This code system represents the contractual relationship between a provider and payer for administrative purposes for a specific patient, service, or product. |
| [NullFlavor](CodeSystem-v3-NullFlavor.md) | A collection of codes specifying why a valid value is not present. |
| [Nutrition Intake Status Reason Codes](CodeSystem-nutritionintake-status-reason.md) | Nutrition Intake Status Reason Codes |
| [Nutrition intake category codes](CodeSystem-nutrition-intake-category.md) | NutritionIntake Category Codes |
| [Observation Category Codes](CodeSystem-observation-category.md) | Observation Category codes. |
| [Observation Reference Range Meaning Codes](CodeSystem-referencerange-meaning.md) | This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population. |
| [ObservationCategory](CodeSystem-v3-ObservationCategory.md) | High level observation categories for the general type of observation being made. URL: http://hl7-fhir.github.io/valueset-observation-category.html This is an inline code system http://hl7.org/fhir/observation-category. |
| [ObservationInterpretation](CodeSystem-v3-ObservationInterpretation.md) | One or more codes providing a rough qualitative interpretation of the observation, such as "normal" / "abnormal", "low" / "high", "better" / "worse", "resistant" / "susceptible", "expected" / "not expected". The value set is intended to be for ANY use where coded representation of an interpretation is needed. |
| [ObservationMethod](CodeSystem-v3-ObservationMethod.md) | A code that provides additional detail about the means or technique used to ascertain the observation.**Examples:**Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc.**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. Note that the Domain has a full discussion about use of the attribute and constraining that is not appropriate for the code system description. Needs to be improved. |
| [ObservationValue](CodeSystem-v3-ObservationValue.md) | This code system covers all concepts of HL7-defined values for the Observation value element, when it has a coded datatype. |
| [Operation Outcome Codes](CodeSystem-operation-outcome.md) | Operation Outcome codes used by FHIR test servers (see Implementation file translations.xml) |
| [Oral Site Codes](CodeSystem-ex-tooth.md) | This value set includes a smattering of FDI oral site codes. |
| [Orderable Drug Form](CodeSystem-v3-orderableDrugForm.md) | **OpenIssue:**Missing description. |
| [Organization Affiliation Role](CodeSystem-organization-affiliation-role.md) | This code system defines a set of codes that can be used to indicate an organization affiliation role. |
| [Organization Affiliation Role for HIE](CodeSystem-organization-affiliation-role-for-hie.md) | This code system defines a set of codes that can be used to indicate an organization affiliation role for HIE. |
| [Organization Alias Type](CodeSystem-organization-alias-type.md) | This code system defines a set of codes for indicating oranization alias type. |
| [Organization type](CodeSystem-organization-type.md) | This example value set defines a set of codes that can be used to indicate a type of organization. |
| [OrganizationNameType](CodeSystem-v3-OrganizationNameType.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. All of these are maintained under EntityNameType. This was created in error and should never be used. |
| [PH_RaceAndEthnicity_CDC](CodeSystem-v2-0005.md) | Code system of concepts specifying the patient's race. Used in HL7 Version 2.x messages in the PID segment. This code system includes codes used decades ago are are maintained here for historical purposes such as searching in past history records. These codes were formally deprecated in V2.9 and retired in THO in 2021. Please reference http://build.fhir.org/ig/HL7/UTG/CodeSystem-CDCREC for the current CDC Race and Ethnicity code system. |
| [ParameterizedDataType](CodeSystem-v3-ParameterizedDataType.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [Participant type](CodeSystem-participant-type.md) | This value set defines a set of codes that can be used to indicate how an individual participates in an encounter. |
| [ParticipationFunction](CodeSystem-v3-ParticipationFunction.md) | This code is used to specify the exact function an actor had in a service in all necessary detail. This domain may include local extensions (CWE). |
| [ParticipationMode](CodeSystem-v3-ParticipationMode.md) | A set of codes specifying the modality by which the Entity playing the Role is participating in the Act.**Examples:**Physically present, over the telephone, written communication.**Rationale:**Particularly for author (originator) participants this is used to specify whether the information represented by the act was initially provided verbally, (hand-)written, or electronically.**Open Issue:**There needs to be a reexamination of the hierarchies as there seems to be some muddling between ELECTRONIC and other concepts that involve electronic communication that are in other hierarchies. |
| [ParticipationSignature](CodeSystem-v3-ParticipationSignature.md) | A set of codes specifying whether and how the participant has attested his participation through a signature and or whether such a signature is needed.**Examples:**A surgical Procedure act object (representing a procedure report) requires a signature of the performing and responsible surgeon, and possibly other participants. (See also: Participation.signatureText.) |
| [ParticipationType](CodeSystem-v3-ParticipationType.md) | A code specifying the meaning and purpose of every Participation instance. Each of its values implies specific constraints on the Roles undertaking the participation. |
| [PatientImportance](CodeSystem-v3-PatientImportance.md) | Patient VIP code |
| [Payee Type Codes](CodeSystem-payeetype.md) | Codes indicating the type of party to be reimbursed for cost of products and services. |
| [PayeeResourceType](CodeSystem-resource-type-link.md) | The type of payee Resource. |
| [Payment Adjustment Reason Codes](CodeSystem-payment-adjustment-reason.md) | This value set includes smattering of Payment Adjustment Reason codes. |
| [Payment Status Codes](CodeSystem-paymentstatus.md) | This value set includes a sample set of Payment Status codes. |
| [Payment Type Codes](CodeSystem-payment-type.md) | This value set includes sample Payment Type codes. |
| [PaymentTerms](CodeSystem-v3-PaymentTerms.md) | Describes payment terms for a financial transaction, used in an invoice. This is typically expressed as a responsibility of the acceptor or payor of an invoice. |
| [PersonDisabilityType](CodeSystem-v3-PersonDisabilityType.md) | A code identifying a person's disability. |
| [PlanDefinitionType](CodeSystem-plan-definition-type.md) | The type of PlanDefinition. |
| [Possible Concept Code Relationships](CodeSystem-v3-ConceptCodeRelationship.md) | **Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. |
| [PostalAddressUse](CodeSystem-v3-PostalAddressUse.md) | **Deprecation Comment:**This code system was deprecated as of the November 2007 harmonization meeting. The content was folded into AddressUse (2.16.840.1.113883.5.1119), which replaces this code system. |
| [Practitioner role](CodeSystem-practitioner-role.md) | This example value set defines a set of codes that can be used to indicate the role of a Practitioner. |
| [Primary-source-type](CodeSystem-primary-source-type.md) | Type of the validation primary source |
| [ProbabilityDistributionType](CodeSystem-v3-ProbabilityDistributionType.md) | **** MISSING DESCRIPTION **** |
| [Procedure Type Codes](CodeSystem-procedure-type.md) | This value set includes Procedure Type codes. |
| [Process Priority Codes](CodeSystem-processpriority.md) | This value set includes the financial processing priority codes. |
| [ProcessingID](CodeSystem-v3-ProcessingID.md) | Codes used to specify whether a message is part of a production, training, or debugging system. |
| [ProcessingMode](CodeSystem-v3-ProcessingMode.md) | This attribute defines whether the message is being sent in current processing, archive mode, initial load mode, restore from archive mode, etc. |
| [Professional Credential Status](CodeSystem-professional-credential-status.md) | This code system establishes a series of codes designed to represent the status of professional credentials. |
| [Program](CodeSystem-program.md) | This value set defines an example set of codes that could be can be used to classify groupings of service-types/specialties. |
| [Provenance participant type](CodeSystem-provenance-participant-type.md) | These codes define the type of participation by an agent in a provenance activity. An agent is something that bears the responsibility identified by the type of participation in the activity taking place, for the existence of an entity, or for another agent's activity. An Agent may be An agent, device, system, organization, group, care-team, or other identifiable thing. |
| [Published In Type](CodeSystem-published-in-type.md) | The type of publication such as book, database, or journal. |
| [Push-type-available](CodeSystem-push-type-available.md) | Type of alerts/updates the primary source can send |
| [QualityOfEvidenceRating](CodeSystem-evidence-quality.md) | A rating system that describes the quality of evidence such as the GRADE, DynaMed, or Oxford CEBM systems. |
| [Quantity Units](CodeSystem-v2-0560.md) | HL7-defined code system of concepts specifying the adjustment quantity. |
| [QueryParameterValue](CodeSystem-v3-QueryParameterValue.md) | The domain of coded values used as parameters within QueryByParameter queries. |
| [QueryPriority](CodeSystem-v3-QueryPriority.md) | Identifies the time frame in which the response is expected. |
| [QueryQuantityUnit](CodeSystem-v3-QueryQuantityUnit.md) | Values in this domain specify the units of a query quantity limited request.**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. This is a holdover. It is not referenced. It is superseded by QueryRequestLimit. |
| [QueryRequestLimit](CodeSystem-v3-QueryRequestLimit.md) | **Definition:**Defines the units associated with the magnitude of the maximum size limit of a query response that can be accepted by the requesting application. |
| [QueryResponse](CodeSystem-v3-QueryResponse.md) | A code classifying the general nature of the response to a given query. Includes whether or not data was found, or whether an error occurred. |
| [QueryStatusCode](CodeSystem-v3-QueryStatusCode.md) | A code specifying the state of the Query. |
| [QuestionnaireItemUsageMode](CodeSystem-questionnaire-usage-mode.md) | Identifies the modes of usage of a questionnaire that should enable a particular questionnaire item. |
| [Race](CodeSystem-v3-Race.md) | **Deprecation Information:**Deprecated per UP-263. This code system is NOT the acknowledged source of truth for Race concepts and codes. It should no longer be used. https://terminology.hl7.org/CodeSystem-CDCREC.html should be used in its place. In the United States, federal standards for classifying data on race determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define race, and they recognize the absence of an anthropological or scientific basis for racial classification. Instead, the federal standards acknowledge that race is a social-political construct in which an individual's own identification with one more race categories is preferred to observer identification. The standards use a variety of features to define five minimum race categories. Among these features are descent from "the original peoples" of a specified region or nation. The minimum race categories are American Indian or Alaska Native, Asian, Black or African American, Native Hawaiian or Other Pacific Islander, and White. The federal standards stipulate that race data need not be limited to the five minimum categories, but any expansion must be collapsible to those categories. |
| [Reason Medication Given Codes](CodeSystem-reason-medication-given.md) | This value set is provided as an example. The value set to instantiate this attribute should be drawn from a robust terminology code system that consists of or contains concepts to support the medication process. |
| [ReferralMethod](CodeSystem-service-referral-method.md) | The methods of referral can be used when referring to a specific HealthCareService resource. |
| [RejectionCriterion](CodeSystem-rejection-criteria.md) | Criterion for rejection of the specimen by laboratory. |
| [RelationalOperator](CodeSystem-v3-RelationalOperator.md) | Identifies common relational operators used in selection criteria. |
| [RelationshipConjunction](CodeSystem-v3-RelationshipConjunction.md) | A code specifying the logical conjunction of the criteria among all the condition-links of Acts (e.g., and, or, exclusive-or.)**Constraints:**All AND criteria must be true. If OR and AND criteria occur together, one criterion out of the OR-group must be true and all AND criteria must be true also. If XOR criteria occur together with OR and AND criteria, exactly one of the XOR criteria must be true, and at least one of the OR criteria and all AND criteria must be true. In other words, the sets of AND, OR, and XOR criteria are in turn combined by a logical AND operator (all AND criteria and at least one OR criterion and exactly one XOR criterion.) To overcome this ordering, Act criteria can be nested in any way necessary. |
| [Religious Affiliation](CodeSystem-v3-ReligiousAffiliation.md) | Assigment of spiritual faith affiliation |
| [Research Study Party Role](CodeSystem-research-study-party-role.md) | This is a ResearchStudy's party role. |
| [Research Study Status](CodeSystem-research-study-status.md) | Codes that convey the current status of the research study. |
| [ResearchStudyObjectiveType](CodeSystem-research-study-objective-type.md) | Codes for the kind of study objective. |
| [ResearchStudyPhase](CodeSystem-research-study-phase.md) | Codes for the stage in the progression of a therapy from initial experimental use in humans in clinical trials to post-market evaluation. |
| [ResearchStudyPrimaryPurposeType](CodeSystem-research-study-prim-purp-type.md) | Codes for the main intent of the study. |
| [ResearchStudyReasonStopped](CodeSystem-research-study-reason-stopped.md) | Codes for why the study ended prematurely. |
| [ResearchSubjectMilestone](CodeSystem-research-subject-milestone.md) | Indicates the progression of a study subject through the study milestones.**Deprecation Information:**This Code System is being replaced in favor of using NCI Thesaurus codes. NCI codes through[Research Subject Milestones](http://terminology.hl7.org/ValueSet/research-subject-milestones)should be used instead |
| [ResearchSubjectState](CodeSystem-research-subject-state.md) | Indicates the progression of a study subject through a study. |
| [ResearchSubjectStateType](CodeSystem-research-subject-state-type.md) | Identifies the kind of state being refered to. |
| [ResourceSecurityCategory](CodeSystem-resource-security-category.md) | Provides general guidance around the kind of access Control to Read, Search, Create, Update, or Delete a resource. |
| [ResponseLevel](CodeSystem-v3-ResponseLevel.md) | Specifies whether a response is expected from the addressee of this interaction and what level of detail that response should include |
| [ResponseModality](CodeSystem-v3-ResponseModality.md) | Defines the timing and grouping of the response instances.**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. |
| [ResponseMode](CodeSystem-v3-ResponseMode.md) | Specifies the mode, immediate versus deferred or queued, by which a receiver should communicate its receiver responsibilities. |
| [Risk Probability](CodeSystem-risk-probability.md) | Codes representing the likelihood of a particular outcome in a risk assessment. |
| [RoleClass](CodeSystem-v3-RoleClass.md) | Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role. The role hierarchy stems from three core concepts, or abstract domains:* **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity. 
* **RoleClassPartitive** collects roles in which the playing entity is in some sense a "part" of the scoping entity. 
* **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between: 
* **RoleClassPassive** which are roles in which the playing entity is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping entity. The playing entity is passive in these roles in that the role exists without an agreement from the playing entity. 
* **RoleClassMutualRelationship** which are relationships based on mutual behavior of the two entities. The basis of these relationship may be formal agreements or they may be **de facto** behavior. Thus, this sub-domain is further divided into: 
* **RoleClassRelationshipFormal** in which the relationship is formally defined, frequently by a contract or agreement. 
* **Personal relationship** which inks two people in a personal relationship. The hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the "Personal relationship" which is a leaf concept. **OpenIssue:** Description copied from Concept Domain of same name. Must be verified.
 
 
 |
| [RoleCode](CodeSystem-v3-RoleCode.md) | A set of codes further specifying the kind of Role; specific classification codes for further qualifying RoleClass codes. |
| [RoleLinkStatus](CodeSystem-v3-RoleLinkStatus.md) | **Description:**Codes representing possible states of a RoleLink, as defined by the RoleLink class state machine. |
| [RoleLinkType](CodeSystem-v3-RoleLinkType.md) | A code specifying the meaning and purpose of every RoleLink instance. Each of its values implies specific constraints to what kinds of Role objects can be related and in which way. |
| [RoleStatus](CodeSystem-v3-RoleStatus.md) | Codes representing the defined possible states of an Role, as defined by the Role class state machine. |
| [RouteOfAdministration](CodeSystem-v3-RouteOfAdministration.md) | The path the administered medication takes to get into the body or into contact with the body. |
| [Security Role Type](CodeSystem-extra-security-role-type.md) | This CodeSystem contains Additional FHIR-defined Security Role types not defined elsewhere |
| [Sequencing](CodeSystem-v3-Sequencing.md) | Specifies sequence of sort order. |
| [Service Delivery Method](CodeSystem-service-delivery-method.md) | This code system defines a set of codes that can be used to indicate service delivery method |
| [Service category](CodeSystem-service-category.md) | This value set defines an example set of codes that can be used to classify groupings of service-types/specialties. |
| [Service type](CodeSystem-service-type.md) | This value set defines an example set of codes of service-types. |
| [ServiceProvisionConditions](CodeSystem-service-provision-conditions.md) | The code(s) that detail the conditions under which the healthcare service is available/offered. |
| [SetOperator](CodeSystem-v3-SetOperator.md) | **** MISSING DESCRIPTION **** |
| [Sex Parameter For Clinical Use](CodeSystem-sex-parameter-for-clinical-use.md) | A summary parameter that provides guidance on how a receiver should apply settings or reference ranges that are derived from observable information such as an organ inventory, recent hormone lab tests, genetic testing, menstrual status, obstetric history, etc.. |
| [SmartCapabilities](CodeSystem-smart-capabilities.md) | Codes that define what the server is capable of. |
| [Software System Type Codes](CodeSystem-software-system-type-codes.md) | Types of software systems that support knowledge artifact authoring and evaluation (authoring, testing, tooling, evaluation) |
| [SoftwareNameExample](CodeSystem-v3-SoftwareNameExample.md) | This code system serves to capture the SoftwareName concept domain used to convey a coded name for the software used to author content. |
| [Special arrangements](CodeSystem-encounter-special-arrangements.md) | This value set defines a set of codes that can be used to indicate the kinds of special arrangements in place for a patients visit. |
| [SpecialValues](CodeSystem-special-values.md) | A set of generally useful codes defined so they can be included in value sets. |
| [SpecimenType](CodeSystem-v3-SpecimenType.md) | **** MISSING DESCRIPTION **** |
| [StandardsStatus](CodeSystem-standards-status.md) | HL7 Ballot/Standards status of artifact. |
| [StateChangeReason](CodeSystem-state-change-reason.md) | Indicates why the state of the subject changed. |
| [Statistic Model Code](CodeSystem-statistic-model-code.md) | The role that the assertion variable plays. |
| [StatisticAttribute Estimate Type](CodeSystem-attribute-estimate-type.md) | Method of reporting variability of estimates, such as confidence intervals, interquartile range or standard deviation. |
| [StatisticCertaintyRating](CodeSystem-certainty-rating.md) | The relative quality of the statistic. |
| [StatisticCertaintySubcomponentRating](CodeSystem-certainty-subcomponent-rating.md) | The quality rating of the subcomponent of a quality of evidence rating. |
| [StatisticCertaintySubcomponentType](CodeSystem-certainty-subcomponent-type.md) | The subcomponent classification of quality of evidence rating systems. |
| [StatisticStatisticType](CodeSystem-statistic-type.md) | The type of a specific statistic. |
| [StatisticStudyType](CodeSystem-study-type.md) | The type of study a statistic was derived from. |
| [StatisticSynthesisType](CodeSystem-synthesis-type.md) | Types of combining results from a body of evidence (eg. summary data meta-analysis). |
| [StatisticsCode](CodeSystem-observation-statistics.md) | The statistical operation parameter -"statistic" codes. |
| [StrengthOfRecommendationRating](CodeSystem-recommendation-strength.md) | A rating system that describes the strength of the recommendation, such as the GRADE, DynaMed, or HGPS systems. |
| [Structure Definition Use Codes / Keywords](CodeSystem-definition-use.md) | Structure Definition Use Codes / Keywords |
| [Style Type](CodeSystem-v3-styleType.md) | The style code is used within the CDA/SPL narrative block to give the instance author some control over various aspects of style. |
| [SubscriberPolicyholder Relationship Codes](CodeSystem-subscriber-relationship.md) | This value set includes codes for the relationship between the Subscriber and the Beneficiary (insured/covered party/patient). |
| [Subscription Error Codes](CodeSystem-subscription-error.md) | Codes to represent subscription error details |
| [SubscriptionChannel Type Codes](CodeSystem-subscription-channel-type.md) | The type of method used to execute a subscription |
| [SubscriptionStatusAtEvent](CodeSystem-subscription-status-at-event.md) | A status code for the state of the Subscription. |
| [SubscriptionTag](CodeSystem-subscription-tag.md) | Tags to put on a resource after subscriptions have been sent. |
| [Substance Admin Substitution](CodeSystem-v3-substanceAdminSubstitution.md) | Identifies what sort of change is permitted or has occurred between the therapy that was ordered and the therapy that was/will be provided. |
| [Substance Category Codes](CodeSystem-substance-category.md) | Substance category codes |
| [SubstitutionCondition](CodeSystem-v3-SubstitutionCondition.md) | Identifies what sort of change is permitted or has occurred between the item that was ordered/requested and the one that was/will be provided. |
| [Supply Item Type](CodeSystem-supply-item-type.md) | This value sets refers to a specific supply item. |
| [Supply Type](CodeSystem-supply-kind.md) | This value sets refers to a Category of supply. |
| [SupplyRequestReason](CodeSystem-supplyrequest-reason.md) | The reason why the supply item was requested. |
| [Surface Codes](CodeSystem-FDI-surface.md) | This value set includes a smattering of FDI tooth surface codes. |
| [Systematized Nomenclature of Dentistry (SNODENT)](CodeSystem-v3-ada-snodent.md) | Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:* Provide standardized terms for describing dental disease 
* Capture clinical detail and patient characteristics 
* Permit analysis of patient care services and outcomes 
* To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR) SNODENT licensing information can be found at: http://www.ada.org/8466.aspx URL for Official Source: http://www.ada.org/snodent.aspx
 |
| [TableCellHorizontalAlign](CodeSystem-v3-TableCellHorizontalAlign.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableCellScope](CodeSystem-v3-TableCellScope.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableCellVerticalAlign](CodeSystem-v3-TableCellVerticalAlign.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableFrame](CodeSystem-v3-TableFrame.md) | These values are defined within the XHTML 4.0 Table Model |
| [TableRules](CodeSystem-v3-TableRules.md) | These values are defined within the XHTML 4.0 Table Model |
| [TargetAwareness](CodeSystem-v3-TargetAwareness.md) | A code specifying the extent to which the Entity playing the participating Role (usually as a target Participation) is aware of the associated Act.**Examples:**For diagnostic observations, is the patient, family member or other participant aware of his terminal illness?**Discussion:**If the awareness, denial, unconsciousness, etc. is the subject of medical considerations (e.g., part of the problem list), one should use explicit observations in these matters as well, and should not solely rely on this simple attribute in the Participation. |
| [TelecommunicationAddressUse](CodeSystem-v3-TelecommunicationAddressUse.md) | **Deprecation Comment:**This code system was deprecated as of the November 2007 harmonization meeting. The content was folded into AddressUse (2.16.840.1.113883.5.1119), which replaces this code system. |
| [TelecommunicationCapabilities](CodeSystem-v3-TelecommunicationCapabilities.md) | **Description:**Concepts that define the telecommunication capabilities of a particular device. Used to identify the expected capabilities to be found at a particular telecommunication address. |
| [Test script operation code](CodeSystem-testscript-operation-codes.md) | This value set defines a set of codes that are used to indicate the supported operations of a testing engine or tool. |
| [Test script profile destination type](CodeSystem-testscript-profile-destination-types.md) | This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the destination within a TestScript. |
| [Test script profile origin type](CodeSystem-testscript-profile-origin-types.md) | This value set defines a set of codes that are used to indicate the profile type of a test system when acting as the origin within a TestScript. |
| [Time Period Ranges](CodeSystem-time-period-ranges.md) | Defines codes for the representation of time period (e.g. age) ranges that are unambiguous, human readable, and machine-readable as a compositional grammar (i.e. the code system defines rules for constructing codes, rather than explicitly enumerating all possible codes). This CodeSystem profiles[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html)for expressing time period ranges through two simple durations (as defined in the[ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html)specification).Codes in the code system are defined according to the grammar:A time period (e.g. age) range is defined as two durations:`[duration1]--[duration2]`, where`duration1`specifies the lower inclusive bound of the age range (everyone who is this age and above) and`duration2`specifies the upper exclusive bound of the age range.For example, the age range "1-9 years" means everyone who is at least one year old and less than 10 years old represented as`P1Y--P10Y`. The age range "10-14 years" means everyone who is at least 10 years old and less than 15 years old and is represented as`P10Y--P15Y`.Durations define the amount of time between two time points. These durations are represented in the form`P[n]Y[n]M[n]DT[n]H[n]M[n]S`or`P[n]W`. The`[n]`is replaced by the value for each of the time elements that follow the`[n]`and the letters have the meaning:* `P` is the duration designator (for period) placed at the start of the duration representation. 
* `Y` is the year designator that follows the value for the number of years.
* `M` is the month designator that follows the value for the number of months.
* `W` is the week designator that follows the value for the number of weeks.
* `D` is the day designator that follows the value for the number of days.
 
* `T` is the time designator that precedes the time components of the representation. 
* `H` is the hour designator that follows the value for the number of hours.
* `M` is the minute designator that follows the value for the number of minutes.
* `S` is the second designator that follows the value for the number of seconds. (Note that seconds can be a decimal in this format to allow for milliseconds)
 
For example,`P3Y6M4DT12H30M5S`represents a duration of**three years, six months, four days, twelve hours, thirty minutes, and five seconds**.Date and time elements including their designator may be omitted if their value is zero, and lower-order elements may also be omitted for reduced precision. For example,`P23DT23H`and`P4Y`are both acceptable duration representations. However, at least one element must be present, thus`P`is not a valid representation for a duration of**0 seconds**.`PT0S`or`P0D`, however, are both valid and represent the same duration.Note that the designator`M`is used for both months and minutes, but this is not ambiguous because the minutes designator must be preceded by the time designator`T`. For example`P1M`is**one month**, while`PT1M`is**one minute**.Content for this code system is adapted from the definition in the IHE-ADX profile: https://www.ihe.net/uploadedFiles/Documents/QRPH/IHE_QRPH_Suppl_ADX.pdf (Appendix 8K Representation of Age Groups in ADX). In addition, the code system definition is adapted from similar content published as part of the SANER implementation guide. See[Age Range Coding System](https://hl7.org/fhir/uv/saner/CodeSystem-IHE-ADX-agerange.html). |
| [TimingEvent](CodeSystem-v3-TimingEvent.md) | **** MISSING DESCRIPTION **** |
| [Title Type](CodeSystem-title-type.md) | Used to express the reason and specific aspect for the variant title, such as language and specific language. |
| [TransmissionRelationshipTypeCode](CodeSystem-v3-TransmissionRelationshipTypeCode.md) | **Description:**A code specifying the meaning and purpose of every TransmissionRelationship instance. Each of its values implies specific constraints to what kinds of Transmission objects can be related and in which way. |
| [TribalEntityUS](CodeSystem-v3-TribalEntityUS.md) | INDIAN ENTITIES RECOGNIZED AND ELIGIBLE TO RECEIVE SERVICES FROM THE UNITED STATES BUREAU OF INDIAN AFFAIRS |
| [Trigger Event ID](CodeSystem-triggerEventID.md) | **Description:**This code system contains all HL7 artifacts of type TE (Trigger Event) that are created by HL7 or its affiliates or their designates using the realm namespacing rules approved by HL7. Local implementations who create trigger events outside of these namespacing rules, (e.g. using the ZZ realm code) must register their own code system. The specific list of legal codes can be found by consulting the HL7 publications (editions, ballots, implementation guides, etc.) published by HL7 Inc. and by the various HL7 affiliates and their designates. Codes shall be expressed in upper case, with separator as shown in HL7 publications with no version id. E.g. PORX_TE123456UV. |
| [USCLS Codes](CodeSystem-ex-USCLS.md) | This value set includes a smattering of USCLS codes. |
| [UTG Specific Concept Properties](CodeSystem-utg-concept-properties.md) | A set of concept properties used by UTG to maintain legacy terminology distribution systems |
| [Unit Type Codes](CodeSystem-benefit-unit.md) | This value set includes a smattering of Unit type codes. |
| [Universal Resource Locator Scheme](CodeSystem-v3-URLScheme.md) | A Universal Resource Locator (URL) is a type of telecommunications address specified as Internet standard RFC 1738 [http://www.isi.edu/in-notes/rfc1738.txt]. The URL specifies the protocol and the contact point defined by that protocol for the resource. |
| [UsageContextType](CodeSystem-usage-context-type.md) | A code that specifies a type of context being specified by a usage context. |
| [V2 Table List](CodeSystem-v2-tables.md) | Master List of V2 Tables Please note that V2 Code System and Value Set URIs are present, but the URIs do not resolve. The addition of the appropriate THO artifacts for these are in progress. |
| [VaccineManufacturer](CodeSystem-v3-VaccineManufacturer.md) | The manufacturer of a vaccine. |
| [VaccineType](CodeSystem-v3-VaccineType.md) | The kind of vaccine. |
| [Validation-process](CodeSystem-validation-process.md) | The primary process by which the target is validated |
| [Validation-status](CodeSystem-validation-status.md) | Status of the validation of the target against the primary source |
| [Validation-type](CodeSystem-validation-type.md) | What the target is validated against |
| [VerificationResult Communication Method](CodeSystem-verificationresult-communication-method.md) | Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated. |
| [Virtual Healthcare Delivery Method](CodeSystem-virtual-healthcare-delivery-method.md) | This code system defines a set of codes for virtual healthcare service delivery method. |
| [VocabularyDomainQualifier](CodeSystem-v3-VocabularyDomainQualifier.md) | Vocabulary domain qualifiers are concepts that are used in domain constraints to specify behavior of the new domain. Code system retired. |
| [Work Classification (Occupational Data for Health)](CodeSystem-v3-WorkClassificationODH.md) | Code system of concepts representing a person's job type as defined by compensation and sector (e.g. paid vs. unpaid, self-employed vs. not self-employed, government vs. private, etc.). |
| [accept-applicationAcknowledgmentConditions](CodeSystem-v2-0155.md) | HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment. |
| [accessRestrictionValue](CodeSystem-v2-0717.md) | Code system of concepts specifying the information to which access is restricted. Used in HL7 Version 2.x messaging in the ARV segment. Note that these new codes as of November 2018 have been temporarily loaded into this V2 code system pending availability of the currently unavailable new tooling, at which time this code systrem will be retired and a value set of codes from the HL7 V3 ActCode code system will be used instead for this table. |
| [acknowledgmentCodes](CodeSystem-v2-0008.md) | HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. |
| [actionCodes](CodeSystem-v2-0323.md) | HL7-defined code system ofstatus codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed. As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx. |
| [actionTakenInResponseToTheEvent](CodeSystem-v2-0251.md) | HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue. Used in HL7 Version 2.x messaging in the PCR segment. |
| [active-inactive](CodeSystem-v2-0183.md) | HL7-defined code system of concepts specifying whether a person is currently a valid staff member. Used in HL7 Version 2.x messaging in the STF segment. |
| [actpriority](CodeSystem-v2-0906.md) | HL7-defined code system of concepts specifying the priority for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [additivePreservative](CodeSystem-v2-0371.md) | HL7-defined code system of concepts specifying any additive introduced to the specimen before or at the time of collection. These additives may be introduced in order to preserve, maintain or enhance the particular nature or component of the specimen. Used in HL7 Version 2.x messaging in the SPM and SAC segments. |
| [addressExpirationReason](CodeSystem-v2-0616.md) | Code system of concepts specifying the reason this address was marked as "ended". Used in HL7 Version 2.x messaging in the XAD segment. |
| [addressType](CodeSystem-v2-0190.md) | HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. |
| [addressUsage](CodeSystem-v2-0617.md) | HL7-defined code system of concepts specifying how an address is intended to be used. Used in HL7 Version 2.x messaging in the XAD segment. |
| [adjustmentAction](CodeSystem-v2-0569.md) | Code system of concepts used to specify the action requested of the party that receives an adjustment. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [adjustmentCategory](CodeSystem-v2-0564.md) | Code system of concepts used to specify the category of adjustment and is used to assist in determining which table is used for Adjustment Reason. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [administrationDevice](CodeSystem-v2-0164.md) | Code system of concepts which specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. Used in HL7 Version 2.x messaging in the RXR segment. |
| [administrationMethod](CodeSystem-v2-0165.md) | Code system of concepts which specify the specific method requested for the administration of the drug or treatment to the patient. Used in HL7 Version 2.x messaging in the RXR segment. |
| [administrativeSex](CodeSystem-v2-0001.md) | Code system of concepts specifying a patient's sex for administrative purposes. Used in HL7 Version 2.x messages in the PID segment. |
| [admissionLevelOfCare](CodeSystem-v2-0432.md) | Code system of concepts specifying the acuity level assigned to the patient at the time of admission. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [admissionType](CodeSystem-v2-0007.md) | Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [advanceDirective](CodeSystem-v2-0435.md) | Code system of concepts specifying the patient's instructions to the healthcare facility. Used in HL7 Version 2.x messaging in the PV2 and PD1 segments. |
| [advancedBeneficiaryNotice](CodeSystem-v2-0339.md) | Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service. Used in HL7 Version 2.x messaging in the ORC and FT1 segments. |
| [alertDevice](CodeSystem-v2-0437.md) | Code system of concepts specifying any type of allergy alert device the patient may be carrying or wearing. Used in HL7 Version 2.x messaging in the IAM segment. |
| [alertLevel](CodeSystem-v2-0367.md) | HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event). Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging. |
| [allergenType](CodeSystem-v2-0127.md) | Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.). Used in HL7 Version 2.x messaging in the AL1 segment. |
| [allergyClinicalStatus](CodeSystem-v2-0438.md) | Code system of concepts specifying the verification status for the allergy. Used in HL7 Version 2.x messaging in the IAM segment. |
| [allergySeverity](CodeSystem-v2-0128.md) | Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x messaging in the AL1 segment. |
| [allowSubstitution](CodeSystem-v2-0161.md) | HL7-defined code system of concepts which specify whether substitutions are allowed and, if so, the type of substitutions allowed. Used in HL7 Version 2.x messaging in the RXO segment. |
| [allowSubstitution](CodeSystem-v2-0279.md) | Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the AIS and AIG segments. |
| [alternateCharacterSetHandlingScheme](CodeSystem-v2-0356.md) | HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. Used in HL7 Version 2.x messaging in the MSH segment. |
| [alternateCharacterSets](CodeSystem-v2-0211.md) | HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. |
| [ambulatoryPaymentClassification](CodeSystem-v2-0466.md) | Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [ambulatoryStatus](CodeSystem-v2-0009.md) | Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [amountClass](CodeSystem-v2-0193.md) | Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in the PTA segment. |
| [amountType](CodeSystem-v2-0146.md) | Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [analyteRepeatStatus](CodeSystem-v2-0389.md) | HL7-defined code system of concepts identifying the repeat status for the analyte/result (e.g. original, rerun, repeat, reflex). The following are assumptions regarding the table values: Repeated without dilution — performed usually to confirm correctness of results (e.g., in case of results flagged as "Panic" or mechanical failures). Repeated with dilution — performed usually in the case the original result exceeded the measurement range (technical limits). Reflex test — this test is performed as the consequence of rules triggered based on other test result(s). Used in HL7 Version 2.x messaging in the Test Code Detail (TCD) segment. |
| [annotations](CodeSystem-v2-0317.md) | Code system of concepts specifying the coded entry associated with a given point in time during the waveform recording. Used in HL7 Version 2.x messaging in the Observation Result (OBX) Another Observation (ANO) segments. |
| [applicationChangeType](CodeSystem-v2-0409.md) | HL7-defined code system of concepts which specify the type of change being requested (if NMR query) or announced (if NMD unsolicited update) during application status changes. It is assumed that a "new" version starts up with no loss or duplication of data as the "old" one is shutting down (if possible). Used in HL7 Version 2 Messaging in the NSC segment. |
| [appointmentReason](CodeSystem-v2-0276.md) | Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [appointmentType](CodeSystem-v2-0277.md) | Code system of concepts used in an appointment request to describe the kind of appointment. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [approvingRegulatoryAgency](CodeSystem-v2-0790.md) | Code system of concepts specifying the regulatory agency by which the item has been approved, such as the FDA or AMA. Used in HL7 Version 2.x messaging in the ITM segment. |
| [armStick](CodeSystem-v2-0927.md) | HL7-defined code system of concepts specifying the arm(s) receiving the stick. Used in HL7 Version 2.x messaging in the DON segment. |
| [arrivalMode](CodeSystem-v2-0430.md) | Code system of concepts specifying how the patient was brought to the healthcare facility. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [artificialBlood](CodeSystem-v2-0375.md) | Code system of concepts that identify the artificial blood identifier associated with the specimen. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [assignmentOfBenefits](CodeSystem-v2-0135.md) | Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider. If so, the insurance will pay the provider directly. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [authorizationMode](CodeSystem-v2-0483.md) | HL7-defined code system of concepts of forms of authorization a recorder may receive from the responsible practitioner to create or change an order. Used in HL7 Version 2.x messaging in the ORC segment. |
| [auto-DilutionType](CodeSystem-v2-0945.md) | Code system of vendor-defined codes that specify the pre‑configured dilution to be applied on the instrument, which can be used instead of a numeric declaration. Used in Version 2 messaging in the TCD segment. |
| [bedStatus](CodeSystem-v2-0116.md) | Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. Used in HL7 Version 2.x messaging in the DLD and PV1 segments. |
| [benefitGroup](CodeSystem-v2-0556.md) | Code system of concepts used to specify the benefit group. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [bloodProduct](CodeSystem-v2-0426.md) | HL7-defined code system of concepts which specify a type of blood product. Used in HL7 Version 2 messaging in the BLC segment. |
| [bloodProductDispenseStatus](CodeSystem-v2-0510.md) | HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the filler or placer. For example, the first status change of a product that may trigger a Blood Product Dispense Status Message occurs when it first becomes linked to a patient and is ready to dispense. The placer system may use the Blood Product Dispense Status Message to request the transfusion service to dispense the product. When the blood product is delivered or issued to a patient, the status of the blood product would be changed to indicate that it has now been "dispensed". Used in the Blood Product Dispense Status (BPX) segment in HL7 Version 2.x messaging. |
| [bloodProductProcessingRequirements](CodeSystem-v2-0508.md) | Code system of concepts used to specify additional information about the blood component class associated with the Universal Service ID. The placer of the order can specify any required processing of the blood product that must be completed prior to transfusion to the intended recipient. Used in the Blood Product Order (BPO) segment in HL7 Version 2.x messaging. |
| [bloodProductTransfusion-dispositionStatus](CodeSystem-v2-0513.md) | HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been "transfused." Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. |
| [bloodUnitType](CodeSystem-v2-0566.md) | HL7-defined code system of concepts used to specify the type of blood unit. Used in the Blood Unit Information (BUI) segment in HL7 Version 2.x messaging. |
| [bodyParts](CodeSystem-v2-0550.md) | HL7-defined code system of concepts specifying the part of the body. Used in HL7 Version 2 messaging in the RXR segment. |
| [bodySite](CodeSystem-v2-0163.md) | HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Used in HL7 Version 2.x messaging in the OBX and CH7 segments. |
| [bodySiteModifier](CodeSystem-v2-0495.md) | HL7-defined code system of concepts specifying the modifier for the body site. Used in HL7 Version 2.x messaging in the RXR segment. |
| [bolusType](CodeSystem-v2-0917.md) | HL7-defined code system of concepts specifying the type of bolus. Used in HL7 Version 2.x messaging in the RXV segment. |
| [bpObservationStatusCodesInterpretation](CodeSystem-v2-0511.md) | HL7-defined code system of concepts used to specify the interpretation for the blood product observation status codes. A status is considered preliminary until a blood product has reached a final disposition for the patient. For example, when the product is first cross-matched and a status message is sent, it would be considered preliminary. When the product is dispensed to the patient, that status would also be considered preliminary. However, once the product is transfused, the status would be considered final. Used in the Blood Product Dispense Status (BPX) and Blood Product Transfusion/Disposition (BTX) segments in HL7 Version 2.x messaging. |
| [calendarAlignment](CodeSystem-v2-0527.md) | HL7-defined code system of concepts used to specify an alignment of the repetition to a calendar (e.g., to distinguish every 30 days from "the 5th of every month"). Used in HL7 Version 2 messaging in the RPT segment. |
| [caseCategory](CodeSystem-v2-0423.md) | HL7-defined code system of concepts which specify reasons that a non-urgent patient presents to the Emergency Room for treatment instead of a clinic or physician office. Used in HL7 Version 2 messaging in the ABS segment. |
| [causalityObservations](CodeSystem-v2-0252.md) | HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [cclValue](CodeSystem-v2-0728.md) | Code system of concepts specifying the clinical complexity level (CCL) value for the determined diagnosis related group (DRG) for this diagnosis. US Realm. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [certificateStatus](CodeSystem-v2-0536.md) | Code system of concepts specifying the status of the certificate held by the health professional. Used in HL7 Version 2 messaging in the CER segment. |
| [certificationCategory](CodeSystem-v2-0922.md) | Code system of concepts specifying the code for the certification category. Used in HL7 Version 2.x messaging in the IN3 segment. |
| [certificationPatientType](CodeSystem-v2-0150.md) | Code system of concepts which specify the category or type of patient for which this certification is requested. Used in HL7 Version 2.x messaging in the ICD segment. |
| [certificationStatus](CodeSystem-v2-0337.md) | HL7-defined code system of concepts used to specify the status of the practitioner's speciality certification. Used in HL7 Version 2.x messaging in the Specialty Description (SPD) value and Practitioner Detail (PRA) segment. |
| [certificationType](CodeSystem-v2-0921.md) | Code system of concepts specifying the code for the certification type. Used in HL7 Version 2.x messaging in the IN3 segment. |
| [chargeOnIndicator](CodeSystem-v2-0269.md) | Code system of concepts used to define the event upon which a charge should be generated. Used in HL7 Version 2.x messaging in the PRC segment. |
| [chargeType](CodeSystem-v2-0122.md) | HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. |
| [chargeTypeReason](CodeSystem-v2-0475.md) | Code system of concepts specifying the choice of, and providing the clinical rationale for, a selected charge type. Used in HL7 Version 2.x messaging in the BLG segment. |
| [checkDigitScheme](CodeSystem-v2-0061.md) | HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. |
| [chromosome-human](CodeSystem-chromosome-human.md) | Chromosome number for human. |
| [clergyNotificationType](CodeSystem-v2-0534.md) | Code system of concepts specifying whether the clergy should be notified. Used in HL7 Version 2 messaging in the PV2 segment. |
| [codingSystem](CodeSystem-v2-0396.md) | HL7-defined code system of concepts specifying the coding system. This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm. Used in HL7 Version 2.x messaging in the CWE segment. |
| [collectionEvent](CodeSystem-v2-0938.md) | HL7-defined code system of concepts specifying the limit for the collection event or process step. Used in HL7 Version 2.x messaging in the OMC segment. |
| [commandResponse](CodeSystem-v2-0387.md) | Code system of concepts identifying the response of the previously issued command. Used in HL7 Version 2.x messaging in the Equipment Command Response (ECR) and Interaction Status Detail (ISD) segments. |
| [commentType](CodeSystem-v2-0364.md) | Code system of concepts that identify the type of comment text being sent in the specific comment record. Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging. |
| [communicationLocation](CodeSystem-v2-0939.md) | HL7-defined code system of concepts specifying the communication location. Used in HL7 Version 2.x messaging in the OMC segment. |
| [completionStatus](CodeSystem-v2-0322.md) | HL7-defined code system of concepts specifying the status of the treatment administration event segment. Used in HL7 Version 2.x messaging in the Pharmacy Order Administration (RXA) segment. |
| [computationType](CodeSystem-v2-0523.md) | HL7-defined code system of concepts used to specify if the change is computed as a percent change or as an absolute change. Used in the Delta (DLT) segment in HL7 Version 2.x messaging. |
| [confidentiality](CodeSystem-v2-0907.md) | HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [confidentialityCodes](CodeSystem-v2-0177.md) | Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation. Used in HL7 Version 2.x messaging in the OM1 and ORC segments. |
| [consentBypassReason](CodeSystem-v2-0499.md) | Code system of concepts specifying the reason the subject's consent was not sought. Used in HL7 Version 2.x messaging in the CON segment. |
| [consentDisclosureLevel](CodeSystem-v2-0500.md) | HL7-defined code system of concepts specifying how much information was disclosed to the subject as part of the informed consent process. Used in HL7 Version 2.x messaging in the CON segment. |
| [consentMode](CodeSystem-v2-0497.md) | HL7-defined code system of concepts specifying the method in which a subject provides consent. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [consentNon-disclosureReason](CodeSystem-v2-0501.md) | Code system of concepts used to specify a reason the subject did not receive full disclosure. Used in the Consent (CON) segment in HL7 Version 2.x messaging. |
| [consentStatus](CodeSystem-v2-0498.md) | HL7-code system of concepts specifying whether the consent has been sought and granted. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [consentType](CodeSystem-v2-0496.md) | Code system of concepts specifying to what the subject is consenting, i.e. what type of service, surgical procedure, information access/release or other event. Used in HL7 Version 2.x messaging in the TXA and CON segments. |
| [contactRole2](CodeSystem-v2-0131.md) | Code system of concepts which specify a relationship role that the next of kin/associated parties plays with regard to the patient. Also used in referrals, for example, it may be necessary to identify the contact representative at the clinic that sent a referral. Used in HL7 Version 2 messaging in the NK1 and CTD segments after 2.5, when it replace 2.16.840.1.113883.18.57. |
| [containerCondition](CodeSystem-v2-0544.md) | HL7-defined code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons. Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging. |
| [containerStatus](CodeSystem-v2-0370.md) | HL7-defined code system of concepts that identify the status of the unique container in which the specimen resides at the time the transaction was initiated. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [continuationStyle](CodeSystem-v2-0398.md) | HL7-defined code system of concepts identifying whether it is a fragmented message or part of an interactive continuation message. Used in HL7 Version 2.x messaging in the Continuation Pointer (DSC) segment. |
| [controlledSubstanceSchedule](CodeSystem-v2-0477.md) | Code system of concepts specifying the class of the drug or other substance if its usage is controlled by legislation. In the USA, such legislation includes the federal Controlled Substance Act (CSA) or a State Uniform Controlled Substance Act. Other countries should create their own versions of this table. Used in HL7 Version 2.x messaging in the RXE segment. The name of the table is taken from the Pharmacy Law Digest July 1988. |
| [coordinationOfBenefits](CodeSystem-v2-0173.md) | Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [coverageType](CodeSystem-v2-0309.md) | Code system of concepts specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system. For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges. Used in HL7 Version 2.x messaging in the Insurance (IN1) segment. |
| [cpRangeType](CodeSystem-v2-0298.md) | HL7-defined code system of concepts used to define a type of range used in composite pricing in financial transacxtions. Used in HL7 Version 2 messaging in the CP datatype. |
| [cumulativeDosageLimitUom](CodeSystem-v2-0924.md) | Code system of concepts specifying the unit of measure (UoM) for the cumulative dosage limit. Used in HL7 Version 2.x messaging in the CDO segment. |
| [cweStatuses](CodeSystem-v2-0353.md) | HL7-defined code system of comcepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in HL7 Version 2.x messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [cycleType](CodeSystem-v2-0702.md) | Code system of concepts specifying the type of cycle that is being executed. A cycle type is a specific sterilization method used for a specific type of supply item. Used in HL7 Version 2.x messaging in the SCD segment. |
| [cyclicEntryExitIndicator](CodeSystem-v2-0505.md) | HL7-defined code system of concepts used to specify if this service request is the first or last service request in a cyclic series of service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [dataTypes](CodeSystem-v2-0440.md) | HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX). Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments. |
| [date-timeSelectionQualifier](CodeSystem-v2-0158.md) | HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment. |
| [dateFormat](CodeSystem-v2-0653.md) | Code system of concepts that identify the date format for a decontamination/sterilization instance. Used in HL7 Version 2.x messaging in the SCP segment. |
| [dayType](CodeSystem-v2-0149.md) | Code system of concepts which specify whether the days are denied, pending or approved. Used in HL7 Version 2.x messaging in the DTN segment. |
| [daysOfTheWeek](CodeSystem-v2-0267.md) | HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments. Used in HL7 Version 2.x messaging in the UVC and LDP segments. |
| [deferredResponseType](CodeSystem-v2-0107.md) | HL7-defined code system of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters. Used in HL7 Version 2 messaging in the QRD segment. |
| [degreeLicenseCertificate](CodeSystem-v2-0360.md) | Code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in HL7 Version 2.x messaging in the CNN segment; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [delayedAcknowledgmentType](CodeSystem-v2-0102.md) | HL7-defined code system of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging and used in the MSH segment. |
| [derivedSpecimen](CodeSystem-v2-0170.md) | HL7-defined code system of concepts which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The process also produces new "specimens" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [deviceDataState](CodeSystem-v2-0667.md) | Code system of concepts that define the state of the data as provided from a device. Used in HL7 Version 2.x messaging in the SDD segment. |
| [deviceStatus](CodeSystem-v2-0682.md) | Code system of concepts that communicate the state of a device. Used in HL7 Version 2.x messaging in the SCD segment. |
| [deviceType](CodeSystem-v2-0657.md) | Code system of concepts that idenfity the kind of device as defined by the manufacturer. Used in HL7 Version 2.x messaging in the SCP segment. |
| [diagnosisClassification](CodeSystem-v2-0228.md) | Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [diagnosisPriority](CodeSystem-v2-0359.md) | Code system of concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in HL7 Version 2.x messaging. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed. |
| [diagnosisType](CodeSystem-v2-0052.md) | Code system of concepts specifying a type of diagnosis being sent. Used in HL7 Version 2.x messaging in the DG1 segment.. |
| [diagnosticServiceSectionId](CodeSystem-v2-0074.md) | HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed. Used in HL7 Version 2.x messaging in the OBR and OM4 segments. |
| [dietCodeSpecificationType](CodeSystem-v2-0159.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODS segment. |
| [disabilityInformationRelationship](CodeSystem-v2-0334.md) | Code system of concepts used to specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. Used in HL7 Version 2.x messaging in the Disability (DB1) segment. |
| [dispenseMethod](CodeSystem-v2-0321.md) | HL7-definde code system of concepts specifying the method by which treatment is dispensed. Used in HL7 Version 2.x messaging in the Pharmacy/Treatment Encoded order (RXE) and Pharmacy/Treatment dispense (RXD) segments. |
| [dispenseType](CodeSystem-v2-0484.md) | Code system of concepts specifying the type of dispensing event that occurred. Used in HL7 Version 2.x messaging in the RXD segment. |
| [documentAvailabilityStatus](CodeSystem-v2-0273.md) | HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care. Used in HL7 Version 2.x messaging in the TXA segment. |
| [documentCompletionStatus](CodeSystem-v2-0271.md) | HL7-defined code system of concepts used to record the state of a document in a workflow. Used in HL7 Version 2.x messaging in the TXA segment. |
| [documentConfidentialityStatus2](CodeSystem-v2-0272.md) | HL7-defined code system of concetps used to identify the degree to which special confidentiality protection should be applied to this information. Used in HL7 Version 2.x messaging in the TXA segment. |
| [documentStorageStatus](CodeSystem-v2-0275.md) | HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage. Used in HL7 Version 2.x messaging in the TXA segment. |
| [documentType](CodeSystem-v2-0270.md) | Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x messaging in the TXA segment. |
| [drgDiagnosisDeterminationStatus](CodeSystem-v2-0731.md) | HL7-defined cCode system of concepts specifying the status of a diagnosis for a diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [drgGroupingStatus](CodeSystem-v2-0749.md) | Code system of concepts specifying the status of the use of the gender information for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [drgProcedureDeterminationStatus](CodeSystem-v2-0761.md) | Code system of concepts specifying the status of the use of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [drgProcedureRelevance](CodeSystem-v2-0763.md) | Code system of concepts specifying the relevance of this particular procedure for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [drgStatusFinancialCalculation](CodeSystem-v2-0742.md) | Code system of concepts specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [drgStatusPatient](CodeSystem-v2-0739.md) | Code system of concepts specifying whether the length of stay is normal or respectively shorter or longer than normal. Used in HL7 Version 2.x messaging in the DRG segment. |
| [drgStatusRespirationMinutes](CodeSystem-v2-0757.md) | Code system of concepts specifying the status of the use of the respiration minutes information for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [drgTransferType](CodeSystem-v2-0415.md) | HL7-defined code system of concepts which specify a type of hospital receiving a transfer patient, which affects how a facility is reimbursed under diagnosis related group (DRG’s), for example, exempt or non-exempt. Used in HL7 Version 2 messaging in the DRG segment. |
| [drgstatusAdmission](CodeSystem-v2-0759.md) | Code system of concepts specifying the admission status for the diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [drgstatusWeightAtBirth](CodeSystem-v2-0755.md) | Code system of concepts specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [durationCategories](CodeSystem-v2-0255.md) | Code system of concepts used to classify an observation definition as intended to measure a patient's state at a point in time. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [eligibilitySource](CodeSystem-v2-0144.md) | Code system of concepts which specify the source of information about the insured's eligibility for benefits. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [employmentStatus](CodeSystem-v2-0066.md) | HL7-defined code system of concepts which specify an employment status of a person. Used in HL7 Version 2 messaging in the GT1 segment. |
| [encoding](CodeSystem-v2-0299.md) | HL7-defined code system of concept identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters. These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt. Used in HL7 Version 2.x messaging in the ED datatypes. |
| [environmentalFactors](CodeSystem-v2-0377.md) | Code system of concepts that identify the other environmental factors associated with the specimen in a specific container, e.g., atmospheric exposure. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [equipmentState](CodeSystem-v2-0365.md) | HL7-defined code system of concepts that identify the status the equipment was in at the time the transaction was initiated. Used in HL7 Version 2.x messaging in the EQU segment. |
| [equipmentStateIndicator](CodeSystem-v2-0942.md) | HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated laboratory instrument. Used in HL7 Version 2.x messaging in the INV segment. |
| [errorSeverity](CodeSystem-v2-0516.md) | HL7-defined code system of concepts specifying the severity of an application error as reported during acknowledgment of messages. Knowing if something is Error, Warning or Information is intrinsic to how an application handles the content and the information flow. Used in HL7 Version 2.x messaging acknowledgment in the ERR segment. |
| [escortRequired](CodeSystem-v2-0225.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [ethnicGroup](CodeSystem-v2-0189.md) | Code system of concepts further defining a patient's ancestry. In the US, a current use is to use these codes to report ethnicity in line with US federal standards for Hispanic origin. Used for HL7 Version 2 messaging in the PID segment. |
| [event](CodeSystem-v2-0003.md) | HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. |
| [eventConsequence](CodeSystem-v2-0240.md) | HL7-defined code system of concepts used to describe the impact of an event on a patient. Used in HL7 Version 2.x messaging in the PEO segment. |
| [eventExpected](CodeSystem-v2-0239.md) | HL7-defined code system of concepts used to communicate whether an event has been judged to be expected or unexpected. Used in HL7 Version 2.x messaging in the PEO segment. |
| [eventQualification](CodeSystem-v2-0237.md) | HL7-defined code system of concepts used to qualify an event related to a product experience. Used in HL7 Version 2.x messaging in the PEO segment. |
| [eventReason](CodeSystem-v2-0062.md) | Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. |
| [eventRelatedPeriod](CodeSystem-v2-0528.md) | HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Used in HL7 Version 2 messaging in the RPT segment. |
| [eventReportedTo](CodeSystem-v2-0236.md) | HL7-defined code system of concepts used to identify the type of entity to which the even has been reported. Used in HL7 Version 2.x messaging in the PES segment. |
| [eventSeriousness](CodeSystem-v2-0238.md) | HL7-defined code system of concepts used by a sender to designate an event as serious or significant. Used in HL7 Version 2.x messaging in the PEO segment. |
| [eventType](CodeSystem-v2-0450.md) | HL7-defined code system of concepts specifying the type of event of the message. Used in HL7 Version 2.x messaging in the EQP segment. |
| [exclusiveTest](CodeSystem-v2-0919.md) | HL7-defined code system of concepts that define if a test should be a specific event with no other tests to be performed with this test, or not, or other special circumstances. Used in HL7 Version 2.x messaging in Master Files (OM1 segment) to characterize observations in a master of such orderables. |
| [expandedYes-NoIndicator](CodeSystem-v2-0532.md) | HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". Used in numerous locations in HL7 Version 2.x messaging. |
| [extendedPriorityCodes](CodeSystem-v2-0485.md) | Code system of concepts describing the urgency of a request carried in an order. Used in HL7 Version 2.x messaging in timing/quantity; in older versions of the Standard was used in the TQ datatype, but in later versions it is used in the TQ1 segment (which replaced the TQ datatype which has been withdrawn). |
| [facilityType](CodeSystem-v2-0331.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [file-levelEvent](CodeSystem-v2-0178.md) | HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [fillerStatus](CodeSystem-v2-0278.md) | Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the SCH segment. |
| [formularyStatus](CodeSystem-v2-0473.md) | Code system of concepts specifying whether or not the service (pharmaceutical) is in the formulary. Used in HL7 Version 2.x messaging in the OM7 segment. |
| [formularyStatus](CodeSystem-v2-0478.md) | HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary. Used in HL7 Version 2.x messaging in the RXE segment. |
| [gestationCategory](CodeSystem-v2-0424.md) | HL7-defined code system of concepts which specify the status of a birth in relation to the gestation. Used in HL7 Version 2 messaging in the ABS segment. |
| [governmentReimbursementProgram](CodeSystem-v2-0401.md) | Code system of concepts which specify codes that indicate an agency that the practitioner is authorized to bill for medical services. Existing codes only for use in the United States. Used in HL7 Version 2.x messaging in the PRA segment. |
| [grouperStatus](CodeSystem-v2-0734.md) | Code system of concepts specifying the status of a grouper in general. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. |
| [hospitalService](CodeSystem-v2-0069.md) | Code system of concepts specifying the treatment or type of surgery the patient is scheduled to receive. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [identifierType](CodeSystem-v2-0203.md) | HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. |
| [identityMayBeDivulged](CodeSystem-v2-0243.md) | HL7-defined code system of concepts used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. Used in HL7 Version 2.x messaging in the PEO segment. |
| [identityReliability](CodeSystem-v2-0445.md) | Code system of concepts specifying the reliability of patient/person identifying data transmitted via a transaction. Used in HL7 Version 2.x messaging in the PID segment. |
| [immunizationRegistryStatus](CodeSystem-v2-0441.md) | Code system of concepts specifying the immunization registry status of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [inactiveReason](CodeSystem-v2-0540.md) | Code system of concepts specifying the reason the staff member is inactive. Used in HL7 Version 2 messaging in the STF segment. |
| [incidentType](CodeSystem-v2-0428.md) | HL7-defined code system of concepts which specify a classification of types of incidents. Used in HL7 Version 2 messaging in the RMI segment. |
| [indirectExposureMechanism](CodeSystem-v2-0253.md) | HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient. Used in HL7 Version 2.x messaging in the PCR segment. |
| [informInstructions](CodeSystem-v2-0517.md) | Code system of concepts specifying who (if anyone) should or should not be informed of an error. Used in the Error (ERR) segment in HL7 Version 2.x messaging. |
| [institutionRelationshipType](CodeSystem-v2-0538.md) | Code system of concepts specifying the relationship the staff person has with the institution for whom he/she provides services. Used in HL7 Version 2 messaging in the STF segment. |
| [insuranceCompanyContactReason](CodeSystem-v2-0232.md) | Code system of concepts used to describe why an insurance company has been contacted. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [intendedProcedureType](CodeSystem-v2-0933.md) | HL7-defined code system of concepts specifying the type of intended procedure. Used in HL7 Version 2.x messaging in the DON segment. |
| [invocationEvent](CodeSystem-v2-0100.md) | HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity. Used in HL7 Version 2.x messaging in the CCD and BLG segments. |
| [invoiceControl](CodeSystem-v2-0553.md) | Code system of concepts used to specify what action is being performed by this message. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [invoiceProcessingResultsStatus](CodeSystem-v2-0571.md) | Code system of concepts used to specify the processing status for an Invoice Processing Result. Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging. |
| [invoiceReason](CodeSystem-v2-0554.md) | Code system of concepts used to specify the reason for this invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [invoiceType](CodeSystem-v2-0555.md) | Code system of concepts used to specify the type of invoice. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [itemImportance](CodeSystem-v2-0634.md) | Code system of concepts that denote a level or importance of an inventory item within the context of an inventory location. Used in HL7 Version 2.x messaging in the IVT segment. |
| [itemStatus](CodeSystem-v2-0625.md) | Code system of concepts that identify the state of an inventory item within the context of an inventory location. Used in HL7 Version 2.x messaging in the IVT segment. |
| [itemStatus](CodeSystem-v2-0776.md) | Code system of concepts specifying the status (useful for reporting and item usage purposes) that applies to an item. Used in HL7 Version 2.x messaging in the ITM segment. |
| [itemType](CodeSystem-v2-0778.md) | Code system of concepts specifying a classification of material items into like groups as defined and utilized within an operating room setting for charting procedures. Used in HL7 Version 2.x messaging in the ITM segment. |
| [jobStatus](CodeSystem-v2-0311.md) | HL7-defined code system of concepts specifying the next of kin/associated party's job status. Used in HL7 Version 2.x messaging in the Next of Kin/Associated Parties (NK1) segment. |
| [jurisdictionalBreadth](CodeSystem-v2-0547.md) | Code system of concepts specifying the breadth/extent of the jurisdiction where the qualification is valid. Used in HL7 Version 2 messaging in the CER segment. |
| [kindOfQuantity](CodeSystem-v2-0254.md) | HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation. These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth. These are discussed more fully in the LOINC Users’ Manual. These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book. These distinctions are used in IUPAC and LOINC standard codes. Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary. |
| [laborCalculationType](CodeSystem-v2-0651.md) | Code system of concepts that identify the method used to calculate employee labor and measure employee productivity. Used in HL7 Version 2.x messaging in the SCP segment. |
| [languageAbility](CodeSystem-v2-0403.md) | Code system of concepts which specify codes that indicate the ability that a Staff Member possesses with respect to the language. Used in HL7 Version 2.x messaging in the LAN segment. |
| [languageProficiency](CodeSystem-v2-0404.md) | HL7-defined code system of concepts which specify a level of knowledge that a Staff Member possesses with respect to their language ability. Used in HL7 Version 2 messaging in the LAN segment. |
| [levelOfCare](CodeSystem-v2-0263.md) | Code system of concepts used to identify the level of care a patient may be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [limitationTypeCode](CodeSystem-v2-0940.md) | HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x messaging in the DPS segment. |
| [livingArrangement](CodeSystem-v2-0220.md) | Code system of concepts characterizing the situation that patient-associated parties live in at their residential address. Used in HL7 Version 2.x messaging in the NK1 and PD1 segments. |
| [livingDependency2](CodeSystem-v2-0223.md) | HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs. This information can be used for discharge planning. Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent. Used in Version 2.s messaging in the NK1 segment. |
| [livingWillCodes](CodeSystem-v2-0315.md) | Code system of concepts specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [loadStatus](CodeSystem-v2-0669.md) | Code system of concepts used to define the status of the information provided in a device sterilization or decontamination cycle. Used in HL7 Version 2.x messaging in the SDD segment. |
| [local-remoteControlState](CodeSystem-v2-0366.md) | HL7-defined code system of concepts that identify the current state of control associated with the equipment. Equipment can either work autonomously ('Local' control state) or it can be controlled by another system, e.g., LAS computer ('Remote' control state). Used in the Equipment Detail (EQU) segment in HL7 Version 2.x messaging. |
| [locationCharacteristic](CodeSystem-v2-0324.md) | Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment. |
| [locationEquipment](CodeSystem-v2-0261.md) | Code system of concepts used to identify the equipment available in a location definition identified as a room or bed. Used in HL7 Version 2.x messaging in the LOC segment. |
| [locationRelationship](CodeSystem-v2-0325.md) | Code system of concepts specifying an identifier code to show which relationship is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Relationship (LRL) segment. |
| [locationServiceType](CodeSystem-v2-0442.md) | Code system of concepts specifying the types of services provided by the location. Used in HL7 Version 2.x messaging in the LOC segment. |
| [lotControl](CodeSystem-v2-0659.md) | Code system of concepts that define whether the sterilization load for a device is built in the sub-sterile area adjacent to an Operating Room or the Central Processing Department. Used in HL7 Version 2.x messaging in the SCP segment. |
| [mailClaimParty](CodeSystem-v2-0137.md) | Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [maritalStatus](CodeSystem-v2-0002.md) | Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. |
| [marketingBasis](CodeSystem-v2-0330.md) | HL7-defined code system of concepts used to specify the basis for marketing approval. Used in HL7 Version 2.x messaging in the Product Detail Country (PDC) segment. |
| [masterFileIdentifierCodes](CodeSystem-v2-0175.md) | HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. |
| [masterfileActionCode](CodeSystem-v2-0180.md) | HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment. |
| [matchAlgorithms](CodeSystem-v2-0393.md) | Code system of concepts identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer. Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment. |
| [matchReason](CodeSystem-v2-0392.md) | Code system of concepts identifying what search components (e.g., name, birthdate, social security number) of the record returned matched the original query where the responding system does not assign numeric match weights or confidence levels. It provides a method for passing a descriptive indication of the reason a particular record was found. Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment. |
| [medicalRoleExecutingPhysician](CodeSystem-v2-0882.md) | Code system of concepts specifying the role of the physician ("self-employed" or "employed"). Used in HL7 Version 2.x messaging in the PSL segment. |
| [messageErrorCondition](CodeSystem-v2-0357.md) | HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ERR segment in HL7 Version 2.x messaging. |
| [messageStructure](CodeSystem-v2-0354.md) | HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard. Used in HL7 Version 2.x messaging in the MSH segment. |
| [messageType](CodeSystem-v2-0076.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [messageWaitingPriority](CodeSystem-v2-0520.md) | HL7-defined code system of concepts which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.). Used in HL7 Version 2.x messaging in the MSA segment. |
| [mfnRecord-levelErrorReturn](CodeSystem-v2-0181.md) | Code system of concepts specifying the status of the requested update. Site-defined table, specific to each master file being updated via this transaction. Used in HL7 Version 2.x messaging in the MFA segment. |
| [militaryService](CodeSystem-v2-0140.md) | Code system of concepts which specify the military branch. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [militaryStatus](CodeSystem-v2-0142.md) | Code system of concepts which specify the military status of the patient. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [mimeBase64EncodingCharacters](CodeSystem-v2-0290.md) | HL7-defined code system of concepts specifying the characters used in the MIME Base 64 encoding mechanism. These are for reference only, as they are not carried as explicit code values in any HL7 coded field. This table was published only in releases 2.3, 2.3.1, and 2.4 of the Standard, and was removed thereafter. |
| [mimeTypes](CodeSystem-v2-0834.md) | Code system of concepts specifying the general type of data. Used in HL7 Version 2.x messaging in the RP and ED datatypes. |
| [modifyIndicator](CodeSystem-v2-0395.md) | HL7-defined code system of concepts identifying whether the subscription is new or is being modified. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [moneyOrPercentageIndicator](CodeSystem-v2-0148.md) | HL7-defined code system of concepts which specify whether the amount is currency or a percentage. Used in HL7 Version 2.x messaging in the MOP segment. |
| [name-addressRepresentation](CodeSystem-v2-0465.md) | HL7-defined code system of concepts specifying an indication of the representation provided by the data item. Used in HL7 Version 2.x messaging in the PPN, XAD, XCN and XON segments. |
| [name-addressRepresentation](CodeSystem-v2-4000.md) | HL7-defined cdoe system of concepts that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data. It is used to provides hints for a receiver, so it can make choices regarding what it has been sent and what it is capable of displaying. |
| [nameAssemblyOrder](CodeSystem-v2-0444.md) | Code system of concepts specifying the preferred display order of the components of this person name. Used in HL7 Version 2.x messaging in the PPN, XCN and XPN segments. |
| [nameType2](CodeSystem-v2-0200.md) | HL7-defined code system of concepts for types of names for persons. Used in HL7 Version 2.x messaging in the XPN, PPN, XCN, PID and MRG segments. |
| [natureOfAbnormalTesting](CodeSystem-v2-0080.md) | HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. |
| [natureOfChallenge](CodeSystem-v2-0257.md) | HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [natureOfServiceTestObservation](CodeSystem-v2-0174.md) | Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [newbornType](CodeSystem-v2-0425.md) | HL7-defined code system of concepts which specify whether the baby was born in or out of a specified facility. Used in HL7 Version 2 messaging in the ABS segment. |
| [non-subjectConsenterReason](CodeSystem-v2-0502.md) | HL7-defined code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent. Used in the Consent (CON) segment in HL7 Version 2.x messaging. |
| [observationResultHandling](CodeSystem-v2-0507.md) | Code system of concepts regarding the handling of a result. For example, an order may specify that the result (e.g., an x-ray film) should be given to the patient for return to the requestor. Used in HL7 Version 2.x messaging in the OBR segment. |
| [observationResultStatusCodesInterpretation](CodeSystem-v2-0085.md) | HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. |
| [observationSubtype](CodeSystem-v2-0937.md) | HL7-defined code system of concepts specifying the observation sub-type. Used in HL7 Version 2.x messaging in the OBX segment. |
| [observationType](CodeSystem-v2-0936.md) | HL7-defined code system of concepts specifying types of observations to enable systems to distinguish between observations sent along with an order, versus observations sent as the result to an order. Used in HL7 Version 2.x messaging in the OBX segment. |
| [onlineVerificationResult](CodeSystem-v2-0970.md) | Code values used to indicate the result of an online verification of insurance data. |
| [onlineVerificationResultErrorCodes](CodeSystem-v2-0971.md) | Code values representing a type of error from a failed operation to perform online verification of insurance data. |
| [orderControlCodeReason](CodeSystem-v2-0949.md) | HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used in HL7 Version 2 messaging in the ORC segment. |
| [orderControlCodes](CodeSystem-v2-0119.md) | HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. |
| [orderStatus](CodeSystem-v2-0038.md) | HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. |
| [orderStatusModifier](CodeSystem-v2-0950.md) | HL7-defined code system of concepts used to further define the status identified in ORC-5. Used in HL7 Version 2 messaging in the ORC segment. |
| [orderType](CodeSystem-v2-0482.md) | HL7-defined code system of concepts specifying whether the order is to be executed in an inpatient setting or an outpatient setting. Used in HL7 Version 2.x messaging in the ORC segment. |
| [organDonorCodes](CodeSystem-v2-0316.md) | Code system of concepts specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [organization-Agency-Department](CodeSystem-v2-0530.md) | Code system of concepts used to specify the agency or department that assigned the identifier in component 1. Used in the Performing Person Time Stamp (PPN), Extended Composite ID Number and Name for Persons (XCN) and Extended Composite ID with Check Digit (CX) segments in HL7 Version 2.x messaging. |
| [organizationUnitType](CodeSystem-v2-0406.md) | HL7-defined code system of concepts which identify an environment in which a provider acts in a specified role. The provider environment is not the specialty for the provider. This is intended to allow communication of this information when the provider information may not have been communicated previously in a master file, and is used to support international requirements. Used in HL7 Version 2 messaging in the PRT and ROL segments. |
| [organizationUnitType](CodeSystem-v2-0474.md) | Code system of concepts specifying the classification of the organization unit. Used in HL7 Version 2.x messaging in the ORG segment. |
| [organizationalNameType](CodeSystem-v2-0204.md) | Code system of concepts used to specify the type of name for an organization i.e., legal name, display name. Used in HL7 Version 2.x messaging in the XON and PD1 segments. |
| [outlierType](CodeSystem-v2-0083.md) | HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid. Used in HL7 Vesrion 2.x messaghing in the DRG segment. |
| [overallClaimDisposition](CodeSystem-v2-0457.md) | Code system of concepts specifying the final status of the claim. Used in HL7 Version 2.x messaging in the GP1 segment. |
| [override](CodeSystem-v2-0268.md) | Code system of concepts used to define whether a Charge Description Master description may be overridden or if it must be overridden. Used in HL7 Version 2.x messaging in the CDM and PRC segments. |
| [overrideType](CodeSystem-v2-0518.md) | Code system of concepts used to specify what type of override can be used to override the specific error identified. Used in HL7 Version 2 messaging in the ERR and OVR segments. |
| [package](CodeSystem-v2-0818.md) | Code system of concepts specifying the packaging unit in which this inventory supply item can be ordered or issued when purchased from the vendor in the related vendor segment. Used in HL7 Version 2.x messaging in the PKG segment. |
| [packagingStatus](CodeSystem-v2-0469.md) | Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [participation](CodeSystem-v2-0912.md) | HL7-defined code system of concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the PRT segment. |
| [patientClass](CodeSystem-v2-0004.md) | Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. |
| [patientCondition](CodeSystem-v2-0434.md) | Code system of concepts specifying the patient's current medical condition for the purpose of communicating to non-medical outside parties, e.g. family, employer, religious minister, media, etc. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [patientLocationType](CodeSystem-v2-0260.md) | Code system of concepts used to identify the kind of location described in the location definition. Used in HL7 Version 2.x messaging in the LOC segment. |
| [patientOutcome](CodeSystem-v2-0241.md) | HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care. Used in HL7 Version 2.x messaging in the PEO segment. |
| [patientResultsReleaseCategorizationScheme](CodeSystem-v2-0909.md) | HL7-defined code system of concepts specifying the scheme for the patient results release categorization. Used in HL7 Version 2.x messaging in the OBX segment. |
| [patientStatus](CodeSystem-v2-0216.md) | Code system of concepts used to define the state of a care episode for a patient. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [patientsRelationshipToInsured](CodeSystem-v2-0344.md) | Code system of concepts used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the Insurance Additional Information (IN2) segment. |
| [payeeRelationshipToInvoice](CodeSystem-v2-0558.md) | Code system of concepts used to specify the relationship to the invoice for Person Payee Types. Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. |
| [payeeType](CodeSystem-v2-0557.md) | Code system of concepts used to specify the type of payee (e.g., organization, person). Used in the Payee Information (PYE) segment in HL7 Version 2.x messaging. |
| [paymentAdjustmentInformation](CodeSystem-v2-0468.md) | Code system of concepts specifying any payment adjustment due to drugs or medical devices. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [paymentMethod](CodeSystem-v2-0570.md) | Code system of concepts used to specify the method for the movement of payment. Used in the Payment Information (PMT) segment in HL7 Version 2.x messaging. |
| [pcaType](CodeSystem-v2-0918.md) | HL7-defined code system of concepts specifying the type of PCA. Used in HL7 Version 2.x messaging in the RXV segment. |
| [personLocationType](CodeSystem-v2-0305.md) | Code system of concepts specifying the categorization of the person's location. Used in HL7 Version 2.x messaging datatypes that contain location identifiers such as Person Location (PL), Location with address variation (LA) and Name with date and location (NDL). |
| [pharmacyOrderTypes](CodeSystem-v2-0480.md) | HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take. Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments. |
| [phlebotomyIssue](CodeSystem-v2-0925.md) | HL7-defined code system of concepts specifying the phlebotomy issue. Used in HL7 Version 2.x messaging in the DON segment. |
| [phlebotomyStatus](CodeSystem-v2-0926.md) | HL7-defined code system of concepts specifying the status of the phlebotomy. Used in HL7 Version 2.x messaging in the DON segment. |
| [policyType](CodeSystem-v2-0147.md) | Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PTA segment. |
| [precaution](CodeSystem-v2-0433.md) | Code system of concepts specifying non-clincal precautions that need to be taken with the patient. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [precision](CodeSystem-v2-0529.md) | HL7-defined code system of concepts specifying the degree of precision of the time stamp (Y = year, L = month, D = day, H = hour, M = minute, S = second). Used in HL7 Version 2 messaging in the TS datatype. Note deprecated in 2.5.1 and retained only for backward compatibility, as the datatypes and architecture for the degree of precision for timestamps was changed. |
| [preferredMethodOfContact](CodeSystem-v2-0185.md) | HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person. Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments. |
| [preferredSpecimen-AttributeStatus](CodeSystem-v2-0920.md) | HL7-defined code system of concepts that indicate whether a Specimen/Attribute is Preferred or Alternate for collection of a particular specimen. Used in HL7 Version 2.x messaging in Master Files (OM4 segment) to characterize information about specimens that are associated with certain observations. |
| [priceType](CodeSystem-v2-0205.md) | HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing transaction. Used in HL7 Version 2.x messaging in the CP datatype. |
| [primaryKeyValueType](CodeSystem-v2-0355.md) | HL7-defined code system of concepts used to specify the type for the master file record identifier. Used in HL7 Version 2.x messaging in the Master File Entry (MFE) segment. |
| [primaryObserverQualification](CodeSystem-v2-0242.md) | HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation. Used in HL7 Version 2.x messaging in the PEO and PCR segments. |
| [priority](CodeSystem-v2-0027.md) | HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [privacyLevel](CodeSystem-v2-0262.md) | Code system of concepts used to identify the level of privacy a patient will be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [problem-goalAction](CodeSystem-v2-0287.md) | HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments. |
| [procedureDrgType](CodeSystem-v2-0416.md) | HL7-defined code system of concepts which specify a procedure’s priority ranking relative to its DRG. Used in HL7 Version 2 messaging in the PR1 segment. |
| [procedureFunctionalType](CodeSystem-v2-0230.md) | Code system of concepts used to classify a procedure. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [procedurePractitionerIdentifierCodeType](CodeSystem-v2-0133.md) | HL7-defined table of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment. Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole. |
| [procedurePriority](CodeSystem-v2-0418.md) | HL7-defined code system of concepts which specify the significance or priority of a procedure code. Used in HL7 Version 2 messaging in the PR1 segment. Note that this is a post-coordinated code system, where additional ordinal priorities are created by incrementing the numericinteger code value as needed. Only the first 2 ordinal values are predefined in the code system. |
| [processInterruption](CodeSystem-v2-0923.md) | HL7-defined code system of concepts specifying whether the process was interrrupted and whether the needle had been inserted in the donor's arm prior to the interruption. Used in HL7 Version 2.x messaging in the DON segment. |
| [processInterruptionReason](CodeSystem-v2-0935.md) | HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL7 Version 2.x messaging in the DON segment. |
| [processingConsideration](CodeSystem-v2-0562.md) | Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [processingId](CodeSystem-v2-0103.md) | HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system. Used in HL7 Version 2.x messaging in the PT datatype. |
| [processingMode](CodeSystem-v2-0207.md) | HL7-defined code system of concepts that indicate an archival process or an initial load process. Used in HL7 Version 2.x messaging in the PT datatype. |
| [processingPriority](CodeSystem-v2-0168.md) | HL7-defined code system of concepts which specify one or more available priorities for performing the observation or test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [processingType](CodeSystem-v2-0388.md) | HL7-defined code system of concepts identifying the processing type that applies to the test code. If this attribute is omitted, then regular production is the default. Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment. |
| [product-serviceStatus](CodeSystem-v2-0559.md) | Code system of concepts used to specify the processing status for the Product/Service Code. Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [product-servicesClarification](CodeSystem-v2-0561.md) | Code system of concepts used to specify the Product/Service Code. Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. |
| [productSource](CodeSystem-v2-0248.md) | HL7-defined code system of concepts used to describe the evaluation state of a product identified in an incident. Used in HL7 Version 2.x messaging in the PCR segment. |
| [productionClass](CodeSystem-v2-0429.md) | Code system of concepts specifying the code and/or text indicating the primary use for which the living subject was bred or grown. Used in HL7 Version 2.x messaging in the PID segment. |
| [protection](CodeSystem-v2-0618.md) | Code system of concepts specifying that an address needs to be treated with special care or sensitivity. Used in HL7 Version 2.x messaging in the XAD and XTN segments. |
| [providerAdjustmentReason](CodeSystem-v2-0565.md) | Code system of concepts used to specify the reason for this adjustment. Used in the Adjustment (ADJ) segment in HL7 Version 2.x messaging. |
| [providerBilling](CodeSystem-v2-0187.md) | HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Version 2.x messaging in the PRA segment. |
| [providerRole](CodeSystem-v2-0286.md) | Code system of concepts used to define the relationship between a referral recipient and a patient or between a referral initiator and a patient. Used in HL7 Version 2.x messaging in the PRD segment. |
| [providerRole](CodeSystem-v2-0443.md) | Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the ROL segment. |
| [publicity](CodeSystem-v2-0215.md) | Code system of concepts specifying a level of publicity of information about a patient for a specific visit. Used in HL7 Version 2.x messaging in the PV2 and PD1 segments. |
| [purgeStatus](CodeSystem-v2-0213.md) | Code system of concepts used to define the state of a visit relative to its place in a purge workflow. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [quantityLimitedRequest](CodeSystem-v2-0126.md) | HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. Used in HL7 Version 2.x messaging in the RCP segment. |
| [quantityMethod](CodeSystem-v2-0329.md) | HL7-defined code system of concepts used to specify the method by which the quantity distributed is measured. Used in HL7 Version 2.x messaging in the Product Summary Header (PSH) segment. |
| [queryPriority](CodeSystem-v2-0091.md) | HL7-defined code system of concepts which specify a time frame in which a querry response is expected. Used in HL7 Verson 2.x messaging in the RCP segment. |
| [queryResponseFormat](CodeSystem-v2-0106.md) | HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query. Used in HL7 Version 2 messaging in the EQL segment. |
| [queryResponseStatus](CodeSystem-v2-0208.md) | HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging. It is commonly used to indicate no data is found that matches the query parameters, but no error. Used in HL7 Version 2.x messaging in the QAK segment. |
| [queryResultsLevel](CodeSystem-v2-0108.md) | HL7-defined code system of concepts which are used to control level of detail in query results. Used in HL7 Version 2 messaging in the URD segment. |
| [re-admissionIndicator](CodeSystem-v2-0092.md) | Code system of concepts which are used to specify that a patient is being re admitted to a healthcare facilityin from which they were discharged, and indicates the circumstances around such re-admission. Used in HL7 Version 2.x messagine in the PV1 segment. |
| [reasonForStudy](CodeSystem-v2-0951.md) | HL7-defined code system of concepts that provide additional information to the universal service identifier on why a test, study or review was ordered. Initial values are to support the IHE LCC LAB-7 transaction. |
| [recreationalDrugType](CodeSystem-v2-0431.md) | Code system of concepts specifying what recreational drugs the patient uses. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [referralCategory](CodeSystem-v2-0284.md) | Code system of concepts used to describe the patient care setting where a referral should take place. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [referralDisposition](CodeSystem-v2-0282.md) | Code system of concepts used to identify the expected response from the healthcare professional receiving a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [referralPriority](CodeSystem-v2-0280.md) | Code system of concepts used to designate the urgency of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [referralReason](CodeSystem-v2-0336.md) | Code system of concepts used to specify the reason for which the referral will take place. Used in HL7 Version 2.x messaging in the Referral Information (RF1) segment. |
| [referralStatus](CodeSystem-v2-0283.md) | Code system of concepts used to define the state of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [referralType](CodeSystem-v2-0281.md) | Code system of concepts used to identify the general category of healthcare professional desired to satisfy a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [reimbursementType](CodeSystem-v2-0470.md) | Code system of concepts specifying the fee schedule reimbursement type applied to the line item. Used in HL7 Version 2.x messaging in the GP2 segment. |
| [relatednessAssessment](CodeSystem-v2-0250.md) | HL7-defined code system of concepts used to provide an estimate of whether an issue with a product was the cause of an event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [relationalConjunction](CodeSystem-v2-0210.md) | HL7-defined code system of concepts used with relationalOperator values to group more than one segment field name. Used in HL7 Version 2.x messaging in the QSC segment. |
| [relationalOperator](CodeSystem-v2-0209.md) | HL7-defined code system of concepts used to define the relationship between HL7 segment field names identified in a query construct. Used in HL7 Version 2.x messaging in the QSC segment. |
| [relationship](CodeSystem-v2-0063.md) | HL7-defined code system of concepts specifying an actual personal relationship that the next of kin/associated party has to a patient. Used in HL7 Version 2.x messaging in the NK1 and IN1 segments. |
| [relationshipModifier](CodeSystem-v2-0258.md) | HL7-defined code system of concepts used in an observation definition to describe the subject of an observation in relation to a patient. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [relevantClincialInformation](CodeSystem-v2-0916.md) | Code system of concepts specifying additional clinical information about the patient or specimen to report the supporting and/or suspected diagnosis and clinical findings on requests for interpreted diagnostic studies. Used in HL7 Version 2.x messaging in the OBR segment. |
| [religion2](CodeSystem-v2-0006.md) | Code system of concepts specifying a person's religion. Used in HL7 Version 2.x messaging in the PID segment. |
| [remoteControlCommand](CodeSystem-v2-0368.md) | Code system of concepts that identify the comment the component is to initiate. Used in the Equipment Command (ECD) and Interaction Status Detail (ISD) segments in HL7 Version 2.x messaging. |
| [reorderTheory](CodeSystem-v2-0642.md) | Code system of concepts that identify the calculation method used to determine the resupply schedule. Used in HL7 Version 2.x messaging in the IVT segment. |
| [repeatPattern](CodeSystem-v2-0335.md) | Code system of concepts used to specify the interval between repeated services. Used in HL7 Version 2.x messaging in the RI datatype and RPT segment. |
| [reportPriority](CodeSystem-v2-0109.md) | HL7-defined code system of concepts which specify the priority associated with a report or update run using a query. Used in HL7 Version 2 messaging in the URD segment. |
| [reportSource](CodeSystem-v2-0235.md) | HL7-defined code system of concepts used to identify where a report sender learned about an event. Used in HL7 Version 2.x messaging in the PES segment. |
| [reportTiming](CodeSystem-v2-0234.md) | HL7-defined code system of concepts used to identify the time span of a report or the reason for a report sent to a regulatory agency. Used in HL7 Version 2.x messaging in the PES segment. |
| [reportingPriority](CodeSystem-v2-0169.md) | HL7-defined code system of concepts which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [responseFlag](CodeSystem-v2-0121.md) | HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. |
| [responseLevel](CodeSystem-v2-0179.md) | HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. Used in HL7 Version 2.x messaging in the MFI segment. |
| [responseModality](CodeSystem-v2-0394.md) | HL7-defined code system of concepts identifying the timing and grouping of the response message(s). Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [resultStatus](CodeSystem-v2-0123.md) | HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [riskManagementIncident](CodeSystem-v2-0427.md) | HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay. Used in HL7 Version 2 messaging in the RMI segment. |
| [risks](CodeSystem-v2-0489.md) | Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. Used in HL7 Version 2.x messaging in the SPM and PAC segments. |
| [roleExecutingPhysician](CodeSystem-v2-0881.md) | Code system of concepts specifying the account role of the physician, for example, only billing for the professional part, the technical part or both. Used in HL7 Version 2.x messaging in the PSL segment. |
| [roomType](CodeSystem-v2-0145.md) | Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [rootCause](CodeSystem-v2-0914.md) | Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX segment. |
| [route](CodeSystem-v2-0033.md) | HL7-defined code system of concepts that indicate a means of administrating a medication dose. Used in HL7 Version 2 messaging in the RX1 segment (which was withdrawn after version 2.2). As of HL7 version 2.3, it was replaced by 2.16.840.1.113883.18.80 routeOfAdministration and 2.16.840.1.113883.18.83 administrationMethod. Used in the RX1 segment. |
| [routeOfAdministration](CodeSystem-v2-0162.md) | Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messaging in the RXR segment. |
| [rulingAct](CodeSystem-v2-0793.md) | Code system of concepts specifying an act containing a rule that the item is legally required to be included in notification reporting. Used in HL7 Version 2.x messaging in the ITM segment. |
| [rxComponentType](CodeSystem-v2-0166.md) | HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x messaging in the RXC segment. |
| [schoolType](CodeSystem-v2-0402.md) | Code system of concepts which specify a categorization of an academic institution that grants a degree to a Staff Member. Used in HL7 Version 2.x messaging in the EDU segment. |
| [securityCheckScheme](CodeSystem-v2-0904.md) | HL7-defined code system of concepts specifying the scheme for the security check. Used in HL7 Version 2.x messaging in the CX datatypes and PPN and XCN segments. |
| [segmentAction](CodeSystem-v2-0206.md) | HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments. |
| [segmentGroup](CodeSystem-v2-0391.md) | HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response. This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [sensitivityToCausativeAgent](CodeSystem-v2-0436.md) | Code system of concepts specifying the reason the patient should not be exposed to a substance. Used in HL7 Version 2.x messaging in the IAM segment. |
| [sequenceCondition](CodeSystem-v2-0504.md) | HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4. Used in HL7 Version 2.x messaging in the TQ2 segment. |
| [sequenceCondition](CodeSystem-v2-0524.md) | HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle of orders is defined. This is part of the Order Sequence Definition used in HL7 Version 2.x messaaging in the OSD datatype. |
| [sequenceResultsFlag](CodeSystem-v2-0503.md) | HL7-defined code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [sequenceStatus](CodeSystem-variant-state.md) | Codes providing the status of the variant test result. |
| [sequencing](CodeSystem-v2-0397.md) | HL7-defined code system of concepts identifying how the field or parameter will be sorted and, if sorted, whether the sort will be case sensitive (the default) or not. Used in HL7 Version 2.x messaging in the Sort Order (SRT) value. |
| [serviceRequestRelationship](CodeSystem-v2-0506.md) | HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. |
| [severityOfIllness](CodeSystem-v2-0421.md) | HL7-defined code system of concepts which specify the ranking of a patient’s illness. Used in HL7 Version 2 messaging in the ABS segment. |
| [shipmentStatus](CodeSystem-v2-0905.md) | HL7-defined code system of concepts specifying the status of the shipment. Used in HL7 Version 2.x messaging in the SHP segment. |
| [sideOfBody](CodeSystem-v2-0894.md) | Code system of concepts specifying the side of the body ("left" or "right"). Used in HL7 Version 2.x messaging in the PSL segment. |
| [signatorysRelationshipToSubject](CodeSystem-v2-0548.md) | Code system of concepts specifying the relationship of the consenter to the subject. Used in HL7 Version 2 messaging in the CON segment. |
| [signatureType](CodeSystem-v2-0535.md) | Code system of concepts that indicate how a patient/subscriber authorization signature is obtained and how it is being retained by a provider. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [siteAdministered](CodeSystem-v2-0034.md) | HL7-defined code system of concepts used for medication administration sites. Used only in HL7 releases 2.1 and 2.2; as of 2.3 the model for this was changed and the field using this code system was removed from the Standard. |
| [sourceOfComment](CodeSystem-v2-0105.md) | HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7 Version 2.x messaging in the NTE segment. |
| [sourceType](CodeSystem-v2-0332.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [specialHandling](CodeSystem-v2-0376.md) | Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments. |
| [specialProgram](CodeSystem-v2-0214.md) | Code system of concepts used to record a health insurance program required for healthcare visit reimbursement. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [specialtyType](CodeSystem-v2-0265.md) | Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition. Used in HL7 Version 2.x messaging in the LDP segment. |
| [specimenAction](CodeSystem-v2-0065.md) | HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. |
| [specimenAppropriateness](CodeSystem-v2-0492.md) | Code system of concepts specifying the suitability of the specimen for the particular planned use as determined by the filler. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenChildRole](CodeSystem-v2-0494.md) | HL7-defined code system of concepts specifying for child specimens the relationship between this specimen and the parent specimen. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenCollectionMethod](CodeSystem-v2-0488.md) | HL7-defined code system of concepts specifying the specimen collection method. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenComponent](CodeSystem-v2-0372.md) | Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [specimenCondition](CodeSystem-v2-0493.md) | Code system of concepts specifying a mode or state of being that describes the nature of the specimen. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenQuality](CodeSystem-v2-0491.md) | Code system of concepts specifying the degree or grade of excellence of the specimen at receipt. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenRejectReason](CodeSystem-v2-0490.md) | HL7-defined code system of reasons a specimen may be rejected for a specified observation/result/analysis. Used in HL7 Version 2.x messaging in the SPM segment. |
| [specimenRole](CodeSystem-v2-0369.md) | HL7-defined code system of concepts that identify the role of a sample. Used in HL7 Version 2.x messaging in the Specimen (SPM) and Observation Request (OBR) segments. |
| [specimenSourceCodes](CodeSystem-v2-0070.md) | HL7-defined code system of concepts which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in code system 2.16.840.1.133883.18.311 specimenType and code system 2.16.840.1.133883.18.312 specimenCollectionMethod as of version 2.5 and thereafter. |
| [specimenType](CodeSystem-v2-0487.md) | HL7-defined code system of concepts that describe the precise nature of an entity that may be used as the source material for an observation. This is one of two code systems that are used instead of table 0070 (code system 2.16.840.1.113883.18.28) which conflated specimen types and specimen collection methods. Used in HL7 Version 2.x messaging in the SPM segment. |
| [statusOfEvaluation](CodeSystem-v2-0247.md) | HL7-defined code system of concepts that describes the status of product evaluation. Used in HL7 Version 2.x messaging in the PCR segment. |
| [sterilizationType](CodeSystem-v2-0806.md) | Code system of concepts specifying the type of sterilization used for sterilizing the inventory supply item in the ITM segment. Used in HL7 Version 2.x messaging in the STZ segment. |
| [stockLocation](CodeSystem-v2-0012.md) | Code system of concepts specifying a stock location for older Version 2 messaging systems; not used after version 2.2 of the Standard. |
| [studentStatus](CodeSystem-v2-0231.md) | Code system of concepts used to designate whether a guarantor is a full or part time student. Used in HL7 Version 2.x messaging in the GT1, NK1 and PD1 segments. |
| [substanceStatus](CodeSystem-v2-0383.md) | HL7-defined code system of concepts identifying the status of the inventoried item. The status indicates the current status of the substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. |
| [substanceType](CodeSystem-v2-0384.md) | HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. |
| [substitutionStatus](CodeSystem-v2-0167.md) | HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments. |
| [subtypeOfReferencedData](CodeSystem-v2-0291.md) | Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream. Used in Version 2 messaging ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes. More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml. |
| [supplierType](CodeSystem-v2-0946.md) | Code system that Identifies the type of supplier that will distribute the supply items associated to a contract number. Used in HL7 Version 2.x messaging in the CTR segment. |
| [supplyRisk](CodeSystem-v2-0871.md) | Code system of concepts specifying any known or suspected hazard associated with this material item. Used in HL7 Version 2.x messaging in the ITM segment. |
| [systemInducedContaminants](CodeSystem-v2-0374.md) | Code system of concepts that identify the specimen contaminant identifier associated with the specimen in the container. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [taxStatus](CodeSystem-v2-0572.md) | Code system of concepts used to specify the tax status of the provider. Used in the Invoice (IVC) segment in HL7 Version 2.x messaging. |
| [telecommunicationEquipmentType](CodeSystem-v2-0202.md) | HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [telecommunicationExpirationReason](CodeSystem-v2-0868.md) | Code system of concepts specifying the reason this contact number/email was marked as "ended". Used in HL7 Version 2.x messaging in the XTN segment. |
| [telecommunicationUse](CodeSystem-v2-0201.md) | HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [timeDelayPostChallenge](CodeSystem-v2-0256.md) | HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [timeSelectionCriteriaParameterClass](CodeSystem-v2-0294.md) | Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. Used in HL7 Version 2.x messaging in the SCV and APR segments. |
| [tissueType](CodeSystem-v2-0417.md) | HL7-defined code system of concepts which specify a type of tissue removed from a patient during a procedure. Used in HL7 Version 2 messaging in the PR1 segment. |
| [tqConjunctionId](CodeSystem-v2-0472.md) | HL7-defined code system of concepts specifying that a second timing specification is to follow using the repeat delimiter. Used in HL7 Version 2.x messaging in the TQ1 segment. |
| [transactionType](CodeSystem-v2-0017.md) | Code system of concepts specifying a type of financial transaction. Used in HL7 Version 2.x messaging in the FT1 segment. |
| [transfusionAdverseReaction](CodeSystem-v2-0514.md) | Code system of concepts used to specify the type of adverse reaction that the recipient of the blood product experienced. Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. |
| [transportArranged](CodeSystem-v2-0224.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [transportationMode](CodeSystem-v2-0124.md) | HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service. Used in HL7 Version 2.x messaging in the OBR segment. |
| [trayType](CodeSystem-v2-0160.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODT segment. |
| [treatment](CodeSystem-v2-0373.md) | Code system of concepts that identify the specimen treatment performed during lab processing. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. |
| [triageType](CodeSystem-v2-0422.md) | HL7-defined code system of concepts which specify a patient’s prioritization within the context of a transmitted abstract. Used in HL7 Version 2 messaging in the ABS segment. |
| [typeOfAgreement](CodeSystem-v2-0098.md) | Code system of concepts which specify codes to further identify an insurance plan. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [typeOfReferencedData](CodeSystem-v2-0191.md) | HL7-defined code system of concepts declaring the general type of media data that is encoded. Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types). More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml |
| [universalIdType](CodeSystem-v2-0301.md) | HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messaging HD and EI datatypes. |
| [userAuthenticationCredentialType](CodeSystem-v2-0615.md) | HL7-defined code system of concepts specifying a type of user authentication credential. Used in HL7 Version 2.x messaging in the UAC segment. |
| [v2CS-relationshipType](CodeSystem-v2-0948.md) | HL7-defined code system of concepts that identify the type of relationship identified by Relationship Instance Identifier (REL-3) that is established between the Source Information Instance (REL-4) and the Target Information Instance (REL-5). |
| [versionId](CodeSystem-v2-0104.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |
| [visitIndicator](CodeSystem-v2-0326.md) | Code system of concepts specifying the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to indicate that the data sent in the message are at the visit level. Used in HL7 Version 2.x messaging in the Patient Visit (PV1) segment. |
| [visitPriority](CodeSystem-v2-0217.md) | Code system of concepts used to define a relative level of urgency applied to a patient visit. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [visitUserCodes](CodeSystem-v2-0130.md) | Code system of concepts which specify categories of a patient's visit with respect to an individual institution's needs, and is expected to be different on a site-specific basis. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [whatSubjectFilter](CodeSystem-v2-0048.md) | HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. Used in HL7 Version 2 messaging in the URD segment. |
| [whichDate-timeQualifier](CodeSystem-v2-0156.md) | HL7-defined code system of concepts that specify a type of date referred to in query specifications. Used in HL7 Version 2 messaging in the QRF segment. |
| [whichDate-timeStatusQualifier](CodeSystem-v2-0157.md) | HL7-defined code system of concepts that specify the status type of objects selected in a date range. Used in HL7 Vesion 2 messaging in the QRF segment. |

### Terminology: Naming Systems 

These define identifier and/or code system identities used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ABC Codes](NamingSystem-abcCodes.md) | Five character alphabetic codes fit into current claims processing software or onto standard paper claim forms. ABC Codes give business parity to licensed CAM and nurse providers who file claims to insurance companies. . |
| [ADA Universal Tooth Designation System](NamingSystem-ADAUniversalToothDesignationSystem.md) | The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994. The universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. Teeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32). Supernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32). The Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf |
| [AHA NUBC Condition Codes](NamingSystem-AHANUBCConditionCodes.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 18-28 Condition Codes These codes are used to convey the applicable Condition Codes and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." National Uniform Billing Committee Data Element Specifications Change Request Guidelines "The National Uniform Billing Committee (NUBC) holds meetings and conference calls throughout the year and change requests to the UB-04 Manual or UB-04 Data Set may be submitted at any time. To be considered at the next scheduled meeting, requests for changes must be received by the NUBC Secretary at least 45 days in advance. Approved changes are usually effective as of July 1 or about 90 days after approval, as appropriate." For more information and to submit a change request, please see[here](https://www.nubc.org/form/change-request-guidelines-form-n)For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Patient Discharge Status Codes](NamingSystem-AHANUBCPatientDischargeStatus.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 17 - Patient Discharge Status These codes are used to convey the patient discharge status and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Point of Origin for Newborn](NamingSystem-AHANUBCPointOfOriginNewborn.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 15 - Point of Origin for Admission or Visit for Newborn These codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Point of Origin for Non-newborn](NamingSystem-AHANUBCPointOfOriginNonnewborn.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 15 - Point of Origin for Admission or Visit for Non-newborn These codes are used to convey the patient point of origin for an admission or visit and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Priority (Type) of Admission or Visit](NamingSystem-AHANUBCPriorityTypeOfAdmitOrVisit.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 14 - Priority (Type) of Admission or Visit These codes are used to convey the priority of an admission or visit and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Revenue Codes](NamingSystem-AHANUBCRevenueCodes.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 42 - Revenue Codes These codes are used to convey the revenue code and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHA NUBC Type Of Bill Codes](NamingSystem-AHANUBCTypeOfBill.md) | The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified. This code system consists of the following: * FL 04 - Type of Bill Facility Codes * FL 04 - Type of Bill Frequency Codes A code indicating the specific Type of Bill (TOB), e.g., hospital inpatient, outpatient, replacements, voids, etc. The first digit is a leading zero*. The fourth digit defines the frequency of the bill for the institutional and electronic professional claim. Note that with the advent of UB-04, the matrix methodology of constructing the first component of TOB codes according to digit position was abandoned in favor of specifying valid discrete codes. As a result, the first three digits in TOB have no underlying meaning. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)The UB-04 Manual has a 12-month subscription period from June 30 through July 1. |
| [AHA NUBC Value Codes and Amounts](NamingSystem-AHANUBCValueCodesAndAmounts.md) | "The UB-04 Data File contains the complete set of NUBC codes. Every code in the range of possible codes is accounted for sequentially. There are no gaps because all used and unused codes are identified." This code system consists of the following: * FL 39-41 Value Codes and Amounts These codes are used to convey the applicable Value Codes and Amounts and are the property of the American Hospital Association. To obtain the underlying code systems, please see information[here](https://www.nubc.org/subscription-information)Statement of Understanding between AHA and HL7 can be found[here](http://www.hl7.org/documentcenter/public/mou/AHA%20HL7%20SOU%202020%20AHA%20Fully%20Executed.pdf). In particular see sections 4.1d and 4.2. "The UB-04 Manual has a 12-month subscription period from June 30 through July 1." National Uniform Billing Committee Data Element Specifications Change Request Guidelines "The National Uniform Billing Committee (NUBC) holds meetings and conference calls throughout the year and change requests to the UB-04 Manual or UB-04 Data Set may be submitted at any time. To be considered at the next scheduled meeting, requests for changes must be received by the NUBC Secretary at least 45 days in advance. Approved changes are usually effective as of July 1 or about 90 days after approval, as appropriate." For more information and to submit a change request, please see[here](https://www.nubc.org/form/change-request-guidelines-form-n)For frequently asked questions, see here[here](https://www.nubc.org/nubc-faqs) |
| [AHFS Pharmacologic-Therapeutic Classification](NamingSystem-ahfs.md) | **Description:**The AHFS Pharmacologic-Therapeutic Classification has been in use in hospitals in the United States since its inception in 1959. An integral part of the American Hospital Formulary Service, the AHFS classification allows the grouping of drugs with similar pharmacologic, therapeutic, and/or chemical characteristics. Today, the AHFS classification is used by many people outside of hospitals. |
| [AS4 Neurophysiology Codes](NamingSystem-AS4E.md) | AS4 Neurophysiology Codes |
| [ASTM E1238/E1467 Universal](NamingSystem-AS4.md) | ASTM E1238/ E1467 Universal |
| [Active Ingredient Code](NamingSystem-v3-hc-aic.md) | Foreign key for the Active Ingredient Table that relates active ingredients to specific products. Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/read-file-drug-product-database-data-extract.htmll |
| [Active Ingredient Group Code](NamingSystem-v3-hc-aigc.md) | Part of the active ingredient code number starting at position 3 and ending at position 7. Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html |
| [Active Ingredient Group Number](NamingSystem-v3-hc-aign.md) | The AIG number is a 10 digit number that identifies products that have the same active ingredient(s) and ingredient strength(s). The AIG is comprised of three portions:* the first portion (2 digits) identifies the number of active ingredients 
* the second portion(5 digits) identifies the unique groups of active ingredients(s); 
* the last portion (3 digits) identifies the active ingredient group strength. The strength group has a tolerance of -2% to +10%. Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database/terminology.html
 |
| [Alabama Driver's License](NamingSystem-AlabamaDLN.md) | Alabama Motor Vehicle Bureau |
| [Alaska Driver's License](NamingSystem-AlaskaDLN.md) | Alaska Motor Vehicle Bureau |
| [All Patient Diagnosis Related Groups (AP DRGs)](NamingSystem-apdrg.md) | In 1987, the state of New York passed legislation instituting a DRG-based prospective payment system for all non-Medicare patients. The legislation included a requirement that the New York State Department of Health (NYDH) evaluate the applicability of the DRGs to a non-Medicare population. In particular, the legislation required that the DRGs be evaluated with respect to neonates and patients with Human Immunodeficiency Virus (HIV) infections. NYDH entered into an agreement with 3M HIS to assist with the evaluation of the need for DRG modifications as well as to make the necessary changes in the DRG definitions and software. The DRG definitions developed by NYDH and 3M HIS are referred to as the All Patient DRGs (AP DRGs). |
| [All Patient Refined Diagnosis Related Groups (APR DRGs)](NamingSystem-APRDRG.md) | 3M APR DRGs have become the standard across the U.S. for classifying hospital inpatients in non-Medicare populations. As of January 2019, 27 state Medicaid programs use 3M APR DRGs to pay hospitals, as do approximately a dozen commercial payers and Medicaid managed care organizations. Over 2,400 hospitals have licensed 3M APR DRGs to verify payment and analyze their internal operations. The 3M APR DRG methodology classifies hospital inpatients according to their reason for admission, severity of illness and risk of mortality. Each year 3M calculates and releases a set of statistics for each 3M APR DRG based on our analysis of large national data sets. These statistics include a relative weight for each 3M APR DRG. The relative weight reflects the average hospital resource use for a patient in that 3M APR DRG relative to the average hospital resource use of all inpatients. Please note that payers and other users of the 3M APR DRG methodology are responsible for ensuring that they use relative weights that are appropriate for their particular populations. The 3M APR DRG statistics also include data for each 3M APR DRG on relative frequency, average length of stay, average charges and incidence of mortality. 3M APR DRGs can be rolled up into broader categories. The 326 base DRGs roll up into 25 major diagnostic categories (MDCs) plus a pre-MDC category. An example is MDC 04, Diseases and Disorders of the Respiratory System. As well, each 3M APR DRG is assigned to a service line that is consistent with the outpatient service lines that are defined by the 3M™ Enhanced Ambulatory Patient Groups (EAPGs). |
| [American College of Radiology Finding Codes](NamingSystem-ACR.md) | American College of Radiology finding codes |
| [American Dental Association Area of Oral Cavity System](NamingSystem-ADAAreaOralCavitySystem.md) | The Area of Oral Cavity System is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. Area of the oral cavity is designated by a two-digit code. The Area of Oral Cavity System can be found in the ADA Comprehensive ADA Dental Claim Form Completion Instructions (see https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf). For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf |
| [American Dental Association Systematized Nomenclature of Dentistry (SNODENT)](NamingSystem-v3-ada-snodent.md) | Systematized Nomenclature of Dentistry (SNODENT) is owned, maintained and distributed by the American Dental Association (ADA). SNODENT is a vocabulary designed for use in the electronic environment - for electronic health and dental records. The intended purpose is to:* Provide standardized terms for describing dental disease 
* Capture clinical detail and patient characteristics 
* Permit analysis of patient care services and outcomes 
* To be interoperable with Electronic Health Records (EHR) and Electronic Dental Records (EDR) SNODENT licensing information can be found at: [http://www.ada.org/8466.aspx](http://www.ada.org/8466.aspx) URL for Official Source: [http://www.ada.org/snodent.aspx](http://www.ada.org/snodent.aspx)
 |
| [American Dental Association Tooth Surface Codes](NamingSystem-ADAToothSurfaceCodes.md) | Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form. Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces). Tooth Surface Codes can be accessed through the[ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7). A Statement of Understanding (SOU) between ADA and HL7 exists[here](http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf). |
| [Arizona Driver's License](NamingSystem-ArizonaDLN.md) | Arizona Motor Vehicle Bureau |
| [Arkansas Driver's License](NamingSystem-ArkansasDLN.md) | Arkansas Motor Vehicle Bureau |
| [Bluetooth Address as a device identifier](NamingSystem-bluetooth-address-identifier.md) | The Bluetooth Device Address (sometimes referred to as a Bluetooth MAC address) is a unique 48-bit identifier assigned to each Bluetooth device by the manufacturer. Bluetooth Addresses are usually displayed as 6 bytes written in hexadecimal and separated by colons (example - 00:11:22:33:FF:EE). They are an essential part of Bluetooth-based protocols. The upper half of a Bluetooth Address (most-significant 24 bits) is the so-called Organizationally Unique Identifier (OUI). It can be used to determine the manufacturer of a device (Bluetooth MAC Address Lookup form). OUI prefixes are assigned by the Institute of Electrical and Electronics Engineers (IEEE). An EUI (Extended Unique Identifier) is generally made from an OUI and thus a Bluetooth Address is also an EUI-48. A device that has a Bluetooth address can also have it own Ethernet MAC address. |
| [Brazilian Procedure Codes SUS](NamingSystem-v3-brazilianProcedureCodesSUS.md) | Brazilian Procedure Codes used in the National Health System |
| [CAMNCVS](NamingSystem-camncvs.md) | CAM & Nursing Coding Vocabulary Set |
| [CAN/CSA-Z795-96](NamingSystem-csaid.md) | ** Inactvie since 2015. Nature of injury (NOI) codes, which are part of the Work Injury or Disease Information coding system (CAN/CSA-Z795-96 - R2003). The CSA code set includes 3 parts: Nature of injury (NOI), body part (BP), side of body (SB). For example:* NOI - Cut or laceration Injury = 03400 
* BP - Upper Arm body part = 31100 
* SOB - Left Side of Body = L The Body Part codes are qualified by the Side of Body codes code system, to be more precise in specifying the location of the injury being coded. Code set is maintained by the Canadian Standards Association (CSA). set is maintained by the Canadian Standards Association (CSA). The Canadian Standards Association 5060 Spectrum Way Mississauga, Ontario Canada L4W 5N6 Phone: (416) 747-4000 1-800-463-6727 Fax: (416) 747-2473
 |
| [CDA_RUS](NamingSystem-CDARUS.md) | Coding system intended for use in the Russian clinical documents |
| [CDC Analyte Codes](NamingSystem-CDCA.md) | CDC Analyte Codes |
| [CDC Local Coding System](NamingSystem-CDCLocal.md) | "CDC Public Health Information Network local coding system used for creating the concepts that are not available in the Standard Development Organization (SDO) Vocabulary like SNOMED CT, LOINC, ICD-9, etc." Versioning numbered according to PHIN VADS convention. For more information, see[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.114222.4.5.274). |
| [CDC Methods/Instruments Codes](NamingSystem-CDCM.md) | CDC Methods/Instruments Codes |
| [CDC Race and Ethnicity](NamingSystem-CDCREC.md) | The U.S. Centers for Disease Control and Prevention (CDC) has prepared a code set for use in coding race and ethnicity data. This code set is based on current federal standards for classifying data on race and ethnicity, specifically the minimum race and ethnicity categories defined by the U.S. Office of Management and Budget (OMB) and a more detailed set of race and ethnicity categories maintained by the U.S. Bureau of the Census (BC). The main purpose of the code set is to facilitate use of federal standards for classifying data on race and ethnicity when these data are exchanged, stored, retrieved, or analyzed in electronic form. At the same time, the code set can be applied to paper-based record systems to the extent that these systems are used to collect, maintain, and report data on race and ethnicity in accordance with current federal standards. The content is available at https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.6.238#. |
| [CDC Surveillance](NamingSystem-CDS.md) | CDC Surveillance |
| [CDT-2 Codes](NamingSystem-CD2.md) | American Dental Association's Current Dental Terminology 2 (CDT-2) codes. |
| [CEN ECG diagnostic codes](NamingSystem-CE.md) | CEN ECG diagnostic codes |
| [CLIP](NamingSystem-CLP.md) | CLIP |
| [CMS Certification Numbers](NamingSystem-CCN.md) | Per CMS Transmittal 29 dated OCTOBER 12, 2007: "The National Provider Identifier (NPI) will replace the Medicare/Medicaid Provider Number on Medicare claims. The NPI will assume the Medicare/Medicaid Provider Number's role as a primary identifier. However, the Medicare/Medicaid Provider Number will continue to be issued to providers and used to verify Medicare/Medicaid certification on all survey and certification, and resident/patient assessment transactions. In order to avoid confusion with the NPI, the Medicare/Medicaid Provider Number (also known as the OSCAR Provider Number, Medicare Identification Number or Provider Number) has been renamed the CMS Certification Number (CCN). The CCN continues to serve a critical role in verifying that a provider has been Medicare certified and for what type of services." See https://www.cms.gov/regulations-and-guidance/guidance/transmittals/downloads/r29soma.pdf |
| [CMS Hierarchical Condition Categories](NamingSystem-cmshcc.md) | The CMS-HCC model uses more than 9,000 ICD-10-CM codes, which are mapped to condition categories that predict costs well. The condition categories are based on diagnoses clinically related to one another and with similar predicted cost implications. Hierarchies are imposed on the condition categories to capture the most costly diagnoses. Hierarchy logic is imposed on certain condition categories to account for different hierarchical costs, thus, the term Hierarchical Condition Category, or HCC. For more information, see https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors. The CMS HCCs are in the public domain and are free to use without restriction. |
| [CMS Place of Service Codes (POS)](NamingSystem-CMSPlaceofServiceCodes.md) | Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry. This code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider. |
| [CMS Prescription Drug Hierarchical Condition Categories](NamingSystem-CMSRxHCC.md) | Starting in 2006, with the implementation of the Part D program, CMS introduced a second major HCC-based risk adjustment model. Created with the passage of the Medicare Modernization Act (MMA) of 2003, the Medicare Part D Prescription Drug benefit became the second major Medicare capitated payment system. CMS developed the Part D RxHCC risk adjustment model to apply to monthly capitated payments to both Medicare Advantage (MA-PDs) and standalone prescription drug plans (PDPs). The Part D RxHCC risk adjustment model implemented in 2006 was developed using a structure similar to the CMS-HCC model, in that it included demographic and diagnosis information clustered into hierarchical condition categories. CMS obtains diagnoses for all Medicare beneficiaries from either fee-for-service claims or Medicare Advantage reporting. In 2011, CMS implemented an updated Part D RxHCC risk adjustment model, incorporating program data derived from prescription drug event (PDE) data. The data used to calibrate this updated model was more recent cost and utilization data, resulting in a model that reflects more recent drug cost and utilization patterns. For more information, see: https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors The CMS RxHCCs are in the public domain and are free to use without restriction. |
| [CMS Present on Admission (POA) Indicator](NamingSystem-presentOnAdmission.md) | This code system consists of Present on Admission (POA) indicators which are assigned to the principal and secondary diagnoses (as defined in Section II of the Official Guidelines for Coding and Reporting) and the external cause of injury codes to indicate the presence or absence of the diagnosis at the time of inpatient admission. |
| [COSTART](NamingSystem-CST.md) | COSTART |
| [CPT-5](NamingSystem-C5.md) | CPT-5 |
| [California Driver's License](NamingSystem-CaliforniaDLN.md) | California Motor Vehicle Bureau |
| [Canada Post Province Codes](NamingSystem-CanadaProvinceCodes.md) | For more information, see[https://www.canadapost-postescanada.ca/cpc/en/support/articles/addressing-guidelines/symbols-and-abbreviations.page](https://www.canadapost-postescanada.ca/cpc/en/support/articles/addressing-guidelines/symbols-and-abbreviations.page) |
| [Canadian Classification of Health Interventions](NamingSystem-v3-cci.md) | CCI (Canadian Classification of Health Interventions) was developed by CIHI to accompany ICD-10-CA. It was designed to be service-provider and service-setting neutral and can be used comprehensively throughout Canada’s health systems. CCI classifies a broad range of interventions including therapeutic and diagnostic interventions and other health care interventions, such as assistance with activities of daily living, environmental assessments and counselling. |
| [Canadian Clinical Drug Data Set](NamingSystem-CCDD.md) | The Canadian Clinical Drug Data Set provides codes for identification and a consistent approach to naming of medications and some medical devices in Canada. It has been designed and developed to reflect current clinical practice and safety advice and is freely available for use in digital health solutions and design applications. CCDD is available in English and Canadian French. To request content changes, send an email to[clinicaldrug@infoway-inforoute.ca](mailto:clinicaldrug@infoway-inforoute.ca). Canada Health Infoway has developed a FHIR representation of CCDD, which can be viewed at:[https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir](https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir)The CCDD FHIR representation contains supplemental property codes, as defined in the Health Canada Drug Product Database (DPD), managed by Health Canada, as follows:* Anatomical Therapeutical Chemical (ATC): The purpose of the ATC classification system is to be used as a tool for drug utilization research to improve the quality of drug use. 
* Biosimilar: Identifies biosimilar products. 
* Pediatric: Identifies pediatric products. 
* Schedule: Each drug is assigned one or more schedules according to the Food and Drug Regulations and the Controlled Drugs and Substances Act. Further information on the supplemental properties may be obtained by reviewing the information at [https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html](https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html) or by emailing [pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca](mailto:pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca)
 |
| [Canadian DiagnosisCodes ICD-10-CA](NamingSystem-icd10-CA.md) | ICD-10-CA (International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada) was developed by the World Health Organization (WHO) and enhanced by CIHI to meet Canadian morbidity data needs. ICD-10-CA classifies diseases, injuries and causes of death, as well as external causes of injury and poisoning. It also includes conditions and situations that are not diseases but represent risk factors to health, such as occupational and environmental factors, lifestyle and psychosocial circumstances. |
| [Canadian Triage and Acuity Scale](NamingSystem-CTAS.md) | The Canadian Triage and Acuity Scale (CTAS) provides a standardized, five-level method for prioritizing patients who present to emergency departments, ensuring that those in greatest need receive the fastest care. The system evolved from military triage principles, adapted for hospitals in the 1960s, and formally standardized in 1999 through collaboration among CAEP, NENA, and AMUQ. It replaced the earlier three-level model to improve national consistency, reliability, and patient outcomes. Triage is defined as a rapid, structured assessment process guided by critical thinking, where an experienced nurse evaluates a patient’s condition, determines severity, assigns a CTAS category, and directs them to appropriate care. This process improves safety, efficiency, and communication while helping manage limited emergency resources. The five CTAS levels range from Level 1 (Resuscitation) for life-threatening emergencies to Level 5 (Non-Urgent) for minor complaints. Effective triage depends on both system design and nurse expertise. Triage nurses must balance speed and accuracy, applying cognitive, behavioral, and interpersonal skills—critical thinking, autonomy, composure under pressure, compassion, and clear communication. Their role includes assessment, initiation of basic interventions, collaboration with physicians, documentation, and ongoing patient reassessment. They serve as patient advocates and frontline decision-makers in dynamic, often crowded environments. The triage process begins with a “critical look”—a 3-to-5-second across-the-room assessment of airway, breathing, circulation, and neurological status—followed by infection control screening, subjective (patient-reported) and objective (observed) assessments, and the selection of a CEDIS Presenting Complaint. Modifiers such as vital-sign deviations or risk factors help refine acuity assignment. Clear documentation of findings and CTAS level is essential, and reassessment intervals are defined: continuous for Level 1 patients, every 15 minutes for Level 2, and progressively less frequent for lower levels. Triage reliability can be affected by ED overcrowding or access block, leading to “triage drift,” where acuity scores may be subconsciously adjusted to fit available space. Strategies such as lean “streaming” processes, internal waiting rooms, and rapid assessment zones help mitigate these pressures. Ultimately, CTAS is more than a categorization tool—it is a cornerstone of emergency care quality and accountability. By integrating standardized assessment with professional judgment, it ensures that patients receive timely, appropriate care while supporting system efficiency, data benchmarking, and continuous improvement across Canadian emergency departments. For more information, see[https://share.google/PedyLtc66nmDyt3a7](https://share.google/PedyLtc66nmDyt3a7). |
| [Chemical Abstract Codes](NamingSystem-CAS.md) | Chemical abstract codes |
| [Chronic Illness and Disability Payment System (CDPS)](NamingSystem-CDPS.md) | "The Chronic Illness and Disability Payment System (CDPS) is a diagnostic-based risk adjustment model that is widely used to adjust capitated payments for health plans that enroll Medicaid beneficiaries. CDPS uses International Classification of Disease (ICD) codes to assign CDPS Categories that indicate illness burden related to major body systems (e.g. cardiovascular) or types of chronic disease (e.g. diabetes). Within each major category is a hierarchy reflecting both the clinical severity of the condition and its expected effect on future costs. Each of the hierarchical CDPS Categories is assigned a CDPS weight. CDPS weights are additive across major categories." "The CDPS model was developed in 2000 using data from seven Fee-for-Service (FFS) Medicaid programs. The model received major updates in 2009 (using national FFS Medicaid data from 2002-2005) and in 2014 (using additional national FFS Medicaid data from 2011). CDPS has also received regular annual updates to include the most recent ICD and NDC codes." For more information, please visit[https://hwsph.ucsd.edu/research/programs-groups/cdps.html](https://hwsph.ucsd.edu/research/programs-groups/cdps.html). |
| [ClinVar Variant ID](NamingSystem-ClinVarV.md) | ClinVar is a freely accessible, public archive of reports of the relationships among human variations and phenotypes, with supporting evidence. ClinVar thus facilitates access to and communication about the relationships asserted between human variation and observed health status, and the history of that interpretation. ClinVar processes submissions reporting variants found in patient samples, assertions made regarding their clinical significance, information about the submitter, and other supporting data. The alleles described in submissions are mapped to reference sequences, and reported according to the HGVS standard. ClinVar then presents the data for interactive users as well as those wishing to use ClinVar in daily workflows and other local applications. ClinVar works in collaboration with interested organizations to meet the needs of the medical genetics community as efficiently and effectively as possible. Read more about using ClinVar. ClinVar supports submissions of differing levels of complexity. The submission may be as simple as a representation of an allele and its interpretation (sometimes termed a variant-level submission), or as detailed as providing multiple types of structured observational (case-level) or experimental evidence about the effect of the variation on phenotype. A major goal is to support computational (re)evaluation, both of genotypes and assertions, and to enable the ongoing evolution and development of knowledge regarding variations and associated phenotypes. ClinVar is an active partner of the ClinGen project, providing data for evaluation and archiving the results of interpretation by recognized expert panels and providers of practice guidelines (see https://www.ncbi.nlm.nih.gov/clinvar/docs/review_guidelines/). ClinVar archives and versions submissions which means that when submitters update their records, the previous version is retained for review. Read more about submitting data to ClinVar at https://www.ncbi.nlm.nih.gov/clinvar/docs/submit. The level of confidence in the accuracy of variation calls and assertions of clinical significance depends in large part on the supporting evidence, so this information, when available, is collected and visible to users. Because the availability of supporting evidence may vary, particularly in regard to retrospective data aggregated from published literature, the archive accepts submissions from multiple groups, and aggregates related information, to reflect transparently both consensus and conflicting assertions of clinical significance. A review status is also assigned to any assertion, to support communication about the trustworthiness of any assertion. Domain experts are encouraged to apply for recognition as an expert panel (more info at https://www.ncbi.nlm.nih.gov/clinvar/docs/review_guidelines/). Accessions, with the format SCV000000000.0, are assigned to each submitted record. If there are multiple submitted records about the same variation/condition pair, they are aggregated within ClinVar's data flow and reported as a reference accession with the format RCV000000000.0. Because of this model, one variant will be included in multiple RCV accessions whenever different conditions are reported for that variant. Submitted records for the same variation are also aggregated and reported as an accession with the format VCV000000000.0. This aggregation lets a user review all submitted data for a variant, regardless of the condition for which it was interpreted. ClinVar archives submitted information, and adds identifiers and other data that may be available about a variant or condition from other public resources. However ClinVar neither curates content nor modifies interpretations independent of an explicit submission. If you have data that differs from what is currently represented in ClinVar, we encourage you to submit your data and the evidence supporting your interpretation. There is a submission wizard to guide you through that process. See https://www.ncbi.nlm.nih.gov/variation/clinvar_single_wizard/. If you are submitting variants that were interpreted as part of work funded by the NIH, please consult your program officer about expectations for submissions to ClinVar. |
| [Clinical Care Classification System](NamingSystem-CCC.md) | Clinical Care Classification System (formerly Home Health Care Classification system) codes. The Clinical Care Classification (CCC) consists of two taxonomies: CCC of Nursing Diagnoses and CCC of Nursing Interventions both of which are classified by 21 Care Components. Each of these are classified by Care Components which provide a standardized framework for documenting patient care in hospitals, home health agencies, ambulatory care clinics, and other health care settings. |
| [Clinical Laboratory Improvement Amendments](NamingSystem-CLIA.md) | "The Centers for Medicare & Medicaid Services (CMS) regulates all laboratory testing (except research) performed on humans in the U.S. through the Clinical Laboratory Improvement Amendments (CLIA). In total, CLIA covers approximately 330,000 laboratory entities. The Division of Clinical Laboratory Improvement & Quality, within the Quality, Safety & Oversight Group, under the Center for Clinical Standards and Quality (CCSQ) has the responsibility for implementing the CLIA Program. The objective of the CLIA program is to ensure quality laboratory testing. Although all clinical laboratories must be properly certified to receive Medicare or Medicaid payments, CLIA has no direct Medicare or Medicaid program responsibilities." CMS CLIA certified laboratories will be assigned a10-digit alphanumeric CLIA identification number, with the "D" in the third position identifying the provider/supplier as a laboratory certified under CLIA." CLIA is maintained by CMS. It is in the public domain and free to use without restriction. See http://cms.gov/regulations-and-guidance/legislation/clia. |
| [ClinicalTrials.gov](NamingSystem-ClinicalTrialsGov.md) | The U.S. National Institutes of Health, Department of Health and Human Services, through its National Library of Medicine, has developed[ClinicalTrials.gov](http://clinicaltrials.gov)to provide patients, family members, and members of the public current information about clinical research studies.[ClinicalTrials.gov](http://clinicaltrials.gov)contains summary information about clinical studies being conducted throughout the United States and in many countries throughout the world. These data are provided to the National Library of Medicine by organizations and institutions that sponsor and implement the studies.[ClinicalTrials.gov](http://clinicaltrials.gov)is updated daily. You should check[ClinicalTrials.gov](http://clinicaltrials.gov)frequently for updated information. More information about ClinicalTrials.gov can be found[here](https://clinicaltrials.gov/about-site/about-ctg). |
| [Code on Dental Procedures and Nomenclature](NamingSystem-CDT.md) | The purpose of the CDT Code is to achieve uniformity, consistency and specificity in accurately documenting dental treatment. One use of the CDT Code is to provide for the efficient processing of dental claims, and another is to populate an Electronic Health Record. |
| [College of American Pathologists (CAP) eCC (electronic Cancer Checklists)](NamingSystem-CAPeCC.md) | "The College of American Pathologists (CAP) eCC (electronic Cancer Checklists) enables pathologists to use the[CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols)directly within their laboratory information system (LIS) workflow and to ensure that each report is completed with the necessary required elements. Most anatomic pathology (AP)-LIS vendors offer a CAP eCC synoptic module for reporting on surgical cancer resections and selected biopsies." "The CAP eCC is based on the[CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols)and is produced under the guidance of the[CAP Pathology Electronic Reporting (PERT) Committee](https://www.cap.org/member-resources/councils-committees/pathology-electronic-reporting-pert-committee)along with close interaction and advisement of the[Cancer Committee](https://www.cap.org/member-resources/councils-committees/cancer-committee). The eCC is developed in collaboration with and partially underwritten by the Centers for Disease Control and Prevention (CDC). Additional collaborators include the American Joint Committee on Cancer (AJCC), Cancer Care Ontario (CCO), and the North American Association of Central Cancer Registries (NAACCR). The CAP currently is working with the[California Cancer Registry (CCR)](http://www.ccrcal.org/)to offer the benefits of the eCC to California laboratories. CCR and the CAP are seeking out laboratories interested in participating in an ongoing project using the eCC to directly transfer cancer data to the central registry." "The CAP releases eCC templates on a rolling basis, coordinating as much as possible with the posting of new and revised[Cancer Protocols and Cancer Biomarker Reporting Templates](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocol-templates). A few weeks prior to each Major or Agile release, email notifications are sent out to all licensed CAP eCC users." For more information, see page[here](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc) |
| [Colorado Driver's License](NamingSystem-ColoradoDLN.md) | Colorado Motor Vehicle Bureau |
| [Connecticut Driver's License](NamingSystem-ConnecticutDLN.md) | Connecticut Motor Vehicle Bureau |
| [Current Procedural Terminology (CPT®)](NamingSystem-CPT.md) | The Current Procedural Terminology (CPT) code set, created and maintained by the American Medical Association, is the language of medicine today and the code to its future. This system of terminology is the most widely accepted medical nomenclature used to report medical procedures and services under public and private health insurance programs. CPT coding is also used for administrative management purposes such as claims processing and developing guidelines for medical care review. Each year, via a rigorous, evidence-based and transparent process, the independent CPT Editorial Panel revises, creates or deletes hundreds of codes in order to reflect current medical practice. Designated by the U.S. Department of Health and Human Services under the Health Insurance Portability and Accountability Act (HIPAA) as a national coding set for physician and other health care professional services and procedures, CPT’s evidence-based codes accurately encompass the full range of health care services. All CPT codes are five-digits and can be either numeric or alphanumeric, depending on the category. CPT code descriptors are clinically focused and utilize common standards so that a diverse set of users can have common understanding across the clinical health care paradigm. There are various types of CPT codes: Category I: These codes have descriptors that correspond to a procedure or service. Codes range from 00100–99499 and are generally ordered into sub-categories based on procedure/service type and anatomy. Category II: These alphanumeric tracking codes are supplemental codes used for performance measurement. Using them is optional and not required for correct coding. Category III: These are temporary alphanumeric codes for new and developing technology, procedures and services. They were created for data collection, assessment and in some instances, payment of new services and procedures that currently don’t meet the criteria for a Category I code. Proprietary Laboratory Analyses (PLA) codes: These codes describe proprietary clinical laboratory analyses and can be either provided by a single (“solesource”) laboratory or licensed or marketed to multiple providing laboratories that are cleared or approved by the Food and Drug Administration (FDA)). This category includes but is not limited to Advanced Diagnostic Laboratory Tests (ADLTs) and Clinical Diagnostic Laboratory Tests (CDLTs), as defined under the Protecting Access to Medicare Act of 2014 (PAMA). |
| [DC Driver's License](NamingSystem-DCDLN.md) | DC Motor Vehicle Bureau |
| [DEEDS vocabularies](NamingSystem-DEEDS.md) | root for the DEEDS code sets |
| [DEEDS(old)](NamingSystem-deeds-old.md) | retired root for DEEDs from earlier work. Superceded. |
| [DEEDS2.10](NamingSystem-DEEDS210.md) | Code for ED Practitioner Role |
| [DEEDS402](NamingSystem-DEEDS402.md) | Mode of transport to ED |
| [DEEDS405](NamingSystem-DEEDS405.md) | ED Source of Referral |
| [DEEDS407](NamingSystem-DEEDS407.md) | Code for Initial Healthcare Encounter for Chief Complaint |
| [DEEDS408](NamingSystem-DEEDS408.md) | Code for Acuity Assessment |
| [DEEDS412](NamingSystem-DEEDS412.md) | ED Responsiveness Assessment |
| [DEEDS414](NamingSystem-DEEDS414.md) | Glasgow eye opening assessment |
| [DEEDS415](NamingSystem-DEEDS415.md) | Glasgow verbal component assessment |
| [DEEDS416](NamingSystem-DEEDS416.md) | Glasgow motor component assessment |
| [DEEDS418](NamingSystem-DEEDS418.md) | Systolic blood pressure special situation |
| [DEEDS422](NamingSystem-DEEDS422.md) | Heart rate method |
| [DEEDS424](NamingSystem-DEEDS424.md) | Respiratory rate special circumstances codes |
| [DEEDS427](NamingSystem-DEEDS427.md) | Patient temperature route |
| [DEEDS506](NamingSystem-DEEDS506.md) | Injury Activity |
| [DEEDS508](NamingSystem-DEEDS508.md) | Safety Equipment Use |
| [DEEDS519](NamingSystem-DEEDS519.md) | Clinical Finding Data Source |
| [DICOM Class Label](NamingSystem-DCL.md) | DICOM Class Label |
| [DICOM Controlled Terminology](NamingSystem-v3-DCM.md) | Coded concepts defined in PS 3.16 Digital Imaging and Communications in Medicine (DICOM): Part 16: Content Mapping Resource, Annex D: DICOM Controlled Terminology Definition |
| [DICOM Query Label](NamingSystem-dicomqry.md) | DICOM Query Label |
| [DICOM Unique Id](NamingSystem-dui.md) | An OID issued under DICOM OID rules. DICOM OIDs are represented as plain OIDs, with a prefix of "urn:oid:". See https://www.dicomstandard.org/ |
| [DICOM modality codes](NamingSystem-dicomMDLTY.md) | DICOM modality codes |
| [Data Universal Numbering System (DUNS) Number](NamingSystem-DUNSNumber.md) | "The Dun & Bradstreet D-U-N-S® Number (short for Data Universal Numbering System) is a nine-digit unique identifier for businesses. Hundreds of millions of D-U-N-S Numbers exist for companies across the globe. A D-U-N-S Number is assigned through our patented identity resolution process, (part of our DUNSRight™ data governance, which includes thousands of separate automated checks.) The D-U-N-S Number identifies a company as being unique from any other in the[Dun & Bradstreet Data Cloud](https://www.dnb.com/about-us/data-cloud.html). It is used as the starting point for any company's[Live Business Identity](https://www.dnb.com/about-us/data-cloud/live-business-identity.html), which helps ensure you have the most accurate and up-to-date view of organizations." For more information, see[https://www.dnb.com/duns.html](https://www.dnb.com/duns.html). |
| [Delaware Driver's License](NamingSystem-DelawareDLN.md) | Delaware Motor Vehicle Bureau |
| [EPSG Geodetic Parameter Dataset](NamingSystem-EPSG-GeodeticParameterDataset.md) | **Description:**The EPSG (European Petroleum Survey Group) dataset represents all Datums, coordinate references (projected and 2D geographic) and coordinate systems (including Cartesian coordinate systems) used in surveying worldwide. Each record includes a 4-8 digit unique identifier. The current version is available from http://www.epsg.org/. The database contains over 4000 records covering spatial data applications worldwide.**Deprecation Comment:**This has been superceded by the two code systems EPSG-CRS and EPSG-CA |
| [EUCLIDES](NamingSystem-euclides.md) | EUCLIDES |
| [Enzyme Codes](NamingSystem-ENZC.md) | Enzyme Codes |
| [Ethernet MAC Address as a device identifier](NamingSystem-ethernet-address-identifier.md) | The Ethernet MAC (media access control) address is a unique identifier assigned to a network interface controller (NIC) for use as a network address in communications within a network segment. This use is common in most IEEE 802 networking technologies. The address typically includes a manufacturer's organizationally unique identifier (OUI). MAC addresses are formed according to the principles of two numbering spaces based on Extended Unique Identifiers (EUI) managed by the Institute of Electrical and Electronics Engineers (IEEE): EUI-48. A device that has an Ethernet MAC address can also have it own Bluetooth MAC address. |
| [Euclides Lab equipment codes](NamingSystem-E7.md) | Euclides Lab equipment codes |
| [Euclides Lab method codes](NamingSystem-E6.md) | Euclides Lab method codes |
| [Euclides quantity codes](NamingSystem-E5.md) | Euclides quantity codes |
| [European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Axis](NamingSystem-epsg-ca.md) | **Description:**The set of values found in the Coord Axis Code column of the Coordinate Axis table as maintained in the EPSG geodetic parameter dataset. These define the axis for coordinate systems for geographic coordinates. |
| [European Petroleum Survey Group Geodetic Parameter Dataset Coordinate Reference System](NamingSystem-epsg-crs.md) | **Description:**The set of values found in the Coord Axis Code column of the Coordinate Axis table as maintained in the EPSG geodetic parameter dataset. These define the axis for coordinate systems for geographic coordinates. |
| [FDA Establishment Identifier](NamingSystem-FEI.md) | "A FDA Establishment Identifier or Firm Establishment Identifier (FEI) is an FDA system generated number used to identify a firm. FDA systems interact, occasionally creating multiple records (FEIs) for one firm. Upon evaluation, these numbers are merged into one surviving FEI which is used to identify the firm. The remaining FEIs become children of the surviving FEI and are not used to identify the firm." For more information, see[https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq](https://www.accessdata.fda.gov/scripts/feiportal/index.cfm?action=common.faq). |
| [FDA K10](NamingSystem-fdk.md) | FDA K10 |
| [FDB HIC Code](NamingSystem-FDBHICCode.md) | The FDB Hierarchical Ingredient Code is a six character identifier that represents an active ingredient and its specific therapeutic classification. |
| [FEvIR Object Identifier](NamingSystem-FOI.md) | The FEvIR Object Identifier (FOI) is a globally unique persistent digital object identifier for Resources accessible through the FEvIR Platform. The FEvIR Platform is a platform to support creation, viewing, notification, and interaction for computable expression of scientific knowledge. The FEvIR Platform is used to facilitate many projects, including the HL7 EBMonFHIR project and the Evidence Based Medicine on FHIR Implementation Guide. |
| [FIPS_SOC](NamingSystem-fipspub92.md) | FIPSPUB92 - GUIDELINE FOR STANDARD OCCUPATIONAL CLASSIFICATION (SOC) CODES, version 1983 February 24. This entry is now obsolete, as FIPS92 was withdrawn from use in February 2005 by the US Government. It has been replaced by 2.16.840.1.113883.6.243; please use that OID instead. |
| [Federal Information Processing Standards Publication: Codes for the Identification of the States, the District of Columbia and the Outlying Areas of the United States, and Associated Areas (FIPS 5-2)](NamingSystem-FIPS52.md) | "This standard provides a set of two-digit numeric codes and a set of two-letter alphabetic codes for representing the 50 states, the District of Columbia and the outlying areas of the United States, and associated areas. The standard covers all land areas under the sovereignty of the United States, the freely associated states of Federated States of Micronesia and Marshall Islands, and the trust territory of Palau. This revision supersedes FIPS PUB 5-1 in its entirety." For more information, see[https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub5-2.pdf) |
| [Federal Information Processing Standards Publication: Counties and Equivalent Entities of the United States, Its Possessions, and Associated Areas (FIPS 6-4)](NamingSystem-FIPS64.md) | "The FIPS county code is a five-digit Federal Information Processing Standard (FIPS) code (FIPS 6-4) which uniquely identifies counties and county equivalents in the United States, certain U.S. possessions, and certain freely associated states. This is the 3-digit part of the 5-digit county FIPS code specifically standing for the county." For more information, see[https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf](https://nvlpubs.nist.gov/nistpubs/Legacy/FIPS/fipspub6-4.pdf) |
| [First DataBank Diagnostic Codes](NamingSystem-FDDX.md) | First DataBank Diagnostic Codes |
| [First DataBank Drug Codes](NamingSystem-FDDC.md) | First DataBank Drug Codes |
| [Florida Driver's License](NamingSystem-FloridaDLN.md) | Florida Motor Vehicle Bureau |
| [Food and Drug Administration Food Canning Establishments](NamingSystem-v3-fda-FCE.md) | Entered erroneously - do not use. The correct OID for this identifier system is 2.16.840.1.113883.4.345. |
| [Food and Drug Administration Food Facility Registration Numbers](NamingSystem-v3-fda-FFRN.md) | Entered in error originally - do not use. Correct OID for this item is 2.16.840.1.113883.4.344. |
| [GCDF](NamingSystem-GCDF.md) | GCDF Dosage Form Code (2-character) a two-character alphanumeric column that represents a dosage form. The dosage form of a generic drug formulation describes the physical presentation of a drug, such as tablet, capsule, or liquid. It may also incorporate the delivery and release mechanism of the drug. A GCDF is associated to each GCN_SEQNO to identify that component of the generic drug formulation. |
| [GCRT](NamingSystem-GCRT.md) | GCRT Route of Administration Code (1-character) a one-character alphanumeric column that provides the normal site or method by which a drug is administered, such as oral, injection, or topical. A GCRT is associated to each GCN_SEQNO to identify that component of the generic drug formulation. |
| [GTIN Global Trade Item Number](NamingSystem-gtin.md) | The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain. Note: GTINs may be used in both Codes (http://build.fhir.org/datatypes.html#Coding) and Identifiers (http://build.fhir.org/datatypes.html#Identifier). |
| [Gene Reference Sequence Collection](NamingSystem-v3-refSeq.md) | The Reference Sequence (RefSeq) is one of the NCBI projects, the RefSeq collection aims to provide a comprehensive, integrated, non-redundant, well-annotated set of sequences, including genomic DNA, transcripts, and proteins. ReqSeq is accessible via BLAST, Entrez, and the NCBI FTP site. Information is also available in Entrez Genomes and Entrez Gene, and for some genomes additional information is available in the Map Viewer. RefSeq entries can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, RefSeq entries can be used to as the observation values for genomic reference sequence identifiers (LOINC #: 48013-7). More information may be found at: http://www.ncbi.nlm.nih.gov/RefSeq Versioning informaiton: The latest release of RefSeq was released on May 13, 2009 with the release number of 35. RefSeq generates new releases roughly every two months. The dates of the three previous releases were: Release 34, March 12, 2009 Release 33, January 20, 2009 Release 32, November 17, 2008 RefSeq is a free database for the public. |
| [Genetic Sequence polymorphism database](NamingSystem-v3-dbSNP.md) | In collaboration with the National Human Genome Research Institute, The National Center for Biotechnology Information has established the dbSNP database to serve as a central repository for both single base nucleotide substitutions and short deletion and insertion polymorphisms. The entries in the dbSNP database can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, dbSNP entries can be used to as the observation values for DNA sequence variation identifiers. For example, OBX|1|CWE|48004-6^DNA Sequence Variation Identifier^LN||rs55538123^^dbSNP Versioning is identified by the build id. A new build is released approximately every six months or every year. The latest build id is 130, and the dbSNP web query for built 130 was available on Apr 30, 2009. dbSNP is a database that can be used freely by the public. More information may be fouond at: http://www.ncbi.nlm.nih.gov/projects/SNP/ |
| [Genetic Testing Registry](NamingSystem-GTR.md) | The Genetic Testing Registry (GTR) provides a central location for voluntary submission of genetic test information by providers. The scope includes the test's purpose, methodology, validity, evidence of the test's usefulness, and laboratory contacts and credentials. The overarching goal of the GTR is to advance the public health and research into the genetic basis of health and disease. Each Test is a specific, orderable test from a particular laboratory, and is assigned a unique GTR accession number. The format is GTR00000001.1, with a leading prefix "GTR" followed by 8 digits, a period, then 1 or more digits representing the version. When a laboratory updates a registered test, a new version number is assigned. To find all laboratories in GTR and all registered tests, see here https://www.ncbi.nlm.nih.gov/gtr/all/tests/?term=all%5Bsb%5D |
| [Georgia Driver's License](NamingSystem-GeorgiaDLN.md) | Georgia Motor Vehicle Bureau |
| [Global Location Number (GLN)](NamingSystem-GLN.md) | Global Location Number (GLN) can be used by companies to identify their locations, giving them complete flexibility to identify any type or level of location required. For more information as to how GLNs are used in healthcare, see a GS1 provided guide located here https://www.gs1.org/docs/healthcare/GLN_Healthcare_Imp_Guide.pdf For additional information regarding the GLN standard refer to the GS1 General Specifications (https://www.gs1.org/standards/barcodes-epcrfid-id-keys/gs1-general-specifications) and for assignment refer to the GS1 GLN Allocation Rules (https://www.gs1.org/1/glnrules/en/). GS1 local offices handle all enquiries related to GS1 standards. Please see the list of GS1 offices (https://www.gs1.org/contact/overview) for more information. In relation to the "Healthcare GLN Implementation Guideline": "GS1®, under its IP Policy, seeks to avoid uncertainty regarding intellectual property claims by requiring the participants in the Work Group that developed this Healthcare GLN Implementation Guideline to agree to grant to GS1 members a royalty-free licence or a RAND licence to Necessary Claims, as that term is defined in the GS1 IP Policy. Furthermore, attention is drawn to the possibility that an implementation of one or more features of this Specification may be the subject of a patent or other intellectual property right that does not involve a Necessary Claim. Any such patent or other intellectual property right is not subject to the licensing obligations of GS1. Moreover, the agreement to grant licences provided under the GS1 IP Policy does not include IP rights and any claims of third parties who were not participants in the Work Group. Accordingly, GS1 recommends that any organisation developing an implementation designed to be in conformance with this Specification should determine whether there are any patents that may encompass a specific implementation that the organisation is developing in compliance with the Specification and whether a licence under a patent or other intellectual property right is needed. Such a determination of a need for licencing should be made in view of the details of the specific system designed by the organisation in consultation with their own patent counsel." "GS1 disclaims all liability for any damages arising from use or misuse of this document, whether special, indirect, consequential, or compensatory damages, and including liability for infringement of any intellectual property rights, relating to use of information in or reliance upon this document." GS1 and the GS1 logo are registered trademarks of GS1 AISBL. |
| [Global Medical Device Nomenclature](NamingSystem-GMDN.md) | http://www.gmdnagency.com/ |
| [Gold Standard's Clinical Pharmacology Monograph Number](NamingSystem-cpnum.md) | Gold Standard's Clinical Pharmacology Monograph Number |
| [HCFA Procedure Codes (HCPCS)](NamingSystem-HCPCS-all-codes.md) | The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing. Level II alphanumeric procedure and modifier codes comprise the A to V range. |
| [HIBCC](NamingSystem-hibccHIN.md) | HIBCC |
| [HL7 Registered External Coding Systems](NamingSystem-externalCodeSystems.md) | External coding systems registered in HL7 with an HL7 OID |
| [HUGO Gene Nomenclature Committee Gene Group](NamingSystem-HGNCGeneGroup.md) | "The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication." HGNC Gene Group is an index on gene families/groups. The numeric GeneGroup IDs should be used as codes. GeneGroup IDs do not begin with "HGNC:" (like the GeneIDs for genes in HGNC Genes), so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs. "For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases." For more information on the use of HGNC Genes, see[https://terminology.hl7.org/CodeSystem-v3-hgnc.html](https://terminology.hl7.org/CodeSystem-v3-hgnc.html). HGNC is a free database for the public. Please see https://www.genenames.org/ for more info. |
| [HUGO Gene Nomenclature Committee Genes](NamingSystem-v3-hgnc.md) | "The HGNC is responsible for approving unique symbols and names for human loci, including protein coding genes, ncRNA genes and pseudogenes, to allow unambiguous scientific communication." The HGNC gene table carries gene IDs, gene symbols and full gene names. Guidance from HGNC confirms that gene symbols are not unique across species and have been known to change in some instances. Thus the commonly used gene symbols should be encoded in FHIR as "displays" with the corresponding IDs (beginning with "HGNC:") as the "codes". "For each known human gene we approve a gene name and symbol (short-form abbreviation). All approved symbols are stored in the HGNC database,[www.genenames.org](https://www.genenames.org/tools/search), a curated online repository of HGNC-approved gene nomenclature, gene groups and associated resources including links to genomic, proteomic and phenotypic information. Each symbol is unique and we ensure that each gene is only given one approved gene symbol. It is necessary to provide a unique symbol for each gene so that we and others can talk about them, and this also facilitates electronic data retrieval from publications and databases." HGNC also provides an index on gene families/groups. GeneGroup IDs do not begin with "HGNC:", so care must be made to ensure alignment of concepts when viewing an HGNC ID from an older system that may be referring to the GeneID and not a gene group. For example, 588 refers to the HLA gene family, but HGNC:588 identifies the ATG12 gene. To provide clarity for systems that do not distinguish codes from genes and gene families, use "http://www.genenames.org" for genes and "http://www.genenames.org/genegroup" for gene families as code system URIs. For more information on HGNC Gene Groups, see[https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html](https://terminology.hl7.org/CodeSystem-HGNCGeneGroup.html). Historically, HGNC gene symbols were used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model Implementation Guide, HGNC gene symbols were used as the observation values for gene identifiers. For example, OBX 1 CWE 48018-6^Gene identifier^ BRCA1^HGNC. Please note that gene symbols may be present in legacy systems, but GeneID should be used to exchange HGNC gene information in current implementations. HGNC is a free database for the public. Versioning Information: The version of the HGNC database is reported using the last updated date. The last updated date is posted on the main HGNC Search screen in the format like "2024-07-25". Current, monthly and quarterly HGNC dataset files are published. Please see https://www.genenames.org/ for more info. |
| [Hawaii Driver's License](NamingSystem-HawaiiDLN.md) | Hawaii Motor Vehicle Bureau |
| [Health Canada Drug Id Number](NamingSystem-ca-hc-din.md) | A Drug Identification Number (DIN) is a computer-generated eight digit number assigned by Health Canada to a drug product prior to being marketed in Canada. It uniquely identifies all drug products sold in a dosage form in Canada and is located on the label of prescription and over-the-counter drug products that have been evaluated and authorized for sale in Canada. A DIN uniquely identifies the following product characteristics:* manufacturer 
* product name 
* active ingredient(s) 
* strength(s) of active ingredient(s) 
* pharmaceutical form, and 
* route of administration. Note: The number has a leading zero. Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/applications-submissions/guidance-documents/regulatory-requirements-drug-identification-numbers/document.html
 |
| [Health Canada Drug Product Database - Schedule](NamingSystem-ca-hc-dpd-schedule.md) | The Code System describes the characteristics of drugs for use in Canada.\r\n\r\nDrugs in Canada are assigned one or more of the following schedules, according to the Food and Drug Regulations, and the Controlled Drugs and Substances Act.\r\n\r\n- Prescription (prescription drugs included in the Prescription Drug List)\r\n\r\n- Prescription Recommended (drugs that are recommended to be listed on the Prescription Drug List)\r\n\r\n- Schedule G (control drugs)\r\n\r\n- Schedule G (Controlled Drugs and Substances Act [CDSA] III)\r\n\r\n- Schedule G (CDSA IV)\r\n\r\n- Schedule C (drugs listed in Schedule C of the Food and Drugs Act, for example, radiopharmaceutical drugs)\r\n\r\n- Schedule D (drugs listed in Schedule D of the Food and Drugs Act, ie. biological products)\r\n\r\n- Narcotic (Narcotic Control Act)\r\n\r\n- Narcotic (CDSA I)\r\n\r\n- Narcotic (CDSA II)\r\n\r\n- Targeted (CDSA IV)\r\n\r\n- CDSA Recommended- Undergoing Regulatory Amendment to add this new substance to Controlled Drugs Substances Act\r\n\r\n- OTC (over the counter drugs that do not appear on a schedule or are not recommended to appear on any schedule)\r\n\r\n- Ethical: a drug that, in accordance with Federal Legislation, does not require a prescription, but that is generally prescribed by a medical practitioner. Ethical products are unscheduled non-prescription professional use products (e.g. MRI contrast agents, hemodialysis solutions) and a few emergency use products (e.g. nitroglycerine) |
| [Health Canada Natural Product Number](NamingSystem-v3-hc-npn.md) | Natural Product Number (NPN) is an eight (8) digit numerical code assigned to each natural health product approved to be marketed under the Natural Health Products Regulations. A Homeopathic Medicine Number (DIN-HM) is an eight (8) digit numerical code assigned to each homeopathic medicine approved to be marketed under the Natural Health Products Regulations. Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/natural-non-prescription/applications-submissions/product-licensing/licensed-natural-health-products-database.html |
| [Health Insurance Prospective Payment System (HIPPS)](NamingSystem-HIPPS.md) | "Health Insurance Prospective Payment System (HIPPS) rate codes represent specific sets of patient characteristics (or case-mix groups) health insurers use to make payment determinations under several prospective payment systems. Case-mix groups are developed based on research into utilization patterns among various provider types. For the payment systems that use HIPPS codes, clinical assessment data is the basic input. A standard patient assessment instrument is interpreted by case-mix grouping software algorithms, which assign the case mix group. For payment purposes, at least one HIPPS code is defined to represent each case-mix group. These HIPPS codes are reported on claims to insurers. Institutional providers use HIPPS codes on claims in association with special revenue codes. One revenue code is defined for each prospective payment system that requires HIPPS codes. HIPPS codes are placed in data element SV202 on the electronic 837 institutional claims transaction, using an HP qualifier, or in Form Locator (FL) 44 ("HCPCS/rate") on a paper UB-04 claims form. The associated revenue code is placed in data element SV201 or in FL 42. In certain circumstances, multiple HIPPS codes may appear on separate lines of a single claim." "HIPPS codes are alpha-numeric codes of five digits. Each code contains intelligence, with certain positions of the code indicating the case mix group itself, and other positions providing additional information. The additional information varies among HIPPS codes pertaining to different payment systems, but often provides information about the clinical assessment used to arrive at the code. Which positions of the code carry the case mix group information may also vary by payment systems." "Under the Health Insurance Portability and Accountability Act (HIPAA) rules for transactions and code sets, HIPPS codes are defined as a non-medical code set. Therefore, these codes are effective by transaction date. Effective From Dates: HIPPS codes are valid under HIPAA on transactions on or after this date. Since all HIPPS codes to date have been initially created for Original Medicare payment systems, this is also date of service the codes begin to be payable by Medicare. While it is valid under HIPAA rules that a claim for dates of service before this date could be submitted on a transaction after this date, CMS is not aware of a business need for a provider to do so. The code would not be payable by any insurer and no Grouper software would be available to produce a code for those dates. Effective Through Dates: HIPPS codes are no longer valid under HIPAA on transactions on or after this date. This date may vary from the date a code ceases to be payable by Medicare, since other payers may continue to use older HIPPS codes after Medicare transitions to a new payment system. Since CMS, as the HIPPS code set maintainer, may not have complete information about other payers’ uses of these codes, codes may remain effective under HIPAA long after they cease to be payable on Medicare claims. To reflect this, a separate column on the HIPPS Code Master List indicates the Medicare Payment Though Date." |
| [Health Outcomes](NamingSystem-hi.md) | Health Outcomes |
| [Healthcare Common Procedure Coding System (HCPCS) level II alphanumeric codes](NamingSystem-hcpcs-Level-II.md) | The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing. Level II alphanumeric procedure and modifier codes comprise the A to V range. |
| [Healthcare Provider Taxonomy HIPAA](NamingSystem-v3-HealthcareProviderTaxonomyHIPAA.md) | This HL7 Version 3 code system stub was created many years ago for the convenience of the HL7 community using the RIM; it has been determined that there is licensure issue with the republishing of the content for this code system by HL7, as well as erroneous and incomplete content. Content should be accessed using the links at nucc.org |
| [Home Health Care](NamingSystem-hhcc.md) | HHCC - Home Health Codes |
| [Human Genome Variation Society nomenclature](NamingSystem-v3-hgvs.md) | HGVS nomenclatures are the guidelines for mutation nomenclature made by the Human Genome Variation Society. HGVS nomenclature can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type should be able to distinguish expressions in HGVS nomenclature from coded concepts. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, HGVS nomenclature can be used to as the observation values for DNA sequence variations. For example, OBX|1|CWE|48004-6^DNA Sequence Variation^LN||c.1129C>T^^HGVS| Versioning information: The HGVS nomenclature for the description of sequence variants was last modified Feb 20, 2008. The HGVS nomenclature for the description of protein sequence variants was last modified May 12, 2007. The HGVS nomenclature for the description of DNA sequence variants was last modified June 15, 2007 The HGVS nomenclature for the description of RNA sequence variants was last modified May 12, 2007 HGVS nomenclatures can be used freely by the public. |
| [Human Phenotype Ontology](NamingSystem-HPO.md) | "The Human Phenotype Ontology (HPO) provides a standardized vocabulary of phenotypic abnormalities encountered in human disease. Each term in the HPO describes a phenotypic abnormality, such as Atrial septal defect. The HPO is currently being developed using the medical literature, Orphanet, DECIPHER, and OMIM. HPO currently contains over 13,000 terms and over 156,000 annotations to hereditary diseases. The HPO project and others have developed software for phenotype-driven differential diagnostics, genomic diagnostics, and translational research. The HPO is a flagship product of the Monarch Initiative, an NIH-supported international consortium dedicated to semantic integration of biomedical and model organism data with the ultimate goal of improving biomedical research. The HPO, as a part of the Monarch Initiative, is a central component of one of the 13 driver projects in the Global Alliance for Genomics and Health (GA4GH) strategic roadmap." Please see https://hpo.jax.org/app/download/ontology. Releases, produced approximately every 2 months, can be found[here](https://github.com/obophenotype/human-phenotype-ontology/releases). |
| [IANA Media Types](NamingSystem-v3-mediaType.md) | Internet Assigned Numbers Authority (IANA) Mime Media Types. Identifies the type of the encapsulated data and identifies a method to interpret or render the data. The IANA defined domain of media types is established by the Internet standard RFC 2045 [http://www.ietf.org/rfc/rfc2045.txt] and 2046 [http://www.ietf.org/rfc/rfc2046.txt]. RFC 2046 defines the media type to consist of two parts:1. top level media type, and
1. media subtype However, this HL7 datatypes specification treats the entire media type as one atomic code symbol in the form defined by IANA, i.e., top level type followed by a slash "/" followed by media subtype. Currently defined media types are registered in a database [http://www.iana.org/assignments/media-types/index.html] maintained by IANA. Currently several hundred different MIME media types are defined, with the list growing rapidly. In general, all those types defined by the IANA MAY be used.
 |
| [IANA Time Zone Database](NamingSystem-IANATimeZoneDatabase.md) | The Time Zone Database (often called tz or zoneinfo) contains code and data that represent the history of local time for many representative locations around the globe. It is updated periodically to reflect changes made by political bodies to time zone boundaries, UTC offsets, and daylight-saving rules. |
| [ICCS](NamingSystem-ics.md) | ICCS |
| [ICD-10](NamingSystem-icd10.md) | International Classification of Diseases revision 10 (ICD 10) |
| [ICD-10 American English](NamingSystem-icd10ae.md) | International Statistical Classification of Diseases and Related Health Problems (ICD-10): Americanized Version. 10th rev. Geneva (Switzerland): World Health Organization, 1998. |
| [ICD-10 Dual Coding](NamingSystem-ICD-10DualCoding.md) | ICD-10 allows dual coding. Refer to Section 3.1.3 of the ICD-10 Instruction Manual (2nd Edition, http://www.who.int/entity/classifications/icd/ICD-10_2nd_ed_volume2.pdf). This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only). An ICD-10 dual code expression SHALL consist of two ICD-10 codes separated by space. This code system SHALL NOT be used for single ICD-10 codes; the normal ICD-10 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. Dual code expressions SHALL only be used per the rules described in the ICD-10 instruction manual.**An example CD:**`&#xD; &lt;example code="J21.8 B95.6" codeSystem="2.16.840.1.113883.6.260"&gt;&#xD; &lt;originalText value="Staph aureus bronchiolitis"/&gt;&#xD; &lt;/example&gt;&#xD;`Where:* J21.8 is: Acute bronchiolitis due to other specified organisms 
* B95.6 is: Staphylococcus aureus as the cause of diseases classified to other chapters
 |
| [ICD-10 German](NamingSystem-dmdICD10.md) | Internationale Klassifikation der Krankheiten 10 [German translation of ICD10]. Germany: Deutsches Institut fuer Medizinische Dokumentation und Information, 1998. |
| [ICD-10 Procedure Codes](NamingSystem-icd10PCS.md) | ICD Procedure Coding System (ICD 10 PCS) |
| [ICD-9 Dual Coding](NamingSystem-ICD-9DualCoding.md) | ICD-9 Dual Coding Expression Syntax", description: ICD-9 allows dual coding. Refer to Section ?? of the ICD-9 Instruction Manual (ref?). This OID identifies the code system that describes how to encode Dual Coding in a CD compatible expression (for Datatypes R2 CD only). An ICD-9 dual code expression SHALL consist of two ICD-9 codes separated by space. This code system SHALL NOT be used for single ICD-9 codes; the normal ICD-9 code system oid which is 2.16.840.1.113883.6.3 should be used in this case. DisplayName SHALL not be used. Dual code expressions SHALL only be used per the rules described in the ICD-9 instruction manual.**An example CD:**`&#xD; &lt;example code="989.5 E905.9" codeSystem="2.16.840.1.113883.6.260"&gt;&#xD; &lt;originalText value="ANAPHYLAXIS DUE TO BITE OR STING"/&gt;&#xD; &lt;/example&gt;&#xD;`Where:* 989.5 is: "Toxic effect of venom" 
* E905.9 is: "Bite or sting"
 |
| [ICD-9-CM (diagnosis codes)](NamingSystem-ICD-9CM-diagnosiscodes.md) | The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute. |
| [ICD-9-CM (procedure codes)](NamingSystem-ICD-9CM-procedurecodes.md) | The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute. |
| [ICD-9CM](NamingSystem-icd9cm.md) | International Classification of Diseases revision 9, with Clinical Modifications (ICD 9 CM) |
| [ICD10, Dutch Translation](NamingSystem-ICD10dut.md) | Hirs, W., H.W. Becker, C. van Boven, S.K. Oskam, I.M. Okkes, H. Lamberts. ICD-10, Dutch Translation, 200403. Amsterdam: Department of General Practice, Academic Medical Center/University of Amsterdam, Dutch College of General Practitioners (NHG), March 20 |
| [ICD9](NamingSystem-icd9.md) | ICD9 |
| [ICH Context of Use](NamingSystem-ICHContextOfUse.md) | Codes are found within the vocabulary package at the link above which is available from this page:[https://ich.org/page/ich-electronic-common-technical-document-ectd-v40](https://ich.org/page/ich-electronic-common-technical-document-ectd-v40). Specifically, the codes are in the “ICH Context of Use” tab of the "ICH M8 OID Listing_eCTDv4_v5.xlsx" workbook. The codes are part of the ICH implementation of HL7 V3 Standard: Regulated Studies; Regulated Product Submissions (RPS), Release 2 Normative (described here:[https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=38)) When using this uri in FHIR, the version identifier is mandatory and the code system uri cannot be used without it. This system uses an integer based versioning system in conjunction with an OID update. For example, if the version of the system is v5, the OID is 2.16.840.1.113883.3.989.2.2.1.1.5. This system has an OID stem of 2.16.840.1.113883.3.989.2.2.1.1. |
| [ICHPPC-2](NamingSystem-IC2.md) | ICHPPC-2 |
| [ICPC2-ICD10 Thesaurus](NamingSystem-icpc2-icd10-THSRS.md) | A diagnostic Terminology for semi-automatic Double Coding in Electronic Patient Records The thesaurus is a part of the CD Rom: "ICPC in the Amsterdam Transition Project. Extended Version. IM Okkes, SK Oskam, H. Lamberts. Amsterdam: Academic Medical Center/University of Amsterdam. Department of Family Medicine", see also the web site http://www.transitieproject.nl for this application of the thesaurus. This bilingual (English/Dutch) ICPC2-ICD10 thesaurus is derived from an extended version of the CD-Rom ICPC in the Amsterdam Transition Project, that was published as a companion to ICPC-2-R by Oxford University Press (2005). As was the case with the former thesaurus (published in Dutch in 2003), the content of this new thesaurus may be copied for academic purposes, and be used for teaching and research under the usual referencing conditions. Any other and/or commercial use requires prior permission from the authors, represented by Dr. Inge Okkes (see below). It is strongly recommended that you first go through the ICPC Tutorial, the Manual and the Glossary, and consider printing them. Becker, H.W., C. van Boven, S.K. Oskam, I.M. Okkes, W. Hirs, H. Lamberts. ICPC2 - ICD10 Thesaurus, Version March, 2004. Amsterdam: Project "Adaptation ICPC, integration and implementation of ICPC2 and ICD10(-CM)." Department of General Practice, Academic |
| [ICPC2-ICD10 Thesaurus (English)](NamingSystem-icpc2-icd10-ENG.md) | Becker, H.W., C. van Boven, S.K. Oskam, I.M. Okkes, W. Hirs, H. Lamberts. ICPC2 - ICD10 Thesaurus, Version March, 2004. Amsterdam: Project "Adaptation ICPC, integration and implementation of ICPC2 and ICD10(-CM)." Department of General Practice, Academic |
| [ICPC2-ICD10 Thesaurus, 7-bit](NamingSystem-mth-icpc2-icd10-7B.md) | International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World |
| [ICPC2-ICD10 Thesaurus, Am Engl](NamingSystem-mth-icpc2-icd10-AE.md) | International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World |
| [ICPC2-ICD10ENG Thesaurus, Dutch Translation](NamingSystem-icpc2-icd10-DUT.md) | International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World |
| [ICPC2E 1998 Plus](NamingSystem-icpc2E-P.md) | International Classification of Primary Care, Version 2-Plus. Produced by NLM. Bethesda (MD): National Library of Medicine, UMLS project. This node has the various modifications and translations produced under it. |
| [ICPC2E 1998 Plus Am Engl](NamingSystem-icpc2E-P-AE.md) | International Classification of Primary Care, Version 2-Plus, Australian Modification. Americanized English Equivalents, January, 2000. Produced by NLM. Bethesda (MD): National Library of Medicine, UMLS project |
| [ICPC2E Am Engl (Metathesaurus)](NamingSystem-mthicpc2E-AE.md) | Henk Lamberts and Inge Hofmans-Okkes. International Classification of Primary Care 2nd Edition, Electronic, 2E, American English Equivalents. Amsterdam: International Classification of Primary Care / prepared by the Classification Committee of the World Health Organization. Entry derived from the UMLS Metathesaurus. |
| [ICPC2E, Dutch Translation](NamingSystem-icpc2E-DUT.md) | Hirs, W., H.W. Becker, C. van Boven, S.K. Oskam, I.M. Okkes, H. Lamberts. International Classification of Primary Care 2E: 2nd ed. electronic. Dutch Translation. Amsterdam: Department of General Practice, Academic Medical Center/University of Amsterdam, D |
| [ICPC2P 1998 Plus Austral Mod](NamingSystem-icpc2E-P-AUS.md) | International Classification of Primary Care, Version 2-Plus, Australian Modification. January, 2000 |
| [IEC 61966-2-1: Colour measurement and management - Part 2-1: Colour management - Default RGB colour space - sRGB](NamingSystem-IECColourManagement.md) | IEC 61966-2-1:1999 is the official specification of sRGB. It provides viewing environment, encoding, and colorimetric details. For more information, please see https://webstore.iec.ch/publication/6168 |
| [IETF RFC 1766](NamingSystem-IETF1766.md) | Codes representing languages for which a person has some level of proficiency for written or spoken communication.**Examples:**Spanish, Italian, German, English, American Sign, etc. |
| [ILRSpeakingSkillScale](NamingSystem-ILRSpeakingSkillScale.md) | The following Interagency Language Roundtable (ILR) Skill Level Descriptions (SLDs) describe proficiency as the functional ability to produce spoken language that reflects current usage. The SLDs characterize proficiency ranging from no communicative ability to mastery. They constitute an ordinal scale that includes six ranked base levels from 0 to 5. They illustrate, but do not exhaustively characterize, the proficiency a person may demonstrate at a given level on the scale. Control of a base level (Levels 1, 2, 3, 4, and 5) typically implies control of the previous levels' aspects. A higher level of performance in one aspect does not justify a higher general proficiency rating. Level 5 includes the features of all levels. Still, as with all levels, Level 5 is a range and performance will vary. There are plus levels for levels 0 through 4. Plus levels describe proficiency that substantially exceeds one base level and does not fully meet the criteria of the next base level. To merit a plus level, the demonstrated proficiency must match the plus level description and not be merely a strong performance at the base level. The SLDs describe four aspects of language proficiency: functional ability (color coded green), precision of forms and meanings (red), content meaningfulness (black), and contextual appropriateness (blue). Functional ability refers to the communicative acts or tasks that an individual can accomplish. There are no functional abilities specific to the plus levels. Precision of forms and meanings refers to accuracy, range, and complexity. Content meaningfulness refers to the relevance and substantive coverage of topics. Contextual appropriateness refers to register, acceptability, and appropriateness of language for the intended audience. The SLDs are presented in an official prose version as well as a supplementary crosswalk matrix. Each level description begins with a bolded main statement that summarizes the features of that level. Color coded supporting statements follow the main statement and describe the four aspects in detail. The crosswalk matrix shows the structure of the SLDs explicitly across the four skills. For more information, including the source content, please see[https://www.govtilr.org/Skills/Speaking.htm](https://www.govtilr.org/Skills/Speaking.htm). |
| [IMEI as a device identifier](NamingSystem-imei-identifier.md) | The International Mobile Equipment Identity (IMEI) is a number, usually unique, to identify 3GPP and iDEN mobile phones, as well as some satellite phones. The IMEI consists of 15 decimal digits: 14 digits plus a check digit while the IMEISV consists of 16 decimal digits: 14 digits plus two software version digits. These numbers includes information on the origin, model, and serial number of the device. The structure of the IMEI/SV is specified in 3GPP TS 23.003. The model and origin comprise the initial 8-digit portion of the IMEI/SV, known as the Type Allocation Code (TAC). The remainder of the IMEI is manufacturer-defined, with a Luhn check digit at the end. |
| [ISBT](NamingSystem-ib.md) | ISBT 128 is a coding system for blood components, hematopoietic progenitor cells and other tissues. It is comprised of an overall Application Specification, and labeling and coding documents for the separate sections: blood components, hematopoietic progenitor cells (draft), source plasma (draft) and tissues (draft). The documentation is supported by databases: Country/Collection Facility, Product Code (blood components), Product Code (hematopoietic progenitor sells), Product Code (source plasma), Product Code (tissues) and Special Testing. ISBT 128 is designed as a series of data structures that are designed to be technology-independent and can be used for bar coding, radio frequency tag encoding and electronic data interchange. The HL7 Blood Bank SIG is currently designing example messages that incorporate ISBT 128 coding. No changes of any kind will be needed to use ISBT 128 in HL7 messages. |
| [ISBT 128 Standard Terminology for Medical Products of Human Origin Product Description Codes](NamingSystem-ISBT128ProductDescriptionCodes.md) | The ISBT 128 Standard provides for the identification, terminology, coding, labeling, and data exchange for medical products of human origin. ISBT 128 Product Description Codes (PDCs) are associated with product descriptions in the ISBT 128 PDC Database based on standardized terminology. The ISBT 128 PDC Database is an international database protected by copyright that contains PDCs that may not apply to all countries. Note that the existence of a PDC does not imply that a product is acceptable to produce and distribute in your region. It is the responsibility of the user to observe national regulations, guidelines, and standards. For more information, see[https://www.isbt128.org/uri/productdescriptioncode](https://www.isbt128.org/uri/productdescriptioncode). |
| [ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types](NamingSystem-ISBT128PropertyTypes.md) | ISBT 128 Reference Table 042 provides data references for ISBT 128 Standard data structures used for the transfer of data pertaining to medical products of human origin within electronic messages. For more information, see[https://www.isbt128.org/uri](https://www.isbt128.org/uri). |
| [ISO 11073-10101 Health informatics - Point-of-care](NamingSystem-v3-mdc.md) | The nomenclature relates primarily to vital signs monitoring, but also includes semantics of other medical devices that are commonly used in acute care settings. There are multiple coding partitions each of which has a systematic name consisting of a set of base concepts and differentiating criteria. |
| [ISO 3166 Part 1 Country Codes](NamingSystem-v3-iso3166-1.md) | Identifies the coding system published in the ISO 3166-1 Standard for Country codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions. |
| [ISO 3166 Part 1 Country Codes, 2nd Edition](NamingSystem-iso3166-1edition2.md) | This OID identifies the coding system published in the ISO 3166-1 Standard for Country codes. It contains 3 sets of synonyms for the country codes: 2-character alphabetic, 3-character alphabetic, and numeric. Note that this is the 2nd edition of the standard. |
| [ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-2](NamingSystem-iso3166-1edition2alpha2.md) | Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, 2-character alphabetic codes. |
| [ISO 3166 Part 1 Country Codes, 2nd Edition, Alpha-3](NamingSystem-iso3166-1edition2alpha3.md) | Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, 3-character alphabetic codes. |
| [ISO 3166 Part 1 Country Codes, 2nd Edition, Numeric](NamingSystem-iso3166-1edition2numeric.md) | Identifies the coding system published in the ISO 3166-1 Standard for Country codes, 2nd edition, numeric codes. |
| [ISO 3166 Part 2 Country Subdivision Codes](NamingSystem-iso3166-2.md) | Identifies the coding system published in the ISO 3166-2 Standard for Country Subdivision codes. This standard is released periodically, and a new OID will be assigned by ISO for new editions. |
| [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](NamingSystem-ISO3166Part1.md) | ISO 3166-1 establishes codes that represent the current names of countries, dependencies, and other areas of particular geopolitical interest, on the basis of country names obtained from the United Nations. |
| [ISO 3166-2 Codes for the representation of names of countries and their subdivisions — Part 2: Country subdivision code](NamingSystem-ISO3166Part2.md) | ISO 3166-2 establishes a code that represents the names of the principal administrative divisions, or similar areas, of the countries and entities included in ISO 3166-1. |
| [ISO 3166-3 Codes for the representation of names of countries and their subdivisions — Part 3: Code for formerly used names of countries](NamingSystem-ISO3166Part3.md) | ISO 3166-3 establishes a code that represents non-current country names, i.e. the country names deleted from ISO 3166 since its first publication in 1974. |
| [ISO 4217 Currency Codes](NamingSystem-iso4217.md) | ISO 4217 currency codes. |
| [ISO 639-1 Alpha-2 Language Codes](NamingSystem-iso639-1ret.md) | Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.**DeprecationComment:**This code system is being deprecated, as the OID identifying it has been replaced with the correct ISO OID of 1.0.639.1 |
| [ISO 639-1: Codes for the representation of names of languages -- Part 1: Alpha-2 code](NamingSystem-iso639-1.md) | **Description:**Codes for the Representation of Names of Languages Part 1: Alpha-2 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification. This part of ISO 639 provides a code consisting of language code elements comprising two-letter language identifiers for the representation of names of languages. The language identifiers according to this part of ISO 639 were devised originally for use in terminology, lexicography and linguistics, but may be adopted for any application requiring the expression of language in two- letter coded form, especially in computerized systems. The alpha-2 code was devised for practical use for most of the major languages of the world that are not only most frequently represented in the total body of the world's literature, but which also comprise a considerable volume of specialized languages and terminologies. Additional language identifiers are created when it becomes apparent that a significant body of documentation written in specialized languages and terminologies exists. Languages designed exclusively for machine use, such as computer-programming languages, are not included in this code. The code set is available from http://www.iso.org/iso/iso_catalogue/catalogue_ics/catalogue_detail_ics.htm? csnumber=22109&ICS1=1&ICS2=140&ICS3=20 |
| [ISO 639-2 Alpha-3 Language Codes](NamingSystem-iso639-2ret.md) | Codes for the Representation of Names of Languages Part 2: Alpha-3 Code. Used as part of the IETF 3066 specification for languages throughout the HL7 specification.**DeprecationComment:**This code system is being deprecated, as the OID identifying it has been replaced with the correct ISO OID of 1.0.639.2 |
| [ISO 639-2: Codes for the representation of names of languages -- Part 2: Alpha-3 code](NamingSystem-iso639-2.md) | **Description:**Codes for the representation of names of languages, 3 character alphabetic codes. This has been superceded by ISO 639-3 for many purposes. ISO 639-2 was released in 1998. The code set is available from http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=4767 |
| [ISO 639-3 Language Codes Alpha 3](NamingSystem-iso639-3.md) | **Description:**ISO 639-3 is a code that aims to define three-letter identifiers for all known human languages. At the core of ISO 639-3 are the individual languages already accounted for in ISO 639-2. The large number of living languages in the initial inventory of ISO 639-3 beyond those already included in ISO 639-2 was derived primarily from Ethnologue (15th edition). Additional extinct, ancient, historic, and constructed languages have been obtained from Linguist List. SIL International has been designated as the ISO 639-3/RA for the purpose of processing requests for alpha-3 language codes comprising the International Standard, Codes for the representation of names of languages - Part 3: Alpha-3 code for comprehensive coverage of languages. The ISO 639-3/RA receives and reviews applications for requesting new language codes and for the change of existing ones according to criteria indicated in the standard. It maintains an accurate list of information associated with registered language codes which can be viewed on or downloaded from this website, and processes updates of registered language codes. Notification of pending and adopted updates are also distributed on a regular basis to subscribers and other parties. |
| [ISO/IEC 21000-6:2004(E) Rights Data Dictionary](NamingSystem-iso21000-6-2004E-RDD.md) | ISO/IEC 21000-6:2004 describes a Rights Data Dictionary which comprises a set of clear, consistent, structured, integrated and uniquely identified terms to support the MPEG-21 Rights Expression Language (REL), ISO/IEC 21000-5. Annex A specifies the methodology for and structure of the RDD Dictionary, and specifies how further Terms may be defined under the governance of a Registration Authority, requirements for which are described in Annex C. Taken together, these specifications and the RDD Dictionary and Database make up the RDD System. Use of the RDD System will facilitate the accurate exchange and processing of information between interested parties involved in the administration of rights in, and use of, Digital Items, and in particular it is intended to support ISO/IEC 21000-5 (REL). Clause 6 describes how ISO/IEC 21000-6:2004 relates to ISO/IEC 21000-5. As well as providing definitions of terms for use in ISO/IEC 21000-5, the RDD System is designed to support the mapping of terms from different namespaces. Such mapping will enable the transformation of metadata from the terminology of one namespace (or Authority) into that of another namespace. Mapping, to ensure minimum ambiguity or loss of semantic integrity, will be the responsibility of the Registration Authority. Provision of automated trm look-up is also a requirement. The RDD Dictionary is a prescriptive dctionary, in the sense that it defines a single meaning for a trm represented by a particular RddAuthorized TermName, but it is also inclusive in that it can recognize the prescription of other Headwords and definitions by other Authorities and incorporates them through mappings. The RDD Dictionary also supports the circumstance that the same name may have different meanings under different Authorities. ISO/IEC 21000-6:2004describes audit provisions so that additions, amendments and deletions to Terms and their attributes can be tracked. ISO/IEC 21000-6:2004 recognizes legal definitions as and only as Terms from other Authorities that can be mapped into the RDD Dictionary. Therefore Terms that are directly authorized by the RDD Registration Authority neither define nor prescribe intellectual property rights or other legal entities. |
| [IUPAC/IFCC Component Codes](NamingSystem-IUPC.md) | IUPAC/IFCC Component Codes |
| [IUPAC/IFCC Property Codes](NamingSystem-IUPP.md) | IUPAC/IFCC Property Codes |
| [Idaho Driver's License](NamingSystem-IdahoDLN.md) | Idaho Motor Vehicle Bureau |
| [Illinois Driver's License](NamingSystem-IllinoisDLN.md) | Illinois Motor Vehicle Bureau |
| [Indiana Driver's License](NamingSystem-IndianaDLN.md) | Indiana Motor Vehicle Bureau |
| [Industry CDC Census 2010](NamingSystem-PHIndustryCDCCensus2010.md) | 2010 Industry coding system used by CDC (NIOSH and NCHS) for coding industry text. Industry describes an economic/business sector comprised of businesses/ enterprises concerned with the output of a specified category of products or services. |
| [Intelligent Medical Objects](NamingSystem-IMO.md) | IMO is a clinical interface terminology, which helps to map diagnostic, procedure and other terminologies to medical concepts and codes. |
| [International Civil Aviation Organization Sex](NamingSystem-icaosex.md) | ICAO is funded and directed by 193 national governments to support their diplomacy and cooperation in air transport as signatory states to the[Chicago Convention (1944)](https://www.icao.int/about-icao/History/Pages/default.aspx)Its core function is to maintain an administrative and expert bureaucracy (the[ICAO Secretariat](https://www.icao.int/secretariat/Pages/default.aspx)supporting these diplomatic interactions, and to research new air transport policy and standardization innovations as directed and endorsed by governments through the[ICAO Assembly](https://www.icao.int/about-icao/assembly/Pages/default.aspx), or by the[ICAO Council](https://www.icao.int/about-icao/Council/Pages/council.aspx)which the assembly elects. ICAO has developed a technical specification (sample version form 2021[here](https://www.icao.int/publications/Documents/9303_p7_cons_en.pdf)) to "allow compatibility and global interchange using both visual (eye readable) and machine readable means. The specifications lay down standards for visas which can, where issued by a State and accepted by a receiving State, be used for travel purposes. The MRV[Machine Readable Visa] shall, as a minimum, contain the data specified herein in a form that is legible both visually and by optical character recognition methods.." Further, defining that "Sex of MRV-A[Format A - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified." Sex of MRV-B[Format B - Machine Readable Visa] holder, when included, is to be specified by use of the single initial commonly used in the language of the State of issue. If translation into English, French or Spanish is necessary, followed by an oblique and the capital letter F for female, M for male, or X for unspecified. |
| [International Classification for Nursing Practice](NamingSystem-icnp.md) | ICNP(r) is a combinatorial terminology, using a multi-axial structure. ICNP(r) provides standardized terms and codes for terms in two classifications that can be used to compose or create pre-coordinated concepts to represent observations and procedures, specifically, patient problems/nursing diagnoses, nursing interventions including those focused on assessment and actual or expected (goal) outcomes. The ICNP(r) Classification for Nursing Phenomena is used to compose concepts or statements to represent observations (nursing diagnoses, patient problems, patient status, patient outcomes). The ICNP(r) Nursing Actions Classification is used to compose concepts or statements to represent procedures (nursing interventions) |
| [International Classification of Diseases for Oncology](NamingSystem-icd-o.md) | International Classification of Diseases for Oncology) |
| [International Classification of Diseases for Oncology, version 3.](NamingSystem-icd-o-3.md) | International Classification of Diseases for Oncology, version 3. For more information see http://www.who.int/classifications/icd/adaptations/oncology/en/. |
| [International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM)](NamingSystem-icd10CM.md) | The International Classification of Diseases, 10th Revision, Clinical Modification (ICD-10-CM), describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases. The ICD-10-CM codes can be used as the value of the Act.cd attribute. |
| [International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)](NamingSystem-ICD11MMS.md) | The International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) is one of the ICD11 linearizations. Information about the ICD Foundation Component and the ICD11 Linearizations can be found in the complete reference guide here:[https://icd.who.int/icd11refguide/en/index.html](https://icd.who.int/icd11refguide/en/index.html)"**The ICD11 Linearizations (Tabular lists)**A linearization is a subset of the foundation component, that is:1. fit for a particular purpose: reporting mortality, morbidity, primary care or other uses;
1. composed of entities that are Mutually Exclusive of each other;
1. each entity is given a single parent. Linearization is similar to the classical print versions of ICD Tabular List (e.g. volume I of ICD-10 or other previous editions). The main linearization of ICD-11 is Mortality and Morbidity Statistics (MMS). Various linearizations could be built at different granularity, use case or other purposes such as for Primary Care, Clinical Care or Research. The linkage from the foundation component to a particular linearization will ensure consistent use of the ICD." ICD-11 for Mortality and Morbidity (ICD-11 MMS) can be downloaded in either print or electronic (spreadsheet) format from the browser in the Info tab located[here](https://icd.who.int/browse11/l-m/en)
 |
| [International Classification of Functioning, Disability and Health](NamingSystem-ICF.md) | "The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors. ICF is the WHO framework for measuring health and disability at both individual and population levels. ICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution[WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf)) as the international standard to describe and measure health and disability. ICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail." Official updates to the ICF are available as annual lists of changes. These updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network. To license ICF, the same rules apply for ICF as for ICD. See[http://icd.who.int/](http://icd.who.int/). For more information, see[https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health](https://www.who.int/standards/classifications/international-classification-of-functioning-disability-and-health). |
| [International Classification of Functioning, Disability and Health, Dutch Translation](NamingSystem-ICFDut.md) | "The International Classification of Functioning, Disability and Health, known more commonly as ICF, is a classification of health and health-related domains. As the functioning and disability of an individual occurs in a context, ICF also includes a list of environmental factors. ICF is the WHO framework for measuring health and disability at both individual and population levels. ICF was officially endorsed by all 191 WHO Member States in the Fifty-fourth World Health Assembly on 22 May 2001(resolution[WHA 54.21](http://apps.who.int/gb/archive/pdf_files/WHA54/ea54r21.pdf)) as the international standard to describe and measure health and disability. ICF is based on the same foundation as ICD and ICHI and share the same set of extension codes that enable documentation at a higher level of detail." "The Dutch translation of the ICF is published in book form by BSL. The ICF can also be consulted online in the[Classification Browser](https://class.whofic.nl/browser.aspx?scheme=ICF-nl.cla). The ICF team of the WHO-FIC Collaborating Center combines expertise in the field of the ICF for the Dutch language area and currently consists of delegations from the Netherlands Paramedical Institute, the University Medical Center Groningen, Maastricht University, the Big Move Institute, Stichting Scientific Research Road Safety, University of Ghent, Vilans, and Rehabilitation Center de Hoogstraat." Official updates to the ICF are available as annual lists of changes. These updates are approved annually at the October meeting of the WHO Family of International Classifications (WHO-FIC) Network. To license ICF, the same rules apply for ICF as for ICD. See[http://icd.who.int/](http://icd.who.int/). For more information, see[https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf](https://www.whofic.nl/familie-van-internationale-classificaties/referentie-classificaties/icf). |
| [International Classification of Primary Care - Third Revision](NamingSystem-ICPC3.md) | The International Classification of Primary Care (ICPC) is the most widely used international classification for systematically capturing and organising clinical information in primary care. It is a unifying language for Primary Care, supporting the coherent coding of reason(s) for encounter, symptoms and complaints, diagnoses, health problems, functioning, environmental factors, personal factors related to health and processes of care, all in only one classification. |
| [International Classification of Primary Care 1993 (English)](NamingSystem-icpc-ENG.md) | The International Classification of Primary Care (ICPC). Swedish Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Basque](NamingSystem-icpc-BAQ.md) | The International Classification of Primary Care (ICPC). Basque Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Danish](NamingSystem-icpc-DAN.md) | The International Classification of Primary Care (ICPC). Danish Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Dutch](NamingSystem-icpc-DUT.md) | The International Classification of Primary Care (ICPC). Dutch Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Finnish](NamingSystem-icpc-FIN.md) | The International Classification of Primary Care (ICPC). Finnish Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 French](NamingSystem-icpc-FRE.md) | The International Classification of Primary Care (ICPC). French Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 German](NamingSystem-icpc-GER.md) | The International Classification of Primary Care (ICPC). German Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Hebrew](NamingSystem-icpc-HEB.md) | The International Classification of Primary Care (ICPC). Hebrew Translation, Denmark: World Organisation of Family Doctors, 1993 |
| [International Classification of Primary Care 1993 Hungarian](NamingSystem-icpc-HUN.md) | The International Classification of Primary Care (ICPC). Hungarian Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Italian](NamingSystem-icpc-ITA.md) | The International Classification of Primary Care (ICPC). Italian Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Norwegian](NamingSystem-icpc-NOR.md) | The International Classification of Primary Care (ICPC). Norwegian Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Portuguese](NamingSystem-icpc-POR.md) | The International Classification of Primary Care (ICPC). Portuguese Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Spanish](NamingSystem-icpc-SPA.md) | The International Classification of Primary Care (ICPC). Spanish Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care 1993 Swedish](NamingSystem-icpc-SWE.md) | The International Classification of Primary Care (ICPC). Swedish Translation. Denmark: World Organisation of Family Doctors, 1993. |
| [International Classification of Primary Care, 1993 edition](NamingSystem-icpc.md) | The International Classification of Primary Care (ICPC). Denmark: World Organisation of Family Doctors, 1993. Various language translations are identified beneath this OID. |
| [International Classification of Primary Care, second edition (1998)](NamingSystem-v3-icpc2E.md) | International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World |
| [International Classification of Primary Care, second edition, English](NamingSystem-icpc2E-ENG.md) | International Classification of Primary Care / prepared by the Classification Committee of the World Organization of National Colleges, Academies and Academic Associations of General Practitioners/Family Physicians (WONCA), known more briefly as the World |
| [International Classification of Sleep Disorders](NamingSystem-ICSD.md) | International Classification of Sleep Disorders |
| [International System for Human Cytogenomic Nomenclature (ISCN)](NamingSystem-ISCN.md) | The International System for Human Cytogenetic Nomenclature (ISCN) was created by the International Standing committee on Human Cytogenetic Nomenclature to represent the outcome of cytogenetic tests. ISCN specifies the nomenclature to describe karyotypes, chromosome abnormalities, in situ hybridization, etc. ISCN provides a list of symbols and abbreviated terms in adjunction with a set of rules, which can be used in the description of chromosomes and chromosome abnormalities, such as p for short arm of chromosome, q for long arm of chromosome, cen for centromere, del for deletion, ish for in situ hybridization, and plus sign (+) for gain, etc. A LOINC code is created to represent "chromosome analysis results in ISCN expression". In HL7 v2 messages, this LOINC code is used in OBX-3 with a coded result (CWE data type) that will be sent in OBX-5. The value of the coded result is an ISCN expression, and ISCN will be the code system for the coded result. |
| [Internationalized Resource Identifier (IRI)](NamingSystem-iri.md) | As defined by RFC 3987 (http://www.ietf.org/rfc/rfc3987.txt). Internationalized Resource Identifiers (IRIs) are the internationalized version of URIs (which are also defined as a NamingSystem as https://terminology.hl7.org/4.0.0/NamingSystem-uri.html) that allow Unicode characters to be used in the identifier with some restrictions, which was defined by the Internet Engineering Task Force (IETF) in 2005. An IRI such as 'https://hi.wikipedia.org/wiki/हृदय' can be percent-encoded into the URI 'https://hi.wikipedia.org/wiki/%E0%A4%B9%E0%A5%83%E0%A4%A6%E0%A4%AF' to be used as a URL, but the IRI is easier to read, particularly for readers of non-Latin languages, and is natively supported by many tools, including many browsers, HTTP libraries, and in the Resource Description Framework (RDF). IRI values SHALL NOT be used in Identifier.system or Coding.system. They SHALL only be used in Identifier.value (where Identifier.system = urn:ietf:rfc:3987). |
| [Iowa Driver's License](NamingSystem-IowaDLN.md) | Iowa Motor Vehicle Bureau |
| [Japanese Chemistry](NamingSystem-JC8.md) | Japanese Chemistry |
| [Kansas Driver's License](NamingSystem-KansasDLN.md) | Kansas Motor Vehicle Bureau |
| [Kentucky Driver's License](NamingSystem-KentuckyDLN.md) | Kentucky Motor Vehicle Bureau |
| [Locus Reference Genomic Sequences (LRG)](NamingSystem-v3-lrg.md) | In collaboration with NCBI, the European Bioinformatics Institute (EBI) is developing the Locus Reference Genomic Sequences (LRG) database, which is a database of reference sequences. LRG is a system for providing a genomic DNA sequence representation of a single gene that is idealized, has a permanent ID (with no versioning), and core content that never changes. LRG is not a nomenclature system. More than one LRG could be created for a region of interest, should that need arise. Additional annotations will be present that may change with time (each item carrying its own date stamp), so that the latest ancillary knowledge about a gene is directly available. In other words, an LRG sequence and its core annotation are not meant to represent current biology knowledge, but to provide a standard for reporting variation in a stable coordinate system. The combination of the LRG plus the updatable-annotation layer will be used to support the biological interpretation of variants. LRG identifiers can be used with the HL7 coded data type (code data type that accepts expression data, or a coded expression data type). This coded data type will be gene symbols can be used with the HL7 coded data type. For example, in the HL7 messages specified according to the HL7 V2 Clinical Genomics Fully LOINC-Qualified Genetic Variation Model, LRG identifiers can be used to as the observation values for Genomic Reference Sequence Identifier (LOINC code: 48013-7). LRG is a database that can be used freely by the public. |
| [Logical Observation Identifier Names and Codes (LOINC)](NamingSystem-v3-loinc.md) | LOINC provides a set of universal names and ID codes for identifying laboratory and clinical test results.1,2 LOINC facilitates the exchange and pooling of results, such as blood hemoglobin, serum potassium, or vital signs, for clinical care, outcomes management, and research. LOINC's universal identifiers (names and codes) can be used in the context of order and observation exchanges between information systems that use syntax standards such as HL73, CEN TC251, ISO TC215, ASTM4, and DICOM. Specifically, the identifier can be used as the coded value for an observation in any other standard that uses the observation/observation value paradigm, whether messages, documents, application programming interface (API), etc. For example, LOINC codes are used widely in the OBX segment Observation Identifier field (OBX-3) of an ORU HL7 (HL7 version 2.x or ASTM 1238-9410) message that may be sent between a Clinical Laboratory Information Management Systems (LIMS) and Electronic Health Record Systems (EHR).5, 6 In this way, LOINC codes provide universal identifiers that allow the exchange of clinical data between heterogeneous computing environments. |
| [Louisiana Driver's License](NamingSystem-LouisianaDLN.md) | Louisiana Motor Vehicle Bureau |
| [MDDID](NamingSystem-mddid.md) | Medispan Drug Descriptor ID Entry autogenerated to support Sources from the UMLS. Full metadata set still incomplete. |
| [MDNS](NamingSystem-UMD.md) | MDNS |
| [MEDCIN](NamingSystem-medcin.md) | MEDCIN contains more than 175,000 clinical data elements arranged in a hierarchy, with each item having weighted links to relevant diagnoses. The clinical data elements are organized into six basic termtypes designed to accommodate information relevant to a clinical encounter. The basic termtypes in MEDCIN's terminological hierarchy are as follows: Symptoms History Physical Examination Tests Diagnoses Therapy Within this basic structure, MEDCIN terms are further organized in a ten level terminological hierarchy, supplemented by an optional, multi-hierarchical diagnostic index. For example, the symptom of "difficulty breathing" is placed in the terminological hierarchy as a subsidiary (or "child") finding of "pulmonary symptoms," although the presence (or absence) of difficulty breathing can related to conditions as diverse as myocardial infarction, bronchitis, pharyngeal foreign bodies, asthma, pulmonary embolism, etc. MEDCIN's diagnostic index provides more than 800 such links for difficulty breathing. |
| [METABOLIC SYNDROME](NamingSystem-metabolicSyndrome.md) | A collection of metabolic risk factors in one individual. The root causes of metabolic syndrome are overweight / obesity, physical inactivity, and genetic factors. Various risk factors have been included in metabolic syndrome. Factors generally accepted as being characteristic of this syndrome include abdominal obesity, atherogenic dyslipidemia, raised blood pressure, insulin resistence with or without glucose intolerance, prothrombotic state, and proinflammatory state. |
| [MIME](NamingSystem-v3-mime.md) | IETF MIME media types |
| [MTH MedDRA Spanish](NamingSystem-MTHMDRSPA.md) | Metathesaurus Forms of Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Spanish Edition. Bethesda, MD: National Library of Medicine, March 2004. |
| [Maine Driver's License](NamingSystem-MaineDLN.md) | Maine Motor Vehicle Bureau |
| [Manufacturers of Vaccines (MVX)](NamingSystem-MVX.md) | "The CDC's National Center for Immunization and Respiratory Diseases ([NCIRD](https://www.cdc.gov/ncird/)) developed and maintains HL7 Table 0227, Manufacturers of Vaccines (MVX). It includes both active and inactive manufacturers of vaccines in the US. Inactive MVX codes allow transmission of historical immunization records. When MVX code is paired with a CVX (vaccine administered) code, the specific trade named vaccine may be indicated. MVX is the underlying Master Code System for V2 table 0227 (Manufacturers Of Vaccines (code=MVX)). The machine readable name for MVX in PHIN VADS is PH_VaccinesAdministeredCVX_CDC_NIP. Status indicates if the manufacturer is currently making vaccine for distribution in the United States. Last Updated indicates the last time this particular manufacturer code was updated in this table. Questions regarding MVX should be directed to the[IIS Technical Assistance Team](mailto:iisinfo@cdc.gov)(or use[mailing address](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx#addr))." For more information, please see[here](https://www2.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=mvx). |
| [Maryland Driver's License](NamingSystem-MarylandDLN.md) | Maryland Motor Vehicle Bureau |
| [Massachusetts Driver's License](NamingSystem-MassachusettsDLN.md) | Massachusetts Motor Vehicle Bureau |
| [MedDRA Am Engl](NamingSystem-MDRAE.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA), American English Equivalents, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004 This is the English language version as encapsulated in the UMLS.. |
| [MedDRA Am Engl expanded](NamingSystem-MDREA.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA), American English Equivalents with expanded abbreviations, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004. |
| [MedDRA Dutch](NamingSystem-MDRDUT.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Dutch Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the Dutch language version as encapsulated in the UMLS.. |
| [MedDRA French](NamingSystem-MDRFRE.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, French Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the French language version as encapsulated in the UMLS.. |
| [MedDRA German](NamingSystem-MDRGER.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, German Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004 This is the German language version as encapsulated in the UMLS.. |
| [MedDRA Portuguese](NamingSystem-MDRPOR.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Portuguese Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004. This is the Portuguese language version as encapsulated in the UMLS.. |
| [MedDRA Spanish](NamingSystem-MDRSPA.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA) Version 7.0, Spanish Edition. International conference on Harmonization of Technical Requirements for Registration of Pharmaceuticals for Human Use (ICH). Reston, VA: MedDRA MSSO, March 1, 2004. This is the Spanish language version as encapsulated in the UMLS.. |
| [MedDRA expanded](NamingSystem-MDREX.md) | Medical Dictionary for Regulatory Activities Terminology (MedDRA), with expanded abbreviations, Version 7.0. Bethesda, MD: National Library of Medicine, March 1, 2004. |
| [Medical Dictionary for Regulatory Activities](NamingSystem-mdr.md) | MedDRA is a multilingual standardised international medical terminology which can be used for regulatory communication and evaluation of data pertaining to medicinal products for human use. MedDRA is designed for use in the registration, documentation and safety monitoring of medicinal products through all phases of the development cycle (i.e., from clinical trials to post-marketing surveillance).#13; MedDRA is structured as a five level hierarchy. System Organ Classes (SOCs) are the broadest terms (e.g., Cardiac disorders, Investigations). The lowest level of the terminology is the Lowest Level Term (LLT) level. |
| [Medical Economics Diagnostic Codes](NamingSystem-MEDX.md) | Medical Economics Diagnostic Codes |
| [Medical Economics Drug Codes](NamingSystem-MEDC.md) | Medical Economics Drug Codes |
| [Medical Subject Headings](NamingSystem-MeSH.md) | The Medical Subject Headings (MeSH) thesaurus is a controlled and hierarchically-organized vocabulary produced by the National Library of Medicine. It is used for indexing, cataloging, and searching of biomedical and health-related information. MeSH includes the subject headings appearing in MEDLINE/PubMed, the NLM Catalog, and other NLM databases. MeSH can be downloaded from https://www.nlm.nih.gov/databases/download/mesh.html MeSH can be browsed here: https://meshb.nlm.nih.gov/search |
| [Medicare Beneficiary Identifier (United States)](NamingSystem-cmsMBI.md) | Medicare Beneficiary Identifier (MBI) number is a unique identifier of a beneficiary used for Medicare entitlement and billing purposes. Medicare Beneficiary Identifiers are represented without any spaces or dashes. |
| [Medicare Severity Diagnosis Related Groups (MS-DRGs)](NamingSystem-MSDRG.md) | Section 1886(d) of the Act specifies that the Secretary shall establish a classification system (referred to as DRGs) for inpatient discharges and adjust payments under the IPPS based on appropriate weighting factors assigned to each DRG. Therefore, under the IPPS, we[CMS] pay for inpatient hospital services on a rate per discharge basis that varies according to the DRG to which a beneficiary's stay is assigned. The formula used to calculate payment for a specific case multiplies an individual hospital's payment rate per case by the weight of the DRG to which the case is assigned. Each DRG weight represents the average resources required to care for cases in that particular DRG, relative to the average resources used to treat cases in all DRGs. Congress recognized that it would be necessary to recalculate the DRG relative weights periodically to account for changes in resource consumption. Accordingly, section 1886(d)(4)(C) of the Act requires that the Secretary adjust the DRG classifications and relative weights at least annually. These adjustments are made to reflect changes in treatment patterns, technology, and any other factors that may change the relative use of hospital resources. Currently, cases are classified into Medicare Severity Diagnosis Related Groups (MS-DRGs) for payment under the IPPS based on the following information reported by the hospital: the principal diagnosis, up to 25 additional diagnoses, and up to 25 procedures performed during the stay. In a small number of MS-DRGs, classification is also based on the age, sex, and discharge status of the patient. Effective October 1, 2015, the diagnosis and procedure information is reported by the hospital using codes from the International Classification of Diseases, Tenth Revision, Clinical Modification (ICD-10-CM) and the International Classification of Diseases, Tenth Revision, Procedure Coding System (ICD-10-PCS). Content can be obtained on the CMS hosted page located at https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/AcuteInpatientPPS/MS-DRG-Classifications-and-Software The DRGs are released annually with errata published infrequently. The fiscal year and release version should be noted (e.g., 2021.38.R1). Requests for annual MS-DRG classification changes and any MS-DRG related inquiries should be sent to the MSDRGClassificationChange@cms.hhs.gov mailbox. For additional information on the MS-DRG system, including yearly reviews and changes to the MS-DRGs, please view prior Inpatient Prospective Payment System (IPPS) proposed and final rules located in the left navigational area of https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/AcuteInpatientPPS/MS-DRG-Classifications-and-Software |
| [Medication Reference Terminology (MED-RT)](NamingSystem-MEDRT.md) | Medication Reference Terminology (MED-RT) is the evolutionary successor to the Veterans Health Administration National Drug File – Reference Terminology (VHA NDF-RT). Both are formal ontology representations of medication terminology, pharmacologic classifications, and asserted authoritative relationships between them. The MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition. MED-RT can be downloaded from https://evs.nci.nih.gov/ftp1/MED-RT/ For more information, please see https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT |
| [Medispan Diagnostic Codes](NamingSystem-MDDX.md) | Medispan Diagnostic Codes |
| [Medispan GPI](NamingSystem-MGPI.md) | Medispan GPI |
| [Michigan Driver's License](NamingSystem-MichiganDLN.md) | Michigan Motor Vehicle Bureau |
| [Minnesota Driver's License](NamingSystem-MinnesotaDLN.md) | Minnesota Motor Vehicle Bureau |
| [Mississippi Driver's License](NamingSystem-MississippiDLN.md) | Mississippi Motor Vehicle Bureau |
| [Missouri Driver's License](NamingSystem-MissouriDLN.md) | Missouri Motor Vehicle Bureau |
| [Mondo Disease Ontology](NamingSystem-MONDO.md) | The Mondo Disease Ontology is a semi-automatically constructed ontology that merges in multiple disease resources to yield a coherent merged ontology that contains cross-species disease terminology. Numerous sources for disease definitions and data models currently exist, which include HPO, OMIM, SNOMED CT, ICD, PhenoDB, MedDRA, MedGen, ORDO, DO, GARD, etc; however, these sources partially overlap and sometimes conflict, making it difficult to know definitively how they relate to each other. This has resulted in a proliferation of mappings between disease entries in different resources; however mappings are problematic: collectively, they are expensive to create and maintain. Most importantly, the mappings lack completeness, accuracy, and precision; as a result, mapping calls are often inconsistent between resources. The UMLS provides intermediate concepts through which other resources can be mapped, but these mappings suffer from the same challenges: they are not guaranteed to be one-to-one, especially in areas with evolving disease concepts such as rare disease. In order to address the lack of a unified disease terminology that provides precise equivalences between disease concepts, we created Mondo, which provides a logic-based structure for unifying multiple disease resources. Mondo’s development is coordinated with the Human Phenotype Ontology (HPO), which describes the individual phenotypic features that constitute a disease. Like the HPO, Mondo provides a hierarchical structure which can be used for classification or “rolling up” diseases to higher level groupings. It provides mappings to other disease resources, but in contrast to other mappings between ontologies, we precisely annotate each mapping using strict semantics, so that we know when two disease names or identifiers are equivalent or one-to-one, in contrast to simply being closely related. For more information, see[https://mondo.monarchinitiative.org/](https://mondo.monarchinitiative.org/) |
| [Montana Driver's License](NamingSystem-MontanaDLN.md) | Montana Motor Vehicle Bureau |
| [Multum Lexicon](NamingSystem-multum.md) | Broadly, the fields and values in the Multum Lexicon and the VantageRx Database are intended to be available for use in any HL7 message that includes a reference to non-veterinary drug products or active ingredients that are either approved for sale by the FDA or readily available in the United States. The following inter-related definitions recently circulated by us to the HL7 Vocabulary Technical Committee explain the scope of what we mean by "drug product" and "active ingredient". (A definition for "drug ingredient" is also provided here because the definition of "active ingredient" is reliant on this term.) Drug Product A drug product is a manufactured or extemporaneously-compounded physiologically-active material intended by the preparer to achieve therapeutic, diagnostic, or preventative effects via biochemical mechanisms when applied to an epithelial surface or placed in an internal body space of a targeted organism. Drug Ingredient A drug ingredient is a chemical compound or biologic agent that occurs in a drug product. Active Ingredient An active ingredient is a drug ingredient that mediates one or more of the intended therapeutic, diagnostic, or preventative effects of a drug product and is present in sufficient quantities to achieve such effects according to the allopathic tradition of healthcare practice. |
| [NAACCR](NamingSystem-naaccrCodes.md) | NAACCR Cancer Registry |
| [NANDA International](NamingSystem-nanda-i.md) | The terminology consists of standardized terms and codes for patient problems or life processes expressed as nursing diagnoses. These data elements would be classified by HL7 as "observations". The taxonomy is multi-axial. It consists of 12 domains and 36 classes. All domains and classes are defined. There are 7 axes with definitions for each. Each nursing diagnosis consists of: a concept label or term expressed as a noun or a noun phrase; a definition of the term; a set of defining characteristics (signs and symptoms) of the diagnostic term; an approved list of modifiers of the term; a set of risk factors with definitions; and a set of related factors (or etiologies) for the term. The system preserves semantics by having robust review procedures and policies to ensure against semantic drift in the meanings of the encoded terms over time. NANDA as an organization is committed to updating the terminology on a regular biannual basis. NANDA has been in existence since 1973 and is thus the oldest developer of standardized language in nursing. Most other nursing language systems use many of the older NANDA terms in their vocabularies. The express purpose of the organization is to develop a comprehensive standardized nursing language that captures the conclusions that nurses make based on observations - in effect, the nursing diagnoses. The work is a continuing effort and diagnoses are revised, retired or added bi-annually. The codes are simple integers and are not linked to each other. If a diagnostic term is retired, the code is also retired. If a new diagnosis is added a new code is given to that term. If a diagnostic term is revised, the code is kept intact but the date of the revision is published alongside the term. Domains and classes are not coded. |
| [NCI Thesaurus](NamingSystem-v3-nciThesaurus.md) | NCI Thesaurus NCI Thesaurus is a biomedical thesaurus created specifically to meet the needs of the cancer research community, especially those engaged in translational research NCI Thesaurus is produced by the NCI Enterprise Vocabulary Services project. The NCI Thesaurus is provided under an open content license. |
| [NCI Version of NDF-RT](NamingSystem-nciVersionOfNDF-RT.md) | The National Drug File RT (NDF-RT) is published by the US Veterans' Administration (VA). NDF-RT covers clinical drugs used at the VA. The NCI version of NDF-RT is used by NCI to provide automated terminology access to the Food and Drug Administration (FDA) Structured Product Label (SPL) initiative. NCI makes its version of NDF-RT available publicly thru the Web, download via FTP and via open APIs for Java, SOAP and HTTP. |
| [NCPDP Brand Generic Indicator](NamingSystem-NCPDPBrandGenericIndicator.md) | Denotes brand or generic drug dispensed. |
| [NCPDP Compound Code](NamingSystem-NCPDPCompoundCode.md) | Code indicating whether or not the prescription is a compound. |
| [NCPDP Dispense As Written (DAW)/Product Selection Code](NamingSystem-NCPDPDispensedAsWrittenOrProductSelectionCode.md) | Code indicating whether or not the prescriber's instructions regarding generic substitution were followed. |
| [NCPDP Pharmacy Type](NamingSystem-NCPDPPharmacyType.md) | Type of pharmacy. |
| [NCPDP Prescription Origin Code](NamingSystem-NCPDPPrescriptionOriginCode.md) | Code indicating the origin of the prescription. Indicates whether the prescription was transmitted as an electronic prescription, by phone, by fax, or as a written paper copy. |
| [NCPDP Provider Identification Number](NamingSystem-NCPDPProviderIdentificationNumber.md) | A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs. |
| [NCPDP Reject Code](NamingSystem-NCPDPRejectCode.md) | Code indicating the error encountered. Contains exception definitions for use when transaction processing cannot be completed. |
| [NHSN BSI Risk Factors](NamingSystem-NHSNBSIRiskFactors.md) | NHSN Blood Stream Infection Risk Factors |
| [NHSN HAI Vocabulary](NamingSystem-NHSNVocabulary.md) | NHSN HAI Vocabulary used for Single Value bindingsto Observation Identifier |
| [NHSN Healthcare Facility Patient Care Location](NamingSystem-hsloc.md) | A classification of patient care locations within healthcare facilities for public health purposes. |
| [NHSN Hip Replacement](NamingSystem-NHSNHipReplacement.md) | NHSN Hip Replacement |
| [NHSN Infection Type](NamingSystem-NHSNInfectionType.md) | NHSN Infection Type |
| [NHSN KneeR eplacement](NamingSystem-NHSNKneeReplacement.md) | NHSN Knee Replacement |
| [NHSN LCBI Pathways](NamingSystem-NHSNLCBIPathways.md) | NHSN Laboratory Confirmed Bloodstream Infection Pathways |
| [NHSN Occasion Of Detection](NamingSystem-NHSNOccasionOfDetection.md) | NHSN Occasion Of Detection |
| [NHSN Procedure Category](NamingSystem-NHSNProcedureCategory.md) | NHSN Procedure Category |
| [NHSN SSI Anatomic Site](NamingSystem-NHSNSSIAnatomicSite.md) | NHSN Surgical Site Infection Anatomic Site |
| [NHSN SSI Location Type](NamingSystem-NHSNSSILocationType.md) | NHSN SSI LocationType |
| [NHSN Spinal Fusion Approach](NamingSystem-NHSNSpinalFusionApproach.md) | NHSN Spinal Fusion Approach |
| [NHSN Spinal Fusion Level](NamingSystem-NHSNSpinalFusionLevel.md) | NHSN Spinal Fusion Level |
| [NHSN Summary Data](NamingSystem-NHSNSummaryData.md) | NHSN Summary Data |
| [NHSN Surveillance System Codes](NamingSystem-CDCNHSN.md) | A set of healthcare surveillance vocabulary concepts and associated identifiers intended solely for data submissions to the National Healthcare Safety Network (NHSN). Other uses are not recommended. The CDCNHSN code system is highly specialized to meet the needs of NHSN surveillance reporting, is undergoing changes, and is not recommended for creating value sets to be used outside of NHSN. |
| [NOC](NamingSystem-noc.md) | NOC - Nursing Outcome Codes |
| [NUCC Health Care Provider Taxonomy](NamingSystem-v3-nuccProviderCodes.md) | The Provider Taxonomy Code List is published (released) twice a year on July 1st and January 1st. The July publication is effective for use on October 1st and the January publication is effective for use on April 1st. The time between the publication release and the effective date is considered an implementation period to allow providers, payers and vendors an opportunity to incorporate any changes into their systems. This listing includes Active codes approved for use effective April 1st, 2003, version 3.0; and codes that are New and approved for use effective October 1st, 2003, version 3.1. It was identified that there is an IP licensure issue with the republishing of the content for this code system by HL7, so the content was removed as of the July 2016 Harmonization cycle release. This external code system content may be accessed from the web page located at http://www.nucc.org/index.php/code-sets-mainmenu-41/provider-taxonomy-mainmenu-40. Multiple formats and means of accessing the content are available from this page. |
| [National Association of Insurance Commissioners (NAIC) Company Codes](NamingSystem-NAICCompanyCodes.md) | NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned by the National Association of Insurance Commissioners (NAIC) to every insurance company to identify them. NAIC maintains a list of all lines of insurance the company sells and a list of all jurisdictions in which the company is licensed. For more information, see[https://content.naic.org/cis_consumer_information.htm](https://content.naic.org/cis_consumer_information.htm) |
| [National Council of State Boards of Nursing (NCSBN) ID](NamingSystem-NCSBNID.md) | Every licensed nurse is assigned an NCSBN ID. This unique number connects all licenses held by a nurse—regardless of license type and across jurisdictions. It supports efficient license management and verification while protecting personal identifiable information (PII), enabling data sharing between systems without compromising privacy. With one number, a nurse can easily access all licensure information in one place. Nursys is the only national database for verification of nurse licensure, discipline and practice privileges for RNs, LPN/VNs and APRNs licensed in participating jurisdictions, including all states in the Nurse Licensure Compact (NLC). For more information, see[https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page](https://www.ncsbn.org/nursing-regulation/licensure/license-verification/ncsbn-id.page). |
| [National Drug Data File](NamingSystem-nddf.md) | National Drug Data File Plus Source Vocabulary 2004. San Bruno, CA: First DataBank, March 11, 2004. This entry was generated to support the Sources in the UMLS. Additional metadata is still missing. |
| [National Drug File Reference Terminology (NDF-RT)](NamingSystem-NDFRT.md) | NDF-RT is a concept-oriented terminology, a collection of concepts, each of which represents a single, unique meaning. Every concept has one fully-specified name and an arbitrary number of other names, all of which are intended to mean the same thing and are therefore synonymous terms. Synonymous terms from external vocabulary sources may have associated unique identifiers. Publication of NDF-RT has ended. The Medication Reference Terminology (MED-RT) is the evolutionary successor to the NDF-RT. |
| [National Uniform Billing Council, UB 92](NamingSystem-nubc-UB92.md) | National Uniform Billing Council, UB 92 |
| [National drug codes](NamingSystem-v3-ndc.md) | National drug codes |
| [Nebraska Driver's License](NamingSystem-NebraskaDLN.md) | Nebraska Motor Vehicle Bureau |
| [Nevada Driver's License](NamingSystem-NevadaDLN.md) | Nevada Motor Vehicle Bureau |
| [New Hampshire Driver's License](NamingSystem-NewHampshireDLN.md) | New Hampshire Motor Vehicle Bureau |
| [New Jersey Driver's License](NamingSystem-NewJerseyDLN.md) | New Jersey Motor Vehicle Bureau |
| [New York Driver's License](NamingSystem-NewYorkDLN.md) | New York Motor Vehicle Bureau |
| [NewMexico Driver's License](NamingSystem-NewMexicoDLN.md) | New Mexico Motor Vehicle Bureau |
| [Nomenclature for Properties and Units (NPU)](NamingSystem-NPU.md) | The NPU terminology is a coding system and terminology for identification and communication of examinations for ordering and reporting results between clinical laboratories and laboratory information systems, hospital patient records, general practitioners (GP) and local and national data repositories. |
| [North American Industry Classification System](NamingSystem-naics.md) | North American Industry Classification System(NAICS) for the United States, a new economic classification system that replaces the 1987 Standard Industrial Classification (SIC) for statistical purposes. NAICS is a system for classifying establishments by type of economic activity. Its purposes are: (1) to facilitate the collection, tabulation, presentation, and analysis of data relating to establishments, and (2) to promote uniformity and comparability in the presentation of statistical data describing the economy. NAICS will be used by Federal statistical agencies that collect or publish data by industry. |
| [North Carolina Driver's License](NamingSystem-NorthCarolinaDLN.md) | North Carolina Motor Vehicle Bureau |
| [North Dakota Driver's License](NamingSystem-NorthDakotaDLN.md) | North Dakota Motor Vehicle Bureau |
| [Nursing Intervention Classification](NamingSystem-nic.md) | The Nursing Interventions Classification (NIC) is a standardized classification developed by a research team at the University of Iowa. The purpose of NIC is to define interventions that nurses do on behalf of patients in all care domains. An intervention is defined as 'any treatment, based upon clinical judgment and knowledge, a nurse performs to enhance patient/client outcomes.' NIC is updated a five-year cycle. |
| [Nursing Management Minimum Data Set](NamingSystem-nmmds.md) | The NMMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. The NMMDS is composed of seventeen (17) data elements organized into three categories: environment, nurse resources, and financial resources. See Tables 1-3 for the elements and related definitions organized by each categories. The NMMDS most appropriately focuses at the first level of accountability for patient/client/family/community nursing care: this may be the delivery unit, service, or center of excellence level. The NMMDS supports numerous constructed variables as well as aggregation of data at the unit, institution, network, and system, etc levels. This minimum data set provides the structure for the collection of uniform information that influences quality of patient care, directly and indirectly. |
| [Nursing Minimum Data Set](NamingSystem-nmds.md) | The NMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. |
| [OHDSI Standardized Vocabularies](NamingSystem-OMOP.md) | Standardized Vocabularies are an integral part of the OMOP CDM. The Standardized Vocabularies contain all of the code sets, terminologies, vocabularies, nomenclatures, lexicons, thesauri, ontologies, taxonomies, classifications, abstractions, and other such data that are needed for:* Generation of the transformed (i.e., standardized) data from the raw source dataset into the OMOP CDM, 
* Searching, querying and extraction of the transformed data, and browsing and navigating the hierarchies of classes and abstractions inherent in the transformed data, and 
* Interpreting the meanings of the data. This asset is available for free to anyone and can be [downloaded](https://athena.ohdsi.org/vocabulary/list) from the Atena download page in a delimited file format. To manage the change of content, but to allow users to use and refer to a defined set of vocabularies, the whole resource is issued in releases. Major changes to the OMOP Vocabulary is released twice yearly in February and August. Instead of a major / minor version scheme, the releases of the Standardized Vocabularies component of the OMOP Vocabulary are tagged with the release date. Version label is based on the version of the CDM its aligned-to, plus a suffix appended incremented based on release date, for example: “v5.0 31-MAY-23.” At this time prior versions of the OMOP Vocabulary are not publicly available. Each release is accompanied by a [standard release note](https://github.com/OHDSI/Vocabulary-v5.0/releases), containing information about: 
* Domain changes 
* Newly added concepts grouped by vocabulary_id and domain 
* Standard concept changes 
* Newly added concepts and their standard concept status 
* Changes of concept mapping status grouped by target domain Additional details about the OMOP Vocabulary release notes can be found [here](https://github.com/OHDSI/Vocabulary-v5.0/wiki/Releases)
 |
| [OMAHA Tangram Medical Terminology](NamingSystem-TangramMedicalTerminology.md) | OMAHA Tangram Medical Terminology is an ontology-based medical terminological resource developed by Chinese language. It helps to standardize the expression of Chinese medical terms, and improve the semantic interoperability between different systems. The terminology can be used in electronic health records, decision support systems and digital health researches, providing the functions of mapping, data capture, data mining, data registries, statistical analysis and reasoning etc. Tangram Medical Terminology is released quarterly using the file name format as Tangram_Medical_Terminology _YYYYMMDD (Example: Tangram _Medical_Terminology _20200120). For more information, please visit http://wiki.omaha.org.cn/pages/viewpage.action?pageId=31425763 For more information, see https://term.omaha.org.cn/. |
| [Occupation CDC Census 2010](NamingSystem-PHOccupationCDCCensus2010.md) | 2010 Occupation coding system used by CDC (NIOSH and NCHS) for coding occupation text. Occupation describes a set of activities or tasks that individuals are paid to perform or, if unpaid, define a person's contribution to a household/family business/community. |
| [Occupational Data for Health (ODH)](NamingSystem-PHOccupationalDataForHealthODH.md) | The concepts representing the values supporting Occupational Data for Health, including Job Supervisory Level or Pay Grade (ODH) code system consists of data elements that describe a person's work information, structured to facilitate individual, population, and public health use; not intended to support billing.). |
| [Ohio Driver's License](NamingSystem-OhioDLN.md) | Ohio Motor Vehicle Bureau |
| [Oklahoma Driver's License](NamingSystem-OklahomaDLN.md) | Oklahoma Motor Vehicle Bureau |
| [Omaha System](NamingSystem-oms.md) | The Omaha System provides standardized terms, definitions, and codes for observations and procedures, specifically for client problems, multidisciplinary interventions including those focusing on assessment and care, and problem-specific client outcomes. |
| [Online Product Identification Number Index of Nova Scotia](NamingSystem-opinions.md) | **Description:**Codes to identify products and services that do not have DIN's and which need to be billed. http://www.atlanticpharmaceutical.ca/default.asp?mn=5.23 |
| [Open Eligibility Taxonomy](NamingSystem-OpenEligibilityTaxonomy.md) | "The Open Eligibility Project is a collaborative for a series of standards for the human services sector. The Open Eligibility taxonomy is a simple way to categorize human services and human situations. With these common categories, we, as service providers, navigators, and people in need, can find human services quickly and easily." "The Open Eligibility taxonomy consists of two important concepts: Human Services and Human Situations. Human Services are services offered by government or charitable organizations, and include things such as housing, food pantries or counseling services. Human Situations are ways of describing attributes of a person that could help them find programs they are looking for, including examples like: veterans, physical disability or seniors." For more information, see[https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project](https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project) |
| [Oregon Driver's License](NamingSystem-OregonDLN.md) | Oregon Motor Vehicle Bureau |
| [PMIX Method of Payment](NamingSystem-PMIXMethodofPayment.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Method of Payment: The PMIX equivalent to the DSP16 field of the ASAP format which identifies the primary method of payment for the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges. |
| [PMIX Opioid Treatment Code](NamingSystem-PMIXOpioidTreatmentCode.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Opioid Treatment Code: The PMIX equivalent to the DSP24 field of the ASAP format which identifies whether or not the prescription is for the purpose of treating Opioid Use Disorder, and if so, the type of treatment. For use in PDMP (Prescription Drug Monitoring Program) data exchanges. |
| [PMIX Patient Alert Category Code](NamingSystem-PMIXPatientAlertCatCode.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Patient Alert Category Code: In the event that the PDMP (Prescription Drug Monitoring Program) utilizes an “alert” functionality – a functionality that alerts an end user to some known or detected activity or condition regarding the requested patient – the alert category code indicates what type of alert was detected and is being sent by the PDMP. |
| [PMIX Species Type Code](NamingSystem-PMIXSpeciesTypeCode.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Species Type Code: The PMIX equivalent to the PAT20 field of the ASAP format which identifies whether the patient is a human patient or a veterinary patient, for use in PDMP (Prescription Drug Monitoring Program) data exchanges. |
| [PMIX Status Code](NamingSystem-PMIXStatusCode.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Status Code: A code that indicates the status of the request to the PDMP (Prescription Drug Monitoring Program). |
| [PMIX Transmission Form Of Rx Origin Code Type](NamingSystem-PMIXTransmissionFormRxOriginCodeType.md) | This code system is part of the PMIX National Architecture. The Prescription Monitoring Information eXchange (PMIX) Standards Organization is the sole body responsible for developing, updating and maintaining all aspects of the PMIX National Architecture and any related standards, documentation and/or guidance documents. The PMIX Standards Organization is made up of State Prescription Drug Monitoring Programs, Prescription Drug Monitoring Program Vendors, Third-Party Intermediaries and Federal Agencies. The appropriate contacts for PMIX are the Chair and Vice Chair of the PMIX Executive Committee. Chair:[Chad Garner](mailto:chad.garner@pharmacy.ohio.gov)Vice Chair:[Chelsea Townsend](mailto:townseca@dhec.sc.gov)Transmission Form Of Rx Origin Code Type: The PMIX equivalent to the DSP12 field of the ASAP format which identifies by which method the pharmacy received the prescription, for use in PDMP (Prescription Drug Monitoring Program) data exchanges. |
| [POS Codes](NamingSystem-POS.md) | POS Codes |
| [Passport Numbers Namespace for AFGHANISTAN](NamingSystem-passportNumNS-AFG.md) | Identifier of the namespace for Passport Numbers issued by the country of AFGHANISTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ALAND ISLANDS](NamingSystem-passportNumNS-ALA.md) | Identifier of the namespace for Passport Numbers issued by the country of ALAND ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ALBANIA](NamingSystem-passportNumNS-ALB.md) | Identifier of the namespace for Passport Numbers issued by the country of ALBANIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ALGERIA](NamingSystem-passportNumNS-DZA.md) | Identifier of the namespace for Passport Numbers issued by the country of ALGERIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for AMERICAN SAMOA](NamingSystem-passportNumNS-ASM.md) | Identifier of the namespace for Passport Numbers issued by the country of AMERICAN SAMOA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ANDORRA](NamingSystem-passportNumNS-AND.md) | Identifier of the namespace for Passport Numbers issued by the country of ANDORRA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ANGOLA](NamingSystem-passportNumNS-AGO.md) | Identifier of the namespace for Passport Numbers issued by the country of ANGOLA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ANGUILLA](NamingSystem-passportNumNS-AIA.md) | Identifier of the namespace for Passport Numbers issued by the country of ANGUILLA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ANTARCTICA](NamingSystem-passportNumNS-ATA.md) | Identifier of the namespace for Passport Numbers issued by the country of ANTARCTICA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ANTIGUA AND BARBUDA](NamingSystem-passportNumNS-ATG.md) | Identifier of the namespace for Passport Numbers issued by the country of ANTIGUA AND BARBUDA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ARGENTINA](NamingSystem-passportNumNS-ARG.md) | Identifier of the namespace for Passport Numbers issued by the country of ARGENTINA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ARMENIA](NamingSystem-passportNumNS-ARM.md) | Identifier of the namespace for Passport Numbers issued by the country of ARMENIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ARUBA](NamingSystem-passportNumNS-ABW.md) | Identifier of the namespace for Passport Numbers issued by the country of ARUBA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for AUSTRALIA](NamingSystem-passportNumNS-AUS.md) | Identifier of the namespace for Passport Numbers issued by the country of AUSTRALIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for AUSTRIA](NamingSystem-passportNumNS-AUT.md) | Identifier of the namespace for Passport Numbers issued by the country of AUSTRIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for AZERBAIJAN](NamingSystem-passportNumNS-AZE.md) | Identifier of the namespace for Passport Numbers issued by the country of AZERBAIJAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BAHAMAS](NamingSystem-passportNumNS-BHS.md) | Identifier of the namespace for Passport Numbers issued by the country of BAHAMAS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BAHRAIN](NamingSystem-passportNumNS-BHR.md) | Identifier of the namespace for Passport Numbers issued by the country of BAHRAIN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BANGLADESH](NamingSystem-passportNumNS-BGD.md) | Identifier of the namespace for Passport Numbers issued by the country of BANGLADESH. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BARBADOS](NamingSystem-passportNumNS-BRB.md) | Identifier of the namespace for Passport Numbers issued by the country of BARBADOS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BELARUS](NamingSystem-passportNumNS-BLR.md) | Identifier of the namespace for Passport Numbers issued by the country of BELARUS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BELGIUM](NamingSystem-passportNumNS-BEL.md) | Identifier of the namespace for Passport Numbers issued by the country of BELGIUM. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BELIZE](NamingSystem-passportNumNS-BLZ.md) | Identifier of the namespace for Passport Numbers issued by the country of BELIZE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BENIN](NamingSystem-passportNumNS-BEN.md) | Identifier of the namespace for Passport Numbers issued by the country of BENIN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BERMUDA](NamingSystem-passportNumNS-BMU.md) | Identifier of the namespace for Passport Numbers issued by the country of BERMUDA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BHUTAN](NamingSystem-passportNumNS-BTN.md) | Identifier of the namespace for Passport Numbers issued by the country of BHUTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BOLIVIA](NamingSystem-passportNumNS-BOL.md) | Identifier of the namespace for Passport Numbers issued by the country of BOLIVIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BOSNIA AND HERZEGOVINA](NamingSystem-passportNumNS-BIH.md) | Identifier of the namespace for Passport Numbers issued by the country of BOSNIA AND HERZEGOVINA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BOTSWANA](NamingSystem-passportNumNS-BWA.md) | Identifier of the namespace for Passport Numbers issued by the country of BOTSWANA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BOUVET ISLAND](NamingSystem-passportNumNS-BVT.md) | Identifier of the namespace for Passport Numbers issued by the country of BOUVET ISLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BRAZIL](NamingSystem-passportNumNS-BRA.md) | Identifier of the namespace for Passport Numbers issued by the country of BRAZIL. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BRITISH INDIAN OCEAN TERRITORY](NamingSystem-passportNumNS-IOT.md) | Identifier of the namespace for Passport Numbers issued by the country of BRITISH INDIAN OCEAN TERRITORY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BRUNEI DARUSSALAM](NamingSystem-passportNumNS-BRN.md) | Identifier of the namespace for Passport Numbers issued by the country of BRUNEI DARUSSALAM. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BULGARIA](NamingSystem-passportNumNS-BGR.md) | Identifier of the namespace for Passport Numbers issued by the country of BULGARIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BURKINA FASO](NamingSystem-passportNumNS-BFA.md) | Identifier of the namespace for Passport Numbers issued by the country of BURKINA FASO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for BURUNDI](NamingSystem-passportNumNS-BDI.md) | Identifier of the namespace for Passport Numbers issued by the country of BURUNDI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CAMBODIA](NamingSystem-passportNumNS-KHM.md) | Identifier of the namespace for Passport Numbers issued by the country of CAMBODIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CAMEROON](NamingSystem-passportNumNS-CMR.md) | Identifier of the namespace for Passport Numbers issued by the country of CAMEROON. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CANADA](NamingSystem-passportNumNS-CAN.md) | Identifier of the namespace for Passport Numbers issued by the country of CANADA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CAPE VERDE](NamingSystem-passportNumNS-CPV.md) | Identifier of the namespace for Passport Numbers issued by the country of CAPE VERDE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CAYMAN ISLANDS](NamingSystem-passportNumNS-CYM.md) | Identifier of the namespace for Passport Numbers issued by the country of CAYMAN ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CENTRAL AFRICAN REPUBLIC](NamingSystem-passportNumNS-CAF.md) | Identifier of the namespace for Passport Numbers issued by the country of CENTRAL AFRICAN REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CHAD](NamingSystem-passportNumNS-TCD.md) | Identifier of the namespace for Passport Numbers issued by the country of CHAD. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CHILE](NamingSystem-passportNumNS-CHL.md) | Identifier of the namespace for Passport Numbers issued by the country of CHILE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CHINA](NamingSystem-passportNumNS-CHN.md) | Identifier of the namespace for Passport Numbers issued by the country of CHINA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CHRISTMAS ISLAND](NamingSystem-passportNumNS-CXR.md) | Identifier of the namespace for Passport Numbers issued by the country of CHRISTMAS ISLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COCOS (KEELING) ISLANDS](NamingSystem-passportNumNS-CCK.md) | Identifier of the namespace for Passport Numbers issued by the country of COCOS (KEELING) ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COLOMBIA](NamingSystem-passportNumNS-COL.md) | Identifier of the namespace for Passport Numbers issued by the country of COLOMBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COMOROS](NamingSystem-passportNumNS-COM.md) | Identifier of the namespace for Passport Numbers issued by the country of COMOROS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CONGO](NamingSystem-passportNumNS-COG.md) | Identifier of the namespace for Passport Numbers issued by the country of CONGO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CONGO, THE DEMOCRATIC REPUBLIC OF THE](NamingSystem-passportNumNS-COD.md) | Identifier of the namespace for Passport Numbers issued by the country of CONGO, THE DEMOCRATIC REPUBLIC OF THE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COOK ISLANDS](NamingSystem-passportNumNS-COK.md) | Identifier of the namespace for Passport Numbers issued by the country of COOK ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COSTA RICA](NamingSystem-passportNumNS-CRI.md) | Identifier of the namespace for Passport Numbers issued by the country of COSTA RICA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for COTE D'IVOIRE](NamingSystem-passportNumNS-CIV.md) | Identifier of the namespace for Passport Numbers issued by the country of COTE D'IVOIRE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CROATIA](NamingSystem-passportNumNS-HRV.md) | Identifier of the namespace for Passport Numbers issued by the country of CROATIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CUBA](NamingSystem-passportNumNS-CUB.md) | Identifier of the namespace for Passport Numbers issued by the country of CUBA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CYPRUS](NamingSystem-passportNumNS-CYP.md) | Identifier of the namespace for Passport Numbers issued by the country of CYPRUS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for CZECH REPUBLIC](NamingSystem-passportNumNS-CZE.md) | Identifier of the namespace for Passport Numbers issued by the country of CZECH REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for DENMARK](NamingSystem-passportNumNS-DNK.md) | Identifier of the namespace for Passport Numbers issued by the country of DENMARK. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for DJIBOUTI](NamingSystem-passportNumNS-DJI.md) | Identifier of the namespace for Passport Numbers issued by the country of DJIBOUTI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for DOMINICA](NamingSystem-passportNumNS-DMA.md) | Identifier of the namespace for Passport Numbers issued by the country of DOMINICA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for DOMINICAN REPUBLIC](NamingSystem-passportNumNS-DOM.md) | Identifier of the namespace for Passport Numbers issued by the country of DOMINICAN REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ECUADOR](NamingSystem-passportNumNS-ECU.md) | Identifier of the namespace for Passport Numbers issued by the country of ECUADOR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for EGYPT](NamingSystem-passportNumNS-EGY.md) | Identifier of the namespace for Passport Numbers issued by the country of EGYPT. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for EL SALVADOR](NamingSystem-passportNumNS-SLV.md) | Identifier of the namespace for Passport Numbers issued by the country of EL SALVADOR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for EQUATORIAL GUINEA](NamingSystem-passportNumNS-GNQ.md) | Identifier of the namespace for Passport Numbers issued by the country of EQUATORIAL GUINEA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ERITREA](NamingSystem-passportNumNS-ERI.md) | Identifier of the namespace for Passport Numbers issued by the country of ERITREA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ESTONIA](NamingSystem-passportNumNS-EST.md) | Identifier of the namespace for Passport Numbers issued by the country of ESTONIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ETHIOPIA](NamingSystem-passportNumNS-ETH.md) | Identifier of the namespace for Passport Numbers issued by the country of ETHIOPIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FALKLAND ISLANDS (MALVINAS)](NamingSystem-passportNumNS-FLK.md) | Identifier of the namespace for Passport Numbers issued by the country of FALKLAND ISLANDS (MALVINAS). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FAROE ISLANDS](NamingSystem-passportNumNS-FRO.md) | Identifier of the namespace for Passport Numbers issued by the country of FAROE ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FIJI](NamingSystem-passportNumNS-FJI.md) | Identifier of the namespace for Passport Numbers issued by the country of FIJI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FINLAND](NamingSystem-passportNumNS-FIN.md) | Identifier of the namespace for Passport Numbers issued by the country of FINLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FRANCE](NamingSystem-passportNumNS-FRA.md) | Identifier of the namespace for Passport Numbers issued by the country of FRANCE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FRENCH GUIANA](NamingSystem-passportNumNS-GUF.md) | Identifier of the namespace for Passport Numbers issued by the country of FRENCH GUIANA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FRENCH POLYNESIA](NamingSystem-passportNumNS-PYF.md) | Identifier of the namespace for Passport Numbers issued by the country of FRENCH POLYNESIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for FRENCH SOUTHERN TERRITORIES](NamingSystem-passportNumNS-ATF.md) | Identifier of the namespace for Passport Numbers issued by the country of FRENCH SOUTHERN TERRITORIES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GABON](NamingSystem-passportNumNS-GAB.md) | Identifier of the namespace for Passport Numbers issued by the country of GABON. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GAMBIA](NamingSystem-passportNumNS-GMB.md) | Identifier of the namespace for Passport Numbers issued by the country of GAMBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GEORGIA](NamingSystem-passportNumNS-GEO.md) | Identifier of the namespace for Passport Numbers issued by the country of GEORGIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GERMANY](NamingSystem-passportNumNS-DEU.md) | Identifier of the namespace for Passport Numbers issued by the country of GERMANY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GHANA](NamingSystem-passportNumNS-GHA.md) | Identifier of the namespace for Passport Numbers issued by the country of GHANA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GIBRALTAR](NamingSystem-passportNumNS-GIB.md) | Identifier of the namespace for Passport Numbers issued by the country of GIBRALTAR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GREECE](NamingSystem-passportNumNS-GRC.md) | Identifier of the namespace for Passport Numbers issued by the country of GREECE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GREENLAND](NamingSystem-passportNumNS-GRL.md) | Identifier of the namespace for Passport Numbers issued by the country of GREENLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GRENADA](NamingSystem-passportNumNS-GRD.md) | Identifier of the namespace for Passport Numbers issued by the country of GRENADA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUADELOUPE](NamingSystem-passportNumNS-GLP.md) | Identifier of the namespace for Passport Numbers issued by the country of GUADELOUPE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUAM](NamingSystem-passportNumNS-GUM.md) | Identifier of the namespace for Passport Numbers issued by the country of GUAM. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUATEMALA](NamingSystem-passportNumNS-GTM.md) | Identifier of the namespace for Passport Numbers issued by the country of GUATEMALA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUERNSEY](NamingSystem-passportNumNS-GGY.md) | Identifier of the namespace for Passport Numbers issued by the country of GUERNSEY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUINEA](NamingSystem-passportNumNS-GIN.md) | Identifier of the namespace for Passport Numbers issued by the country of GUINEA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUINEA-BISSAU](NamingSystem-passportNumNS-GNB.md) | Identifier of the namespace for Passport Numbers issued by the country of GUINEA-BISSAU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for GUYANA](NamingSystem-passportNumNS-GUY.md) | Identifier of the namespace for Passport Numbers issued by the country of GUYANA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HAITI](NamingSystem-passportNumNS-HTI.md) | Identifier of the namespace for Passport Numbers issued by the country of HAITI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HEARD ISLAND AND MCDONALD ISLANDS](NamingSystem-passportNumNS-HMD.md) | Identifier of the namespace for Passport Numbers issued by the country of HEARD ISLAND AND MCDONALD ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HOLY SEE (VATICAN CITY STATE)](NamingSystem-passportNumNS-VAT.md) | Identifier of the namespace for Passport Numbers issued by the country of HOLY SEE (VATICAN CITY STATE). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HONDURAS](NamingSystem-passportNumNS-HND.md) | Identifier of the namespace for Passport Numbers issued by the country of HONDURAS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HONG KONG](NamingSystem-passportNumNS-HKG.md) | Identifier of the namespace for Passport Numbers issued by the country of HONG KONG. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for HUNGARY](NamingSystem-passportNumNS-HUN.md) | Identifier of the namespace for Passport Numbers issued by the country of HUNGARY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ICELAND](NamingSystem-passportNumNS-ISL.md) | Identifier of the namespace for Passport Numbers issued by the country of ICELAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for INDIA](NamingSystem-passportNumNS-IND.md) | Identifier of the namespace for Passport Numbers issued by the country of INDIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for INDONESIA](NamingSystem-passportNumNS-IDN.md) | Identifier of the namespace for Passport Numbers issued by the country of INDONESIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for IRAN (ISLAMIC REPUBLIC OF)](NamingSystem-passportNumNS-IRN.md) | Identifier of the namespace for Passport Numbers issued by the country of IRAN (ISLAMIC REPUBLIC OF). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for IRAQ](NamingSystem-passportNumNS-IRQ.md) | Identifier of the namespace for Passport Numbers issued by the country of IRAQ. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for IRELAND](NamingSystem-passportNumNS-IRL.md) | Identifier of the namespace for Passport Numbers issued by the country of IRELAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ISLE OF MAN](NamingSystem-passportNumNS-IMM.md) | Identifier of the namespace for Passport Numbers issued by the country of ISLE OF MAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ISRAEL](NamingSystem-passportNumNS-ISR.md) | Identifier of the namespace for Passport Numbers issued by the country of ISRAEL. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ITALY](NamingSystem-passportNumNS-ITA.md) | Identifier of the namespace for Passport Numbers issued by the country of ITALY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for JAMAICA](NamingSystem-passportNumNS-JAM.md) | Identifier of the namespace for Passport Numbers issued by the country of JAMAICA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for JAPAN](NamingSystem-passportNumNS-JPN.md) | Identifier of the namespace for Passport Numbers issued by the country of JAPAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for JERSEY](NamingSystem-passportNumNS-JEY.md) | Identifier of the namespace for Passport Numbers issued by the country of JERSEY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for JORDAN](NamingSystem-passportNumNS-JOR.md) | Identifier of the namespace for Passport Numbers issued by the country of JORDAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KAZAKHSTAN](NamingSystem-passportNumNS-KAZ.md) | Identifier of the namespace for Passport Numbers issued by the country of KAZAKHSTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KENYA](NamingSystem-passportNumNS-KEN.md) | Identifier of the namespace for Passport Numbers issued by the country of KENYA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KIRIBATI](NamingSystem-passportNumNS-KIR.md) | Identifier of the namespace for Passport Numbers issued by the country of KIRIBATI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF](NamingSystem-passportNumNS-PRK.md) | Identifier of the namespace for Passport Numbers issued by the country of KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KOREA, REPUBLIC OF](NamingSystem-passportNumNS-KOR.md) | Identifier of the namespace for Passport Numbers issued by the country of KOREA, REPUBLIC OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KUWAIT](NamingSystem-passportNumNS-KWT.md) | Identifier of the namespace for Passport Numbers issued by the country of KUWAIT. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for KYRGYZSTAN](NamingSystem-passportNumNS-KGZ.md) | Identifier of the namespace for Passport Numbers issued by the country of KYRGYZSTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LAO PEOPLE'S DEMOCRATIC REPUBLIC](NamingSystem-passportNumNS-LAO.md) | Identifier of the namespace for Passport Numbers issued by the country of LAO PEOPLE'S DEMOCRATIC REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LATVIA](NamingSystem-passportNumNS-LVA.md) | Identifier of the namespace for Passport Numbers issued by the country of LATVIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LEBANON](NamingSystem-passportNumNS-LBN.md) | Identifier of the namespace for Passport Numbers issued by the country of LEBANON. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LESOTHO](NamingSystem-passportNumNS-LSO.md) | Identifier of the namespace for Passport Numbers issued by the country of LESOTHO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LIBERIA](NamingSystem-passportNumNS-LBR.md) | Identifier of the namespace for Passport Numbers issued by the country of LIBERIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LIBYAN ARAB JAMAHIRIYA](NamingSystem-passportNumNS-LBY.md) | Identifier of the namespace for Passport Numbers issued by the country of LIBYAN ARAB JAMAHIRIYA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LIECHTENSTEIN](NamingSystem-passportNumNS-LIE.md) | Identifier of the namespace for Passport Numbers issued by the country of LIECHTENSTEIN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LITHUANIA](NamingSystem-passportNumNS-LTU.md) | Identifier of the namespace for Passport Numbers issued by the country of LITHUANIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for LUXEMBOURG](NamingSystem-passportNumNS-LUX.md) | Identifier of the namespace for Passport Numbers issued by the country of LUXEMBOURG. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MACAO](NamingSystem-passportNumNS-MAC.md) | Identifier of the namespace for Passport Numbers issued by the country of MACAO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF](NamingSystem-passportNumNS-MKD.md) | Identifier of the namespace for Passport Numbers issued by the country of MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MADAGASCAR](NamingSystem-passportNumNS-MDG.md) | Identifier of the namespace for Passport Numbers issued by the country of MADAGASCAR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MALAWI](NamingSystem-passportNumNS-MWI.md) | Identifier of the namespace for Passport Numbers issued by the country of MALAWI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MALAYSIA](NamingSystem-passportNumNS-MYS.md) | Identifier of the namespace for Passport Numbers issued by the country of MALAYSIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MALDIVES](NamingSystem-passportNumNS-MDV.md) | Identifier of the namespace for Passport Numbers issued by the country of MALDIVES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MALI](NamingSystem-passportNumNS-MLI.md) | Identifier of the namespace for Passport Numbers issued by the country of MALI. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MALTA](NamingSystem-passportNumNS-MLT.md) | Identifier of the namespace for Passport Numbers issued by the country of MALTA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MARSHALL ISLANDS](NamingSystem-passportNumNS-MHL.md) | Identifier of the namespace for Passport Numbers issued by the country of MARSHALL ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MARTINIQUE](NamingSystem-passportNumNS-MTQ.md) | Identifier of the namespace for Passport Numbers issued by the country of MARTINIQUE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MAURITANIA](NamingSystem-passportNumNS-MRT.md) | Identifier of the namespace for Passport Numbers issued by the country of MAURITANIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MAURITIUS](NamingSystem-passportNumNS-MUS.md) | Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MAYOTTE](NamingSystem-passportNumNS-MYT.md) | Identifier of the namespace for Passport Numbers issued by the country of MAYOTTE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MEXICO](NamingSystem-passportNumNS-MEX.md) | Identifier of the namespace for Passport Numbers issued by the country of MEXICO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MICRONESIA, FEDERATED STATES OF](NamingSystem-passportNumNS-FSM.md) | Identifier of the namespace for Passport Numbers issued by the country of MICRONESIA, FEDERATED STATES OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MOLDOVA, REPUBLIC OF](NamingSystem-passportNumNS-MDA.md) | Identifier of the namespace for Passport Numbers issued by the country of MOLDOVA, REPUBLIC OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MONACO](NamingSystem-passportNumNS-MCO.md) | Identifier of the namespace for Passport Numbers issued by the country of MONACO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MONGOLIA](NamingSystem-passportNumNS-MNG.md) | Identifier of the namespace for Passport Numbers issued by the country of MONGOLIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MONTENEGRO](NamingSystem-passportNumNS-MNE.md) | Identifier of the namespace for Passport Numbers issued by the country of MONTENEGRO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MONTSERRAT](NamingSystem-passportNumNS-MSR.md) | Identifier of the namespace for Passport Numbers issued by the country of MONTSERRAT. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MOROCCO](NamingSystem-passportNumNS-MAR.md) | Identifier of the namespace for Passport Numbers issued by the country of MOROCCO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MOZAMBIQUE](NamingSystem-passportNumNS-MOZ.md) | Identifier of the namespace for Passport Numbers issued by the country of MOZAMBIQUE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for MYANMAR](NamingSystem-passportNumNS-MMR.md) | Identifier of the namespace for Passport Numbers issued by the country of MYANMAR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NAMIBIA](NamingSystem-passportNumNS-NAM.md) | Identifier of the namespace for Passport Numbers issued by the country of NAMIBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NAURU](NamingSystem-passportNumNS-NRU.md) | Identifier of the namespace for Passport Numbers issued by the country of NAURU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NEPAL](NamingSystem-passportNumNS-NPL.md) | Identifier of the namespace for Passport Numbers issued by the country of NEPAL. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NETHERLANDS](NamingSystem-passportNumNS-NLD.md) | Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NETHERLANDS ANTILLES](NamingSystem-passportNumNS-ANT.md) | Identifier of the namespace for Passport Numbers issued by the country of NETHERLANDS ANTILLES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NEW CALEDONIA](NamingSystem-passportNumNS-NCL.md) | Identifier of the namespace for Passport Numbers issued by the country of NEW CALEDONIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NEW ZEALAND](NamingSystem-passportNumNS-NZL.md) | Identifier of the namespace for Passport Numbers issued by the country of NEW ZEALAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NICARAGUA](NamingSystem-passportNumNS-NIC.md) | Identifier of the namespace for Passport Numbers issued by the country of NICARAGUA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NIGER](NamingSystem-passportNumNS-NER.md) | Identifier of the namespace for Passport Numbers issued by the country of NIGER. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NIGERIA](NamingSystem-passportNumNS-NGA.md) | Identifier of the namespace for Passport Numbers issued by the country of NIGERIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NIUE](NamingSystem-passportNumNS-NIU.md) | Identifier of the namespace for Passport Numbers issued by the country of NIUE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NORFOLK ISLAND](NamingSystem-passportNumNS-NFK.md) | Identifier of the namespace for Passport Numbers issued by the country of NORFOLK ISLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NORTHERN MARIANA ISLANDS](NamingSystem-passportNumNS-MNP.md) | Identifier of the namespace for Passport Numbers issued by the country of NORTHERN MARIANA ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for NORWAY](NamingSystem-passportNumNS-NOR.md) | Identifier of the namespace for Passport Numbers issued by the country of NORWAY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for OMAN](NamingSystem-passportNumNS-OMN.md) | Identifier of the namespace for Passport Numbers issued by the country of OMAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PAKISTAN](NamingSystem-passportNumNS-PAK.md) | Identifier of the namespace for Passport Numbers issued by the country of PAKISTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PALAU](NamingSystem-passportNumNS-PLW.md) | Identifier of the namespace for Passport Numbers issued by the country of PALAU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PALESTINIAN TERRITORY, OCCUPIED](NamingSystem-passportNumNS-PSE.md) | Identifier of the namespace for Passport Numbers issued by the country of PALESTINIAN TERRITORY, OCCUPIED. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PANAMA](NamingSystem-passportNumNS-PAN.md) | Identifier of the namespace for Passport Numbers issued by the country of PANAMA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PAPUA NEW GUINEA](NamingSystem-passportNumNS-PNG.md) | Identifier of the namespace for Passport Numbers issued by the country of PAPUA NEW GUINEA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PARAGUAY](NamingSystem-passportNumNS-PRY.md) | Identifier of the namespace for Passport Numbers issued by the country of PARAGUAY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PERU](NamingSystem-passportNumNS-PER.md) | Identifier of the namespace for Passport Numbers issued by the country of PERU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PHILIPPINES](NamingSystem-passportNumNS-PHL.md) | Identifier of the namespace for Passport Numbers issued by the country of PHILIPPINES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PITCAIRN](NamingSystem-passportNumNS-PCN.md) | Identifier of the namespace for Passport Numbers issued by the country of PITCAIRN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for POLAND](NamingSystem-passportNumNS-POL.md) | Identifier of the namespace for Passport Numbers issued by the country of POLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PORTUGAL](NamingSystem-passportNumNS-PRT.md) | Identifier of the namespace for Passport Numbers issued by the country of PORTUGAL. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for PUERTO RICO](NamingSystem-passportNumNS-PRI.md) | Identifier of the namespace for Passport Numbers issued by the country of PUERTO RICO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for QATAR](NamingSystem-passportNumNS-QAT.md) | Identifier of the namespace for Passport Numbers issued by the country of QATAR. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for REUNION](NamingSystem-passportNumNS-REU.md) | Identifier of the namespace for Passport Numbers issued by the country of REUNION. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ROMANIA](NamingSystem-passportNumNS-ROU.md) | Identifier of the namespace for Passport Numbers issued by the country of ROMANIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for RUSSIAN FEDERATION](NamingSystem-passportNumNS-RUS.md) | Identifier of the namespace for Passport Numbers issued by the country of RUSSIAN FEDERATION. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for RWANDA](NamingSystem-passportNumNS-RWA.md) | Identifier of the namespace for Passport Numbers issued by the country of RWANDA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT BARTHELEMY](NamingSystem-passportNumNS-BLM.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT BARTHELEMY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT HELENA](NamingSystem-passportNumNS-SHN.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT HELENA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT KITTS AND NEVIS](NamingSystem-passportNumNS-KNA.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT KITTS AND NEVIS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT LUCIA](NamingSystem-passportNumNS-LCA.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT LUCIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT MARTIN (FRENCH PART)](NamingSystem-passportNumNS-MAF.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT MARTIN (FRENCH PART). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT PIERRE AND MIQUELON](NamingSystem-passportNumNS-SPM.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT PIERRE AND MIQUELON. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAINT VINCENT AND THE GRENADINES](NamingSystem-passportNumNS-VCT.md) | Identifier of the namespace for Passport Numbers issued by the country of SAINT VINCENT AND THE GRENADINES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAMOA](NamingSystem-passportNumNS-WSM.md) | Identifier of the namespace for Passport Numbers issued by the country of SAMOA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAN MARINO](NamingSystem-passportNumNS-SMR.md) | Identifier of the namespace for Passport Numbers issued by the country of SAN MARINO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAO TOME AND PRINCIPE](NamingSystem-passportNumNS-STP.md) | Identifier of the namespace for Passport Numbers issued by the country of SAO TOME AND PRINCIPE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SAUDI ARABIA](NamingSystem-passportNumNS-SAU.md) | Identifier of the namespace for Passport Numbers issued by the country of SAUDI ARABIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SENEGAL](NamingSystem-passportNumNS-SEN.md) | Identifier of the namespace for Passport Numbers issued by the country of SENEGAL. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SERBIA](NamingSystem-passportNumNS-SRB.md) | Identifier of the namespace for Passport Numbers issued by the country of SERBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SEYCHELLES](NamingSystem-passportNumNS-SYC.md) | Identifier of the namespace for Passport Numbers issued by the country of SEYCHELLES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SIERRA LEONE](NamingSystem-passportNumNS-SLE.md) | Identifier of the namespace for Passport Numbers issued by the country of SIERRA LEONE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SINGAPORE](NamingSystem-passportNumNS-SGP.md) | Identifier of the namespace for Passport Numbers issued by the country of SINGAPORE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SLOVAKIA](NamingSystem-passportNumNS-SVK.md) | Identifier of the namespace for Passport Numbers issued by the country of SLOVAKIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SLOVENIA](NamingSystem-passportNumNS-SVN.md) | Identifier of the namespace for Passport Numbers issued by the country of SLOVENIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SOLOMON ISLANDS](NamingSystem-passportNumNS-SLB.md) | Identifier of the namespace for Passport Numbers issued by the country of SOLOMON ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SOMALIA](NamingSystem-passportNumNS-SOM.md) | Identifier of the namespace for Passport Numbers issued by the country of SOMALIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SOUTH AFRICA](NamingSystem-passportNumNS-ZAF.md) | Identifier of the namespace for Passport Numbers issued by the country of SOUTH AFRICA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS](NamingSystem-passportNumNS-SGS.md) | Identifier of the namespace for Passport Numbers issued by the country of SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SPAIN](NamingSystem-passportNumNS-ESP.md) | Identifier of the namespace for Passport Numbers issued by the country of SPAIN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SRI LANKA](NamingSystem-passportNumNS-LKA.md) | Identifier of the namespace for Passport Numbers issued by the country of SRI LANKA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SUDAN](NamingSystem-passportNumNS-SDN.md) | Identifier of the namespace for Passport Numbers issued by the country of SUDAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SURINAME](NamingSystem-passportNumNS-SUR.md) | Identifier of the namespace for Passport Numbers issued by the country of SURINAME. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SVALBARD AND JAN MAYEN](NamingSystem-passportNumNS-SJM.md) | Identifier of the namespace for Passport Numbers issued by the country of SVALBARD AND JAN MAYEN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SWAZILAND](NamingSystem-passportNumNS-SWZ.md) | Identifier of the namespace for Passport Numbers issued by the country of SWAZILAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SWEDEN](NamingSystem-passportNumNS-SWE.md) | Identifier of the namespace for Passport Numbers issued by the country of SWEDEN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SWITZERLAND](NamingSystem-passportNumNS-CHE.md) | Identifier of the namespace for Passport Numbers issued by the country of SWITZERLAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for SYRIAN ARAB REPUBLIC](NamingSystem-passportNumNS-SYR.md) | Identifier of the namespace for Passport Numbers issued by the country of SYRIAN ARAB REPUBLIC. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TAIWAN, PROVINCE OF CHINA](NamingSystem-passportNumNS-TWN.md) | Identifier of the namespace for Passport Numbers issued by the country of TAIWAN, PROVINCE OF CHINA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TAJIKISTAN](NamingSystem-passportNumNS-TJK.md) | Identifier of the namespace for Passport Numbers issued by the country of TAJIKISTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TANZANIA, UNITED REPUBLIC OF](NamingSystem-passportNumNS-TZA.md) | Identifier of the namespace for Passport Numbers issued by the country of TANZANIA, UNITED REPUBLIC OF. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for THAILAND](NamingSystem-passportNumNS-THA.md) | Identifier of the namespace for Passport Numbers issued by the country of THAILAND. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TIMOR-LESTE](NamingSystem-passportNumNS-TLS.md) | Identifier of the namespace for Passport Numbers issued by the country of TIMOR-LESTE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TOGO](NamingSystem-passportNumNS-TGO.md) | Identifier of the namespace for Passport Numbers issued by the country of TOGO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TOKELAU](NamingSystem-passportNumNS-TKL.md) | Identifier of the namespace for Passport Numbers issued by the country of TOKELAU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TONGA](NamingSystem-passportNumNS-TON.md) | Identifier of the namespace for Passport Numbers issued by the country of TONGA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TRINIDAD AND TOBAGO](NamingSystem-passportNumNS-TTO.md) | Identifier of the namespace for Passport Numbers issued by the country of TRINIDAD AND TOBAGO. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TUNISIA](NamingSystem-passportNumNS-TUN.md) | Identifier of the namespace for Passport Numbers issued by the country of TUNISIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TURKEY](NamingSystem-passportNumNS-TUR.md) | Identifier of the namespace for Passport Numbers issued by the country of TURKEY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TURKMENISTAN](NamingSystem-passportNumNS-TKM.md) | Identifier of the namespace for Passport Numbers issued by the country of TURKMENISTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TURKS AND CAICOS ISLANDS](NamingSystem-passportNumNS-TCA.md) | Identifier of the namespace for Passport Numbers issued by the country of TURKS AND CAICOS ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for TUVALU](NamingSystem-passportNumNS-TUV.md) | Identifier of the namespace for Passport Numbers issued by the country of TUVALU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UGANDA](NamingSystem-passportNumNS-UGA.md) | Identifier of the namespace for Passport Numbers issued by the country of UGANDA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UKRAINE](NamingSystem-passportNumNS-UKR.md) | Identifier of the namespace for Passport Numbers issued by the country of UKRAINE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UNITED ARAB EMIRATES](NamingSystem-passportNumNS-ARE.md) | Identifier of the namespace for Passport Numbers issued by the country of UNITED ARAB EMIRATES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UNITED KINGDOM](NamingSystem-passportNumNS-GBR.md) | Identifier of the namespace for Passport Numbers issued by the country of UNITED KINGDOM. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UNITED STATES](NamingSystem-passportNumNS-USA.md) | Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UNITED STATES MINOR OUTLYING ISLANDS](NamingSystem-passportNumNS-UMI.md) | Identifier of the namespace for Passport Numbers issued by the country of UNITED STATES MINOR OUTLYING ISLANDS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for URUGUAY](NamingSystem-passportNumNS-URY.md) | Identifier of the namespace for Passport Numbers issued by the country of URUGUAY. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for UZBEKISTAN](NamingSystem-passportNumNS-UZB.md) | Identifier of the namespace for Passport Numbers issued by the country of UZBEKISTAN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for VANUATU](NamingSystem-passportNumNS-VUT.md) | Identifier of the namespace for Passport Numbers issued by the country of VANUATU. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for VENEZUELA](NamingSystem-passportNumNS-VEN.md) | Identifier of the namespace for Passport Numbers issued by the country of VENEZUELA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for VIET NAM](NamingSystem-passportNumNS-VNM.md) | Identifier of the namespace for Passport Numbers issued by the country of VIET NAM. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for VIRGIN ISLANDS (BRITISH)](NamingSystem-passportNumNS-VGB.md) | Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (BRITISH). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for VIRGIN ISLANDS (U.S.)](NamingSystem-passportNumNS-VIR.md) | Identifier of the namespace for Passport Numbers issued by the country of VIRGIN ISLANDS (U.S.). Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for WALLIS AND FUTUNA](NamingSystem-passportNumNS-WLF.md) | Identifier of the namespace for Passport Numbers issued by the country of WALLIS AND FUTUNA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for WESTERN SAHARA](NamingSystem-passportNumNS-ESH.md) | Identifier of the namespace for Passport Numbers issued by the country of WESTERN SAHARA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for YEMEN](NamingSystem-passportNumNS-YEM.md) | Identifier of the namespace for Passport Numbers issued by the country of YEMEN. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for YUGOSLAVIA](NamingSystem-passportNumNS-YUG.md) | Identifier of the namespace for Passport Numbers issued by the country of YUGOSLAVIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ZAMBIA](NamingSystem-passportNumNS-ZMB.md) | Identifier of the namespace for Passport Numbers issued by the country of ZAMBIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Passport Numbers Namespace for ZIMBABWE](NamingSystem-passportNumNS-ZWE.md) | Identifier of the namespace for Passport Numbers issued by the country of ZIMBABWE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |
| [Pennsylvania Driver's License](NamingSystem-PennsylvaniaDLN.md) | Pennsylvania Motor Vehicle Bureau |
| [PeriodicIntervalOfTimeAbbreviation](NamingSystem-v3-PeriodicIntervalOfTimeAbbreviation.md) |  |
| [Perioperative Nursing Data Set](NamingSystem-pnds.md) | The PNDS provides standardized terms and codes for patient problems/nursing diagnoses, nursing interventions including actual or expected (goal) outcomes. The PNDS provides standardized terms and codes for nursing diagnoses (a subset of NANDA), nursing interventions and outcomes. The outcomes and interventions are in a relational database. The PNDS intervention and outcome statements are attached in an Access Database. The NANDA diagnoses in the PNDS have already been registered by HL7. |
| [Pharmacogene Variation](NamingSystem-PharmVar.md) | "The major focus of the Pharmacogene Consortium (PharmVar) is to serve as a repository for allelic variation, providing an official and unified allele designation system for the Pharmacogenetics (PGx) community and facilitating the translation of genotype into phenotype and clinical implementation of PGx. While the majority of pharmacogenes in PharmVar utilize the star nomenclature to describe variation, the provision of single nucleotide variants (SNVs), rather than haplotype, is preferred for some genes. Thus, PharmVar has two different page formats, A) using star nomenclature and B) using rs ID# as allele (referred to as ‘rs-format’). PharmVar designates human pharmacogene variation and houses allelic variants in the PharmVar database.* All submissions to PharmVar must use the submission form available on [www.PharmVar.org](https://www.pharmvar.org/) and be submitted to [submissions@PharmVar.org](mailto:submissions@PharmVar.org). Only complete submission requests will be accepted and processed. 
* PharmVar Gene Expert Panels will review each submission and make a recommendation to the PharmVar Steering Committee. 
* In this ‘Allele Designation Criteria and Evidence level’ document, we collectively refer to deviations from the RefSeq as “sequence variations” or "SNVs", including single nucleotide polymorphisms (SNPs) and small nucleotide insertions and deletions (indels) up to 50 bp. Copy number variants (i.e. entire or partial gene deletions and duplications), hybrid genes (e.g. CYP2D6/2D7 hybrids) and duplications containing non-identical gene copies (e.g. CYP2D6*36+*10) are referred to as CNVs or structural variants. 
* PharmVar applies the following criteria for allele designation. In rare cases, exceptions may be made to accommodate established star allele definitions to minimize impact on research, clinical labs and/or PGx implementation." PharmVar is released monthly (or more frequently) and uses a numbered database version format for each release. Note on updates to variants: The variants defined in association with a given PharmVar ID are immutable. When it is necessary to update the variant definitions for an associated concept, the existing allele and PharmVar ID are marked as "retired" and a new PharmVar ID is issued with the updated variant definitions. In the context of the representation of PharmVar in HL7 standards: 
* The concept identifier is the PharmVar ID 
* The concept display name is the Allele Name 
* There are several concept properties associated with PharmVar concepts (Legacy Label, Variants, etc.) 
* The code system is represented with an is-a hierarchy
 |
| [Policy Holder Role](NamingSystem-v3-policyHolderRole.md) | This vocabulary is defined by Implementation Guide for CDA Release 2 - Level 1 - Care Record Summary (US realm). It describes roles recognized through the issuance of an insurance policy to a policyholder who a relationship with the covered party, such as spouse, child, etc. This vocabulary is essentially an inversion of the role relations of the HL7 CoverageRoleType vocabulary. It provides more detailed roles with respect to the underwriter (the scoping organization) for those participants in the policyholder role for a patient.**Open Issue:**The code values for this coding system must be extracted from the CDA documentation and brought forward through Harmonization for instantiation in this repository. |
| [ProcedureMethod](NamingSystem-v3-ProcedureMethod.md) | Identifies the technique used to perform a procedure. |
| [RadLex radiology lexicon](NamingSystem-RadLex.md) | RadLex is a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research. RadLex Playbook is a project of the Radiological Society of North America (RSNA), and constitutes a portion of the RadLex ontology. Playbook aims to provide a standard system for naming radiology procedures, based on the elements which define an imaging exam such as modality and body part. By providing standard names and codes for radiologic studies, Playbook is intended to facilitate a variety of operational and quality improvement efforts, including workflow optimization, chargemaster management, radiation dose tracking, enterprise integration and image exchange. As of RadLex Playbook version 2.5, a four-year project to harmonize RadLex Playbook with the radiology portion of the LOINC standard has been concluded, leading to the LOINC-RSNA Radiology Playbook which is jointly managed by the Regenstrief Institute (publisher of LOINC) and RSNA. This harmonized Playbook defines a new information model for describing imaging procedures, and identifies correspondences between RadLex Playbook codes and LOINC codes. (See https://loinc.org/download/loinc-users-guide and http://pubs.rsna.org/doi/pdf/10.1148/rg.2017160188 for details.) Note that RadLex Playbook codes start with "RPID" followed by a numerical value. LOINC codes consist of a numerical code, followed by a hyphen and a single additional digit (called the check digit). Note that in the future, new codes will be created in the LOINC format only, not the RPID format. New adopters are encouraged to use LOINC-format codes. LOINC-format codes may be accessed at http://search.loinc.org. New code requests may be submitted to the joint Regenstrief-RSNA governance committee at https://loinc.org/submissions/. From the RSNA website: "We (RSNA) recognize the benefits that come from radiologists using common language to communicate diagnostic results. For this reason, RSNA produced RadLex®, a comprehensive set of radiology terms for use in radiology reporting, decision support, data mining, data registries, education and research. RadLex provides the foundation for vital data resources used in radiology:* The LOINC/RSNA Radiology Playbook (http://playbook.radlex.org/playbook/SearchRadlexAction) 
* RadElement Common Data Elements (http://www.radelement.org/) 
* RadReport Radiology Reporting Templates (http://radreport.org/) The development of RadLex has been supported by the National Institute of Biomedical Imaging and Bioengineering (NIBIB) and the cancer Biomedical Informatics Grid (caBIG) project.;"
 |
| [Read Classification](NamingSystem-read-Codes.md) | Clinical Terms Version 3 contains over 200,000 coded concepts arranged in a sub-type hierarchical structure. Top level hierarchy sections: Disorders Findings Morphology Surgical procedures Regimes & therapies Investigations Stages & scales Occupations Organisms Units Drugs Appliances & equipment |
| [Rhode Island Driver's License](NamingSystem-RhodeIslandDLN.md) | Rhode Island Motor Vehicle Bureau |
| [RxNorm](NamingSystem-v3-rxNorm.md) | RxNorm provides normalized names for clinical drugs and links its names to many of the drug vocabularies commonly used in pharmacy management and drug interaction software, including those of First Databank, Micromedex, and Gold Standard Drug Database. By providing links between these vocabularies, RxNorm can mediate messages between systems not using the same software and vocabulary. RxNorm now includes the United States Pharmacopeia (USP) Compendial Nomenclature from the United States Pharmacopeial Convention. USP is a cumulative data set of all Active Pharmaceutical Ingredients (API). |
| [SCDHEC GIS Spatial Accuracy Tiers](NamingSystem-SCDHEC-GISSpatialAccuracyTiers.md) | **Description:**The South Carolina Department of Health and Environmental Control GIS Spatial Data Accuracy Tiers have been derived from the National Standard for Spatial Data Accuracy as a means to categorize the accuracy of spatial data assignment utilizing a variety of tools for capturing coordinates including digitizers, geocoding software and global positioning system devices. |
| [SNOMED International](NamingSystem-SNM3.md) | SNOMED International |
| [SNOMED topology codes (anatomic sites)](NamingSystem-SNT.md) | SNOMED topology codes (anatomic sites) |
| [SNOMED-DICOM Microglossary](NamingSystem-SDM.md) | SNOMED-DICOM Microglossary |
| [SNOMED CT International Edition](NamingSystem-v3-snomed-CT.md) | SNOMED CT is a core clinical healthcare terminology that contains concepts with unique meanings and formal logic based definitions organized into hierarchies. |
| [Scientific Evidence Code System (SEVCO)](NamingSystem-SEVCO.md) | The Scientific Evidence Code System (SEVCO) includes terms for describing scientific research, including study design, risk of bias, and statistical concepts. For additional derivation details for any term, see[https://fevir.net/resources/CodeSystem/27270](https://fevir.net/resources/CodeSystem/27270)For more information, see[https://fevir.net/sevco](https://fevir.net/sevco) |
| [Sequence Ontology](NamingSystem-SO.md) | "The Sequence Ontology is a set of terms and relationships used to describe the features and attributes of biological sequence. SO includes different kinds of features which can be located on the sequence. Biological features are those which are defined by their disposition to be involved in a biological process." "The Sequence Ontologies are provided as a resource to the biological community. They have the following obvious uses:* To provide for a structured controlled vocabulary for the description of primary annotations of nucleic acid sequence, e.g. the annotations shared by a DAS server ([BioDAS](http://www.biodas.org/documents/das2/das2_protocol.html), [Biosapiens DAS](http://www.biosapiens.info/page.php?page=das_portal)), or annotations encoded by [GFF3](http://www.sequenceontology.org/gff3.shtml)." 
* To provide for a structured representation of these annotations within databases. Were genes within model organism databases to be annotated with these terms then it would be possible to query all these databases for, for example, all genes whose transcripts are edited, or trans-spliced, or are bound by a particular protein. One such genomic database is [Chado](http://www.gmod.org/wiki/Chado). 
* To provide a structured controlled vocabulary for the description of mutations at both the sequence and more gross level in the context of genomic databases." "The Sequence Ontology is part of [OBO](http://www.obofoundry.org/). It has close links to other ontology projects such as the [RNAO consortium](http://roc.bgsu.edu/), and the [Biosapiens polypeptide features](http://www.ebi.ac.uk/ontology-lookup/browse.do?ontName=BS)." The content can be browsed [here](http://www.sequenceontology.org/browser/obob.cgi) The content can be downloaded [here](https://github.com/The-Sequence-Ontology/SO-Ontologies) For information on contributing, please see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies#contributing) To request a term or register feedback, see [here](https://github.com/The-Sequence-Ontology/SO-Ontologies/issues)
 |
| [Source of Payment Typology](NamingSystem-SOPT.md) | The Source of Payment Typology (SOPT) is maintained by the Centers for Disease Control and Prevention (CDC), National Center for Health Statistics (NCHS). The code system is used to allow consistent reporting of payer data to public health agencies for health care services and research, and to exchange health insurance payer and program information. See[https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5](https://phinvads.cdc.gov/vads/ViewCodeSystem.action?id=2.16.840.1.113883.3.221.5) |
| [South Carolina Driver's License](NamingSystem-SouthCarolinaDLN.md) | South Carolina Motor Vehicle Bureau |
| [South Dakota Driver's License](NamingSystem-SouthDakotaDLN.md) | South Dakota Motor Vehicle Bureau |
| [SpecialArrangement](NamingSystem-v3-SpecialArrangement.md) | A code indicating the type of special arrangements provided for a patient encounter (e.g., wheelchair, stretcher, interpreter, attendant, seeing eye dog). For encounters in intention moods, this information can be used to identify special arrangements that will need to be made for the incoming patient. |
| [Standard Billing Unit](NamingSystem-standardBillingUnit.md) | NCPDP standard product billing codes of NCPDP field Unit of Measure (600-28). This billing code is assigned per product, placed in the Structured Product Label, and used in the pharmacy billing processing for consistent billing unit. |
| [Standard Occupation Code](NamingSystem-soc.md) | The Standard Occupational Classification (SOC) system is used by Federal statistical agencies to classify workers into occupational categories for the purpose of collecting, calculating, or disseminating data. All workers are classified into one of over 820 occupations according to their occupational definition. To facilitate classification, occupations are combined to form 23 major groups, 96 minor groups, and 449 broad occupations. Each broad occupation includes detailed occupation(s) requiring similar job duties, skills, education, or experience. This code system replaced the older FIPSPUB92, which was withdrawn in February 2005. |
| [Systemized Nomenclature of Medicine (SNOMED)](NamingSystem-snm.md) | Systemized Nomenclature in Medicine (SNOMED) |
| [TNM Staging System](NamingSystem-TNM.md) | The TNM Staging System was developed and is maintained by the AJCC and the Union for International Cancer Control (UICC). It is the most commonly used staging system by medical professionals around the world. The TNM classification system was developed as a tool for doctors to stage different types of cancer based on certain, standardized criteria. The TNM Staging System is based on the extent of the tumor (T), the extent of spread to the lymph nodes (N), and the presence of metastasis (M). HTA Note: Most content of TNM (V6) is in the SNOMED international release but not content from the most recent (V9). In Europe many countries use TNM codes, taken from the book and referenced using an OID. |
| [Tags for the Identification of Languages](NamingSystem-ietf3066.md) | from OID registry |
| [Tennessee Driver's License](NamingSystem-TennesseeDLN.md) | Tennessee Motor Vehicle Bureau |
| [Texas Driver's License](NamingSystem-TexasDLN.md) | Texas Motor Vehicle Bureau |
| [The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories](NamingSystem-hcp-lan-apm-framework.md) | "The Health Care Payment Learning and Action Network (HCPLAN or LAN)[https://hcp-lan.org/](https://hcp-lan.org/)is a public-private partnership established in 2015 by the US Department of Health and Human Services (HHS) to accelerate the transition to value-based payment models in the US healthcare system." "The Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer." "Since the original APM Framework White Paper was released in January 2016, it has become the foundation for implementing APMs and evaluating progress toward health care payment reform. Payers, providers, and purchasers have all used the APM Framework to better understand the payment reform landscape and to set goals for particip