# DentistHIPAA - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DentistHIPAA**

## ValueSet: DentistHIPAA 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-DentistHIPAA | *Version*:4.0.0 | |
| Retired as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DentistHIPAA |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.13188 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A dentist is a person qualified by a doctorate in dental surgery (D.D. S.) or dental medicine (D.M.D.). licensed by the state to practice dentistry, and practicing within the scope of that license. Many dentists are general practitioners who handle a wide variety of dental needs. Other dentists practice in one of eight specialty areas recognized by the American Dental Association: oral and maxillofacial surgery, orthodontics, periodontics, prosthodontics, endodontics, public health, oral pathology and pediatric dentistry. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansions are not generated for retired value sets

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-DentistHIPAA",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-DentistHIPAA",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.13188"
    }
  ],
  "version" : "4.0.0",
  "name" : "DentistHIPAA",
  "title" : "DentistHIPAA",
  "status" : "retired",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A dentist is a person qualified by a doctorate in dental surgery (D.D. S.) or dental medicine (D.M.D.). licensed by the state to practice dentistry, and practicing within the scope of that license. Many dentists are general practitioners who handle a wide variety of dental needs. Other dentists practice in one of eight specialty areas recognized by the American Dental Association: oral and maxillofacial surgery, orthodontics, periodontics, prosthodontics, endodontics, public health, oral pathology and pediatric dentistry.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://nucc.org/provider-taxonomy",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "122300000X"
          }
        ]
      }
    ]
  }
}

```
