# ActPriority - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActPriority**

## ValueSet: ActPriority 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-ActPriority | *Version*:3.0.0 | |
| Active as of 2014-03-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActPriority |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16866 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code or set of codes (e.g., for routine, emergency,) specifying the urgency under which the Act happened, can happen, is happening, is intended to happen, or is requested/demanded to happen. 
**Discussion:**This attribute is used in orders to indicate the ordered priority, and in event documentation it indicates the actual priority used to perform the act. In definition mood it indicates the available priorities. 

 **References** 

* [Appointment](http://hl7.org/fhir/R5/appointment.html)
* [Encounter](http://hl7.org/fhir/R5/encounter.html)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-ActPriority",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-ActPriority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16866"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActPriority",
  "title" : "ActPriority",
  "status" : "active",
  "experimental" : false,
  "date" : "2014-03-26",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code or set of codes (e.g., for routine, emergency,) specifying the urgency under which the Act happened, can happen, is happening, is intended to happen, or is requested/demanded to happen.\r\n\r\n*Discussion:* This attribute is used in orders to indicate the ordered priority, and in event documentation it indicates the actual priority used to perform the act. In definition mood it indicates the available priorities.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActPriority",
        "concept" : [
          {
            "code" : "A"
          },
          {
            "code" : "CR"
          },
          {
            "code" : "EL"
          },
          {
            "code" : "EM"
          },
          {
            "code" : "P"
          },
          {
            "code" : "PRN"
          },
          {
            "code" : "R"
          },
          {
            "code" : "RR"
          },
          {
            "code" : "S"
          },
          {
            "code" : "T"
          },
          {
            "code" : "UD"
          },
          {
            "code" : "UR"
          }
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-ActPriorityCallback"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-xEncounterAdmissionUrgency"
        ]
      }
    ]
  }
}

```
