# MIF Concept Relationship Reflexivity - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF Concept Relationship Reflexivity**

## ValueSet: MIF Concept Relationship Reflexivity 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/mif-conceptRelationshipReflexivity | *Version*:1.0.0 | |
| Draft as of 2025-12-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MIFConceptRelationshipReflexivity |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for use in the ext-mif-relationship-reflexivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.reflexivity values 

 **References** 

* [MIF concept relationship is reflexivity](StructureDefinition-ext-mif-relationship-reflexivity.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "mif-conceptRelationshipReflexivity",
  "url" : "http://terminology.hl7.org/ValueSet/mif-conceptRelationshipReflexivity",
  "version" : "1.0.0",
  "name" : "MIFConceptRelationshipReflexivity",
  "title" : "MIF Concept Relationship Reflexivity",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for use in the ext-mif-relationship-reflexivity to capture V3 Model Interchange Format (MIF) SupportedConceptRelationship.reflexivity values",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "MIF-ConceptRelationshipReflexivity"
          }
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
        "concept" : [
          {
            "code" : "MIF-ConceptRelationshipReflexivity"
          }
        ]
      }
    ]
  }
}

```
