# CQL Access Modifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Access Modifier**

## ValueSet: CQL Access Modifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/cql-access-modifier | *Version*:1.0.0 | |
| Draft as of 2024-02-16 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CqlAccessModifier |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Access modifiers defined by the Clinical Quality Language (CQL) specification in the[Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers)topic. 

 **References** 

* [CQL Access Modifier](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-cqf-cqlAccessModifier.html)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cql-access-modifier",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/cql-access-modifier",
  "version" : "1.0.0",
  "name" : "CqlAccessModifier",
  "title" : "CQL Access Modifier",
  "status" : "draft",
  "experimental" : false,
  "date" : "2024-02-16",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Access modifiers defined by the Clinical Quality Language (CQL) specification in the [Access Modifiers](https://cql.hl7.org/03-developersguide.html#access-modifiers) topic.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/cql-access-modifier"
      }
    ]
  }
}

```
