# Languages - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Languages**

## ValueSet: Languages 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/Languages | *Version*:1.0.0 | |
| Active as of 2024-07-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Languages |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This value set defines a set of codes for the representation of the names of languages. It uses the list of ISO 639-2 concepts using the ISO 639-1 2-digit code for a concept where possible and the 3-digit terminological code where there is no 2-digit code. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "Languages",
  "meta" : {
    "lastUpdated" : "2020-02-24T12:41:39.109+11:00",
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    }
  ],
  "url" : "http://terminology.hl7.org/ValueSet/Languages",
  "version" : "1.0.0",
  "name" : "Languages",
  "title" : "Languages",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-07-01T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes for the representation of the names of languages. It uses the list of ISO 639-2 concepts using the ISO 639-1 2-digit code for a concept where possible and the 3-digit terminological code where there is no  2-digit code.",
  "immutable" : true,
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:bcp:47",
        "concept" : [
          {
            "code" : "aa",
            "display" : "Afar"
          },
          {
            "code" : "ab",
            "display" : "Abkhazian"
          },
          {
            "code" : "ace",
            "display" : "Achinese"
          },
          {
            "code" : "ach",
            "display" : "Acoli"
          },
          {
            "code" : "ada",
            "display" : "Adangme"
          },
          {
            "code" : "ady",
            "display" : "Adyghe; Adygei"
          },
          {
            "code" : "ae",
            "display" : "Avestan"
          },
          {
            "code" : "af",
            "display" : "Afrikaans"
          },
          {
            "code" : "afa",
            "display" : "Afro-Asiatic languages"
          },
          {
            "code" : "afh",
            "display" : "Afrihili"
          },
          {
            "code" : "ain",
            "display" : "Ainu"
          },
          {
            "code" : "ak",
            "display" : "Akan"
          },
          {
            "code" : "akk",
            "display" : "Akkadian"
          },
          {
            "code" : "ale",
            "display" : "Aleut"
          },
          {
            "code" : "alg",
            "display" : "Algonquian languages"
          },
          {
            "code" : "alt",
            "display" : "Southern Altai"
          },
          {
            "code" : "am",
            "display" : "Amharic"
          },
          {
            "code" : "an",
            "display" : "Aragonese"
          },
          {
            "code" : "ang",
            "display" : "English, Old (ca.450-1100)"
          },
          {
            "code" : "anp",
            "display" : "Angika"
          },
          {
            "code" : "apa",
            "display" : "Apache languages"
          },
          {
            "code" : "ar",
            "display" : "Arabic"
          },
          {
            "code" : "arc",
            "display" : "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)"
          },
          {
            "code" : "arn",
            "display" : "Mapudungun; Mapuche"
          },
          {
            "code" : "arp",
            "display" : "Arapaho"
          },
          {
            "code" : "art",
            "display" : "Artificial languages"
          },
          {
            "code" : "arw",
            "display" : "Arawak"
          },
          {
            "code" : "as",
            "display" : "Assamese"
          },
          {
            "code" : "ast",
            "display" : "Asturian; Bable; Leonese; Asturleonese"
          },
          {
            "code" : "ath",
            "display" : "Athapascan languages"
          },
          {
            "code" : "aus",
            "display" : "Australian languages"
          },
          {
            "code" : "av",
            "display" : "Avaric"
          },
          {
            "code" : "awa",
            "display" : "Awadhi"
          },
          {
            "code" : "ay",
            "display" : "Aymara"
          },
          {
            "code" : "az",
            "display" : "Azerbaijani"
          },
          {
            "code" : "ba",
            "display" : "Bashkir"
          },
          {
            "code" : "bad",
            "display" : "Banda languages"
          },
          {
            "code" : "bai",
            "display" : "Bamileke languages"
          },
          {
            "code" : "bal",
            "display" : "Baluchi"
          },
          {
            "code" : "ban",
            "display" : "Balinese"
          },
          {
            "code" : "bas",
            "display" : "Basa"
          },
          {
            "code" : "bat",
            "display" : "Baltic languages"
          },
          {
            "code" : "be",
            "display" : "Belarusian"
          },
          {
            "code" : "bej",
            "display" : "Beja; Bedawiyet"
          },
          {
            "code" : "bem",
            "display" : "Bemba"
          },
          {
            "code" : "ber",
            "display" : "Berber languages"
          },
          {
            "code" : "bg",
            "display" : "Bulgarian"
          },
          {
            "code" : "bho",
            "display" : "Bhojpuri"
          },
          {
            "code" : "bi",
            "display" : "Bislama"
          },
          {
            "code" : "bik",
            "display" : "Bikol"
          },
          {
            "code" : "bin",
            "display" : "Bini; Edo"
          },
          {
            "code" : "bla",
            "display" : "Siksika"
          },
          {
            "code" : "bm",
            "display" : "Bambara"
          },
          {
            "code" : "bn",
            "display" : "Bengali"
          },
          {
            "code" : "bnt",
            "display" : "Bantu languages"
          },
          {
            "code" : "bo",
            "display" : "Tibetan"
          },
          {
            "code" : "br",
            "display" : "Breton"
          },
          {
            "code" : "bra",
            "display" : "Braj"
          },
          {
            "code" : "bs",
            "display" : "Bosnian"
          },
          {
            "code" : "btk",
            "display" : "Batak languages"
          },
          {
            "code" : "bua",
            "display" : "Buriat"
          },
          {
            "code" : "bug",
            "display" : "Buginese"
          },
          {
            "code" : "byn",
            "display" : "Blin; Bilin"
          },
          {
            "code" : "ca",
            "display" : "Catalan; Valencian"
          },
          {
            "code" : "cad",
            "display" : "Caddo"
          },
          {
            "code" : "cai",
            "display" : "Central American Indian languages"
          },
          {
            "code" : "car",
            "display" : "Galibi Carib"
          },
          {
            "code" : "cau",
            "display" : "Caucasian languages"
          },
          {
            "code" : "ce",
            "display" : "Chechen"
          },
          {
            "code" : "ceb",
            "display" : "Cebuano"
          },
          {
            "code" : "cel",
            "display" : "Celtic languages"
          },
          {
            "code" : "ch",
            "display" : "Chamorro"
          },
          {
            "code" : "chb",
            "display" : "Chibcha"
          },
          {
            "code" : "chg",
            "display" : "Chagatai"
          },
          {
            "code" : "chk",
            "display" : "Chuukese"
          },
          {
            "code" : "chm",
            "display" : "Mari"
          },
          {
            "code" : "chn",
            "display" : "Chinook jargon"
          },
          {
            "code" : "cho",
            "display" : "Choctaw"
          },
          {
            "code" : "chp",
            "display" : "Chipewyan; Dene Suline"
          },
          {
            "code" : "chr",
            "display" : "Cherokee"
          },
          {
            "code" : "chy",
            "display" : "Cheyenne"
          },
          {
            "code" : "cmc",
            "display" : "Chamic languages"
          },
          {
            "code" : "cnr",
            "display" : "Montenegrin"
          },
          {
            "code" : "co",
            "display" : "Corsican"
          },
          {
            "code" : "cop",
            "display" : "Coptic"
          },
          {
            "code" : "cpe",
            "display" : "Creoles and pidgins, English based"
          },
          {
            "code" : "cpf",
            "display" : "Creoles and pidgins, French-based"
          },
          {
            "code" : "cpp",
            "display" : "Creoles and pidgins, Portuguese-based"
          },
          {
            "code" : "cr",
            "display" : "Cree"
          },
          {
            "code" : "crh",
            "display" : "Crimean Tatar; Crimean Turkish"
          },
          {
            "code" : "crp",
            "display" : "Creoles and pidgins"
          },
          {
            "code" : "cs",
            "display" : "Czech"
          },
          {
            "code" : "csb",
            "display" : "Kashubian"
          },
          {
            "code" : "cu",
            "display" : "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic"
          },
          {
            "code" : "cus",
            "display" : "Cushitic languages"
          },
          {
            "code" : "cv",
            "display" : "Chuvash"
          },
          {
            "code" : "cy",
            "display" : "Welsh"
          },
          {
            "code" : "da",
            "display" : "Danish"
          },
          {
            "code" : "dak",
            "display" : "Dakota"
          },
          {
            "code" : "dar",
            "display" : "Dargwa"
          },
          {
            "code" : "day",
            "display" : "Land Dayak languages"
          },
          {
            "code" : "de",
            "display" : "German"
          },
          {
            "code" : "del",
            "display" : "Delaware"
          },
          {
            "code" : "den",
            "display" : "Slave (Athapascan)"
          },
          {
            "code" : "dgr",
            "display" : "Tlicho; Dogrib"
          },
          {
            "code" : "din",
            "display" : "Dinka"
          },
          {
            "code" : "doi",
            "display" : "Dogri"
          },
          {
            "code" : "dra",
            "display" : "Dravidian languages"
          },
          {
            "code" : "dsb",
            "display" : "Lower Sorbian"
          },
          {
            "code" : "dua",
            "display" : "Duala"
          },
          {
            "code" : "dum",
            "display" : "Dutch, Middle (ca.1050-1350)"
          },
          {
            "code" : "dv",
            "display" : "Divehi; Dhivehi; Maldivian"
          },
          {
            "code" : "dyu",
            "display" : "Dyula"
          },
          {
            "code" : "dz",
            "display" : "Dzongkha"
          },
          {
            "code" : "ee",
            "display" : "Ewe"
          },
          {
            "code" : "efi",
            "display" : "Efik"
          },
          {
            "code" : "egy",
            "display" : "Egyptian (Ancient)"
          },
          {
            "code" : "eka",
            "display" : "Ekajuk"
          },
          {
            "code" : "el",
            "display" : "Greek, Modern (1453-)"
          },
          {
            "code" : "elx",
            "display" : "Elamite"
          },
          {
            "code" : "en",
            "display" : "English"
          },
          {
            "code" : "enm",
            "display" : "English, Middle (1100-1500)"
          },
          {
            "code" : "eo",
            "display" : "Esperanto"
          },
          {
            "code" : "es",
            "display" : "Spanish; Castilian"
          },
          {
            "code" : "et",
            "display" : "Estonian"
          },
          {
            "code" : "eu",
            "display" : "Basque"
          },
          {
            "code" : "ewo",
            "display" : "Ewondo"
          },
          {
            "code" : "fa",
            "display" : "Persian"
          },
          {
            "code" : "fan",
            "display" : "Fang"
          },
          {
            "code" : "fat",
            "display" : "Fanti"
          },
          {
            "code" : "ff",
            "display" : "Fulah"
          },
          {
            "code" : "fi",
            "display" : "Finnish"
          },
          {
            "code" : "fil",
            "display" : "Filipino; Pilipino"
          },
          {
            "code" : "fiu",
            "display" : "Finno-Ugrian languages"
          },
          {
            "code" : "fj",
            "display" : "Fijian"
          },
          {
            "code" : "fo",
            "display" : "Faroese"
          },
          {
            "code" : "fon",
            "display" : "Fon"
          },
          {
            "code" : "fr",
            "display" : "French"
          },
          {
            "code" : "frm",
            "display" : "French, Middle (ca.1400-1600)"
          },
          {
            "code" : "fro",
            "display" : "French, Old (842-ca.1400)"
          },
          {
            "code" : "frr",
            "display" : "Northern Frisian"
          },
          {
            "code" : "frs",
            "display" : "Eastern Frisian"
          },
          {
            "code" : "fur",
            "display" : "Friulian"
          },
          {
            "code" : "fy",
            "display" : "Western Frisian"
          },
          {
            "code" : "ga",
            "display" : "Irish"
          },
          {
            "code" : "gaa",
            "display" : "Ga"
          },
          {
            "code" : "gay",
            "display" : "Gayo"
          },
          {
            "code" : "gba",
            "display" : "Gbaya"
          },
          {
            "code" : "gd",
            "display" : "Gaelic; Scottish Gaelic"
          },
          {
            "code" : "gem",
            "display" : "Germanic languages"
          },
          {
            "code" : "gez",
            "display" : "Geez"
          },
          {
            "code" : "gil",
            "display" : "Gilbertese"
          },
          {
            "code" : "gl",
            "display" : "Galician"
          },
          {
            "code" : "gmh",
            "display" : "German, Middle High (ca.1050-1500)"
          },
          {
            "code" : "gn",
            "display" : "Guarani"
          },
          {
            "code" : "goh",
            "display" : "German, Old High (ca.750-1050)"
          },
          {
            "code" : "gon",
            "display" : "Gondi"
          },
          {
            "code" : "gor",
            "display" : "Gorontalo"
          },
          {
            "code" : "got",
            "display" : "Gothic"
          },
          {
            "code" : "grb",
            "display" : "Grebo"
          },
          {
            "code" : "grc",
            "display" : "Greek, Ancient (to 1453)"
          },
          {
            "code" : "gsw",
            "display" : "Swiss German; Alemannic; Alsatian"
          },
          {
            "code" : "gu",
            "display" : "Gujarati"
          },
          {
            "code" : "gv",
            "display" : "Manx"
          },
          {
            "code" : "gwi",
            "display" : "Gwich'in"
          },
          {
            "code" : "ha",
            "display" : "Hausa"
          },
          {
            "code" : "hai",
            "display" : "Haida"
          },
          {
            "code" : "haw",
            "display" : "Hawaiian"
          },
          {
            "code" : "he",
            "display" : "Hebrew"
          },
          {
            "code" : "hi",
            "display" : "Hindi"
          },
          {
            "code" : "hil",
            "display" : "Hiligaynon"
          },
          {
            "code" : "him",
            "display" : "Himachali languages; Western Pahari languages"
          },
          {
            "code" : "hit",
            "display" : "Hittite"
          },
          {
            "code" : "hmn",
            "display" : "Hmong; Mong"
          },
          {
            "code" : "ho",
            "display" : "Hiri Motu"
          },
          {
            "code" : "hr",
            "display" : "Croatian"
          },
          {
            "code" : "hsb",
            "display" : "Upper Sorbian"
          },
          {
            "code" : "ht",
            "display" : "Haitian; Haitian Creole"
          },
          {
            "code" : "hu",
            "display" : "Hungarian"
          },
          {
            "code" : "hup",
            "display" : "Hupa"
          },
          {
            "code" : "hy",
            "display" : "Armenian"
          },
          {
            "code" : "hz",
            "display" : "Herero"
          },
          {
            "code" : "ia",
            "display" : "Interlingua (International Auxiliary Language Association)"
          },
          {
            "code" : "iba",
            "display" : "Iban"
          },
          {
            "code" : "id",
            "display" : "Indonesian"
          },
          {
            "code" : "ie",
            "display" : "Interlingue; Occidental"
          },
          {
            "code" : "ig",
            "display" : "Igbo"
          },
          {
            "code" : "ii",
            "display" : "Sichuan Yi; Nuosu"
          },
          {
            "code" : "ijo",
            "display" : "Ijo languages"
          },
          {
            "code" : "ik",
            "display" : "Inupiaq"
          },
          {
            "code" : "ilo",
            "display" : "Iloko"
          },
          {
            "code" : "inc",
            "display" : "Indic languages"
          },
          {
            "code" : "ine",
            "display" : "Indo-European languages"
          },
          {
            "code" : "inh",
            "display" : "Ingush"
          },
          {
            "code" : "io",
            "display" : "Ido"
          },
          {
            "code" : "ira",
            "display" : "Iranian languages"
          },
          {
            "code" : "iro",
            "display" : "Iroquoian languages"
          },
          {
            "code" : "is",
            "display" : "Icelandic"
          },
          {
            "code" : "it",
            "display" : "Italian"
          },
          {
            "code" : "iu",
            "display" : "Inuktitut"
          },
          {
            "code" : "ja",
            "display" : "Japanese"
          },
          {
            "code" : "jbo",
            "display" : "Lojban"
          },
          {
            "code" : "jpr",
            "display" : "Judeo-Persian"
          },
          {
            "code" : "jrb",
            "display" : "Judeo-Arabic"
          },
          {
            "code" : "jv",
            "display" : "Javanese"
          },
          {
            "code" : "ka",
            "display" : "Georgian"
          },
          {
            "code" : "kaa",
            "display" : "Kara-Kalpak"
          },
          {
            "code" : "kab",
            "display" : "Kabyle"
          },
          {
            "code" : "kac",
            "display" : "Kachin; Jingpho"
          },
          {
            "code" : "kam",
            "display" : "Kamba"
          },
          {
            "code" : "kar",
            "display" : "Karen languages"
          },
          {
            "code" : "kaw",
            "display" : "Kawi"
          },
          {
            "code" : "kbd",
            "display" : "Kabardian"
          },
          {
            "code" : "kg",
            "display" : "Kongo"
          },
          {
            "code" : "kha",
            "display" : "Khasi"
          },
          {
            "code" : "khi",
            "display" : "Khoisan languages"
          },
          {
            "code" : "kho",
            "display" : "Khotanese; Sakan"
          },
          {
            "code" : "ki",
            "display" : "Kikuyu; Gikuyu"
          },
          {
            "code" : "kj",
            "display" : "Kuanyama; Kwanyama"
          },
          {
            "code" : "kk",
            "display" : "Kazakh"
          },
          {
            "code" : "kl",
            "display" : "Kalaallisut; Greenlandic"
          },
          {
            "code" : "km",
            "display" : "Central Khmer"
          },
          {
            "code" : "kmb",
            "display" : "Kimbundu"
          },
          {
            "code" : "kn",
            "display" : "Kannada"
          },
          {
            "code" : "ko",
            "display" : "Korean"
          },
          {
            "code" : "kok",
            "display" : "Konkani"
          },
          {
            "code" : "kos",
            "display" : "Kosraean"
          },
          {
            "code" : "kpe",
            "display" : "Kpelle"
          },
          {
            "code" : "kr",
            "display" : "Kanuri"
          },
          {
            "code" : "krc",
            "display" : "Karachay-Balkar"
          },
          {
            "code" : "krl",
            "display" : "Karelian"
          },
          {
            "code" : "kro",
            "display" : "Kru languages"
          },
          {
            "code" : "kru",
            "display" : "Kurukh"
          },
          {
            "code" : "ks",
            "display" : "Kashmiri"
          },
          {
            "code" : "ku",
            "display" : "Kurdish"
          },
          {
            "code" : "kum",
            "display" : "Kumyk"
          },
          {
            "code" : "kut",
            "display" : "Kutenai"
          },
          {
            "code" : "kv",
            "display" : "Komi"
          },
          {
            "code" : "kw",
            "display" : "Cornish"
          },
          {
            "code" : "ky",
            "display" : "Kirghiz; Kyrgyz"
          },
          {
            "code" : "la",
            "display" : "Latin"
          },
          {
            "code" : "lad",
            "display" : "Ladino"
          },
          {
            "code" : "lah",
            "display" : "Lahnda"
          },
          {
            "code" : "lam",
            "display" : "Lamba"
          },
          {
            "code" : "lb",
            "display" : "Luxembourgish; Letzeburgesch"
          },
          {
            "code" : "lez",
            "display" : "Lezghian"
          },
          {
            "code" : "lg",
            "display" : "Ganda"
          },
          {
            "code" : "li",
            "display" : "Limburgan; Limburger; Limburgish"
          },
          {
            "code" : "ln",
            "display" : "Lingala"
          },
          {
            "code" : "lo",
            "display" : "Lao"
          },
          {
            "code" : "lol",
            "display" : "Mongo"
          },
          {
            "code" : "loz",
            "display" : "Lozi"
          },
          {
            "code" : "lt",
            "display" : "Lithuanian"
          },
          {
            "code" : "lu",
            "display" : "Luba-Katanga"
          },
          {
            "code" : "lua",
            "display" : "Luba-Lulua"
          },
          {
            "code" : "lui",
            "display" : "Luiseno"
          },
          {
            "code" : "lun",
            "display" : "Lunda"
          },
          {
            "code" : "luo",
            "display" : "Luo (Kenya and Tanzania)"
          },
          {
            "code" : "lus",
            "display" : "Lushai"
          },
          {
            "code" : "lv",
            "display" : "Latvian"
          },
          {
            "code" : "mad",
            "display" : "Madurese"
          },
          {
            "code" : "mag",
            "display" : "Magahi"
          },
          {
            "code" : "mai",
            "display" : "Maithili"
          },
          {
            "code" : "mak",
            "display" : "Makasar"
          },
          {
            "code" : "man",
            "display" : "Mandingo"
          },
          {
            "code" : "map",
            "display" : "Austronesian languages"
          },
          {
            "code" : "mas",
            "display" : "Masai"
          },
          {
            "code" : "mdf",
            "display" : "Moksha"
          },
          {
            "code" : "mdr",
            "display" : "Mandar"
          },
          {
            "code" : "men",
            "display" : "Mende"
          },
          {
            "code" : "mg",
            "display" : "Malagasy"
          },
          {
            "code" : "mga",
            "display" : "Irish, Middle (900-1200)"
          },
          {
            "code" : "mh",
            "display" : "Marshallese"
          },
          {
            "code" : "mi",
            "display" : "Maori"
          },
          {
            "code" : "mic",
            "display" : "Mi'kmaq; Micmac"
          },
          {
            "code" : "min",
            "display" : "Minangkabau"
          },
          {
            "code" : "mis",
            "display" : "Uncoded languages"
          },
          {
            "code" : "mk",
            "display" : "Macedonian"
          },
          {
            "code" : "mkh",
            "display" : "Mon-Khmer languages"
          },
          {
            "code" : "ml",
            "display" : "Malayalam"
          },
          {
            "code" : "mn",
            "display" : "Mongolian"
          },
          {
            "code" : "mnc",
            "display" : "Manchu"
          },
          {
            "code" : "mni",
            "display" : "Manipuri"
          },
          {
            "code" : "mno",
            "display" : "Manobo languages"
          },
          {
            "code" : "moh",
            "display" : "Mohawk"
          },
          {
            "code" : "mos",
            "display" : "Mossi"
          },
          {
            "code" : "mr",
            "display" : "Marathi"
          },
          {
            "code" : "ms",
            "display" : "Malay"
          },
          {
            "code" : "mt",
            "display" : "Maltese"
          },
          {
            "code" : "mul",
            "display" : "Multiple languages"
          },
          {
            "code" : "mun",
            "display" : "Munda languages"
          },
          {
            "code" : "mus",
            "display" : "Creek"
          },
          {
            "code" : "mwl",
            "display" : "Mirandese"
          },
          {
            "code" : "mwr",
            "display" : "Marwari"
          },
          {
            "code" : "my",
            "display" : "Burmese"
          },
          {
            "code" : "myn",
            "display" : "Mayan languages"
          },
          {
            "code" : "myv",
            "display" : "Erzya"
          },
          {
            "code" : "na",
            "display" : "Nauru"
          },
          {
            "code" : "nah",
            "display" : "Nahuatl languages"
          },
          {
            "code" : "nai",
            "display" : "North American Indian languages"
          },
          {
            "code" : "nap",
            "display" : "Neapolitan"
          },
          {
            "code" : "nb",
            "display" : "Bokmål, Norwegian; Norwegian Bokmål"
          },
          {
            "code" : "nd",
            "display" : "Ndebele, North; North Ndebele"
          },
          {
            "code" : "nds",
            "display" : "Low German; Low Saxon; German, Low; Saxon, Low"
          },
          {
            "code" : "ne",
            "display" : "Nepali"
          },
          {
            "code" : "new",
            "display" : "Nepal Bhasa; Newari"
          },
          {
            "code" : "ng",
            "display" : "Ndonga"
          },
          {
            "code" : "nia",
            "display" : "Nias"
          },
          {
            "code" : "nic",
            "display" : "Niger-Kordofanian languages"
          },
          {
            "code" : "niu",
            "display" : "Niuean"
          },
          {
            "code" : "nl",
            "display" : "Dutch; Flemish"
          },
          {
            "code" : "nn",
            "display" : "Norwegian Nynorsk; Nynorsk, Norwegian"
          },
          {
            "code" : "no",
            "display" : "Norwegian"
          },
          {
            "code" : "nog",
            "display" : "Nogai"
          },
          {
            "code" : "non",
            "display" : "Norse, Old"
          },
          {
            "code" : "nqo",
            "display" : "N'Ko"
          },
          {
            "code" : "nr",
            "display" : "Ndebele, South; South Ndebele"
          },
          {
            "code" : "nso",
            "display" : "Pedi; Sepedi; Northern Sotho"
          },
          {
            "code" : "nub",
            "display" : "Nubian languages"
          },
          {
            "code" : "nv",
            "display" : "Navajo; Navaho"
          },
          {
            "code" : "nwc",
            "display" : "Classical Newari; Old Newari; Classical Nepal Bhasa"
          },
          {
            "code" : "ny",
            "display" : "Chichewa; Chewa; Nyanja"
          },
          {
            "code" : "nym",
            "display" : "Nyamwezi"
          },
          {
            "code" : "nyn",
            "display" : "Nyankole"
          },
          {
            "code" : "nyo",
            "display" : "Nyoro"
          },
          {
            "code" : "nzi",
            "display" : "Nzima"
          },
          {
            "code" : "oc",
            "display" : "Occitan (post 1500)"
          },
          {
            "code" : "oj",
            "display" : "Ojibwa"
          },
          {
            "code" : "om",
            "display" : "Oromo"
          },
          {
            "code" : "or",
            "display" : "Oriya"
          },
          {
            "code" : "os",
            "display" : "Ossetian; Ossetic"
          },
          {
            "code" : "osa",
            "display" : "Osage"
          },
          {
            "code" : "ota",
            "display" : "Turkish, Ottoman (1500-1928)"
          },
          {
            "code" : "oto",
            "display" : "Otomian languages"
          },
          {
            "code" : "pa",
            "display" : "Panjabi; Punjabi"
          },
          {
            "code" : "paa",
            "display" : "Papuan languages"
          },
          {
            "code" : "pag",
            "display" : "Pangasinan"
          },
          {
            "code" : "pal",
            "display" : "Pahlavi"
          },
          {
            "code" : "pam",
            "display" : "Pampanga; Kapampangan"
          },
          {
            "code" : "pap",
            "display" : "Papiamento"
          },
          {
            "code" : "pau",
            "display" : "Palauan"
          },
          {
            "code" : "peo",
            "display" : "Persian, Old (ca.600-400 B.C.)"
          },
          {
            "code" : "phi",
            "display" : "Philippine languages"
          },
          {
            "code" : "phn",
            "display" : "Phoenician"
          },
          {
            "code" : "pi",
            "display" : "Pali"
          },
          {
            "code" : "pl",
            "display" : "Polish"
          },
          {
            "code" : "pon",
            "display" : "Pohnpeian"
          },
          {
            "code" : "pra",
            "display" : "Prakrit languages"
          },
          {
            "code" : "pro",
            "display" : "Provençal, Old (to 1500);Occitan, Old (to 1500)"
          },
          {
            "code" : "ps",
            "display" : "Pushto; Pashto"
          },
          {
            "code" : "pt",
            "display" : "Portuguese"
          },
          {
            "code" : "qu",
            "display" : "Quechua"
          },
          {
            "code" : "raj",
            "display" : "Rajasthani"
          },
          {
            "code" : "rap",
            "display" : "Rapanui"
          },
          {
            "code" : "rar",
            "display" : "Rarotongan; Cook Islands Maori"
          },
          {
            "code" : "rm",
            "display" : "Romansh"
          },
          {
            "code" : "rn",
            "display" : "Rundi"
          },
          {
            "code" : "ro",
            "display" : "Romanian; Moldavian; Moldovan"
          },
          {
            "code" : "roa",
            "display" : "Romance languages"
          },
          {
            "code" : "rom",
            "display" : "Romany"
          },
          {
            "code" : "ru",
            "display" : "Russian"
          },
          {
            "code" : "rup",
            "display" : "Aromanian; Arumanian; Macedo-Romanian"
          },
          {
            "code" : "rw",
            "display" : "Kinyarwanda"
          },
          {
            "code" : "sa",
            "display" : "Sanskrit"
          },
          {
            "code" : "sad",
            "display" : "Sandawe"
          },
          {
            "code" : "sah",
            "display" : "Yakut"
          },
          {
            "code" : "sai",
            "display" : "South American Indian languages"
          },
          {
            "code" : "sal",
            "display" : "Salishan languages"
          },
          {
            "code" : "sam",
            "display" : "Samaritan Aramaic"
          },
          {
            "code" : "sas",
            "display" : "Sasak"
          },
          {
            "code" : "sat",
            "display" : "Santali"
          },
          {
            "code" : "sc",
            "display" : "Sardinian"
          },
          {
            "code" : "scn",
            "display" : "Sicilian"
          },
          {
            "code" : "sco",
            "display" : "Scots"
          },
          {
            "code" : "sd",
            "display" : "Sindhi"
          },
          {
            "code" : "se",
            "display" : "Northern Sami"
          },
          {
            "code" : "sel",
            "display" : "Selkup"
          },
          {
            "code" : "sem",
            "display" : "Semitic languages"
          },
          {
            "code" : "sg",
            "display" : "Sango"
          },
          {
            "code" : "sga",
            "display" : "Irish, Old (to 900)"
          },
          {
            "code" : "sgn",
            "display" : "Sign Languages"
          },
          {
            "code" : "shn",
            "display" : "Shan"
          },
          {
            "code" : "si",
            "display" : "Sinhala; Sinhalese"
          },
          {
            "code" : "sid",
            "display" : "Sidamo"
          },
          {
            "code" : "sio",
            "display" : "Siouan languages"
          },
          {
            "code" : "sit",
            "display" : "Sino-Tibetan languages"
          },
          {
            "code" : "sk",
            "display" : "Slovak"
          },
          {
            "code" : "sl",
            "display" : "Slovenian"
          },
          {
            "code" : "sla",
            "display" : "Slavic languages"
          },
          {
            "code" : "sm",
            "display" : "Samoan"
          },
          {
            "code" : "sma",
            "display" : "Southern Sami"
          },
          {
            "code" : "smi",
            "display" : "Sami languages"
          },
          {
            "code" : "smj",
            "display" : "Lule Sami"
          },
          {
            "code" : "smn",
            "display" : "Inari Sami"
          },
          {
            "code" : "sms",
            "display" : "Skolt Sami"
          },
          {
            "code" : "sn",
            "display" : "Shona"
          },
          {
            "code" : "snk",
            "display" : "Soninke"
          },
          {
            "code" : "so",
            "display" : "Somali"
          },
          {
            "code" : "sog",
            "display" : "Sogdian"
          },
          {
            "code" : "son",
            "display" : "Songhai languages"
          },
          {
            "code" : "sq",
            "display" : "Albanian"
          },
          {
            "code" : "sr",
            "display" : "Serbian"
          },
          {
            "code" : "srn",
            "display" : "Sranan Tongo"
          },
          {
            "code" : "srr",
            "display" : "Serer"
          },
          {
            "code" : "ss",
            "display" : "Swati"
          },
          {
            "code" : "ssa",
            "display" : "Nilo-Saharan languages"
          },
          {
            "code" : "st",
            "display" : "Sotho, Southern"
          },
          {
            "code" : "su",
            "display" : "Sundanese"
          },
          {
            "code" : "suk",
            "display" : "Sukuma"
          },
          {
            "code" : "sus",
            "display" : "Susu"
          },
          {
            "code" : "sux",
            "display" : "Sumerian"
          },
          {
            "code" : "sv",
            "display" : "Swedish"
          },
          {
            "code" : "sw",
            "display" : "Swahili"
          },
          {
            "code" : "syc",
            "display" : "Classical Syriac"
          },
          {
            "code" : "syr",
            "display" : "Syriac"
          },
          {
            "code" : "ta",
            "display" : "Tamil"
          },
          {
            "code" : "tai",
            "display" : "Tai languages"
          },
          {
            "code" : "te",
            "display" : "Telugu"
          },
          {
            "code" : "tem",
            "display" : "Timne"
          },
          {
            "code" : "ter",
            "display" : "Tereno"
          },
          {
            "code" : "tet",
            "display" : "Tetum"
          },
          {
            "code" : "tg",
            "display" : "Tajik"
          },
          {
            "code" : "th",
            "display" : "Thai"
          },
          {
            "code" : "ti",
            "display" : "Tigrinya"
          },
          {
            "code" : "tig",
            "display" : "Tigre"
          },
          {
            "code" : "tiv",
            "display" : "Tiv"
          },
          {
            "code" : "tk",
            "display" : "Turkmen"
          },
          {
            "code" : "tkl",
            "display" : "Tokelau"
          },
          {
            "code" : "tl",
            "display" : "Tagalog"
          },
          {
            "code" : "tlh",
            "display" : "Klingon; tlhIngan-Hol"
          },
          {
            "code" : "tli",
            "display" : "Tlingit"
          },
          {
            "code" : "tmh",
            "display" : "Tamashek"
          },
          {
            "code" : "tn",
            "display" : "Tswana"
          },
          {
            "code" : "to",
            "display" : "Tonga (Tonga Islands)"
          },
          {
            "code" : "tog",
            "display" : "Tonga (Nyasa)"
          },
          {
            "code" : "tpi",
            "display" : "Tok Pisin"
          },
          {
            "code" : "tr",
            "display" : "Turkish"
          },
          {
            "code" : "ts",
            "display" : "Tsonga"
          },
          {
            "code" : "tsi",
            "display" : "Tsimshian"
          },
          {
            "code" : "tt",
            "display" : "Tatar"
          },
          {
            "code" : "tum",
            "display" : "Tumbuka"
          },
          {
            "code" : "tup",
            "display" : "Tupi languages"
          },
          {
            "code" : "tut",
            "display" : "Altaic languages"
          },
          {
            "code" : "tvl",
            "display" : "Tuvalu"
          },
          {
            "code" : "tw",
            "display" : "Twi"
          },
          {
            "code" : "ty",
            "display" : "Tahitian"
          },
          {
            "code" : "tyv",
            "display" : "Tuvinian"
          },
          {
            "code" : "udm",
            "display" : "Udmurt"
          },
          {
            "code" : "ug",
            "display" : "Uighur; Uyghur"
          },
          {
            "code" : "uga",
            "display" : "Ugaritic"
          },
          {
            "code" : "uk",
            "display" : "Ukrainian"
          },
          {
            "code" : "umb",
            "display" : "Umbundu"
          },
          {
            "code" : "und",
            "display" : "Undetermined"
          },
          {
            "code" : "ur",
            "display" : "Urdu"
          },
          {
            "code" : "uz",
            "display" : "Uzbek"
          },
          {
            "code" : "vai",
            "display" : "Vai"
          },
          {
            "code" : "ve",
            "display" : "Venda"
          },
          {
            "code" : "vi",
            "display" : "Vietnamese"
          },
          {
            "code" : "vo",
            "display" : "Volapük"
          },
          {
            "code" : "vot",
            "display" : "Votic"
          },
          {
            "code" : "wa",
            "display" : "Walloon"
          },
          {
            "code" : "wak",
            "display" : "Wakashan languages"
          },
          {
            "code" : "wal",
            "display" : "Wolaitta; Wolaytta"
          },
          {
            "code" : "war",
            "display" : "Waray"
          },
          {
            "code" : "was",
            "display" : "Washo"
          },
          {
            "code" : "wen",
            "display" : "Sorbian languages"
          },
          {
            "code" : "wo",
            "display" : "Wolof"
          },
          {
            "code" : "xal",
            "display" : "Kalmyk; Oirat"
          },
          {
            "code" : "xh",
            "display" : "Xhosa"
          },
          {
            "code" : "yao",
            "display" : "Yao"
          },
          {
            "code" : "yap",
            "display" : "Yapese"
          },
          {
            "code" : "yi",
            "display" : "Yiddish"
          },
          {
            "code" : "yo",
            "display" : "Yoruba"
          },
          {
            "code" : "ypk",
            "display" : "Yupik languages"
          },
          {
            "code" : "za",
            "display" : "Zhuang; Chuang"
          },
          {
            "code" : "zap",
            "display" : "Zapotec"
          },
          {
            "code" : "zbl",
            "display" : "Blissymbols; Blissymbolics; Bliss"
          },
          {
            "code" : "zen",
            "display" : "Zenaga"
          },
          {
            "code" : "zgh",
            "display" : "Standard Moroccan Tamazight"
          },
          {
            "code" : "zh",
            "display" : "Chinese"
          },
          {
            "code" : "znd",
            "display" : "Zande languages"
          },
          {
            "code" : "zu",
            "display" : "Zulu"
          },
          {
            "code" : "zun",
            "display" : "Zuni"
          },
          {
            "code" : "zxx",
            "display" : "No linguistic content; Not applicable"
          },
          {
            "code" : "zza",
            "display" : "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki"
          }
        ]
      }
    ]
  }
}

```
