# MIF Associated concept property - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MIF Associated concept property**

## Extension: MIF Associated concept property 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp | *Version*:0.0.34 |
| Active as of 2025-12-11 | *Computable Name*:AssociatedConceptProperty |

Concept Properties that are associated with this Code System or Value Set Version

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [ActRelationshipTemporallyPertainsEnd](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md), [ActRelationshipTemporallyPertainsStart](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md), [ReactionParticipant](ValueSet-v3-ReactionParticipant.md), [RoleClassMolecularFeatures](ValueSet-v3-RoleClassMolecularFeatures.md)...Show 40 more,[RoleClassMolecularPart](ValueSet-v3-RoleClassMolecularPart.md),[RoleClassSubstancePresence](ValueSet-v3-RoleClassSubstancePresence.md),[XAccommodationRequestorRole](ValueSet-v3-xAccommodationRequestorRole.md),[XActClassDocumentEntryAct](ValueSet-v3-xActClassDocumentEntryAct.md),[XActClassDocumentEntryOrganizer](ValueSet-v3-xActClassDocumentEntryOrganizer.md),[XActMoodDefEvn](ValueSet-v3-xActMoodDefEvn.md),[XActMoodDefEvnRqoPrmsPrp](ValueSet-v3-xActMoodDefEvnRqoPrmsPrp.md),[XActMoodDocumentObservation](ValueSet-v3-xActMoodDocumentObservation.md),[XActMoodEvnOrdPrmsPrp](ValueSet-v3-xActMoodEvnOrdPrmsPrp.md),[XActMoodIntentEvent](ValueSet-v3-xActMoodIntentEvent.md),[XActMoodOrdPrms](ValueSet-v3-xActMoodOrdPrms.md),[XActMoodOrdPrmsEvn](ValueSet-v3-xActMoodOrdPrmsEvn.md),[XActMoodPermPermrq](ValueSet-v3-xActMoodPermPermrq.md),[XActMoodRqoPrpAptArq](ValueSet-v3-xActMoodRqoPrpAptArq.md),[XActRelationshipDocument](ValueSet-v3-xActRelationshipDocument.md),[XActRelationshipDocumentSPL](ValueSet-v3-xActRelationshipDocumentSPL.md),[XActRelationshipEntry](ValueSet-v3-xActRelationshipEntry.md),[XActRelationshipEntryRelationship](ValueSet-v3-xActRelationshipEntryRelationship.md),[XActRelationshipExternalReference](ValueSet-v3-xActRelationshipExternalReference.md),[XActRelationshipPatientTransport](ValueSet-v3-xActRelationshipPatientTransport.md),[XActRelationshipPertinentInfo](ValueSet-v3-xActRelationshipPertinentInfo.md),[XDocumentEntrySubject](ValueSet-v3-xDocumentEntrySubject.md),[XDocumentSubject](ValueSet-v3-xDocumentSubject.md),[XEncounterParticipant](ValueSet-v3-xEncounterParticipant.md),[XEncounterPerformerParticipation](ValueSet-v3-xEncounterPerformerParticipation.md),[XEntityClassDocumentReceiving](ValueSet-v3-xEntityClassDocumentReceiving.md),[XEntityClassPersonOrOrgReceiving](ValueSet-v3-xEntityClassPersonOrOrgReceiving.md),[XInformationRecipient](ValueSet-v3-xInformationRecipient.md),[XInformationRecipientRole](ValueSet-v3-xInformationRecipientRole.md),[XLabProcessClassCodes](ValueSet-v3-xLabProcessClassCodes.md),[XParticipationAuthorPerformer](ValueSet-v3-xParticipationAuthorPerformer.md),[XParticipationEntVrf](ValueSet-v3-xParticipationEntVrf.md),[XParticipationPrfEntVrf](ValueSet-v3-xParticipationPrfEntVrf.md),[XParticipationVrfRespSprfWit](ValueSet-v3-xParticipationVrfRespSprfWit.md),[XRoleClassAccommodationRequestor](ValueSet-v3-xRoleClassAccommodationRequestor.md),[XRoleClassCoverage](ValueSet-v3-xRoleClassCoverage.md),[XRoleClassCoverageInvoice](ValueSet-v3-xRoleClassCoverageInvoice.md),[XRoleClassCredentialedEntity](ValueSet-v3-xRoleClassCredentialedEntity.md),[XRoleClassPayeePolicyRelationship](ValueSet-v3-xRoleClassPayeePolicyRelationship.md)and[XServiceEventPerformer](ValueSet-v3-xServiceEventPerformer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-mif-assocConceptProp)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-mif-assocConceptProp.csv), [Excel](StructureDefinition-ext-mif-assocConceptProp.xlsx), [Schematron](StructureDefinition-ext-mif-assocConceptProp.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-mif-assocConceptProp",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp",
  "version" : "0.0.34",
  "name" : "AssociatedConceptProperty",
  "title" : "MIF Associated concept property",
  "status" : "active",
  "date" : "2025-12-11T21:56:12-07:00",
  "description" : "Concept Properties that are associated with this Code System or Value Set Version",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "mif",
      "uri" : "urn:hl7-org:v3/mif2",
      "name" : "HL7 V3 Model Interchange Format 2"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem.property"
    },
    {
      "type" : "element",
      "expression" : "ValueSet"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MIF Value Set associated concept property",
        "definition" : "Concept Properties that are associated with this Value Set Version because the property is DECLARED as value-set associatable by the Code System from which this value set draws its enumerated content",
        "max" : "1",
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "ValueSetVersion.associatedConceptProperty"
          }
        ]
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2,
        "max" : "2"
      },
      {
        "id" : "Extension.extension:name",
        "path" : "Extension.extension",
        "sliceName" : "name",
        "short" : "Property name",
        "definition" : "Identifies the name of the property being specified",
        "min" : 1,
        "max" : "1",
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "ValueSetVersion.associatedConceptProperty.name"
          }
        ]
      },
      {
        "id" : "Extension.extension:name.url",
        "path" : "Extension.extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "name"
      },
      {
        "id" : "Extension.extension:name.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:value",
        "path" : "Extension.extension",
        "sliceName" : "value",
        "short" : "Property value",
        "definition" : "Identifies the value of the property being specified",
        "min" : 1,
        "max" : "1",
        "mapping" : [
          {
            "identity" : "mif",
            "map" : "ValueSetVersion.associatedConceptProperty.value"
          }
        ]
      },
      {
        "id" : "Extension.extension:value.url",
        "path" : "Extension.extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "value"
      },
      {
        "id" : "Extension.extension:value.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
