# CAN/CSA-Z795-96 - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CAN/CSA-Z795-96**

## NamingSystem: CAN/CSA-Z795-96 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/csaid | *Version*:2.0.1 | |
| Retired as of 2021-07-27 | *Responsible:*HL7 | *Computable Name*:Csaid |

 
** Inactvie since 2015. Nature of injury (NOI) codes, which are part of the Work Injury or Disease Information coding system (CAN/CSA-Z795-96 - R2003). 
The CSA code set includes 3 parts: Nature of injury (NOI), body part (BP), side of body (SB). 
For example: 
* NOI - Cut or laceration Injury = 03400
* BP - Upper Arm body part = 31100
* SOB - Left Side of Body = L
 
The Body Part codes are qualified by the Side of Body codes code system, to be more precise in specifying the location of the injury being coded. 
Code set is maintained by the Canadian Standards Association (CSA). 
set is maintained by the Canadian Standards Association (CSA). 
The Canadian Standards Association 5060 Spectrum Way Mississauga, Ontario Canada L4W 5N6 
Phone: (416) 747-4000 1-800-463-6727 Fax: (416) 747-2473 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "csaid",
  "url" : "http://terminology.hl7.org/NamingSystem/csaid",
  "version" : "2.0.1",
  "name" : "Csaid",
  "title" : "CAN/CSA-Z795-96",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-07-27T00:00:00-04:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "Canadian Standards Association (CSA)"
    }
  ],
  "responsible" : "HL7",
  "description" : "** Inactvie since 2015.    Nature of injury (NOI) codes, which are part of the Work Injury or Disease Information coding system (CAN/CSA-Z795-96 - R2003).\r\n\r\nThe CSA code set includes 3 parts: Nature of injury (NOI), body part (BP), side of body (SB).\r\n\r\nFor example:\r\n\r\n *  NOI - Cut or laceration Injury = 03400\r\n *  BP - Upper Arm body part = 31100\r\n *  SOB - Left Side of Body = L\r\n\r\nThe Body Part codes are qualified by the Side of Body codes code system, to be more precise in specifying the location of the injury being coded.\r\n\r\nCode set is maintained by the Canadian Standards Association (CSA).\r\n\r\nset is maintained by the Canadian Standards Association (CSA).\r\n\r\nThe Canadian Standards Association 5060 Spectrum Way Mississauga, Ontario Canada L4W 5N6\r\n\r\nPhone: (416) 747-4000 1-800-463-6727 Fax: (416) 747-2473",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.235",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/csaid",
      "preferred" : true,
      "comment" : "Code system inactive as of 2015.",
      "period" : {
        "start" : "2015-12-31"
      }
    }
  ]
}

```
