# Medical Subject Headings - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medical Subject Headings**

## NamingSystem: Medical Subject Headings 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/MeSH | *Version*:3.0.0 | |
| Active as of 2021-06-29 | *Responsible:*[National Library of Medicine](https://www.nlm.nih.gov/) | *Computable Name*:MeSH |

 
The Medical Subject Headings (MeSH) thesaurus is a controlled and hierarchically-organized vocabulary produced by the National Library of Medicine. It is used for indexing, cataloging, and searching of biomedical and health-related information. MeSH includes the subject headings appearing in MEDLINE/PubMed, the NLM Catalog, and other NLM databases. 
MeSH can be downloaded from https://www.nlm.nih.gov/databases/download/mesh.html 
MeSH can be browsed here: https://meshb.nlm.nih.gov/search 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "MeSH",
  "url" : "http://terminology.hl7.org/NamingSystem/MeSH",
  "version" : "3.0.0",
  "name" : "MeSH",
  "title" : "Medical Subject Headings",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-06-29T00:00:00-04:00",
  "publisher" : "National Library of Medicine",
  "contact" : [
    {
      "name" : "National Library of Medicine; 8600 Rockville Pike, Bethesda, MD 20894",
      "telecom" : [
        {
          "system" : "email",
          "value" : "https://support.nlm.nih.gov/support/create-case/"
        },
        {
          "system" : "url",
          "value" : "https://www.nlm.nih.gov/"
        }
      ]
    }
  ],
  "description" : "The Medical Subject Headings (MeSH) thesaurus is a controlled and hierarchically-organized vocabulary produced by the National Library of Medicine. It is used for indexing, cataloging, and searching of biomedical and health-related information. MeSH includes the subject headings appearing in MEDLINE/PubMed, the NLM Catalog, and other NLM databases.\r\n\r\nMeSH can be downloaded from https://www.nlm.nih.gov/databases/download/mesh.html\r\n\r\nMeSH can be browsed here: https://meshb.nlm.nih.gov/search",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.177",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.nlm.nih.gov/mesh",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-06-29T00:00:00-04:00"
      }
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/MSH",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility.",
      "period" : {
        "end" : "2021-06-29T00:00:00-04:00"
      }
    },
    {
      "type" : "iri-stem",
      "value" : "http://id.nlm.nih.gov/mesh/",
      "preferred" : false,
      "comment" : "MeSH as per https://hhs.github.io/meshrdf/versioning-policy as retrieved on 2024-Jan-24",
      "authoritative" : true
    }
  ]
}

```
