# CMS Place of Service Codes (POS) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Place of Service Codes (POS)**

## NamingSystem: CMS Place of Service Codes (POS) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CMSPlaceofServiceCodes | *Version*:1.1.0 |
| Active as of 2022-04-07 | *Responsible:*Centers for Medicare & Medicaid Services /td>*Computable Name*:CMSPlaceofServiceCodesPlace of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.This code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider. |



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CMSPlaceofServiceCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/CMSPlaceofServiceCodes",
  "version" : "1.1.0",
  "name" : "CMSPlaceofServiceCodes",
  "title" : "CMS Place of Service Codes (POS)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-04-07T00:00:00-00:00",
  "publisher" : "Centers for Medicare & Medicaid Services",
  "responsible" : "Centers for Medicare & Medicaid Services",
  "description" : "Place of Service Codes are two-digit codes placed on health care professional claims to indicate the setting in which a service was provided. The Centers for Medicare & Medicaid Services (CMS) maintain POS codes used throughout the health care industry.\r\n\r\nThis code set is required for use in the implementation guide adopted as the national standard for electronic transmission of professional health care claims under the provisions of the Health Insurance Portability and Accountability Act of 1996 (HIPAA). HIPAA directed the Secretary of HHS to adopt national standards for electronic transactions. These standard transactions require all health plans and providers to use standard code sets to populate data elements in each transaction. The Transaction and Code Set Rule adopted the ASC X12N-837 Health Care Claim: Professional, volumes 1 and 2, as the standard for electronic submission of professional claims. This standard names the POS code set currently maintained by CMS as the code set to be used for describing sites of service in such claims. POS information is often needed to determine the acceptability of direct billing of Medicare, Medicaid and private insurance services provided by a given provider.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.15.5",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set",
      "preferred" : true
    }
  ]
}

```
