# Race - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Race**

## CodeSystem: Race 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-Race | *Version*:4.0.0 | |
| Active as of 2022-01-05 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Race |
| *Other Identifiers:*OID:2.16.840.1.113883.5.104 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Deprecation Information:**Deprecated per UP-263. This code system is NOT the acknowledged source of truth for Race concepts and codes. It should no longer be used. https://terminology.hl7.org/CodeSystem-CDCREC.html should be used in its place. In the United States, federal standards for classifying data on race determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define race, and they recognize the absence of an anthropological or scientific basis for racial classification. Instead, the federal standards acknowledge that race is a social-political construct in which an individual's own identification with one more race categories is preferred to observer identification. The standards use a variety of features to define five minimum race categories. Among these features are descent from "the original peoples" of a specified region or nation. The minimum race categories are American Indian or Alaska Native, Asian, Black or African American, Native Hawaiian or Other Pacific Islander, and White. The federal standards stipulate that race data need not be limited to the five minimum categories, but any expansion must be collapsible to those categories. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Catawba](ValueSet-v3-Catawba.md)
* [Race](ValueSet-v3-Race.md)
* [RaceAfricanAmericanAfrican](ValueSet-v3-RaceAfricanAmericanAfrican.md)
* [RaceAlaskanIndian](ValueSet-v3-RaceAlaskanIndian.md)
* [RaceAlaskanIndianAthabascan](ValueSet-v3-RaceAlaskanIndianAthabascan.md)
* [RaceAlaskanNative](ValueSet-v3-RaceAlaskanNative.md)
* [RaceAlaskanNativeAleut](ValueSet-v3-RaceAlaskanNativeAleut.md)
* [RaceAlaskanNativeAleutAlutiiq](ValueSet-v3-RaceAlaskanNativeAleutAlutiiq.md)
* [RaceAlaskanNativeAleutBristolBay](ValueSet-v3-RaceAlaskanNativeAleutBristolBay.md)
* [RaceAlaskanNativeAleutChugach](ValueSet-v3-RaceAlaskanNativeAleutChugach.md)
* [RaceAlaskanNativeAleutKoniag](ValueSet-v3-RaceAlaskanNativeAleutKoniag.md)
* [RaceAlaskanNativeAleutUnangan](ValueSet-v3-RaceAlaskanNativeAleutUnangan.md)
* [RaceAlaskanNativeEskimo](ValueSet-v3-RaceAlaskanNativeEskimo.md)
* [RaceAlaskanNativeInupiatEskimo](ValueSet-v3-RaceAlaskanNativeInupiatEskimo.md)
* [RaceAlaskanNativeSiberianEskimo](ValueSet-v3-RaceAlaskanNativeSiberianEskimo.md)
* [RaceAlaskanNativeYupikEskimo](ValueSet-v3-RaceAlaskanNativeYupikEskimo.md)
* [RaceAmericanIndian](ValueSet-v3-RaceAmericanIndian.md)
* [RaceAmericanIndianApache](ValueSet-v3-RaceAmericanIndianApache.md)
* [RaceAmericanIndianArapaho](ValueSet-v3-RaceAmericanIndianArapaho.md)
* [RaceAmericanIndianAssiniboineSioux](ValueSet-v3-RaceAmericanIndianAssiniboineSioux.md)
* [RaceAmericanIndianCaddo](ValueSet-v3-RaceAmericanIndianCaddo.md)
* [RaceAmericanIndianCahuilla](ValueSet-v3-RaceAmericanIndianCahuilla.md)
* [RaceAmericanIndianCalifornia](ValueSet-v3-RaceAmericanIndianCalifornia.md)
* [RaceAmericanIndianChemakuan](ValueSet-v3-RaceAmericanIndianChemakuan.md)
* [RaceAmericanIndianCherokee](ValueSet-v3-RaceAmericanIndianCherokee.md)
* [RaceAmericanIndianCheyenne](ValueSet-v3-RaceAmericanIndianCheyenne.md)
* [RaceAmericanIndianChickahominy](ValueSet-v3-RaceAmericanIndianChickahominy.md)
* [RaceAmericanIndianChinook](ValueSet-v3-RaceAmericanIndianChinook.md)
* [RaceAmericanIndianChippewa](ValueSet-v3-RaceAmericanIndianChippewa.md)
* [RaceAmericanIndianChippewaCree](ValueSet-v3-RaceAmericanIndianChippewaCree.md)
* [RaceAmericanIndianChoctaw](ValueSet-v3-RaceAmericanIndianChoctaw.md)
* [RaceAmericanIndianChumash](ValueSet-v3-RaceAmericanIndianChumash.md)
* [RaceAmericanIndianComanche](ValueSet-v3-RaceAmericanIndianComanche.md)
* [RaceAmericanIndianCoushatta](ValueSet-v3-RaceAmericanIndianCoushatta.md)
* [RaceAmericanIndianCreek](ValueSet-v3-RaceAmericanIndianCreek.md)
* [RaceAmericanIndianCupeno](ValueSet-v3-RaceAmericanIndianCupeno.md)
* [RaceAmericanIndianDelaware](ValueSet-v3-RaceAmericanIndianDelaware.md)
* [RaceAmericanIndianDiegueno](ValueSet-v3-RaceAmericanIndianDiegueno.md)
* [RaceAmericanIndianEasternTribes](ValueSet-v3-RaceAmericanIndianEasternTribes.md)
* [RaceAmericanIndianGrosVentres](ValueSet-v3-RaceAmericanIndianGrosVentres.md)
* [RaceAmericanIndianHoopa](ValueSet-v3-RaceAmericanIndianHoopa.md)
* [RaceAmericanIndianIowa](ValueSet-v3-RaceAmericanIndianIowa.md)
* [RaceAmericanIndianIroquois](ValueSet-v3-RaceAmericanIndianIroquois.md)
* [RaceAmericanIndianKickapoo](ValueSet-v3-RaceAmericanIndianKickapoo.md)
* [RaceAmericanIndianKiowa](ValueSet-v3-RaceAmericanIndianKiowa.md)
* [RaceAmericanIndianKlallam](ValueSet-v3-RaceAmericanIndianKlallam.md)
* [RaceAmericanIndianLongIsland](ValueSet-v3-RaceAmericanIndianLongIsland.md)
* [RaceAmericanIndianLuiseno](ValueSet-v3-RaceAmericanIndianLuiseno.md)
* [RaceAmericanIndianMaidu](ValueSet-v3-RaceAmericanIndianMaidu.md)
* [RaceAmericanIndianMiami](ValueSet-v3-RaceAmericanIndianMiami.md)
* [RaceAmericanIndianMicmac](ValueSet-v3-RaceAmericanIndianMicmac.md)
* [RaceAmericanIndianNavajo](ValueSet-v3-RaceAmericanIndianNavajo.md)
* [RaceAmericanIndianNorthwestTribes](ValueSet-v3-RaceAmericanIndianNorthwestTribes.md)
* [RaceAmericanIndianOttawa](ValueSet-v3-RaceAmericanIndianOttawa.md)
* [RaceAmericanIndianPaiute](ValueSet-v3-RaceAmericanIndianPaiute.md)
* [RaceAmericanIndianPassamaquoddy](ValueSet-v3-RaceAmericanIndianPassamaquoddy.md)
* [RaceAmericanIndianPawnee](ValueSet-v3-RaceAmericanIndianPawnee.md)
* [RaceAmericanIndianPeoria](ValueSet-v3-RaceAmericanIndianPeoria.md)
* [RaceAmericanIndianPequot](ValueSet-v3-RaceAmericanIndianPequot.md)
* [RaceAmericanIndianPima](ValueSet-v3-RaceAmericanIndianPima.md)
* [RaceAmericanIndianPomo](ValueSet-v3-RaceAmericanIndianPomo.md)
* [RaceAmericanIndianPonca](ValueSet-v3-RaceAmericanIndianPonca.md)
* [RaceAmericanIndianPotawatomi](ValueSet-v3-RaceAmericanIndianPotawatomi.md)
* [RaceAmericanIndianPueblo](ValueSet-v3-RaceAmericanIndianPueblo.md)
* [RaceAmericanIndianPugetSoundSalish](ValueSet-v3-RaceAmericanIndianPugetSoundSalish.md)
* [RaceAmericanIndianSacFox](ValueSet-v3-RaceAmericanIndianSacFox.md)
* [RaceAmericanIndianSeminole](ValueSet-v3-RaceAmericanIndianSeminole.md)
* [RaceAmericanIndianSerrano](ValueSet-v3-RaceAmericanIndianSerrano.md)
* [RaceAmericanIndianShawnee](ValueSet-v3-RaceAmericanIndianShawnee.md)
* [RaceAmericanIndianShoshone](ValueSet-v3-RaceAmericanIndianShoshone.md)
* [RaceAmericanIndianShoshonePaiute](ValueSet-v3-RaceAmericanIndianShoshonePaiute.md)
* [RaceAmericanIndianSioux](ValueSet-v3-RaceAmericanIndianSioux.md)
* [RaceAmericanIndianTohonoOOdham](ValueSet-v3-RaceAmericanIndianTohonoOOdham.md)
* [RaceAmericanIndianUmpqua](ValueSet-v3-RaceAmericanIndianUmpqua.md)
* [RaceAmericanIndianUte](ValueSet-v3-RaceAmericanIndianUte.md)
* [RaceAmericanIndianWampanoag](ValueSet-v3-RaceAmericanIndianWampanoag.md)
* [RaceAmericanIndianWashoe](ValueSet-v3-RaceAmericanIndianWashoe.md)
* [RaceAmericanIndianWinnebago](ValueSet-v3-RaceAmericanIndianWinnebago.md)
* [RaceAmericanIndianYuman](ValueSet-v3-RaceAmericanIndianYuman.md)
* [RaceAmericanIndianYurok](ValueSet-v3-RaceAmericanIndianYurok.md)
* [RaceAsian](ValueSet-v3-RaceAsian.md)
* [RaceBlackOrAfricanAmerican](ValueSet-v3-RaceBlackOrAfricanAmerican.md)
* [RaceCanadianLatinIndian](ValueSet-v3-RaceCanadianLatinIndian.md)
* [RaceHawaiianOrPacificIsland](ValueSet-v3-RaceHawaiianOrPacificIsland.md)
* [RaceNativeAmerican](ValueSet-v3-RaceNativeAmerican.md)
* [RacePacificIslandMelanesian](ValueSet-v3-RacePacificIslandMelanesian.md)
* [RacePacificIslandMicronesian](ValueSet-v3-RacePacificIslandMicronesian.md)
* [RacePacificIslandPolynesian](ValueSet-v3-RacePacificIslandPolynesian.md)
* [RaceSoutheastAlaskanIndian](ValueSet-v3-RaceSoutheastAlaskanIndian.md)
* [RaceSoutheastAlaskanIndianTlingit](ValueSet-v3-RaceSoutheastAlaskanIndianTlingit.md)
* [RaceSoutheastAlaskanIndianTsimshian](ValueSet-v3-RaceSoutheastAlaskanIndianTsimshian.md)
* [RaceWhite](ValueSet-v3-RaceWhite.md)
* [RaceWhiteArab](ValueSet-v3-RaceWhiteArab.md)
* [RaceWhiteEuropean](ValueSet-v3-RaceWhiteEuropean.md)
* [RaceWhiteMiddleEast](ValueSet-v3-RaceWhiteMiddleEast.md)
* [Wiyot](ValueSet-v3-Wiyot.md)
* [Yaqui](ValueSet-v3-Yaqui.md)
* [Yokuts](ValueSet-v3-Yokuts.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-Race",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-Race",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.104"
    }
  ],
  "version" : "4.0.0",
  "name" : "Race",
  "title" : "Race",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-01-05",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Deprecation Information:** Deprecated per UP-263. This code system is NOT the acknowledged source of truth for Race concepts and codes. It should no longer be used. https://terminology.hl7.org/CodeSystem-CDCREC.html should be used in its place. In the United States, federal standards for classifying data on race determine the categories used by federal agencies and exert a strong influence on categorization by state and local agencies and private sector organizations. The federal standards do not conceptually define race, and they recognize the absence of an anthropological or scientific basis for racial classification. Instead, the federal standards acknowledge that race is a social-political construct in which an individual's own identification with one more race categories is preferred to observer identification. The standards use a variety of features to define five minimum race categories. Among these features are descent from \"the original peoples\" of a specified region or nation. The minimum race categories are American Indian or Alaska Native, Asian, Black or African American, Native Hawaiian or Other Pacific Islander, and White. The federal standards stipulate that race data need not be limited to the five minimum categories, but any expansion must be collapsible to those categories.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "1002-5",
      "display" : "American Indian or Alaska Native",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14915"
        }
      ],
      "concept" : [
        {
          "code" : "1004-1",
          "display" : "American Indian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14916"
            }
          ],
          "concept" : [
            {
              "code" : "1006-6",
              "display" : "Abenaki",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14917"
                }
              ]
            },
            {
              "code" : "1008-2",
              "display" : "Algonquian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14918"
                }
              ]
            },
            {
              "code" : "1010-8",
              "display" : "Apache",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14919"
                }
              ],
              "concept" : [
                {
                  "code" : "1011-6",
                  "display" : "Chiricahua",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14920"
                    }
                  ]
                },
                {
                  "code" : "1012-4",
                  "display" : "Fort Sill Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14921"
                    }
                  ]
                },
                {
                  "code" : "1013-2",
                  "display" : "Jicarilla Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14922"
                    }
                  ]
                },
                {
                  "code" : "1014-0",
                  "display" : "Lipan Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14923"
                    }
                  ]
                },
                {
                  "code" : "1015-7",
                  "display" : "Mescalero Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14924"
                    }
                  ]
                },
                {
                  "code" : "1016-5",
                  "display" : "Oklahoma Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14925"
                    }
                  ]
                },
                {
                  "code" : "1017-3",
                  "display" : "Payson Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14926"
                    }
                  ]
                },
                {
                  "code" : "1018-1",
                  "display" : "San Carlos Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14927"
                    }
                  ]
                },
                {
                  "code" : "1019-9",
                  "display" : "White Mountain Apache",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14928"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1021-5",
              "display" : "Arapaho",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14929"
                }
              ],
              "concept" : [
                {
                  "code" : "1022-3",
                  "display" : "Northern Arapaho",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14930"
                    }
                  ]
                },
                {
                  "code" : "1023-1",
                  "display" : "Southern Arapaho",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14931"
                    }
                  ]
                },
                {
                  "code" : "1024-9",
                  "display" : "Wind River Arapaho",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14932"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1026-4",
              "display" : "Arikara",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14933"
                }
              ]
            },
            {
              "code" : "1028-0",
              "display" : "Assiniboine",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14934"
                }
              ]
            },
            {
              "code" : "1030-6",
              "display" : "Assiniboine Sioux",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14935"
                }
              ],
              "concept" : [
                {
                  "code" : "1031-4",
                  "display" : "Fort Peck Assiniboine Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14936"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1033-0",
              "display" : "Bannock",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14937"
                }
              ]
            },
            {
              "code" : "1035-5",
              "display" : "Blackfeet",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14938"
                }
              ]
            },
            {
              "code" : "1037-1",
              "display" : "Brotherton",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14939"
                }
              ]
            },
            {
              "code" : "1039-7",
              "display" : "Burt Lake Band",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14940"
                }
              ]
            },
            {
              "code" : "1041-3",
              "display" : "Caddo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14941"
                }
              ],
              "concept" : [
                {
                  "code" : "1042-1",
                  "display" : "Oklahoma Cado",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14942"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1044-7",
              "display" : "Cahuilla",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14943"
                }
              ],
              "concept" : [
                {
                  "code" : "1045-4",
                  "display" : "Agua Caliente Cahuilla",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14944"
                    }
                  ]
                },
                {
                  "code" : "1046-2",
                  "display" : "Augustine",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14945"
                    }
                  ]
                },
                {
                  "code" : "1047-0",
                  "display" : "Cabazon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14946"
                    }
                  ]
                },
                {
                  "code" : "1048-8",
                  "display" : "Los Coyotes",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14947"
                    }
                  ]
                },
                {
                  "code" : "1049-6",
                  "display" : "Morongo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14948"
                    }
                  ]
                },
                {
                  "code" : "1050-4",
                  "display" : "Santa Rosa Cahuilla",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14949"
                    }
                  ]
                },
                {
                  "code" : "1051-2",
                  "display" : "Torres-Martinez",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14950"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1053-8",
              "display" : "California Tribes",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14951"
                }
              ],
              "concept" : [
                {
                  "code" : "1054-6",
                  "display" : "Cahto",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14952"
                    }
                  ]
                },
                {
                  "code" : "1055-3",
                  "display" : "Chimariko",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14953"
                    }
                  ]
                },
                {
                  "code" : "1056-1",
                  "display" : "Coast Miwok",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14954"
                    }
                  ]
                },
                {
                  "code" : "1057-9",
                  "display" : "Digger",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14955"
                    }
                  ]
                },
                {
                  "code" : "1058-7",
                  "display" : "Kawaiisu",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14956"
                    }
                  ]
                },
                {
                  "code" : "1059-5",
                  "display" : "Kern River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14957"
                    }
                  ]
                },
                {
                  "code" : "1060-3",
                  "display" : "Mattole",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14958"
                    }
                  ]
                },
                {
                  "code" : "1061-1",
                  "display" : "Red Wood",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14959"
                    }
                  ]
                },
                {
                  "code" : "1062-9",
                  "display" : "Santa Rosa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14960"
                    }
                  ]
                },
                {
                  "code" : "1063-7",
                  "display" : "Takelma",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14961"
                    }
                  ]
                },
                {
                  "code" : "1064-5",
                  "display" : "Wappo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14962"
                    }
                  ]
                },
                {
                  "code" : "1065-2",
                  "display" : "Yana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14963"
                    }
                  ]
                },
                {
                  "code" : "1066-0",
                  "display" : "Yuki",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14964"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1068-6",
              "display" : "Canadian and Latin American Indian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14965"
                }
              ],
              "concept" : [
                {
                  "code" : "1069-4",
                  "display" : "Canadian Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14966"
                    }
                  ]
                },
                {
                  "code" : "1070-2",
                  "display" : "Central American Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14967"
                    }
                  ]
                },
                {
                  "code" : "1071-0",
                  "display" : "French American Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14968"
                    }
                  ]
                },
                {
                  "code" : "1072-8",
                  "display" : "Mexican American Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14969"
                    }
                  ]
                },
                {
                  "code" : "1073-6",
                  "display" : "South American Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14970"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1074-4",
              "display" : "Spanish American Indian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14971"
                }
              ]
            },
            {
              "code" : "1076-9",
              "display" : "Catawba",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14972"
                }
              ],
              "concept" : [
                {
                  "code" : "1741-8",
                  "display" : "Alatna",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15474"
                    }
                  ]
                },
                {
                  "code" : "1742-6",
                  "display" : "Alexander",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15475"
                    }
                  ]
                },
                {
                  "code" : "1743-4",
                  "display" : "Allakaket",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15476"
                    }
                  ]
                },
                {
                  "code" : "1744-2",
                  "display" : "Alanvik",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15477"
                    }
                  ]
                },
                {
                  "code" : "1745-9",
                  "display" : "Anvik",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15478"
                    }
                  ]
                },
                {
                  "code" : "1746-7",
                  "display" : "Arctic",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15479"
                    }
                  ]
                },
                {
                  "code" : "1747-5",
                  "display" : "Beaver",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15480"
                    }
                  ]
                },
                {
                  "code" : "1748-3",
                  "display" : "Birch Creek",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15481"
                    }
                  ]
                },
                {
                  "code" : "1749-1",
                  "display" : "Cantwell",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15482"
                    }
                  ]
                },
                {
                  "code" : "1750-9",
                  "display" : "Chalkyitsik",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15483"
                    }
                  ]
                },
                {
                  "code" : "1751-7",
                  "display" : "Chickaloon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15484"
                    }
                  ]
                },
                {
                  "code" : "1752-5",
                  "display" : "Chistochina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15485"
                    }
                  ]
                },
                {
                  "code" : "1753-3",
                  "display" : "Chitina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15486"
                    }
                  ]
                },
                {
                  "code" : "1754-1",
                  "display" : "Circle",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15487"
                    }
                  ]
                },
                {
                  "code" : "1755-8",
                  "display" : "Cook Inlet",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15488"
                    }
                  ]
                },
                {
                  "code" : "1756-6",
                  "display" : "Copper Center",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15489"
                    }
                  ]
                },
                {
                  "code" : "1757-4",
                  "display" : "Copper River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15490"
                    }
                  ]
                },
                {
                  "code" : "1758-2",
                  "display" : "Dot Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15491"
                    }
                  ]
                },
                {
                  "code" : "1759-0",
                  "display" : "Doyon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15492"
                    }
                  ]
                },
                {
                  "code" : "1760-8",
                  "display" : "Eagle",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15493"
                    }
                  ]
                },
                {
                  "code" : "1761-6",
                  "display" : "Eklutna",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15494"
                    }
                  ]
                },
                {
                  "code" : "1762-4",
                  "display" : "Evansville",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15495"
                    }
                  ]
                },
                {
                  "code" : "1763-2",
                  "display" : "Fort Yukon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15496"
                    }
                  ]
                },
                {
                  "code" : "1764-0",
                  "display" : "Gakona",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15497"
                    }
                  ]
                },
                {
                  "code" : "1765-7",
                  "display" : "Galena",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15498"
                    }
                  ]
                },
                {
                  "code" : "1766-5",
                  "display" : "Grayling",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15499"
                    }
                  ]
                },
                {
                  "code" : "1767-3",
                  "display" : "Gulkana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15500"
                    }
                  ]
                },
                {
                  "code" : "1768-1",
                  "display" : "Healy Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15501"
                    }
                  ]
                },
                {
                  "code" : "1769-9",
                  "display" : "Holy Cross",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15502"
                    }
                  ]
                },
                {
                  "code" : "1770-7",
                  "display" : "Hughes",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15503"
                    }
                  ]
                },
                {
                  "code" : "1771-5",
                  "display" : "Huslia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15504"
                    }
                  ]
                },
                {
                  "code" : "1772-3",
                  "display" : "Iliamna",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15505"
                    }
                  ]
                },
                {
                  "code" : "1773-1",
                  "display" : "Kaltag",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15506"
                    }
                  ]
                },
                {
                  "code" : "1774-9",
                  "display" : "Kluti Kaah",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15507"
                    }
                  ]
                },
                {
                  "code" : "1775-6",
                  "display" : "Knik",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15508"
                    }
                  ]
                },
                {
                  "code" : "1776-4",
                  "display" : "Koyukuk",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15509"
                    }
                  ]
                },
                {
                  "code" : "1777-2",
                  "display" : "Lake Minchumina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15510"
                    }
                  ]
                },
                {
                  "code" : "1778-0",
                  "display" : "Lime",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15511"
                    }
                  ]
                },
                {
                  "code" : "1779-8",
                  "display" : "Mcgrath",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15512"
                    }
                  ]
                },
                {
                  "code" : "1780-6",
                  "display" : "Manley Hot Springs",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15513"
                    }
                  ]
                },
                {
                  "code" : "1781-4",
                  "display" : "Mentasta Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15514"
                    }
                  ]
                },
                {
                  "code" : "1782-2",
                  "display" : "Minto",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15515"
                    }
                  ]
                },
                {
                  "code" : "1783-0",
                  "display" : "Nenana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15516"
                    }
                  ]
                },
                {
                  "code" : "1784-8",
                  "display" : "Nikolai",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15517"
                    }
                  ]
                },
                {
                  "code" : "1785-5",
                  "display" : "Ninilchik",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15518"
                    }
                  ]
                },
                {
                  "code" : "1786-3",
                  "display" : "Nondalton",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15519"
                    }
                  ]
                },
                {
                  "code" : "1787-1",
                  "display" : "Northway",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15520"
                    }
                  ]
                },
                {
                  "code" : "1788-9",
                  "display" : "Nulato",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15521"
                    }
                  ]
                },
                {
                  "code" : "1789-7",
                  "display" : "Pedro Bay",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15522"
                    }
                  ]
                },
                {
                  "code" : "1790-5",
                  "display" : "Rampart",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15523"
                    }
                  ]
                },
                {
                  "code" : "1791-3",
                  "display" : "Ruby",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15524"
                    }
                  ]
                },
                {
                  "code" : "1792-1",
                  "display" : "Salamatof",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15525"
                    }
                  ]
                },
                {
                  "code" : "1793-9",
                  "display" : "Seldovia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15526"
                    }
                  ]
                },
                {
                  "code" : "1794-7",
                  "display" : "Slana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15527"
                    }
                  ]
                },
                {
                  "code" : "1795-4",
                  "display" : "Shageluk",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15528"
                    }
                  ]
                },
                {
                  "code" : "1796-2",
                  "display" : "Stevens",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15529"
                    }
                  ]
                },
                {
                  "code" : "1797-0",
                  "display" : "Stony River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15530"
                    }
                  ]
                },
                {
                  "code" : "1798-8",
                  "display" : "Takotna",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15531"
                    }
                  ]
                },
                {
                  "code" : "1799-6",
                  "display" : "Tanacross",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15532"
                    }
                  ]
                },
                {
                  "code" : "1800-2",
                  "display" : "Tanaina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15533"
                    }
                  ]
                },
                {
                  "code" : "1801-0",
                  "display" : "Tanana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15534"
                    }
                  ]
                },
                {
                  "code" : "1802-8",
                  "display" : "Tanana Chiefs",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15535"
                    }
                  ]
                },
                {
                  "code" : "1803-6",
                  "display" : "Tazlina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15536"
                    }
                  ]
                },
                {
                  "code" : "1804-4",
                  "display" : "Telida",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15537"
                    }
                  ]
                },
                {
                  "code" : "1805-1",
                  "display" : "Tetlin",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15538"
                    }
                  ]
                },
                {
                  "code" : "1806-9",
                  "display" : "Tok",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15539"
                    }
                  ]
                },
                {
                  "code" : "1807-7",
                  "display" : "Tyonek",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15540"
                    }
                  ]
                },
                {
                  "code" : "1808-5",
                  "display" : "Venetie",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15541"
                    }
                  ]
                },
                {
                  "code" : "1809-3",
                  "display" : "Wiseman",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15542"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1078-5",
              "display" : "Cayuse",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14973"
                }
              ]
            },
            {
              "code" : "1080-1",
              "display" : "Chehalis",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14974"
                }
              ]
            },
            {
              "code" : "1082-7",
              "display" : "Chemakuan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14975"
                }
              ],
              "concept" : [
                {
                  "code" : "1083-5",
                  "display" : "Hoh",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14976"
                    }
                  ]
                },
                {
                  "code" : "1084-3",
                  "display" : "Quileute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14977"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1086-8",
              "display" : "Chemehuevi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14978"
                }
              ]
            },
            {
              "code" : "1088-4",
              "display" : "Cherokee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14979"
                }
              ],
              "concept" : [
                {
                  "code" : "1089-2",
                  "display" : "Cherokee Alabama",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14980"
                    }
                  ]
                },
                {
                  "code" : "1090-0",
                  "display" : "Cherokees of Northeast Alabama",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14981"
                    }
                  ]
                },
                {
                  "code" : "1091-8",
                  "display" : "Cherokees of Southeast Alabama",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14982"
                    }
                  ]
                },
                {
                  "code" : "1092-6",
                  "display" : "Eastern Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14983"
                    }
                  ]
                },
                {
                  "code" : "1093-4",
                  "display" : "Echota Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14984"
                    }
                  ]
                },
                {
                  "code" : "1094-2",
                  "display" : "Etowah Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14985"
                    }
                  ]
                },
                {
                  "code" : "1095-9",
                  "display" : "Northern Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14986"
                    }
                  ]
                },
                {
                  "code" : "1096-7",
                  "display" : "Tuscola",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14987"
                    }
                  ]
                },
                {
                  "code" : "1097-5",
                  "display" : "United Keetowah Band of Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14988"
                    }
                  ]
                },
                {
                  "code" : "1098-3",
                  "display" : "Western Cherokee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14989"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1100-7",
              "display" : "Cherokee Shawnee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14990"
                }
              ]
            },
            {
              "code" : "1102-3",
              "display" : "Cheyenne",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14991"
                }
              ],
              "concept" : [
                {
                  "code" : "1103-1",
                  "display" : "Northern Cheyenne",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14992"
                    }
                  ]
                },
                {
                  "code" : "1104-9",
                  "display" : "Southern Cheyenne",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14993"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1106-4",
              "display" : "Cheyenne-Arapaho",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14994"
                }
              ]
            },
            {
              "code" : "1108-0",
              "display" : "Chickahominy",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14995"
                }
              ],
              "concept" : [
                {
                  "code" : "1109-8",
                  "display" : "Eastern Chickahominy",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14996"
                    }
                  ]
                },
                {
                  "code" : "1110-6",
                  "display" : "Western Chickahominy",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14997"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1112-2",
              "display" : "Chickasaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14998"
                }
              ]
            },
            {
              "code" : "1114-8",
              "display" : "Chinook",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14999"
                }
              ],
              "concept" : [
                {
                  "code" : "1115-5",
                  "display" : "Clatsop",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15000"
                    }
                  ]
                },
                {
                  "code" : "1116-3",
                  "display" : "Columbia River Chinook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15001"
                    }
                  ]
                },
                {
                  "code" : "1117-1",
                  "display" : "Kathlamet",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15002"
                    }
                  ]
                },
                {
                  "code" : "1118-9",
                  "display" : "Upper Chinook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15003"
                    }
                  ]
                },
                {
                  "code" : "1119-7",
                  "display" : "Wakiakum Chinook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15004"
                    }
                  ]
                },
                {
                  "code" : "1120-5",
                  "display" : "Willapa Chinook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15005"
                    }
                  ]
                },
                {
                  "code" : "1121-3",
                  "display" : "Wishram",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15006"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1123-9",
              "display" : "Chippewa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15007"
                }
              ],
              "concept" : [
                {
                  "code" : "1124-7",
                  "display" : "Bad River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15008"
                    }
                  ]
                },
                {
                  "code" : "1125-4",
                  "display" : "Bay Mills Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15009"
                    }
                  ]
                },
                {
                  "code" : "1126-2",
                  "display" : "Bois Forte",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15010"
                    }
                  ]
                },
                {
                  "code" : "1127-0",
                  "display" : "Burt Lake Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15011"
                    }
                  ]
                },
                {
                  "code" : "1128-8",
                  "display" : "Fond du Lac",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15012"
                    }
                  ]
                },
                {
                  "code" : "1129-6",
                  "display" : "Grand Portage",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15013"
                    }
                  ]
                },
                {
                  "code" : "1130-4",
                  "display" : "Grand Traverse Band of Ottawa-Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15014"
                    }
                  ]
                },
                {
                  "code" : "1131-2",
                  "display" : "Keweenaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15015"
                    }
                  ]
                },
                {
                  "code" : "1132-0",
                  "display" : "Lac Courte Oreilles",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15016"
                    }
                  ]
                },
                {
                  "code" : "1133-8",
                  "display" : "Lac du Flambeau",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15017"
                    }
                  ]
                },
                {
                  "code" : "1134-6",
                  "display" : "Lac Vieux Desert Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15018"
                    }
                  ]
                },
                {
                  "code" : "1135-3",
                  "display" : "Lake Superior",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15019"
                    }
                  ]
                },
                {
                  "code" : "1136-1",
                  "display" : "Leech Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15020"
                    }
                  ]
                },
                {
                  "code" : "1137-9",
                  "display" : "Little Shell Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15021"
                    }
                  ]
                },
                {
                  "code" : "1138-7",
                  "display" : "Mille Lacs",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15022"
                    }
                  ]
                },
                {
                  "code" : "1139-5",
                  "display" : "Minnesota Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15023"
                    }
                  ]
                },
                {
                  "code" : "1140-3",
                  "display" : "Ontonagon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15024"
                    }
                  ]
                },
                {
                  "code" : "1141-1",
                  "display" : "Red Cliff Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15025"
                    }
                  ]
                },
                {
                  "code" : "1142-9",
                  "display" : "Red Lake Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15026"
                    }
                  ]
                },
                {
                  "code" : "1143-7",
                  "display" : "Saginaw Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15027"
                    }
                  ]
                },
                {
                  "code" : "1144-5",
                  "display" : "St. Croix Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15028"
                    }
                  ]
                },
                {
                  "code" : "1145-2",
                  "display" : "Sault Ste. Marie Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15029"
                    }
                  ]
                },
                {
                  "code" : "1146-0",
                  "display" : "Sokoagon Chippewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15030"
                    }
                  ]
                },
                {
                  "code" : "1147-8",
                  "display" : "Turtle Mountain",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15031"
                    }
                  ]
                },
                {
                  "code" : "1148-6",
                  "display" : "White Earth",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15032"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1150-2",
              "display" : "Chippewa Cree",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15033"
                }
              ],
              "concept" : [
                {
                  "code" : "1151-0",
                  "display" : "Rocky Boy's Chippewa Cree",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15034"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1153-6",
              "display" : "Chitimacha",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15035"
                }
              ]
            },
            {
              "code" : "1155-1",
              "display" : "Choctaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15036"
                }
              ],
              "concept" : [
                {
                  "code" : "1156-9",
                  "display" : "Clifton Choctaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15037"
                    }
                  ]
                },
                {
                  "code" : "1157-7",
                  "display" : "Jena Choctaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15038"
                    }
                  ]
                },
                {
                  "code" : "1158-5",
                  "display" : "Mississippi Choctaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15039"
                    }
                  ]
                },
                {
                  "code" : "1159-3",
                  "display" : "Mowa Band of Choctaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15040"
                    }
                  ]
                },
                {
                  "code" : "1160-1",
                  "display" : "Oklahoma Choctaw",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15041"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1162-7",
              "display" : "Chumash",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15042"
                }
              ],
              "concept" : [
                {
                  "code" : "1163-5",
                  "display" : "Santa Ynez",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15043"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1165-0",
              "display" : "Clear Lake",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15044"
                }
              ]
            },
            {
              "code" : "1167-6",
              "display" : "Coeur D'Alene",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15045"
                }
              ]
            },
            {
              "code" : "1169-2",
              "display" : "Coharie",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15046"
                }
              ]
            },
            {
              "code" : "1171-8",
              "display" : "Colorado River",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15047"
                }
              ]
            },
            {
              "code" : "1173-4",
              "display" : "Colville",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15048"
                }
              ]
            },
            {
              "code" : "1175-9",
              "display" : "Comanche",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15049"
                }
              ],
              "concept" : [
                {
                  "code" : "1176-7",
                  "display" : "Oklahoma Comanche",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15050"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1178-3",
              "display" : "Coos, Lower Umpqua, Siuslaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15051"
                }
              ]
            },
            {
              "code" : "1180-9",
              "display" : "Coos",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15052"
                }
              ]
            },
            {
              "code" : "1182-5",
              "display" : "Coquilles",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15053"
                }
              ]
            },
            {
              "code" : "1184-1",
              "display" : "Costanoan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15054"
                }
              ]
            },
            {
              "code" : "1186-6",
              "display" : "Coushatta",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15055"
                }
              ],
              "concept" : [
                {
                  "code" : "1187-4",
                  "display" : "Alabama Coushatta",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15056"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1189-0",
              "display" : "Cowlitz",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15057"
                }
              ]
            },
            {
              "code" : "1191-6",
              "display" : "Cree",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15058"
                }
              ]
            },
            {
              "code" : "1193-2",
              "display" : "Creek",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15059"
                }
              ],
              "concept" : [
                {
                  "code" : "1194-0",
                  "display" : "Alabama Creek",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15060"
                    }
                  ]
                },
                {
                  "code" : "1195-7",
                  "display" : "Alabama Quassarte",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15061"
                    }
                  ]
                },
                {
                  "code" : "1196-5",
                  "display" : "Eastern Creek",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15062"
                    }
                  ]
                },
                {
                  "code" : "1197-3",
                  "display" : "Eastern Muscogee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15063"
                    }
                  ]
                },
                {
                  "code" : "1198-1",
                  "display" : "Kialegee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15064"
                    }
                  ]
                },
                {
                  "code" : "1199-9",
                  "display" : "Lower Muscogee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15065"
                    }
                  ]
                },
                {
                  "code" : "1200-5",
                  "display" : "Machis Lower Creek Indian",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15066"
                    }
                  ]
                },
                {
                  "code" : "1201-3",
                  "display" : "Poarch Band",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15067"
                    }
                  ]
                },
                {
                  "code" : "1202-1",
                  "display" : "Principal Creek Indian Nation",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15068"
                    }
                  ]
                },
                {
                  "code" : "1203-9",
                  "display" : "Star Clan of Muscogee Creeks",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15069"
                    }
                  ]
                },
                {
                  "code" : "1204-7",
                  "display" : "Thlopthlocco",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15070"
                    }
                  ]
                },
                {
                  "code" : "1205-4",
                  "display" : "Tuckabachee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15071"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1207-0",
              "display" : "Croatan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15072"
                }
              ]
            },
            {
              "code" : "1209-6",
              "display" : "Crow",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15073"
                }
              ]
            },
            {
              "code" : "1211-2",
              "display" : "Cupeno",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15074"
                }
              ],
              "concept" : [
                {
                  "code" : "1212-0",
                  "display" : "Agua Caliente",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15075"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1214-6",
              "display" : "Delaware",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15076"
                }
              ],
              "concept" : [
                {
                  "code" : "1215-3",
                  "display" : "Eastern Delaware",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15077"
                    }
                  ]
                },
                {
                  "code" : "1216-1",
                  "display" : "Lenni-Lenape",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15078"
                    }
                  ]
                },
                {
                  "code" : "1217-9",
                  "display" : "Munsee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15079"
                    }
                  ]
                },
                {
                  "code" : "1218-7",
                  "display" : "Oklahoma Delaware",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15080"
                    }
                  ]
                },
                {
                  "code" : "1219-5",
                  "display" : "Rampough Mountain",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15081"
                    }
                  ]
                },
                {
                  "code" : "1220-3",
                  "display" : "Sand Hill",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15082"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1222-9",
              "display" : "Diegueno",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15083"
                }
              ],
              "concept" : [
                {
                  "code" : "1223-7",
                  "display" : "Campo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15084"
                    }
                  ]
                },
                {
                  "code" : "1224-5",
                  "display" : "Capitan Grande",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15085"
                    }
                  ]
                },
                {
                  "code" : "1225-2",
                  "display" : "Cuyapaipe",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15086"
                    }
                  ]
                },
                {
                  "code" : "1226-0",
                  "display" : "La Posta",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15087"
                    }
                  ]
                },
                {
                  "code" : "1227-8",
                  "display" : "Manzanita",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15088"
                    }
                  ]
                },
                {
                  "code" : "1228-6",
                  "display" : "Mesa Grande",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15089"
                    }
                  ]
                },
                {
                  "code" : "1229-4",
                  "display" : "San Pasqual",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15090"
                    }
                  ]
                },
                {
                  "code" : "1230-2",
                  "display" : "Santa Ysabel",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15091"
                    }
                  ]
                },
                {
                  "code" : "1231-0",
                  "display" : "Sycuan",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15092"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1233-6",
              "display" : "Eastern Tribes",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15093"
                }
              ],
              "concept" : [
                {
                  "code" : "1234-4",
                  "display" : "Attacapa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15094"
                    }
                  ]
                },
                {
                  "code" : "1235-1",
                  "display" : "Biloxi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15095"
                    }
                  ]
                },
                {
                  "code" : "1236-9",
                  "display" : "Georgetown",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15096"
                    }
                  ]
                },
                {
                  "code" : "1237-7",
                  "display" : "Moor",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15097"
                    }
                  ]
                },
                {
                  "code" : "1238-5",
                  "display" : "Nansemond",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15098"
                    }
                  ]
                },
                {
                  "code" : "1239-3",
                  "display" : "Natchez",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15099"
                    }
                  ]
                },
                {
                  "code" : "1240-1",
                  "display" : "Nausu Waiwash",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15100"
                    }
                  ]
                },
                {
                  "code" : "1241-9",
                  "display" : "Nipmuc",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15101"
                    }
                  ]
                },
                {
                  "code" : "1242-7",
                  "display" : "Paugussett",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15102"
                    }
                  ]
                },
                {
                  "code" : "1243-5",
                  "display" : "Pocomoke Acohonock",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15103"
                    }
                  ]
                },
                {
                  "code" : "1244-3",
                  "display" : "Southeastern Indians",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15104"
                    }
                  ]
                },
                {
                  "code" : "1245-0",
                  "display" : "Susquehanock",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15105"
                    }
                  ]
                },
                {
                  "code" : "1246-8",
                  "display" : "Tunica Biloxi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15106"
                    }
                  ]
                },
                {
                  "code" : "1247-6",
                  "display" : "Waccamaw-Siousan",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15107"
                    }
                  ]
                },
                {
                  "code" : "1248-4",
                  "display" : "Wicomico",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15108"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1250-0",
              "display" : "Esselen",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15109"
                }
              ]
            },
            {
              "code" : "1252-6",
              "display" : "Fort Belknap",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15110"
                }
              ]
            },
            {
              "code" : "1254-2",
              "display" : "Fort Berthold",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15111"
                }
              ]
            },
            {
              "code" : "1256-7",
              "display" : "Fort Mcdowell",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15112"
                }
              ]
            },
            {
              "code" : "1258-3",
              "display" : "Fort Hall",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15113"
                }
              ]
            },
            {
              "code" : "1260-9",
              "display" : "Gabrieleno",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15114"
                }
              ]
            },
            {
              "code" : "1262-5",
              "display" : "Grand Ronde",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15115"
                }
              ]
            },
            {
              "code" : "1264-1",
              "display" : "Gros Ventres",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15116"
                }
              ],
              "concept" : [
                {
                  "code" : "1265-8",
                  "display" : "Atsina",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15117"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1267-4",
              "display" : "Haliwa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15118"
                }
              ]
            },
            {
              "code" : "1269-0",
              "display" : "Hidatsa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15119"
                }
              ]
            },
            {
              "code" : "1271-6",
              "display" : "Hoopa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15120"
                }
              ],
              "concept" : [
                {
                  "code" : "1272-4",
                  "display" : "Trinity",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15121"
                    }
                  ]
                },
                {
                  "code" : "1273-2",
                  "display" : "Whilkut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15122"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1275-7",
              "display" : "Hoopa Extension",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15123"
                }
              ]
            },
            {
              "code" : "1277-3",
              "display" : "Houma",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15124"
                }
              ]
            },
            {
              "code" : "1279-9",
              "display" : "Inaja-Cosmit",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15125"
                }
              ]
            },
            {
              "code" : "1281-5",
              "display" : "Iowa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15126"
                }
              ],
              "concept" : [
                {
                  "code" : "1282-3",
                  "display" : "Iowa of Kansas-Nebraska",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15127"
                    }
                  ]
                },
                {
                  "code" : "1283-1",
                  "display" : "Iowa of Oklahoma",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15128"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1285-6",
              "display" : "Iroquois",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15129"
                }
              ],
              "concept" : [
                {
                  "code" : "1286-4",
                  "display" : "Cayuga",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15130"
                    }
                  ]
                },
                {
                  "code" : "1287-2",
                  "display" : "Mohawk",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15131"
                    }
                  ]
                },
                {
                  "code" : "1288-0",
                  "display" : "Oneida",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15132"
                    }
                  ]
                },
                {
                  "code" : "1289-8",
                  "display" : "Onondaga",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15133"
                    }
                  ]
                },
                {
                  "code" : "1290-6",
                  "display" : "Seneca",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15134"
                    }
                  ]
                },
                {
                  "code" : "1291-4",
                  "display" : "Seneca Nation",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15135"
                    }
                  ]
                },
                {
                  "code" : "1292-2",
                  "display" : "Seneca-Cayuga",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15136"
                    }
                  ]
                },
                {
                  "code" : "1293-0",
                  "display" : "Tonawanda Seneca",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15137"
                    }
                  ]
                },
                {
                  "code" : "1294-8",
                  "display" : "Tuscarora",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15138"
                    }
                  ]
                },
                {
                  "code" : "1295-5",
                  "display" : "Wyandotte",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15139"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1297-1",
              "display" : "Juaneno",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15140"
                }
              ]
            },
            {
              "code" : "1299-7",
              "display" : "Kalispel",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15141"
                }
              ]
            },
            {
              "code" : "1301-1",
              "display" : "Karuk",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15142"
                }
              ]
            },
            {
              "code" : "1303-7",
              "display" : "Kaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15143"
                }
              ]
            },
            {
              "code" : "1305-2",
              "display" : "Kickapoo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15144"
                }
              ],
              "concept" : [
                {
                  "code" : "1306-0",
                  "display" : "Oklahoma Kickapoo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15145"
                    }
                  ]
                },
                {
                  "code" : "1307-8",
                  "display" : "Texas Kickapoo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15146"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1309-4",
              "display" : "Kiowa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15147"
                }
              ],
              "concept" : [
                {
                  "code" : "1310-2",
                  "display" : "Oklahoma Kiowa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15148"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1312-8",
              "display" : "Klallam",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15149"
                }
              ],
              "concept" : [
                {
                  "code" : "1313-6",
                  "display" : "Jamestown",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15150"
                    }
                  ]
                },
                {
                  "code" : "1314-4",
                  "display" : "Lower Elwha",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15151"
                    }
                  ]
                },
                {
                  "code" : "1315-1",
                  "display" : "Port Gamble Klallam",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15152"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1317-7",
              "display" : "Klamath",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15153"
                }
              ]
            },
            {
              "code" : "1319-3",
              "display" : "Konkow",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15154"
                }
              ]
            },
            {
              "code" : "1321-9",
              "display" : "Kootenai",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15155"
                }
              ]
            },
            {
              "code" : "1323-5",
              "display" : "Lassik",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15156"
                }
              ]
            },
            {
              "code" : "1325-0",
              "display" : "Long Island",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15157"
                }
              ],
              "concept" : [
                {
                  "code" : "1326-8",
                  "display" : "Matinecock",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15158"
                    }
                  ]
                },
                {
                  "code" : "1327-6",
                  "display" : "Montauk",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15159"
                    }
                  ]
                },
                {
                  "code" : "1328-4",
                  "display" : "Poospatuck",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15160"
                    }
                  ]
                },
                {
                  "code" : "1329-2",
                  "display" : "Setauket",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15161"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1331-8",
              "display" : "Luiseno",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15162"
                }
              ],
              "concept" : [
                {
                  "code" : "1332-6",
                  "display" : "La Jolla",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15163"
                    }
                  ]
                },
                {
                  "code" : "1333-4",
                  "display" : "Pala",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15164"
                    }
                  ]
                },
                {
                  "code" : "1334-2",
                  "display" : "Pauma",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15165"
                    }
                  ]
                },
                {
                  "code" : "1335-9",
                  "display" : "Pechanga",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15166"
                    }
                  ]
                },
                {
                  "code" : "1336-7",
                  "display" : "Soboba",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15167"
                    }
                  ]
                },
                {
                  "code" : "1337-5",
                  "display" : "Twenty-Nine Palms",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15168"
                    }
                  ]
                },
                {
                  "code" : "1338-3",
                  "display" : "Temecula",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15169"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1340-9",
              "display" : "Lumbee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15170"
                }
              ]
            },
            {
              "code" : "1342-5",
              "display" : "Lummi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15171"
                }
              ]
            },
            {
              "code" : "1344-1",
              "display" : "Maidu",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15172"
                }
              ],
              "concept" : [
                {
                  "code" : "1345-8",
                  "display" : "Mountain Maidu",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15173"
                    }
                  ]
                },
                {
                  "code" : "1346-6",
                  "display" : "Nishinam",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15174"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1348-2",
              "display" : "Makah",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15175"
                }
              ]
            },
            {
              "code" : "1350-8",
              "display" : "Maliseet",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15176"
                }
              ]
            },
            {
              "code" : "1352-4",
              "display" : "Mandan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15177"
                }
              ]
            },
            {
              "code" : "1354-0",
              "display" : "Mattaponi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15178"
                }
              ]
            },
            {
              "code" : "1356-5",
              "display" : "Menominee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15179"
                }
              ]
            },
            {
              "code" : "1358-1",
              "display" : "Miami",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15180"
                }
              ],
              "concept" : [
                {
                  "code" : "1359-9",
                  "display" : "Illinois Miami",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15181"
                    }
                  ]
                },
                {
                  "code" : "1360-7",
                  "display" : "Indiana Miami",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15182"
                    }
                  ]
                },
                {
                  "code" : "1361-5",
                  "display" : "Oklahoma Miami",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15183"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1363-1",
              "display" : "Miccosukee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15184"
                }
              ]
            },
            {
              "code" : "1365-6",
              "display" : "Micmac",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15185"
                }
              ],
              "concept" : [
                {
                  "code" : "1366-4",
                  "display" : "Aroostook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15186"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1368-0",
              "display" : "Mission Indians",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15187"
                }
              ]
            },
            {
              "code" : "1370-6",
              "display" : "Miwok",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15188"
                }
              ]
            },
            {
              "code" : "1372-2",
              "display" : "Modoc",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15189"
                }
              ]
            },
            {
              "code" : "1374-8",
              "display" : "Mohegan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15190"
                }
              ]
            },
            {
              "code" : "1376-3",
              "display" : "Mono",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15191"
                }
              ]
            },
            {
              "code" : "1378-9",
              "display" : "Nanticoke",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15192"
                }
              ]
            },
            {
              "code" : "1380-5",
              "display" : "Narragansett",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15193"
                }
              ]
            },
            {
              "code" : "1382-1",
              "display" : "Navajo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15194"
                }
              ],
              "concept" : [
                {
                  "code" : "1383-9",
                  "display" : "Alamo Navajo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15195"
                    }
                  ]
                },
                {
                  "code" : "1384-7",
                  "display" : "Canoncito Navajo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15196"
                    }
                  ]
                },
                {
                  "code" : "1385-4",
                  "display" : "Ramah Navajo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15197"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1387-0",
              "display" : "Nez Perce",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15198"
                }
              ]
            },
            {
              "code" : "1389-6",
              "display" : "Nomalaki",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15199"
                }
              ]
            },
            {
              "code" : "1391-2",
              "display" : "Northwest Tribes",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15200"
                }
              ],
              "concept" : [
                {
                  "code" : "1392-0",
                  "display" : "Alsea",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15201"
                    }
                  ]
                },
                {
                  "code" : "1393-8",
                  "display" : "Celilo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15202"
                    }
                  ]
                },
                {
                  "code" : "1394-6",
                  "display" : "Columbia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15203"
                    }
                  ]
                },
                {
                  "code" : "1395-3",
                  "display" : "Kalapuya",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15204"
                    }
                  ]
                },
                {
                  "code" : "1396-1",
                  "display" : "Molala",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15205"
                    }
                  ]
                },
                {
                  "code" : "1397-9",
                  "display" : "Talakamish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15206"
                    }
                  ]
                },
                {
                  "code" : "1398-7",
                  "display" : "Tenino",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15207"
                    }
                  ]
                },
                {
                  "code" : "1399-5",
                  "display" : "Tillamook",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15208"
                    }
                  ]
                },
                {
                  "code" : "1400-1",
                  "display" : "Wenatchee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15209"
                    }
                  ]
                },
                {
                  "code" : "1401-9",
                  "display" : "Yahooskin",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15210"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1403-5",
              "display" : "Omaha",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15211"
                }
              ]
            },
            {
              "code" : "1405-0",
              "display" : "Oregon Athabaskan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15212"
                }
              ]
            },
            {
              "code" : "1407-6",
              "display" : "Osage",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15213"
                }
              ]
            },
            {
              "code" : "1409-2",
              "display" : "Otoe-Missouria",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15214"
                }
              ]
            },
            {
              "code" : "1411-8",
              "display" : "Ottawa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15215"
                }
              ],
              "concept" : [
                {
                  "code" : "1412-6",
                  "display" : "Burt Lake Ottawa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15216"
                    }
                  ]
                },
                {
                  "code" : "1413-4",
                  "display" : "Michigan Ottawa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15217"
                    }
                  ]
                },
                {
                  "code" : "1414-2",
                  "display" : "Oklahoma Ottawa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15218"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1416-7",
              "display" : "Paiute",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15219"
                }
              ],
              "concept" : [
                {
                  "code" : "1417-5",
                  "display" : "Bishop",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15220"
                    }
                  ]
                },
                {
                  "code" : "1418-3",
                  "display" : "Bridgeport",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15221"
                    }
                  ]
                },
                {
                  "code" : "1419-1",
                  "display" : "Burns Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15222"
                    }
                  ]
                },
                {
                  "code" : "1420-9",
                  "display" : "Cedarville",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15223"
                    }
                  ]
                },
                {
                  "code" : "1421-7",
                  "display" : "Fort Bidwell",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15224"
                    }
                  ]
                },
                {
                  "code" : "1422-5",
                  "display" : "Fort Independence",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15225"
                    }
                  ]
                },
                {
                  "code" : "1423-3",
                  "display" : "Kaibab",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15226"
                    }
                  ]
                },
                {
                  "code" : "1424-1",
                  "display" : "Las Vegas",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15227"
                    }
                  ]
                },
                {
                  "code" : "1425-8",
                  "display" : "Lone Pine",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15228"
                    }
                  ]
                },
                {
                  "code" : "1426-6",
                  "display" : "Lovelock",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15229"
                    }
                  ]
                },
                {
                  "code" : "1427-4",
                  "display" : "Malheur Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15230"
                    }
                  ]
                },
                {
                  "code" : "1428-2",
                  "display" : "Moapa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15231"
                    }
                  ]
                },
                {
                  "code" : "1429-0",
                  "display" : "Northern Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15232"
                    }
                  ]
                },
                {
                  "code" : "1430-8",
                  "display" : "Owens Valley",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15233"
                    }
                  ]
                },
                {
                  "code" : "1431-6",
                  "display" : "Pyramid Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15234"
                    }
                  ]
                },
                {
                  "code" : "1432-4",
                  "display" : "San Juan Southern Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15235"
                    }
                  ]
                },
                {
                  "code" : "1433-2",
                  "display" : "Southern Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15236"
                    }
                  ]
                },
                {
                  "code" : "1434-0",
                  "display" : "Summit Lake",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15237"
                    }
                  ]
                },
                {
                  "code" : "1435-7",
                  "display" : "Utu Utu Gwaitu Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15238"
                    }
                  ]
                },
                {
                  "code" : "1436-5",
                  "display" : "Walker River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15239"
                    }
                  ]
                },
                {
                  "code" : "1437-3",
                  "display" : "Yerington Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15240"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1439-9",
              "display" : "Pamunkey",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15241"
                }
              ]
            },
            {
              "code" : "1441-5",
              "display" : "Passamaquoddy",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15242"
                }
              ],
              "concept" : [
                {
                  "code" : "1442-3",
                  "display" : "Indian Township",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15243"
                    }
                  ]
                },
                {
                  "code" : "1443-1",
                  "display" : "Pleasant Point Passamaquoddy",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15244"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1445-6",
              "display" : "Pawnee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15245"
                }
              ],
              "concept" : [
                {
                  "code" : "1446-4",
                  "display" : "Oklahoma Pawnee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15246"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1448-0",
              "display" : "Penobscot",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15247"
                }
              ]
            },
            {
              "code" : "1450-6",
              "display" : "Peoria",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15248"
                }
              ],
              "concept" : [
                {
                  "code" : "1451-4",
                  "display" : "Oklahoma Peoria",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15249"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1453-0",
              "display" : "Pequot",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15250"
                }
              ],
              "concept" : [
                {
                  "code" : "1454-8",
                  "display" : "Marshantucket Pequot",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15251"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1456-3",
              "display" : "Pima",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15252"
                }
              ],
              "concept" : [
                {
                  "code" : "1457-1",
                  "display" : "Gila River Pima-Maricopa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15253"
                    }
                  ]
                },
                {
                  "code" : "1458-9",
                  "display" : "Salt River Pima-Maricopa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15254"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1460-5",
              "display" : "Piscataway",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15255"
                }
              ]
            },
            {
              "code" : "1462-1",
              "display" : "Pit River",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15256"
                }
              ]
            },
            {
              "code" : "1464-7",
              "display" : "Pomo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15257"
                }
              ],
              "concept" : [
                {
                  "code" : "1465-4",
                  "display" : "Central Pomo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15258"
                    }
                  ]
                },
                {
                  "code" : "1466-2",
                  "display" : "Dry Creek",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15259"
                    }
                  ]
                },
                {
                  "code" : "1467-0",
                  "display" : "Eastern Pomo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15260"
                    }
                  ]
                },
                {
                  "code" : "1468-8",
                  "display" : "Kashia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15261"
                    }
                  ]
                },
                {
                  "code" : "1469-6",
                  "display" : "Northern Pomo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15262"
                    }
                  ]
                },
                {
                  "code" : "1470-4",
                  "display" : "Scotts Valley",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15263"
                    }
                  ]
                },
                {
                  "code" : "1471-2",
                  "display" : "Stonyford",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15264"
                    }
                  ]
                },
                {
                  "code" : "1472-0",
                  "display" : "Sulphur Bank",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15265"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1474-6",
              "display" : "Ponca",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15266"
                }
              ],
              "concept" : [
                {
                  "code" : "1475-3",
                  "display" : "Nebraska Ponca",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15267"
                    }
                  ]
                },
                {
                  "code" : "1476-1",
                  "display" : "Oklahoma Ponca",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15268"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1478-7",
              "display" : "Potawatomi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15269"
                }
              ],
              "concept" : [
                {
                  "code" : "1479-5",
                  "display" : "Citizen Band Potawatomi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15270"
                    }
                  ]
                },
                {
                  "code" : "1480-3",
                  "display" : "Forest County",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15271"
                    }
                  ]
                },
                {
                  "code" : "1481-1",
                  "display" : "Hannahville",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15272"
                    }
                  ]
                },
                {
                  "code" : "1482-9",
                  "display" : "Huron Potawatomi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15273"
                    }
                  ]
                },
                {
                  "code" : "1483-7",
                  "display" : "Pokagon Potawatomi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15274"
                    }
                  ]
                },
                {
                  "code" : "1484-5",
                  "display" : "Prairie Band",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15275"
                    }
                  ]
                },
                {
                  "code" : "1485-2",
                  "display" : "Wisconsin Potawatomi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15276"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1487-8",
              "display" : "Powhatan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15277"
                }
              ]
            },
            {
              "code" : "1489-4",
              "display" : "Pueblo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15278"
                }
              ],
              "concept" : [
                {
                  "code" : "1490-2",
                  "display" : "Acoma",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15279"
                    }
                  ]
                },
                {
                  "code" : "1491-0",
                  "display" : "Arizona Tewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15280"
                    }
                  ]
                },
                {
                  "code" : "1492-8",
                  "display" : "Cochiti",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15281"
                    }
                  ]
                },
                {
                  "code" : "1493-6",
                  "display" : "Hopi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15282"
                    }
                  ]
                },
                {
                  "code" : "1494-4",
                  "display" : "Isleta",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15283"
                    }
                  ]
                },
                {
                  "code" : "1495-1",
                  "display" : "Jemez",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15284"
                    }
                  ]
                },
                {
                  "code" : "1496-9",
                  "display" : "Keres",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15285"
                    }
                  ]
                },
                {
                  "code" : "1497-7",
                  "display" : "Laguna",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15286"
                    }
                  ]
                },
                {
                  "code" : "1498-5",
                  "display" : "Nambe",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15287"
                    }
                  ]
                },
                {
                  "code" : "1499-3",
                  "display" : "Picuris",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15288"
                    }
                  ]
                },
                {
                  "code" : "1500-8",
                  "display" : "Piro",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15289"
                    }
                  ]
                },
                {
                  "code" : "1501-6",
                  "display" : "Pojoaque",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15290"
                    }
                  ]
                },
                {
                  "code" : "1502-4",
                  "display" : "San Felipe",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15291"
                    }
                  ]
                },
                {
                  "code" : "1503-2",
                  "display" : "San Ildefonso",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15292"
                    }
                  ]
                },
                {
                  "code" : "1504-0",
                  "display" : "San Juan Pueblo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15293"
                    }
                  ]
                },
                {
                  "code" : "1505-7",
                  "display" : "San Juan De",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15294"
                    }
                  ]
                },
                {
                  "code" : "1506-5",
                  "display" : "San Juan",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15295"
                    }
                  ]
                },
                {
                  "code" : "1507-3",
                  "display" : "Sandia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15296"
                    }
                  ]
                },
                {
                  "code" : "1508-1",
                  "display" : "Santa Ana",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15297"
                    }
                  ]
                },
                {
                  "code" : "1509-9",
                  "display" : "Santa Clara",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15298"
                    }
                  ]
                },
                {
                  "code" : "1510-7",
                  "display" : "Santo Domingo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15299"
                    }
                  ]
                },
                {
                  "code" : "1511-5",
                  "display" : "Taos",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15300"
                    }
                  ]
                },
                {
                  "code" : "1512-3",
                  "display" : "Tesuque",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15301"
                    }
                  ]
                },
                {
                  "code" : "1513-1",
                  "display" : "Tewa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15302"
                    }
                  ]
                },
                {
                  "code" : "1514-9",
                  "display" : "Tigua",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15303"
                    }
                  ]
                },
                {
                  "code" : "1515-6",
                  "display" : "Zia",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15304"
                    }
                  ]
                },
                {
                  "code" : "1516-4",
                  "display" : "Zuni",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15305"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1518-0",
              "display" : "Puget Sound Salish",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15306"
                }
              ],
              "concept" : [
                {
                  "code" : "1519-8",
                  "display" : "Duwamish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15307"
                    }
                  ]
                },
                {
                  "code" : "1520-6",
                  "display" : "Kikiallus",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15308"
                    }
                  ]
                },
                {
                  "code" : "1521-4",
                  "display" : "Lower Skagit",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15309"
                    }
                  ]
                },
                {
                  "code" : "1522-2",
                  "display" : "Muckleshoot",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15310"
                    }
                  ]
                },
                {
                  "code" : "1523-0",
                  "display" : "Nisqually",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15311"
                    }
                  ]
                },
                {
                  "code" : "1524-8",
                  "display" : "Nooksack",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15312"
                    }
                  ]
                },
                {
                  "code" : "1525-5",
                  "display" : "Port Madison",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15313"
                    }
                  ]
                },
                {
                  "code" : "1526-3",
                  "display" : "Puyallup",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15314"
                    }
                  ]
                },
                {
                  "code" : "1527-1",
                  "display" : "Samish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15315"
                    }
                  ]
                },
                {
                  "code" : "1528-9",
                  "display" : "Sauk-Suiattle",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15316"
                    }
                  ]
                },
                {
                  "code" : "1529-7",
                  "display" : "Skokomish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15317"
                    }
                  ]
                },
                {
                  "code" : "1530-5",
                  "display" : "Skykomish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15318"
                    }
                  ]
                },
                {
                  "code" : "1531-3",
                  "display" : "Snohomish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15319"
                    }
                  ]
                },
                {
                  "code" : "1532-1",
                  "display" : "Snoqualmie",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15320"
                    }
                  ]
                },
                {
                  "code" : "1533-9",
                  "display" : "Squaxin Island",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15321"
                    }
                  ]
                },
                {
                  "code" : "1534-7",
                  "display" : "Steilacoom",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15322"
                    }
                  ]
                },
                {
                  "code" : "1535-4",
                  "display" : "Stillaguamish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15323"
                    }
                  ]
                },
                {
                  "code" : "1536-2",
                  "display" : "Suquamish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15324"
                    }
                  ]
                },
                {
                  "code" : "1537-0",
                  "display" : "Swinomish",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15325"
                    }
                  ]
                },
                {
                  "code" : "1538-8",
                  "display" : "Tulalip",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15326"
                    }
                  ]
                },
                {
                  "code" : "1539-6",
                  "display" : "Upper Skagit",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15327"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1541-2",
              "display" : "Quapaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15328"
                }
              ]
            },
            {
              "code" : "1543-8",
              "display" : "Quinault",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15329"
                }
              ]
            },
            {
              "code" : "1545-3",
              "display" : "Rappahannock",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15330"
                }
              ]
            },
            {
              "code" : "1547-9",
              "display" : "Reno-Sparks",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15331"
                }
              ]
            },
            {
              "code" : "1549-5",
              "display" : "Round Valley",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15332"
                }
              ]
            },
            {
              "code" : "1551-1",
              "display" : "Sac and Fox",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15333"
                }
              ],
              "concept" : [
                {
                  "code" : "1552-9",
                  "display" : "Iowa Sac and Fox",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15334"
                    }
                  ]
                },
                {
                  "code" : "1553-7",
                  "display" : "Missouri Sac and Fox",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15335"
                    }
                  ]
                },
                {
                  "code" : "1554-5",
                  "display" : "Oklahoma Sac and Fox",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15336"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1556-0",
              "display" : "Salinan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15337"
                }
              ]
            },
            {
              "code" : "1558-6",
              "display" : "Salish",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15338"
                }
              ]
            },
            {
              "code" : "1560-2",
              "display" : "Salish and Kootenai",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15339"
                }
              ]
            },
            {
              "code" : "1562-8",
              "display" : "Schaghticoke",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15340"
                }
              ]
            },
            {
              "code" : "1564-4",
              "display" : "Scott Valley",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15341"
                }
              ]
            },
            {
              "code" : "1566-9",
              "display" : "Seminole",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15342"
                }
              ],
              "concept" : [
                {
                  "code" : "1567-7",
                  "display" : "Big Cypress",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15343"
                    }
                  ]
                },
                {
                  "code" : "1568-5",
                  "display" : "Brighton",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15344"
                    }
                  ]
                },
                {
                  "code" : "1569-3",
                  "display" : "Florida Seminole",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15345"
                    }
                  ]
                },
                {
                  "code" : "1570-1",
                  "display" : "Hollywood Seminole",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15346"
                    }
                  ]
                },
                {
                  "code" : "1571-9",
                  "display" : "Oklahoma Seminole",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15347"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1573-5",
              "display" : "Serrano",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15348"
                }
              ],
              "concept" : [
                {
                  "code" : "1574-3",
                  "display" : "San Manual",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15349"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1576-8",
              "display" : "Shasta",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15350"
                }
              ]
            },
            {
              "code" : "1578-4",
              "display" : "Shawnee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15351"
                }
              ],
              "concept" : [
                {
                  "code" : "1579-2",
                  "display" : "Absentee Shawnee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15352"
                    }
                  ]
                },
                {
                  "code" : "1580-0",
                  "display" : "Eastern Shawnee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15353"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1582-6",
              "display" : "Shinnecock",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15354"
                }
              ]
            },
            {
              "code" : "1584-2",
              "display" : "Shoalwater Bay",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15355"
                }
              ]
            },
            {
              "code" : "1586-7",
              "display" : "Shoshone",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15356"
                }
              ],
              "concept" : [
                {
                  "code" : "1587-5",
                  "display" : "Battle Mountain",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15357"
                    }
                  ]
                },
                {
                  "code" : "1588-3",
                  "display" : "Duckwater",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15358"
                    }
                  ]
                },
                {
                  "code" : "1589-1",
                  "display" : "Elko",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15359"
                    }
                  ]
                },
                {
                  "code" : "1590-9",
                  "display" : "Ely",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15360"
                    }
                  ]
                },
                {
                  "code" : "1591-7",
                  "display" : "Goshute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15361"
                    }
                  ]
                },
                {
                  "code" : "1592-5",
                  "display" : "Panamint",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15362"
                    }
                  ]
                },
                {
                  "code" : "1593-3",
                  "display" : "Ruby Valley",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15363"
                    }
                  ]
                },
                {
                  "code" : "1594-1",
                  "display" : "Skull Valley",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15364"
                    }
                  ]
                },
                {
                  "code" : "1595-8",
                  "display" : "South Fork Shoshone",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15365"
                    }
                  ]
                },
                {
                  "code" : "1596-6",
                  "display" : "Te-Moak Western Shoshone",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15366"
                    }
                  ]
                },
                {
                  "code" : "1597-4",
                  "display" : "Timbi-Sha Shoshone",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15367"
                    }
                  ]
                },
                {
                  "code" : "1598-2",
                  "display" : "Washakie",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15368"
                    }
                  ]
                },
                {
                  "code" : "1599-0",
                  "display" : "Wind River Shoshone",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15369"
                    }
                  ]
                },
                {
                  "code" : "1600-6",
                  "display" : "Yomba",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15370"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1602-2",
              "display" : "Shoshone Paiute",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15371"
                }
              ],
              "concept" : [
                {
                  "code" : "1603-0",
                  "display" : "Duck Valley",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15372"
                    }
                  ]
                },
                {
                  "code" : "1604-8",
                  "display" : "Fallon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15373"
                    }
                  ]
                },
                {
                  "code" : "1605-5",
                  "display" : "Fort McDermitt",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15374"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1607-1",
              "display" : "Siletz",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15375"
                }
              ]
            },
            {
              "code" : "1609-7",
              "display" : "Sioux",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15376"
                }
              ],
              "concept" : [
                {
                  "code" : "1610-5",
                  "display" : "Blackfoot Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15377"
                    }
                  ]
                },
                {
                  "code" : "1611-3",
                  "display" : "Brule Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15378"
                    }
                  ]
                },
                {
                  "code" : "1612-1",
                  "display" : "Cheyenne River Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15379"
                    }
                  ]
                },
                {
                  "code" : "1613-9",
                  "display" : "Crow Creek Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15380"
                    }
                  ]
                },
                {
                  "code" : "1614-7",
                  "display" : "Dakota Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15381"
                    }
                  ]
                },
                {
                  "code" : "1615-4",
                  "display" : "Flandreau Santee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15382"
                    }
                  ]
                },
                {
                  "code" : "1616-2",
                  "display" : "Fort Peck",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15383"
                    }
                  ]
                },
                {
                  "code" : "1617-0",
                  "display" : "Lake Traverse Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15384"
                    }
                  ]
                },
                {
                  "code" : "1618-8",
                  "display" : "Lower Brule Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15385"
                    }
                  ]
                },
                {
                  "code" : "1619-6",
                  "display" : "Lower Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15386"
                    }
                  ]
                },
                {
                  "code" : "1620-4",
                  "display" : "Mdewakanton Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15387"
                    }
                  ]
                },
                {
                  "code" : "1621-2",
                  "display" : "Miniconjou",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15388"
                    }
                  ]
                },
                {
                  "code" : "1622-0",
                  "display" : "Oglala Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15389"
                    }
                  ]
                },
                {
                  "code" : "1623-8",
                  "display" : "Pine Ridge Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15390"
                    }
                  ]
                },
                {
                  "code" : "1624-6",
                  "display" : "Pipestone Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15391"
                    }
                  ]
                },
                {
                  "code" : "1625-3",
                  "display" : "Prairie Island Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15392"
                    }
                  ]
                },
                {
                  "code" : "1626-1",
                  "display" : "Prior Lake Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15393"
                    }
                  ]
                },
                {
                  "code" : "1627-9",
                  "display" : "Rosebud Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15394"
                    }
                  ]
                },
                {
                  "code" : "1628-7",
                  "display" : "Sans Arc Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15395"
                    }
                  ]
                },
                {
                  "code" : "1629-5",
                  "display" : "Santee Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15396"
                    }
                  ]
                },
                {
                  "code" : "1630-3",
                  "display" : "Sisseton-Wahpeton",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15397"
                    }
                  ]
                },
                {
                  "code" : "1631-1",
                  "display" : "Sisseton Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15398"
                    }
                  ]
                },
                {
                  "code" : "1632-9",
                  "display" : "Spirit Lake Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15399"
                    }
                  ]
                },
                {
                  "code" : "1633-7",
                  "display" : "Standing Rock Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15400"
                    }
                  ]
                },
                {
                  "code" : "1634-5",
                  "display" : "Teton Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15401"
                    }
                  ]
                },
                {
                  "code" : "1635-2",
                  "display" : "Two Kettle Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15402"
                    }
                  ]
                },
                {
                  "code" : "1636-0",
                  "display" : "Upper Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15403"
                    }
                  ]
                },
                {
                  "code" : "1637-8",
                  "display" : "Wahpekute Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15404"
                    }
                  ]
                },
                {
                  "code" : "1638-6",
                  "display" : "Wahpeton Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15405"
                    }
                  ]
                },
                {
                  "code" : "1639-4",
                  "display" : "Wazhaza Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15406"
                    }
                  ]
                },
                {
                  "code" : "1640-2",
                  "display" : "Yankton Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15407"
                    }
                  ]
                },
                {
                  "code" : "1641-0",
                  "display" : "Yanktonai Sioux",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15408"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1643-6",
              "display" : "Siuslaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15409"
                }
              ]
            },
            {
              "code" : "1645-1",
              "display" : "Spokane",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15410"
                }
              ]
            },
            {
              "code" : "1647-7",
              "display" : "Stewart",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15411"
                }
              ]
            },
            {
              "code" : "1649-3",
              "display" : "Stockbridge",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15412"
                }
              ]
            },
            {
              "code" : "1651-9",
              "display" : "Susanville",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15413"
                }
              ]
            },
            {
              "code" : "1653-5",
              "display" : "Tohono O'Odham",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15414"
                }
              ],
              "concept" : [
                {
                  "code" : "1654-3",
                  "display" : "Ak-Chin",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15415"
                    }
                  ]
                },
                {
                  "code" : "1655-0",
                  "display" : "Gila Bend",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15416"
                    }
                  ]
                },
                {
                  "code" : "1656-8",
                  "display" : "San Xavier",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15417"
                    }
                  ]
                },
                {
                  "code" : "1657-6",
                  "display" : "Sells",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15418"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1659-2",
              "display" : "Tolowa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15419"
                }
              ]
            },
            {
              "code" : "1661-8",
              "display" : "Tonkawa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15420"
                }
              ]
            },
            {
              "code" : "1663-4",
              "display" : "Tygh",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15421"
                }
              ]
            },
            {
              "code" : "1665-9",
              "display" : "Umatilla",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15422"
                }
              ]
            },
            {
              "code" : "1667-5",
              "display" : "Umpqua",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15423"
                }
              ],
              "concept" : [
                {
                  "code" : "1668-3",
                  "display" : "Cow Creek Umpqua",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15424"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1670-9",
              "display" : "Ute",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15425"
                }
              ],
              "concept" : [
                {
                  "code" : "1671-7",
                  "display" : "Allen Canyon",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15426"
                    }
                  ]
                },
                {
                  "code" : "1672-5",
                  "display" : "Uintah Ute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15427"
                    }
                  ]
                },
                {
                  "code" : "1673-3",
                  "display" : "Ute Mountain Ute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15428"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1675-8",
              "display" : "Wailaki",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15429"
                }
              ]
            },
            {
              "code" : "1677-4",
              "display" : "Walla-Walla",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15430"
                }
              ]
            },
            {
              "code" : "1679-0",
              "display" : "Wampanoag",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15431"
                }
              ],
              "concept" : [
                {
                  "code" : "1680-8",
                  "display" : "Gay Head Wampanoag",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15432"
                    }
                  ]
                },
                {
                  "code" : "1681-6",
                  "display" : "Mashpee Wampanoag",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15433"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1683-2",
              "display" : "Warm Springs",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15434"
                }
              ]
            },
            {
              "code" : "1685-7",
              "display" : "Wascopum",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15435"
                }
              ]
            },
            {
              "code" : "1687-3",
              "display" : "Washoe",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15436"
                }
              ],
              "concept" : [
                {
                  "code" : "1688-1",
                  "display" : "Alpine",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15437"
                    }
                  ]
                },
                {
                  "code" : "1689-9",
                  "display" : "Carson",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15438"
                    }
                  ]
                },
                {
                  "code" : "1690-7",
                  "display" : "Dresslerville",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15439"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1692-3",
              "display" : "Wichita",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15440"
                }
              ]
            },
            {
              "code" : "1694-9",
              "display" : "Wind River",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15441"
                }
              ]
            },
            {
              "code" : "1696-4",
              "display" : "Winnebago",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15442"
                }
              ],
              "concept" : [
                {
                  "code" : "1697-2",
                  "display" : "Ho-chunk",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15443"
                    }
                  ]
                },
                {
                  "code" : "1698-0",
                  "display" : "Nebraska Winnebago",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15444"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1700-4",
              "display" : "Winnemucca",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15445"
                }
              ]
            },
            {
              "code" : "1702-0",
              "display" : "Wintun",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15446"
                }
              ]
            },
            {
              "code" : "1704-6",
              "display" : "Wiyot",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15447"
                }
              ],
              "concept" : [
                {
                  "code" : "1705-3",
                  "display" : "Table Bluff",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15448"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1707-9",
              "display" : "Yakama",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15449"
                }
              ]
            },
            {
              "code" : "1709-5",
              "display" : "Yakama Cowlitz",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15450"
                }
              ]
            },
            {
              "code" : "1711-1",
              "display" : "Yaqui",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15451"
                }
              ],
              "concept" : [
                {
                  "code" : "1712-9",
                  "display" : "Barrio Libre",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15452"
                    }
                  ]
                },
                {
                  "code" : "1713-7",
                  "display" : "Pascua Yaqui",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15453"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1715-2",
              "display" : "Yavapai Apache",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15454"
                }
              ]
            },
            {
              "code" : "1717-8",
              "display" : "Yokuts",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15455"
                }
              ],
              "concept" : [
                {
                  "code" : "1718-6",
                  "display" : "Chukchansi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15456"
                    }
                  ]
                },
                {
                  "code" : "1719-4",
                  "display" : "Tachi",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15457"
                    }
                  ]
                },
                {
                  "code" : "1720-2",
                  "display" : "Tule River",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15458"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1722-8",
              "display" : "Yuchi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15459"
                }
              ]
            },
            {
              "code" : "1724-4",
              "display" : "Yuman",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15460"
                }
              ],
              "concept" : [
                {
                  "code" : "1725-1",
                  "display" : "Cocopah",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15461"
                    }
                  ]
                },
                {
                  "code" : "1726-9",
                  "display" : "Havasupai",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15462"
                    }
                  ]
                },
                {
                  "code" : "1727-7",
                  "display" : "Hualapai",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15463"
                    }
                  ]
                },
                {
                  "code" : "1728-5",
                  "display" : "Maricopa",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15464"
                    }
                  ]
                },
                {
                  "code" : "1729-3",
                  "display" : "Mohave",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15465"
                    }
                  ]
                },
                {
                  "code" : "1730-1",
                  "display" : "Quechan",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15466"
                    }
                  ]
                },
                {
                  "code" : "1731-9",
                  "display" : "Yavapai",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15467"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1732-7",
              "display" : "Yurok",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15468"
                }
              ],
              "concept" : [
                {
                  "code" : "1733-5",
                  "display" : "Coast Yurok",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15469"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "1735-0",
          "display" : "Alaska Native",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15470"
            }
          ],
          "concept" : [
            {
              "code" : "1737-6",
              "display" : "Alaska Indian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15471"
                }
              ],
              "concept" : [
                {
                  "code" : "1739-2",
                  "display" : "Alaskan Athabascan",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15472"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1740-0",
                      "display" : "Ahtna",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15473"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1811-9",
                  "display" : "Southeast Alaska",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15543"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1813-5",
                      "display" : "Tlingit-Haida",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15544"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "1814-3",
                          "display" : "Angoon",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15545"
                            }
                          ]
                        },
                        {
                          "code" : "1815-0",
                          "display" : "Central Council of Tlingit and Haida Tribes",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15546"
                            }
                          ]
                        },
                        {
                          "code" : "1816-8",
                          "display" : "Chilkat",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15547"
                            }
                          ]
                        },
                        {
                          "code" : "1817-6",
                          "display" : "Chilkoot",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15548"
                            }
                          ]
                        },
                        {
                          "code" : "1818-4",
                          "display" : "Craig",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15549"
                            }
                          ]
                        },
                        {
                          "code" : "1819-2",
                          "display" : "Douglas",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15550"
                            }
                          ]
                        },
                        {
                          "code" : "1820-0",
                          "display" : "Haida",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15551"
                            }
                          ]
                        },
                        {
                          "code" : "1821-8",
                          "display" : "Hoonah",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15552"
                            }
                          ]
                        },
                        {
                          "code" : "1822-6",
                          "display" : "Hydaburg",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15553"
                            }
                          ]
                        },
                        {
                          "code" : "1823-4",
                          "display" : "Kake",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15554"
                            }
                          ]
                        },
                        {
                          "code" : "1824-2",
                          "display" : "Kasaan",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15555"
                            }
                          ]
                        },
                        {
                          "code" : "1825-9",
                          "display" : "Kenaitze",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15556"
                            }
                          ]
                        },
                        {
                          "code" : "1826-7",
                          "display" : "Ketchikan",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15557"
                            }
                          ]
                        },
                        {
                          "code" : "1827-5",
                          "display" : "Klawock",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15558"
                            }
                          ]
                        },
                        {
                          "code" : "1828-3",
                          "display" : "Pelican",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15559"
                            }
                          ]
                        },
                        {
                          "code" : "1829-1",
                          "display" : "Petersburg",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15560"
                            }
                          ]
                        },
                        {
                          "code" : "1830-9",
                          "display" : "Saxman",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15561"
                            }
                          ]
                        },
                        {
                          "code" : "1831-7",
                          "display" : "Sitka",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15562"
                            }
                          ]
                        },
                        {
                          "code" : "1832-5",
                          "display" : "Tenakee Springs",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15563"
                            }
                          ]
                        },
                        {
                          "code" : "1833-3",
                          "display" : "Tlingit",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15564"
                            }
                          ]
                        },
                        {
                          "code" : "1834-1",
                          "display" : "Wrangell",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15565"
                            }
                          ]
                        },
                        {
                          "code" : "1835-8",
                          "display" : "Yakutat",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15566"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "1837-4",
                      "display" : "Tsimshian",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15567"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "1838-2",
                          "display" : "Metlakatla",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "15568"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1840-8",
              "display" : "Eskimo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15569"
                }
              ],
              "concept" : [
                {
                  "code" : "1842-4",
                  "display" : "Greenland Eskimo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15570"
                    }
                  ]
                },
                {
                  "code" : "1844-0",
                  "display" : "Inupiat Eskimo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15571"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1845-7",
                      "display" : "Ambler",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15572"
                        }
                      ]
                    },
                    {
                      "code" : "1846-5",
                      "display" : "Anaktuvuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15573"
                        }
                      ]
                    },
                    {
                      "code" : "1847-3",
                      "display" : "Anaktuvuk Pass",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15574"
                        }
                      ]
                    },
                    {
                      "code" : "1848-1",
                      "display" : "Arctic Slope Inupiat",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15575"
                        }
                      ]
                    },
                    {
                      "code" : "1849-9",
                      "display" : "Arctic Slope Corporation",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15576"
                        }
                      ]
                    },
                    {
                      "code" : "1850-7",
                      "display" : "Atqasuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15577"
                        }
                      ]
                    },
                    {
                      "code" : "1851-5",
                      "display" : "Barrow",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15578"
                        }
                      ]
                    },
                    {
                      "code" : "1852-3",
                      "display" : "Bering Straits Inupiat",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15579"
                        }
                      ]
                    },
                    {
                      "code" : "1853-1",
                      "display" : "Brevig Mission",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15580"
                        }
                      ]
                    },
                    {
                      "code" : "1854-9",
                      "display" : "Buckland",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15581"
                        }
                      ]
                    },
                    {
                      "code" : "1855-6",
                      "display" : "Chinik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15582"
                        }
                      ]
                    },
                    {
                      "code" : "1856-4",
                      "display" : "Council",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15583"
                        }
                      ]
                    },
                    {
                      "code" : "1857-2",
                      "display" : "Deering",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15584"
                        }
                      ]
                    },
                    {
                      "code" : "1858-0",
                      "display" : "Elim",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15585"
                        }
                      ]
                    },
                    {
                      "code" : "1859-8",
                      "display" : "Golovin",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15586"
                        }
                      ]
                    },
                    {
                      "code" : "1860-6",
                      "display" : "Inalik Diomede",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15587"
                        }
                      ]
                    },
                    {
                      "code" : "1861-4",
                      "display" : "Inupiaq",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15588"
                        }
                      ]
                    },
                    {
                      "code" : "1862-2",
                      "display" : "Kaktovik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15589"
                        }
                      ]
                    },
                    {
                      "code" : "1863-0",
                      "display" : "Kawerak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15590"
                        }
                      ]
                    },
                    {
                      "code" : "1864-8",
                      "display" : "Kiana",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15591"
                        }
                      ]
                    },
                    {
                      "code" : "1865-5",
                      "display" : "Kivalina",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15592"
                        }
                      ]
                    },
                    {
                      "code" : "1866-3",
                      "display" : "Kobuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15593"
                        }
                      ]
                    },
                    {
                      "code" : "1867-1",
                      "display" : "Kotzebue",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15594"
                        }
                      ]
                    },
                    {
                      "code" : "1868-9",
                      "display" : "Koyuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15595"
                        }
                      ]
                    },
                    {
                      "code" : "1869-7",
                      "display" : "Kwiguk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15596"
                        }
                      ]
                    },
                    {
                      "code" : "1870-5",
                      "display" : "Mauneluk Inupiat",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15597"
                        }
                      ]
                    },
                    {
                      "code" : "1871-3",
                      "display" : "Nana Inupiat",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15598"
                        }
                      ]
                    },
                    {
                      "code" : "1872-1",
                      "display" : "Noatak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15599"
                        }
                      ]
                    },
                    {
                      "code" : "1873-9",
                      "display" : "Nome",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15600"
                        }
                      ]
                    },
                    {
                      "code" : "1874-7",
                      "display" : "Noorvik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15601"
                        }
                      ]
                    },
                    {
                      "code" : "1875-4",
                      "display" : "Nuiqsut",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15602"
                        }
                      ]
                    },
                    {
                      "code" : "1876-2",
                      "display" : "Point Hope",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15603"
                        }
                      ]
                    },
                    {
                      "code" : "1877-0",
                      "display" : "Point Lay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15604"
                        }
                      ]
                    },
                    {
                      "code" : "1878-8",
                      "display" : "Selawik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15605"
                        }
                      ]
                    },
                    {
                      "code" : "1879-6",
                      "display" : "Shaktoolik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15606"
                        }
                      ]
                    },
                    {
                      "code" : "1880-4",
                      "display" : "Shishmaref",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15607"
                        }
                      ]
                    },
                    {
                      "code" : "1881-2",
                      "display" : "Shungnak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15608"
                        }
                      ]
                    },
                    {
                      "code" : "1882-0",
                      "display" : "Solomon",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15609"
                        }
                      ]
                    },
                    {
                      "code" : "1883-8",
                      "display" : "Teller",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15610"
                        }
                      ]
                    },
                    {
                      "code" : "1884-6",
                      "display" : "Unalakleet",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15611"
                        }
                      ]
                    },
                    {
                      "code" : "1885-3",
                      "display" : "Wainwright",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15612"
                        }
                      ]
                    },
                    {
                      "code" : "1886-1",
                      "display" : "Wales",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15613"
                        }
                      ]
                    },
                    {
                      "code" : "1887-9",
                      "display" : "White Mountain",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15614"
                        }
                      ]
                    },
                    {
                      "code" : "1888-7",
                      "display" : "White Mountain Inupiat",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15615"
                        }
                      ]
                    },
                    {
                      "code" : "1889-5",
                      "display" : "Mary's Igloo",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15616"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1891-1",
                  "display" : "Siberian Eskimo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15617"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1892-9",
                      "display" : "Gambell",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15618"
                        }
                      ]
                    },
                    {
                      "code" : "1893-7",
                      "display" : "Savoonga",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15619"
                        }
                      ]
                    },
                    {
                      "code" : "1894-5",
                      "display" : "Siberian Yupik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15620"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1896-0",
                  "display" : "Yupik Eskimo",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15621"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1897-8",
                      "display" : "Akiachak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15622"
                        }
                      ]
                    },
                    {
                      "code" : "1898-6",
                      "display" : "Akiak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15623"
                        }
                      ]
                    },
                    {
                      "code" : "1899-4",
                      "display" : "Alakanuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15624"
                        }
                      ]
                    },
                    {
                      "code" : "1900-0",
                      "display" : "Aleknagik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15625"
                        }
                      ]
                    },
                    {
                      "code" : "1901-8",
                      "display" : "Andreafsky",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15626"
                        }
                      ]
                    },
                    {
                      "code" : "1902-6",
                      "display" : "Aniak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15627"
                        }
                      ]
                    },
                    {
                      "code" : "1903-4",
                      "display" : "Atmautluak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15628"
                        }
                      ]
                    },
                    {
                      "code" : "1904-2",
                      "display" : "Bethel",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15629"
                        }
                      ]
                    },
                    {
                      "code" : "1905-9",
                      "display" : "Bill Moore's Slough",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15630"
                        }
                      ]
                    },
                    {
                      "code" : "1906-7",
                      "display" : "Bristol Bay Yupik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15631"
                        }
                      ]
                    },
                    {
                      "code" : "1907-5",
                      "display" : "Calista Yupik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15632"
                        }
                      ]
                    },
                    {
                      "code" : "1908-3",
                      "display" : "Chefornak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15633"
                        }
                      ]
                    },
                    {
                      "code" : "1909-1",
                      "display" : "Chevak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15634"
                        }
                      ]
                    },
                    {
                      "code" : "1910-9",
                      "display" : "Chuathbaluk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15635"
                        }
                      ]
                    },
                    {
                      "code" : "1911-7",
                      "display" : "Clark's Point",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15636"
                        }
                      ]
                    },
                    {
                      "code" : "1912-5",
                      "display" : "Crooked Creek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15637"
                        }
                      ]
                    },
                    {
                      "code" : "1913-3",
                      "display" : "Dillingham",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15638"
                        }
                      ]
                    },
                    {
                      "code" : "1914-1",
                      "display" : "Eek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15639"
                        }
                      ]
                    },
                    {
                      "code" : "1915-8",
                      "display" : "Ekuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15640"
                        }
                      ]
                    },
                    {
                      "code" : "1916-6",
                      "display" : "Ekwok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15641"
                        }
                      ]
                    },
                    {
                      "code" : "1917-4",
                      "display" : "Emmonak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15642"
                        }
                      ]
                    },
                    {
                      "code" : "1918-2",
                      "display" : "Goodnews Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15643"
                        }
                      ]
                    },
                    {
                      "code" : "1919-0",
                      "display" : "Hooper Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15644"
                        }
                      ]
                    },
                    {
                      "code" : "1920-8",
                      "display" : "Iqurmuit (Russian Mission)",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15645"
                        }
                      ]
                    },
                    {
                      "code" : "1921-6",
                      "display" : "Kalskag",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15646"
                        }
                      ]
                    },
                    {
                      "code" : "1922-4",
                      "display" : "Kasigluk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15647"
                        }
                      ]
                    },
                    {
                      "code" : "1923-2",
                      "display" : "Kipnuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15648"
                        }
                      ]
                    },
                    {
                      "code" : "1924-0",
                      "display" : "Koliganek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15649"
                        }
                      ]
                    },
                    {
                      "code" : "1925-7",
                      "display" : "Kongiganak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15650"
                        }
                      ]
                    },
                    {
                      "code" : "1926-5",
                      "display" : "Kotlik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15651"
                        }
                      ]
                    },
                    {
                      "code" : "1927-3",
                      "display" : "Kwethluk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15652"
                        }
                      ]
                    },
                    {
                      "code" : "1928-1",
                      "display" : "Kwigillingok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15653"
                        }
                      ]
                    },
                    {
                      "code" : "1929-9",
                      "display" : "Levelock",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15654"
                        }
                      ]
                    },
                    {
                      "code" : "1930-7",
                      "display" : "Lower Kalskag",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15655"
                        }
                      ]
                    },
                    {
                      "code" : "1931-5",
                      "display" : "Manokotak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15656"
                        }
                      ]
                    },
                    {
                      "code" : "1932-3",
                      "display" : "Marshall",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15657"
                        }
                      ]
                    },
                    {
                      "code" : "1933-1",
                      "display" : "Mekoryuk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15658"
                        }
                      ]
                    },
                    {
                      "code" : "1934-9",
                      "display" : "Mountain Village",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15659"
                        }
                      ]
                    },
                    {
                      "code" : "1935-6",
                      "display" : "Naknek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15660"
                        }
                      ]
                    },
                    {
                      "code" : "1936-4",
                      "display" : "Napaumute",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15661"
                        }
                      ]
                    },
                    {
                      "code" : "1937-2",
                      "display" : "Napakiak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15662"
                        }
                      ]
                    },
                    {
                      "code" : "1938-0",
                      "display" : "Napaskiak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15663"
                        }
                      ]
                    },
                    {
                      "code" : "1939-8",
                      "display" : "Newhalen",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15664"
                        }
                      ]
                    },
                    {
                      "code" : "1940-6",
                      "display" : "New Stuyahok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15665"
                        }
                      ]
                    },
                    {
                      "code" : "1941-4",
                      "display" : "Newtok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15666"
                        }
                      ]
                    },
                    {
                      "code" : "1942-2",
                      "display" : "Nightmute",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15667"
                        }
                      ]
                    },
                    {
                      "code" : "1943-0",
                      "display" : "Nunapitchukv",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15668"
                        }
                      ]
                    },
                    {
                      "code" : "1944-8",
                      "display" : "Oscarville",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15669"
                        }
                      ]
                    },
                    {
                      "code" : "1945-5",
                      "display" : "Pilot Station",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15670"
                        }
                      ]
                    },
                    {
                      "code" : "1946-3",
                      "display" : "Pitkas Point",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15671"
                        }
                      ]
                    },
                    {
                      "code" : "1947-1",
                      "display" : "Platinum",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15672"
                        }
                      ]
                    },
                    {
                      "code" : "1948-9",
                      "display" : "Portage Creek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15673"
                        }
                      ]
                    },
                    {
                      "code" : "1949-7",
                      "display" : "Quinhagak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15674"
                        }
                      ]
                    },
                    {
                      "code" : "1950-5",
                      "display" : "Red Devil",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15675"
                        }
                      ]
                    },
                    {
                      "code" : "1951-3",
                      "display" : "St. Michael",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15676"
                        }
                      ]
                    },
                    {
                      "code" : "1952-1",
                      "display" : "Scammon Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15677"
                        }
                      ]
                    },
                    {
                      "code" : "1953-9",
                      "display" : "Sheldon's Point",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15678"
                        }
                      ]
                    },
                    {
                      "code" : "1954-7",
                      "display" : "Sleetmute",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15679"
                        }
                      ]
                    },
                    {
                      "code" : "1955-4",
                      "display" : "Stebbins",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15680"
                        }
                      ]
                    },
                    {
                      "code" : "1956-2",
                      "display" : "Togiak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15681"
                        }
                      ]
                    },
                    {
                      "code" : "1957-0",
                      "display" : "Toksook",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15682"
                        }
                      ]
                    },
                    {
                      "code" : "1958-8",
                      "display" : "Tulukskak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15683"
                        }
                      ]
                    },
                    {
                      "code" : "1959-6",
                      "display" : "Tuntutuliak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15684"
                        }
                      ]
                    },
                    {
                      "code" : "1960-4",
                      "display" : "Tununak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15685"
                        }
                      ]
                    },
                    {
                      "code" : "1961-2",
                      "display" : "Twin Hills",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15686"
                        }
                      ]
                    },
                    {
                      "code" : "1962-0",
                      "display" : "Georgetown",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15687"
                        }
                      ]
                    },
                    {
                      "code" : "1963-8",
                      "display" : "St. Mary's",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15688"
                        }
                      ]
                    },
                    {
                      "code" : "1964-6",
                      "display" : "Umkumiate",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15689"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "1966-1",
              "display" : "Aleut",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15690"
                }
              ],
              "concept" : [
                {
                  "code" : "1968-7",
                  "display" : "Alutiiq Aleut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15691"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1969-5",
                      "display" : "Tatitlek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15692"
                        }
                      ]
                    },
                    {
                      "code" : "1970-3",
                      "display" : "Ugashik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15693"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1972-9",
                  "display" : "Bristol Bay Aleut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16466"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1973-7",
                      "display" : "Chignik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15695"
                        }
                      ]
                    },
                    {
                      "code" : "1974-5",
                      "display" : "Chignik Lake",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15696"
                        }
                      ]
                    },
                    {
                      "code" : "1975-2",
                      "display" : "Egegik",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15697"
                        }
                      ]
                    },
                    {
                      "code" : "1976-0",
                      "display" : "Igiugig",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15698"
                        }
                      ]
                    },
                    {
                      "code" : "1977-8",
                      "display" : "Ivanof Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15699"
                        }
                      ]
                    },
                    {
                      "code" : "1978-6",
                      "display" : "King Salmon",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15700"
                        }
                      ]
                    },
                    {
                      "code" : "1979-4",
                      "display" : "Kokhanok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15701"
                        }
                      ]
                    },
                    {
                      "code" : "1980-2",
                      "display" : "Perryville",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15702"
                        }
                      ]
                    },
                    {
                      "code" : "1981-0",
                      "display" : "Pilot Point",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15703"
                        }
                      ]
                    },
                    {
                      "code" : "1982-8",
                      "display" : "Port Heiden",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15704"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1984-4",
                  "display" : "Chugach Aleut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15705"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1985-1",
                      "display" : "Chenega",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15706"
                        }
                      ]
                    },
                    {
                      "code" : "1986-9",
                      "display" : "Chugach Corporation",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15707"
                        }
                      ]
                    },
                    {
                      "code" : "1987-7",
                      "display" : "English Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15708"
                        }
                      ]
                    },
                    {
                      "code" : "1988-5",
                      "display" : "Port Graham",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15709"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "1990-1",
                  "display" : "Eyak",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15710"
                    }
                  ]
                },
                {
                  "code" : "1992-7",
                  "display" : "Koniag Aleut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15711"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "1993-5",
                      "display" : "Akhiok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15712"
                        }
                      ]
                    },
                    {
                      "code" : "1994-3",
                      "display" : "Agdaagux",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15713"
                        }
                      ]
                    },
                    {
                      "code" : "1995-0",
                      "display" : "Karluk",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15714"
                        }
                      ]
                    },
                    {
                      "code" : "1996-8",
                      "display" : "Kodiak",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15715"
                        }
                      ]
                    },
                    {
                      "code" : "1997-6",
                      "display" : "Larsen Bay",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15716"
                        }
                      ]
                    },
                    {
                      "code" : "1998-4",
                      "display" : "Old Harbor",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15717"
                        }
                      ]
                    },
                    {
                      "code" : "1999-2",
                      "display" : "Ouzinkie",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15718"
                        }
                      ]
                    },
                    {
                      "code" : "2000-8",
                      "display" : "Port Lions",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15719"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "2002-4",
                  "display" : "Sugpiaq",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15720"
                    }
                  ]
                },
                {
                  "code" : "2004-0",
                  "display" : "Suqpigaq",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15721"
                    }
                  ]
                },
                {
                  "code" : "2006-5",
                  "display" : "Unangan Aleut",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "15722"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "2007-3",
                      "display" : "Akutan",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15723"
                        }
                      ]
                    },
                    {
                      "code" : "2008-1",
                      "display" : "Aleut Corporation",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15724"
                        }
                      ]
                    },
                    {
                      "code" : "2009-9",
                      "display" : "Aleutian",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15725"
                        }
                      ]
                    },
                    {
                      "code" : "2010-7",
                      "display" : "Aleutian Islander",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15726"
                        }
                      ]
                    },
                    {
                      "code" : "2011-5",
                      "display" : "Atka",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15727"
                        }
                      ]
                    },
                    {
                      "code" : "2012-3",
                      "display" : "Belkofski",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15728"
                        }
                      ]
                    },
                    {
                      "code" : "2013-1",
                      "display" : "Chignik Lagoon",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15729"
                        }
                      ]
                    },
                    {
                      "code" : "2014-9",
                      "display" : "King Cove",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15730"
                        }
                      ]
                    },
                    {
                      "code" : "2015-6",
                      "display" : "False Pass",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15731"
                        }
                      ]
                    },
                    {
                      "code" : "2016-4",
                      "display" : "Nelson Lagoon",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15732"
                        }
                      ]
                    },
                    {
                      "code" : "2017-2",
                      "display" : "Nikolski",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15733"
                        }
                      ]
                    },
                    {
                      "code" : "2018-0",
                      "display" : "Pauloff Harbor",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15734"
                        }
                      ]
                    },
                    {
                      "code" : "2019-8",
                      "display" : "Qagan Toyagungin",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15735"
                        }
                      ]
                    },
                    {
                      "code" : "2020-6",
                      "display" : "Qawalangin",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15736"
                        }
                      ]
                    },
                    {
                      "code" : "2021-4",
                      "display" : "St. George",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15737"
                        }
                      ]
                    },
                    {
                      "code" : "2022-2",
                      "display" : "St. Paul",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15738"
                        }
                      ]
                    },
                    {
                      "code" : "2023-0",
                      "display" : "Sand Point",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15739"
                        }
                      ]
                    },
                    {
                      "code" : "2024-8",
                      "display" : "South Naknek",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15740"
                        }
                      ]
                    },
                    {
                      "code" : "2025-5",
                      "display" : "Unalaska",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15741"
                        }
                      ]
                    },
                    {
                      "code" : "2026-3",
                      "display" : "Unga",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "15742"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "2028-9",
      "display" : "Asian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15743"
        }
      ],
      "concept" : [
        {
          "code" : "2029-7",
          "display" : "Asian Indian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15744"
            }
          ]
        },
        {
          "code" : "2030-5",
          "display" : "Bangladeshi",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15745"
            }
          ]
        },
        {
          "code" : "2031-3",
          "display" : "Bhutanese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15746"
            }
          ]
        },
        {
          "code" : "2032-1",
          "display" : "Burmese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15747"
            }
          ]
        },
        {
          "code" : "2033-9",
          "display" : "Cambodian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15748"
            }
          ]
        },
        {
          "code" : "2034-7",
          "display" : "Chinese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15749"
            }
          ]
        },
        {
          "code" : "2035-4",
          "display" : "Taiwanese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15750"
            }
          ]
        },
        {
          "code" : "2036-2",
          "display" : "Filipino",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15751"
            }
          ]
        },
        {
          "code" : "2037-0",
          "display" : "Hmong",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15752"
            }
          ]
        },
        {
          "code" : "2038-8",
          "display" : "Indonesian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15753"
            }
          ]
        },
        {
          "code" : "2039-6",
          "display" : "Japanese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15754"
            }
          ]
        },
        {
          "code" : "2040-4",
          "display" : "Korean",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15755"
            }
          ]
        },
        {
          "code" : "2041-2",
          "display" : "Laotian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15756"
            }
          ]
        },
        {
          "code" : "2042-0",
          "display" : "Malaysian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15757"
            }
          ]
        },
        {
          "code" : "2043-8",
          "display" : "Okinawan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15758"
            }
          ]
        },
        {
          "code" : "2044-6",
          "display" : "Pakistani",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15759"
            }
          ]
        },
        {
          "code" : "2045-3",
          "display" : "Sri Lankan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15760"
            }
          ]
        },
        {
          "code" : "2046-1",
          "display" : "Thai",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15761"
            }
          ]
        },
        {
          "code" : "2047-9",
          "display" : "Vietnamese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15762"
            }
          ]
        },
        {
          "code" : "2048-7",
          "display" : "Iwo Jiman",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15763"
            }
          ]
        },
        {
          "code" : "2049-5",
          "display" : "Maldivian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15764"
            }
          ]
        },
        {
          "code" : "2050-3",
          "display" : "Nepalese",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15765"
            }
          ]
        },
        {
          "code" : "2051-1",
          "display" : "Singaporean",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15766"
            }
          ]
        },
        {
          "code" : "2052-9",
          "display" : "Madagascar",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15767"
            }
          ]
        }
      ]
    },
    {
      "code" : "2054-5",
      "display" : "Black or African American",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15768"
        }
      ],
      "concept" : [
        {
          "code" : "2056-0",
          "display" : "Black",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15769"
            }
          ]
        },
        {
          "code" : "2058-6",
          "display" : "African American",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15770"
            }
          ]
        },
        {
          "code" : "2060-2",
          "display" : "African",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15771"
            }
          ],
          "concept" : [
            {
              "code" : "2061-0",
              "display" : "Botswanan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15772"
                }
              ]
            },
            {
              "code" : "2062-8",
              "display" : "Ethiopian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15773"
                }
              ]
            },
            {
              "code" : "2063-6",
              "display" : "Liberian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15774"
                }
              ]
            },
            {
              "code" : "2064-4",
              "display" : "Namibian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15775"
                }
              ]
            },
            {
              "code" : "2065-1",
              "display" : "Nigerian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15776"
                }
              ]
            },
            {
              "code" : "2066-9",
              "display" : "Zairean",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15777"
                }
              ]
            }
          ]
        },
        {
          "code" : "2067-7",
          "display" : "Bahamian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15778"
            }
          ]
        },
        {
          "code" : "2068-5",
          "display" : "Barbadian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15779"
            }
          ]
        },
        {
          "code" : "2069-3",
          "display" : "Dominican",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15780"
            }
          ]
        },
        {
          "code" : "2070-1",
          "display" : "Dominica Islander",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15781"
            }
          ]
        },
        {
          "code" : "2071-9",
          "display" : "Haitian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15782"
            }
          ]
        },
        {
          "code" : "2072-7",
          "display" : "Jamaican",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15783"
            }
          ]
        },
        {
          "code" : "2073-5",
          "display" : "Tobagoan",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15784"
            }
          ]
        },
        {
          "code" : "2074-3",
          "display" : "Trinidadian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15785"
            }
          ]
        },
        {
          "code" : "2075-0",
          "display" : "West Indian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15786"
            }
          ]
        }
      ]
    },
    {
      "code" : "2076-8",
      "display" : "Native Hawaiian or Other Pacific Islander",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15787"
        }
      ],
      "concept" : [
        {
          "code" : "2078-4",
          "display" : "Polynesian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15788"
            }
          ],
          "concept" : [
            {
              "code" : "2079-2",
              "display" : "Native Hawaiian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15789"
                }
              ]
            },
            {
              "code" : "2080-0",
              "display" : "Samoan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15790"
                }
              ]
            },
            {
              "code" : "2081-8",
              "display" : "Tahitian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15791"
                }
              ]
            },
            {
              "code" : "2082-6",
              "display" : "Tongan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15792"
                }
              ]
            },
            {
              "code" : "2083-4",
              "display" : "Tokelauan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15793"
                }
              ]
            }
          ]
        },
        {
          "code" : "2085-9",
          "display" : "Micronesian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15794"
            }
          ],
          "concept" : [
            {
              "code" : "2086-7",
              "display" : "Guamanian or Chamorro",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15795"
                }
              ]
            },
            {
              "code" : "2087-5",
              "display" : "Guamanian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15796"
                }
              ]
            },
            {
              "code" : "2088-3",
              "display" : "Chamorro",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15797"
                }
              ]
            },
            {
              "code" : "2089-1",
              "display" : "Mariana Islander",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15798"
                }
              ]
            },
            {
              "code" : "2090-9",
              "display" : "Marshallese",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15799"
                }
              ]
            },
            {
              "code" : "2091-7",
              "display" : "Palauan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15800"
                }
              ]
            },
            {
              "code" : "2092-5",
              "display" : "Carolinian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15801"
                }
              ]
            },
            {
              "code" : "2093-3",
              "display" : "Kosraean",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15802"
                }
              ]
            },
            {
              "code" : "2094-1",
              "display" : "Pohnpeian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15803"
                }
              ]
            },
            {
              "code" : "2095-8",
              "display" : "Saipanese",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15804"
                }
              ]
            },
            {
              "code" : "2096-6",
              "display" : "Kiribati",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15805"
                }
              ]
            },
            {
              "code" : "2097-4",
              "display" : "Chuukese",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15806"
                }
              ]
            },
            {
              "code" : "2098-2",
              "display" : "Yapese",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15807"
                }
              ]
            }
          ]
        },
        {
          "code" : "2100-6",
          "display" : "Melanesian",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15808"
            }
          ],
          "concept" : [
            {
              "code" : "2101-4",
              "display" : "Fijian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15809"
                }
              ]
            },
            {
              "code" : "2102-2",
              "display" : "Papua New Guinean",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15810"
                }
              ]
            },
            {
              "code" : "2103-0",
              "display" : "Solomon Islander",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15811"
                }
              ]
            },
            {
              "code" : "2104-8",
              "display" : "New Hebrides",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15812"
                }
              ]
            }
          ]
        },
        {
          "code" : "2500-7",
          "display" : "Other Pacific Islander",
          "definition" : "Note that this term remains in the table for completeness, even though within HL7, the notion of Other code is deprecated.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15813"
            }
          ]
        }
      ]
    },
    {
      "code" : "2106-3",
      "display" : "White",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15814"
        }
      ],
      "concept" : [
        {
          "code" : "2108-9",
          "display" : "European",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15815"
            }
          ],
          "concept" : [
            {
              "code" : "2109-7",
              "display" : "Armenian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15816"
                }
              ]
            },
            {
              "code" : "2110-5",
              "display" : "English",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15817"
                }
              ]
            },
            {
              "code" : "2111-3",
              "display" : "French",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15818"
                }
              ]
            },
            {
              "code" : "2112-1",
              "display" : "German",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15819"
                }
              ]
            },
            {
              "code" : "2113-9",
              "display" : "Irish",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15820"
                }
              ]
            },
            {
              "code" : "2114-7",
              "display" : "Italian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15821"
                }
              ]
            },
            {
              "code" : "2115-4",
              "display" : "Polish",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15822"
                }
              ]
            },
            {
              "code" : "2116-2",
              "display" : "Scottish",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15823"
                }
              ]
            }
          ]
        },
        {
          "code" : "2118-8",
          "display" : "Middle Eastern or North African",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15824"
            }
          ],
          "concept" : [
            {
              "code" : "2119-6",
              "display" : "Assyrian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15825"
                }
              ]
            },
            {
              "code" : "2120-4",
              "display" : "Egyptian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15826"
                }
              ]
            },
            {
              "code" : "2121-2",
              "display" : "Iranian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15827"
                }
              ]
            },
            {
              "code" : "2122-0",
              "display" : "Iraqi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15828"
                }
              ]
            },
            {
              "code" : "2123-8",
              "display" : "Lebanese",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15829"
                }
              ]
            },
            {
              "code" : "2124-6",
              "display" : "Palestinian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15830"
                }
              ]
            },
            {
              "code" : "2125-3",
              "display" : "Syrian",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15831"
                }
              ]
            },
            {
              "code" : "2126-1",
              "display" : "Afghanistani",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15832"
                }
              ]
            },
            {
              "code" : "2127-9",
              "display" : "Israeili",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "15833"
                }
              ]
            }
          ]
        },
        {
          "code" : "2129-5",
          "display" : "Arab",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15834"
            }
          ]
        }
      ]
    },
    {
      "code" : "2131-1",
      "display" : "Other Race",
      "definition" : "Note that this term remains in the table for completeness, even though within HL7, the notion of Other code is deprecated.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15835"
        }
      ]
    }
  ]
}

```
