# MaritalStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MaritalStatus**

## CodeSystem: MaritalStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MaritalStatus | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MaritalStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.2 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
* * * No description supplied * * * 
**Open Issue:**The specific meanings of these codes can vary somewhat by jurisdiction and implementation so caution should be used when determining equivalency. 
**Open Issue:**fixing and completion of the hierarchy and proper good definitions of all the concepts is badly needed. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MaritalStatus](ValueSet-v3-MaritalStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MaritalStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.2"
    }
  ],
  "version" : "3.0.0",
  "name" : "MaritalStatus",
  "title" : "MaritalStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "\\* \\* \\* No description supplied \\* \\* \\*\r\n\r\n*Open Issue:* The specific meanings of these codes can vary somewhat by jurisdiction and implementation so caution should be used when determining equivalency.\r\n\r\n*Open Issue:* fixing and completion of the hierarchy and proper good definitions of all the concepts is badly needed.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Annulled",
      "definition" : "Marriage contract has been declared null and to not have existed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12213"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Divorced",
      "definition" : "Marriage contract has been declared dissolved and inactive",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12214"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Interlocutory",
      "definition" : "Subject to an Interlocutory Decree.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12215"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Legally Separated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12216"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Married",
      "definition" : "A current marriage contract is active",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12217"
        }
      ],
      "concept" : [
        {
          "code" : "C",
          "display" : "Common Law",
          "definition" : "a marriage recognized in some jurisdictions and based on the parties' agreement to consider themselves married and can also be based on documentation of cohabitation.\r\n\r\nThis definition was based on https://www.merriam-webster.com/dictionary/common-law%20marriage.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "24122"
            }
          ]
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Polygamous",
      "definition" : "More than 1 current spouse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12220"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Domestic partner",
      "definition" : "Person declares that a domestic partner relationship exists.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15981"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "unmarried",
      "definition" : "Currently not in a marriage contract.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23624"
        }
      ],
      "concept" : [
        {
          "code" : "S",
          "display" : "Never Married",
          "definition" : "No marriage contract has ever been entered",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "12218"
            }
          ]
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Widowed",
      "definition" : "The spouse has died",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "12219"
        }
      ]
    }
  ]
}

```
