# IntegrityCheckAlgorithm - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IntegrityCheckAlgorithm**

## CodeSystem: IntegrityCheckAlgorithm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-IntegrityCheckAlgorithm | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:IntegrityCheckAlgorithm |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1010 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**** MISSING DESCRIPTION **** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [IntegrityCheckAlgorithm](ValueSet-v3-IntegrityCheckAlgorithm.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-IntegrityCheckAlgorithm",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-IntegrityCheckAlgorithm",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1010"
    }
  ],
  "version" : "3.0.0",
  "name" : "IntegrityCheckAlgorithm",
  "title" : "IntegrityCheckAlgorithm",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**** MISSING DESCRIPTION ****",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "SHA-1",
      "display" : "secure hash algorithm - 1",
      "definition" : "This algorithm is defined in FIPS PUB 180-1: Secure Hash Standard. As of April 17, 1995.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17386"
        }
      ]
    },
    {
      "code" : "SHA-256",
      "display" : "secure hash algorithm - 256",
      "definition" : "This algorithm is defined in FIPS PUB 180-2: Secure Hash Standard.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17387"
        }
      ]
    }
  ]
}

```
