# EntityDeterminer - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityDeterminer**

## CodeSystem: EntityDeterminer 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityDeterminer | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityDeterminer |
| *Other Identifiers:*OID:2.16.840.1.113883.5.30 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
EntityDeterminer in natural language grammar is the class of words that comprises articles, demonstrative pronouns, and quantifiers. In the RIM, determiner is a structural code in the Entity class to distinguish whether any given Entity object stands for some, any one, or a specific thing. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityDeterminer](ValueSet-v3-EntityDeterminer.md)
* [EntityDeterminerDescribedGroup](ValueSet-v3-EntityDeterminerDescribedGroup.md)
* [EntityDeterminerDescribedQuantified](ValueSet-v3-EntityDeterminerDescribedQuantified.md)
* [EntityDeterminerDetermined](ValueSet-v3-EntityDeterminerDetermined.md)
* [EntityDeterminerSpecific](ValueSet-v3-EntityDeterminerSpecific.md)
* [EntityDeterminerSpecificGroup](ValueSet-v3-EntityDeterminerSpecificGroup.md)
* [XDeterminerInstanceKind](ValueSet-v3-xDeterminerInstanceKind.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityDeterminer",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityDeterminer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.30"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityDeterminer",
  "title" : "EntityDeterminer",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "EntityDeterminer in natural language grammar is the class of words that comprises articles, demonstrative pronouns, and quantifiers. In the RIM, determiner is a structural code in the Entity class to distinguish whether any given Entity object stands for some, any one, or a specific thing.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "Name:Class",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Class",
      "description" : "The formal name for the class clone under this code",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "INSTANCE",
      "display" : "specific",
      "definition" : "**Description:**A determiner that specifies that the Entity object represents a particular physical thing (as opposed to a universal, kind, or class of physical thing).\r\n\r\n**Discussion:** It does not matter whether an INSTANCE still exists as a whole at the point in time (or process) when we mention it, for example, a drug product lot is an INSTANCE even though it has been portioned out for retail purpose.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10881"
        }
      ],
      "concept" : [
        {
          "code" : "GROUP",
          "display" : "specific group",
          "definition" : "A determiner that specifies that the Entity object represents a particular collection of physical things (as opposed to a universal, kind, or class of physical thing). While the collection may resolve to having only a single individual (or even no individuals), the potential should exist for it to cover multiple individuals.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23599"
            }
          ]
        }
      ]
    },
    {
      "code" : "KIND",
      "display" : "described",
      "definition" : "**Description:**A determiner that specifies that the Entity object represents a universal, kind or class of physical thing (as opposed to a particular thing).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10879"
        },
        {
          "code" : "Name:Class",
          "valueCode" : "Kind"
        }
      ],
      "concept" : [
        {
          "code" : "GROUPKIND",
          "display" : "described group",
          "definition" : "A determiner that specifies that the Entity object represents a universal, kind or class of collections physical things. While the collection may resolve to having only a single individual (or even no individuals), the potential should exist for it to cover multiple individuals.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23600"
            }
          ]
        },
        {
          "code" : "QUANTIFIED_KIND",
          "display" : "described quantified",
          "definition" : "The described quantified determiner indicates that the given Entity is taken as a general description of a specific amount of a thing. For example, QUANTIFIED\\_KIND of syringe (quantity = 3,) stands for exactly three syringes.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "deprecated"
            },
            {
              "code" : "deprecationDate",
              "valueDateTime" : "2008-11-14"
            },
            {
              "code" : "internalId",
              "valueCode" : "10880"
            }
          ]
        }
      ]
    }
  ]
}

```
