# DocumentStorage - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DocumentStorage**

## CodeSystem: DocumentStorage 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-DocumentStorage | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DocumentStorage |
| *Other Identifiers:*OID:2.16.840.1.113883.5.34 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies the storage status of a document. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DocumentStorage](ValueSet-v3-DocumentStorage.md)
* [DocumentStorageActive](ValueSet-v3-DocumentStorageActive.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-DocumentStorage",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-DocumentStorage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.34"
    }
  ],
  "version" : "3.0.0",
  "name" : "DocumentStorage",
  "title" : "DocumentStorage",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies the storage status of a document.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AC",
      "display" : "active",
      "definition" : "A storage status in which a document is available on-line.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10584"
        }
      ],
      "concept" : [
        {
          "code" : "AA",
          "display" : "active and archived",
          "definition" : "A storage status in which a document is available on-line and is also stored off-line for long-term access.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10585"
            }
          ]
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "archived (not active)",
      "definition" : "A storage status in which a document has been stored off-line for long-term access.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10586"
        }
      ]
    },
    {
      "code" : "PU",
      "display" : "purged",
      "definition" : "A storage status in which a document is no longer available in this system.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10587"
        }
      ]
    }
  ]
}

```
