# ContainerCap - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ContainerCap**

## CodeSystem: ContainerCap 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ContainerCap | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContainerCap |
| *Other Identifiers:*OID:2.16.840.1.113883.5.26 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The type of cap associated with a container 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContainerCap](ValueSet-v3-ContainerCap.md)
* [MedicationCap](ValueSet-v3-MedicationCap.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ContainerCap",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ContainerCap",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.26"
    }
  ],
  "version" : "3.0.0",
  "name" : "ContainerCap",
  "title" : "ContainerCap",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of cap associated with a container",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_MedicationCap",
      "display" : "MedicationCap",
      "definition" : "Cap types for medication containers",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21052"
        }
      ],
      "concept" : [
        {
          "code" : "CHILD",
          "display" : "ChildProof",
          "definition" : "A cap designed to be difficult to open for children. Generally requires multiple simultaneous actions (e.g. squeeze and twist) to open. Used for products that may be dangerous if ingested or overdosed by children.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16186"
            }
          ]
        },
        {
          "code" : "EASY",
          "display" : "EasyOpen",
          "definition" : "A cap designed to be easily removed. For products intended to be opened by persons with limited strength or dexterity.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "16185"
            }
          ]
        }
      ]
    },
    {
      "code" : "FILM",
      "display" : "Film",
      "definition" : "A non-reactive plastic film covering over the opening of a container.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14053"
        }
      ]
    },
    {
      "code" : "FOIL",
      "display" : "Foil",
      "definition" : "A foil covering (type of foil not specified) over the opening of a container",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14052"
        }
      ]
    },
    {
      "code" : "PUSH",
      "display" : "Push Cap",
      "definition" : "A non-threaded cap that forms a tight-fitting closure on a container by pushing the fitted end into the conatiner opening",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14051"
        }
      ]
    },
    {
      "code" : "SCR",
      "display" : "Screw Cap",
      "definition" : "A threaded cap that is screwed onto the opening of a container",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14050"
        }
      ]
    }
  ]
}

```
