# Confidentiality - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Confidentiality**

## CodeSystem: Confidentiality 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-Confidentiality | *Version*:3.0.0 | |
| Active as of 2023-05-30 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Confidentiality |
| *Other Identifiers:*OID:2.16.840.1.113883.5.25 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A set of codes specifying the security classification of acts and roles in accordance with the definition for concept domain "Confidentiality". 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Confidentiality](ValueSet-v2-0952.md)
* [Confidentiality](ValueSet-v3-Confidentiality.md)
* [ConfidentialityModifiers](ValueSet-v3-ConfidentialityModifiers.md)
* [SecurityClassificationObservationValue](ValueSet-v3-SecurityClassificationObservationValue.md)
* [XBasicConfidentialityKind](ValueSet-v3-xBasicConfidentialityKind.md)
* [XVeryBasicConfidentialityKind](ValueSet-v3-xVeryBasicConfidentialityKind.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-Confidentiality",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.25"
    }
  ],
  "version" : "3.0.0",
  "name" : "Confidentiality",
  "title" : "Confidentiality",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-05-30",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A set of codes specifying the security classification of acts and roles in accordance with the definition for concept domain \"Confidentiality\".",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_Confidentiality",
      "display" : "Confidentiality",
      "definition" : "A specializable code and its leaf codes used in Confidentiality value sets to value the Act.Confidentiality and Role.Confidentiality attribute in accordance with the definition for concept domain \"Confidentiality\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23320"
        }
      ],
      "concept" : [
        {
          "code" : "L",
          "display" : "low",
          "definition" : "Privacy metadata indicating that a low level of protection is required to safeguard personal and healthcare information, which has been altered in such a way as to minimize the need for confidentiality protections with some residual risks associated with re-linking. The risk of harm to an individual's reputation and sense of privacy if disclosed without authorization is considered negligible, and mitigations are in place to address reidentification risk.\r\n\r\n*Usage Note:* \r\n\r\nThe level of protection afforded anonymized and pseudonymized, and non-personally identifiable information (e.g., a limited data set) is dictated by privacy policies and data use agreements intended to engender trust that health information can be used and disclosed with little or no risk of re-identification.\r\n\r\n**Example:** Personal and healthcare information, which excludes 16 designated categories of direct identifiers in a HIPAA Limited Data Set. This information may be disclosed by HIPAA Covered Entities without patient authorization for a research, public health, and operations purposes if conditions are met, which includes obtaining a signed data use agreement from the recipient. See 45 CFR Section 164.514.\r\n\r\nThis metadata indicates that the receiver may have an obligation to comply with a data use agreement with the discloser. The discloser may have obligations to comply with policies dictating the methods for de-identification.\r\n\r\nConfidentiality code total order hierarchy: Low (L) is less protective than *V, R, N,* and *M*, and subsumes *U*.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10234"
            }
          ]
        },
        {
          "code" : "M",
          "display" : "moderate",
          "definition" : "Privacy metadata indicating the level of protection required to safeguard personal and healthcare information, which if disclosed without authorization, would present a moderate risk of harm to an individual's reputation and sense of privacy.\r\n\r\n*Usage Note:* The level of protection afforded moderately confidential information is dictated by privacy policies intended to engender trust in a service provider. May include publicly available information in jurisdictions that restrict uses of that information without the consent of the data subject.\r\n\r\nPrivacy policies mandating moderate levels of protection, which preempt less protective privacy policies. \"Moderate\" confidentiality policies differ from and would be preempted by the prevailing privacy policies mandating the normative level of protection for information used in the delivery and management of healthcare.\r\n\r\nConfidentiality code total order hierarchy: Moderate (M) is less protective than *V, R, and N*, and subsumes all other protection levels (i.e., *L* and *U*).\r\n\r\n**Examples:** Includes personal and health information that an individual authorizes to be collected, accessed, used or disclosed to a bank for a health credit card or savings account; to health oversight authorities; to a hospital patient directory; to worker compensation, disability, property and casualty or life insurers; and to personal health record systems, consumer-controlled devices, social media accounts and online Apps; or for marketing purposes",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23322"
            }
          ]
        },
        {
          "code" : "N",
          "display" : "normal",
          "definition" : "Privacy metadata indicating the level of protection required to safeguard personal and healthcare information, which if disclosed without authorization, would present a considerable risk of harm to an individual's reputation and sense of privacy.\r\n\r\n*Usage Note:* The level of protection afforded normatively confidential information is dictated by the prevailing normative privacy policies, which are intended to engender patient trust in their healthcare providers.\r\n\r\nPrivacy policies mandating normative levels of protection, which preempt less protective privacy policies when the information is used in the delivery and management of healthcare. May be pre-empted by jurisdictional law (e.g., for public health reporting or emergency treatment).\r\n\r\nConfidentiality code total order hierarchy: Normal (N) is less protective than *V* and *R*, and subsumes all other protection levels (i.e., *M, L, and U*).\r\n\r\n**Map:**Partial Map to ISO 13606-4 Sensitivity Level (3) Clinical Care when purpose of use is treatment: Default for normal clinical care access (i.e., most clinical staff directly caring for the patient should be able to access nearly all of the EHR). Maps to normal confidentiality for treatment information but not to ancillary care, payment and operations.\r\n\r\n**Examples:** \r\n\r\nn the US, this includes what HIPAA identifies as protected health information (PHI) under 45 CFR Section 160.103.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10230"
            }
          ]
        },
        {
          "code" : "R",
          "display" : "restricted",
          "definition" : "Privacy metadata indicating the level of protection required to safeguard potentially stigmatizing information, which if disclosed without authorization, would present a high risk of harm to an individual's reputation and sense of privacy.\r\n\r\n*Usage Note:* The level of protection afforded restricted confidential information is dictated by specially protective organizational or jurisdictional privacy policies, including at an authorized individual's request, intended to engender patient trust in providers of sensitive services.\r\n\r\nPrivacy policies mandating additional levels of protection by restricting information access preempt less protective privacy policies when the information is used in the delivery and management of healthcare. May be pre-empted by jurisdictional law (e.g., for public health reporting or emergency treatment).\r\n\r\nConfidentiality code total order hierarchy: Restricted (R) is less protective than *V*, and subsumes all other protection levels (i.e., *N, M, L, and U*).\r\n\r\n**Examples:** \r\n\r\nIncludes information that is additionally protected such as sensitive conditions mental health, HIV, substance abuse, domestic violence, child abuse, genetic disease, and reproductive health; or sensitive demographic information such as a patient's standing as an employee or a celebrity. May be used to indicate proprietary or classified information that is not related to an individual (e.g., secret ingredients in a therapeutic substance; or the name of a manufacturer).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10232"
            }
          ]
        },
        {
          "code" : "U",
          "display" : "unrestricted",
          "definition" : "Privacy metadata indicating that no level of protection is required to safeguard personal and healthcare information that has been disclosed by an authorized individual without restrictions on its use.\r\n\r\n**Examples:** Includes publicly available information e.g., business name, phone, email and physical address.\r\n\r\n*Usage Note:* The authorization to collect, access, use, and disclose this information may be stipulated in a contract of adhesion by a data user (e.g., via terms of service or data user privacy policies) in exchange for the data subject's use of a service.\r\n\r\nThis metadata indicates that the receiver has no obligation to consider privacy policies other than its own when making access control decisions.\r\n\r\nThis metadata indicates that the receiver has no obligation to consider privacy policies other than its own when making access control decisions.\r\n\r\nConfidentiality code total order hierarchy: Unrestricted (U) is less protective than *V, R, N, M,* and *L*, and is the lowest protection levels.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23321"
            }
          ]
        },
        {
          "code" : "V",
          "display" : "very restricted",
          "definition" : "Privacy metadata indicating the level of protection required under atypical cicumstances to safeguard potentially damaging or harmful information, which if disclosed without authorization, would (1) present an extremely high risk of harm to an individual's reputation, sense of privacy, and possibly safety; or (2) impact an individual's or organization's legal matters.\r\n\r\n*Usage Note:* The level of protection afforded very restricted confidential information is dictated by specially protective privacy or legal policies intended to ensure that under atypical circumstances additional protections limit access to only those with a high 'need to know' and the information is kept in highest confidence..\r\n\r\nPrivacy and legal policies mandating the highest level of protection by stringently restricting information access, preempt less protective privacy policies when the information is used in the delivery and management of healthcare including legal proceedings related to healthcare. May be pre-empted by jurisdictional law (e.g., for public health reporting or emergency treatment but only under limited circumstances).\r\n\r\nConfidentiality code total order hierarchy: Very Restricted (V) is the highest protection level and subsumes all other protection levels s (i.e., *R, N, M, L, and UI*).\r\n\r\n**Examples:** \r\n\r\nIncludes information about a victim of abuse, patient requested information sensitivity, and taboo subjects relating to health status that must be discussed with the patient by an attending provider before sharing with the patient. May also include information held under a legal hold or attorney-client privilege.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14799"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ConfidentialityByAccessKind",
      "display" : "ConfidentialityByAccessKind",
      "definition" : "**Description:** By accessing subject / role and relationship based rights (These concepts are mutually exclusive, one and only one is required for a valid confidentiality coding.)\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21049"
        }
      ],
      "concept" : [
        {
          "code" : "B",
          "display" : "business",
          "definition" : "**Description:** Since the service class can represent knowledge structures that may be considered a trade or business secret, there is sometimes (though rarely) the need to flag those items as of business level confidentiality. However, no patient related information may ever be of this confidentiality level.\r\n\r\n*Deprecation Comment:* Replced by ActCode.B",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10235"
            }
          ]
        },
        {
          "code" : "D",
          "display" : "clinician",
          "definition" : "**Description:** Only clinicians may see this item, billing and administration persons can not access this item without special permission.\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10231"
            }
          ]
        },
        {
          "code" : "I",
          "display" : "individual",
          "definition" : "**Description:** Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor type code).\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10233"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ConfidentialityByInfoType",
      "display" : "ConfidentialityByInfoType",
      "definition" : "**Description:** By information type, only for service catalog entries (multiples allowed). Not to be used with actual patient data!\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21050"
        }
      ],
      "concept" : [
        {
          "code" : "ETH",
          "display" : "substance abuse related",
          "definition" : "**Description:** Alcohol/drug-abuse related item\r\n\r\n*Deprecation Comment:*Replced by ActCode.ETH",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10243"
            }
          ]
        },
        {
          "code" : "HIV",
          "display" : "HIV related",
          "definition" : "**Description:** HIV and AIDS related item\r\n\r\n*Deprecation Comment:*Replced by ActCode.HIV",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10241"
            }
          ]
        },
        {
          "code" : "PSY",
          "display" : "psychiatry relate",
          "definition" : "**Description:** Psychiatry related item\r\n\r\n*Deprecation Comment:*Replced by ActCode.PSY",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10242"
            }
          ]
        },
        {
          "code" : "SDV",
          "display" : "sexual and domestic violence related",
          "definition" : "**Description:** Sexual assault / domestic violence related item\r\n\r\n*Deprecation Comment:*Replced by ActCode.SDV",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10244"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ConfidentialityModifiers",
      "display" : "ConfidentialityModifiers",
      "definition" : "**Description:** Modifiers of role based access rights (multiple allowed)\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21051"
        }
      ],
      "concept" : [
        {
          "code" : "C",
          "display" : "celebrity",
          "definition" : "**Description:** Celebrities are people of public interest (VIP) including employees, whose information require special protection.\r\n\r\n*Deprecation Comment:*Replced by ActCode.CEL",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10239"
            }
          ]
        },
        {
          "code" : "S",
          "display" : "sensitive",
          "definition" : "**Description:** \r\n\r\nInformation for which the patient seeks heightened confidentiality. Sensitive information is not to be shared with family members. Information reported by the patient about family members is sensitive by default. Flag can be set or cleared on patient's request.\r\n\r\n*Deprecation Comment:*Deprecated due to updated confidentiality codes under ActCode",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10237"
            }
          ]
        },
        {
          "code" : "T",
          "display" : "taboo",
          "definition" : "**Description:** Information not to be disclosed or discussed with patient except through physician assigned to patient in this case. This is usually a temporary constraint only, example use is a new fatal diagnosis or finding, such as malignancy or HIV.\r\n\r\n*Deprecation Note:*Replced by ActCode.TBOO",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10238"
            }
          ]
        }
      ]
    }
  ]
}

```
