# CompressionAlgorithm - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CompressionAlgorithm**

## CodeSystem: CompressionAlgorithm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-CompressionAlgorithm | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CompressionAlgorithm |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1009 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Type of compression algorithm used 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CompressionAlgorithm](ValueSet-v3-CompressionAlgorithm.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-CompressionAlgorithm",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-CompressionAlgorithm",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1009"
    }
  ],
  "version" : "3.0.0",
  "name" : "CompressionAlgorithm",
  "title" : "CompressionAlgorithm",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Type of compression algorithm used",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "howApplies",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-how-applies",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "BZ",
      "display" : "bzip",
      "definition" : "bzip-2 compression format. See \\[http://www.bzip.org/\\] for more information.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23535"
        }
      ]
    },
    {
      "code" : "DF",
      "display" : "deflate",
      "definition" : "The deflate compressed data format as specified in RFC 1951 \\[http://www.ietf.org/rfc/rfc1951.txt\\].",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10621"
        },
        {
          "code" : "howApplies",
          "valueString" : "mandatory"
        }
      ]
    },
    {
      "code" : "GZ",
      "display" : "gzip",
      "definition" : "A compressed data format that is compatible with the widely used GZIP utility as specified in RFC 1952 \\[http://www.ietf.org/rfc/rfc1952.txt\\] (uses the deflate algorithm).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10622"
        },
        {
          "code" : "howApplies",
          "valueString" : "other"
        }
      ]
    },
    {
      "code" : "Z",
      "display" : "compress",
      "definition" : "Original UNIX compress algorithm and file format using the LZC algorithm (a variant of LZW). Patent encumbered and less efficient than deflate.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10624"
        },
        {
          "code" : "howApplies",
          "valueString" : "deprecated"
        }
      ]
    },
    {
      "code" : "Z7",
      "display" : "Z7",
      "definition" : "7z compression file format. See \\[http://www.7-zip.org/7z.html\\] for more information.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23536"
        }
      ]
    },
    {
      "code" : "ZL",
      "display" : "zlib",
      "definition" : "A compressed data format that also uses the deflate algorithm. Specified as RFC 1950 \\[http://www.ietf.org/rfc/rfc1952.txt\\]",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10623"
        },
        {
          "code" : "howApplies",
          "valueString" : "other"
        }
      ]
    }
  ]
}

```
