# ActExposureLevelCode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActExposureLevelCode**

## CodeSystem: ActExposureLevelCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActExposureLevelCode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActExposureLevelCode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1114 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as "low", "medium" and "high". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActExposureLevelCode](ValueSet-v3-ActExposureLevelCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActExposureLevelCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActExposureLevelCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1114"
    }
  ],
  "version" : "3.0.0",
  "name" : "ActExposureLevelCode",
  "title" : "ActExposureLevelCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as \"low\", \"medium\" and \"high\". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_ActExposureLevelCode",
      "display" : "ActExposureLevelCode",
      "definition" : "A qualitative measure of the degree of exposure to the causative agent. This includes concepts such as \"low\", \"medium\" and \"high\". This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22372"
        }
      ],
      "concept" : [
        {
          "code" : "HIGH",
          "display" : "high",
          "definition" : "**Description:** Exposure to an agent at a relatively high level above background.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22373"
            }
          ]
        },
        {
          "code" : "LOW",
          "display" : "low",
          "definition" : "**Description:** Exposure to an agent at a relatively low level above background.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22374"
            }
          ]
        },
        {
          "code" : "MEDIUM",
          "display" : "medium",
          "definition" : "**Description:** Exposure to an agent at a relatively moderate level above background.A",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22375"
            }
          ]
        }
      ]
    }
  ]
}

```
