# AcknowledgementType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AcknowledgementType**

## CodeSystem: AcknowledgementType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-AcknowledgementType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AcknowledgementType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.18 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This attribute contains an acknowledgement code as described in the HL7 message processing rules. 
**OpenIssue:**Description was copied from attribute and needs to be improved to be appropriate for a code system. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AcknowledgementType](ValueSet-v3-AcknowledgementType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-AcknowledgementType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-AcknowledgementType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.18"
    }
  ],
  "version" : "3.0.0",
  "name" : "AcknowledgementType",
  "title" : "AcknowledgementType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This attribute contains an acknowledgement code as described in the HL7 message processing rules.\r\n\r\n*OpenIssue:* Description was copied from attribute and needs to be improved to be appropriate for a code system.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Application Acknowledgement Accept",
      "definition" : "Receiving application successfully processed message.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16022"
        }
      ]
    },
    {
      "code" : "AE",
      "display" : "Application Acknowledgement Error",
      "definition" : "Receiving application found error in processing message. Sending error response with additional error detail information.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16023"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Application Acknowledgement Reject",
      "definition" : "Receiving application failed to process message for reason unrelated to content or format. Original message sender must decide on whether to automatically send message again.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16024"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Accept Acknowledgement Commit Accept",
      "definition" : "Receiving message handling service accepts responsibility for passing message onto receiving application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16025"
        }
      ]
    },
    {
      "code" : "CE",
      "display" : "Accept Acknowledgement Commit Error",
      "definition" : "Receiving message handling service cannot accept message for any other reason (e.g. message sequence number, etc.).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16027"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Accept Acknowledgement Commit Reject",
      "definition" : "Receiving message handling service rejects message if interaction identifier, version or processing mode is incompatible with known receiving application role information.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16026"
        }
      ]
    }
  ]
}

```
