# processInterruptionReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **processInterruptionReason**

## CodeSystem: processInterruptionReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0935 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessInterruptionReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.435 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the reason for the process interruption. Used in HL7 Version 2.x messaging in the DON segment. 

 
Underlying Master Code System for V2 table 0935 (Process Interruption Reason) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcessInterruptionReason](ValueSet-v2-0935.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0935",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0935",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.435"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProcessInterruptionReason",
  "title" : "processInterruptionReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the reason for the process interruption.  Used in HL7 Version 2.x messaging in the DON segment.",
  "purpose" : "Underlying Master Code System for V2 table 0935 (Process Interruption Reason)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0935",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6696",
      "code" : "NRG",
      "display" : "No reason given, donor decided to stop without giving a reason",
      "definition" : "No reason given, donor decided to stop without giving a reason",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6697",
      "code" : "PCD",
      "display" : "Phone Call-Donor",
      "definition" : "Phone Call-Donor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6698",
      "code" : "DCW",
      "display" : "Couldn't wait",
      "definition" : "Couldn't wait",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6699",
      "code" : "CFT",
      "display" : "Couldn't follow through with donation (scared)",
      "definition" : "Couldn't follow through with donation (scared)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6700",
      "code" : "DBB",
      "display" : "Bathroom",
      "definition" : "Bathroom",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6701",
      "code" : "DNI",
      "display" : "Phlebotomy Issue",
      "definition" : "Phlebotomy Issue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6702",
      "code" : "ASC",
      "display" : "Apheresis Software Crash",
      "definition" : "Apheresis Software Crash",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6703",
      "code" : "BSC",
      "display" : "Manufacturing Software Crash",
      "definition" : "Manufacturing Software Crash",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6704",
      "code" : "GFE",
      "display" : "General Facility Emergency",
      "definition" : "General Facility Emergency",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Power outage,  natural disaster (tornado, flood, hurricane, etc.), air conditioning failure, etc."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Power outage,  natural disaster (tornado, flood, hurricane, etc.), air conditioning failure, etc."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
