# drgstatusWeightAtBirth - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **drgstatusWeightAtBirth**

## CodeSystem: drgstatusWeightAtBirth 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0755 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DrgstatusWeightAtBirth |
| *Other Identifiers:*OID:2.16.840.1.113883.18.397 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. 

 
Underlying Master Code System for V2 table 0755 (Status Weight At Birth) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSStatusWeightAtBirth](ValueSet-v2-0755.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0755",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0755",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.397"
    }
  ],
  "version" : "3.0.0",
  "name" : "DrgstatusWeightAtBirth",
  "title" : "drgstatusWeightAtBirth",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of the use of the weight at birth for diagnosis related group (DRG) determination.  US Realm.  Used in HL7 Version 2.x messaging in the DRG segment.",
  "purpose" : "Underlying Master Code System for V2 table 0755 (Status Weight At Birth)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0755",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6454",
      "code" : "0",
      "display" : "No weight reported at admission used for grouping",
      "definition" : "No weight reported at admission used for grouping",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6455",
      "code" : "1",
      "display" : "Weight reported at admission used for grouping",
      "definition" : "Weight reported at admission used for grouping",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6456",
      "code" : "2",
      "display" : "Default weight (>2499g) used for grouping",
      "definition" : "Default weight (>2499g) used for grouping",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
