# addressExpirationReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **addressExpirationReason**

## CodeSystem: addressExpirationReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0616 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AddressExpirationReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.374 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the reason this address was marked as "ended". Used in HL7 Version 2.x messaging in the XAD segment. 

 
Underlying Master Code System for V2 table 0616 (Address Expiration Reason) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAddressExpirationReason](ValueSet-v2-0616.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0616",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0616",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.374"
    }
  ],
  "version" : "3.0.0",
  "name" : "AddressExpirationReason",
  "title" : "addressExpirationReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the reason this address was marked as \"ended\".  Used in HL7 Version 2.x messaging in the XAD segment.",
  "purpose" : "Underlying Master Code System for V2 table 0616 (Address Expiration Reason)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0616",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6255",
      "code" : "M",
      "display" : "Moved",
      "definition" : "Moved",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The individual associated with the address has moved and is no longer reachable at the address"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The individual associated with the address has moved and is no longer reachable at the address"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6256",
      "code" : "E",
      "display" : "Added in error",
      "definition" : "Added in error",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The address was incorrect and should never have been associated with the individual"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The address was incorrect and should never have been associated with the individual"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6257",
      "code" : "R",
      "display" : "On request",
      "definition" : "On request",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The associated individual requested that the address be removed from their record"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The associated individual requested that the address be removed from their record"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6258",
      "code" : "C",
      "display" : "Corrected",
      "definition" : "Corrected",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The address has been replaced with a corrected version"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The address has been replaced with a corrected version"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
