# invoiceProcessingResultsStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **invoiceProcessingResultsStatus**

## CodeSystem: invoiceProcessingResultsStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0571 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InvoiceProcessingResultsStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.371 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the processing status for an Invoice Processing Result. Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0571 (Invoice Processing Results Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSInvoiceProcessingResultsStatus](ValueSet-v2-0571.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0571",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0571",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.371"
    }
  ],
  "version" : "3.0.0",
  "name" : "InvoiceProcessingResultsStatus",
  "title" : "invoiceProcessingResultsStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the processing status for an Invoice Processing Result.  Used in the Invoice Processing Result (IPR) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0571 (Invoice Processing Results Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0571",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6243",
      "code" : "ACK",
      "display" : "Acknowledge",
      "definition" : "Acknowledge",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Empfangsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6244",
      "code" : "REJECT",
      "display" : "Reject",
      "definition" : "Reject",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6245",
      "code" : "PEND",
      "display" : "Pending",
      "definition" : "Pending",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6246",
      "code" : "ADJZER",
      "display" : "Adjudicated to Zero",
      "definition" : "Adjudicated to Zero",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6247",
      "code" : "ADJSUB",
      "display" : "Adjudicated as Submitted",
      "definition" : "Adjudicated as Submitted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6248",
      "code" : "ADJ",
      "display" : "Adjudicated with Adjustments",
      "definition" : "Adjudicated with Adjustments",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6249",
      "code" : "PAID",
      "display" : "Paid",
      "definition" : "Paid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6250",
      "code" : "PRED",
      "display" : "Pre-Determination",
      "definition" : "Pre-Determination",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Indicates that the IPR has been adjudicated but will not be paid.  Equivalent to ADJUD (Adjudicate)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Indicates that the IPR has been adjudicated but will not be paid.  Equivalent to ADJUD (Adjudicate)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
