# bloodProductTransfusion-dispositionStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **bloodProductTransfusion-dispositionStatus**

## CodeSystem: bloodProductTransfusion-dispositionStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0513 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BloodProductTransfusionDispositionStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.335 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer. For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been "transfused." Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0513 (Blood Product Transfusion/Disposition Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSBloodProductTransfusionDispositionStatus](ValueSet-v2-0513.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0513",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0513",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.335"
    }
  ],
  "version" : "3.0.0",
  "name" : "BloodProductTransfusionDispositionStatus",
  "title" : "bloodProductTransfusion-dispositionStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the current status of the specified blood product as indicated by the placer.  For example, the placer may return the blood product to the transfusion service unused because an IV could not be started. The blood component may have been entered, but the line was clogged and could not be used, in which case the component must be wasted. A final status would indicate that the product has actually been \"transfused.\"  Used in the Blood Product Transfusion/Disposition (BTX) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0513 (Blood Product Transfusion/Disposition Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0513",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5560",
      "code" : "RA",
      "display" : "Returned unused and unlinked",
      "definition" : "Blood product was returned unused, because it is no longer needed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5561",
      "code" : "RL",
      "display" : "Returned unused but linked",
      "definition" : "Blood product was returned unused, because it is not currently needed, but should remain linked to the patient for future use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5562",
      "code" : "WA",
      "display" : "Wasted",
      "definition" : "The blood product is no longer viable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5563",
      "code" : "TI",
      "display" : "Transfusion Interrupted",
      "definition" : "Transfusion of the blood product was interrupted and considered ended; a reason for interruption is usually also reported.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "This is not expected to be an end state; transfusion will either be ended or restarted."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "5564",
      "code" : "TR",
      "display" : "Transfusion Ended with Reactions",
      "definition" : "The blood product has been transfused and it caused an adverse reaction.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5565",
      "code" : "TS",
      "display" : "Transfusion Started",
      "definition" : "Transfusion of the blood product has been started and is in progress",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "This code may be used for restart if interrupted as well."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "5566",
      "code" : "TX",
      "display" : "Transfusion Ended",
      "definition" : "The blood product has been transfused with a normal end to the transfusion.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
