# dispenseType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **dispenseType**

## CodeSystem: dispenseType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0484 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DispenseType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.309 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the type of dispensing event that occurred. Used in HL7 Version 2.x messaging in the RXD segment. 

 
Underlying Master Code System for V2 table 0484 (Dispense Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDispenseType](ValueSet-v2-0484.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0484",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0484",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.309"
    }
  ],
  "version" : "3.0.0",
  "name" : "DispenseType",
  "title" : "dispenseType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the type of dispensing event that occurred.  Used in HL7 Version 2.x messaging in the RXD segment.",
  "purpose" : "Underlying Master Code System for V2 table 0484 (Dispense Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0484",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4913",
      "code" : "B",
      "display" : "Trial Quantity Balance",
      "definition" : "Trial Quantity Balance",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4914",
      "code" : "C",
      "display" : "Compassionate Fill",
      "definition" : "Compassionate Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4915",
      "code" : "N",
      "display" : "New/Renew - Full Fill",
      "definition" : "New/Renew - Full Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4916",
      "code" : "P",
      "display" : "New/Renew - Part Fill",
      "definition" : "New/Renew - Part Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4917",
      "code" : "Q",
      "display" : "Refill - Part Fill",
      "definition" : "Refill - Part Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4918",
      "code" : "R",
      "display" : "Refill - Full Fill",
      "definition" : "Refill - Full Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4919",
      "code" : "S",
      "display" : "Manufacturer Sample",
      "definition" : "Manufacturer Sample",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4920",
      "code" : "T",
      "display" : "Trial Quantity",
      "definition" : "Trial Quantity",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4921",
      "code" : "Z",
      "display" : "Non-Prescription Fill",
      "definition" : "Non-Prescription Fill",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
