# riskManagementIncident - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **riskManagementIncident**

## CodeSystem: riskManagementIncident 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0427 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RiskManagementIncident |
| *Other Identifiers:*OID:2.16.840.1.113883.18.268 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay. Used in HL7 Version 2 messaging in the RMI segment. 

 
Underlying Master Code System for V2 table 0427 (Risk Management Incident Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSRiskManagementIncidentCode](ValueSet-v2-0427.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0427",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0427",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.268"
    }
  ],
  "version" : "3.0.0",
  "name" : "RiskManagementIncident",
  "title" : "riskManagementIncident",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a type of incident that occurs during a patient’s stay.  Used in HL7 Version 2 messaging in the RMI segment.",
  "purpose" : "Underlying Master Code System for V2 table 0427 (Risk Management Incident Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0427",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4606",
      "code" : "B",
      "display" : "Body fluid exposure",
      "definition" : "Body fluid exposure",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4607",
      "code" : "C",
      "display" : "Contaminated Substance",
      "definition" : "Contaminated Substance",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4608",
      "code" : "D",
      "display" : "Diet Errors",
      "definition" : "Diet Errors",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4609",
      "code" : "E",
      "display" : "Equipment problem",
      "definition" : "Equipment problem",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4610",
      "code" : "F",
      "display" : "Patient fell (not from bed)",
      "definition" : "Patient fell (not from bed)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4611",
      "code" : "H",
      "display" : "Patient fell from bed",
      "definition" : "Patient fell from bed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4612",
      "code" : "I",
      "display" : "Infusion error",
      "definition" : "Infusion error",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4613",
      "code" : "J",
      "display" : "Foreign object left during surgery",
      "definition" : "Foreign object left during surgery",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4614",
      "code" : "K",
      "display" : "Sterile precaution violated",
      "definition" : "Sterile precaution violated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4615",
      "code" : "P",
      "display" : "Procedure error",
      "definition" : "Procedure error",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4616",
      "code" : "R",
      "display" : "Pharmaceutical error",
      "definition" : "Pharmaceutical error",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4617",
      "code" : "S",
      "display" : "Suicide Attempt",
      "definition" : "Suicide Attempt",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4618",
      "code" : "T",
      "display" : "Transfusion error",
      "definition" : "Transfusion error",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4619",
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
