# natureOfChallenge - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **natureOfChallenge**

## CodeSystem: natureOfChallenge 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0257 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NatureOfChallenge |
| *Other Identifiers:*OID:2.16.840.1.113883.18.152 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation. Used in HL7 Version 2.x messaging in the OM1 segment. 

 
Underlying Master Code System for V2 table 0257 (Nature of Challenge) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSNatureOfChallenge](ValueSet-v2-0257.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0257",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0257",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.152"
    }
  ],
  "version" : "3.0.0",
  "name" : "NatureOfChallenge",
  "title" : "natureOfChallenge",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation.  Used in HL7 Version 2.x messaging in the OM1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0257 (Nature of Challenge)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0257",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2557",
      "code" : "CFST",
      "display" : "Fasting (no calorie intake) for the period specified in the time component of the term, e.g., 1H POST CFST",
      "definition" : "Fasting (no calorie intake) for the period specified in the time component of the term, e.g., 1H POST CFST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2558",
      "code" : "EXCZ",
      "display" : "Exercise undertaken as challenge (can be quantified)",
      "definition" : "Exercise undertaken as challenge (can be quantified)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2559",
      "code" : "FFST",
      "display" : "No fluid intake for the period specified in the time component of the term",
      "definition" : "No fluid intake for the period specified in the time component of the term",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
