# indirectExposureMechanism - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **indirectExposureMechanism**

## CodeSystem: indirectExposureMechanism 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0253 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:IndirectExposureMechanism |
| *Other Identifiers:*OID:2.16.840.1.113883.18.148 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient. Used in HL7 Version 2.x messaging in the PCR segment. 

 
Underlying Master Code System for V2 table 0253 (Indirect Exposure Mechanism) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSIndirectExposureMechanism](ValueSet-v2-0253.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0253",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0253",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.148"
    }
  ],
  "version" : "3.0.0",
  "name" : "IndirectExposureMechanism",
  "title" : "indirectExposureMechanism",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient.  Used in HL7 Version 2.x messaging in the PCR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0253 (Indirect Exposure Mechanism)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0253",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2379",
      "code" : "B",
      "display" : "Breast milk",
      "definition" : "Breast milk",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2380",
      "code" : "P",
      "display" : "Transplacental",
      "definition" : "Transplacental",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2381",
      "code" : "F",
      "display" : "Father",
      "definition" : "Father",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2382",
      "code" : "X",
      "display" : "Blood product",
      "definition" : "Blood product",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2383",
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
