# relatednessAssessment - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **relatednessAssessment**

## CodeSystem: relatednessAssessment 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0250 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RelatednessAssessment |
| *Other Identifiers:*OID:2.16.840.1.113883.18.145 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to provide an estimate of whether an issue with a product was the cause of an event. Used in HL7 Version 2.x messaging in the PCR segment. 

 
Underlying Master Code System for V2 table 0250 (Relatedness Assessment) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSRelatednessAssessment](ValueSet-v2-0250.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0250",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0250",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.145"
    }
  ],
  "version" : "3.0.0",
  "name" : "RelatednessAssessment",
  "title" : "relatednessAssessment",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to provide an estimate of whether an issue with a  product was the cause of an event.  Used in HL7 Version 2.x messaging in the PCR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0250 (Relatedness Assessment)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0250",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2357",
      "code" : "H",
      "display" : "Highly probable",
      "definition" : "Highly probable",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2358",
      "code" : "M",
      "display" : "Moderately probable",
      "definition" : "Moderately probable",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2359",
      "code" : "S",
      "display" : "Somewhat probable",
      "definition" : "Somewhat probable",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2360",
      "code" : "I",
      "display" : "Improbable",
      "definition" : "Improbable",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2361",
      "code" : "N",
      "display" : "Not related",
      "definition" : "Not related",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
