# Title Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Title Type**

## CodeSystem: Title Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/title-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:TitleType |

 
Used to express the reason and specific aspect for the variant title, such as language and specific language. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [TitleType](ValueSet-title-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "title-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/title-type",
  "version" : "1.0.0",
  "name" : "TitleType",
  "title" : "Title Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to express the reason and specific aspect for the variant title, such as language and specific language.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/title-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "primary",
      "display" : "Primary title",
      "definition" : "Main title for common use. The primary title used for representation if multiple titles exist."
    },
    {
      "code" : "official",
      "display" : "Official title",
      "definition" : "The official or authoritative title."
    },
    {
      "code" : "scientific",
      "display" : "Scientific title",
      "definition" : "Title using scientific terminology."
    },
    {
      "code" : "plain-language",
      "display" : "Plain language title",
      "definition" : "Title using language common to lay public discourse."
    },
    {
      "code" : "subtitle",
      "display" : "Subtitle",
      "definition" : "Subtitle or secondary title."
    },
    {
      "code" : "short-title",
      "display" : "Short title",
      "definition" : "Brief title (e.g. 'running title' or title used in page headers)"
    },
    {
      "code" : "acronym",
      "display" : "Acronym",
      "definition" : "Abbreviation used as title"
    },
    {
      "code" : "earlier-title",
      "display" : "Different text in an earlier version",
      "definition" : "Alternative form of title in an earlier version such as epub ahead of print."
    },
    {
      "code" : "language",
      "display" : "Different language",
      "definition" : "Additional form of title in a different language."
    },
    {
      "code" : "autotranslated",
      "display" : "Different language derived from autotranslation",
      "definition" : "Machine translated form of title in a different language, language element codes the language into which it was translated by machine."
    },
    {
      "code" : "human-use",
      "display" : "Human use",
      "definition" : "Human-friendly title"
    },
    {
      "code" : "machine-use",
      "display" : "Machine use",
      "definition" : "Machine-friendly title"
    },
    {
      "code" : "duplicate-uid",
      "display" : "Different text for the same object with a different identifier",
      "definition" : "An alternative form of the title in two or more entries, e.g. in multiple medline entries"
    }
  ]
}

```
