# StatisticSynthesisType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticSynthesisType**

## CodeSystem: StatisticSynthesisType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/synthesis-type | *Version*:2.0.0 | |
| Active as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticSynthesisType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1348 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Types of combining results from a body of evidence (eg. summary data meta-analysis). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticSynthesisType](ValueSet-synthesis-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "synthesis-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/synthesis-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1348"
    }
  ],
  "version" : "2.0.0",
  "name" : "StatisticSynthesisType",
  "title" : "StatisticSynthesisType",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Types of combining results from a body of evidence (eg. summary data meta-analysis).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/synthesis-type",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "std-MA",
      "display" : "summary data meta-analysis",
      "definition" : "A meta-analysis of the summary data of estimates from individual studies or data sets."
    },
    {
      "code" : "IPD-MA",
      "display" : "individual patient data meta-analysis",
      "definition" : "A meta-analysis of the individual participant data from individual studies or data sets."
    },
    {
      "code" : "indirect-NMA",
      "display" : "indirect network meta-analysis",
      "definition" : "An indirect meta-analysis derived from 2 or more direct comparisons in a network meta-analysis."
    },
    {
      "code" : "combined-NMA",
      "display" : "combined direct plus indirect network meta-analysis",
      "definition" : "An composite meta-analysis derived from direct comparisons and indirect comparisons in a network meta-analysis."
    },
    {
      "code" : "range",
      "display" : "range of results",
      "definition" : "A range of results across a body of evidence."
    },
    {
      "code" : "classification",
      "display" : "classifcation of results",
      "definition" : "An approach describing a body of evidence by categorically classifying individual studies (eg 3 studies showed beneft and 2 studied found no effect)."
    },
    {
      "code" : "NotApplicable",
      "display" : "not applicable",
      "definition" : "Not applicable because the evidence is not from a synthesis but from a single study. Used fo explicitly state that it's not a synthesis."
    },
    {
      "code" : "pooled",
      "display" : "pooled rates",
      "definition" : "An unweighted average.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    }
  ]
}

```
