# Audit Event Source Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Audit Event Source Type**

## CodeSystem: Audit Event Source Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/security-source-type | *Version*:1.0.0 | | |
| Active as of 2010-08-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AuditEventSourceType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1137 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The type of process where the audit event originated from. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AuditEventSourceType](ValueSet-audit-source-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "security-source-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sec"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/security-source-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1137"
    }
  ],
  "version" : "1.0.0",
  "name" : "AuditEventSourceType",
  "title" : "Audit Event Source Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2010-08-26T10:00:00+10:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of process where the audit event originated from.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/audit-source-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "User Device",
      "definition" : "End-user display device, diagnostic device."
    },
    {
      "code" : "2",
      "display" : "Data Interface",
      "definition" : "Data acquisition device or instrument."
    },
    {
      "code" : "3",
      "display" : "Web Server",
      "definition" : "Web Server process or thread."
    },
    {
      "code" : "4",
      "display" : "Application Server",
      "definition" : "Application Server process or thread."
    },
    {
      "code" : "5",
      "display" : "Database Server",
      "definition" : "Database Server process or thread."
    },
    {
      "code" : "6",
      "display" : "Security Server",
      "definition" : "Security server, e.g. a domain controller."
    },
    {
      "code" : "7",
      "display" : "Network Device",
      "definition" : "ISO level 1-3 network component."
    },
    {
      "code" : "8",
      "display" : "Network Router",
      "definition" : "ISO level 4-6 operating software."
    },
    {
      "code" : "9",
      "display" : "Other",
      "definition" : "Other kind of device (defined by DICOM, but some other code/system can be used)."
    }
  ]
}

```
