# Organization type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization type**

## CodeSystem: Organization type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/organization-type | *Version*:2.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrganizationType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1128 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of codes that can be used to indicate a type of organization. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [OrganizationType](ValueSet-organization-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/organization-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1128"
    }
  ],
  "version" : "2.0.1",
  "name" : "OrganizationType",
  "title" : "Organization type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to indicate a type of organization.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/organization-type",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental,      deprecated, and retired",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "prov",
      "display" : "Healthcare Provider",
      "definition" : "An organization that provides healthcare services."
    },
    {
      "code" : "dept",
      "display" : "Hospital Department",
      "definition" : "A department or ward within a hospital (Generally is not applicable to top level organizations)"
    },
    {
      "code" : "team",
      "display" : "Organizational team",
      "definition" : "An organizational team is usually a grouping of practitioners that perform a specific function within an organization (which could be a top level organization, or a department)."
    },
    {
      "code" : "govt",
      "display" : "Government",
      "definition" : "A political body, often used when including organization records for government bodies such as a Federal Government, State or Local Government."
    },
    {
      "code" : "ins",
      "display" : "Insurance Company",
      "definition" : "A company that provides insurance to its subscribers that may include healthcare related policies."
    },
    {
      "code" : "pay",
      "display" : "Payer",
      "definition" : "A company, charity, or governmental organization, which processes claims and/or issues payments to providers on behalf of patients or groups of patients."
    },
    {
      "code" : "edu",
      "display" : "Educational Institute",
      "definition" : "An educational institution that provides education or research facilities."
    },
    {
      "code" : "reli",
      "display" : "Religious Institution",
      "definition" : "An organization that is identified as a part of a religious institution."
    },
    {
      "code" : "crs",
      "display" : "Clinical Research Sponsor",
      "definition" : "An organization that is identified as a Pharmaceutical/Clinical Research Sponsor."
    },
    {
      "code" : "cg",
      "display" : "Community Group",
      "definition" : "An un-incorporated community group."
    },
    {
      "code" : "bus",
      "display" : "Non-Healthcare Business or Corporation",
      "definition" : "An organization that is a registered business or corporation but not identified by other types."
    },
    {
      "code" : "ntwk",
      "display" : "Network",
      "definition" : "A healthcare provider insurance network"
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Other type of organization not already specified.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    }
  ]
}

```
