# Organization Affiliation Role for HIE - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Affiliation Role for HIE**

## CodeSystem: Organization Affiliation Role for HIE 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/organization-affiliation-role-for-hie | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrganizationAffiliationRoleForHie |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes that can be used to indicate an organization affiliation role for HIE. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [OrganizationAffiliationRole](ValueSet-organization-affiliation-role.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-affiliation-role-for-hie",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/organization-affiliation-role-for-hie",
  "version" : "1.0.0",
  "name" : "OrganizationAffiliationRoleForHie",
  "title" : "Organization Affiliation Role for HIE",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes that can be used to indicate an organization affiliation role for HIE.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/organization-affiliation-role-for-hie",
  "content" : "complete",
  "concept" : [
    {
      "code" : "HieInitiator",
      "display" : "HIE Initiator",
      "definition" : "Indicate that the organization referenced in .participatingOrganization is a member of the network led by the organization mentioned in .organization. It has both the permission and the intention to request data from other members of the network. In this context, OrganizationAffiliation.endpoint refers to the endpoint utilized by .participatingOrganization to make requests to the Initiating Gateway, acting under the authority of .organization."
    },
    {
      "code" : "HieResponder",
      "display" : "HIE Responder",
      "definition" : "Indicate that the organization linked in .participatingOrganization is a member of the network overseen by the organization in .organization. It possesses an Endpoint capable of receiving requests from other network members that maintain an HIEInitiator relationship with the network's governing organization. In this context, OrganizationAffiliation.endpoint includes endpoints utilized by other network members to transmit requests to .participatingOrganization. This Endpoint may also serve Initiating and Responding gateways operated by .organization."
    },
    {
      "code" : "PartnerConnectivity",
      "display" : "Partner Connectivity",
      "definition" : "Indicate that .participatingOrganization should be able to directly contact .organization via .Endpoint. It does not assert the availability of connectivity for any organizations other than those two directly linked through the OrganizationAffiliation Resource. It's important to note that many document-sharing networks might opt to distribute the information required to establish these connections out of band, rather than through the directory."
    },
    {
      "code" : "DocShareFederateInt",
      "display" : "Document Sharing Federated Internal",
      "definition" : "Indicate that documents from .participatingOrganization are accessible to organizations within the network through communication with the network's Initiating Gateway, which is operated by .organization. In this context, 'within the network' refers to organizations that maintain an HIEInitiator relationship with .organization. This code is analogous to the DocShare-federate code in mCSD (Mobile Care Services Directory), but its scope is confined to organizations internal to the network."
    },
    {
      "code" : "DocShareFederateExt",
      "display" : "Document Sharing Federated External",
      "definition" : "Indicate that documents from .participatingOrganization are accessible to organizations outside the network through communication with the network's Responding Gateway, operated by .organization. Here, 'outside the network' refers to organizations that do not have a child relationship with .organization, yet possess upper-level network or peer connectivity with that organization. This code is analogous to the DocShare-federate code in mCSD (Mobile Care Services Directory), but its scope is restricted to organizations external to the network."
    }
  ]
}

```
