# NDH Healthcare Service Category - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NDH Healthcare Service Category**

## CodeSystem: NDH Healthcare Service Category 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ndh-healthcare-service-category | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NDHHealthcareServiceCategory |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NDHHealthcareServiceCategory](ValueSet-ndh-healthcare-service-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ndh-healthcare-service-category",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ndh-healthcare-service-category",
  "version" : "1.0.0",
  "name" : "NDHHealthcareServiceCategory",
  "title" : "NDH Healthcare Service Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for NDH Healthcare Service Category used in the National Directory of Healthcare Providers and Services (NDH).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ndh-healthcare-service-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "behav",
      "display" : "Behavioral Health",
      "definition" : "Services related to the promotion of mental health, resilience and wellbeing; the treatment of mental and substance use disorders; and the support of those who experience and/or are in recovery from these conditions, along with their families and communities."
    },
    {
      "code" : "dent",
      "display" : "Dental",
      "definition" : "Services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of  the teeth, gums, and mouth."
    },
    {
      "code" : "dme",
      "display" : "DME/Medical Supplies",
      "definition" : "Health care consumables or equipments supplied to patients"
    },
    {
      "code" : "emerg",
      "display" : "Emergency care",
      "definition" : "Health care services rendered within a designated emergency care facility, for point-in-time evaluation and/or treatment any medical condition such that a prudent layperson possessing an average knowledge of medicine and health, believes that immediate unscheduled medical care is required."
    },
    {
      "code" : "group",
      "display" : "Medical Group",
      "definition" : "Health care services provided by a collective of medical practitioners, typically physicians, who work together to deliver coordinated medical care. This group focuses on medical treatment and does not vision or dental services."
    },
    {
      "code" : "home",
      "display" : "Home Health",
      "definition" : "Health care services delivered to patients within their residence rather than a clinical setting; usually provided by nurses, home health aides, and other professionals on a regularly scheduled visit."
    },
    {
      "code" : "hosp",
      "display" : "Hospital",
      "definition" : "Health care services rendered within a hospital or other inpatient setting providng patient treatment with specialzed medical and nursing staff and medical equipment."
    },
    {
      "code" : "lab",
      "display" : "Laboratory",
      "definition" : "Pathology and laboratory testing on clinical specimenst to obtain informaion about the health of a paeint to aid in diagnosis, treatment and prevention of disease."
    },
    {
      "code" : "outpat",
      "display" : "Clinic or Outpatient Facility",
      "definition" : "Health care services rendered in an outpatient facility, e.g. medical procedures, surgeries, etc."
    },
    {
      "code" : "prov",
      "display" : "Medical Provider",
      "definition" : "Individual healthcare services rendered by a licensed medical professional, such as a physician or nurse, focusing on general medical care rather than specialized fields like dentistry or vision."
    },
    {
      "code" : "pharm",
      "display" : "Pharmacy",
      "definition" : "Services related to the storage, compounding, dispensing and sale of drugs."
    },
    {
      "code" : "trans",
      "display" : "Transportation",
      "definition" : "Services related to the transportation of patients to and from a healthcare facility, or programs related to transportation insecurity."
    },
    {
      "code" : "urg",
      "display" : "Urgent Care",
      "definition" : "Unscheduled health care services which provide for point-in-time evaluation or treatment of a non-life-threatening medical condition."
    },
    {
      "code" : "vis",
      "display" : "Vision",
      "definition" : "Services related to the study, diagnosis, prevention, and treatment of diseases, disorders, and conditions of the eyes."
    },
    {
      "code" : "education",
      "display" : "Education",
      "definition" : "Services or programs related to education, including health literacy, health education, and health promotion (stress management, smoking cessation, etc.)"
    },
    {
      "code" : "employment",
      "display" : "Employment",
      "definition" : "Services or programs related to employment assistance."
    },
    {
      "code" : "financial",
      "display" : "Financial",
      "definition" : "Services or programs related to financial insecurity, material hardship, or medical cost burden."
    },
    {
      "code" : "food",
      "display" : "Food",
      "definition" : "Services or programs related to food insecurity or inadequate nutrition."
    },
    {
      "code" : "housing",
      "display" : "Housing",
      "definition" : "Services or programs related to housing instability, inadequate housing, or homelessness."
    },
    {
      "code" : "personal-safety",
      "display" : "Personal Safety",
      "definition" : "Services or programs related to personal safety, including intimate partner violence, elder abuse, sexual violence, and child abuse and neglect."
    },
    {
      "code" : "social-connection",
      "display" : "Social Connection",
      "definition" : "Services or programs related to social isolation or social connection."
    }
  ]
}

```
