# MeasureImprovementNotation - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MeasureImprovementNotation**

## CodeSystem: MeasureImprovementNotation 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-improvement-notation | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureImprovementNotation |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1395 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureImprovementNotation](ValueSet-measure-improvement-notation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-improvement-notation",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-improvement-notation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1395"
    }
  ],
  "version" : "1.0.1",
  "name" : "MeasureImprovementNotation",
  "title" : "MeasureImprovementNotation",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/measure-improvement-notation",
  "content" : "complete",
  "concept" : [
    {
      "code" : "increase",
      "display" : "Increased score indicates improvement",
      "definition" : "Improvement is indicated as an increase in the score or measurement (e.g. Higher score indicates better quality)."
    },
    {
      "code" : "decrease",
      "display" : "Decreased score indicates improvement",
      "definition" : "Improvement is indicated as a decrease in the score or measurement (e.g. Lower score indicates better quality)."
    }
  ]
}

```
