# ISO 21089 2017 Health Record Lifecycle Events - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 21089 2017 Health Record Lifecycle Events**

## CodeSystem: ISO 21089 2017 Health Record Lifecycle Events 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/iso-21089-lifecycle | *Version*:1.0.0 | |
| Active as of 2025-12-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Iso_21089_2017_Health_Record_Lifecycle_Events |
| **Copyright/Legal**: These codes are excerpted from ISO Standard, TS 21089-2017 - Health Informatics - Trusted End-to-End Information Flows, Copyright by ISO International. Copies of this standard are available through the ISO Web Site at www.iso.org. | | |

 
Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informatics - Trusted End-to-End Information Flows, Section 3, Terms and Definitions (2017, at ISO Central Secretariat, passed ballot and ready for publication). This will also be included in the FHIR EHR Record Lifecycle Event Implementation Guide, balloted and (to be) published with FHIR STU-3. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "iso-21089-lifecycle",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/iso-21089-lifecycle",
  "version" : "1.0.0",
  "name" : "Iso_21089_2017_Health_Record_Lifecycle_Events",
  "title" : "ISO 21089 2017 Health Record Lifecycle Events",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Attached is vocabulary for the 27 record lifecycle events, as per ISO TS 21089-2017, Health Informatics - Trusted End-to-End Information Flows, Section 3, Terms and Definitions (2017, at ISO Central Secretariat, passed ballot and ready for publication).  This will also be included in the FHIR EHR Record Lifecycle Event Implementation Guide, balloted and (to be) published with FHIR STU-3.",
  "copyright" : "These codes are excerpted from ISO Standard, TS 21089-2017 - Health Informatics - Trusted End-to-End Information Flows, Copyright by ISO International. Copies of this standard are available through the ISO Web Site at www.iso.org.",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "access",
      "display" : "Access/View Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to obtain and open a record entry for inspection or review."
    },
    {
      "code" : "hold",
      "display" : "Add Legal Hold Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to tag or otherwise indicate special access management and suspension of record entry deletion/destruction, if deemed relevant to a lawsuit or which are reasonably anticipated to be relevant or to fulfill organizational policy under the legal doctrine of “duty to preserve”."
    },
    {
      "code" : "amend",
      "display" : "Amend (Update) Record Lifecycle Event",
      "definition" : "Occurs when an agent makes any change to record entry content currently residing in storage considered permanent (persistent)."
    },
    {
      "code" : "archive",
      "display" : "Archive Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to create and move archive artifacts containing record entry content, typically to long-term offline storage."
    },
    {
      "code" : "attest",
      "display" : "Attest Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to capture the agent’s digital signature (or equivalent indication) during formal validation of record entry content."
    },
    {
      "code" : "decrypt",
      "display" : "Decrypt Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to decode record entry content from a cipher."
    },
    {
      "code" : "deidentify",
      "display" : "De-Identify (Anononymize) Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to scrub record entry content to reduce the association between a set of identifying data and the data subject in a way that might or might not be reversible."
    },
    {
      "code" : "deprecate",
      "display" : "Deprecate Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to tag record entry(ies) as obsolete, erroneous or untrustworthy, to warn against its future use."
    },
    {
      "code" : "destroy",
      "display" : "Destroy/Delete Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to permanently erase record entry content from the system."
    },
    {
      "code" : "disclose",
      "display" : "Disclose Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to release, transfer, provision access to, or otherwise divulge record entry content."
    },
    {
      "code" : "encrypt",
      "display" : "Encrypt Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to encode record entry content in a cipher."
    },
    {
      "code" : "extract",
      "display" : "Extract Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to selectively pull out a subset of record entry content, based on explicit criteria."
    },
    {
      "code" : "link",
      "display" : "Link Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to connect related record entries."
    },
    {
      "code" : "merge",
      "display" : "Merge Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to combine or join content from two or more record entries, resulting in a single logical record entry."
    },
    {
      "code" : "originate",
      "display" : "Originate/Retain Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to: a) initiate capture of potential record content, and b) incorporate that content into the storage considered a permanent part of the health record."
    },
    {
      "code" : "pseudonymize",
      "display" : "Pseudonymize Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to remove record entry content to reduce the association between a set of identifying data and the data subject in a way that may be reversible."
    },
    {
      "code" : "reactivate",
      "display" : "Re-activate Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to recreate or restore full status to record entries previously deleted or deprecated."
    },
    {
      "code" : "receive",
      "display" : "Receive/Retain Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to a) initiate capture of data content from elsewhere, and b) incorporate that content into the storage considered a permanent part of the health record."
    },
    {
      "code" : "reidentify",
      "display" : "Re-identify Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to restore information to data that allows identification of information source and/or information subject."
    },
    {
      "code" : "unhold",
      "display" : "Remove Legal Hold Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to remove a tag or other cues for special access management had required to fulfill organizational policy under the legal doctrine of “duty to preserve”."
    },
    {
      "code" : "report",
      "display" : "Report (Output) Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to produce and deliver record entry content in a particular form and manner."
    },
    {
      "code" : "restore",
      "display" : "Restore Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to recreate record entries and their content from a previous created archive artefact."
    },
    {
      "code" : "transform",
      "display" : "Transform/Translate Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to change the form, language or code system used to represent record entry content."
    },
    {
      "code" : "transmit",
      "display" : "Transmit Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to send record entry content from one (EHR/PHR/other) system to another."
    },
    {
      "code" : "unlink",
      "display" : "Unlink Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to disconnect two or more record entries previously connected, rendering them separate (disconnected) again."
    },
    {
      "code" : "unmerge",
      "display" : "Unmerge Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to reverse a previous record entry merge operation, rendering them separate again."
    },
    {
      "code" : "verify",
      "display" : "Verify Record Lifecycle Event",
      "definition" : "Occurs when an agent causes the system to confirm compliance of data or data objects with regulations, requirements, specifications, or other imposed conditions based on organizational policy."
    }
  ]
}

```
