# Insuranceplan Plan Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Insuranceplan Plan Type**

## CodeSystem: Insuranceplan Plan Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/insuranceplan-plan-type | *Version*:1.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InsuranceplanPlanType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for Insuranceplan Plan Type. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [InsuranceplanPlanType](ValueSet-insuranceplan-plan-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "insuranceplan-plan-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/insuranceplan-plan-type",
  "version" : "1.0.0",
  "name" : "InsuranceplanPlanType",
  "title" : "Insuranceplan Plan Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for Insuranceplan Plan Type.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/insuranceplan-plan-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "platinum",
      "display" : "Platinum-QHP",
      "definition" : "Plan with highest monthly premium and lowest costs when you need care. A Qualified Health Plan with the highest monthly premiums and smallest out-of-pocket costs for the member in comparison to other metal-category plans."
    },
    {
      "code" : "gold",
      "display" : "Gold-QHP",
      "definition" : "Plan with high monthly premium and low costs when you need care. A Qualified Health Plan with the higher monthly premiums and smaller out-of-pocket costs for the member in comparison to other metal-category plans."
    },
    {
      "code" : "silver",
      "display" : "Silver-QHP",
      "definition" : "Plan with moderate monthly premium and moderate costs when you need care. A Qualified Health Plan with the lower monthly premiums and larger out-of-pocket costs for the member in comparison to other metal-category plans."
    },
    {
      "code" : "bronze",
      "display" : "Bronze-QHP",
      "definition" : "Plan with lowest monthly premium and highest costs when you need care. A Qualified Health Plan with the lowest monthly premiums and largest out-of-pocket costs for the member in comparison to other metal-category plans."
    },
    {
      "code" : "catastrophic",
      "display" : "Catastrophic-QHP",
      "definition" : "A plan with low monthly premiums and very high deductibles and are available only to those under 30 or with certain special exemptions."
    },
    {
      "code" : "lowdeductible",
      "display" : "Low Deductible",
      "definition" : "A plan that requires the insured to pay out of pocket a smaller proportion of incurred health care costs than a traditional insurance plan."
    },
    {
      "code" : "highdeductible",
      "display" : "High Deductible",
      "definition" : "A plan that requires the insured to pay out of pocket a larger proportion of incurred health care costs than a traditional insurance plan."
    },
    {
      "code" : "catastrophicplan",
      "display" : "Catastrophic Plan",
      "definition" : "A plan that requires the insured to pay out of pocket a much larger proportion of incurred health care costs than a traditional insurance plan."
    }
  ]
}

```
