# Goal category - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Goal category**

## CodeSystem: Goal category 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/goal-category | *Version*:2.0.0 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GoalCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1097 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes for grouping goals to use for filtering or presentation. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GoalCategory](ValueSet-goal-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "goal-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/goal-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1097"
    }
  ],
  "version" : "2.0.0",
  "name" : "GoalCategory",
  "title" : "Goal category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for grouping goals to use for filtering or presentation.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/goal-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "dietary",
      "display" : "Dietary",
      "definition" : "Goals related to the consumption of food and/or beverages."
    },
    {
      "code" : "safety",
      "display" : "Safety",
      "definition" : "Goals related to the personal protection of the subject."
    },
    {
      "code" : "behavioral",
      "display" : "Behavioral",
      "definition" : "Goals related to the manner in which the subject acts."
    },
    {
      "code" : "independence",
      "display" : "Independence",
      "definition" : "Goals related to living one’s life independently without help or assistance from others."
    },
    {
      "code" : "housing",
      "display" : "Housing",
      "definition" : "Goals related to the subject's place of residence."
    },
    {
      "code" : "legal",
      "display" : "Legal",
      "definition" : "Goals related to legal issues or legal involvement of the subject."
    },
    {
      "code" : "nursing",
      "display" : "Nursing",
      "definition" : "Goals related to the practice of nursing or established by nurses."
    },
    {
      "code" : "physiotherapy",
      "display" : "Physiotherapy",
      "definition" : "Goals related to the mobility and/or motor capability of the subject."
    }
  ]
}

```
