# Flag Category - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Flag Category**

## CodeSystem: Flag Category 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/flag-category | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FlagCategory |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1071 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Example list of general categories for flagged issues. (Not complete or necessarily appropriate.) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FlagCategory](ValueSet-flag-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "flag-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/flag-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1071"
    }
  ],
  "version" : "1.0.1",
  "name" : "FlagCategory",
  "title" : "Flag Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Example list of general categories for flagged issues. (Not complete or necessarily appropriate.)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/flag-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "diet",
      "display" : "Diet",
      "definition" : "Flags related to the subject's dietary needs."
    },
    {
      "code" : "drug",
      "display" : "Drug",
      "definition" : "Flags related to the subject's medications."
    },
    {
      "code" : "lab",
      "display" : "Lab",
      "definition" : "Flags related to performing laboratory tests and related processes (e.g. phlebotomy)."
    },
    {
      "code" : "admin",
      "display" : "Administrative",
      "definition" : "Flags related to administrative and financial processes."
    },
    {
      "code" : "contact",
      "display" : "Subject Contact",
      "definition" : "Flags related to coming into contact with the patient."
    },
    {
      "code" : "clinical",
      "display" : "Clinical",
      "definition" : "Flags related to the subject's clinical data."
    },
    {
      "code" : "behavioral",
      "display" : "Behavioral",
      "definition" : "Flags related to behavior."
    },
    {
      "code" : "research",
      "display" : "Research",
      "definition" : "Flags related to research."
    },
    {
      "code" : "advance-directive",
      "display" : "Advance Directive",
      "definition" : "Flags related to subject's advance directives."
    },
    {
      "code" : "safety",
      "display" : "Safety",
      "definition" : "Flags related to safety precautions."
    }
  ]
}

```
