# Example Program Reason Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Program Reason Codes**

## CodeSystem: Example Program Reason Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-programcode | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleProgramReasonCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1161 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Program Reason Span codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleProgramReasonCodes](ValueSet-ex-program-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-programcode",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-programcode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1161"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleProgramReasonCodes",
  "title" : "Example Program Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Program Reason Span codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-program-code",
  "content" : "complete",
  "concept" : [
    {
      "code" : "as",
      "display" : "Child Asthma",
      "definition" : "Child Asthma Program"
    },
    {
      "code" : "hd",
      "display" : "Hemodialysis",
      "definition" : "Hemodialysis Program."
    },
    {
      "code" : "auscr",
      "display" : "Autism Screening",
      "definition" : "Autism Screening Program."
    },
    {
      "code" : "none",
      "display" : "None",
      "definition" : "No program code applies."
    }
  ]
}

```
