# Example Diagnosis Related Group Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Diagnosis Related Group Codes**

## CodeSystem: Example Diagnosis Related Group Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleDiagnosisRelatedGroupCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1166 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes example Diagnosis Related Group codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleDiagnosisRelatedGroupCodes](ValueSet-ex-diagnosisrelatedgroup.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-diagnosisrelatedgroup",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1166"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleDiagnosisRelatedGroupCodes",
  "title" : "Example Diagnosis Related Group Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes example Diagnosis Related Group codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-diagnosisrelatedgroup",
  "content" : "complete",
  "concept" : [
    {
      "code" : "100",
      "display" : "Normal Vaginal Delivery",
      "definition" : "Normal Vaginal Delivery."
    },
    {
      "code" : "101",
      "display" : "Appendectomy - uncomplicated",
      "definition" : "Appendectomy without rupture or other complications."
    },
    {
      "code" : "300",
      "display" : "Tooth abscess",
      "definition" : "Emergency department treatment of a tooth abscess."
    },
    {
      "code" : "400",
      "display" : "Head trauma - concussion",
      "definition" : "Head trauma - concussion."
    }
  ]
}

```
