# Example Diagnosis on Admission Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Diagnosis on Admission Codes**

## CodeSystem: Example Diagnosis on Admission Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-diagnosis-on-admission | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleDiagnosisOnAdmissionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1170 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes example Diagnosis on Admission codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleDiagnosisOnAdmissionCodes](ValueSet-ex-diagnosis-on-admission.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-diagnosis-on-admission",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-diagnosis-on-admission",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1170"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleDiagnosisOnAdmissionCodes",
  "title" : "Example Diagnosis on Admission Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes example Diagnosis on Admission codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-diagnosis-on-admission",
  "content" : "complete",
  "concept" : [
    {
      "code" : "yes",
      "display" : "Yes",
      "definition" : "Diagnosis was present at time of inpatient admission."
    },
    {
      "code" : "no",
      "display" : "No",
      "definition" : "Diagnosis was not present at time of inpatient admission."
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "Not known if condition was present at the time of inpatient admission."
    }
  ]
}

```
