# FHIRDeviceStatusReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FHIRDeviceStatusReason**

## CodeSystem: FHIRDeviceStatusReason 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/device-status-reason | *Version*:1.0.0 | | |
| Draft as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FHIRDeviceStatusReason |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1082 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The availability status reason of the device. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FHIRDeviceStatusReason](ValueSet-device-status-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "device-status-reason",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/device-status-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1082"
    }
  ],
  "version" : "1.0.0",
  "name" : "FHIRDeviceStatusReason",
  "title" : "FHIRDeviceStatusReason",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The availability status reason of the device.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/device-status-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "online",
      "display" : "Online",
      "definition" : "The device is off."
    },
    {
      "code" : "paused",
      "display" : "Paused",
      "definition" : "The device is paused."
    },
    {
      "code" : "standby",
      "display" : "Standby",
      "definition" : "The device is ready but not actively operating."
    },
    {
      "code" : "offline",
      "display" : "Offline",
      "definition" : "The device is offline."
    },
    {
      "code" : "not-ready",
      "display" : "Not Ready",
      "definition" : "The device is not ready."
    },
    {
      "code" : "transduc-discon",
      "display" : "Transducer Disconnected",
      "definition" : "The device transducer is disconnected."
    },
    {
      "code" : "hw-discon",
      "display" : "Hardware Disconnected",
      "definition" : "The device hardware is disconnected."
    },
    {
      "code" : "off",
      "display" : "Off",
      "definition" : "The device is off."
    }
  ]
}

```
