# Contributor Role - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contributor Role**

## CodeSystem: Contributor Role 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contributor-role | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ContributorRole |

 
Used to code the format of the display string. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContributorRole](ValueSet-contributor-role.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contributor-role",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contributor-role",
  "version" : "1.0.0",
  "name" : "ContributorRole",
  "title" : "Contributor Role",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to code the format of the display string.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contributor-role",
  "content" : "complete",
  "concept" : [
    {
      "code" : "publisher",
      "display" : "Publisher",
      "definition" : "Entity that makes the content available for public use"
    },
    {
      "code" : "author",
      "display" : "Author/Creator",
      "definition" : "An entity primarily responsible for making the resource, often called author or creator"
    },
    {
      "code" : "reviewer",
      "display" : "Reviewer",
      "definition" : "Entity that examines the content, formally or informally, and suggests revisions or comments"
    },
    {
      "code" : "endorser",
      "display" : "Endorser",
      "definition" : "Entity that supports, approves, or advocates for the content"
    },
    {
      "code" : "editor",
      "display" : "Editor",
      "definition" : "Entity that revises or has authority to control the content"
    },
    {
      "code" : "informant",
      "display" : "Informant",
      "definition" : "Entity that supplies information"
    },
    {
      "code" : "funder",
      "display" : "Funder",
      "definition" : "Entity that supplies financial support"
    },
    {
      "code" : "recorder",
      "display" : "Recorder",
      "definition" : "Entity that entered the data into the Resource instance, if different than the author or creator of the intellectual property contained within the Resource instance"
    }
  ]
}

```
