# Consent Category Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent Category Codes**

## CodeSystem: Consent Category Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/consentcategorycodes | *Version*:1.0.1 | | |
| Active as of 2025-12-11 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConsentCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1226 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright 1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set includes sample Consent Directive Type codes, including several consent directive related LOINC codes; HL7 VALUE SET: ActConsentType(2.16.840.1.113883.1.11.19897); examples of US realm consent directive legal descriptions and references to online and/or downloadable forms such as the SSA-827 Authorization to Disclose Information to the Social Security Administration; and other anticipated consent directives related to participation in a clinical trial, medical procedures, reproductive procedures; health care directive (Living Will); advance directive, do not resuscitate (DNR); Physician Orders for Life-Sustaining Treatment (POLST) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "consentcategorycodes",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cbcc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1226"
    }
  ],
  "version" : "1.0.1",
  "name" : "ConsentCategoryCodes",
  "title" : "Consent Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-11T21:56:12-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Consent Directive Type codes, including several consent directive related LOINC codes; HL7 VALUE SET: ActConsentType(2.16.840.1.113883.1.11.19897); examples of US realm consent directive legal descriptions and references to online and/or downloadable forms such as the SSA-827 Authorization to Disclose Information to the Social Security Administration; and other anticipated consent directives related to participation in a clinical trial, medical procedures, reproductive procedures; health care directive (Living Will); advance directive, do not resuscitate (DNR); Physician Orders for Life-Sustaining Treatment (POLST)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright  1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "acd",
      "display" : "Advance Directive",
      "definition" : "Any instructions, written or given verbally by a patient in anticipation of potential need for medical treatment."
    },
    {
      "code" : "dnr",
      "display" : "Do Not Resuscitate",
      "definition" : "A legal document, signed by both the patient and their provider, stating a desire not to have CPR initiated in case of a cardiac event."
    },
    {
      "code" : "emrgonly",
      "display" : "Emergency Only Disclosure",
      "definition" : "Opt-in to disclosure of health information for emergency only consent directive. Comment: This general consent directive specifically limits disclosure of health information for purpose of emergency treatment. Additional parameters may further limit the disclosure to specific users, roles, duration, types of information, and impose uses obligations."
    },
    {
      "code" : "hcd",
      "display" : "Health Care Directive",
      "definition" : "Patient authored document communicating to patient's health care provider(s) instructions about the patient's goals, preferences, and priorities if the patient is diagnosed as being terminally ill and in a persistent vegetative state, is in a permanently unconscious condition or is otherwise unable to communicate thoe instructions."
    },
    {
      "code" : "npp",
      "display" : "Notice of Privacy Practices",
      "definition" : "Acknowledgement of custodian notice of privacy practices. Usage Notes: This type of consent directive acknowledges a custodian's notice of privacy practices including its permitted collection, access, use and disclosure of health information to users and for purposes of use specified."
    },
    {
      "code" : "polst",
      "display" : "POLST",
      "definition" : "The Physician Order for Life-Sustaining Treatment form records a person's health care wishes for end of life emergency treatment and translates them into an order by the physician. It must be reviewed and signed by both the patient and the physician, Advanced Registered Nurse Practitioner or Physician Assistant."
    },
    {
      "code" : "research",
      "display" : "Research Information Access",
      "definition" : "Consent to have healthcare information in an electronic health record accessed for research purposes."
    },
    {
      "code" : "rsdid",
      "display" : "De-identified Information Access",
      "definition" : "Consent to have de-identified healthcare information in an electronic health record that is accessed for research purposes, but without consent to re-identify the information under any circumstance."
    },
    {
      "code" : "rsreid",
      "display" : "Re-identifiable Information Access",
      "definition" : "Consent to have de-identified healthcare information in an electronic health record that is accessed for research purposes re-identified under specific circumstances outlined in the consent."
    }
  ]
}

```
