# StatisticCertaintyRating - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticCertaintyRating**

## CodeSystem: StatisticCertaintyRating 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/certainty-rating | *Version*:2.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticCertaintyRating |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1415 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The relative quality of the statistic. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticCertaintyRating](ValueSet-certainty-rating.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "certainty-rating",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/certainty-rating",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1415"
    }
  ],
  "version" : "2.0.0",
  "name" : "StatisticCertaintyRating",
  "title" : "StatisticCertaintyRating",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The relative quality of the statistic.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/certainty-rating",
  "content" : "complete",
  "concept" : [
    {
      "code" : "high",
      "display" : "High quality",
      "definition" : "High quality evidence."
    },
    {
      "code" : "moderate",
      "display" : "Moderate quality",
      "definition" : "Moderate quality evidence."
    },
    {
      "code" : "low",
      "display" : "Low quality",
      "definition" : "Low quality evidence."
    },
    {
      "code" : "very-low",
      "display" : "Very low quality",
      "definition" : "Very low quality evidence."
    },
    {
      "code" : "no-concern",
      "display" : "no serious concern",
      "definition" : "no serious concern."
    },
    {
      "code" : "serious-concern",
      "display" : "serious concern",
      "definition" : "serious concern."
    },
    {
      "code" : "very-serious-concern",
      "display" : "very serious concern",
      "definition" : "very serious concern."
    },
    {
      "code" : "extremely-serious-concern",
      "display" : "extremely serious concern",
      "definition" : "extremely serious concern."
    },
    {
      "code" : "present",
      "display" : "present",
      "definition" : "possible reason for increasing quality rating was checked and found to be present."
    },
    {
      "code" : "absent",
      "display" : "absent",
      "definition" : "possible reason for increasing quality rating was checked and found to be absent."
    },
    {
      "code" : "no-change",
      "display" : "no change to rating",
      "definition" : "no change to quality rating."
    },
    {
      "code" : "downcode1",
      "display" : "reduce rating: -1",
      "definition" : "reduce quality rating by 1."
    },
    {
      "code" : "downcode2",
      "display" : "reduce rating: -2",
      "definition" : "reduce quality rating by 2."
    },
    {
      "code" : "downcode3",
      "display" : "reduce rating: -3",
      "definition" : "reduce quality rating by 3."
    },
    {
      "code" : "upcode1",
      "display" : "increase rating: +1",
      "definition" : "increase quality rating by 1."
    },
    {
      "code" : "upcode2",
      "display" : "increase rating: +2",
      "definition" : "increase quality rating by 2."
    }
  ]
}

```
