# HL7 Terminology Home Page - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* **HL7 Terminology Home Page**

## HL7 Terminology Home Page

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ImplementationGuide/hl7.terminology | *Version*:7.0.1 |
| Active as of 2025-12-11 | *Computable Name*:HL7Terminology |

### Introduction

 This is the main entry page for access to the HL7 Terminology. This material comprises the Code Systems and Value Sets which are cited in HL7 Published artifacts (International Standards and Implemenation Guides) in a convenient browsable form. 

 As part of the HL7 approach to provide unified governance, and support consistent access to the terminology and vocabulary that has been published for many years, all of the published Code Systems and Value Sets across all of the main HL7 Product families is intended to be accessible on these pages. This includes Version 2, Version 3, CDA (base only), and FHIR. Note that the full unification of all of the terminology content of HL7 Code Systems will be an ongoing effort. Included here are also the Concept Domains and Tables, as well as Concept Maps and Naming Systems defined and published by HL7. There is an option to download the terminology along with additional components, and background information. Users may browse and download the HL7 terminology on these pages. 

#### Using This Content Layout

 The black bar on the top of the pages is the primary navigation tool. Selecting any of the named items from that bar will navigate to a page with that content on it. Each page is in a similar format for easy access to the content. Each of these pages has a selection of tabs on the page which group the content in ways that are convenient for access. 

1. **All Code Systems**lists all of the code systems published on these pages.
1. **CDA**lists the code systems (all from V3) that are used in the CDA Base Standard.
1. **FHIR**lists the code systems references by FHIR standards that are rooted at terminology.hl7.org
1. **V2**lists the code systems underlying the Version 2 Tables that list codes.
1. **V3**lists the code systems published in the Version 3 Standards (traditionally in the coremif).
1. **Unified**lists the code systems which are used across all of the HL7 Product Families, and whose coded content has been unified across all uses.
1. **External**lists the code systems which are published by organizations outside of HL7 but are referenced by, and identified in, HL7 Published Stanards.
1. **Retired**lists the code systems which were published by HL7 some time in the past, but are no longer published and have been retired from use.

### Licensing

 This THO content is made available under the CC0 designation. For more information see the [THO licensing details](license.md) page. 

### Identificaton of Versions

 The HL7 Terminology releases carry a 3-part release version identifier, in the format of Major.Minor.Build (similar to the commonly used semantic versioning scheme). For the HL7 Terminology releases, the Major number indicates a new major release, and will be updated occasionally when significant new content is added or there are substantial layout and formatting changes, or changes are being released which MAY break some backward compatibility. Upon a new major release, the Major number will be incrementd by one, and the Minor number and Build number will both be reset to zero. 

The Minor number indicates a snapshot of the current build (ci build) that has been taken and released. These releases will have internal conistency, and will consist of one to many approved changes to the HL7 terminology content. These releases will occur relatively frequently, and will be done to support various HL7 needs, and respond to requests of the HL7 community for access to changed content. Occasionally a minor release may coincide with other HL7 Standards releases for synchronization purposes. The Build number will be reset to zero on a new minor release. 

 The Build number for published releases will almost always remain at zero, unless there is some highly exceptional circumstance. This number however is incremented on the HL7 Terminology ci build page (link to 'current' in the Published Releases list), and will be incremented with every new implementation of UTG changes and subsequent rebuild of the continuous integration environment, and thus is important primarily on the continuous build pages, and helps to indicate the number of completed UTG tickets since the last published release. 

### Changes and Enhancements to the HL7 Terminology

 In order to request changes to the content on these pages, and to participate in the process, please see the information for participation and sign-up on the [HL7 Vocabulary Maintenance](https://confluence.hl7.org/display/VMAH/Vocabulary+Maintenance+at+HL7) pages. 

