# HumanActSite - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HumanActSite**

## ValueSet: HumanActSite 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/ValueSet/v3-HumanActSite | *Version*:2.0.0 |
| Retired as of 2014-03-26 | *Computable Name*:HumanActSite |
| *Other Identifiers:*OID:2.16.840.1.113883.1.11.16538 | |

 
An anatomical location on a human which can be the focus of an act. 
**OpenIssue:**This value set was approved for**deletion**in November 2008, and was deleted at release #762. Subsequently, however, it was found that this deletion caused the legacy software embedded in the RMIM Designer in Visio to fail to show appropriate options for concepts in the subject area of this value set. For that reason, the value set was**re-added in releasse 813 and DEPRECATED from general use**at the same time. This value set should be deleted as soon as it is no longer required to support of the legacy software. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansions are not generated for retired value sets

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-HumanActSite",
  "language" : "en",
  "url" : "http://terminology.hl7.org/ValueSet/v3-HumanActSite",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.1.11.16538"
    }
  ],
  "version" : "2.0.0",
  "name" : "HumanActSite",
  "title" : "HumanActSite",
  "status" : "retired",
  "experimental" : false,
  "date" : "2014-03-26",
  "description" : "An anatomical location on a human which can be the focus of an act.\r\n\r\n*OpenIssue:* This value set was approved for **deletion** in November 2008, and was deleted at release \\#762. Subsequently, however, it was found that this deletion caused the legacy software embedded in the RMIM Designer in Visio to fail to show appropriate options for concepts in the subject area of this value set. For that reason, the value set was **re-added in releasse 813 and DEPRECATED from general use** at the same time. This value set should be deleted as soon as it is no longer required to support of the legacy software.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActSite",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "_HumanActSite"
          }
        ]
      },
      {
        "valueSet" : ["http://terminology.hl7.org/ValueSet/v3-Dentition"]
      },
      {
        "valueSet" : [
          "http://terminology.hl7.org/ValueSet/v3-HumanSubstanceAdministrationSite"
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActSite",
        "concept" : [
          {
            "code" : "_HumanActSite"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActSite",
        "concept" : [
          {
            "code" : "_HumanSubstanceAdministrationSite"
          }
        ]
      }
    ]
  }
}

```
